/* gitg-application.c generated by valac 0.35.5.2-9e6c0, the Vala compiler
 * generated from gitg-application.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include "libgitg-ext/libgitg-ext.h"
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>
#include "libgitg/libgitg.h"
#include <libgitg/gitg-platform-support.h>
#include <gdk/gdk.h>
#include <libgit2-glib/ggit.h>


#define GITG_TYPE_APPLICATION (gitg_application_get_type ())
#define GITG_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_APPLICATION, GitgApplication))
#define GITG_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_APPLICATION, GitgApplicationClass))
#define GITG_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_APPLICATION))
#define GITG_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_APPLICATION))
#define GITG_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_APPLICATION, GitgApplicationClass))

typedef struct _GitgApplication GitgApplication;
typedef struct _GitgApplicationClass GitgApplicationClass;
typedef struct _GitgApplicationPrivate GitgApplicationPrivate;

#define GITG_TYPE_PREFERENCES_DIALOG (gitg_preferences_dialog_get_type ())
#define GITG_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialog))
#define GITG_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))
#define GITG_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PREFERENCES_DIALOG))
#define GITG_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PREFERENCES_DIALOG, GitgPreferencesDialogClass))

typedef struct _GitgPreferencesDialog GitgPreferencesDialog;
typedef struct _GitgPreferencesDialogClass GitgPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_HISTORY_TYPE_COMMAND_LINE (gitg_history_command_line_get_type ())
#define GITG_HISTORY_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLine))
#define GITG_HISTORY_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))
#define GITG_HISTORY_IS_COMMAND_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_IS_COMMAND_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_HISTORY_TYPE_COMMAND_LINE))
#define GITG_HISTORY_COMMAND_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_HISTORY_TYPE_COMMAND_LINE, GitgHistoryCommandLineClass))

typedef struct _GitgHistoryCommandLine GitgHistoryCommandLine;
typedef struct _GitgHistoryCommandLineClass GitgHistoryCommandLineClass;

#define GITG_TYPE_PLUGINS_ENGINE (gitg_plugins_engine_get_type ())
#define GITG_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngine))
#define GITG_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))
#define GITG_IS_PLUGINS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_IS_PLUGINS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_PLUGINS_ENGINE))
#define GITG_PLUGINS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_PLUGINS_ENGINE, GitgPluginsEngineClass))

typedef struct _GitgPluginsEngine GitgPluginsEngine;
typedef struct _GitgPluginsEngineClass GitgPluginsEngineClass;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define GITG_TYPE_WINDOW (gitg_window_get_type ())
#define GITG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_WINDOW, GitgWindow))
#define GITG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_WINDOW, GitgWindowClass))
#define GITG_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_WINDOW))
#define GITG_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_WINDOW))
#define GITG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_WINDOW, GitgWindowClass))

typedef struct _GitgWindow GitgWindow;
typedef struct _GitgWindowClass GitgWindowClass;

#define GITG_TYPE_AUTHOR_DETAILS_DIALOG (gitg_author_details_dialog_get_type ())
#define GITG_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialog))
#define GITG_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))
#define GITG_IS_AUTHOR_DETAILS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_IS_AUTHOR_DETAILS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_AUTHOR_DETAILS_DIALOG))
#define GITG_AUTHOR_DETAILS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_AUTHOR_DETAILS_DIALOG, GitgAuthorDetailsDialogClass))

typedef struct _GitgAuthorDetailsDialog GitgAuthorDetailsDialog;
typedef struct _GitgAuthorDetailsDialogClass GitgAuthorDetailsDialogClass;

#define GITG_APPLICATION_TYPE_ACCEL (gitg_application_accel_get_type ())
typedef struct _GitgApplicationAccel GitgApplicationAccel;

#define GITG_APPLICATION_TYPE_MULTI_ACCEL (gitg_application_multi_accel_get_type ())
typedef struct _GitgApplicationMultiAccel GitgApplicationMultiAccel;

#define GITG_APPLICATION_TYPE_OPTIONS (gitg_application_options_get_type ())
typedef struct _GitgApplicationOptions GitgApplicationOptions;

struct _GitgApplication {
	GtkApplication parent_instance;
	GitgApplicationPrivate * priv;
};

struct _GitgApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GitgApplicationPrivate {
	GSettings* d_state_settings;
	GitgPreferencesDialog* d_preferences;
	GtkShortcutsWindow* d_shortcuts;
};

struct _GitgApplicationAccel {
	gchar* name;
	gchar* accel;
};

struct _GitgApplicationMultiAccel {
	gchar* name;
	gchar** accels;
	gint accels_length1;
	gint _accels_size_;
};

struct _GitgApplicationOptions {
};


static gpointer gitg_application_parent_class = NULL;
static gboolean gitg_application_options_quit;
static gchar* gitg_application_options_activity;
static gboolean gitg_application_options_no_wd;
static GApplicationCommandLine* gitg_application_options_command_line;
static gboolean gitg_application_options_quit = FALSE;
static gchar* gitg_application_options_activity = NULL;
static gboolean gitg_application_options_no_wd = FALSE;
static GApplicationCommandLine* gitg_application_options_command_line = NULL;

GType gitg_application_get_type (void) G_GNUC_CONST;
GType gitg_preferences_dialog_get_type (void) G_GNUC_CONST;
#define GITG_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_APPLICATION, GitgApplicationPrivate))
enum  {
	GITG_APPLICATION_DUMMY_PROPERTY,
	GITG_APPLICATION_STATE_SETTINGS
};
static void gitg_application_on_app_new_window_activated (GitgApplication* self);
static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_about_activated (GitgApplication* self);
static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_quit_activated (GitgApplication* self);
static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_app_author_details_global_activated (GitgApplication* self);
static void _gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_preferences_activated (GitgApplication* self);
static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void gitg_application_on_shortcuts_activated (GitgApplication* self);
static void _gitg_application_on_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GitgApplication* gitg_application_new (void);
GitgApplication* gitg_application_construct (GType object_type);
static gboolean gitg_application_show_version_and_quit (void);
static GitgExtCommandLines* gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error);
static gboolean gitg_application_options_commit_activity (void);
GType gitg_history_command_line_get_type (void) G_GNUC_CONST;
GitgHistoryCommandLine* gitg_history_command_line_new (void);
GitgHistoryCommandLine* gitg_history_command_line_construct (GType object_type);
static void _vala_array_add8 (GitgExtCommandLine** * array, int* length, int* size, GitgExtCommandLine* value);
GType gitg_plugins_engine_get_type (void) G_GNUC_CONST;
GitgPluginsEngine* gitg_plugins_engine_get_default (void);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_array_add9 (GitgExtCommandLine** * array, int* length, int* size, GitgExtCommandLine* value);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
static gchar** _vala_array_dup16 (gchar** self, int length);
void gitg_plugins_engine_initialize (void);
static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
static void _vala_array_add10 (GFile** * array, int* length, int* size, GFile* value);
static void gitg_application_open_command_line (GitgApplication* self, GFile** files, int files_length1, const gchar* hint, GitgExtCommandLines* command_lines);
static void gitg_application_activate_command_line (GitgApplication* self, GitgExtCommandLines* command_lines);
static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint, GitgExtCommandLines* command_lines);
gpointer gitg_builder_load_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* id, const gchar* object);
static void ___lambda168_ (GitgApplication* self, GtkWidget* w);
static void ____lambda168__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static void ___lambda169_ (GitgApplication* self, GtkWidget* w);
static void ____lambda169__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
GType gitg_window_get_type (void) G_GNUC_CONST;
GType gitg_author_details_dialog_get_type (void) G_GNUC_CONST;
GitgAuthorDetailsDialog* gitg_author_details_dialog_show_global (GitgWindow* window);
static void gitg_application_init_error (GitgApplication* self, const gchar* msg);
static void __lambda170_ (GitgApplication* self);
static void ___lambda170__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void gitg_application_real_startup (GApplication* base);
static GType gitg_application_accel_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationAccel* gitg_application_accel_dup (const GitgApplicationAccel* self);
static void gitg_application_accel_free (GitgApplicationAccel* self);
static void gitg_application_accel_copy (const GitgApplicationAccel* self, GitgApplicationAccel* dest);
static void gitg_application_accel_destroy (GitgApplicationAccel* self);
static GType gitg_application_multi_accel_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationMultiAccel* gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_free (GitgApplicationMultiAccel* self);
static void gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self, GitgApplicationMultiAccel* dest);
static void gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self);
static void gitg_application_add_css (GitgApplication* self, const gchar* path);
static void _vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel * array, gint array_length);
static void gitg_application_real_shutdown (GApplication* base);
static void gitg_application_present_window (GitgApplication* self, const gchar* activity, GitgExtCommandLines* command_lines);
static void gitg_application_real_activate (GApplication* base);
static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file);
static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
void gitg_window_set_environment (GitgWindow* self, gchar** environment, int environment_length1);
void gitg_window_present (GitgWindow* self, const gchar* hint, GitgExtCommandLines* command_lines);
GitgWindow* gitg_window_create_new (GtkApplication* app, GitgRepository* repository, const gchar* action);
GSettings* gitg_application_get_state_settings (GitgApplication* self);
static GType gitg_application_options_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self);
static void gitg_application_options_free (GitgApplicationOptions* self);
static gchar** _vala_array_dup17 (gchar** self, int length);
static void gitg_application_finalize (GObject * obj);
static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry GITG_APPLICATION_app_entries[5] = {{"new", _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback}, {"about", _gitg_application_on_app_about_activated_gsimple_action_activate_callback}, {"quit", _gitg_application_on_app_quit_activated_gsimple_action_activate_callback}, {"author-details-global", _gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback}, {"preferences", _gitg_application_on_preferences_activated_gsimple_action_activate_callback}};
static const GActionEntry GITG_APPLICATION_shortcut_window_entries[1] = {{"shortcuts", _gitg_application_on_shortcuts_activated_gsimple_action_activate_callback}};
static const GOptionEntry GITG_APPLICATION_OPTIONS_entries[5] = {{"version", 'v', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_show_version_and_quit, N_ ("Show the application's version"), NULL}, {"activity", '\0', 0, G_OPTION_ARG_STRING, &gitg_application_options_activity, N_ ("Start gitg with a particular activity"), NULL}, {"commit", 'c', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) gitg_application_options_commit_activity, N_ ("Start gitg with the commit activity (shorthand for --activity commit)"), NULL}, {"no-wd", (gchar) 0, 0, G_OPTION_ARG_NONE, &gitg_application_options_no_wd, N_ ("Do not try to load a repository from the current working directory"), NULL}, {NULL}};

static void _gitg_application_on_app_new_window_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_new_window_activated ((GitgApplication*) self);
#line 249 "gitg-application.c"
}


static void _gitg_application_on_app_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_about_activated ((GitgApplication*) self);
#line 256 "gitg-application.c"
}


static void _gitg_application_on_app_quit_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_quit_activated ((GitgApplication*) self);
#line 263 "gitg-application.c"
}


static void _gitg_application_on_app_author_details_global_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_app_author_details_global_activated ((GitgApplication*) self);
#line 270 "gitg-application.c"
}


static void _gitg_application_on_preferences_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 309 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_preferences_activated ((GitgApplication*) self);
#line 277 "gitg-application.c"
}


static void _gitg_application_on_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 318 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_on_shortcuts_activated ((GitgApplication*) self);
#line 284 "gitg-application.c"
}


GitgApplication* gitg_application_construct (GType object_type) {
	GitgApplication * self = NULL;
#line 34 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) g_object_new (object_type, "application-id", "org.gnome.gitg", "flags", (G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE) | G_APPLICATION_SEND_ENVIRONMENT, NULL);
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return self;
#line 294 "gitg-application.c"
}


GitgApplication* gitg_application_new (void) {
#line 32 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return gitg_application_construct (GITG_TYPE_APPLICATION);
#line 301 "gitg-application.c"
}


static gboolean gitg_application_show_version_and_quit (void) {
	gboolean result = FALSE;
	FILE* _tmp0_;
	const gchar* _tmp1_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = stdout;
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_get_application_name ();
#line 84 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	fprintf (_tmp0_, "%s %s\n", _tmp1_, VERSION);
#line 88 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_options_quit = TRUE;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = TRUE;
#line 89 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 321 "gitg-application.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return self ? g_object_ref (self) : NULL;
#line 328 "gitg-application.c"
}


static void _vala_array_add8 (GitgExtCommandLine** * array, int* length, int* size, GitgExtCommandLine* value) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
#line 339 "gitg-application.c"
	}
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 345 "gitg-application.c"
}


static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self) {
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return g_boxed_copy (peas_plugin_info_get_type (), self);
#line 352 "gitg-application.c"
}


static gpointer __vala_PeasPluginInfo_copy0 (gpointer self) {
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
#line 359 "gitg-application.c"
}


static void _vala_array_add9 (GitgExtCommandLine** * array, int* length, int* size, GitgExtCommandLine* value) {
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*array = g_renew (GitgExtCommandLine*, *array, (*size) + 1);
#line 370 "gitg-application.c"
	}
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 376 "gitg-application.c"
}


static void _vala_PeasPluginInfo_free (PeasPluginInfo* self) {
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_boxed_free (peas_plugin_info_get_type (), self);
#line 383 "gitg-application.c"
}


static GitgExtCommandLines* gitg_application_parse_command_line (GitgApplication* self, gchar*** argv, int* argv_length1, GError** error) {
	GitgExtCommandLines* result = NULL;
	GOptionContext* ctx;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	GitgExtCommandLine** cmdexts;
	GitgExtCommandLine** _tmp4_;
	gint cmdexts_length1;
	gint _cmdexts_size_;
	GitgHistoryCommandLine* historycmd;
	GitgHistoryCommandLine* _tmp5_;
	GitgExtCommandLine** _tmp6_;
	gint _tmp6__length1;
	GitgHistoryCommandLine* _tmp7_;
	GitgExtCommandLine* _tmp8_;
	GOptionContext* _tmp9_;
	GitgHistoryCommandLine* _tmp10_;
	GOptionGroup* _tmp11_;
	GitgPluginsEngine* engine;
	GitgPluginsEngine* _tmp12_;
	GitgPluginsEngine* _tmp13_;
	GList* _tmp14_;
	GOptionContext* _tmp29_;
	GitgExtCommandLines* ret;
	GitgExtCommandLine** _tmp30_;
	gint _tmp30__length1;
	GitgExtCommandLines* _tmp31_;
	GitgExtCommandLines* _tmp32_;
	GError * _inner_error_ = NULL;
#line 92 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_option_context_new (_ ("- Git repository viewer"));
#line 94 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	ctx = _tmp0_;
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = ctx;
#line 96 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_option_context_add_main_entries (_tmp1_, GITG_APPLICATION_OPTIONS_entries, GETTEXT_PACKAGE);
#line 97 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = ctx;
#line 97 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = gtk_get_option_group (TRUE);
#line 97 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_option_context_add_group (_tmp2_, _tmp3_);
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_new0 (GitgExtCommandLine*, 0 + 1);
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cmdexts = _tmp4_;
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cmdexts_length1 = 0;
#line 99 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_cmdexts_size_ = cmdexts_length1;
#line 101 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp5_ = gitg_history_command_line_new ();
#line 101 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	historycmd = _tmp5_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6_ = cmdexts;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6__length1 = cmdexts_length1;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_ = historycmd;
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_ = _g_object_ref0 ((GitgExtCommandLine*) _tmp7_);
#line 102 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_vala_array_add8 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp8_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = ctx;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp10_ = historycmd;
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp11_ = gitg_ext_command_line_get_option_group ((GitgExtCommandLine*) _tmp10_);
#line 104 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_option_context_add_group (_tmp9_, _tmp11_);
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp12_ = gitg_plugins_engine_get_default ();
#line 107 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	engine = _tmp12_;
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp13_ = engine;
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp14_ = peas_engine_get_plugin_list ((PeasEngine*) _tmp13_);
#line 472 "gitg-application.c"
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		info_collection = _tmp14_;
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
#line 480 "gitg-application.c"
			PeasPluginInfo* _tmp15_;
			PeasPluginInfo* info = NULL;
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_tmp15_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) info_it->data);
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			info = _tmp15_;
#line 487 "gitg-application.c"
			{
				PeasPluginInfo* _tmp16_;
				const gchar* _tmp17_;
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp16_ = info;
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp17_ = peas_plugin_info_get_external_data (_tmp16_, "CommandLine");
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (_tmp17_ != NULL) {
#line 497 "gitg-application.c"
					GitgExtCommandLine* ext;
					GitgPluginsEngine* _tmp18_;
					PeasPluginInfo* _tmp19_;
					PeasExtension* _tmp20_;
					GitgExtCommandLine* _tmp21_;
					GitgExtCommandLine* _tmp22_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp18_ = engine;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp19_ = info;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp20_ = peas_engine_create_extension ((PeasEngine*) _tmp18_, _tmp19_, GITG_EXT_TYPE_COMMAND_LINE, NULL);
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GITG_EXT_TYPE_COMMAND_LINE) ? ((GitgExtCommandLine*) _tmp20_) : NULL;
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					if (_tmp21_ == NULL) {
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_g_object_unref0 (_tmp20_);
#line 516 "gitg-application.c"
					}
#line 113 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					ext = _tmp21_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp22_ = ext;
#line 115 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					if (_tmp22_ != NULL) {
#line 524 "gitg-application.c"
						GitgExtCommandLine** _tmp23_;
						gint _tmp23__length1;
						GitgExtCommandLine* _tmp24_;
						GitgExtCommandLine* _tmp25_;
						GOptionContext* _tmp26_;
						GitgExtCommandLine* _tmp27_;
						GOptionGroup* _tmp28_;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp23_ = cmdexts;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp23__length1 = cmdexts_length1;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp24_ = ext;
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp25_ = _g_object_ref0 (_tmp24_);
#line 117 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_vala_array_add9 (&cmdexts, &cmdexts_length1, &_cmdexts_size_, _tmp25_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp26_ = ctx;
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp27_ = ext;
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						_tmp28_ = gitg_ext_command_line_get_option_group (_tmp27_);
#line 118 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
						g_option_context_add_group (_tmp26_, _tmp28_);
#line 550 "gitg-application.c"
					}
#line 111 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (ext);
#line 554 "gitg-application.c"
				}
#line 109 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				__vala_PeasPluginInfo_free0 (info);
#line 558 "gitg-application.c"
			}
		}
	}
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp29_ = ctx;
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_option_context_parse (_tmp29_, argv_length1, argv, &_inner_error_);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (_inner_error_->domain == G_OPTION_ERROR) {
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			g_propagate_error (error, _inner_error_);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (historycmd);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			return NULL;
#line 582 "gitg-application.c"
		} else {
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (engine);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_object_unref0 (historycmd);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_option_context_free0 (ctx);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			g_clear_error (&_inner_error_);
#line 123 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			return NULL;
#line 598 "gitg-application.c"
		}
	}
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp30_ = cmdexts;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp30__length1 = cmdexts_length1;
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp31_ = gitg_ext_command_lines_new (_tmp30_, _tmp30__length1);
#line 125 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	ret = _tmp31_;
#line 126 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp32_ = ret;
#line 126 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_ext_command_lines_parse_finished (_tmp32_);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = ret;
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (engine);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (historycmd);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cmdexts = (_vala_array_free (cmdexts, cmdexts_length1, (GDestroyNotify) g_object_unref), NULL);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_option_context_free0 (ctx);
#line 128 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 625 "gitg-application.c"
}


static gchar** _vala_array_dup16 (gchar** self, int length) {
	gchar** result;
	int i;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = g_new0 (gchar*, length + 1);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	for (i = 0; i < length; i++) {
#line 636 "gitg-application.c"
		gchar* _tmp0_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp0_ = g_strdup (self[i]);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result[i] = _tmp0_;
#line 642 "gitg-application.c"
	}
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 646 "gitg-application.c"
}


static gboolean gitg_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	GitgApplication * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	gchar** cp;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint cp_length1;
	gint _cp_size_;
	gchar** argv;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint argv_length1;
	gint _argv_size_;
	gboolean _tmp9_;
	gint _tmp10_ = 0;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
#line 131 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = *arguments;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = _vala_array_length (*arguments);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup16 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = _tmp0__length1;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cp = _tmp1_;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cp_length1 = _tmp1__length1;
#line 134 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_cp_size_ = cp_length1;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = cp;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2__length1 = cp_length1;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	argv = _tmp2_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp2__length1;
#line 135 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 137 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_plugins_engine_initialize ();
#line 698 "gitg-application.c"
	{
		GitgExtCommandLines* _tmp3_;
		GitgExtCommandLines* _tmp4_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = _tmp3_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (_tmp4_);
#line 142 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "gitg-application.c"
			goto __catch42_g_error;
		}
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = stderr;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp6_ = e;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_->message;
#line 146 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		fprintf (_tmp5_, "Failed to parse options: %s\n", _tmp7_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 1;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 745 "gitg-application.c"
		}
#line 148 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return result;
#line 749 "gitg-application.c"
	}
	__finally42:
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "gitg-application.c"
		gboolean _tmp8_ = FALSE;
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return _tmp8_;
#line 764 "gitg-application.c"
	}
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = gitg_application_options_quit;
#line 151 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp9_) {
#line 153 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_vala_exit_status = 0;
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result = TRUE;
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (exit_status) {
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			*exit_status = _vala_exit_status;
#line 780 "gitg-application.c"
		}
#line 154 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return result;
#line 784 "gitg-application.c"
	}
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp11_ = G_APPLICATION_CLASS (gitg_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), arguments, &_tmp10_);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_vala_exit_status = _tmp10_;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = _tmp11_;
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	cp = (_vala_array_free (cp, cp_length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (exit_status) {
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*exit_status = _vala_exit_status;
#line 798 "gitg-application.c"
	}
#line 157 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 802 "gitg-application.c"
}


static void _vala_array_add10 (GFile** * array, int* length, int* size, GFile* value) {
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if ((*length) == (*size)) {
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 813 "gitg-application.c"
	}
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[(*length)++] = value;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*array)[*length] = NULL;
#line 819 "gitg-application.c"
}


static gint gitg_application_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	GitgApplication * self;
	gint result = 0;
	gchar** arguments;
	GApplicationCommandLine* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint arguments_length1;
	gint _arguments_size_;
	gchar** argv;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint argv_length1;
	gint _argv_size_;
	GitgExtCommandLines* command_lines = NULL;
	gboolean _tmp11_;
	GApplicationCommandLine* _tmp12_;
	gboolean _tmp13_;
	GApplicationCommandLine* tmpcmd;
	GApplicationCommandLine* _tmp16_;
	GApplicationCommandLine* _tmp17_;
	GApplicationCommandLine* _tmp18_;
	GApplicationCommandLine* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GApplicationCommandLine* _tmp34_;
	GApplicationCommandLine* _tmp35_;
	GError * _inner_error_ = NULL;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 160 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (cmd != NULL, 0);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = cmd;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	arguments = _tmp2_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	arguments_length1 = _tmp1_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_arguments_size_ = arguments_length1;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = arguments;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3__length1 = arguments_length1;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	argv = _tmp3_;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	argv_length1 = _tmp3__length1;
#line 163 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_argv_size_ = argv_length1;
#line 875 "gitg-application.c"
	{
		GitgExtCommandLines* _tmp4_;
		GitgExtCommandLines* _tmp5_;
		GitgExtCommandLines* _tmp6_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_application_parse_command_line (self, &argv, &argv_length1, &_inner_error_);
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = _tmp5_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 886 "gitg-application.c"
			goto __catch43_g_error;
		}
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp6_ = _tmp4_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = NULL;
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 168 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		command_lines = _tmp6_;
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (_tmp4_);
#line 899 "gitg-application.c"
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = cmd;
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp8_ = e;
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp9_ = _tmp8_->message;
#line 172 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_application_command_line_printerr (_tmp7_, "option parsing failed: %s\n", _tmp9_);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result = 1;
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 173 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return result;
#line 930 "gitg-application.c"
	}
	__finally43:
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 935 "gitg-application.c"
		gint _tmp10_ = 0;
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 166 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return _tmp10_;
#line 947 "gitg-application.c"
	}
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp11_ = gitg_application_options_quit;
#line 176 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp11_) {
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result = 0;
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (command_lines);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 178 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return result;
#line 961 "gitg-application.c"
	}
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp12_ = cmd;
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp13_ = g_application_command_line_get_is_remote (_tmp12_);
#line 181 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (!_tmp13_) {
#line 969 "gitg-application.c"
		GApplicationCommandLine* _tmp14_;
		GApplicationCommandLine* _tmp15_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp14_ = cmd;
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (gitg_application_options_command_line);
#line 183 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_options_command_line = _tmp15_;
#line 980 "gitg-application.c"
	}
#line 186 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp16_ = gitg_application_options_command_line;
#line 186 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 186 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	tmpcmd = _tmp17_;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp18_ = cmd;
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 187 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp19_;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp20_ = argv;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp20__length1 = argv_length1;
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp20__length1 > 1) {
#line 1002 "gitg-application.c"
		GFile** files;
		gchar** _tmp21_;
		gint _tmp21__length1;
		GFile** _tmp22_;
		gint files_length1;
		gint _files_size_;
		gint _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar** _tmp25_;
		gint _tmp25__length1;
		GFile** _tmp30_;
		gint _tmp30__length1;
		const gchar* _tmp31_;
		GitgExtCommandLines* _tmp32_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp21_ = argv;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp21__length1 = argv_length1;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp22_ = g_new0 (GFile*, (_tmp21__length1 - 1) + 1);
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		files = _tmp22_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		files_length1 = _tmp21__length1 - 1;
#line 191 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_files_size_ = files_length1;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		files_length1 = 0;
#line 192 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp23_ = files_length1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp24_ = argv;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp24__length1 = argv_length1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp25_ = argv;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp25__length1 = argv_length1;
#line 1042 "gitg-application.c"
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			arg_collection = _tmp24_ + 1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			arg_collection_length1 = _tmp25__length1 - 1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			for (arg_it = 0; arg_it < (_tmp25__length1 - 1); arg_it = arg_it + 1) {
#line 1054 "gitg-application.c"
				gchar* _tmp26_;
				gchar* arg = NULL;
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp26_ = g_strdup (arg_collection[arg_it]);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				arg = _tmp26_;
#line 1061 "gitg-application.c"
				{
					GFile** _tmp27_;
					gint _tmp27__length1;
					const gchar* _tmp28_;
					GFile* _tmp29_;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp27_ = files;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp27__length1 = files_length1;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp28_ = arg;
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp29_ = g_file_new_for_commandline_arg (_tmp28_);
#line 196 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_vala_array_add10 (&files, &files_length1, &_files_size_, _tmp29_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_free0 (arg);
#line 1079 "gitg-application.c"
				}
			}
		}
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp30_ = files;
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp30__length1 = files_length1;
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp31_ = gitg_application_options_activity;
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp32_ = command_lines;
#line 199 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_open_command_line (self, _tmp30_, _tmp30__length1, _tmp31_, _tmp32_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1095 "gitg-application.c"
	} else {
		GitgExtCommandLines* _tmp33_;
#line 203 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp33_ = command_lines;
#line 203 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_activate_command_line (self, _tmp33_);
#line 1102 "gitg-application.c"
	}
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp34_ = tmpcmd;
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (gitg_application_options_command_line);
#line 206 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_options_command_line = _tmp35_;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = 1;
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (tmpcmd);
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (command_lines);
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 207 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 1122 "gitg-application.c"
}


static void gitg_application_on_app_new_window_activated (GitgApplication* self) {
#line 210 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 212 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_new_window (self, NULL, NULL, NULL);
#line 1131 "gitg-application.c"
}


static void gitg_application_on_app_about_activated (GitgApplication* self) {
	gchar** artists;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint artists_length1;
	gint _artists_size_;
	gchar** authors;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint authors_length1;
	gint _authors_size_;
	gchar* copyright;
	gchar* _tmp5_;
	gchar* comments;
	gchar* _tmp6_;
	GList* wnds;
	GList* _tmp7_;
	GtkWindow* _tmp8_ = NULL;
	GList* _tmp9_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("Jakub Steiner <jimmac@gmail.com>");
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_[0] = _tmp0_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	artists = _tmp1_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	artists_length1 = 1;
#line 217 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_artists_size_ = artists_length1;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_strdup ("Jesse van den Kieboom <jessevdk@gnome.org>");
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup ("Ignacio Casal Quinteiro <icq@gnome.org>");
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_[0] = _tmp2_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_[1] = _tmp3_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	authors = _tmp4_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	authors_length1 = 2;
#line 218 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_authors_size_ = authors_length1;
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_strdup ("Copyright \xc2\xa9 2012 Jesse van den Kieboom");
#line 221 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	copyright = _tmp5_;
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6_ = g_strdup (_ ("gitg is a Git repository viewer for gtk+/GNOME"));
#line 222 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	comments = _tmp6_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_ = gtk_application_get_windows ((GtkApplication*) self);
#line 224 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	wnds = _tmp7_;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = wnds;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp9_ != NULL) {
#line 1207 "gitg-application.c"
		GList* _tmp10_;
		gconstpointer _tmp11_;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp10_ = wnds;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp11_ = _tmp10_->data;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp8_ = (GtkWindow*) _tmp11_;
#line 1216 "gitg-application.c"
	} else {
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp8_ = NULL;
#line 1220 "gitg-application.c"
	}
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp12_ = artists;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp12__length1 = artists_length1;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp13_ = authors;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp13__length1 = authors_length1;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp14_ = copyright;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp15_ = comments;
#line 226 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_show_about_dialog (_tmp8_, "artists", _tmp12_, "authors", _tmp13_, "copyright", _tmp14_, "comments", _tmp15_, "translator-credits", _ ("translator-credits"), "version", VERSION, "website", PACKAGE_URL, "website-label", _ ("gitg homepage"), "logo-icon-name", PACKAGE_NAME, "license-type", GTK_LICENSE_GPL_2_0, NULL);
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (comments);
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (copyright);
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 215 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 1244 "gitg-application.c"
}


static void gitg_application_on_app_quit_activated (GitgApplication* self) {
	GList* wnds;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 241 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	wnds = _tmp1_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = wnds;
#line 1263 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		window_collection = _tmp2_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1271 "gitg-application.c"
			GtkWindow* window = NULL;
#line 243 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			window = (GtkWindow*) window_it->data;
#line 1275 "gitg-application.c"
			{
				GtkWindow* _tmp3_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp3_ = window;
#line 245 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1282 "gitg-application.c"
			}
		}
	}
#line 239 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_list_free0 (wnds);
#line 1288 "gitg-application.c"
}


static void ___lambda168_ (GitgApplication* self, GtkWidget* w) {
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (w != NULL);
#line 259 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 259 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self->priv->d_preferences = NULL;
#line 1299 "gitg-application.c"
}


static void ____lambda168__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	___lambda168_ ((GitgApplication*) self, _sender);
#line 1306 "gitg-application.c"
}


static void gitg_application_on_preferences_activated (GitgApplication* self) {
	GList* wnds;
	GList* _tmp0_;
	GitgPreferencesDialog* _tmp1_;
	GList* _tmp4_;
	GitgPreferencesDialog* _tmp8_;
#line 249 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 251 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	wnds = _tmp0_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_preferences;
#line 254 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 1326 "gitg-application.c"
		gpointer _tmp2_;
		GitgPreferencesDialog* _tmp3_;
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp2_ = gitg_builder_load_object (GITG_TYPE_PREFERENCES_DIALOG, (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-preferences.ui", "preferences");
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (self->priv->d_preferences);
#line 256 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		self->priv->d_preferences = (GitgPreferencesDialog*) _tmp2_;
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = self->priv->d_preferences;
#line 258 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda168__gtk_widget_destroy, self, 0);
#line 1339 "gitg-application.c"
	}
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = wnds;
#line 263 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp4_ != NULL) {
#line 1345 "gitg-application.c"
		GitgPreferencesDialog* _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = self->priv->d_preferences;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp6_ = wnds;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_->data;
#line 265 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp7_);
#line 1357 "gitg-application.c"
	}
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_ = self->priv->d_preferences;
#line 268 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_window_present ((GtkWindow*) _tmp8_);
#line 1363 "gitg-application.c"
}


static void ___lambda169_ (GitgApplication* self, GtkWidget* w) {
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (w != NULL);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_shortcuts);
#line 283 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self->priv->d_shortcuts = NULL;
#line 1374 "gitg-application.c"
}


static void ____lambda169__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	___lambda169_ ((GitgApplication*) self, _sender);
#line 1381 "gitg-application.c"
}


static void gitg_application_on_shortcuts_activated (GitgApplication* self) {
	GList* wnds;
	GList* _tmp0_;
	GtkShortcutsWindow* _tmp1_;
	GList* _tmp4_;
	GtkShortcutsWindow* _tmp8_;
#line 271 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 275 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	wnds = _tmp0_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = self->priv->d_shortcuts;
#line 278 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 1401 "gitg-application.c"
		gpointer _tmp2_;
		GtkShortcutsWindow* _tmp3_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp2_ = gitg_builder_load_object (GTK_TYPE_SHORTCUTS_WINDOW, (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-shortcuts.ui", "shortcuts-gitg");
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (self->priv->d_shortcuts);
#line 280 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		self->priv->d_shortcuts = (GtkShortcutsWindow*) _tmp2_;
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = self->priv->d_shortcuts;
#line 282 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_signal_connect_object ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda169__gtk_widget_destroy, self, 0);
#line 1414 "gitg-application.c"
	}
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = wnds;
#line 287 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp4_ != NULL) {
#line 1420 "gitg-application.c"
		GtkShortcutsWindow* _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = self->priv->d_shortcuts;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp6_ = wnds;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_->data;
#line 289 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) _tmp7_);
#line 1432 "gitg-application.c"
	}
#line 292 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_ = self->priv->d_shortcuts;
#line 292 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_window_present ((GtkWindow*) _tmp8_);
#line 1438 "gitg-application.c"
}


static void gitg_application_on_app_author_details_global_activated (GitgApplication* self) {
	GList* wnds;
	GList* _tmp0_;
	GitgWindow* window;
	GList* _tmp1_;
	GitgWindow* _tmp6_;
	GitgAuthorDetailsDialog* _tmp7_;
	GitgAuthorDetailsDialog* _tmp8_;
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 298 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 298 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	wnds = _tmp0_;
#line 299 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	window = NULL;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = wnds;
#line 301 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp1_ != NULL) {
#line 1462 "gitg-application.c"
		GList* _tmp2_;
		gconstpointer _tmp3_;
		GtkWindow* _tmp4_;
		GitgWindow* _tmp5_;
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp2_ = wnds;
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = _tmp2_->data;
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = (GtkWindow*) _tmp3_;
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_WINDOW) ? ((GitgWindow*) _tmp4_) : NULL);
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (window);
#line 303 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		window = _tmp5_;
#line 1479 "gitg-application.c"
	}
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6_ = window;
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_ = gitg_author_details_dialog_show_global (_tmp6_);
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_ = _tmp7_;
#line 306 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (_tmp8_);
#line 296 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (window);
#line 1491 "gitg-application.c"
}


static void __lambda170_ (GitgApplication* self) {
#line 346 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_main_quit ();
#line 1498 "gitg-application.c"
}


static void ___lambda170__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 346 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	__lambda170_ ((GitgApplication*) self);
#line 1505 "gitg-application.c"
}


static void gitg_application_init_error (GitgApplication* self, const gchar* msg) {
	GtkMessageDialog* dlg;
	const gchar* _tmp0_;
	GtkMessageDialog* _tmp1_;
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (msg != NULL);
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = msg;
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp0_);
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_object_ref_sink (_tmp1_);
#line 337 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	dlg = _tmp1_;
#line 344 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_object_set ((GtkWindow*) dlg, "window-position", GTK_WIN_POS_CENTER, NULL);
#line 346 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_signal_connect_object ((GtkDialog*) dlg, "response", (GCallback) ___lambda170__gtk_dialog_response, self, 0);
#line 347 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_widget_show ((GtkWidget*) dlg);
#line 335 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (dlg);
#line 1533 "gitg-application.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1434 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1435 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = self;
#line 1435 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1545 "gitg-application.c"
}


static void _vala_GitgApplicationMultiAccel_array_free (GitgApplicationMultiAccel * array, gint array_length) {
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (array != NULL) {
#line 1552 "gitg-application.c"
		int i;
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			gitg_application_multi_accel_destroy (&array[i]);
#line 1558 "gitg-application.c"
		}
	}
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_free (array);
#line 1563 "gitg-application.c"
}


static void gitg_application_real_startup (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
#line 384 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	static const GitgApplicationAccel single_accels[] = {{"app.new", "<Primary>N"}, {"app.quit", "<Primary>Q"}, {"app.help", "F1"}, {"win.search", "<Primary>F"}, {"win.gear-menu", "F10"}, {"win.open-repository", "<Primary>O"}, {"win.close", "<Primary>W"}};
#line 1573 "gitg-application.c"
	GitgApplicationMultiAccel* multi_accels;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	GitgApplicationMultiAccel _tmp8_ = {0};
	GitgApplicationMultiAccel* _tmp9_;
	gint multi_accels_length1;
	gint _multi_accels_size_;
	GitgApplicationMultiAccel* _tmp17_;
	gint _tmp17__length1;
	GtkSettings* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkIconTheme* theme;
	GtkIconTheme* _tmp32_;
	GtkIconTheme* _tmp33_;
	GtkIconTheme* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GError * _inner_error_ = NULL;
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 352 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 354 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_platform_support_application_support_prepare_startup ();
#line 1606 "gitg-application.c"
	{
#line 358 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_init (&_inner_error_);
#line 358 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1612 "gitg-application.c"
			goto __catch44_g_error;
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		e = _inner_error_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_inner_error_ = NULL;
#line 362 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp0_ = e;
#line 362 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (g_error_matches (_tmp0_, GITG_INIT_ERROR, GITG_INIT_ERROR_THREADS_UNSAFE)) {
#line 1629 "gitg-application.c"
			gchar* errmsg;
			gchar* _tmp1_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_tmp1_ = g_strdup (_ ("We are terribly sorry, but gitg requires libgit2 (a library on which g" \
"itg depends) to be compiled with threading support.\n" \
"\n" \
"If you manually compiled libgit2, then please configure libgit2 with -" \
"DTHREADSAFE:BOOL=ON.\n" \
"\n" \
"Otherwise, report a bug in your distributions' bug reporting system fo" \
"r providing libgit2 without threading support."));
#line 364 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			errmsg = _tmp1_;
#line 366 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			gitg_application_init_error (self, errmsg);
#line 367 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			g_error ("gitg-application.vala:367: %s", errmsg);
#line 362 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_g_free0 (errmsg);
#line 1642 "gitg-application.c"
		}
#line 370 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_error_free0 (e);
#line 370 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return;
#line 1648 "gitg-application.c"
	}
	__finally44:
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_clear_error (&_inner_error_);
#line 356 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return;
#line 1659 "gitg-application.c"
	}
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = g_settings_new ("org.gnome.gitg.state.window");
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 374 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self->priv->d_state_settings = _tmp2_;
#line 375 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = self->priv->d_state_settings;
#line 375 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_settings_delay (_tmp3_);
#line 378 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_app_entries, G_N_ELEMENTS (GITG_APPLICATION_app_entries), self);
#line 381 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GITG_APPLICATION_shortcut_window_entries, G_N_ELEMENTS (GITG_APPLICATION_shortcut_window_entries), self);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = g_strdup ("win.reload");
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp5_ = g_strdup ("<Primary>R");
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6_ = g_strdup ("F5");
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_ = g_new0 (gchar*, 2 + 1);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_[0] = _tmp5_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_[1] = _tmp6_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	memset (&_tmp8_, 0, sizeof (GitgApplicationMultiAccel));
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp8_.name);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_.name = _tmp4_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_.accels = (_vala_array_free (_tmp8_.accels, _tmp8_.accels_length1, (GDestroyNotify) g_free), NULL);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_.accels = _tmp7_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_.accels_length1 = 2;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_._accels_size_ = _tmp8_.accels_length1;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = g_new0 (GitgApplicationMultiAccel, 1);
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_[0] = _tmp8_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	multi_accels = _tmp9_;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	multi_accels_length1 = 1;
#line 395 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_multi_accels_size_ = multi_accels_length1;
#line 1711 "gitg-application.c"
	{
		GitgApplicationAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		accel_collection = single_accels;
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		accel_collection_length1 = G_N_ELEMENTS (single_accels);
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (accel_it = 0; accel_it < G_N_ELEMENTS (single_accels); accel_it = accel_it + 1) {
#line 1723 "gitg-application.c"
			GitgApplicationAccel accel = {0};
#line 402 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			accel = accel_collection[accel_it];
#line 1727 "gitg-application.c"
			{
				GitgApplicationAccel _tmp10_;
				const gchar* _tmp11_;
				GitgApplicationAccel _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp10_ = accel;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp11_ = _tmp10_.name;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp12_ = accel;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp13_ = _tmp12_.accel;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp15_ = g_new0 (gchar*, 1 + 1);
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp15_[0] = _tmp14_;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp16_ = _tmp15_;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp16__length1 = 1;
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp11_, _tmp16_);
#line 404 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
#line 1759 "gitg-application.c"
			}
		}
	}
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp17_ = multi_accels;
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp17__length1 = multi_accels_length1;
#line 1767 "gitg-application.c"
	{
		GitgApplicationMultiAccel* accel_collection = NULL;
		gint accel_collection_length1 = 0;
		gint _accel_collection_size_ = 0;
		gint accel_it = 0;
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		accel_collection = _tmp17_;
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		accel_collection_length1 = _tmp17__length1;
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (accel_it = 0; accel_it < _tmp17__length1; accel_it = accel_it + 1) {
#line 1779 "gitg-application.c"
			GitgApplicationMultiAccel _tmp18_ = {0};
			GitgApplicationMultiAccel accel = {0};
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			gitg_application_multi_accel_copy (&accel_collection[accel_it], &_tmp18_);
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			accel = _tmp18_;
#line 1786 "gitg-application.c"
			{
				GitgApplicationMultiAccel _tmp19_;
				const gchar* _tmp20_;
				GitgApplicationMultiAccel _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp19_ = accel;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp20_ = _tmp19_.name;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp21_ = accel;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp22_ = _tmp21_.accels;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp22__length1 = _tmp21_.accels_length1;
#line 409 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				gtk_application_set_accels_for_action ((GtkApplication*) self, _tmp20_, _tmp22_);
#line 407 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				gitg_application_multi_accel_destroy (&accel);
#line 1807 "gitg-application.c"
			}
		}
	}
#line 412 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp23_ = gtk_settings_get_default ();
#line 412 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_object_get (_tmp23_, "gtk-shell-shows-app-menu", &_tmp24_, NULL);
#line 412 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp25_ = _tmp24_;
#line 412 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp25_) {
#line 1819 "gitg-application.c"
		GMenuModel* menu;
		gpointer _tmp26_;
		GMenuModel* _tmp27_;
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp26_ = gitg_builder_load_object (g_menu_model_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, "ui/gitg-menus.ui", "app-menu");
#line 414 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		menu = (GMenuModel*) _tmp26_;
#line 416 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp27_ = menu;
#line 416 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		if (_tmp27_ != NULL) {
#line 1831 "gitg-application.c"
			GMenuModel* _tmp28_;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_tmp28_ = menu;
#line 418 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			gtk_application_set_app_menu ((GtkApplication*) self, _tmp28_);
#line 1837 "gitg-application.c"
		}
#line 412 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_object_unref0 (menu);
#line 1841 "gitg-application.c"
	}
#line 422 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_add_css (self, "style.css");
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp29_ = string_to_string (PLATFORM_NAME);
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp30_ = g_strconcat ("style-", _tmp29_, ".css", NULL);
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp31_ = _tmp30_;
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_add_css (self, _tmp31_);
#line 423 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp31_);
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp32_ = gtk_icon_theme_get_default ();
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp33_ = _g_object_ref0 (_tmp32_);
#line 425 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	theme = _tmp33_;
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp34_ = theme;
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp35_ = gitg_platform_support_get_data_dir ();
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp36_ = _tmp35_;
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp37_ = g_build_filename (_tmp36_, "icons", NULL);
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp38_ = _tmp37_;
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gtk_icon_theme_prepend_search_path (_tmp34_, _tmp38_);
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp38_);
#line 426 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (_tmp36_);
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (theme);
#line 350 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	multi_accels = (_vala_GitgApplicationMultiAccel_array_free (multi_accels, multi_accels_length1), NULL);
#line 1881 "gitg-application.c"
}


static void gitg_application_add_css (GitgApplication* self, const gchar* path) {
	GtkCssProvider* provider;
	const gchar* _tmp0_;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* _tmp2_;
#line 429 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 429 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (path != NULL);
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = path;
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = gitg_resource_load_css (_tmp0_);
#line 431 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	provider = _tmp1_;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = provider;
#line 433 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp2_ != NULL) {
#line 1904 "gitg-application.c"
		GdkScreen* _tmp3_;
		GtkCssProvider* _tmp4_;
#line 435 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = gdk_screen_get_default ();
#line 435 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = provider;
#line 435 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) 600);
#line 1913 "gitg-application.c"
	}
#line 429 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (provider);
#line 1917 "gitg-application.c"
}


static void gitg_application_real_shutdown (GApplication* base) {
	GitgApplication * self;
	GSettings* _tmp0_;
#line 441 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 443 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 443 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_settings_apply (_tmp0_);
#line 444 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1932 "gitg-application.c"
}


static void gitg_application_activate_command_line (GitgApplication* self, GitgExtCommandLines* command_lines) {
	gboolean _tmp0_;
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 447 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (command_lines != NULL);
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gitg_application_options_no_wd;
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp0_) {
#line 1946 "gitg-application.c"
		const gchar* _tmp1_;
		GitgExtCommandLines* _tmp2_;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp1_ = gitg_application_options_activity;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp2_ = command_lines;
#line 451 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self, _tmp1_, _tmp2_);
#line 1955 "gitg-application.c"
	} else {
		gchar* wd;
		GApplicationCommandLine* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFile** _tmp8_;
		GFile** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GitgExtCommandLines* _tmp12_;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp3_ = gitg_application_options_command_line;
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = g_application_command_line_get_cwd (_tmp3_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 456 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		wd = _tmp5_;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp6_ = wd;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = g_file_new_for_path (_tmp6_);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp8_ = g_new0 (GFile*, 1 + 1);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp8_[0] = _tmp7_;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp9_ = _tmp8_;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp9__length1 = 1;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp10_ = gitg_application_options_activity;
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_application_open ((GApplication*) self, _tmp9_, 1, _tmp10_);
#line 458 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
#line 459 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp11_ = gitg_application_options_activity;
#line 459 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp12_ = command_lines;
#line 459 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_present_window (self, _tmp11_, _tmp12_);
#line 449 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_g_free0 (wd);
#line 2003 "gitg-application.c"
	}
}


static void gitg_application_real_activate (GApplication* base) {
	GitgApplication * self;
#line 463 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 465 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_present_window (self, NULL, NULL);
#line 466 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_APPLICATION_CLASS (gitg_application_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 2016 "gitg-application.c"
}


static GitgWindow* gitg_application_find_window_for_file (GitgApplication* self, GFile* file) {
	GitgWindow* result = NULL;
	GList* _tmp0_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 469 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 2029 "gitg-application.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		window_collection = _tmp0_;
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 2037 "gitg-application.c"
			GtkWindow* _tmp1_;
			GtkWindow* window = NULL;
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_tmp1_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			window = _tmp1_;
#line 2044 "gitg-application.c"
			{
				GitgWindow* wnd;
				GtkWindow* _tmp2_;
				GitgWindow* _tmp3_;
				GitgWindow* _tmp4_;
				GitgRepository* _tmp5_;
				GitgRepository* _tmp6_;
				GitgRepository* _tmp7_;
				gboolean _tmp8_;
				GitgWindow* _tmp9_;
				GitgRepository* _tmp10_;
				GitgRepository* _tmp11_;
				GitgRepository* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
#line 473 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp2_ = window;
#line 473 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GITG_TYPE_WINDOW) ? ((GitgWindow*) _tmp2_) : NULL);
#line 473 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				wnd = _tmp3_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp4_ = wnd;
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp5_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp4_);
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp6_ = _tmp5_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp7_ = _tmp6_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp8_ = _tmp7_ == NULL;
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp7_);
#line 475 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (_tmp8_) {
#line 477 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (wnd);
#line 477 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 477 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					continue;
#line 2089 "gitg-application.c"
				}
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp9_ = wnd;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp10_ = gitg_ext_application_get_repository ((GitgExtApplication*) _tmp9_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp11_ = _tmp10_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp12_ = _tmp11_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp13_ = ggit_repository_get_location ((GgitRepository*) _tmp12_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp14_ = _tmp13_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp15_ = file;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp17_ = _tmp16_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp14_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (_tmp12_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (_tmp17_) {
#line 482 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					result = wnd;
#line 482 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 482 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					return result;
#line 2121 "gitg-application.c"
				}
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (wnd);
#line 471 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 2127 "gitg-application.c"
			}
		}
	}
#line 486 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = NULL;
#line 486 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 2135 "gitg-application.c"
}


static void gitg_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	GitgApplication * self;
	GFile** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = (GitgApplication*) base;
#line 489 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (hint != NULL);
#line 491 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = files;
#line 491 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = files_length1;
#line 491 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = hint;
#line 491 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_open_command_line (self, _tmp0_, _tmp0__length1, _tmp1_, NULL);
#line 2156 "gitg-application.c"
}


static void gitg_application_open_command_line (GitgApplication* self, GFile** files, int files_length1, const gchar* hint, GitgExtCommandLines* command_lines) {
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GError * _inner_error_ = NULL;
#line 495 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = files;
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0__length1 = files_length1;
#line 497 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp0__length1 == 0) {
#line 499 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return;
#line 2176 "gitg-application.c"
	}
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = files;
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1__length1 = files_length1;
#line 2182 "gitg-application.c"
	{
		GFile** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		f_collection = _tmp1_;
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		f_collection_length1 = _tmp1__length1;
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		for (f_it = 0; f_it < _tmp1__length1; f_it = f_it + 1) {
#line 2194 "gitg-application.c"
			GFile* _tmp2_;
			GFile* f = NULL;
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			_tmp2_ = _g_object_ref0 (f_collection[f_it]);
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
			f = _tmp2_;
#line 2201 "gitg-application.c"
			{
				GFile* resolved = NULL;
				GitgWindow* window;
				GFile* _tmp7_;
				GitgWindow* _tmp8_;
				GitgWindow* _tmp9_;
				GitgRepository* repo = NULL;
				GitgRepository* _tmp21_;
				const gchar* _tmp22_;
				GitgExtCommandLines* _tmp23_;
				{
					GFile* _tmp3_;
					GFile* _tmp4_;
					GFile* _tmp5_;
					GFile* _tmp6_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp4_ = f;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp5_ = ggit_repository_discover (_tmp4_, &_inner_error_);
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp3_ = _tmp5_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2225 "gitg-application.c"
						goto __catch45_g_error;
					}
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp6_ = _tmp3_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp3_ = NULL;
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 510 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					resolved = _tmp6_;
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (_tmp3_);
#line 2238 "gitg-application.c"
				}
				goto __finally45;
				__catch45_g_error:
				{
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 512 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					continue;
#line 2253 "gitg-application.c"
				}
				__finally45:
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 508 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					return;
#line 2268 "gitg-application.c"
				}
#line 515 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp7_ = resolved;
#line 515 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp8_ = gitg_application_find_window_for_file (self, _tmp7_);
#line 515 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				window = _tmp8_;
#line 517 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp9_ = window;
#line 517 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (_tmp9_ != NULL) {
#line 2280 "gitg-application.c"
					GitgWindow* _tmp10_;
					GApplicationCommandLine* _tmp11_;
					gchar** _tmp12_;
					gchar** _tmp13_;
					GitgWindow* _tmp14_;
					const gchar* _tmp15_;
					GitgExtCommandLines* _tmp16_;
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp10_ = window;
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp11_ = gitg_application_options_command_line;
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp13_ = _tmp12_ = g_application_command_line_get_environ (_tmp11_);
#line 520 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					gitg_window_set_environment (_tmp10_, _tmp13_, _vala_array_length (_tmp12_));
#line 521 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp14_ = window;
#line 521 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp15_ = hint;
#line 521 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp16_ = command_lines;
#line 521 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					gitg_window_present (_tmp14_, _tmp15_, _tmp16_);
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 522 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					continue;
#line 2312 "gitg-application.c"
				}
				{
					GitgRepository* _tmp17_;
					GFile* _tmp18_;
					GitgRepository* _tmp19_;
					GitgRepository* _tmp20_;
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp18_ = resolved;
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp19_ = gitg_repository_new (_tmp18_, NULL, &_inner_error_);
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp17_ = _tmp19_;
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2327 "gitg-application.c"
						goto __catch46_g_error;
					}
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp20_ = _tmp17_;
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_tmp17_ = NULL;
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 530 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					repo = _tmp20_;
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (_tmp17_);
#line 2340 "gitg-application.c"
				}
				goto __finally46;
				__catch46_g_error:
				{
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_inner_error_ = NULL;
#line 532 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 532 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 532 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 532 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 532 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					continue;
#line 2359 "gitg-application.c"
				}
				__finally46:
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (repo);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (window);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (resolved);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					_g_object_unref0 (f);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					g_clear_error (&_inner_error_);
#line 528 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
					return;
#line 2378 "gitg-application.c"
				}
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp21_ = repo;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp22_ = hint;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_tmp23_ = command_lines;
#line 535 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				gitg_application_new_window (self, _tmp21_, _tmp22_, _tmp23_);
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (repo);
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (window);
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (resolved);
#line 503 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
				_g_object_unref0 (f);
#line 2396 "gitg-application.c"
			}
		}
	}
}


static void gitg_application_new_window (GitgApplication* self, GitgRepository* repo, const gchar* hint, GitgExtCommandLines* command_lines) {
	GitgWindow* window;
	GitgRepository* _tmp0_;
	const gchar* _tmp1_;
	GitgWindow* _tmp2_;
	GitgWindow* _tmp3_;
	const gchar* _tmp8_;
	GitgExtCommandLines* _tmp9_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 541 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = repo;
#line 541 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = hint;
#line 541 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = gitg_window_create_new ((GtkApplication*) self, _tmp0_, _tmp1_);
#line 541 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	window = _tmp2_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = window;
#line 543 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp3_ != NULL) {
#line 2425 "gitg-application.c"
		GitgWindow* _tmp4_;
		GApplicationCommandLine* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp4_ = window;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp5_ = gitg_application_options_command_line;
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp7_ = _tmp6_ = g_application_command_line_get_environ (_tmp5_);
#line 545 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_window_set_environment (_tmp4_, _tmp7_, _vala_array_length (_tmp6_));
#line 2438 "gitg-application.c"
	}
#line 548 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp8_ = hint;
#line 548 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = command_lines;
#line 548 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_present_window (self, _tmp8_, _tmp9_);
#line 539 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (window);
#line 2448 "gitg-application.c"
}


static void gitg_application_present_window (GitgApplication* self, const gchar* activity, GitgExtCommandLines* command_lines) {
	GList* windows;
	GList* _tmp0_;
	GList* _tmp1_;
	GitgWindow* w;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GitgWindow* _tmp5_;
	GitgWindow* _tmp6_;
	GApplicationCommandLine* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	GitgWindow* _tmp10_;
	const gchar* _tmp11_;
	GitgExtCommandLines* _tmp12_;
#line 551 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_if_fail (self != NULL);
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
#line 557 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	windows = _tmp0_;
#line 559 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = windows;
#line 559 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	if (_tmp1_ == NULL) {
#line 561 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		gitg_application_new_window (self, NULL, NULL, NULL);
#line 562 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		return;
#line 2482 "gitg-application.c"
	}
#line 565 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = windows;
#line 565 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_list_first (_tmp2_);
#line 565 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp4_ = _tmp3_->data;
#line 565 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp4_, GITG_TYPE_WINDOW, GitgWindow));
#line 565 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	w = _tmp5_;
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp6_ = w;
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp7_ = gitg_application_options_command_line;
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp9_ = _tmp8_ = g_application_command_line_get_environ (_tmp7_);
#line 567 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_window_set_environment (_tmp6_, _tmp9_, _vala_array_length (_tmp8_));
#line 568 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp10_ = w;
#line 568 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp11_ = activity;
#line 568 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp12_ = command_lines;
#line 568 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_window_present (_tmp10_, _tmp11_, _tmp12_);
#line 551 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (w);
#line 2512 "gitg-application.c"
}


GSettings* gitg_application_get_state_settings (GitgApplication* self) {
	GSettings* result;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = self->priv->d_state_settings;
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = _tmp1_;
#line 29 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 2530 "gitg-application.c"
}


static gboolean gitg_application_options_commit_activity (void) {
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("commit");
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 50 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = TRUE;
#line 51 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 2547 "gitg-application.c"
}


static GitgApplicationOptions* gitg_application_options_dup (const GitgApplicationOptions* self) {
	GitgApplicationOptions* dup;
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationOptions, 1);
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	memcpy (dup, self, sizeof (GitgApplicationOptions));
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return dup;
#line 2559 "gitg-application.c"
}


static void gitg_application_options_free (GitgApplicationOptions* self) {
#line 40 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2566 "gitg-application.c"
}


static GType gitg_application_options_get_type (void) {
	static volatile gsize gitg_application_options_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_options_type_id__volatile)) {
		GType gitg_application_options_type_id;
		gitg_application_options_type_id = g_boxed_type_register_static ("GitgApplicationOptions", (GBoxedCopyFunc) gitg_application_options_dup, (GBoxedFreeFunc) gitg_application_options_free);
		g_once_init_leave (&gitg_application_options_type_id__volatile, gitg_application_options_type_id);
	}
	return gitg_application_options_type_id__volatile;
}


static void gitg_application_accel_copy (const GitgApplicationAccel* self, GitgApplicationAccel* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = (*self).name;
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).name);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).name = _tmp1_;
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = (*self).accel;
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).accel);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).accel = _tmp3_;
#line 2602 "gitg-application.c"
}


static void gitg_application_accel_destroy (GitgApplicationAccel* self) {
#line 325 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).name);
#line 326 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).accel);
#line 2611 "gitg-application.c"
}


static GitgApplicationAccel* gitg_application_accel_dup (const GitgApplicationAccel* self) {
	GitgApplicationAccel* dup;
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationAccel, 1);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_accel_copy (self, dup);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return dup;
#line 2623 "gitg-application.c"
}


static void gitg_application_accel_free (GitgApplicationAccel* self) {
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_accel_destroy (self);
#line 323 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2632 "gitg-application.c"
}


static GType gitg_application_accel_get_type (void) {
	static volatile gsize gitg_application_accel_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_accel_type_id__volatile)) {
		GType gitg_application_accel_type_id;
		gitg_application_accel_type_id = g_boxed_type_register_static ("GitgApplicationAccel", (GBoxedCopyFunc) gitg_application_accel_dup, (GBoxedFreeFunc) gitg_application_accel_free);
		g_once_init_leave (&gitg_application_accel_type_id__volatile, gitg_application_accel_type_id);
	}
	return gitg_application_accel_type_id__volatile;
}


static gchar** _vala_array_dup17 (gchar** self, int length) {
	gchar** result;
	int i;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	result = g_new0 (gchar*, length + 1);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	for (i = 0; i < length; i++) {
#line 2654 "gitg-application.c"
		gchar* _tmp0_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		_tmp0_ = g_strdup (self[i]);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		result[i] = _tmp0_;
#line 2660 "gitg-application.c"
	}
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return result;
#line 2664 "gitg-application.c"
}


static void gitg_application_multi_accel_copy (const GitgApplicationMultiAccel* self, GitgApplicationMultiAccel* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = (*self).name;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*dest).name);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).name = _tmp1_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2_ = (*self).accels;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp2__length1 = (*self).accels_length1;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup17 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp3__length1 = _tmp2__length1;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).accels = (_vala_array_free ((*dest).accels, (*dest).accels_length1, (GDestroyNotify) g_free), NULL);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).accels = _tmp3_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest).accels_length1 = _tmp3__length1;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*dest)._accels_size_ = (*dest).accels_length1;
#line 2699 "gitg-application.c"
}


static void gitg_application_multi_accel_destroy (GitgApplicationMultiAccel* self) {
#line 331 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 ((*self).name);
#line 332 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	(*self).accels = (_vala_array_free ((*self).accels, (*self).accels_length1, (GDestroyNotify) g_free), NULL);
#line 2708 "gitg-application.c"
}


static GitgApplicationMultiAccel* gitg_application_multi_accel_dup (const GitgApplicationMultiAccel* self) {
	GitgApplicationMultiAccel* dup;
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	dup = g_new0 (GitgApplicationMultiAccel, 1);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_multi_accel_copy (self, dup);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	return dup;
#line 2720 "gitg-application.c"
}


static void gitg_application_multi_accel_free (GitgApplicationMultiAccel* self) {
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_multi_accel_destroy (self);
#line 329 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_free (self);
#line 2729 "gitg-application.c"
}


static GType gitg_application_multi_accel_get_type (void) {
	static volatile gsize gitg_application_multi_accel_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_multi_accel_type_id__volatile)) {
		GType gitg_application_multi_accel_type_id;
		gitg_application_multi_accel_type_id = g_boxed_type_register_static ("GitgApplicationMultiAccel", (GBoxedCopyFunc) gitg_application_multi_accel_dup, (GBoxedFreeFunc) gitg_application_multi_accel_free);
		g_once_init_leave (&gitg_application_multi_accel_type_id__volatile, gitg_application_multi_accel_type_id);
	}
	return gitg_application_multi_accel_type_id__volatile;
}


static void gitg_application_class_init (GitgApplicationClass * klass) {
	gchar* _tmp0_;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_type_class_add_private (klass, sizeof (GitgApplicationPrivate));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->local_command_line = gitg_application_real_local_command_line;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->command_line = gitg_application_real_command_line;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->startup = gitg_application_real_startup;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->shutdown = gitg_application_real_shutdown;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->activate = gitg_application_real_activate;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	((GApplicationClass *) klass)->open = gitg_application_real_open;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_application_get_property;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_application_finalize;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_APPLICATION_STATE_SETTINGS, g_param_spec_object ("state-settings", "state-settings", "state-settings", g_settings_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 79 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_tmp0_ = g_strdup ("");
#line 79 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_free0 (gitg_application_options_activity);
#line 79 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	gitg_application_options_activity = _tmp0_;
#line 2774 "gitg-application.c"
}


static void gitg_application_instance_init (GitgApplication * self) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self->priv = GITG_APPLICATION_GET_PRIVATE (self);
#line 2781 "gitg-application.c"
}


static void gitg_application_finalize (GObject * obj) {
	GitgApplication * self;
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_APPLICATION, GitgApplication);
#line 25 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_state_settings);
#line 71 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_preferences);
#line 74 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	_g_object_unref0 (self->priv->d_shortcuts);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	G_OBJECT_CLASS (gitg_application_parent_class)->finalize (obj);
#line 2797 "gitg-application.c"
}


GType gitg_application_get_type (void) {
	static volatile gsize gitg_application_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgApplication), 0, (GInstanceInitFunc) gitg_application_instance_init, NULL };
		GType gitg_application_type_id;
		gitg_application_type_id = g_type_register_static (gtk_application_get_type (), "GitgApplication", &g_define_type_info, 0);
		g_once_init_leave (&gitg_application_type_id__volatile, gitg_application_type_id);
	}
	return gitg_application_type_id__volatile;
}


static void _vala_gitg_application_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_APPLICATION, GitgApplication);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
	switch (property_id) {
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		case GITG_APPLICATION_STATE_SETTINGS:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		g_value_take_object (value, gitg_application_get_state_settings (self));
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		break;
#line 2824 "gitg-application.c"
		default:
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 23 "/home/mcatanzaro/Projects/GNOME/gitg/gitg/gitg-application.vala"
		break;
#line 2830 "gitg-application.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



