/* gnome-sudoku.c generated by valac 0.35.7.24-0448, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
	GameMode current_game_mode;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda26_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation);
static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
static void sudoku_display_unpause_button (Sudoku* self);
static void sudoku_display_pause_button (Sudoku* self);
static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda21_ (Block1Data* _data1_, gint response_id);
static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void sudoku_tick_cb (Sudoku* self);
static void sudoku_show_game_view (Sudoku* self);
static void sudoku_set_headerbar_title (Sudoku* self);
static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda16_ (Sudoku* self);
static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda17_ (Sudoku* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (Block2Data* _data2_, gint response_id);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda20_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda25_ (Sudoku* self);
static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[14] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the possible values for each cell"), NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 256 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 263 "gnome-sudoku.c"
}


static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_create_game_cb ((Sudoku*) self);
#line 270 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 277 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 284 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 291 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 298 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 305 "gnome-sudoku.c"
}


static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_play_custom_game_cb ((Sudoku*) self);
#line 312 "gnome-sudoku.c"
}


static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_toggle_pause_cb ((Sudoku*) self);
#line 319 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 326 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 333 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 340 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 347 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 367 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 374 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	GVariantDict* _tmp3_;
	gboolean _tmp4_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 395 "gnome-sudoku.c"
		FILE* _tmp2_;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 405 "gnome-sudoku.c"
	}
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 415 "gnome-sudoku.c"
	}
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 421 "gnome-sudoku.c"
}


static void __lambda26_ (Sudoku* self) {
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->view;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_ != NULL) {
#line 432 "gnome-sudoku.c"
		GameMode _tmp2_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->current_game_mode;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_ == GAME_MODE_PLAY;
#line 438 "gnome-sudoku.c"
	} else {
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = FALSE;
#line 442 "gnome-sudoku.c"
	}
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 446 "gnome-sudoku.c"
		SudokuView* _tmp3_;
		GSettings* _tmp4_;
		gboolean _tmp5_;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->view;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->settings;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = g_settings_get_boolean (_tmp4_, "show-warnings");
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp3_, _tmp5_);
#line 458 "gnome-sudoku.c"
	}
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda26_ ((Sudoku*) self);
#line 466 "gnome-sudoku.c"
}


static void __lambda27_ (Sudoku* self) {
	SudokuView* _tmp0_;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 476 "gnome-sudoku.c"
		SudokuView* _tmp1_;
		GSettings* _tmp2_;
		gboolean _tmp3_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
#line 488 "gnome-sudoku.c"
	}
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda27_ ((Sudoku*) self);
#line 496 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 503 "gnome-sudoku.c"
}


static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_size_allocate_cb ((Sudoku*) self, allocation);
#line 510 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 519 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_;
	GAction* action;
	GSettings* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* highlighter_action;
	GSettings* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GtkCssProvider* css_provider;
	GtkCssProvider* _tmp30_;
	GtkCssProvider* _tmp31_;
	GdkScreen* _tmp32_;
	GtkCssProvider* _tmp33_;
	GtkBuilder* builder;
	GtkBuilder* _tmp34_;
	GtkBuilder* _tmp35_;
	GObject* _tmp36_;
	GtkApplicationWindow* _tmp37_;
	GtkApplicationWindow* _tmp38_;
	GtkApplicationWindow* _tmp39_;
	GtkApplicationWindow* _tmp40_;
	GSettings* _tmp41_;
	gint _tmp42_;
	GSettings* _tmp43_;
	gint _tmp44_;
	GSettings* _tmp45_;
	gboolean _tmp46_;
	GtkApplicationWindow* _tmp48_;
	GtkBuilder* _tmp49_;
	GObject* _tmp50_;
	GtkHeaderBar* _tmp51_;
	GtkBuilder* _tmp52_;
	GObject* _tmp53_;
	GtkStack* _tmp54_;
	GtkBuilder* _tmp55_;
	GObject* _tmp56_;
	GtkBox* _tmp57_;
	GtkBuilder* _tmp58_;
	GObject* _tmp59_;
	GtkBox* _tmp60_;
	GtkBuilder* _tmp61_;
	GObject* _tmp62_;
	GtkButton* _tmp63_;
	GtkBuilder* _tmp64_;
	GObject* _tmp65_;
	GtkLabel* _tmp66_;
	GtkBuilder* _tmp67_;
	GObject* _tmp68_;
	GtkImage* _tmp69_;
	GtkBuilder* _tmp70_;
	GObject* _tmp71_;
	GtkButton* _tmp72_;
	GtkBuilder* _tmp73_;
	GObject* _tmp74_;
	GtkButton* _tmp75_;
	GtkBuilder* _tmp76_;
	GObject* _tmp77_;
	GtkLabel* _tmp78_;
	GAction* _tmp79_;
	GSimpleAction* _tmp80_;
	GAction* _tmp81_;
	GSimpleAction* _tmp82_;
	GAction* _tmp83_;
	GSimpleAction* _tmp84_;
	GAction* _tmp85_;
	GSimpleAction* _tmp86_;
	GAction* _tmp87_;
	GSimpleAction* _tmp88_;
	GAction* _tmp89_;
	GSimpleAction* _tmp90_;
	GAction* _tmp91_;
	GSimpleAction* _tmp92_;
	GAction* _tmp93_;
	GSimpleAction* _tmp94_;
	GtkHeaderBar* _tmp95_;
	GtkApplicationWindow* _tmp96_;
	GtkHeaderBar* _tmp97_;
	SudokuSaver* _tmp98_;
	SudokuGame* savegame;
	SudokuSaver* _tmp99_;
	SudokuGame* _tmp100_;
	SudokuGame* _tmp101_;
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = action;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda26__g_object_notify, self, 0);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = action;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->settings;
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	highlighter_action = _tmp6_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = highlighter_action;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda27__g_object_notify, self, 0);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = highlighter_action;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>n");
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>p");
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>q");
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary>r");
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("<Primary>z");
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = g_strdup ("<Primary><Shift>z");
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_[0] = _tmp24_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26__length1 = 1;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = g_strdup ("F1");
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_[0] = _tmp27_;
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = _tmp28_;
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29__length1 = 1;
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gtk_css_provider_new ();
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp30_;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = css_provider;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_css_provider_load_from_resource (_tmp31_, "/org/gnome/sudoku/ui/gnome-sudoku.css");
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = gdk_screen_get_default ();
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = css_provider;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp34_;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = builder;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "sudoku_app");
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp37_;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->window;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "size-allocate", (GCallback) _sudoku_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->window;
#line 159 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->window;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = self->priv->settings;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = self->priv->settings;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->settings;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp46_) {
#line 832 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp47_;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp47_ = self->priv->window;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 838 "gnome-sudoku.c"
	}
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = self->priv->window;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "headerbar");
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 166 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp51_;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "main_stack");
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_stack_get_type (), GtkStack));
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp54_;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "game_box");
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp57_;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "undo_redo_box");
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_box_get_type (), GtkBox));
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp60_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = builder;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "back_button");
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp63_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = builder;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "clock_label");
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_label_get_type (), GtkLabel));
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_label = _tmp66_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = builder;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = gtk_builder_get_object (_tmp67_, "clock_image");
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_image_get_type (), GtkImage));
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_image = _tmp69_;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = builder;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = gtk_builder_get_object (_tmp70_, "play_custom_game_button");
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_button_get_type (), GtkButton));
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_button = _tmp72_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp73_ = builder;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "play_pause_button");
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_button_get_type (), GtkButton));
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_button = _tmp75_;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp76_ = builder;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp77_ = gtk_builder_get_object (_tmp76_, "play_pause_label");
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_label_get_type (), GtkLabel));
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_label = _tmp78_;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp79_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, g_simple_action_get_type (), GSimpleAction));
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp80_;
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp81_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, g_simple_action_get_type (), GSimpleAction));
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp82_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, g_simple_action_get_type (), GSimpleAction));
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->new_game_action = _tmp84_;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, g_simple_action_get_type (), GSimpleAction));
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp86_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp87_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, g_simple_action_get_type (), GSimpleAction));
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp88_;
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp89_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, g_simple_action_get_type (), GSimpleAction));
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp90_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp91_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, g_simple_action_get_type (), GSimpleAction));
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->pause_action = _tmp92_;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp93_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, g_simple_action_get_type (), GSimpleAction));
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_action = _tmp94_;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp95_ = self->priv->headerbar;
#line 186 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_show_close_button (_tmp95_, TRUE);
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp96_ = self->priv->window;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp97_ = self->priv->headerbar;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_titlebar ((GtkWindow*) _tmp96_, (GtkWidget*) _tmp97_);
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp98_ = sudoku_saver_new ();
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp98_;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp99_ = self->priv->saver;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp100_ = sudoku_saver_get_savedgame (_tmp99_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp100_;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp101_ = savegame;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp101_ != NULL) {
#line 1034 "gnome-sudoku.c"
		SudokuGame* _tmp102_;
		SudokuBoard* _tmp103_;
		DifficultyCategory _tmp104_;
		DifficultyCategory _tmp105_;
		SudokuGame* _tmp115_;
		SudokuBoard* _tmp116_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp102_ = savegame;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp103_ = _tmp102_->board;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp104_ = sudoku_board_get_difficulty_category (_tmp103_);
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp105_ = _tmp104_;
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp105_ == DIFFICULTY_CATEGORY_CUSTOM) {
#line 1051 "gnome-sudoku.c"
			GameMode _tmp106_ = 0;
			SudokuGame* _tmp107_;
			SudokuBoard* _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			SudokuGame* _tmp111_;
			SudokuBoard* _tmp112_;
			gint _tmp113_;
			gint _tmp114_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp107_ = savegame;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp108_ = _tmp107_->board;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp109_ = sudoku_board_get_filled (_tmp108_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp110_ = _tmp109_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp111_ = savegame;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp112_ = _tmp111_->board;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp113_ = sudoku_board_get_fixed (_tmp112_);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp114_ = _tmp113_;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			if (_tmp110_ == _tmp114_) {
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp106_ = GAME_MODE_CREATE;
#line 1081 "gnome-sudoku.c"
			} else {
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp106_ = GAME_MODE_PLAY;
#line 1085 "gnome-sudoku.c"
			}
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			self->priv->current_game_mode = _tmp106_;
#line 1089 "gnome-sudoku.c"
		}
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp115_ = savegame;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp116_ = _tmp115_->board;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp116_);
#line 1097 "gnome-sudoku.c"
	} else {
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1101 "gnome-sudoku.c"
	}
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (highlighter_action);
#line 120 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1113 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_;
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1126 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_;
	GSettings* _tmp22_;
	gint _tmp23_;
	GSettings* _tmp24_;
	gint _tmp25_;
	GSettings* _tmp26_;
	gboolean _tmp27_;
	GError * _inner_error_ = NULL;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 208 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1146 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp10_ = FALSE;
		SudokuGame* _tmp11_;
		gboolean _tmp12_;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = sudoku_game_is_empty (_tmp2_);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp3_) {
#line 1159 "gnome-sudoku.c"
			SudokuGame* _tmp4_;
			SudokuBoard* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp4_ = self->priv->game;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = _tmp4_->board;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = sudoku_board_get_complete (_tmp5_);
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = _tmp6_;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp7_;
#line 1174 "gnome-sudoku.c"
		} else {
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1178 "gnome-sudoku.c"
		}
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1182 "gnome-sudoku.c"
			SudokuSaver* _tmp8_;
			SudokuGame* _tmp9_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = self->priv->saver;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->game;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp8_, _tmp9_);
#line 1191 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->game;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = sudoku_game_is_empty (_tmp11_);
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp12_) {
#line 1199 "gnome-sudoku.c"
			SudokuSaver* _tmp13_;
			SudokuGame* _tmp14_;
			SudokuGame* _tmp15_;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->saver;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_saver_get_savedgame (_tmp13_);
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = _tmp14_;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = _tmp15_ != NULL;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp15_);
#line 1213 "gnome-sudoku.c"
		} else {
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = FALSE;
#line 1217 "gnome-sudoku.c"
		}
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp10_) {
#line 1221 "gnome-sudoku.c"
			GFile* file;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			GFile* _tmp18_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savegame_file ();
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = g_file_new_for_path (_tmp17_);
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp18_;
#line 1234 "gnome-sudoku.c"
			{
				GFile* _tmp19_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp19_ = file;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp19_, NULL, &_inner_error_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1243 "gnome-sudoku.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_;
				const gchar* _tmp21_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp20_ = e;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = _tmp20_->message;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:223: Failed to delete saved game: %s", _tmp21_);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1265 "gnome-sudoku.c"
			}
			__finally0:
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1278 "gnome-sudoku.c"
			}
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1282 "gnome-sudoku.c"
		}
	}
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->settings;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->window_width;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp22_, "window-width", _tmp23_);
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_height;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-height", _tmp25_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->is_maximized;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp26_, "window-is-maximized", _tmp27_);
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1305 "gnome-sudoku.c"
}


static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkApplicationWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (allocation != NULL);
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->is_maximized;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = TRUE;
#line 1325 "gnome-sudoku.c"
	} else {
		gboolean _tmp2_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->is_tiled;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_;
#line 1332 "gnome-sudoku.c"
	}
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1338 "gnome-sudoku.c"
	}
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_width = _tmp4_;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_height = _tmp5_;
#line 1348 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	GdkEventWindowState* _tmp4_;
	GdkWindowState _tmp5_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1368 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 246 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1377 "gnome-sudoku.c"
	}
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = event;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 248 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1385 "gnome-sudoku.c"
		GdkEventWindowState* _tmp6_;
		GdkWindowState _tmp7_;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = event;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1394 "gnome-sudoku.c"
	}
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1400 "gnome-sudoku.c"
}


static void sudoku_paused_changed_cb (Sudoku* self) {
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SudokuView* _tmp19_;
#line 253 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1419 "gnome-sudoku.c"
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_display_unpause_button (self);
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->clear_action;
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->undo_action;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 260 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->redo_action;
#line 260 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp5_, FALSE);
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->new_game_action;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp6_, FALSE);
#line 1442 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp7_;
		gdouble _tmp8_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = sudoku_game_get_total_time_played (_tmp7_);
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp8_ > ((gdouble) 0)) {
#line 1452 "gnome-sudoku.c"
			GSimpleAction* _tmp9_;
			SudokuGame* _tmp10_;
			gboolean _tmp11_;
			GSimpleAction* _tmp12_;
			SudokuGame* _tmp13_;
			gboolean _tmp14_;
			GSimpleAction* _tmp15_;
			SudokuGame* _tmp16_;
			gboolean _tmp17_;
			GSimpleAction* _tmp18_;
#line 265 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_display_pause_button (self);
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->clear_action;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = self->priv->undo_action;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->game;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_game_is_undostack_null (_tmp13_);
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->redo_action;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = self->priv->game;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = sudoku_game_is_redostack_null (_tmp16_);
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp15_, !_tmp17_);
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = self->priv->new_game_action;
#line 269 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp18_, TRUE);
#line 1493 "gnome-sudoku.c"
		}
	}
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = self->priv->view;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp19_);
#line 1500 "gnome-sudoku.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1509 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1518 "gnome-sudoku.c"
		Sudoku* self;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->dialog);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1528 "gnome-sudoku.c"
	}
}


static void ____lambda21_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
	GtkMessageDialog* _tmp3_;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 298 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 298 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1543 "gnome-sudoku.c"
		SudokuGame* _tmp1_;
		SudokuBoard* _tmp2_;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->board;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp2_);
#line 1552 "gnome-sudoku.c"
	}
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _data1_->dialog;
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1558 "gnome-sudoku.c"
}


static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	____lambda21_ (self, response_id);
#line 1565 "gnome-sudoku.c"
}


static void sudoku_play_custom_game_cb (Sudoku* self) {
	gint solutions;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->board;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_board_count_solutions_limited (_tmp1_);
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	solutions = _tmp2_;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = solutions;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp3_ == 1) {
#line 1589 "gnome-sudoku.c"
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_->board;
#line 279 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp5_);
#line 1598 "gnome-sudoku.c"
	} else {
		gint _tmp6_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = solutions;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp6_ == 0) {
#line 1605 "gnome-sudoku.c"
			gchar* error_str;
			gchar* _tmp7_;
			GtkMessageDialog* dialog;
			GtkApplicationWindow* _tmp8_;
			const gchar* _tmp9_;
			GtkMessageDialog* _tmp10_;
			GtkMessageDialog* _tmp11_;
			GtkMessageDialog* _tmp12_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered is not a valid Sudoku."), _ ("Please enter a valid puzzle."));
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			error_str = _tmp7_;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = self->priv->window;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = error_str;
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp9_);
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp10_);
#line 284 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			dialog = _tmp10_;
#line 286 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = dialog;
#line 286 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_run ((GtkDialog*) _tmp11_);
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = dialog;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp12_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (dialog);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (error_str);
#line 1640 "gnome-sudoku.c"
		} else {
			Block1Data* _data1_;
			gchar* warning_str;
			gchar* _tmp13_;
			GtkApplicationWindow* _tmp14_;
			const gchar* _tmp15_;
			GtkMessageDialog* _tmp16_;
			GtkMessageDialog* _tmp17_;
			GtkMessageDialog* _tmp18_;
			GtkMessageDialog* _tmp19_;
			GtkMessageDialog* _tmp20_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = g_slice_new0 (Block1Data);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->_ref_count_ = 1;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->self = g_object_ref (self);
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = g_strdup_printf ("%s\n%s", _ ("The puzzle you have entered has multiple solutions."), _ ("Valid Sudoku puzzles have exactly one solution."));
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			warning_str = _tmp13_;
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = self->priv->window;
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = warning_str;
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp14_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp15_);
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp16_);
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->dialog = _tmp16_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _data1_->dialog;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp17_, _ ("_Back"), (gint) GTK_RESPONSE_REJECT);
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = _data1_->dialog;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp18_, _ ("Play _Anyway"), (gint) GTK_RESPONSE_ACCEPT);
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = _data1_->dialog;
#line 297 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) _____lambda21__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = _data1_->dialog;
#line 304 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_show ((GtkWidget*) _tmp20_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (warning_str);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			block1_data_unref (_data1_);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = NULL;
#line 1694 "gnome-sudoku.c"
		}
	}
}


static void sudoku_toggle_pause_cb (Sudoku* self) {
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1714 "gnome-sudoku.c"
		SudokuGame* _tmp3_;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp3_);
#line 1720 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp4_;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 313 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp4_);
#line 1727 "gnome-sudoku.c"
	}
}


static void sudoku_tick_cb (Sudoku* self) {
	gint elapsed_time;
	SudokuGame* _tmp0_;
	gdouble _tmp1_;
	gint hours;
	gint _tmp2_;
	gint minutes;
	gint _tmp3_;
	gint _tmp4_;
	gint seconds;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_total_time_played (_tmp0_);
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	elapsed_time = (gint) _tmp1_;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = elapsed_time;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	hours = _tmp2_ / 3600;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = elapsed_time;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = hours;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = (_tmp3_ - (_tmp4_ * 3600)) / 60;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = elapsed_time;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = hours;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = minutes;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	seconds = (_tmp5_ - (_tmp6_ * 3600)) - (_tmp7_ * 60);
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = hours;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ > 0) {
#line 1776 "gnome-sudoku.c"
		GtkLabel* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->clock_label;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = hours;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = minutes;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = seconds;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp10_, _tmp11_, _tmp12_);
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = _tmp13_;
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp9_, _tmp14_);
#line 323 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp14_);
#line 1799 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = self->priv->clock_label;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = minutes;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = seconds;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp15_, _tmp19_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp19_);
#line 1820 "gnome-sudoku.c"
	}
}


static void sudoku_display_pause_button (Sudoku* self) {
	GtkButton* _tmp0_;
	GtkLabel* _tmp1_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 330 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 331 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 331 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _ ("_Pause"));
#line 1838 "gnome-sudoku.c"
}


static void sudoku_display_unpause_button (Sudoku* self) {
	GtkButton* _tmp0_;
	GtkLabel* _tmp1_;
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _ ("_Resume"));
#line 1855 "gnome-sudoku.c"
}


static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board) {
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp0_);
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = board;
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game (self, _tmp1_);
#line 1876 "gnome-sudoku.c"
}


static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self) {
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_tick_cb ((Sudoku*) self);
#line 1883 "gnome-sudoku.c"
}


static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self) {
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_paused_changed_cb ((Sudoku*) self);
#line 1890 "gnome-sudoku.c"
}


static void __lambda16_ (Sudoku* self) {
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	GSimpleAction* _tmp6_;
	SudokuGame* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	GSimpleAction* _tmp15_;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_game_is_empty (_tmp7_);
#line 382 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp8_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp11_) {
#line 1938 "gnome-sudoku.c"
		SudokuGame* _tmp12_;
		SudokuBoard* _tmp13_;
		gboolean _tmp14_;
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_fully_filled (_tmp13_);
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = !_tmp14_;
#line 1950 "gnome-sudoku.c"
	} else {
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = FALSE;
#line 1954 "gnome-sudoku.c"
	}
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->play_custom_game_action;
#line 383 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, _tmp9_);
#line 1960 "gnome-sudoku.c"
}


static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 379 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ ((Sudoku*) self);
#line 1967 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 1976 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1985 "gnome-sudoku.c"
		Sudoku* self;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->self;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 1995 "gnome-sudoku.c"
	}
}


static void __lambda18_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data2_->self;
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 2011 "gnome-sudoku.c"
	} else {
		gint _tmp1_;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = response_id;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
#line 413 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			g_application_quit ((GApplication*) self);
#line 2020 "gnome-sudoku.c"
		}
	}
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 2025 "gnome-sudoku.c"
}


static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda18_ (self, response_id);
#line 2032 "gnome-sudoku.c"
}


static void __lambda17_ (Sudoku* self) {
	Block2Data* _data2_;
	GtkButton* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuSaver* _tmp17_;
	SudokuGame* _tmp18_;
	gint minutes;
	SudokuGame* _tmp19_;
	gdouble _tmp20_;
	gint _tmp21_;
	gchar* time_str;
	gchar* _tmp22_;
	GtkApplicationWindow* _tmp23_;
	GtkMessageDialog* _tmp24_;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->self = g_object_ref (self);
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_custom_game_button;
#line 390 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 391 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 391 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp1_);
#line 2064 "gnome-sudoku.c"
	{
		gint i;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 2069 "gnome-sudoku.c"
		{
			gboolean _tmp2_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp2_ = TRUE;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 2076 "gnome-sudoku.c"
				gint _tmp4_;
				SudokuGame* _tmp5_;
				SudokuBoard* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp2_) {
#line 2084 "gnome-sudoku.c"
					gint _tmp3_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp3_ = i;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp3_ + 1;
#line 2090 "gnome-sudoku.c"
				}
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = FALSE;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = i;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = self->priv->game;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_->board;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = _tmp7_;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 2108 "gnome-sudoku.c"
				}
				{
					gint j;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 2114 "gnome-sudoku.c"
					{
						gboolean _tmp9_;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp9_ = TRUE;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 2121 "gnome-sudoku.c"
							gint _tmp11_;
							SudokuGame* _tmp12_;
							SudokuBoard* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							SudokuView* _tmp16_;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp9_) {
#line 2130 "gnome-sudoku.c"
								gint _tmp10_;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp10_ = j;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp10_ + 1;
#line 2136 "gnome-sudoku.c"
							}
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = FALSE;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = j;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = self->priv->game;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_->board;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp15_ = _tmp14_;
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp11_ < _tmp15_)) {
#line 394 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 2154 "gnome-sudoku.c"
							}
#line 395 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp16_ = self->priv->view;
#line 395 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp16_, "can-focus", FALSE, NULL);
#line 2160 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 397 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->saver;
#line 397 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 397 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp17_, _tmp18_, TRUE);
#line 400 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = self->priv->game;
#line 400 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = sudoku_game_get_total_time_played (_tmp19_);
#line 400 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = MAX (1, ((gint) _tmp20_) / 60);
#line 400 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp21_;
#line 401 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_strdup_printf (ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes), minutes);
#line 401 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp22_;
#line 404 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->window;
#line 404 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp23_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", time_str);
#line 404 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp24_);
#line 404 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp24_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _ ("_Quit"), (gint) GTK_RESPONSE_REJECT);
#line 407 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _ ("Play _Again"), (gint) GTK_RESPONSE_ACCEPT);
#line 409 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 2207 "gnome-sudoku.c"
}


static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ ((Sudoku*) self);
#line 2214 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	SudokuView* _tmp0_;
	SudokuBoard* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuGame* _tmp5_;
	GameMode _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	GSimpleAction* _tmp12_;
	SudokuGame* _tmp13_;
	gboolean _tmp14_;
	SudokuGame* _tmp15_;
	SudokuGame* _tmp16_;
	SudokuGame* _tmp17_;
	SudokuGame* _tmp18_;
	SudokuView* _tmp19_;
	SudokuView* _tmp20_;
	SudokuView* _tmp21_;
	gboolean _tmp22_;
	GameMode _tmp23_;
	SudokuView* _tmp28_;
	GSettings* _tmp29_;
	gboolean _tmp30_;
	SudokuView* _tmp31_;
	GtkBox* _tmp32_;
	SudokuView* _tmp33_;
	SudokuGame* _tmp34_;
	GameMode _tmp35_;
	SudokuGame* _tmp36_;
	SudokuBoard* _tmp37_;
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 349 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 349 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 2259 "gnome-sudoku.c"
		GtkBox* _tmp1_;
		SudokuView* _tmp2_;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game_box;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
#line 2268 "gnome-sudoku.c"
	}
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = board;
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_game_new (_tmp3_);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp4_;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->game;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->current_game_mode;
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_->mode = _tmp6_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->undo_action;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, FALSE);
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->redo_action;
#line 357 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 358 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->clear_action;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = self->priv->play_custom_game_action;
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = self->priv->game;
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = sudoku_game_is_empty (_tmp13_);
#line 360 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->game;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp15_, "tick", (GCallback) _sudoku_tick_cb_sudoku_game_tick, self, 0);
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp16_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_start_clock (_tmp17_);
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = sudoku_view_new (_tmp18_);
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp19_);
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp19_;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = self->priv->view;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp20_, 480, 480);
#line 369 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = self->priv->view;
#line 369 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->show_possibilities;
#line 369 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp21_, _tmp22_);
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->current_game_mode;
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp23_ == GAME_MODE_CREATE) {
#line 2348 "gnome-sudoku.c"
		SudokuView* _tmp24_;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = self->priv->view;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp24_, TRUE);
#line 2354 "gnome-sudoku.c"
	} else {
		SudokuView* _tmp25_;
		GSettings* _tmp26_;
		gboolean _tmp27_;
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp25_ = self->priv->view;
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp26_ = self->priv->settings;
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp27_ = g_settings_get_boolean (_tmp26_, "show-warnings");
#line 373 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp25_, _tmp27_);
#line 2367 "gnome-sudoku.c"
	}
#line 374 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->view;
#line 374 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->settings;
#line 374 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = g_settings_get_boolean (_tmp29_, "highlighter");
#line 374 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_highlighter (_tmp28_, _tmp30_);
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->view;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp31_);
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = self->priv->game_box;
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->view;
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
#line 379 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = self->priv->game;
#line 379 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp34_, "cell-changed", (GCallback) ___lambda16__sudoku_game_cell_changed, self, 0);
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->current_game_mode;
#line 386 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp35_ == GAME_MODE_CREATE) {
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2397 "gnome-sudoku.c"
	}
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->game;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _tmp36_->board;
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp37_, "completed", (GCallback) ___lambda17__sudoku_board_completed, self, 0);
#line 2405 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	SudokuGame* _tmp2_;
	GtkBox* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GSimpleAction* _tmp5_;
	GtkLabel* _tmp6_;
	GtkImage* _tmp7_;
	SudokuGame* _tmp8_;
#line 421 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_redo_box;
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->headerbar;
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_title (_tmp4_, _ ("Select Difficulty"));
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->print_action;
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 428 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clock_label;
#line 428 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp6_);
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->clock_image;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->game;
#line 430 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ != NULL) {
#line 2455 "gnome-sudoku.c"
		SudokuGame* _tmp9_;
#line 431 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->game;
#line 431 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp9_);
#line 2461 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 434 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 436 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 2471 "gnome-sudoku.c"
}


static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2479 "gnome-sudoku.c"
	{
		GeeList* gen_boards;
		GAsyncResult* _tmp0_;
		GeeList* _tmp1_;
		gpointer _tmp2_;
		SudokuBoard* _tmp3_;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2494 "gnome-sudoku.c"
			goto __catch1_g_error;
		}
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gee_list_get (gen_boards, 0);
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = (SudokuBoard*) _tmp2_;
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp3_);
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp3_);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2507 "gnome-sudoku.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = e->message;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:450: Error: %s", _tmp4_);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2524 "gnome-sudoku.c"
	}
	__finally1:
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 443 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2535 "gnome-sudoku.c"
	}
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda19_ ((Sudoku*) self, source_object, res);
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2545 "gnome-sudoku.c"
}


static void sudoku_create_game_cb (Sudoku* self) {
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 441 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_CREATE;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda19__gasync_ready_callback, g_object_ref (self));
#line 2556 "gnome-sudoku.c"
}


static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2564 "gnome-sudoku.c"
	{
		GeeList* gen_boards;
		GAsyncResult* _tmp0_;
		GeeList* _tmp1_;
		GtkButton* _tmp2_;
		gpointer _tmp3_;
		SudokuBoard* _tmp4_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2580 "gnome-sudoku.c"
			goto __catch2_g_error;
		}
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2597 "gnome-sudoku.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:475: Error: %s", _tmp5_);
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2614 "gnome-sudoku.c"
	}
	__finally2:
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 467 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2625 "gnome-sudoku.c"
	}
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ ((Sudoku*) self, source_object, res);
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2635 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty;
	GVariant* _tmp0_;
	gint32 _tmp1_;
	GtkButton* _tmp2_;
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 455 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 461 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 464 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, NULL, ___lambda15__gasync_ready_callback, g_object_ref (self));
#line 2662 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2671 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2680 "gnome-sudoku.c"
		Sudoku* self;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->dialog);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2690 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_;
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 485 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2704 "gnome-sudoku.c"
		SudokuGame* _tmp1_;
		SudokuView* _tmp2_;
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 487 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp1_);
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp2_);
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 490 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2725 "gnome-sudoku.c"
	}
#line 492 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
#line 2729 "gnome-sudoku.c"
}


static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self, response_id);
#line 2736 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Reset the board to its original state?"));
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp1_);
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->dialog = _tmp1_;
#line 484 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2768 "gnome-sudoku.c"
}


static void sudoku_show_game_view (Sudoku* self) {
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkBox* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkLabel* _tmp4_;
	GtkImage* _tmp5_;
	SudokuGame* _tmp6_;
	GameMode _tmp8_;
#line 498 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_redo_box;
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_action;
#line 503 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->clock_label;
#line 504 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->clock_image;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_ != NULL) {
#line 2811 "gnome-sudoku.c"
		SudokuGame* _tmp7_;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp7_);
#line 2817 "gnome-sudoku.c"
	}
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->current_game_mode;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ == GAME_MODE_PLAY) {
#line 2823 "gnome-sudoku.c"
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->play_custom_game_button;
#line 512 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->play_pause_button;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
#line 2834 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp11_;
		GtkImage* _tmp12_;
		GtkButton* _tmp13_;
		GtkButton* _tmp14_;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->clock_label;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->clock_image;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp12_);
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = self->priv->play_custom_game_button;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = self->priv->play_pause_button;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
#line 2856 "gnome-sudoku.c"
	}
}


static void sudoku_set_headerbar_title (Sudoku* self) {
	GameMode _tmp0_;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->current_game_mode;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == GAME_MODE_PLAY) {
#line 2869 "gnome-sudoku.c"
		GtkHeaderBar* _tmp1_;
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		DifficultyCategory _tmp4_;
		DifficultyCategory _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->headerbar;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_get_difficulty_category (_tmp3_);
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = difficulty_category_to_string (_tmp5_);
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_;
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp1_, _tmp7_);
#line 527 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp7_);
#line 2895 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp8_;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->headerbar;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp8_, _ ("Create Puzzle"));
#line 2902 "gnome-sudoku.c"
	}
}


static void sudoku_back_cb (Sudoku* self) {
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 2914 "gnome-sudoku.c"
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	SudokuGame* _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	SudokuView* _tmp6_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2936 "gnome-sudoku.c"
	}
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2954 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	SudokuGame* _tmp2_;
	GSimpleAction* _tmp3_;
	SudokuGame* _tmp4_;
	gboolean _tmp5_;
	SudokuView* _tmp6_;
#line 547 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 549 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 549 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 549 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 550 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2976 "gnome-sudoku.c"
	}
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 552 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 2994 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GeeArrayList* list;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	SudokuGame* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuBoard* _tmp9_;
	SudokuPrinter* printer;
	GeeArrayList* _tmp10_;
	GtkApplicationWindow* _tmp11_;
	SudokuPrinter* _tmp12_;
	SudokuPrinter* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3027 "gnome-sudoku.c"
	}
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 560 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 561 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, (GtkWindow*) _tmp11_);
#line 565 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 566 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 566 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 569 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 569 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 3079 "gnome-sudoku.c"
}


static void __lambda25_ (Sudoku* self) {
	GSimpleAction* _tmp0_;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	GSimpleAction* _tmp3_;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 578 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 579 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 579 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 3100 "gnome-sudoku.c"
}


static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda25_ ((Sudoku*) self);
#line 3107 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	PrintDialog* print_dialog;
	SudokuSaver* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	PrintDialog* _tmp4_;
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 575 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	print_dialog = _tmp4_;
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) print_dialog, "destroy", (GCallback) ___lambda25__gtk_widget_destroy, self, 0);
#line 581 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) print_dialog);
#line 572 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (print_dialog);
#line 3144 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 584 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 3152 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3167 "gnome-sudoku.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:592: Unable to open help: %s", _tmp4_);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 3189 "gnome-sudoku.c"
	}
	__finally3:
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 586 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3200 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_generator_qqwing_version ();
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp2_);
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _ ("Sudoku"), "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _ (_tmp4_), "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_3_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp4_);
#line 605 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp2_);
#line 3229 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint _tmp4_;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 622 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 3259 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 3269 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) sudoku_real_startup;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) sudoku_real_activate;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 3288 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 60 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 3299 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject * obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 32 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 33 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 35 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 37 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 42 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 43 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 47 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 52 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 55 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 3355 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



