/* rygel-tracker-metadata-container.c generated by valac 0.34.7, the Vala compiler
 * generated from rygel-tracker-metadata-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TRACKER_TYPE_METADATA_CONTAINER (rygel_tracker_metadata_container_get_type ())
#define RYGEL_TRACKER_METADATA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_METADATA_CONTAINER, RygelTrackerMetadataContainer))
#define RYGEL_TRACKER_METADATA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_METADATA_CONTAINER, RygelTrackerMetadataContainerClass))
#define RYGEL_TRACKER_IS_METADATA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_METADATA_CONTAINER))
#define RYGEL_TRACKER_IS_METADATA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_METADATA_CONTAINER))
#define RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_METADATA_CONTAINER, RygelTrackerMetadataContainerClass))

typedef struct _RygelTrackerMetadataContainer RygelTrackerMetadataContainer;
typedef struct _RygelTrackerMetadataContainerClass RygelTrackerMetadataContainerClass;
typedef struct _RygelTrackerMetadataContainerPrivate RygelTrackerMetadataContainerPrivate;

#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;
#define _rygel_tracker_item_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_item_factory_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerMetadataContainerFetchMetadataValuesData RygelTrackerMetadataContainerFetchMetadataValuesData;
typedef struct _RygelTrackerMetadataContainerFindObjectData RygelTrackerMetadataContainerFindObjectData;

struct _RygelTrackerMetadataContainer {
	RygelSimpleContainer parent_instance;
	RygelTrackerMetadataContainerPrivate * priv;
	RygelTrackerItemFactory* item_factory;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerMetadataContainerClass {
	RygelSimpleContainerClass parent_class;
	RygelTrackerSelectionQuery* (*create_query) (RygelTrackerMetadataContainer* self);
	RygelTrackerSearchContainer* (*create_container) (RygelTrackerMetadataContainer* self, const gchar* id, const gchar* title, const gchar* value);
	gchar* (*create_id_for_title) (RygelTrackerMetadataContainer* self, const gchar* title);
	gchar* (*create_title_for_value) (RygelTrackerMetadataContainer* self, const gchar* value);
	gchar* (*create_filter) (RygelTrackerMetadataContainer* self, const gchar* variable, const gchar* value);
};

struct _RygelTrackerMetadataContainerPrivate {
	gboolean update_in_progress;
	gchar* child_class;
	TrackerSparqlConnection* resources;
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerMetadataContainerFetchMetadataValuesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataContainer* self;
	gboolean _tmp0_;
	RygelTrackerSelectionQuery* query;
	RygelTrackerSelectionQuery* _tmp1_;
	RygelTrackerSelectionQuery* _tmp2_;
	TrackerSparqlConnection* _tmp3_;
	gboolean _tmp4_;
	RygelTrackerSelectionQuery* _tmp5_;
	TrackerSparqlCursor* _tmp6_;
	gboolean _tmp7_;
	RygelTrackerSelectionQuery* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	gboolean _tmp10_;
	gchar* value;
	RygelTrackerSelectionQuery* _tmp11_;
	TrackerSparqlCursor* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* title;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* id;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_;
	RygelTrackerSearchContainer* container;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	RygelTrackerSearchContainer* _tmp28_;
	const gchar* _tmp29_;
	RygelTrackerSearchContainer* _tmp30_;
	const gchar* _tmp31_;
	RygelTrackerSearchContainer* _tmp32_;
	GError* _error_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GError* _tmp36_;
	const gchar* _tmp37_;
	GError * _inner_error_;
};

struct _RygelTrackerMetadataContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerMetadataContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	RygelMediaObject* _tmp2_;
	const gchar* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* _tmp6_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_metadata_container_parent_class = NULL;

GType rygel_tracker_metadata_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_METADATA_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_METADATA_CONTAINER, RygelTrackerMetadataContainerPrivate))
enum  {
	RYGEL_TRACKER_METADATA_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_METADATA_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker1"
#define RYGEL_TRACKER_METADATA_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
RygelTrackerMetadataContainer* rygel_tracker_metadata_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, const gchar* child_class);
static void rygel_tracker_metadata_container_fetch_metadata_values_data_free (gpointer _data);
void rygel_tracker_metadata_container_fetch_metadata_values (RygelTrackerMetadataContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_metadata_container_fetch_metadata_values_finish (RygelTrackerMetadataContainer* self, GAsyncResult* _res_);
static gboolean rygel_tracker_metadata_container_fetch_metadata_values_co (RygelTrackerMetadataContainerFetchMetadataValuesData* _data_);
RygelTrackerSelectionQuery* rygel_tracker_metadata_container_create_query (RygelTrackerMetadataContainer* self);
void rygel_tracker_query_execute (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_tracker_query_execute_finish (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
static void rygel_tracker_metadata_container_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* rygel_tracker_metadata_container_create_title_for_value (RygelTrackerMetadataContainer* self, const gchar* value);
gchar* rygel_tracker_metadata_container_create_id_for_title (RygelTrackerMetadataContainer* self, const gchar* title);
RygelTrackerSearchContainer* rygel_tracker_metadata_container_create_container (RygelTrackerMetadataContainer* self, const gchar* id, const gchar* title, const gchar* value);
static RygelTrackerSelectionQuery* rygel_tracker_metadata_container_real_create_query (RygelTrackerMetadataContainer* self);
static RygelTrackerSearchContainer* rygel_tracker_metadata_container_real_create_container (RygelTrackerMetadataContainer* self, const gchar* id, const gchar* title, const gchar* value);
static void rygel_tracker_metadata_container_real_find_object_data_free (gpointer _data);
static void rygel_tracker_metadata_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_metadata_container_real_find_object_co (RygelTrackerMetadataContainerFindObjectData* _data_);
static gboolean rygel_tracker_metadata_container_is_our_child (RygelTrackerMetadataContainer* self, const gchar* id);
static void rygel_tracker_metadata_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_metadata_container_real_create_id_for_title (RygelTrackerMetadataContainer* self, const gchar* title);
static gchar* rygel_tracker_metadata_container_real_create_title_for_value (RygelTrackerMetadataContainer* self, const gchar* value);
gchar* rygel_tracker_metadata_container_create_filter (RygelTrackerMetadataContainer* self, const gchar* variable, const gchar* value);
static gchar* rygel_tracker_metadata_container_real_create_filter (RygelTrackerMetadataContainer* self, const gchar* variable, const gchar* value);
gchar* rygel_tracker_query_escape_string (const gchar* literal);
static void rygel_tracker_metadata_container_finalize (GObject* obj);


static gpointer _rygel_tracker_item_factory_ref0 (gpointer self) {
	return self ? rygel_tracker_item_factory_ref (self) : NULL;
}


RygelTrackerMetadataContainer* rygel_tracker_metadata_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, RygelTrackerItemFactory* item_factory, const gchar* child_class) {
	RygelTrackerMetadataContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelTrackerItemFactory* _tmp3_ = NULL;
	RygelTrackerItemFactory* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (item_factory != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	self = (RygelTrackerMetadataContainer*) rygel_simple_container_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = item_factory;
	_tmp4_ = _rygel_tracker_item_factory_ref0 (_tmp3_);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	self->item_factory = _tmp4_;
	_tmp5_ = child_class;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->child_class);
	self->priv->child_class = _tmp6_;
	{
		TrackerSparqlConnection* _tmp7_ = NULL;
		TrackerSparqlConnection* _tmp8_ = NULL;
		TrackerSparqlConnection* _tmp9_ = NULL;
		_tmp8_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->priv->resources);
		self->priv->resources = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = _ ("Failed to create Tracker connection: %s");
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_critical (_tmp10_, _tmp12_);
		_g_error_free0 (_error_);
		return self;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static void rygel_tracker_metadata_container_fetch_metadata_values_data_free (gpointer _data) {
	RygelTrackerMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerMetadataContainerFetchMetadataValuesData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void rygel_tracker_metadata_container_fetch_metadata_values (RygelTrackerMetadataContainer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataContainerFetchMetadataValuesData* _data_;
	RygelTrackerMetadataContainer* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelTrackerMetadataContainerFetchMetadataValuesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_container_fetch_metadata_values);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_container_fetch_metadata_values_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_tracker_metadata_container_fetch_metadata_values_co (_data_);
}


void rygel_tracker_metadata_container_fetch_metadata_values_finish (RygelTrackerMetadataContainer* self, GAsyncResult* _res_) {
	RygelTrackerMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_metadata_container_fetch_metadata_values_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataContainerFetchMetadataValuesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_metadata_container_fetch_metadata_values_co (_data_);
}


static gboolean rygel_tracker_metadata_container_fetch_metadata_values_co (RygelTrackerMetadataContainerFetchMetadataValuesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->update_in_progress;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->update_in_progress = TRUE;
	rygel_simple_container_clear ((RygelSimpleContainer*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = rygel_tracker_metadata_container_create_query (_data_->self);
	_data_->query = _data_->_tmp1_;
	{
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->resources;
		_data_->_state_ = 1;
		rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->_tmp2_, _data_->_tmp3_, rygel_tracker_metadata_container_fetch_metadata_values_ready, _data_);
		return FALSE;
		_state_1:
		rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->query;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->_tmp5_->result;
			_data_->_tmp7_ = FALSE;
			_data_->_tmp7_ = tracker_sparql_cursor_next (_data_->_tmp6_, NULL, &_data_->_inner_error_);
			_data_->_tmp4_ = _data_->_tmp7_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			if (!_data_->_tmp4_) {
				break;
			}
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->query;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_->result;
			_data_->_tmp10_ = FALSE;
			_data_->_tmp10_ = tracker_sparql_cursor_is_bound (_data_->_tmp9_, 0);
			if (!_data_->_tmp10_) {
				continue;
			}
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->query;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_tmp11_->result;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = tracker_sparql_cursor_get_string (_data_->_tmp12_, 0, NULL);
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_strdup (_data_->_tmp13_);
			_data_->value = _data_->_tmp14_;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->value;
			if (g_strcmp0 (_data_->_tmp15_, "") == 0) {
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->value;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = rygel_tracker_metadata_container_create_title_for_value (_data_->self, _data_->_tmp16_);
			_data_->title = _data_->_tmp17_;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->title;
			if (_data_->_tmp18_ == NULL) {
				_g_free0 (_data_->title);
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->title;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = rygel_tracker_metadata_container_create_id_for_title (_data_->self, _data_->_tmp19_);
			_data_->id = _data_->_tmp20_;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->id;
			if (_data_->_tmp22_ == NULL) {
				_data_->_tmp21_ = TRUE;
			} else {
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _data_->id;
				_data_->_tmp24_ = FALSE;
				_data_->_tmp24_ = rygel_simple_container_is_child_id_unique ((RygelSimpleContainer*) _data_->self, _data_->_tmp23_);
				_data_->_tmp21_ = !_data_->_tmp24_;
			}
			if (_data_->_tmp21_) {
				_g_free0 (_data_->id);
				_g_free0 (_data_->title);
				_g_free0 (_data_->value);
				continue;
			}
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->id;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->title;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->value;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = rygel_tracker_metadata_container_create_container (_data_->self, _data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_);
			_data_->container = _data_->_tmp28_;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->self->priv->child_class;
			if (_data_->_tmp29_ != NULL) {
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->container;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->self->priv->child_class;
				rygel_media_object_set_upnp_class ((RygelMediaObject*) _data_->_tmp30_, _data_->_tmp31_);
			}
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->container;
			rygel_simple_container_add_child_container ((RygelSimpleContainer*) _data_->self, (RygelMediaContainer*) _data_->_tmp32_);
			_g_object_unref0 (_data_->container);
			_g_free0 (_data_->id);
			_g_free0 (_data_->title);
			_g_free0 (_data_->value);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _ ("Error getting all values for “%s”: %s");
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_error_;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->_tmp36_->message;
		g_critical (_data_->_tmp33_, _data_->_tmp35_, _data_->_tmp37_);
		_data_->self->priv->update_in_progress = FALSE;
		_g_error_free0 (_data_->_error_);
		_rygel_tracker_query_unref0 (_data_->query);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_rygel_tracker_query_unref0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	_data_->self->priv->update_in_progress = FALSE;
	_rygel_tracker_query_unref0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static RygelTrackerSelectionQuery* rygel_tracker_metadata_container_real_create_query (RygelTrackerMetadataContainer* self) {
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_metadata_container_create_query'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelTrackerSelectionQuery* rygel_tracker_metadata_container_create_query (RygelTrackerMetadataContainer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS (self)->create_query (self);
}


static RygelTrackerSearchContainer* rygel_tracker_metadata_container_real_create_container (RygelTrackerMetadataContainer* self, const gchar* id, const gchar* title, const gchar* value) {
	g_critical ("Type `%s' does not implement abstract method `rygel_tracker_metadata_container_create_container'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelTrackerSearchContainer* rygel_tracker_metadata_container_create_container (RygelTrackerMetadataContainer* self, const gchar* id, const gchar* title, const gchar* value) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS (self)->create_container (self, id, title, value);
}


static void rygel_tracker_metadata_container_real_find_object_data_free (gpointer _data) {
	RygelTrackerMetadataContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerMetadataContainerFindObjectData, _data_);
}


static void rygel_tracker_metadata_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerMetadataContainer * self;
	RygelTrackerMetadataContainerFindObjectData* _data_;
	RygelTrackerMetadataContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	self = (RygelTrackerMetadataContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerMetadataContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_tracker_metadata_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_metadata_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_tracker_metadata_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_tracker_metadata_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelTrackerMetadataContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_tracker_metadata_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerMetadataContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_metadata_container_real_find_object_co (_data_);
}


static gboolean rygel_tracker_metadata_container_real_find_object_co (RygelTrackerMetadataContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = rygel_tracker_metadata_container_is_our_child (_data_->self, _data_->_tmp0_);
	if (_data_->_tmp1_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->id;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->cancellable;
		_data_->_state_ = 1;
		RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer), _data_->_tmp3_, _data_->_tmp4_, rygel_tracker_metadata_container_find_object_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_tracker_metadata_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_TYPE_SIMPLE_CONTAINER, RygelSimpleContainer), _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_data_->result = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp2_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_metadata_container_real_create_id_for_title (RygelTrackerMetadataContainer* self, const gchar* title) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ":", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = title;
	_tmp5_ = g_uri_escape_string (_tmp4_, "", TRUE);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp8_;
	return result;
}


gchar* rygel_tracker_metadata_container_create_id_for_title (RygelTrackerMetadataContainer* self, const gchar* title) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS (self)->create_id_for_title (self, title);
}


static gchar* rygel_tracker_metadata_container_real_create_title_for_value (RygelTrackerMetadataContainer* self, const gchar* value) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* rygel_tracker_metadata_container_create_title_for_value (RygelTrackerMetadataContainer* self, const gchar* value) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS (self)->create_title_for_value (self, value);
}


static gchar* rygel_tracker_metadata_container_real_create_filter (RygelTrackerMetadataContainer* self, const gchar* variable, const gchar* value) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (variable != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = variable;
	_tmp1_ = g_strconcat (_tmp0_, " = \"", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = value;
	_tmp4_ = rygel_tracker_query_escape_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "\"", NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}


gchar* rygel_tracker_metadata_container_create_filter (RygelTrackerMetadataContainer* self, const gchar* variable, const gchar* value) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_TRACKER_METADATA_CONTAINER_GET_CLASS (self)->create_filter (self, variable, value);
}


static gboolean rygel_tracker_metadata_container_is_our_child (RygelTrackerMetadataContainer* self, const gchar* id) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = id;
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_str_has_prefix (_tmp0_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static void rygel_tracker_metadata_container_class_init (RygelTrackerMetadataContainerClass * klass) {
	rygel_tracker_metadata_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerMetadataContainerPrivate));
	((RygelTrackerMetadataContainerClass *) klass)->create_query = (RygelTrackerSelectionQuery* (*)(RygelTrackerMetadataContainer*)) rygel_tracker_metadata_container_real_create_query;
	((RygelTrackerMetadataContainerClass *) klass)->create_container = (RygelTrackerSearchContainer* (*)(RygelTrackerMetadataContainer*, const gchar*, const gchar*, const gchar*)) rygel_tracker_metadata_container_real_create_container;
	((RygelMediaContainerClass *) klass)->find_object = (void (*)(RygelMediaContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_metadata_container_real_find_object;
	((RygelMediaContainerClass *) klass)->find_object_finish = (RygelMediaObject* (*)(RygelMediaContainer*, GAsyncResult*, GError**)) rygel_tracker_metadata_container_real_find_object_finish;
	((RygelTrackerMetadataContainerClass *) klass)->create_id_for_title = (gchar* (*)(RygelTrackerMetadataContainer*, const gchar*)) rygel_tracker_metadata_container_real_create_id_for_title;
	((RygelTrackerMetadataContainerClass *) klass)->create_title_for_value = (gchar* (*)(RygelTrackerMetadataContainer*, const gchar*)) rygel_tracker_metadata_container_real_create_title_for_value;
	((RygelTrackerMetadataContainerClass *) klass)->create_filter = (gchar* (*)(RygelTrackerMetadataContainer*, const gchar*, const gchar*)) rygel_tracker_metadata_container_real_create_filter;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_metadata_container_finalize;
}


static void rygel_tracker_metadata_container_instance_init (RygelTrackerMetadataContainer * self) {
	self->priv = RYGEL_TRACKER_METADATA_CONTAINER_GET_PRIVATE (self);
	self->priv->update_in_progress = FALSE;
}


static void rygel_tracker_metadata_container_finalize (GObject* obj) {
	RygelTrackerMetadataContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_METADATA_CONTAINER, RygelTrackerMetadataContainer);
	_rygel_tracker_item_factory_unref0 (self->item_factory);
	_g_free0 (self->priv->child_class);
	_g_object_unref0 (self->priv->resources);
	_g_object_unref0 (self->triplets);
	G_OBJECT_CLASS (rygel_tracker_metadata_container_parent_class)->finalize (obj);
}


/**
 * Base class for containers listing possible values of a particular Tracker
 * metadata key.
 */
GType rygel_tracker_metadata_container_get_type (void) {
	static volatile gsize rygel_tracker_metadata_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_metadata_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMetadataContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_metadata_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMetadataContainer), 0, (GInstanceInitFunc) rygel_tracker_metadata_container_instance_init, NULL };
		GType rygel_tracker_metadata_container_type_id;
		rygel_tracker_metadata_container_type_id = g_type_register_static (RYGEL_TYPE_SIMPLE_CONTAINER, "RygelTrackerMetadataContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_tracker_metadata_container_type_id__volatile, rygel_tracker_metadata_container_type_id);
	}
	return rygel_tracker_metadata_container_type_id__volatile;
}



