/* minefield-view.c generated by valac 0.16.0, the Vala compiler
 * generated from minefield-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <games-preimage.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

struct _MinefieldView {
	GtkDrawingArea parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _MinefieldViewPrivate {
	gboolean use_question_marks;
	gboolean use_overmine_warning;
	gboolean use_autoflag;
	gint selected_x;
	gint selected_y;
	GamesPreimage* flag_preimage;
	GamesPreimage* mine_preimage;
	GamesPreimage* question_preimage;
	GamesPreimage* bang_preimage;
	GamesPreimage* warning_preimage;
	guint render_size;
	cairo_pattern_t* flag_pattern;
	cairo_pattern_t* mine_pattern;
	cairo_pattern_t* question_pattern;
	cairo_pattern_t* bang_pattern;
	cairo_pattern_t* warning_pattern;
	cairo_pattern_t** number_patterns;
	gint number_patterns_length1;
	gint _number_patterns_size_;
	Minefield* _minefield;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer minefield_view_parent_class = NULL;

GType minefield_view_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
static GamesPreimage* minefield_view_load_preimage (MinefieldView* self, const gchar* filename);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static cairo_pattern_t* minefield_view_render_preimage_pattern (MinefieldView* self, cairo_t* cr, GamesPreimage* preimage);
static guint minefield_view_get_mine_size (MinefieldView* self);
static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
Minefield* minefield_view_get_minefield (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_x_offset (MinefieldView* self);
static guint minefield_view_get_y_offset (MinefieldView* self);
static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gboolean minefield_is_location (Minefield* self, guint x, guint y);
gboolean minefield_get_paused (Minefield* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean minefield_get_is_complete (Minefield* self);
static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void _minefield_view_minefield___lambda2_ (MinefieldView* self);
static void __minefield_view_minefield___lambda2__minefield_paused_changed (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

MinefieldView* minefield_view_construct (GType object_type) {
	MinefieldView * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GamesPreimage* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GamesPreimage* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GamesPreimage* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GamesPreimage* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	GamesPreimage* _tmp14_ = NULL;
	cairo_pattern_t** _tmp15_ = NULL;
	self = (MinefieldView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK));
	_tmp0_ = g_build_filename (DATA_DIRECTORY, "flag.svg", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = minefield_view_load_preimage (self, _tmp1_);
	_g_object_unref0 (self->priv->flag_preimage);
	self->priv->flag_preimage = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = g_build_filename (DATA_DIRECTORY, "mine.svg", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_load_preimage (self, _tmp4_);
	_g_object_unref0 (self->priv->mine_preimage);
	self->priv->mine_preimage = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = g_build_filename (DATA_DIRECTORY, "flag-question.svg", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = minefield_view_load_preimage (self, _tmp7_);
	_g_object_unref0 (self->priv->question_preimage);
	self->priv->question_preimage = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = g_build_filename (DATA_DIRECTORY, "bang.svg", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = minefield_view_load_preimage (self, _tmp10_);
	_g_object_unref0 (self->priv->bang_preimage);
	self->priv->bang_preimage = _tmp11_;
	_g_free0 (_tmp10_);
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "warning.svg", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = minefield_view_load_preimage (self, _tmp13_);
	_g_object_unref0 (self->priv->warning_preimage);
	self->priv->warning_preimage = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = g_new0 (cairo_pattern_t*, 8 + 1);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->priv->number_patterns = _tmp15_;
	self->priv->number_patterns_length1 = 8;
	self->priv->_number_patterns_size_ = self->priv->number_patterns_length1;
	return self;
}


MinefieldView* minefield_view_new (void) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW);
}


void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_question_marks;
	self->priv->use_question_marks = _tmp0_;
}


void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_overmine_warning;
	self->priv->use_overmine_warning = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_autoflag;
	self->priv->use_autoflag = _tmp0_;
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	{
		gint x;
		x = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				Minefield* _tmp4_;
				guint _tmp5_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = minefield;
				_tmp5_ = _tmp4_->width;
				if (!(((guint) _tmp3_) < _tmp5_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							Minefield* _tmp10_;
							guint _tmp11_;
							gboolean _tmp12_ = FALSE;
							Minefield* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							gboolean _tmp16_ = FALSE;
							gboolean _tmp27_;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = y;
								y = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = y;
							_tmp10_ = minefield;
							_tmp11_ = _tmp10_->height;
							if (!(((guint) _tmp9_) < _tmp11_)) {
								break;
							}
							_tmp13_ = minefield;
							_tmp14_ = x;
							_tmp15_ = y;
							_tmp16_ = minefield_has_mine (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
							if (_tmp16_) {
								_tmp12_ = TRUE;
							} else {
								gboolean _tmp17_ = FALSE;
								Minefield* _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gboolean _tmp21_ = FALSE;
								gboolean _tmp26_;
								_tmp18_ = minefield;
								_tmp19_ = x;
								_tmp20_ = y;
								_tmp21_ = minefield_has_mine (_tmp18_, (guint) _tmp19_, (guint) _tmp20_);
								if (!_tmp21_) {
									Minefield* _tmp22_;
									gint _tmp23_;
									gint _tmp24_;
									FlagType _tmp25_ = 0;
									_tmp22_ = minefield;
									_tmp23_ = x;
									_tmp24_ = y;
									_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
									_tmp17_ = _tmp25_ == FLAG_TYPE_FLAG;
								} else {
									_tmp17_ = FALSE;
								}
								_tmp26_ = _tmp17_;
								_tmp12_ = _tmp26_;
							}
							_tmp27_ = _tmp12_;
							if (_tmp27_) {
								gint _tmp28_;
								gint _tmp29_;
								_tmp28_ = x;
								_tmp29_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp28_, (guint) _tmp29_);
							}
						}
					}
				}
			}
		}
	}
}


static GamesPreimage* minefield_view_load_preimage (MinefieldView* self, const gchar* filename) {
	GamesPreimage* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	{
		const gchar* _tmp0_;
		GamesPreimage* _tmp1_;
		GamesPreimage* _tmp2_;
		_tmp0_ = filename;
		_tmp1_ = games_preimage_new_from_file (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		result = _tmp2_;
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static cairo_pattern_t* minefield_view_render_preimage_pattern (MinefieldView* self, cairo_t* cr, GamesPreimage* preimage) {
	cairo_pattern_t* result = NULL;
	cairo_t* _tmp0_;
	cairo_surface_t* _tmp1_ = NULL;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* surface;
	cairo_t* _tmp7_;
	cairo_t* c;
	GamesPreimage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPixbuf* pixbuf;
	cairo_pattern_t* _tmp14_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (preimage != NULL, NULL);
	_tmp0_ = cr;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = minefield_view_get_mine_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, (gint) _tmp3_, (gint) _tmp5_);
	surface = _tmp6_;
	_tmp7_ = cairo_create (surface);
	c = _tmp7_;
	_tmp8_ = preimage;
	_tmp9_ = minefield_view_get_mine_size (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = minefield_view_get_mine_size (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_preimage_render (_tmp8_, ((gint) _tmp10_) - 2, ((gint) _tmp12_) - 2);
	pixbuf = _tmp13_;
	gdk_cairo_set_source_pixbuf (c, pixbuf, (gdouble) 1, (gdouble) 1);
	cairo_paint (c);
	_tmp14_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp14_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_g_object_unref0 (pixbuf);
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n) {
	cairo_pattern_t* result = NULL;
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	PangoLayout* _tmp4_;
	PangoLayout* layout;
	PangoLayout* _tmp5_;
	PangoAttrList* _tmp6_;
	PangoAttrList* attributes;
	PangoAttribute* color_attribute = NULL;
	guint _tmp7_;
	PangoAttribute* _tmp16_;
	PangoAttribute* _tmp17_;
	guint _tmp18_;
	PangoAttrList* _tmp19_;
	PangoAttribute* _tmp20_;
	PangoFontDescription* _tmp21_;
	PangoFontDescription* font_desc;
	guint _tmp22_;
	guint _tmp23_;
	gdouble font_size;
	PangoAttrFontDesc* _tmp24_;
	PangoAttrFontDesc* font_attribute;
	PangoAttrFontDesc* _tmp25_;
	PangoAttrFontDesc* _tmp26_;
	guint _tmp27_;
	PangoAttrList* _tmp28_;
	PangoAttrFontDesc* _tmp29_;
	PangoLayout* _tmp30_;
	PangoAttrList* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	cairo_surface_t* _tmp36_;
	cairo_surface_t* surface;
	cairo_t* _tmp37_;
	cairo_t* c;
	PangoRectangle extent = {0};
	PangoLayout* _tmp38_;
	PangoRectangle _tmp39_ = {0};
	guint _tmp40_;
	guint _tmp41_;
	PangoRectangle _tmp42_;
	gint _tmp43_;
	gint dx;
	guint _tmp44_;
	guint _tmp45_;
	PangoRectangle _tmp46_;
	gint _tmp47_;
	gint dy;
	PangoLayout* _tmp48_;
	cairo_pattern_t* _tmp49_;
	cairo_pattern_t* pattern;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	layout = _tmp4_;
	_tmp5_ = layout;
	pango_layout_set_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	_tmp6_ = pango_attr_list_new ();
	attributes = _tmp6_;
	_tmp7_ = n;
	switch (_tmp7_) {
		case 1:
		{
			PangoAttribute* _tmp8_ = NULL;
			_tmp8_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp8_;
			break;
		}
		case 2:
		{
			PangoAttribute* _tmp9_ = NULL;
			_tmp9_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xa0a0, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp9_;
			break;
		}
		case 3:
		{
			PangoAttribute* _tmp10_ = NULL;
			_tmp10_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp10_;
			break;
		}
		case 4:
		{
			PangoAttribute* _tmp11_ = NULL;
			_tmp11_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x7fff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp11_;
			break;
		}
		case 5:
		{
			PangoAttribute* _tmp12_ = NULL;
			_tmp12_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp12_;
			break;
		}
		case 6:
		{
			PangoAttribute* _tmp13_ = NULL;
			_tmp13_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xffff, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp13_;
			break;
		}
		case 7:
		{
			PangoAttribute* _tmp14_ = NULL;
			_tmp14_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0xa0a0);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp14_;
			break;
		}
		default:
		case 8:
		{
			PangoAttribute* _tmp15_ = NULL;
			_tmp15_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp15_;
			break;
		}
	}
	_tmp16_ = color_attribute;
	_tmp16_->start_index = (guint) 0;
	_tmp17_ = color_attribute;
	_tmp18_ = G_MAXUINT;
	_tmp17_->end_index = _tmp18_;
	_tmp19_ = attributes;
	_tmp20_ = color_attribute;
	color_attribute = NULL;
	pango_attr_list_insert (_tmp19_, _tmp20_);
	_tmp21_ = pango_font_description_new ();
	font_desc = _tmp21_;
	pango_font_description_set_family (font_desc, "Sans");
	_tmp22_ = minefield_view_get_mine_size (self);
	_tmp23_ = _tmp22_;
	font_size = ((_tmp23_ - 2) * PANGO_SCALE) * 0.85;
	pango_font_description_set_absolute_size (font_desc, font_size);
	pango_font_description_set_weight (font_desc, PANGO_WEIGHT_BOLD);
	_tmp24_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (font_desc);
	font_attribute = _tmp24_;
	_tmp25_ = font_attribute;
	((PangoAttribute*) _tmp25_)->start_index = (guint) 0;
	_tmp26_ = font_attribute;
	_tmp27_ = G_MAXUINT;
	((PangoAttribute*) _tmp26_)->end_index = _tmp27_;
	_tmp28_ = attributes;
	_tmp29_ = font_attribute;
	font_attribute = NULL;
	pango_attr_list_insert (_tmp28_, (PangoAttribute*) _tmp29_);
	_tmp30_ = layout;
	_tmp31_ = attributes;
	pango_layout_set_attributes (_tmp30_, _tmp31_);
	_tmp32_ = minefield_view_get_mine_size (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = minefield_view_get_mine_size (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp33_, (gint) _tmp35_);
	surface = _tmp36_;
	_tmp37_ = cairo_create (surface);
	c = _tmp37_;
	_tmp38_ = layout;
	pango_layout_get_extents (_tmp38_, NULL, &_tmp39_);
	extent = _tmp39_;
	_tmp40_ = minefield_view_get_mine_size (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = extent;
	_tmp43_ = _tmp42_.width;
	dx = (((((gint) _tmp41_) - 2) - (_tmp43_ / PANGO_SCALE)) / 2) + 1;
	_tmp44_ = minefield_view_get_mine_size (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = extent;
	_tmp47_ = _tmp46_.height;
	dy = (((((gint) _tmp45_) - 2) - (_tmp47_ / PANGO_SCALE)) / 2) + 1;
	cairo_move_to (c, (gdouble) dx, (gdouble) dy);
	_tmp48_ = layout;
	pango_cairo_show_layout (c, _tmp48_);
	_tmp49_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp49_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (font_attribute);
	_pango_font_description_free0 (font_desc);
	_pango_attribute_destroy0 (color_attribute);
	_pango_attr_list_unref0 (attributes);
	_g_object_unref0 (layout);
	return result;
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->height;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_x_offset (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = minefield_view_get_mine_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_get_y_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = y;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = minefield_view_get_mine_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = minefield_view_get_mine_size (self);
	_tmp13_ = _tmp12_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp1_ + (_tmp2_ * _tmp4_)), (gint) (_tmp6_ + (_tmp7_ * _tmp9_)), (gint) _tmp11_, (gint) _tmp13_);
}


static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	gboolean _tmp12_;
	gboolean is_down;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_;
	gboolean _tmp20_;
	Minefield* _tmp45_;
	Minefield* _tmp46_;
	guint _tmp47_;
	guint _tmp48_;
	gboolean _tmp49_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp2_ = x;
	_tmp3_ = self->priv->selected_x;
	if (_tmp2_ == ((guint) _tmp3_)) {
		guint _tmp4_;
		gint _tmp5_;
		_tmp4_ = y;
		_tmp5_ = self->priv->selected_y;
		_tmp1_ = _tmp4_ == ((guint) _tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		FlagType _tmp11_ = 0;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = x;
		_tmp10_ = y;
		_tmp11_ = minefield_get_flag (_tmp8_, _tmp9_, _tmp10_);
		_tmp0_ = _tmp11_ != FLAG_TYPE_FLAG;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	is_down = _tmp12_;
	_tmp14_ = self->priv->selected_x;
	if (_tmp14_ >= 0) {
		Minefield* _tmp15_;
		Minefield* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp15_ = minefield_view_get_minefield (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->selected_x;
		_tmp18_ = self->priv->selected_y;
		_tmp19_ = minefield_is_cleared (_tmp16_, (guint) _tmp17_, (guint) _tmp18_);
		_tmp13_ = _tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		{
			Neighbour* neighbour_collection = NULL;
			gint neighbour_collection_length1 = 0;
			gint _neighbour_collection_size_ = 0;
			gint neighbour_it = 0;
			neighbour_collection = neighbour_map;
			neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
			for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
				Neighbour neighbour = {0};
				neighbour = neighbour_collection[neighbour_it];
				{
					gint _tmp21_;
					Neighbour _tmp22_;
					gint _tmp23_;
					gint nx;
					gint _tmp24_;
					Neighbour _tmp25_;
					gint _tmp26_;
					gint ny;
					Minefield* _tmp27_;
					Minefield* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					guint _tmp34_;
					gint _tmp35_;
					gboolean _tmp38_;
					gboolean _tmp44_;
					_tmp21_ = self->priv->selected_x;
					_tmp22_ = neighbour;
					_tmp23_ = _tmp22_.x;
					nx = _tmp21_ + _tmp23_;
					_tmp24_ = self->priv->selected_y;
					_tmp25_ = neighbour;
					_tmp26_ = _tmp25_.y;
					ny = _tmp24_ + _tmp26_;
					_tmp27_ = minefield_view_get_minefield (self);
					_tmp28_ = _tmp27_;
					_tmp29_ = nx;
					_tmp30_ = ny;
					_tmp31_ = minefield_is_location (_tmp28_, (guint) _tmp29_, (guint) _tmp30_);
					if (!_tmp31_) {
						continue;
					}
					_tmp34_ = x;
					_tmp35_ = nx;
					if (_tmp34_ == ((guint) _tmp35_)) {
						guint _tmp36_;
						gint _tmp37_;
						_tmp36_ = y;
						_tmp37_ = ny;
						_tmp33_ = _tmp36_ == ((guint) _tmp37_);
					} else {
						_tmp33_ = FALSE;
					}
					_tmp38_ = _tmp33_;
					if (_tmp38_) {
						Minefield* _tmp39_;
						Minefield* _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						FlagType _tmp43_ = 0;
						_tmp39_ = minefield_view_get_minefield (self);
						_tmp40_ = _tmp39_;
						_tmp41_ = nx;
						_tmp42_ = ny;
						_tmp43_ = minefield_get_flag (_tmp40_, (guint) _tmp41_, (guint) _tmp42_);
						_tmp32_ = _tmp43_ != FLAG_TYPE_FLAG;
					} else {
						_tmp32_ = FALSE;
					}
					_tmp44_ = _tmp32_;
					if (_tmp44_) {
						is_down = TRUE;
					}
				}
			}
		}
	}
	_tmp45_ = minefield_view_get_minefield (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = x;
	_tmp48_ = y;
	_tmp49_ = minefield_is_cleared (_tmp46_, _tmp47_, _tmp48_);
	if (_tmp49_) {
		GtkStateType _tmp50_ = 0;
		gboolean _tmp51_;
		GtkStyle* _tmp52_ = NULL;
		cairo_t* _tmp53_;
		GtkStateType _tmp54_;
		guint _tmp55_;
		guint _tmp56_;
		guint _tmp57_;
		guint _tmp58_;
		guint _tmp59_;
		guint _tmp64_;
		cairo_t* _tmp69_;
		guint _tmp70_;
		guint _tmp71_;
		cairo_t* _tmp72_;
		guint _tmp73_;
		guint _tmp74_;
		guint _tmp75_;
		guint _tmp76_;
		cairo_t* _tmp77_;
		guint _tmp78_;
		guint _tmp79_;
		cairo_t* _tmp80_;
		guint _tmp81_;
		guint _tmp82_;
		guint _tmp83_;
		guint _tmp84_;
		cairo_t* _tmp85_;
		cairo_t* _tmp86_;
		GtkStyle* _tmp87_ = NULL;
		GdkColor* _tmp88_;
		gint _tmp88__length1;
		GtkStateType _tmp89_ = 0;
		GdkColor _tmp90_;
		cairo_t* _tmp91_;
		gdouble* _tmp92_ = NULL;
		gdouble* dots;
		gint dots_length1;
		gint _dots_size_;
		cairo_t* _tmp93_;
		gdouble* _tmp94_;
		gint _tmp94__length1;
		cairo_t* _tmp95_;
		cairo_t* _tmp96_;
		Minefield* _tmp97_;
		Minefield* _tmp98_;
		gboolean _tmp99_;
		gboolean _tmp100_;
		Minefield* _tmp101_;
		Minefield* _tmp102_;
		guint _tmp103_;
		guint _tmp104_;
		gboolean _tmp105_ = FALSE;
		_tmp51_ = is_down;
		if (_tmp51_) {
			_tmp50_ = GTK_STATE_ACTIVE;
		} else {
			_tmp50_ = GTK_STATE_NORMAL;
		}
		_tmp52_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp53_ = cr;
		_tmp54_ = _tmp50_;
		_tmp55_ = minefield_view_get_mine_size (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = minefield_view_get_mine_size (self);
		_tmp58_ = _tmp57_;
		gtk_paint_box (_tmp52_, _tmp53_, _tmp54_, GTK_SHADOW_IN, (GtkWidget*) self, "button", 0, 0, (gint) _tmp56_, (gint) _tmp58_);
		_tmp59_ = y;
		if (_tmp59_ == ((guint) 0)) {
			cairo_t* _tmp60_;
			cairo_t* _tmp61_;
			guint _tmp62_;
			guint _tmp63_;
			_tmp60_ = cr;
			cairo_move_to (_tmp60_, (gdouble) 0, (gdouble) 0);
			_tmp61_ = cr;
			_tmp62_ = minefield_view_get_mine_size (self);
			_tmp63_ = _tmp62_;
			cairo_line_to (_tmp61_, (gdouble) (_tmp63_ - 1), (gdouble) 0);
		}
		_tmp64_ = x;
		if (_tmp64_ == ((guint) 0)) {
			cairo_t* _tmp65_;
			cairo_t* _tmp66_;
			guint _tmp67_;
			guint _tmp68_;
			_tmp65_ = cr;
			cairo_move_to (_tmp65_, (gdouble) 0, (gdouble) 0);
			_tmp66_ = cr;
			_tmp67_ = minefield_view_get_mine_size (self);
			_tmp68_ = _tmp67_;
			cairo_line_to (_tmp66_, (gdouble) 0, (gdouble) (_tmp68_ - 1));
		}
		_tmp69_ = cr;
		_tmp70_ = minefield_view_get_mine_size (self);
		_tmp71_ = _tmp70_;
		cairo_move_to (_tmp69_, (_tmp71_ - 1) + 0.5, 0.5);
		_tmp72_ = cr;
		_tmp73_ = minefield_view_get_mine_size (self);
		_tmp74_ = _tmp73_;
		_tmp75_ = minefield_view_get_mine_size (self);
		_tmp76_ = _tmp75_;
		cairo_line_to (_tmp72_, (_tmp74_ - 1) + 0.5, (_tmp76_ - 1) + 0.5);
		_tmp77_ = cr;
		_tmp78_ = minefield_view_get_mine_size (self);
		_tmp79_ = _tmp78_;
		cairo_move_to (_tmp77_, 0.5, (_tmp79_ - 1) + 0.5);
		_tmp80_ = cr;
		_tmp81_ = minefield_view_get_mine_size (self);
		_tmp82_ = _tmp81_;
		_tmp83_ = minefield_view_get_mine_size (self);
		_tmp84_ = _tmp83_;
		cairo_line_to (_tmp80_, (_tmp82_ - 1) + 0.5, (_tmp84_ - 1) + 0.5);
		_tmp85_ = cr;
		cairo_save (_tmp85_);
		_tmp86_ = cr;
		_tmp87_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp88_ = _tmp87_->dark;
		_tmp88__length1 = -1;
		_tmp89_ = gtk_widget_get_state ((GtkWidget*) self);
		_tmp90_ = _tmp88_[_tmp89_];
		gdk_cairo_set_source_color (_tmp86_, &_tmp90_);
		_tmp91_ = cr;
		cairo_set_line_width (_tmp91_, (gdouble) 1);
		_tmp92_ = g_new0 (gdouble, 2);
		_tmp92_[0] = (gdouble) 2;
		_tmp92_[1] = (gdouble) 2;
		dots = _tmp92_;
		dots_length1 = 2;
		_dots_size_ = dots_length1;
		_tmp93_ = cr;
		_tmp94_ = dots;
		_tmp94__length1 = dots_length1;
		cairo_set_dash (_tmp93_, _tmp94_, _tmp94__length1, (gdouble) 0);
		_tmp95_ = cr;
		cairo_stroke (_tmp95_);
		_tmp96_ = cr;
		cairo_restore (_tmp96_);
		_tmp97_ = minefield_view_get_minefield (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = minefield_get_paused (_tmp98_);
		_tmp100_ = _tmp99_;
		if (_tmp100_) {
			dots = (g_free (dots), NULL);
			return;
		}
		_tmp101_ = minefield_view_get_minefield (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = x;
		_tmp104_ = y;
		_tmp105_ = minefield_has_mine (_tmp102_, _tmp103_, _tmp104_);
		if (_tmp105_) {
			cairo_pattern_t* _tmp106_;
			cairo_t* _tmp110_;
			cairo_pattern_t* _tmp111_;
			cairo_t* _tmp112_;
			guint _tmp113_;
			guint _tmp114_;
			guint _tmp115_;
			guint _tmp116_;
			cairo_t* _tmp117_;
			_tmp106_ = self->priv->bang_pattern;
			if (_tmp106_ == NULL) {
				cairo_t* _tmp107_;
				GamesPreimage* _tmp108_;
				cairo_pattern_t* _tmp109_ = NULL;
				_tmp107_ = cr;
				_tmp108_ = self->priv->bang_preimage;
				_tmp109_ = minefield_view_render_preimage_pattern (self, _tmp107_, _tmp108_);
				_cairo_pattern_destroy0 (self->priv->bang_pattern);
				self->priv->bang_pattern = _tmp109_;
			}
			_tmp110_ = cr;
			_tmp111_ = self->priv->bang_pattern;
			cairo_set_source (_tmp110_, _tmp111_);
			_tmp112_ = cr;
			_tmp113_ = minefield_view_get_mine_size (self);
			_tmp114_ = _tmp113_;
			_tmp115_ = minefield_view_get_mine_size (self);
			_tmp116_ = _tmp115_;
			cairo_rectangle (_tmp112_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp114_, (gdouble) _tmp116_);
			_tmp117_ = cr;
			cairo_fill (_tmp117_);
		} else {
			gboolean _tmp118_ = FALSE;
			gboolean _tmp119_;
			gboolean _tmp125_;
			Minefield* _tmp138_;
			Minefield* _tmp139_;
			guint _tmp140_;
			guint _tmp141_;
			guint _tmp142_ = 0U;
			guint n;
			guint _tmp143_;
			_tmp119_ = self->priv->use_overmine_warning;
			if (_tmp119_) {
				Minefield* _tmp120_;
				Minefield* _tmp121_;
				guint _tmp122_;
				guint _tmp123_;
				gboolean _tmp124_ = FALSE;
				_tmp120_ = minefield_view_get_minefield (self);
				_tmp121_ = _tmp120_;
				_tmp122_ = x;
				_tmp123_ = y;
				_tmp124_ = minefield_has_flag_warning (_tmp121_, _tmp122_, _tmp123_);
				_tmp118_ = _tmp124_;
			} else {
				_tmp118_ = FALSE;
			}
			_tmp125_ = _tmp118_;
			if (_tmp125_) {
				cairo_pattern_t* _tmp126_;
				cairo_t* _tmp130_;
				cairo_pattern_t* _tmp131_;
				cairo_t* _tmp132_;
				guint _tmp133_;
				guint _tmp134_;
				guint _tmp135_;
				guint _tmp136_;
				cairo_t* _tmp137_;
				_tmp126_ = self->priv->warning_pattern;
				if (_tmp126_ == NULL) {
					cairo_t* _tmp127_;
					GamesPreimage* _tmp128_;
					cairo_pattern_t* _tmp129_ = NULL;
					_tmp127_ = cr;
					_tmp128_ = self->priv->warning_preimage;
					_tmp129_ = minefield_view_render_preimage_pattern (self, _tmp127_, _tmp128_);
					_cairo_pattern_destroy0 (self->priv->warning_pattern);
					self->priv->warning_pattern = _tmp129_;
				}
				_tmp130_ = cr;
				_tmp131_ = self->priv->warning_pattern;
				cairo_set_source (_tmp130_, _tmp131_);
				_tmp132_ = cr;
				_tmp133_ = minefield_view_get_mine_size (self);
				_tmp134_ = _tmp133_;
				_tmp135_ = minefield_view_get_mine_size (self);
				_tmp136_ = _tmp135_;
				cairo_rectangle (_tmp132_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp134_, (gdouble) _tmp136_);
				_tmp137_ = cr;
				cairo_fill (_tmp137_);
			}
			_tmp138_ = minefield_view_get_minefield (self);
			_tmp139_ = _tmp138_;
			_tmp140_ = x;
			_tmp141_ = y;
			_tmp142_ = minefield_get_n_adjacent_mines (_tmp139_, _tmp140_, _tmp141_);
			n = _tmp142_;
			_tmp143_ = n;
			if (_tmp143_ != ((guint) 0)) {
				cairo_pattern_t** _tmp144_;
				gint _tmp144__length1;
				guint _tmp145_;
				cairo_pattern_t* _tmp146_;
				cairo_t* _tmp152_;
				cairo_pattern_t** _tmp153_;
				gint _tmp153__length1;
				guint _tmp154_;
				cairo_pattern_t* _tmp155_;
				cairo_t* _tmp156_;
				guint _tmp157_;
				guint _tmp158_;
				guint _tmp159_;
				guint _tmp160_;
				cairo_t* _tmp161_;
				_tmp144_ = self->priv->number_patterns;
				_tmp144__length1 = self->priv->number_patterns_length1;
				_tmp145_ = n;
				_tmp146_ = _tmp144_[_tmp145_ - 1];
				if (_tmp146_ == NULL) {
					cairo_pattern_t** _tmp147_;
					gint _tmp147__length1;
					guint _tmp148_;
					guint _tmp149_;
					cairo_pattern_t* _tmp150_ = NULL;
					cairo_pattern_t* _tmp151_;
					_tmp147_ = self->priv->number_patterns;
					_tmp147__length1 = self->priv->number_patterns_length1;
					_tmp148_ = n;
					_tmp149_ = n;
					_tmp150_ = minefield_view_render_number_pattern (self, _tmp149_);
					_cairo_pattern_destroy0 (_tmp147_[_tmp148_ - 1]);
					_tmp147_[_tmp148_ - 1] = _tmp150_;
					_tmp151_ = _tmp147_[_tmp148_ - 1];
				}
				_tmp152_ = cr;
				_tmp153_ = self->priv->number_patterns;
				_tmp153__length1 = self->priv->number_patterns_length1;
				_tmp154_ = n;
				_tmp155_ = _tmp153_[_tmp154_ - 1];
				cairo_set_source (_tmp152_, _tmp155_);
				_tmp156_ = cr;
				_tmp157_ = minefield_view_get_mine_size (self);
				_tmp158_ = _tmp157_;
				_tmp159_ = minefield_view_get_mine_size (self);
				_tmp160_ = _tmp159_;
				cairo_rectangle (_tmp156_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp158_, (gdouble) _tmp160_);
				_tmp161_ = cr;
				cairo_fill (_tmp161_);
			}
		}
		dots = (g_free (dots), NULL);
	} else {
		GtkStateType _tmp162_ = 0;
		gboolean _tmp163_;
		GtkShadowType _tmp164_ = 0;
		gboolean _tmp165_;
		GtkStyle* _tmp166_ = NULL;
		cairo_t* _tmp167_;
		GtkStateType _tmp168_;
		GtkShadowType _tmp169_;
		guint _tmp170_;
		guint _tmp171_;
		guint _tmp172_;
		guint _tmp173_;
		Minefield* _tmp174_;
		Minefield* _tmp175_;
		gboolean _tmp176_;
		gboolean _tmp177_;
		Minefield* _tmp178_;
		Minefield* _tmp179_;
		guint _tmp180_;
		guint _tmp181_;
		FlagType _tmp182_ = 0;
		_tmp163_ = is_down;
		if (_tmp163_) {
			_tmp162_ = GTK_STATE_ACTIVE;
		} else {
			_tmp162_ = GTK_STATE_SELECTED;
		}
		_tmp165_ = is_down;
		if (_tmp165_) {
			_tmp164_ = GTK_SHADOW_IN;
		} else {
			_tmp164_ = GTK_SHADOW_OUT;
		}
		_tmp166_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp167_ = cr;
		_tmp168_ = _tmp162_;
		_tmp169_ = _tmp164_;
		_tmp170_ = minefield_view_get_mine_size (self);
		_tmp171_ = _tmp170_;
		_tmp172_ = minefield_view_get_mine_size (self);
		_tmp173_ = _tmp172_;
		gtk_paint_box (_tmp166_, _tmp167_, _tmp168_, _tmp169_, (GtkWidget*) self, "button", 0, 0, (gint) _tmp171_, (gint) _tmp173_);
		_tmp174_ = minefield_view_get_minefield (self);
		_tmp175_ = _tmp174_;
		_tmp176_ = minefield_get_paused (_tmp175_);
		_tmp177_ = _tmp176_;
		if (_tmp177_) {
			return;
		}
		_tmp178_ = minefield_view_get_minefield (self);
		_tmp179_ = _tmp178_;
		_tmp180_ = x;
		_tmp181_ = y;
		_tmp182_ = minefield_get_flag (_tmp179_, _tmp180_, _tmp181_);
		if (_tmp182_ == FLAG_TYPE_FLAG) {
			cairo_pattern_t* _tmp183_;
			cairo_t* _tmp187_;
			cairo_pattern_t* _tmp188_;
			cairo_t* _tmp189_;
			guint _tmp190_;
			guint _tmp191_;
			guint _tmp192_;
			guint _tmp193_;
			cairo_t* _tmp194_;
			gboolean _tmp195_ = FALSE;
			Minefield* _tmp196_;
			Minefield* _tmp197_;
			gboolean _tmp198_;
			gboolean _tmp204_;
			_tmp183_ = self->priv->flag_pattern;
			if (_tmp183_ == NULL) {
				cairo_t* _tmp184_;
				GamesPreimage* _tmp185_;
				cairo_pattern_t* _tmp186_ = NULL;
				_tmp184_ = cr;
				_tmp185_ = self->priv->flag_preimage;
				_tmp186_ = minefield_view_render_preimage_pattern (self, _tmp184_, _tmp185_);
				_cairo_pattern_destroy0 (self->priv->flag_pattern);
				self->priv->flag_pattern = _tmp186_;
			}
			_tmp187_ = cr;
			_tmp188_ = self->priv->flag_pattern;
			cairo_set_source (_tmp187_, _tmp188_);
			_tmp189_ = cr;
			_tmp190_ = minefield_view_get_mine_size (self);
			_tmp191_ = _tmp190_;
			_tmp192_ = minefield_view_get_mine_size (self);
			_tmp193_ = _tmp192_;
			cairo_rectangle (_tmp189_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp191_, (gdouble) _tmp193_);
			_tmp194_ = cr;
			cairo_fill (_tmp194_);
			_tmp196_ = minefield_view_get_minefield (self);
			_tmp197_ = _tmp196_;
			_tmp198_ = _tmp197_->exploded;
			if (_tmp198_) {
				Minefield* _tmp199_;
				Minefield* _tmp200_;
				guint _tmp201_;
				guint _tmp202_;
				gboolean _tmp203_ = FALSE;
				_tmp199_ = minefield_view_get_minefield (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = x;
				_tmp202_ = y;
				_tmp203_ = minefield_has_mine (_tmp200_, _tmp201_, _tmp202_);
				_tmp195_ = !_tmp203_;
			} else {
				_tmp195_ = FALSE;
			}
			_tmp204_ = _tmp195_;
			if (_tmp204_) {
				guint _tmp205_;
				guint _tmp206_;
				gdouble x1;
				guint _tmp207_;
				guint _tmp208_;
				gdouble y1;
				guint _tmp209_;
				guint _tmp210_;
				gdouble x2;
				guint _tmp211_;
				guint _tmp212_;
				gdouble y2;
				cairo_t* _tmp213_;
				gdouble _tmp214_;
				gdouble _tmp215_;
				cairo_t* _tmp216_;
				gdouble _tmp217_;
				gdouble _tmp218_;
				cairo_t* _tmp219_;
				gdouble _tmp220_;
				gdouble _tmp221_;
				cairo_t* _tmp222_;
				gdouble _tmp223_;
				gdouble _tmp224_;
				cairo_t* _tmp225_;
				cairo_t* _tmp226_;
				GtkStyle* _tmp227_ = NULL;
				GdkColor _tmp228_;
				cairo_t* _tmp229_;
				guint _tmp230_;
				guint _tmp231_;
				gdouble _tmp232_ = 0.0;
				cairo_t* _tmp233_;
				cairo_t* _tmp234_;
				cairo_t* _tmp235_;
				cairo_t* _tmp236_;
				_tmp205_ = minefield_view_get_mine_size (self);
				_tmp206_ = _tmp205_;
				x1 = 0.1 * _tmp206_;
				_tmp207_ = minefield_view_get_mine_size (self);
				_tmp208_ = _tmp207_;
				y1 = 0.1 * _tmp208_;
				_tmp209_ = minefield_view_get_mine_size (self);
				_tmp210_ = _tmp209_;
				x2 = 0.9 * _tmp210_;
				_tmp211_ = minefield_view_get_mine_size (self);
				_tmp212_ = _tmp211_;
				y2 = 0.9 * _tmp212_;
				_tmp213_ = cr;
				_tmp214_ = x1;
				_tmp215_ = y1;
				cairo_move_to (_tmp213_, _tmp214_, _tmp215_);
				_tmp216_ = cr;
				_tmp217_ = x2;
				_tmp218_ = y2;
				cairo_line_to (_tmp216_, _tmp217_, _tmp218_);
				_tmp219_ = cr;
				_tmp220_ = x1;
				_tmp221_ = y2;
				cairo_move_to (_tmp219_, _tmp220_, _tmp221_);
				_tmp222_ = cr;
				_tmp223_ = x2;
				_tmp224_ = y1;
				cairo_line_to (_tmp222_, _tmp223_, _tmp224_);
				_tmp225_ = cr;
				cairo_save (_tmp225_);
				_tmp226_ = cr;
				_tmp227_ = gtk_widget_get_style ((GtkWidget*) self);
				_tmp228_ = _tmp227_->black;
				gdk_cairo_set_source_color (_tmp226_, &_tmp228_);
				_tmp229_ = cr;
				_tmp230_ = minefield_view_get_mine_size (self);
				_tmp231_ = _tmp230_;
				_tmp232_ = MAX ((gdouble) 1, 0.1 * _tmp231_);
				cairo_set_line_width (_tmp229_, _tmp232_);
				_tmp233_ = cr;
				cairo_set_line_join (_tmp233_, CAIRO_LINE_JOIN_ROUND);
				_tmp234_ = cr;
				cairo_set_line_cap (_tmp234_, CAIRO_LINE_CAP_ROUND);
				_tmp235_ = cr;
				cairo_stroke (_tmp235_);
				_tmp236_ = cr;
				cairo_restore (_tmp236_);
			}
		} else {
			gboolean _tmp237_ = FALSE;
			Minefield* _tmp238_;
			Minefield* _tmp239_;
			gboolean _tmp240_;
			gboolean _tmp246_;
			_tmp238_ = minefield_view_get_minefield (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = _tmp239_->exploded;
			if (_tmp240_) {
				Minefield* _tmp241_;
				Minefield* _tmp242_;
				guint _tmp243_;
				guint _tmp244_;
				gboolean _tmp245_ = FALSE;
				_tmp241_ = minefield_view_get_minefield (self);
				_tmp242_ = _tmp241_;
				_tmp243_ = x;
				_tmp244_ = y;
				_tmp245_ = minefield_has_mine (_tmp242_, _tmp243_, _tmp244_);
				_tmp237_ = _tmp245_;
			} else {
				_tmp237_ = FALSE;
			}
			_tmp246_ = _tmp237_;
			if (_tmp246_) {
				cairo_pattern_t* _tmp247_;
				cairo_t* _tmp251_;
				cairo_pattern_t* _tmp252_;
				cairo_t* _tmp253_;
				guint _tmp254_;
				guint _tmp255_;
				guint _tmp256_;
				guint _tmp257_;
				cairo_t* _tmp258_;
				_tmp247_ = self->priv->mine_pattern;
				if (_tmp247_ == NULL) {
					cairo_t* _tmp248_;
					GamesPreimage* _tmp249_;
					cairo_pattern_t* _tmp250_ = NULL;
					_tmp248_ = cr;
					_tmp249_ = self->priv->mine_preimage;
					_tmp250_ = minefield_view_render_preimage_pattern (self, _tmp248_, _tmp249_);
					_cairo_pattern_destroy0 (self->priv->mine_pattern);
					self->priv->mine_pattern = _tmp250_;
				}
				_tmp251_ = cr;
				_tmp252_ = self->priv->mine_pattern;
				cairo_set_source (_tmp251_, _tmp252_);
				_tmp253_ = cr;
				_tmp254_ = minefield_view_get_mine_size (self);
				_tmp255_ = _tmp254_;
				_tmp256_ = minefield_view_get_mine_size (self);
				_tmp257_ = _tmp256_;
				cairo_rectangle (_tmp253_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp255_, (gdouble) _tmp257_);
				_tmp258_ = cr;
				cairo_fill (_tmp258_);
			} else {
				Minefield* _tmp259_;
				Minefield* _tmp260_;
				guint _tmp261_;
				guint _tmp262_;
				FlagType _tmp263_ = 0;
				_tmp259_ = minefield_view_get_minefield (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = x;
				_tmp262_ = y;
				_tmp263_ = minefield_get_flag (_tmp260_, _tmp261_, _tmp262_);
				if (_tmp263_ == FLAG_TYPE_MAYBE) {
					cairo_pattern_t* _tmp264_;
					cairo_t* _tmp268_;
					cairo_pattern_t* _tmp269_;
					cairo_t* _tmp270_;
					guint _tmp271_;
					guint _tmp272_;
					guint _tmp273_;
					guint _tmp274_;
					cairo_t* _tmp275_;
					_tmp264_ = self->priv->question_pattern;
					if (_tmp264_ == NULL) {
						cairo_t* _tmp265_;
						GamesPreimage* _tmp266_;
						cairo_pattern_t* _tmp267_ = NULL;
						_tmp265_ = cr;
						_tmp266_ = self->priv->question_preimage;
						_tmp267_ = minefield_view_render_preimage_pattern (self, _tmp265_, _tmp266_);
						_cairo_pattern_destroy0 (self->priv->question_pattern);
						self->priv->question_pattern = _tmp267_;
					}
					_tmp268_ = cr;
					_tmp269_ = self->priv->question_pattern;
					cairo_set_source (_tmp268_, _tmp269_);
					_tmp270_ = cr;
					_tmp271_ = minefield_view_get_mine_size (self);
					_tmp272_ = _tmp271_;
					_tmp273_ = minefield_view_get_mine_size (self);
					_tmp274_ = _tmp273_;
					cairo_rectangle (_tmp270_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp272_, (gdouble) _tmp274_);
					_tmp275_ = cr;
					cairo_fill (_tmp275_);
				}
			}
		}
	}
}


static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr) {
	MinefieldView * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Minefield* _tmp43_;
	Minefield* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_size;
	_tmp1_ = minefield_view_get_mine_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = minefield_view_get_mine_size (self);
		_tmp4_ = _tmp3_;
		self->priv->render_size = _tmp4_;
		_cairo_pattern_destroy0 (self->priv->flag_pattern);
		self->priv->flag_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->mine_pattern);
		self->priv->mine_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->question_pattern);
		self->priv->question_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->bang_pattern);
		self->priv->bang_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->warning_pattern);
		self->priv->warning_pattern = NULL;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp5_;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_;
					gint _tmp8_;
					cairo_pattern_t** _tmp9_;
					gint _tmp9__length1;
					cairo_pattern_t** _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					cairo_pattern_t* _tmp12_;
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = self->priv->number_patterns;
					_tmp9__length1 = self->priv->number_patterns_length1;
					if (!(_tmp8_ < _tmp9__length1)) {
						break;
					}
					_tmp10_ = self->priv->number_patterns;
					_tmp10__length1 = self->priv->number_patterns_length1;
					_tmp11_ = i;
					_cairo_pattern_destroy0 (_tmp10_[_tmp11_]);
					_tmp10_[_tmp11_] = NULL;
					_tmp12_ = _tmp10_[_tmp11_];
				}
			}
		}
	}
	{
		gint x;
		x = 0;
		{
			gboolean _tmp13_;
			_tmp13_ = TRUE;
			while (TRUE) {
				gboolean _tmp14_;
				gint _tmp16_;
				Minefield* _tmp17_;
				Minefield* _tmp18_;
				guint _tmp19_;
				_tmp14_ = _tmp13_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = x;
					x = _tmp15_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp16_ = x;
				_tmp17_ = minefield_view_get_minefield (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_->width;
				if (!(((guint) _tmp16_) < _tmp19_)) {
					break;
				}
				{
					gint y;
					y = 0;
					{
						gboolean _tmp20_;
						_tmp20_ = TRUE;
						while (TRUE) {
							gboolean _tmp21_;
							gint _tmp23_;
							Minefield* _tmp24_;
							Minefield* _tmp25_;
							guint _tmp26_;
							cairo_t* _tmp27_;
							cairo_t* _tmp28_;
							guint _tmp29_;
							guint _tmp30_;
							gint _tmp31_;
							guint _tmp32_;
							guint _tmp33_;
							guint _tmp34_;
							guint _tmp35_;
							gint _tmp36_;
							guint _tmp37_;
							guint _tmp38_;
							cairo_t* _tmp39_;
							gint _tmp40_;
							gint _tmp41_;
							cairo_t* _tmp42_;
							_tmp21_ = _tmp20_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = y;
								y = _tmp22_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp23_ = y;
							_tmp24_ = minefield_view_get_minefield (self);
							_tmp25_ = _tmp24_;
							_tmp26_ = _tmp25_->height;
							if (!(((guint) _tmp23_) < _tmp26_)) {
								break;
							}
							_tmp27_ = cr;
							cairo_save (_tmp27_);
							_tmp28_ = cr;
							_tmp29_ = minefield_view_get_x_offset (self);
							_tmp30_ = _tmp29_;
							_tmp31_ = x;
							_tmp32_ = minefield_view_get_mine_size (self);
							_tmp33_ = _tmp32_;
							_tmp34_ = minefield_view_get_y_offset (self);
							_tmp35_ = _tmp34_;
							_tmp36_ = y;
							_tmp37_ = minefield_view_get_mine_size (self);
							_tmp38_ = _tmp37_;
							cairo_translate (_tmp28_, (gdouble) (_tmp30_ + (_tmp31_ * _tmp33_)), (gdouble) (_tmp35_ + (_tmp36_ * _tmp38_)));
							_tmp39_ = cr;
							_tmp40_ = x;
							_tmp41_ = y;
							minefield_view_draw_square (self, _tmp39_, (guint) _tmp40_, (guint) _tmp41_);
							_tmp42_ = cr;
							cairo_restore (_tmp42_);
						}
					}
				}
			}
		}
	}
	_tmp43_ = minefield_view_get_minefield (self);
	_tmp44_ = _tmp43_;
	_tmp45_ = minefield_get_paused (_tmp44_);
	_tmp46_ = _tmp45_;
	if (_tmp46_) {
		cairo_t* _tmp47_;
		cairo_t* _tmp48_;
		cairo_t* _tmp49_;
		cairo_t* _tmp50_;
		gint _tmp51_ = 0;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_;
		gchar* text;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp54_;
		const gchar* _tmp55_;
		cairo_text_extents_t _tmp56_ = {0};
		cairo_t* _tmp57_;
		gint _tmp58_ = 0;
		cairo_text_extents_t _tmp59_;
		gdouble _tmp60_;
		gint _tmp61_ = 0;
		cairo_text_extents_t _tmp62_;
		gdouble _tmp63_;
		cairo_t* _tmp64_;
		cairo_t* _tmp65_;
		const gchar* _tmp66_;
		_tmp47_ = cr;
		cairo_set_source_rgba (_tmp47_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp48_ = cr;
		cairo_paint (_tmp48_);
		_tmp49_ = cr;
		cairo_select_font_face (_tmp49_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp50_ = cr;
		_tmp51_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp50_, _tmp51_ * 0.125);
		_tmp52_ = _ ("Paused");
		_tmp53_ = g_strdup (_tmp52_);
		text = _tmp53_;
		_tmp54_ = cr;
		_tmp55_ = text;
		cairo_text_extents (_tmp54_, _tmp55_, &_tmp56_);
		extents = _tmp56_;
		_tmp57_ = cr;
		_tmp58_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp59_ = extents;
		_tmp60_ = _tmp59_.width;
		_tmp61_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp62_ = extents;
		_tmp63_ = _tmp62_.height;
		cairo_move_to (_tmp57_, (_tmp58_ - _tmp60_) / 2.0, (_tmp61_ + _tmp63_) / 2.0);
		_tmp64_ = cr;
		cairo_set_source_rgb (_tmp64_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp65_ = cr;
		_tmp66_ = text;
		cairo_show_text (_tmp65_, _tmp66_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	FlagType _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_get_flag (_tmp1_, _tmp2_, _tmp3_);
	switch (_tmp4_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp5_ = FALSE;
			Minefield* _tmp6_;
			Minefield* _tmp7_;
			guint _tmp8_;
			guint _tmp9_;
			Minefield* _tmp10_;
			Minefield* _tmp11_;
			guint _tmp12_;
			gboolean _tmp14_;
			_tmp6_ = minefield_view_get_minefield (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = minefield_get_n_flags (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = minefield_view_get_minefield (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_->n_mines;
			if (_tmp9_ >= _tmp12_) {
				gboolean _tmp13_;
				_tmp13_ = self->priv->use_question_marks;
				_tmp5_ = _tmp13_;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp14_ = _tmp5_;
			if (_tmp14_) {
				Minefield* _tmp15_;
				Minefield* _tmp16_;
				guint _tmp17_;
				guint _tmp18_;
				_tmp15_ = minefield_view_get_minefield (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = x;
				_tmp18_ = y;
				minefield_set_flag (_tmp16_, _tmp17_, _tmp18_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp19_;
				Minefield* _tmp20_;
				guint _tmp21_;
				guint _tmp22_;
				_tmp19_ = minefield_view_get_minefield (self);
				_tmp20_ = _tmp19_;
				_tmp21_ = x;
				_tmp22_ = y;
				minefield_set_flag (_tmp20_, _tmp21_, _tmp22_, FLAG_TYPE_FLAG);
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Minefield* _tmp23_;
			Minefield* _tmp24_;
			guint _tmp25_;
			guint _tmp26_;
			_tmp23_ = minefield_view_get_minefield (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = x;
			_tmp26_ = y;
			minefield_set_flag (_tmp24_, _tmp25_, _tmp26_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			gboolean _tmp27_;
			_tmp27_ = self->priv->use_question_marks;
			if (_tmp27_) {
				Minefield* _tmp28_;
				Minefield* _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = x;
				_tmp31_ = y;
				minefield_set_flag (_tmp29_, _tmp30_, _tmp31_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp32_;
				Minefield* _tmp33_;
				guint _tmp34_;
				guint _tmp35_;
				_tmp32_ = minefield_view_get_minefield (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = x;
				_tmp35_ = y;
				minefield_set_flag (_tmp33_, _tmp34_, _tmp35_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp0_;
				Neighbour _tmp1_;
				gint _tmp2_;
				guint nx;
				guint _tmp3_;
				Neighbour _tmp4_;
				gint _tmp5_;
				guint ny;
				Minefield* _tmp6_;
				Minefield* _tmp7_;
				guint _tmp8_;
				guint _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = _tmp0_ + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = _tmp3_ + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					guint _tmp11_;
					guint _tmp12_;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, _tmp11_, _tmp12_);
				}
			}
		}
	}
}


static gpointer _minefield_ref0 (gpointer self) {
	return self ? minefield_ref (self) : NULL;
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_;
	Minefield* _tmp12_;
	Minefield* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	guint _tmp16_ = 0U;
	guint n_mines;
	guint n_flags;
	guint n_unknown;
	gboolean do_clear;
	guint _tmp40_;
	guint _tmp41_;
	Minefield* _tmp47_;
	Minefield* _tmp48_;
	Minefield* _tmp49_;
	Minefield* m;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_;
		Minefield* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		return;
	}
	_tmp12_ = minefield_view_get_minefield (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = x;
	_tmp15_ = y;
	_tmp16_ = minefield_get_n_adjacent_mines (_tmp13_, _tmp14_, _tmp15_);
	n_mines = _tmp16_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp17_;
				Neighbour _tmp18_;
				gint _tmp19_;
				guint nx;
				guint _tmp20_;
				Neighbour _tmp21_;
				gint _tmp22_;
				guint ny;
				Minefield* _tmp23_;
				Minefield* _tmp24_;
				guint _tmp25_;
				guint _tmp26_;
				gboolean _tmp27_ = FALSE;
				Minefield* _tmp28_;
				Minefield* _tmp29_;
				guint _tmp30_;
				guint _tmp31_;
				FlagType _tmp32_ = 0;
				Minefield* _tmp34_;
				Minefield* _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				gboolean _tmp38_ = FALSE;
				_tmp17_ = x;
				_tmp18_ = neighbour;
				_tmp19_ = _tmp18_.x;
				nx = _tmp17_ + _tmp19_;
				_tmp20_ = y;
				_tmp21_ = neighbour;
				_tmp22_ = _tmp21_.y;
				ny = _tmp20_ + _tmp22_;
				_tmp23_ = minefield_view_get_minefield (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = nx;
				_tmp26_ = ny;
				_tmp27_ = minefield_is_location (_tmp24_, _tmp25_, _tmp26_);
				if (!_tmp27_) {
					continue;
				}
				_tmp28_ = minefield_view_get_minefield (self);
				_tmp29_ = _tmp28_;
				_tmp30_ = nx;
				_tmp31_ = ny;
				_tmp32_ = minefield_get_flag (_tmp29_, _tmp30_, _tmp31_);
				if (_tmp32_ == FLAG_TYPE_FLAG) {
					guint _tmp33_;
					_tmp33_ = n_flags;
					n_flags = _tmp33_ + 1;
				}
				_tmp34_ = minefield_view_get_minefield (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = nx;
				_tmp37_ = ny;
				_tmp38_ = minefield_is_cleared (_tmp35_, _tmp36_, _tmp37_);
				if (!_tmp38_) {
					guint _tmp39_;
					_tmp39_ = n_unknown;
					n_unknown = _tmp39_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp40_ = n_mines;
	_tmp41_ = n_flags;
	if (_tmp40_ == _tmp41_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_;
		gboolean _tmp46_;
		_tmp43_ = self->priv->use_autoflag;
		if (_tmp43_) {
			guint _tmp44_;
			guint _tmp45_;
			_tmp44_ = n_unknown;
			_tmp45_ = n_mines;
			_tmp42_ = _tmp44_ == _tmp45_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp46_ = _tmp42_;
		if (_tmp46_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp47_ = minefield_view_get_minefield (self);
	_tmp48_ = _tmp47_;
	_tmp49_ = _minefield_ref0 (_tmp48_);
	m = _tmp49_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				guint _tmp50_;
				Neighbour _tmp51_;
				gint _tmp52_;
				guint nx;
				guint _tmp53_;
				Neighbour _tmp54_;
				gint _tmp55_;
				guint ny;
				Minefield* _tmp56_;
				guint _tmp57_;
				guint _tmp58_;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_;
				gboolean _tmp66_;
				_tmp50_ = x;
				_tmp51_ = neighbour;
				_tmp52_ = _tmp51_.x;
				nx = _tmp50_ + _tmp52_;
				_tmp53_ = y;
				_tmp54_ = neighbour;
				_tmp55_ = _tmp54_.y;
				ny = _tmp53_ + _tmp55_;
				_tmp56_ = m;
				_tmp57_ = nx;
				_tmp58_ = ny;
				_tmp59_ = minefield_is_location (_tmp56_, _tmp57_, _tmp58_);
				if (!_tmp59_) {
					continue;
				}
				_tmp61_ = do_clear;
				if (_tmp61_) {
					Minefield* _tmp62_;
					guint _tmp63_;
					guint _tmp64_;
					FlagType _tmp65_ = 0;
					_tmp62_ = m;
					_tmp63_ = nx;
					_tmp64_ = ny;
					_tmp65_ = minefield_get_flag (_tmp62_, _tmp63_, _tmp64_);
					_tmp60_ = _tmp65_ != FLAG_TYPE_FLAG;
				} else {
					_tmp60_ = FALSE;
				}
				_tmp66_ = _tmp60_;
				if (_tmp66_) {
					Minefield* _tmp67_;
					guint _tmp68_;
					guint _tmp69_;
					_tmp67_ = m;
					_tmp68_ = nx;
					_tmp69_ = ny;
					minefield_clear_mine (_tmp67_, _tmp68_, _tmp69_);
				} else {
					Minefield* _tmp70_;
					guint _tmp71_;
					guint _tmp72_;
					_tmp70_ = m;
					_tmp71_ = nx;
					_tmp72_ = ny;
					minefield_set_flag (_tmp70_, _tmp71_, _tmp72_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_minefield_unref0 (m);
}


static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton _tmp0_;
	GdkEventType _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp16_;
	GdkEventButton _tmp17_;
	gdouble _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gdouble _tmp23_ = 0.0;
	gint x;
	GdkEventButton _tmp24_;
	gdouble _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	gdouble _tmp30_ = 0.0;
	gint y;
	Minefield* _tmp31_;
	Minefield* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GdkEventButton _tmp37_;
	guint _tmp38_;
	gboolean _tmp45_;
	GdkEventButton _tmp48_;
	guint _tmp49_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	_tmp11_ = _tmp3_;
	if (_tmp11_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = minefield_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = _tmp15_;
	}
	_tmp16_ = _tmp2_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = *event;
	_tmp18_ = _tmp17_.x;
	_tmp19_ = minefield_view_get_x_offset (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = minefield_view_get_mine_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = floor ((_tmp18_ - _tmp20_) / _tmp22_);
	x = (gint) _tmp23_;
	_tmp24_ = *event;
	_tmp25_ = _tmp24_.y;
	_tmp26_ = minefield_view_get_y_offset (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = minefield_view_get_mine_size (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = floor ((_tmp25_ - _tmp27_) / _tmp29_);
	y = (gint) _tmp30_;
	_tmp31_ = minefield_view_get_minefield (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = x;
	_tmp34_ = y;
	_tmp35_ = minefield_is_location (_tmp32_, (guint) _tmp33_, (guint) _tmp34_);
	if (!_tmp35_) {
		result = FALSE;
		return result;
	}
	_tmp37_ = *event;
	_tmp38_ = _tmp37_.button;
	if (_tmp38_ == ((guint) 3)) {
		_tmp36_ = TRUE;
	} else {
		gboolean _tmp39_ = FALSE;
		GdkEventButton _tmp40_;
		guint _tmp41_;
		gboolean _tmp44_;
		_tmp40_ = *event;
		_tmp41_ = _tmp40_.button;
		if (_tmp41_ == ((guint) 1)) {
			GdkEventButton _tmp42_;
			GdkModifierType _tmp43_;
			_tmp42_ = *event;
			_tmp43_ = _tmp42_.state;
			_tmp39_ = (_tmp43_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp39_ = FALSE;
		}
		_tmp44_ = _tmp39_;
		_tmp36_ = _tmp44_;
	}
	_tmp45_ = _tmp36_;
	if (_tmp45_) {
		gint _tmp46_;
		gint _tmp47_;
		_tmp46_ = x;
		_tmp47_ = y;
		minefield_view_toggle_mark (self, (guint) _tmp46_, (guint) _tmp47_);
		result = FALSE;
		return result;
	}
	_tmp48_ = *event;
	_tmp49_ = _tmp48_.button;
	if (_tmp49_ == ((guint) 1)) {
		gint _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		Minefield* _tmp54_;
		Minefield* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gboolean _tmp58_ = FALSE;
		_tmp50_ = x;
		self->priv->selected_x = _tmp50_;
		_tmp51_ = y;
		self->priv->selected_y = _tmp51_;
		_tmp52_ = x;
		_tmp53_ = y;
		minefield_view_redraw_sector_cb (self, (guint) _tmp52_, (guint) _tmp53_);
		g_signal_emit_by_name (self, "look");
		_tmp54_ = minefield_view_get_minefield (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = x;
		_tmp57_ = y;
		_tmp58_ = minefield_is_cleared (_tmp55_, (guint) _tmp56_, (guint) _tmp57_);
		if (_tmp58_) {
			gint _tmp59_;
			gint _tmp60_;
			_tmp59_ = x;
			_tmp60_ = y;
			minefield_view_redraw_adjacent (self, (guint) _tmp59_, (guint) _tmp60_);
		}
	}
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gint _tmp9_;
	GdkEventMotion _tmp10_;
	gdouble _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	gdouble _tmp16_ = 0.0;
	gint x;
	GdkEventMotion _tmp17_;
	gdouble _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	gdouble _tmp23_ = 0.0;
	gint y;
	Minefield* _tmp24_;
	Minefield* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint _tmp30_;
	gint _tmp31_;
	gboolean _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	Minefield* _tmp37_;
	Minefield* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gboolean _tmp41_ = FALSE;
	gint _tmp44_;
	gint _tmp45_;
	Minefield* _tmp46_;
	Minefield* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_ = FALSE;
	gint _tmp53_;
	gint _tmp54_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->exploded;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->selected_x;
	if (_tmp9_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.x;
	_tmp12_ = minefield_view_get_x_offset (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = minefield_view_get_mine_size (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = floor ((_tmp11_ - _tmp13_) / _tmp15_);
	x = (gint) _tmp16_;
	_tmp17_ = *event;
	_tmp18_ = _tmp17_.y;
	_tmp19_ = minefield_view_get_y_offset (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = minefield_view_get_mine_size (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = floor ((_tmp18_ - _tmp20_) / _tmp22_);
	y = (gint) _tmp23_;
	_tmp24_ = minefield_view_get_minefield (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = x;
	_tmp27_ = y;
	_tmp28_ = minefield_is_location (_tmp25_, (guint) _tmp26_, (guint) _tmp27_);
	if (!_tmp28_) {
		result = FALSE;
		return result;
	}
	_tmp30_ = x;
	_tmp31_ = self->priv->selected_x;
	if (_tmp30_ == _tmp31_) {
		gint _tmp32_;
		gint _tmp33_;
		_tmp32_ = y;
		_tmp33_ = self->priv->selected_y;
		_tmp29_ = _tmp32_ == _tmp33_;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp34_ = _tmp29_;
	if (_tmp34_) {
		result = FALSE;
		return result;
	}
	_tmp35_ = self->priv->selected_x;
	_tmp36_ = self->priv->selected_y;
	minefield_view_redraw_sector_cb (self, (guint) _tmp35_, (guint) _tmp36_);
	_tmp37_ = minefield_view_get_minefield (self);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->selected_x;
	_tmp40_ = self->priv->selected_y;
	_tmp41_ = minefield_is_cleared (_tmp38_, (guint) _tmp39_, (guint) _tmp40_);
	if (_tmp41_) {
		gint _tmp42_;
		gint _tmp43_;
		_tmp42_ = self->priv->selected_x;
		_tmp43_ = self->priv->selected_y;
		minefield_view_redraw_adjacent (self, (guint) _tmp42_, (guint) _tmp43_);
	}
	_tmp44_ = x;
	_tmp45_ = y;
	minefield_view_redraw_sector_cb (self, (guint) _tmp44_, (guint) _tmp45_);
	_tmp46_ = minefield_view_get_minefield (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = x;
	_tmp49_ = y;
	_tmp50_ = minefield_is_cleared (_tmp47_, (guint) _tmp48_, (guint) _tmp49_);
	if (_tmp50_) {
		gint _tmp51_;
		gint _tmp52_;
		_tmp51_ = x;
		_tmp52_ = y;
		minefield_view_redraw_adjacent (self, (guint) _tmp51_, (guint) _tmp52_);
	}
	_tmp53_ = x;
	self->priv->selected_x = _tmp53_;
	_tmp54_ = y;
	self->priv->selected_y = _tmp54_;
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gint _tmp9_;
	GdkEventButton _tmp10_;
	guint _tmp11_;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->exploded;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = minefield_view_get_minefield (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = minefield_get_is_complete (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->selected_x;
	if (_tmp9_ < 0) {
		result = FALSE;
		return result;
	}
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.button;
	if (_tmp11_ == ((guint) 1)) {
		Minefield* _tmp12_;
		Minefield* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp16_ = FALSE;
		gint _tmp30_;
		gint _tmp31_;
		g_signal_emit_by_name (self, "unlook");
		_tmp12_ = minefield_view_get_minefield (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->selected_x;
		_tmp15_ = self->priv->selected_y;
		_tmp16_ = minefield_is_cleared (_tmp13_, (guint) _tmp14_, (guint) _tmp15_);
		if (_tmp16_) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp17_ = self->priv->selected_x;
			_tmp18_ = self->priv->selected_y;
			minefield_view_multi_release (self, (guint) _tmp17_, (guint) _tmp18_);
			_tmp19_ = self->priv->selected_x;
			_tmp20_ = self->priv->selected_y;
			minefield_view_redraw_adjacent (self, (guint) _tmp19_, (guint) _tmp20_);
		} else {
			Minefield* _tmp21_;
			Minefield* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			FlagType _tmp25_ = 0;
			_tmp21_ = minefield_view_get_minefield (self);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->selected_x;
			_tmp24_ = self->priv->selected_y;
			_tmp25_ = minefield_get_flag (_tmp22_, (guint) _tmp23_, (guint) _tmp24_);
			if (_tmp25_ != FLAG_TYPE_FLAG) {
				Minefield* _tmp26_;
				Minefield* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp26_ = minefield_view_get_minefield (self);
				_tmp27_ = _tmp26_;
				_tmp28_ = self->priv->selected_x;
				_tmp29_ = self->priv->selected_y;
				minefield_clear_mine (_tmp27_, (guint) _tmp28_, (guint) _tmp29_);
			}
		}
		_tmp30_ = self->priv->selected_x;
		_tmp31_ = self->priv->selected_y;
		minefield_view_redraw_sector_cb (self, (guint) _tmp30_, (guint) _tmp31_);
	}
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	result = FALSE;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	guint _tmp7_;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_x_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_y_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_;
	Minefield* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	Minefield* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint w;
	Minefield* _tmp3_;
	Minefield* _tmp4_;
	guint _tmp5_;
	guint h;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint s;
	guint _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb (self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb (self, _sender);
}


static void _minefield_view_minefield___lambda2_ (MinefieldView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __minefield_view_minefield___lambda2__minefield_paused_changed (Minefield* _sender, gpointer self) {
	_minefield_view_minefield___lambda2_ (self);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_;
	Minefield* _tmp2_;
	Minefield* _tmp3_;
	Minefield* _tmp4_;
	Minefield* _tmp5_;
	Minefield* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _minefield_ref0 (_tmp2_);
	_minefield_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	_tmp4_ = self->priv->_minefield;
	g_signal_connect_object (_tmp4_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp5_ = self->priv->_minefield;
	g_signal_connect_object (_tmp5_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp6_ = self->priv->_minefield;
	g_signal_connect_object (_tmp6_, "paused-changed", (GCallback) __minefield_view_minefield___lambda2__minefield_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = minefield_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = minefield_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = minefield_view_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = minefield_view_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, param_spec_minefield ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
	self->priv->selected_x = -1;
	self->priv->selected_y = -1;
	self->priv->render_size = (guint) 0;
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (obj);
	_g_object_unref0 (self->priv->flag_preimage);
	_g_object_unref0 (self->priv->mine_preimage);
	_g_object_unref0 (self->priv->question_preimage);
	_g_object_unref0 (self->priv->bang_preimage);
	_g_object_unref0 (self->priv->warning_preimage);
	_cairo_pattern_destroy0 (self->priv->flag_pattern);
	_cairo_pattern_destroy0 (self->priv->mine_pattern);
	_cairo_pattern_destroy0 (self->priv->question_pattern);
	_cairo_pattern_destroy0 (self->priv->bang_pattern);
	_cairo_pattern_destroy0 (self->priv->warning_pattern);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_minefield_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (object);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		value_set_minefield (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = MINEFIELD_VIEW (object);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, value_get_minefield (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



