/* gnome-boxes-search-provider.c generated by valac 0.17.7, the Vala compiler
 * generated from gnome-boxes-search-provider.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libcommon.h>
#include <stdio.h>


#define BOXES_TYPE_SEARCH_PROVIDER (boxes_search_provider_get_type ())
#define BOXES_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider))
#define BOXES_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProviderClass))
#define BOXES_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCH_PROVIDER))
#define BOXES_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCH_PROVIDER))
#define BOXES_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProviderClass))

typedef struct _BoxesSearchProvider BoxesSearchProvider;
typedef struct _BoxesSearchProviderClass BoxesSearchProviderClass;
typedef struct _BoxesSearchProviderPrivate BoxesSearchProviderPrivate;

#define BOXES_TYPE_SEARCH_PROVIDER_APP (boxes_search_provider_app_get_type ())
#define BOXES_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderApp))
#define BOXES_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderAppClass))
#define BOXES_IS_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP))
#define BOXES_IS_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCH_PROVIDER_APP))
#define BOXES_SEARCH_PROVIDER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCH_PROVIDER_APP, BoxesSearchProviderAppClass))

typedef struct _BoxesSearchProviderApp BoxesSearchProviderApp;
typedef struct _BoxesSearchProviderAppClass BoxesSearchProviderAppClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _BoxesSearchProviderLoadData BoxesSearchProviderLoadData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _BoxesSearchProviderSearchData BoxesSearchProviderSearchData;
typedef struct _boxes_search_provider_GetInitialResultSetData boxes_search_provider_GetInitialResultSetData;
typedef struct _boxes_search_provider_GetSubsearchResultSetData boxes_search_provider_GetSubsearchResultSetData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _boxes_search_provider_GetResultMetasData boxes_search_provider_GetResultMetasData;
typedef struct _BoxesSearchProviderAppPrivate BoxesSearchProviderAppPrivate;

struct _BoxesSearchProvider {
	GObject parent_instance;
	BoxesSearchProviderPrivate * priv;
};

struct _BoxesSearchProviderClass {
	GObjectClass parent_class;
};

struct _BoxesSearchProviderPrivate {
	BoxesSearchProviderApp* app;
	gboolean loading;
	gboolean _loaded;
	GHashTable* boxes;
	guint next_id;
};

struct _Block1Data {
	int _ref_count_;
	BoxesSearchProvider * self;
	gpointer _async_data_;
};

struct _BoxesSearchProviderLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesSearchProvider* self;
	Block1Data* _data1_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gulong _tmp4_;
	gulong wait;
	gulong _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* dir;
	GFile* _tmp11_;
};

struct _Block2Data {
	int _ref_count_;
	GPtrArray * self;
	GCompareFunc compare_func;
};

struct _BoxesSearchProviderSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	BoxesSearchProviderApp* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** normalized_terms;
	gint normalized_terms_length1;
	gint _normalized_terms_size_;
	GPtrArray* _tmp9_;
	GPtrArray* matches;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_;
	GHashTable* _tmp14_;
	GList* _tmp15_;
	GList* box_collection;
	GList* box_it;
	BoxesDisplayProperties* box;
	BoxesDisplayProperties* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gboolean _tmp18_;
	GPtrArray* _tmp19_;
	BoxesDisplayProperties* _tmp20_;
	BoxesDisplayProperties* _tmp21_;
	GPtrArray* _tmp22_;
	GPtrArray* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gchar** _tmp26_;
	gchar** results;
	gint results_length1;
	gint _results_size_;
	gint i;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GPtrArray* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	GPtrArray* _tmp36_;
	gint _tmp37_;
	gconstpointer _tmp38_;
	gconstpointer _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	BoxesSearchProviderApp* _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
};

struct _boxes_search_provider_GetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _boxes_search_provider_GetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** new_terms;
	gint new_terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
};

struct _boxes_search_provider_GetResultMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesSearchProvider* self;
	gchar** ids;
	gint ids_length1;
	GHashTable** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GHashTable** _tmp1_;
	GHashTable** metas;
	gint metas_length1;
	gint _metas_size_;
	BoxesSearchProviderApp* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	guint n;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** id_collection;
	gint id_collection_length1;
	gint _id_collection_size_;
	gint id_it;
	gchar* _tmp7_;
	gchar* id;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gconstpointer _tmp10_;
	BoxesDisplayProperties* _tmp11_;
	BoxesDisplayProperties* box;
	BoxesDisplayProperties* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GHashTable* meta;
	GHashTable** _tmp16_;
	gint _tmp16__length1;
	guint _tmp17_;
	GHashTable* _tmp18_;
	GHashTable* _tmp19_;
	GHashTable* _tmp20_;
	guint _tmp21_;
	GHashTable* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GVariant* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	BoxesDisplayProperties* _tmp28_;
	BoxesDisplayConfig* _tmp29_;
	BoxesDisplayConfig* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	BoxesDisplayProperties* _tmp35_;
	BoxesDisplayConfig* _tmp36_;
	BoxesDisplayConfig* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	GFile* file;
	GFileInfo* info;
	GFile* _tmp45_;
	GFileInfo* _tmp46_;
	GFileInfo* _tmp47_;
	GError* _error_;
	GFileInfo* _tmp48_;
	GFile* _tmp49_;
	GFileIcon* _tmp50_;
	GFileIcon* icon;
	GHashTable* _tmp51_;
	gchar* _tmp52_;
	GFileIcon* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GVariant* _tmp56_;
	GHashTable* _tmp57_;
	gchar* _tmp58_;
	GThemedIcon* _tmp59_;
	GThemedIcon* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GVariant* _tmp63_;
	BoxesSearchProviderApp* _tmp64_;
	GHashTable** _tmp65_;
	gint _tmp65__length1;
	guint _tmp66_;
	GHashTable** _tmp67_;
	gint _tmp67__length1;
	GHashTable** _tmp68_;
	gint _tmp68__length1;
	GError * _inner_error_;
};

struct _BoxesSearchProviderApp {
	GApplication parent_instance;
	BoxesSearchProviderAppPrivate * priv;
};

struct _BoxesSearchProviderAppClass {
	GApplicationClass parent_class;
};


static gpointer boxes_search_provider_parent_class = NULL;
static gpointer boxes_search_provider_app_parent_class = NULL;

GType boxes_search_provider_get_type (void) G_GNUC_CONST;
guint boxes_search_provider_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType boxes_search_provider_app_get_type (void) G_GNUC_CONST;
#define BOXES_SEARCH_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProviderPrivate))
enum  {
	BOXES_SEARCH_PROVIDER_DUMMY_PROPERTY,
	BOXES_SEARCH_PROVIDER_LOADED
};
BoxesSearchProvider* boxes_search_provider_new (BoxesSearchProviderApp* app);
BoxesSearchProvider* boxes_search_provider_construct (GType object_type, BoxesSearchProviderApp* app);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void boxes_search_provider_add_box (BoxesSearchProvider* self, BoxesDisplayProperties* box);
static void boxes_search_provider_load_data_free (gpointer _data);
static void boxes_search_provider_load (BoxesSearchProvider* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void boxes_search_provider_load_finish (BoxesSearchProvider* self, GAsyncResult* _res_);
static gboolean boxes_search_provider_load_co (BoxesSearchProviderLoadData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean boxes_search_provider_get_loaded (BoxesSearchProvider* self);
static void ___lambda2_ (Block1Data* _data1_);
static void ____lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda3_ (BoxesSearchProvider* self, const gchar* filename, GError** error);
static gboolean ___lambda3__boxes_foreach_filename_from_dir_func (const gchar* filename, gpointer self, GError** error);
static void boxes_search_provider_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void boxes_search_provider_set_loaded (BoxesSearchProvider* self, gboolean value);
static gint boxes_search_provider_compare_boxes (BoxesDisplayProperties* a, BoxesDisplayProperties* b);
static void boxes_search_provider_search_data_free (gpointer _data);
static void boxes_search_provider_search (BoxesSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** boxes_search_provider_search_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean boxes_search_provider_search_co (BoxesSearchProviderSearchData* _data_);
static void boxes_search_provider_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void boxes_search_provider_GetInitialResultSet_data_free (gpointer _data);
void boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** boxes_search_provider_GetInitialResultSet_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean boxes_search_provider_GetInitialResultSet_co (boxes_search_provider_GetInitialResultSetData* _data_);
static void boxes_search_provider_GetInitialResultSet_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_search_provider_GetSubsearchResultSet_data_free (gpointer _data);
void boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self, gchar** previous_results, int previous_results_length1, gchar** new_terms, int new_terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** boxes_search_provider_GetSubsearchResultSet_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean boxes_search_provider_GetSubsearchResultSet_co (boxes_search_provider_GetSubsearchResultSetData* _data_);
static void boxes_search_provider_GetSubsearchResultSet_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_search_provider_GetResultMetas_data_free (gpointer _data);
void boxes_search_provider_GetResultMetas (BoxesSearchProvider* self, gchar** ids, int ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable** boxes_search_provider_GetResultMetas_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1);
static gboolean boxes_search_provider_GetResultMetas_co (boxes_search_provider_GetResultMetasData* _data_);
static void _g_variant_unref0_ (gpointer var);
static void boxes_search_provider_GetResultMetas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GHashTable** _vala_array_dup1 (GHashTable** self, int length);
void boxes_search_provider_ActivateResult (BoxesSearchProvider* self, const gchar* search_id);
static void boxes_search_provider_finalize (GObject* obj);
static void _vala_boxes_search_provider_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_boxes_search_provider_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _dbus_boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetInitialResultSet_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetSubsearchResultSet_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_boxes_search_provider_GetResultMetas (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_boxes_search_provider_GetResultMetas_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_boxes_search_provider_ActivateResult (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void boxes_search_provider_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* boxes_search_provider_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_boxes_search_provider_get_loaded (BoxesSearchProvider* self);
static gboolean boxes_search_provider_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_boxes_search_provider_set_loaded (BoxesSearchProvider* self, GVariant* _value);
static void _boxes_search_provider_unregister_object (gpointer user_data);
enum  {
	BOXES_SEARCH_PROVIDER_APP_DUMMY_PROPERTY
};
BoxesSearchProviderApp* boxes_search_provider_app_new (void);
BoxesSearchProviderApp* boxes_search_provider_app_construct (GType object_type);
static gboolean boxes_search_provider_app_real_dbus_register (GApplication* base, GDBusConnection* connection, const gchar* object_path, GError** error);
static void boxes_search_provider_app_real_startup (GApplication* base);
gint _vala_main (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetInitialResultSet_terms = {-1, "terms", "as"};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetInitialResultSet_result = {-1, "result", "as"};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetInitialResultSet_in[] = {&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_terms, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetInitialResultSet_out[] = {&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetInitialResultSet = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetInitialResultSet_out)};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results = {-1, "previous_results", "as"};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms = {-1, "new_terms", "as"};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_result = {-1, "result", "as"};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_in[] = {&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_previous_results, &_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_new_terms, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_out[] = {&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetSubsearchResultSet = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetSubsearchResultSet_out)};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetResultMetas_ids = {-1, "ids", "as"};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_GetResultMetas_result = {-1, "result", "aa{sv}"};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetResultMetas_in[] = {&_boxes_search_provider_dbus_arg_info_GetResultMetas_ids, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_GetResultMetas_out[] = {&_boxes_search_provider_dbus_arg_info_GetResultMetas_result, NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_GetResultMetas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetResultMetas_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_GetResultMetas_out)};
static const GDBusArgInfo _boxes_search_provider_dbus_arg_info_ActivateResult_search_id = {-1, "search_id", "s"};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_ActivateResult_in[] = {&_boxes_search_provider_dbus_arg_info_ActivateResult_search_id, NULL};
static const GDBusArgInfo * const _boxes_search_provider_dbus_arg_info_ActivateResult_out[] = {NULL};
static const GDBusMethodInfo _boxes_search_provider_dbus_method_info_ActivateResult = {-1, "ActivateResult", (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_ActivateResult_in), (GDBusArgInfo **) (&_boxes_search_provider_dbus_arg_info_ActivateResult_out)};
static const GDBusMethodInfo * const _boxes_search_provider_dbus_method_info[] = {&_boxes_search_provider_dbus_method_info_GetInitialResultSet, &_boxes_search_provider_dbus_method_info_GetSubsearchResultSet, &_boxes_search_provider_dbus_method_info_GetResultMetas, &_boxes_search_provider_dbus_method_info_ActivateResult, NULL};
static const GDBusSignalInfo * const _boxes_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _boxes_search_provider_dbus_property_info_loaded = {-1, "Loaded", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _boxes_search_provider_dbus_property_info[] = {&_boxes_search_provider_dbus_property_info_loaded, NULL};
static const GDBusInterfaceInfo _boxes_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider", (GDBusMethodInfo **) (&_boxes_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_boxes_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_boxes_search_provider_dbus_property_info)};
static const GDBusInterfaceVTable _boxes_search_provider_dbus_interface_vtable = {boxes_search_provider_dbus_interface_method_call, boxes_search_provider_dbus_interface_get_property, boxes_search_provider_dbus_interface_set_property};

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


BoxesSearchProvider* boxes_search_provider_construct (GType object_type, BoxesSearchProviderApp* app) {
	BoxesSearchProvider * self = NULL;
	BoxesSearchProviderApp* _tmp0_;
	BoxesSearchProviderApp* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (BoxesSearchProvider*) g_object_new (object_type, NULL);
	_tmp0_ = app;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->boxes);
	self->priv->boxes = _tmp4_;
	return self;
}


BoxesSearchProvider* boxes_search_provider_new (BoxesSearchProviderApp* app) {
	return boxes_search_provider_construct (BOXES_TYPE_SEARCH_PROVIDER, app);
}


static void boxes_search_provider_add_box (BoxesSearchProvider* self, BoxesDisplayProperties* box) {
	guint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	BoxesDisplayProperties* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	BoxesDisplayProperties* _tmp6_;
	BoxesDisplayProperties* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp0_ = self->priv->next_id;
	self->priv->next_id = _tmp0_ + 1;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	id = _tmp1_;
	_tmp2_ = box;
	_tmp3_ = g_strdup (id);
	g_object_set_data_full ((GObject*) _tmp2_, "search-id", _tmp3_, g_free);
	_tmp4_ = self->priv->boxes;
	_tmp5_ = g_strdup (id);
	_tmp6_ = box;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_g_free0 (id);
}


static void boxes_search_provider_load_data_free (gpointer _data) {
	BoxesSearchProviderLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesSearchProviderLoadData, _data_);
}


static void boxes_search_provider_load (BoxesSearchProvider* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesSearchProviderLoadData* _data_;
	BoxesSearchProvider* _tmp0_;
	_data_ = g_slice_new0 (BoxesSearchProviderLoadData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_search_provider_load);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_search_provider_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_search_provider_load_co (_data_);
}


static void boxes_search_provider_load_finish (BoxesSearchProvider* self, GAsyncResult* _res_) {
	BoxesSearchProviderLoadData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BoxesSearchProvider * self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_) {
	BoxesSearchProvider * self;
	self = _data1_->self;
	boxes_search_provider_load_co (_data1_->_async_data_);
}


static void ____lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda2_ (self);
}


static gboolean __lambda3_ (BoxesSearchProvider* self, const gchar* filename, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	BoxesCollectionSource* _tmp1_;
	BoxesCollectionSource* source;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = boxes_collection_source_new_with_file (_tmp0_, &_inner_error_);
	source = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp2_ = boxes_collection_source_get_enabled (source);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		_g_object_unref0 (source);
		return result;
	}
	_tmp5_ = boxes_iconfig_get_groups ((BoxesIConfig*) source, "display", &_tmp4_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp5_;
		group_collection_length1 = _tmp4_;
		for (group_it = 0; group_it < _tmp4_; group_it = group_it + 1) {
			gchar* _tmp6_;
			gchar* group = NULL;
			_tmp6_ = g_strdup (group_collection[group_it]);
			group = _tmp6_;
			{
				const gchar* _tmp7_;
				BoxesDisplayConfig* _tmp8_;
				BoxesDisplayConfig* config;
				BoxesDisplayConfig* _tmp9_;
				BoxesDisplayProperties* _tmp10_;
				BoxesDisplayProperties* box;
				BoxesDisplayProperties* _tmp11_;
				_tmp7_ = group;
				_tmp8_ = boxes_display_config_new_with_group (source, _tmp7_);
				config = _tmp8_;
				_tmp9_ = config;
				_tmp10_ = boxes_display_properties_new_with_config (_tmp9_);
				box = _tmp10_;
				_tmp11_ = box;
				boxes_search_provider_add_box (self, _tmp11_);
				_g_object_unref0 (box);
				_g_object_unref0 (config);
				_g_free0 (group);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = FALSE;
	_g_object_unref0 (source);
	return result;
}


static gboolean ___lambda3__boxes_foreach_filename_from_dir_func (const gchar* filename, gpointer self, GError** error) {
	gboolean result;
	result = __lambda3_ (self, filename, error);
	return result;
}


static void boxes_search_provider_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesSearchProviderLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_load_co (_data_);
}


static gboolean boxes_search_provider_load_co (BoxesSearchProviderLoadData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	while (TRUE) {
		_data_->_tmp1_ = _data_->self->priv->_loaded;
		if (!_data_->_tmp1_) {
			_data_->_tmp2_ = _data_->self->priv->loading;
			_data_->_tmp0_ = _data_->_tmp2_;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		if (!_data_->_tmp3_) {
			break;
		}
		_data_->_tmp4_ = 0UL;
		_data_->_tmp4_ = g_signal_connect_data ((GObject*) _data_->self, "notify::loaded", (GCallback) ____lambda2__g_object_notify, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
		_data_->wait = _data_->_tmp4_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp5_ = _data_->wait;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->_tmp5_);
		_data_->_tmp6_ = _data_->self->priv->_loaded;
		if (_data_->_tmp6_) {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->self->priv->loading = TRUE;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = boxes_get_user_pkgconfig_source (NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_file_new_for_path (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_g_free0 (_data_->_tmp8_);
	_data_->dir = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->dir;
	_data_->_state_ = 2;
	boxes_foreach_filename_from_dir (_data_->_tmp11_, ___lambda3__boxes_foreach_filename_from_dir_func, _data_->self, boxes_search_provider_load_ready, _data_);
	return FALSE;
	_state_2:
	boxes_foreach_filename_from_dir_finish (_data_->_res_);
	boxes_search_provider_set_loaded (_data_->self, TRUE);
	_data_->self->priv->loading = FALSE;
	_g_object_unref0 (_data_->dir);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint boxes_search_provider_compare_boxes (BoxesDisplayProperties* a, BoxesDisplayProperties* b) {
	gint result = 0;
	BoxesDisplayProperties* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	BoxesDisplayProperties* _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	BoxesDisplayProperties* _tmp6_;
	BoxesDisplayConfig* _tmp7_;
	BoxesDisplayConfig* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* a_name;
	BoxesDisplayProperties* _tmp11_;
	BoxesDisplayConfig* _tmp12_;
	BoxesDisplayConfig* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* b_name;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp21_;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	const gchar* _tmp27_;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = boxes_display_properties_get_access_last_time (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = boxes_display_properties_get_access_last_time (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		result = -1;
		return result;
	}
	_tmp6_ = a;
	_tmp7_ = boxes_display_properties_get_config (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = boxes_display_config_get_last_seen_name (_tmp8_);
	_tmp10_ = _tmp9_;
	a_name = _tmp10_;
	_tmp11_ = b;
	_tmp12_ = boxes_display_properties_get_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = boxes_display_config_get_last_seen_name (_tmp13_);
	_tmp15_ = _tmp14_;
	b_name = _tmp15_;
	_tmp17_ = a_name;
	_tmp18_ = boxes_is_set (_tmp17_);
	if (_tmp18_) {
		const gchar* _tmp19_;
		gboolean _tmp20_ = FALSE;
		_tmp19_ = b_name;
		_tmp20_ = boxes_is_set (_tmp19_);
		_tmp16_ = _tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gint _tmp24_ = 0;
		_tmp22_ = a_name;
		_tmp23_ = b_name;
		_tmp24_ = g_utf8_collate (_tmp22_, _tmp23_);
		result = _tmp24_;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	_tmp25_ = a_name;
	_tmp26_ = boxes_is_set (_tmp25_);
	if (_tmp26_) {
		result = -1;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	_tmp27_ = b_name;
	_tmp28_ = boxes_is_set (_tmp27_);
	if (_tmp28_) {
		result = -1;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	result = 0;
	_g_free0 (b_name);
	_g_free0 (a_name);
	return result;
}


static void boxes_search_provider_search_data_free (gpointer _data) {
	BoxesSearchProviderSearchData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesSearchProviderSearchData, _data_);
}


static void boxes_search_provider_search (BoxesSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesSearchProviderSearchData* _data_;
	BoxesSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (BoxesSearchProviderSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_search_provider_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_search_provider_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = terms;
	_tmp1__length1 = terms_length1;
	_data_->terms = _tmp1_;
	_data_->terms_length1 = _tmp1__length1;
	boxes_search_provider_search_co (_data_);
}


static gchar** boxes_search_provider_search_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	BoxesSearchProviderSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void boxes_search_provider_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesSearchProviderSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_search_co (_data_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GPtrArray * self;
		self = _data2_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gint __lambda0_ (Block2Data* _data2_, gconstpointer** a, gconstpointer** b) {
	GPtrArray * self;
	gint result = 0;
	GCompareFunc _tmp0_;
	gconstpointer** _tmp1_;
	gconstpointer** _tmp2_;
	gint _tmp3_ = 0;
	self = _data2_->self;
	_tmp0_ = _data2_->compare_func;
	_tmp1_ = a;
	_tmp2_ = b;
	_tmp3_ = _tmp0_ ((gconstpointer**) (*_tmp1_), (gconstpointer**) (*_tmp2_));
	result = _tmp3_;
	return result;
}


static gint ___lambda0__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}


static void vala_g_ptr_array_sort (GPtrArray* self, GCompareFunc compare_func) {
	Block2Data* _data2_;
	GCompareFunc _tmp0_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_ptr_array_ref (self);
	_tmp0_ = compare_func;
	_data2_->compare_func = _tmp0_;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gboolean boxes_search_provider_search_co (BoxesSearchProviderSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->app;
	g_application_hold ((GApplication*) _data_->_tmp0_);
	_data_->_tmp1_ = _data_->terms;
	_data_->_tmp1__length1 = _data_->terms_length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strjoinv (" ", _data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = boxes_canonicalize_for_search (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_ = g_strsplit (_data_->_tmp5_, " ", 0);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp8__length1 = _vala_array_length (_data_->_tmp6_);
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_data_->normalized_terms = _data_->_tmp8_;
	_data_->normalized_terms_length1 = _data_->_tmp8__length1;
	_data_->_normalized_terms_size_ = _data_->normalized_terms_length1;
	_data_->_tmp9_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_data_->matches = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->terms;
	_data_->_tmp10__length1 = _data_->terms_length1;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strjoinv (", ", _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	g_debug ("gnome-boxes-search-provider.vala:83: search (%s)", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = _data_->self->priv->_loaded;
	if (!_data_->_tmp13_) {
		_data_->_state_ = 1;
		boxes_search_provider_load (_data_->self, boxes_search_provider_search_ready, _data_);
		return FALSE;
		_state_1:
		boxes_search_provider_load_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp14_ = _data_->self->priv->boxes;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_hash_table_get_values (_data_->_tmp14_);
	{
		_data_->box_collection = _data_->_tmp15_;
		for (_data_->box_it = _data_->box_collection; _data_->box_it != NULL; _data_->box_it = _data_->box_it->next) {
			_data_->box = (BoxesDisplayProperties*) _data_->box_it->data;
			{
				_data_->_tmp16_ = _data_->box;
				_data_->_tmp17_ = _data_->normalized_terms;
				_data_->_tmp17__length1 = _data_->normalized_terms_length1;
				_data_->_tmp18_ = FALSE;
				_data_->_tmp18_ = boxes_display_properties_contains_strings (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp17__length1);
				if (_data_->_tmp18_) {
					_data_->_tmp19_ = _data_->matches;
					_data_->_tmp20_ = _data_->box;
					_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
					g_ptr_array_add (_data_->_tmp19_, _data_->_tmp21_);
				}
			}
		}
		_g_list_free0 (_data_->box_collection);
	}
	_data_->_tmp22_ = _data_->matches;
	vala_g_ptr_array_sort (_data_->_tmp22_, (GCompareFunc) boxes_search_provider_compare_boxes);
	_data_->_tmp23_ = _data_->matches;
	_data_->_tmp24_ = g_ptr_array_get_length (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_new0 (gchar*, _data_->_tmp25_ + 1);
	_data_->results = _data_->_tmp26_;
	_data_->results_length1 = _data_->_tmp25_;
	_data_->_results_size_ = _data_->results_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp27_ = TRUE;
			while (TRUE) {
				_data_->_tmp28_ = _data_->_tmp27_;
				if (!_data_->_tmp28_) {
					_data_->_tmp29_ = _data_->i;
					_data_->i = _data_->_tmp29_ + 1;
				}
				_data_->_tmp27_ = FALSE;
				_data_->_tmp30_ = _data_->i;
				_data_->_tmp31_ = _data_->matches;
				_data_->_tmp32_ = g_ptr_array_get_length (_data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				if (!(_data_->_tmp30_ < _data_->_tmp33_)) {
					break;
				}
				_data_->_tmp34_ = _data_->results;
				_data_->_tmp34__length1 = _data_->results_length1;
				_data_->_tmp35_ = _data_->i;
				_data_->_tmp36_ = _data_->matches;
				_data_->_tmp37_ = _data_->i;
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = g_ptr_array_index (_data_->_tmp36_, (guint) _data_->_tmp37_);
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = g_object_get_data ((GObject*) ((BoxesDisplayProperties*) _data_->_tmp38_), "search-id");
				_data_->_tmp40_ = g_strdup ((const gchar*) _data_->_tmp39_);
				_g_free0 (_data_->_tmp34_[_data_->_tmp35_]);
				_data_->_tmp34_[_data_->_tmp35_] = _data_->_tmp40_;
				_data_->_tmp41_ = _data_->_tmp34_[_data_->_tmp35_];
			}
		}
	}
	_data_->_tmp42_ = _data_->self->priv->app;
	g_application_release ((GApplication*) _data_->_tmp42_);
	_data_->_tmp43_ = _data_->results;
	_data_->_tmp43__length1 = _data_->results_length1;
	_data_->result_length1 = _data_->_tmp43__length1;
	_data_->result = _data_->_tmp43_;
	_g_ptr_array_unref0 (_data_->matches);
	_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->results = (_vala_array_free (_data_->results, _data_->results_length1, (GDestroyNotify) g_free), NULL);
	_g_ptr_array_unref0 (_data_->matches);
	_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_search_provider_GetInitialResultSet_data_free (gpointer _data) {
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetInitialResultSetData, _data_);
}


void boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self, gchar** terms, int terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	boxes_search_provider_GetInitialResultSetData* _data_;
	BoxesSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (boxes_search_provider_GetInitialResultSetData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_search_provider_GetInitialResultSet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_search_provider_GetInitialResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = terms;
	_tmp1__length1 = terms_length1;
	_data_->terms = _tmp1_;
	_data_->terms_length1 = _tmp1__length1;
	boxes_search_provider_GetInitialResultSet_co (_data_);
}


gchar** boxes_search_provider_GetInitialResultSet_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void boxes_search_provider_GetInitialResultSet_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	boxes_search_provider_GetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetInitialResultSet_co (_data_);
}


static gboolean boxes_search_provider_GetInitialResultSet_co (boxes_search_provider_GetInitialResultSetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->terms;
	_data_->_tmp0__length1 = _data_->terms_length1;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	boxes_search_provider_search (_data_->self, _data_->_tmp0_, _data_->_tmp0__length1, boxes_search_provider_GetInitialResultSet_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = boxes_search_provider_search_finish (_data_->self, _data_->_res_, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_search_provider_GetSubsearchResultSet_data_free (gpointer _data) {
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetSubsearchResultSetData, _data_);
}


void boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self, gchar** previous_results, int previous_results_length1, gchar** new_terms, int new_terms_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	BoxesSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_data_ = g_slice_new0 (boxes_search_provider_GetSubsearchResultSetData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_search_provider_GetSubsearchResultSet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_search_provider_GetSubsearchResultSet_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = previous_results;
	_tmp1__length1 = previous_results_length1;
	_data_->previous_results = _tmp1_;
	_data_->previous_results_length1 = _tmp1__length1;
	_tmp2_ = new_terms;
	_tmp2__length1 = new_terms_length1;
	_data_->new_terms = _tmp2_;
	_data_->new_terms_length1 = _tmp2__length1;
	boxes_search_provider_GetSubsearchResultSet_co (_data_);
}


gchar** boxes_search_provider_GetSubsearchResultSet_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	gchar** result;
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void boxes_search_provider_GetSubsearchResultSet_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	boxes_search_provider_GetSubsearchResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetSubsearchResultSet_co (_data_);
}


static gboolean boxes_search_provider_GetSubsearchResultSet_co (boxes_search_provider_GetSubsearchResultSetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->new_terms;
	_data_->_tmp0__length1 = _data_->new_terms_length1;
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	boxes_search_provider_search (_data_->self, _data_->_tmp0_, _data_->_tmp0__length1, boxes_search_provider_GetSubsearchResultSet_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = boxes_search_provider_search_finish (_data_->self, _data_->_res_, &_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = _data_->_tmp1_;
	_data_->result_length1 = _data_->_tmp3__length1;
	_data_->result = _data_->_tmp3_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_search_provider_GetResultMetas_data_free (gpointer _data) {
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (boxes_search_provider_GetResultMetasData, _data_);
}


void boxes_search_provider_GetResultMetas (BoxesSearchProvider* self, gchar** ids, int ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	boxes_search_provider_GetResultMetasData* _data_;
	BoxesSearchProvider* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_data_ = g_slice_new0 (boxes_search_provider_GetResultMetasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_search_provider_GetResultMetas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_search_provider_GetResultMetas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = ids;
	_tmp1__length1 = ids_length1;
	_data_->ids = _tmp1_;
	_data_->ids_length1 = _tmp1__length1;
	boxes_search_provider_GetResultMetas_co (_data_);
}


GHashTable** boxes_search_provider_GetResultMetas_finish (BoxesSearchProvider* self, GAsyncResult* _res_, int* result_length1) {
	GHashTable** result;
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void boxes_search_provider_GetResultMetas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	boxes_search_provider_GetResultMetasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_search_provider_GetResultMetas_co (_data_);
}


static GHashTable** _vala_array_dup1 (GHashTable** self, int length) {
	GHashTable** result;
	int i;
	result = g_new0 (GHashTable*, length + 1);
	for (i = 0; i < length; i++) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean boxes_search_provider_GetResultMetas_co (boxes_search_provider_GetResultMetasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->ids;
	_data_->_tmp0__length1 = _data_->ids_length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_new0 (GHashTable*, _data_->_tmp0__length1 + 1);
	_data_->metas = _data_->_tmp1_;
	_data_->metas_length1 = _data_->_tmp0__length1;
	_data_->_metas_size_ = _data_->metas_length1;
	_data_->_tmp2_ = _data_->self->priv->app;
	g_application_hold ((GApplication*) _data_->_tmp2_);
	_data_->_tmp3_ = _data_->ids;
	_data_->_tmp3__length1 = _data_->ids_length1;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strjoinv (", ", _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("gnome-boxes-search-provider.vala:114: GetResultMetas (%s)", _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->n = (guint) 0;
	_data_->_tmp6_ = _data_->ids;
	_data_->_tmp6__length1 = _data_->ids_length1;
	{
		_data_->id_collection_length1 = 0;
		_data_->_id_collection_size_ = 0;
		_data_->id_collection = _data_->_tmp6_;
		_data_->id_collection_length1 = _data_->_tmp6__length1;
		for (_data_->id_it = 0; _data_->id_it < _data_->_tmp6__length1; _data_->id_it = _data_->id_it + 1) {
			_data_->_tmp7_ = g_strdup (_data_->id_collection[_data_->id_it]);
			_data_->id = _data_->_tmp7_;
			{
				_data_->_tmp8_ = _data_->self->priv->boxes;
				_data_->_tmp9_ = _data_->id;
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = g_hash_table_lookup (_data_->_tmp8_, _data_->_tmp9_);
				_data_->_tmp11_ = _g_object_ref0 ((BoxesDisplayProperties*) _data_->_tmp10_);
				_data_->box = _data_->_tmp11_;
				_data_->_tmp12_ = _data_->box;
				if (_data_->_tmp12_ == NULL) {
					_g_object_unref0 (_data_->box);
					_g_free0 (_data_->id);
					continue;
				}
				_data_->_tmp13_ = g_str_hash;
				_data_->_tmp14_ = g_str_equal;
				_data_->_tmp15_ = g_hash_table_new_full (_data_->_tmp13_, _data_->_tmp14_, _g_free0_, _g_variant_unref0_);
				_data_->meta = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->metas;
				_data_->_tmp16__length1 = _data_->metas_length1;
				_data_->_tmp17_ = _data_->n;
				_data_->_tmp18_ = _data_->meta;
				_data_->_tmp19_ = _g_hash_table_ref0 (_data_->_tmp18_);
				_g_hash_table_unref0 (_data_->_tmp16_[_data_->_tmp17_]);
				_data_->_tmp16_[_data_->_tmp17_] = _data_->_tmp19_;
				_data_->_tmp20_ = _data_->_tmp16_[_data_->_tmp17_];
				_data_->_tmp21_ = _data_->n;
				_data_->n = _data_->_tmp21_ + 1;
				_data_->_tmp22_ = _data_->meta;
				_data_->_tmp23_ = g_strdup ("id");
				_data_->_tmp24_ = _data_->id;
				_data_->_tmp25_ = g_variant_new_string (_data_->_tmp24_);
				g_variant_ref_sink (_data_->_tmp25_);
				g_hash_table_insert (_data_->_tmp22_, _data_->_tmp23_, _data_->_tmp25_);
				_data_->_tmp26_ = _data_->meta;
				_data_->_tmp27_ = g_strdup ("name");
				_data_->_tmp28_ = _data_->box;
				_data_->_tmp29_ = boxes_display_properties_get_config (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = boxes_display_config_get_last_seen_name (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = g_variant_new_string (_data_->_tmp33_);
				g_variant_ref_sink (_data_->_tmp34_);
				g_hash_table_insert (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp34_);
				_g_free0 (_data_->_tmp33_);
				_data_->_tmp35_ = _data_->box;
				_data_->_tmp36_ = boxes_display_properties_get_config (_data_->_tmp35_);
				_data_->_tmp37_ = _data_->_tmp36_;
				_data_->_tmp38_ = boxes_display_config_get_uuid (_data_->_tmp37_);
				_data_->_tmp39_ = _data_->_tmp38_;
				_data_->_tmp40_ = _data_->_tmp39_;
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = boxes_get_screenshot_filename (_data_->_tmp40_);
				_data_->_tmp42_ = _data_->_tmp41_;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = g_file_new_for_path (_data_->_tmp42_);
				_data_->_tmp44_ = _data_->_tmp43_;
				_g_free0 (_data_->_tmp42_);
				_g_free0 (_data_->_tmp40_);
				_data_->file = _data_->_tmp44_;
				_data_->info = NULL;
				{
					_data_->_tmp45_ = _data_->file;
					_data_->_state_ = 1;
					g_file_query_info_async (_data_->_tmp45_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, boxes_search_provider_GetResultMetas_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = g_file_query_info_finish (_data_->_tmp45_, _data_->_res_, &_data_->_inner_error_);
					_data_->_tmp47_ = _data_->_tmp46_;
					if (_data_->_inner_error_ != NULL) {
						goto __catch0_g_error;
					}
					_g_object_unref0 (_data_->info);
					_data_->info = _data_->_tmp47_;
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_error_free0 (_data_->_error_);
				}
				__finally0:
				if (_data_->_inner_error_ != NULL) {
					_g_object_unref0 (_data_->info);
					_g_object_unref0 (_data_->file);
					_g_hash_table_unref0 (_data_->meta);
					_g_object_unref0 (_data_->box);
					_g_free0 (_data_->id);
					_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->_tmp48_ = _data_->info;
				if (_data_->_tmp48_ != NULL) {
					_data_->_tmp49_ = _data_->file;
					_data_->_tmp50_ = (GFileIcon*) g_file_icon_new (_data_->_tmp49_);
					_data_->icon = _data_->_tmp50_;
					_data_->_tmp51_ = _data_->meta;
					_data_->_tmp52_ = g_strdup ("gicon");
					_data_->_tmp53_ = _data_->icon;
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = g_icon_to_string ((GIcon*) _data_->_tmp53_);
					_data_->_tmp55_ = _data_->_tmp54_;
					_data_->_tmp56_ = g_variant_new_string (_data_->_tmp55_);
					g_variant_ref_sink (_data_->_tmp56_);
					g_hash_table_insert (_data_->_tmp51_, _data_->_tmp52_, _data_->_tmp56_);
					_g_free0 (_data_->_tmp55_);
					_g_object_unref0 (_data_->icon);
				} else {
					_data_->_tmp57_ = _data_->meta;
					_data_->_tmp58_ = g_strdup ("gicon");
					_data_->_tmp59_ = (GThemedIcon*) g_themed_icon_new ("gnome-boxes");
					_data_->_tmp60_ = _data_->_tmp59_;
					_data_->_tmp61_ = NULL;
					_data_->_tmp61_ = g_icon_to_string ((GIcon*) _data_->_tmp60_);
					_data_->_tmp62_ = _data_->_tmp61_;
					_data_->_tmp63_ = g_variant_new_string (_data_->_tmp62_);
					g_variant_ref_sink (_data_->_tmp63_);
					g_hash_table_insert (_data_->_tmp57_, _data_->_tmp58_, _data_->_tmp63_);
					_g_free0 (_data_->_tmp62_);
					_g_object_unref0 (_data_->_tmp60_);
				}
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				_g_hash_table_unref0 (_data_->meta);
				_g_object_unref0 (_data_->box);
				_g_free0 (_data_->id);
			}
		}
	}
	_data_->_tmp64_ = _data_->self->priv->app;
	g_application_release ((GApplication*) _data_->_tmp64_);
	_data_->_tmp65_ = _data_->metas;
	_data_->_tmp65__length1 = _data_->metas_length1;
	_data_->_tmp66_ = _data_->n;
	_data_->_tmp67_ = ((_data_->_tmp65_ + 0) != NULL) ? _vala_array_dup1 (_data_->_tmp65_ + 0, _data_->_tmp66_ - 0) : ((gpointer) (_data_->_tmp65_ + 0));
	_data_->_tmp67__length1 = _data_->_tmp66_ - 0;
	_data_->_tmp68_ = _data_->_tmp67_;
	_data_->_tmp68__length1 = _data_->_tmp67__length1;
	_data_->result_length1 = _data_->_tmp68__length1;
	_data_->result = _data_->_tmp68_;
	_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->metas = (_vala_array_free (_data_->metas, _data_->metas_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void boxes_search_provider_ActivateResult (BoxesSearchProvider* self, const gchar* search_id) {
	BoxesSearchProviderApp* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	BoxesDisplayProperties* _tmp5_;
	BoxesDisplayProperties* box;
	BoxesDisplayProperties* _tmp6_;
	BoxesDisplayProperties* _tmp11_;
	BoxesDisplayConfig* _tmp12_;
	BoxesDisplayConfig* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* uuid;
	BoxesSearchProviderApp* _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_id != NULL);
	_tmp0_ = self->priv->app;
	g_application_hold ((GApplication*) _tmp0_);
	_tmp1_ = search_id;
	g_debug ("gnome-boxes-search-provider.vala:149: ActivateResult (%s)", _tmp1_);
	_tmp2_ = self->priv->boxes;
	_tmp3_ = search_id;
	_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 ((BoxesDisplayProperties*) _tmp4_);
	box = _tmp5_;
	_tmp6_ = box;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		BoxesSearchProviderApp* _tmp10_;
		_tmp7_ = search_id;
		_tmp8_ = g_strconcat ("Can't find id: ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("gnome-boxes-search-provider.vala:153: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->app;
		g_application_release ((GApplication*) _tmp10_);
		_g_object_unref0 (box);
		return;
	}
	_tmp11_ = box;
	_tmp12_ = boxes_display_properties_get_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = boxes_display_config_get_uuid (_tmp13_);
	_tmp15_ = _tmp14_;
	uuid = _tmp15_;
	{
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* cmd;
		const gchar* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_;
		_tmp16_ = uuid;
		_tmp17_ = g_strconcat ("gnome-boxes --open-uuid ", _tmp16_, NULL);
		cmd = _tmp17_;
		_tmp18_ = cmd;
		_tmp19_ = g_spawn_command_line_async (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			_g_free0 (cmd);
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			_g_free0 (cmd);
			_g_free0 (uuid);
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp20_) {
			FILE* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = stderr;
			_tmp22_ = uuid;
			fprintf (_tmp21_, "Failed to launch Boxes with uuid '%s'\n", _tmp22_);
		}
		_g_free0 (cmd);
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp23_;
		const gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = uuid;
		fprintf (_tmp23_, "Failed to launch Boxes with uuid '%s'\n", _tmp24_);
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		g_warning ("gnome-boxes-search-provider.vala:165: %s", _tmp26_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (uuid);
		_g_object_unref0 (box);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp27_ = self->priv->app;
	g_application_release ((GApplication*) _tmp27_);
	_g_free0 (uuid);
	_g_object_unref0 (box);
}


gboolean boxes_search_provider_get_loaded (BoxesSearchProvider* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_loaded;
	result = _tmp0_;
	return result;
}


void boxes_search_provider_set_loaded (BoxesSearchProvider* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_loaded = _tmp0_;
	g_object_notify ((GObject *) self, "loaded");
}


static void boxes_search_provider_class_init (BoxesSearchProviderClass * klass) {
	boxes_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesSearchProviderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_search_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_search_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_search_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SEARCH_PROVIDER_LOADED, g_param_spec_boolean ("loaded", "loaded", "loaded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void boxes_search_provider_instance_init (BoxesSearchProvider * self) {
	self->priv = BOXES_SEARCH_PROVIDER_GET_PRIVATE (self);
}


static void boxes_search_provider_finalize (GObject* obj) {
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	_g_object_unref0 (self->priv->app);
	_g_hash_table_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (boxes_search_provider_parent_class)->finalize (obj);
}


GType boxes_search_provider_get_type (void) {
	static volatile gsize boxes_search_provider_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_search_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSearchProvider), 0, (GInstanceInitFunc) boxes_search_provider_instance_init, NULL };
		GType boxes_search_provider_type_id;
		boxes_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesSearchProvider", &g_define_type_info, 0);
		g_type_set_qdata (boxes_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) boxes_search_provider_register_object);
		g_once_init_leave (&boxes_search_provider_type_id__volatile, boxes_search_provider_type_id);
	}
	return boxes_search_provider_type_id__volatile;
}


static void _vala_boxes_search_provider_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	switch (property_id) {
		case BOXES_SEARCH_PROVIDER_LOADED:
		g_value_set_boolean (value, boxes_search_provider_get_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_boxes_search_provider_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BoxesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SEARCH_PROVIDER, BoxesSearchProvider);
	switch (property_id) {
		case BOXES_SEARCH_PROVIDER_LOADED:
		boxes_search_provider_set_loaded (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_boxes_search_provider_GetInitialResultSet (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	int terms_length1 = 0;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	terms = _tmp1_;
	g_variant_unref (_tmp0_);
	boxes_search_provider_GetInitialResultSet (self, terms, terms_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetInitialResultSet_ready, invocation);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_boxes_search_provider_GetInitialResultSet_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	int _tmp6_;
	invocation = _user_data_;
	result = boxes_search_provider_GetInitialResultSet_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_boxes_search_provider_GetSubsearchResultSet (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** previous_results = NULL;
	int previous_results_length1 = 0;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	int _tmp8__length;
	int _tmp8__size;
	int _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	gchar** new_terms = NULL;
	int new_terms_length1 = 0;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	int _tmp12__length;
	int _tmp12__size;
	int _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	new_terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	new_terms = _tmp12_;
	g_variant_unref (_tmp11_);
	boxes_search_provider_GetSubsearchResultSet (self, previous_results, previous_results_length1, new_terms, new_terms_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetSubsearchResultSet_ready, invocation);
	previous_results = (_vala_array_free (previous_results, previous_results_length1, (GDestroyNotify) g_free), NULL);
	new_terms = (_vala_array_free (new_terms, new_terms_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_boxes_search_provider_GetSubsearchResultSet_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	int _tmp17_;
	invocation = _user_data_;
	result = boxes_search_provider_GetSubsearchResultSet_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_boxes_search_provider_GetResultMetas (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar** ids = NULL;
	int ids_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	int _tmp19__length;
	int _tmp19__size;
	int _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	ids_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	ids = _tmp19_;
	g_variant_unref (_tmp18_);
	boxes_search_provider_GetResultMetas (self, ids, ids_length1, (GAsyncReadyCallback) _dbus_boxes_search_provider_GetResultMetas_ready, invocation);
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
}


static void _dbus_boxes_search_provider_GetResultMetas_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	int result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	int _tmp24_;
	invocation = _user_data_;
	result = boxes_search_provider_GetResultMetas_finish ((BoxesSearchProvider*) source_object, _res_, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_boxes_search_provider_ActivateResult (BoxesSearchProvider* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* search_id = NULL;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	search_id = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	boxes_search_provider_ActivateResult (self, search_id);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (search_id);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void boxes_search_provider_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_boxes_search_provider_GetInitialResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_boxes_search_provider_GetSubsearchResultSet (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_boxes_search_provider_GetResultMetas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_boxes_search_provider_ActivateResult (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_boxes_search_provider_get_loaded (BoxesSearchProvider* self) {
	gboolean result;
	GVariant* _reply;
	result = boxes_search_provider_get_loaded (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* boxes_search_provider_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Loaded") == 0) {
		return _dbus_boxes_search_provider_get_loaded (object);
	}
	return NULL;
}


static void _dbus_boxes_search_provider_set_loaded (BoxesSearchProvider* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	boxes_search_provider_set_loaded (self, value);
}


static gboolean boxes_search_provider_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Loaded") == 0) {
		_dbus_boxes_search_provider_set_loaded (object, value);
		return TRUE;
	}
	return FALSE;
}


guint boxes_search_provider_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_boxes_search_provider_dbus_interface_info), &_boxes_search_provider_dbus_interface_vtable, data, _boxes_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _boxes_search_provider_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


BoxesSearchProviderApp* boxes_search_provider_app_construct (GType object_type) {
	BoxesSearchProviderApp * self = NULL;
	self = (BoxesSearchProviderApp*) g_object_new (object_type, "application-id", "org.gnome.Boxes.SearchProvider", "flags", G_APPLICATION_IS_SERVICE, "inactivity-timeout", 10000, NULL);
	return self;
}


BoxesSearchProviderApp* boxes_search_provider_app_new (void) {
	return boxes_search_provider_app_construct (BOXES_TYPE_SEARCH_PROVIDER_APP);
}


static gboolean boxes_search_provider_app_real_dbus_register (GApplication* base, GDBusConnection* connection, const gchar* object_path, GError** error) {
	BoxesSearchProviderApp * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (BoxesSearchProviderApp*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		GDBusConnection* _tmp0_;
		const gchar* _tmp1_;
		BoxesSearchProvider* _tmp2_;
		BoxesSearchProvider* _tmp3_;
		_tmp0_ = connection;
		_tmp1_ = object_path;
		_tmp2_ = boxes_search_provider_new (self);
		_tmp3_ = _tmp2_;
		boxes_search_provider_register_object (_tmp3_, _tmp0_, _tmp1_, &_inner_error_);
		_g_object_unref0 (_tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "Could not register service: %s", _tmp6_);
		g_application_quit ((GApplication*) self);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void boxes_search_provider_app_real_startup (GApplication* base) {
	BoxesSearchProviderApp * self;
	const gchar* _tmp0_ = NULL;
	self = (BoxesSearchProviderApp*) base;
	_tmp0_ = g_getenv ("BOXES_SEARCH_PROVIDER_PERSIST");
	if (_tmp0_ != NULL) {
		g_application_hold ((GApplication*) self);
	}
	G_APPLICATION_CLASS (boxes_search_provider_app_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
}


static void boxes_search_provider_app_class_init (BoxesSearchProviderAppClass * klass) {
	boxes_search_provider_app_parent_class = g_type_class_peek_parent (klass);
	G_APPLICATION_CLASS (klass)->dbus_register = boxes_search_provider_app_real_dbus_register;
	G_APPLICATION_CLASS (klass)->startup = boxes_search_provider_app_real_startup;
}


static void boxes_search_provider_app_instance_init (BoxesSearchProviderApp * self) {
}


GType boxes_search_provider_app_get_type (void) {
	static volatile gsize boxes_search_provider_app_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_search_provider_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesSearchProviderAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_search_provider_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSearchProviderApp), 0, (GInstanceInitFunc) boxes_search_provider_app_instance_init, NULL };
		GType boxes_search_provider_app_type_id;
		boxes_search_provider_app_type_id = g_type_register_static (g_application_get_type (), "BoxesSearchProviderApp", &g_define_type_info, 0);
		g_once_init_leave (&boxes_search_provider_app_type_id__volatile, boxes_search_provider_app_type_id);
	}
	return boxes_search_provider_app_type_id__volatile;
}


gint _vala_main (void) {
	gint result = 0;
	BoxesSearchProviderApp* _tmp0_;
	BoxesSearchProviderApp* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	_tmp0_ = boxes_search_provider_app_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, 0, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main ();
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



