/* rygel-searchable-container.c generated by valac 0.17.4.16-52707, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	gint _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	RygelMediaObjects* _tmp4_;
	RygelMediaObjects* children;
	guint limit;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* _tmp9_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _child_size;
	gint _child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	RygelMediaObjects* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	RygelMediaObject* child;
	gboolean _tmp19_;
	RygelSearchExpression* _tmp20_;
	RygelSearchExpression* _tmp21_;
	RygelMediaObject* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	RygelMediaObjects* _tmp25_;
	RygelMediaObject* _tmp26_;
	gboolean _tmp27_;
	guint _tmp28_;
	RygelMediaObjects* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	guint _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	RygelMediaObjects* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	guint _tmp39_;
	gboolean _tmp40_;
	guint _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	RygelMediaObjects* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	guint _tmp47_;
	guint child_limit;
	RygelSearchExpression* _tmp48_;
	RygelMediaObjects* _tmp49_;
	guint _tmp50_;
	const gchar* _tmp51_;
	GCancellable* _tmp52_;
	RygelMediaObjects* _tmp53_;
	RygelMediaObjects* child_results;
	RygelMediaObjects* _tmp54_;
	RygelMediaObjects* _tmp55_;
	guint _tmp56_;
	RygelMediaObjects* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	guint _tmp60_;
	RygelMediaObjects* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	RygelMediaObjects* _tmp64_;
	gboolean _tmp65_;
	RygelMediaObjects* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gboolean _tmp69_;
	guint _tmp70_;
	guint _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	guint stop;
	gboolean _tmp74_;
	guint _tmp75_;
	guint _tmp76_;
	guint _tmp77_;
	RygelMediaObjects* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	gboolean _tmp81_;
	guint _tmp82_;
	guint _tmp83_;
	RygelMediaObjects* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	RygelMediaObjects* _tmp87_;
	guint _tmp88_;
	guint _tmp89_;
	GeeList* _tmp90_;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	RygelRelationalExpression* _tmp0_;
	RygelRelationalExpression* expression;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint total_matches;
	GCancellable* _tmp4_;
	guint _tmp5_;
	RygelMediaObjects* _tmp6_;
	RygelMediaObjects* results;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	RygelSearchExpression* expression;
	RygelMediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* _result_;
	RygelMediaObjects* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_size;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	RygelMediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	RygelMediaObject* child;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	RygelSearchableContainer* container;
	guint tmp;
	RygelSearchableContainer* _tmp15_;
	RygelSearchExpression* _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	RygelMediaObjects* _tmp21_;
	RygelMediaObjects* child_result;
	RygelMediaObjects* _tmp22_;
	RygelMediaObjects* _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	guint _tmp29_;
	gboolean _tmp30_;
	GError * _inner_error_;
};



GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_search_expression_satisfied_by (RygelSearchExpression* self, RygelMediaObject* media_object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
#line 428 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 435 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 454 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 461 "rygel-searchable-container.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 468 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp5_ = sort_criteria;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp7_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp8_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 521 "rygel-searchable-container.c"
}


RygelMediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 532 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (total_matches) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 540 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 548 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 578 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 587 "rygel-searchable-container.c"
		goto _state_0;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 591 "rygel-searchable-container.c"
		goto _state_1;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 2:
#line 595 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 600 "rygel-searchable-container.c"
	}
	_state_0:
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = ((RygelMediaContainer*) _data_->self)->child_count;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->sort_criteria;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, rygel_searchable_container_simple_search_ready, _data_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 619 "rygel-searchable-container.c"
	_state_1:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp4_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 639 "rygel-searchable-container.c"
		} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 643 "rygel-searchable-container.c"
		}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 649 "rygel-searchable-container.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->max_count;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp5_ > ((guint) 0)) {
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp6_ = _data_->offset;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp7_ = _data_->max_count;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp6_ + _data_->_tmp7_;
#line 661 "rygel-searchable-container.c"
	} else {
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 665 "rygel-searchable-container.c"
	}
	{
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp8_ = _data_->children;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp9_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp10_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp12_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp13_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp13_ + 1;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp14_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp15_ = _data_->_child_size;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 698 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp16_ = _data_->_child_list;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp17_ = _data_->_child_index;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp18_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, _data_->_tmp17_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp18_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp20_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp20_ == NULL) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp19_ = TRUE;
#line 716 "rygel-searchable-container.c"
			} else {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->expression;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->child;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp23_ = FALSE;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp23_ = rygel_search_expression_satisfied_by (_data_->_tmp21_, _data_->_tmp22_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->_tmp23_;
#line 728 "rygel-searchable-container.c"
			}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp24_ = _data_->_tmp19_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp24_) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp25_ = _data_->_result_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->child;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, _data_->_tmp26_);
#line 740 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp28_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp28_ > ((guint) 0)) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->_result_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp29_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp32_ = _data_->limit;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp27_ = ((guint) _data_->_tmp31_) >= _data_->_tmp32_;
#line 756 "rygel-searchable-container.c"
			} else {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp27_ = FALSE;
#line 760 "rygel-searchable-container.c"
			}
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp33_ = _data_->_tmp27_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp33_) {
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 770 "rygel-searchable-container.c"
			}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 774 "rygel-searchable-container.c"
		}
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 778 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp35_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp35_ == ((guint) 0)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp34_ = TRUE;
#line 786 "rygel-searchable-container.c"
	} else {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp36_ = _data_->_result_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp36_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp39_ = _data_->limit;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp34_ = ((guint) _data_->_tmp38_) < _data_->_tmp39_;
#line 798 "rygel-searchable-container.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp40_ = _data_->_tmp34_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp40_) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp42_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp42_ == ((guint) 0)) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp41_ = (guint) 0;
#line 810 "rygel-searchable-container.c"
		} else {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp43_ = _data_->limit;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp44_ = _data_->_result_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp44_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp41_ = _data_->_tmp43_ - _data_->_tmp46_;
#line 822 "rygel-searchable-container.c"
		}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp47_ = _data_->_tmp41_;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp47_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp48_ = _data_->expression;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp49_ = _data_->children;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp50_ = _data_->child_limit;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp51_ = _data_->sort_criteria;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp52_ = _data_->cancellable;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, rygel_searchable_container_simple_search_ready, _data_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 844 "rygel-searchable-container.c"
		_state_2:
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp53_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp53_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp53_;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 866 "rygel-searchable-container.c"
			} else {
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 870 "rygel-searchable-container.c"
			}
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			return FALSE;
#line 876 "rygel-searchable-container.c"
		}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp54_ = _data_->_result_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->child_results;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp54_, (GeeCollection*) _data_->_tmp55_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 886 "rygel-searchable-container.c"
	}
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp56_ = _data_->max_count;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp56_ > ((guint) 0)) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 894 "rygel-searchable-container.c"
	} else {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->_result_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp58_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp57_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp59_ = _data_->_tmp58_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp59_;
#line 904 "rygel-searchable-container.c"
	}
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp60_ = _data_->offset;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp61_ = _data_->_result_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp62_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp61_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp63_ = _data_->_tmp62_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp60_ >= ((guint) _data_->_tmp63_)) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp64_ = rygel_media_objects_new ();
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp64_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 928 "rygel-searchable-container.c"
		} else {
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 932 "rygel-searchable-container.c"
		}
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 938 "rygel-searchable-container.c"
	}
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp66_ = _data_->_result_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp66_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp68_ = _data_->_tmp67_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp68_ > 0) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp70_ = _data_->max_count;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp70_ > ((guint) 0)) {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp69_ = TRUE;
#line 954 "rygel-searchable-container.c"
		} else {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp71_ = _data_->offset;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp69_ = _data_->_tmp71_ > ((guint) 0);
#line 960 "rygel-searchable-container.c"
		}
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp72_ = _data_->_tmp69_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp65_ = _data_->_tmp72_;
#line 966 "rygel-searchable-container.c"
	} else {
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp65_ = FALSE;
#line 970 "rygel-searchable-container.c"
	}
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp73_ = _data_->_tmp65_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp73_) {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp75_ = _data_->max_count;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp75_ != ((guint) 0)) {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->offset;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp77_ = _data_->max_count;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp78_ = _data_->_result_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp78_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp80_ = _data_->_tmp79_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp74_ = (_data_->_tmp76_ + _data_->_tmp77_) <= ((guint) _data_->_tmp80_);
#line 992 "rygel-searchable-container.c"
		} else {
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp74_ = FALSE;
#line 996 "rygel-searchable-container.c"
		}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp81_ = _data_->_tmp74_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_tmp81_) {
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp82_ = _data_->offset;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp83_ = _data_->max_count;
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp82_ + _data_->_tmp83_;
#line 1008 "rygel-searchable-container.c"
		} else {
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp84_ = _data_->_result_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp85_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp84_);
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp86_ = _data_->_tmp85_;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp86_;
#line 1018 "rygel-searchable-container.c"
		}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp87_ = _data_->_result_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp88_ = _data_->offset;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp89_ = _data_->stop;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp90_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp90_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp87_, (gint) _data_->_tmp88_, (gint) _data_->_tmp89_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp90_, RYGEL_TYPE_MEDIA_OBJECTS) ? ((RygelMediaObjects*) _data_->_tmp90_) : NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1040 "rygel-searchable-container.c"
		} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1044 "rygel-searchable-container.c"
		}
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1050 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1060 "rygel-searchable-container.c"
	} else {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1064 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1078 "rygel-searchable-container.c"
	} else {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1082 "rygel-searchable-container.c"
	}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1088 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1105 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_find_object);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1140 "rygel-searchable-container.c"
}


RygelMediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 1151 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 1161 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1185 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 1194 "rygel-searchable-container.c"
		goto _state_0;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 1198 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1203 "rygel-searchable-container.c"
	}
	_state_0:
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_relational_expression_new ();
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_EQ);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup ("@id");
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand1);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand1 = _data_->_tmp1_;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->id;
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (((RygelSearchExpression*) _data_->expression)->operand2);
#line 157 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	((RygelSearchExpression*) _data_->expression)->operand2 = _data_->_tmp3_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp4_ = _data_->cancellable;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp5_ = 0U;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (RygelSearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->_tmp4_, rygel_searchable_container_find_object_ready, _data_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1236 "rygel-searchable-container.c"
	_state_1:
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp6_ = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp6_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp5_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp6_;
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1258 "rygel-searchable-container.c"
		} else {
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1262 "rygel-searchable-container.c"
		}
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1268 "rygel-searchable-container.c"
	}
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_tmp8_ > 0) {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp9_ = NULL;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = (RygelMediaObject*) _data_->_tmp9_;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1290 "rygel-searchable-container.c"
		} else {
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1294 "rygel-searchable-container.c"
		}
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1300 "rygel-searchable-container.c"
	} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1312 "rygel-searchable-container.c"
		} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1316 "rygel-searchable-container.c"
		}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return FALSE;
#line 1322 "rygel-searchable-container.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1332 "rygel-searchable-container.c"
	} else {
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1336 "rygel-searchable-container.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1342 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1363 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, RygelSearchExpression* expression, RygelMediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _tmp4_;
	guint _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp6_ = sort_criteria;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp7_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp8_ = cancellable;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->cancellable = _tmp9_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1419 "rygel-searchable-container.c"
}


static RygelMediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		return NULL;
#line 1430 "rygel-searchable-container.c"
	}
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	result = _data_->result;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return result;
#line 1440 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1454 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 0:
#line 1463 "rygel-searchable-container.c"
		goto _state_0;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		case 1:
#line 1467 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1472 "rygel-searchable-container.c"
	}
	_state_0:
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_tmp0_ = rygel_media_objects_new ();
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1479 "rygel-searchable-container.c"
	{
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1511 "rygel-searchable-container.c"
			}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->child = (RygelMediaObject*) _data_->_tmp11_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->sort_criteria;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->cancellable;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp20_ = 0U;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, rygel_searchable_container_search_in_children_ready, _data_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				return FALSE;
#line 1551 "rygel-searchable-container.c"
				_state_1:
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp21_ = NULL;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp20_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp21_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1579 "rygel-searchable-container.c"
					} else {
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1583 "rygel-searchable-container.c"
					}
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
					return FALSE;
#line 1589 "rygel-searchable-container.c"
				}
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp23_ = _data_->child_result;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp22_, (GeeCollection*) _data_->_tmp23_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1601 "rygel-searchable-container.c"
			}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp25_ = _data_->limit;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp25_ > ((guint) 0)) {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->_result_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->limit;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp24_ = ((guint) _data_->_tmp28_) >= _data_->_tmp29_;
#line 1617 "rygel-searchable-container.c"
			} else {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_data_->_tmp24_ = FALSE;
#line 1621 "rygel-searchable-container.c"
			}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_data_->_tmp30_ = _data_->_tmp24_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (_data_->_tmp30_) {
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 198 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1631 "rygel-searchable-container.c"
			}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1635 "rygel-searchable-container.c"
		}
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1639 "rygel-searchable-container.c"
	}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1647 "rygel-searchable-container.c"
	} else {
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1651 "rygel-searchable-container.c"
	}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1663 "rygel-searchable-container.c"
	} else {
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1667 "rygel-searchable-container.c"
	}
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return FALSE;
#line 1673 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1680 "rygel-searchable-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _search_class_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_size;
		gint _search_class_index;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		while (TRUE) {
#line 1711 "rygel-searchable-container.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* search_class;
			GUPnPDIDLLiteContainer* _tmp12_;
			const gchar* _tmp13_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
				break;
#line 1733 "rygel-searchable-container.c"
			}
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 1751 "rygel-searchable-container.c"
		}
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 1755 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 1765 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 30 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 1774 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
	if (!initialized) {
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		initialized = TRUE;
#line 29 "/home/jens/Source/rygel/src/librygel-server/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1787 "rygel-searchable-container.c"
	}
}


GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



