/* rygel-av-transport.c generated by valac 0.20.1.2-ca5c2, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelAvTransportHandlePlaylistData RygelAvTransportHandlePlaylistData;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	gchar* protocol_info;
	gchar* _status;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
	RygelPlayerController* controller;
};

struct _Block1Data {
	int _ref_count_;
	RygelAVTransport * self;
	gchar* _uri;
	gchar* _metadata;
	GUPnPServiceAction* action;
};

struct _Block2Data {
	int _ref_count_;
	RygelAVTransport * self;
	gpointer _async_data_;
};

struct _RygelAvTransportHandlePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	Block2Data* _data2_;
	RygelPlayerController* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* message;
	SoupSession* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessage* _tmp6_;
	SoupMessage* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GUPnPServiceAction* _tmp10_;
	const gchar* _tmp11_;
	SoupMessage* _tmp12_;
	SoupMessageBody* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	const gchar* xml_string;
	const gchar* _tmp15_;
	GUPnPMediaCollection* _tmp16_;
	GUPnPMediaCollection* collection;
	GUPnPMediaCollection* _tmp17_;
	GList* _tmp18_;
	GList* _tmp19_;
	guint _tmp20_;
	gboolean _tmp21_;
	GUPnPServiceAction* _tmp22_;
	const gchar* _tmp23_;
	RygelPlayerController* _tmp24_;
	GUPnPMediaCollection* _tmp25_;
	GUPnPServiceAction* _tmp26_;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_TRACK_METADATA,
	RYGEL_AV_TRANSPORT_TRACK_URI,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:AVTransport:1"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_SoupURI_free (SoupURI* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
gchar* rygel_av_transport_get_track_metadata (RygelAVTransport* self);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
gchar* rygel_av_transport_get_track_uri (RygelAVTransport* self);
const gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection);
static void ___lambda4_ (Block1Data* _data1_, SoupMessage* msg);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
void rygel_av_transport_set_track_metadata (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_track_uri (RygelAVTransport* self, const gchar* value);
static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime);
static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features);
static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_);
void rygel_media_player_set_mime_type (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_content_features (RygelMediaPlayer* self, const gchar* value);
static void ____lambda4__soup_message_finished (SoupMessage* _sender, gpointer self);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gint64 rygel_time_utils_time_from_string (const gchar* str);
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
static void rygel_av_transport_handle_playlist_data_free (gpointer _data);
static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_);
static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gchar* rygel_av_transport_unescape (RygelAVTransport* self, const gchar* input);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
gchar* rygel_media_player_get_metadata (RygelMediaPlayer* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
gchar* rygel_media_player_get_uri (RygelMediaPlayer* self);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_av_transport_query_last_change_cb (self, _sender, variable, value);
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_set_av_transport_uri_cb (self, _sender, action);
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_media_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_media_info_ex_cb (self, _sender, action);
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_position_info_cb (self, _sender, action);
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_device_capabilities_cb (self, _sender, action);
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_settings_cb (self, _sender, action);
}


static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_actions_cb (self, _sender, action);
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_stop_cb (self, _sender, action);
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_play_cb (self, _sender, action);
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_pause_cb (self, _sender, action);
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_seek_cb (self, _sender, action);
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_next_cb (self, _sender, action);
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_previous_cb (self, _sender, action);
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_state_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_n_tracks_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_uri_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_meta_data_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_duration_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_uri_cb (self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_meta_data_cb (self, _sender, pspec);
}


static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelChangeLog* _tmp7_;
	RygelMediaPlayer* _tmp8_ = NULL;
	RygelMediaRendererPlugin* _tmp9_;
	RygelPlayerController* _tmp10_ = NULL;
	RygelPlayerController* _tmp11_;
	RygelPlayerController* _tmp12_;
	RygelPlayerController* _tmp13_;
	RygelPlayerController* _tmp14_;
	RygelPlayerController* _tmp15_;
	RygelMediaPlayer* _tmp16_;
	RygelMediaPlayer* _tmp17_;
	RygelMediaPlayer* _tmp18_;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* proxy;
	const gchar* _tmp21_;
	SoupSession* _tmp35_;
	RygelMediaRendererPlugin* _tmp36_;
	gchar* _tmp37_ = NULL;
	self = (RygelAVTransport*) base;
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp7_;
	_tmp8_ = rygel_av_transport_get_player (self);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp8_;
	_tmp9_ = plugin;
	_tmp10_ = rygel_media_renderer_plugin_get_controller (_tmp9_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp10_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentTransportActions", (GCallback) _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
	_tmp11_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
	_tmp12_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::n-tracks", (GCallback) _rygel_av_transport_notify_n_tracks_cb_g_object_notify, self, 0);
	_tmp13_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::track", (GCallback) _rygel_av_transport_notify_track_cb_g_object_notify, self, 0);
	_tmp14_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
	_tmp15_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
	_tmp16_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
	_tmp17_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::uri", (GCallback) _rygel_av_transport_notify_track_uri_cb_g_object_notify, self, 0);
	_tmp18_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::metadata", (GCallback) _rygel_av_transport_notify_track_meta_data_cb_g_object_notify, self, 0);
	_tmp19_ = g_getenv ("http_proxy");
	_tmp20_ = g_strdup (_tmp19_);
	proxy = _tmp20_;
	_tmp21_ = proxy;
	if (_tmp21_ != NULL) {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp27_;
		const gchar* _tmp30_;
		SoupURI* _tmp31_;
		SoupURI* _tmp32_;
		SoupSessionAsync* _tmp33_;
		_tmp23_ = proxy;
		_tmp24_ = g_str_has_prefix (_tmp23_, "http://");
		if (!_tmp24_) {
			const gchar* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = proxy;
			_tmp26_ = g_str_has_prefix (_tmp25_, "https://");
			_tmp22_ = !_tmp26_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp27_ = _tmp22_;
		if (_tmp27_) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = proxy;
			_tmp29_ = g_strconcat ("http://", _tmp28_, NULL);
			_g_free0 (proxy);
			proxy = _tmp29_;
		}
		_tmp30_ = proxy;
		_tmp31_ = soup_uri_new (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = (SoupSessionAsync*) soup_session_async_new_with_options (SOUP_SESSION_PROXY_URI, _tmp32_, NULL);
		_g_object_unref0 (self->priv->session);
		self->priv->session = (SoupSession*) _tmp33_;
		__vala_SoupURI_free0 (_tmp32_);
	} else {
		SoupSessionAsync* _tmp34_;
		_tmp34_ = (SoupSessionAsync*) soup_session_async_new ();
		_g_object_unref0 (self->priv->session);
		self->priv->session = (SoupSession*) _tmp34_;
	}
	_tmp35_ = self->priv->session;
	soup_session_add_feature_by_type (_tmp35_, soup_proxy_resolver_default_get_type ());
	_tmp36_ = plugin;
	_tmp37_ = rygel_media_renderer_plugin_get_protocol_info (_tmp36_);
	_g_free0 (self->priv->protocol_info);
	self->priv->protocol_info = _tmp37_;
	_g_free0 (proxy);
	_g_object_unref0 (plugin);
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_;
	GUPnPRootDevice* _tmp2_;
	GUPnPResourceFactory* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	RygelMediaRendererPlugin* _tmp5_;
	RygelMediaRendererPlugin* _tmp6_;
	RygelMediaRendererPlugin* plugin;
	RygelMediaPlayer* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp7_;
	_g_object_unref0 (plugin);
	return result;
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* _tmp0_;
	RygelChangeLog* log;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelPlayerController* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaPlayer* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	RygelPlayerController* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	RygelMediaPlayer* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	RygelMediaPlayer* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	RygelPlayerController* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	RygelPlayerController* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp1_ = self->priv->player;
	_tmp2_ = rygel_media_player_get_playback_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (log, "TransportState", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->controller;
	_tmp6_ = rygel_player_controller_get_current_transport_actions (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	rygel_change_log_log (log, "CurrentTransportActions", _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = rygel_av_transport_get_status (self);
	_tmp10_ = _tmp9_;
	rygel_change_log_log (log, "TransportStatus", _tmp10_);
	rygel_change_log_log (log, "PlaybackStorageMedium", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
	_tmp11_ = rygel_av_transport_get_mode (self);
	_tmp12_ = _tmp11_;
	rygel_change_log_log (log, "CurrentPlayMode", _tmp12_);
	_tmp13_ = self->priv->player;
	_tmp14_ = rygel_media_player_get_playback_speed (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp16_);
	_g_free0 (_tmp16_);
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordQualityModes", "NOT_IMPLEMENTED");
	_tmp17_ = self->priv->controller;
	_tmp18_ = rygel_player_controller_get_n_tracks (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%u", _tmp19_);
	_tmp21_ = _tmp20_;
	rygel_change_log_log (log, "NumberOfTracks", _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = self->priv->controller;
	_tmp23_ = rygel_player_controller_get_track (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%u", _tmp24_);
	_tmp26_ = _tmp25_;
	rygel_change_log_log (log, "CurrentTrack", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = self->priv->player;
	_tmp28_ = rygel_media_player_get_duration_as_str (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_;
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->player;
	_tmp32_ = rygel_media_player_get_duration_as_str (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_;
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = rygel_av_transport_get_track_metadata (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_;
	_tmp38_ = g_markup_escape_text (_tmp37_, (gssize) (-1));
	_tmp39_ = _tmp38_;
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp39_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_tmp40_ = self->priv->controller;
	_tmp41_ = rygel_player_controller_get_metadata (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = g_markup_escape_text (_tmp43_, (gssize) (-1));
	_tmp45_ = _tmp44_;
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp45_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = rygel_av_transport_get_track_uri (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = _tmp47_;
	rygel_change_log_log (log, "CurrentTrackURI", _tmp48_);
	_g_free0 (_tmp48_);
	_tmp49_ = self->priv->controller;
	_tmp50_ = rygel_player_controller_get_uri (_tmp49_);
	_tmp51_ = _tmp50_;
	rygel_change_log_log (log, "AVTransportURI", _tmp51_);
	rygel_change_log_log (log, "NextAVTransportURI", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "NextAVTransportURIMetaData", "NOT_IMPLEMENTED");
	g_value_init (value, G_TYPE_STRING);
	_tmp52_ = rygel_change_log_finish (log);
	_tmp53_ = _tmp52_;
	g_value_set_string (value, _tmp53_);
	_g_free0 (_tmp53_);
	_g_object_unref0 (log);
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id;
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp6_;
	gint64 _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	instance_id = (gint64) (-1);
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
	_tmp2_ = instance_id_string;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = instance_id_string;
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
		instance_id = _tmp4_;
		_tmp1_ = !_tmp5_;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = action;
		_tmp8_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp7_, (guint) 402, _tmp8_);
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	_tmp9_ = instance_id;
	if (_tmp9_ != ((gint64) 0)) {
		GUPnPServiceAction* _tmp10_;
		const gchar* _tmp11_ = NULL;
		_tmp10_ = action;
		_tmp11_ = _ ("Invalid InstanceID");
		gupnp_service_action_return_error (_tmp10_, (guint) 718, _tmp11_);
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	result = TRUE;
	_g_free0 (instance_id_string);
	return result;
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelAVTransport * self;
		self = _data1_->self;
		_g_free0 (_data1_->_metadata);
		_g_free0 (_data1_->_uri);
		__vala_GUPnPServiceAction_free0 (_data1_->action);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, SoupMessage* msg) {
	RygelAVTransport * self;
	SoupMessage* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_;
	SoupMessage* _tmp12_;
	guint _tmp13_ = 0U;
	guint _tmp14_;
	self = _data1_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) SOUP_STATUS_BAD_REQUEST)) {
		GUPnPServiceAction* _tmp3_;
		RygelPlayerController* _tmp4_;
		const gchar* _tmp5_;
		RygelPlayerController* _tmp6_;
		const gchar* _tmp7_;
		RygelPlayerController* _tmp8_;
		RygelPlayerController* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp3_ = _data1_->action;
		gupnp_service_action_return (_tmp3_);
		_tmp4_ = self->priv->controller;
		_tmp5_ = _data1_->_metadata;
		rygel_player_controller_set_metadata (_tmp4_, _tmp5_);
		_tmp6_ = self->priv->controller;
		_tmp7_ = _data1_->_uri;
		rygel_player_controller_set_uri (_tmp6_, _tmp7_);
		_tmp8_ = self->priv->controller;
		rygel_player_controller_set_n_tracks (_tmp8_, (guint) 1);
		_tmp9_ = self->priv->controller;
		rygel_player_controller_set_track (_tmp9_, (guint) 1);
		_tmp10_ = _data1_->_metadata;
		rygel_av_transport_set_track_metadata (self, _tmp10_);
		_tmp11_ = _data1_->_uri;
		rygel_av_transport_set_track_uri (self, _tmp11_);
		return;
	}
	_tmp12_ = msg;
	g_object_get (_tmp12_, "status-code", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != ((guint) SOUP_STATUS_OK)) {
		const gchar* _tmp15_;
		SoupMessage* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GUPnPServiceAction* _tmp20_;
		const gchar* _tmp21_ = NULL;
		_tmp15_ = _data1_->_uri;
		_tmp16_ = msg;
		g_object_get (_tmp16_, "reason-phrase", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		g_warning ("rygel-av-transport.vala:266: Failed to access %s: %s", _tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = _data1_->action;
		_tmp21_ = _ ("Resource not found");
		gupnp_service_action_return_error (_tmp20_, (guint) 716, _tmp21_);
		return;
	} else {
		SoupMessage* _tmp22_;
		SoupMessageHeaders* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gchar* mime;
		SoupMessage* _tmp26_;
		SoupMessageHeaders* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* features;
		gboolean _tmp30_ = FALSE;
		const gchar* _tmp31_;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp36_;
		RygelPlayerController* _tmp39_;
		const gchar* _tmp40_;
		RygelPlayerController* _tmp41_;
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		_tmp22_ = msg;
		_tmp23_ = _tmp22_->response_headers;
		_tmp24_ = soup_message_headers_get_one (_tmp23_, "Content-Type");
		_tmp25_ = g_strdup (_tmp24_);
		mime = _tmp25_;
		_tmp26_ = msg;
		_tmp27_ = _tmp26_->response_headers;
		_tmp28_ = soup_message_headers_get_one (_tmp27_, "contentFeatures.dlna.org");
		_tmp29_ = g_strdup (_tmp28_);
		features = _tmp29_;
		_tmp31_ = mime;
		_tmp32_ = rygel_av_transport_is_valid_mime_type (self, _tmp31_);
		if (!_tmp32_) {
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gboolean _tmp35_ = FALSE;
			_tmp33_ = mime;
			_tmp34_ = features;
			_tmp35_ = rygel_av_transport_is_playlist (self, _tmp33_, _tmp34_);
			_tmp30_ = !_tmp35_;
		} else {
			_tmp30_ = FALSE;
		}
		_tmp36_ = _tmp30_;
		if (_tmp36_) {
			GUPnPServiceAction* _tmp37_;
			const gchar* _tmp38_ = NULL;
			_tmp37_ = _data1_->action;
			_tmp38_ = _ ("Illegal MIME-type");
			gupnp_service_action_return_error (_tmp37_, (guint) 714, _tmp38_);
			_g_free0 (features);
			_g_free0 (mime);
			return;
		}
		_tmp39_ = self->priv->controller;
		_tmp40_ = _data1_->_metadata;
		rygel_player_controller_set_metadata (_tmp39_, _tmp40_);
		_tmp41_ = self->priv->controller;
		_tmp42_ = _data1_->_uri;
		rygel_player_controller_set_uri (_tmp41_, _tmp42_);
		_tmp43_ = mime;
		_tmp44_ = features;
		_tmp45_ = rygel_av_transport_is_playlist (self, _tmp43_, _tmp44_);
		if (_tmp45_) {
			GUPnPServiceAction* _tmp46_;
			_tmp46_ = _data1_->action;
			rygel_av_transport_handle_playlist (self, _tmp46_, NULL, NULL);
		} else {
			RygelMediaPlayer* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			RygelPlayerController* _tmp55_;
			RygelPlayerController* _tmp56_;
			GUPnPServiceAction* _tmp57_;
			_tmp47_ = self->priv->player;
			_tmp48_ = mime;
			rygel_media_player_set_mime_type (_tmp47_, _tmp48_);
			_tmp49_ = features;
			if (_tmp49_ != NULL) {
				RygelMediaPlayer* _tmp50_;
				const gchar* _tmp51_;
				_tmp50_ = self->priv->player;
				_tmp51_ = features;
				rygel_media_player_set_content_features (_tmp50_, _tmp51_);
			} else {
				RygelMediaPlayer* _tmp52_;
				_tmp52_ = self->priv->player;
				rygel_media_player_set_content_features (_tmp52_, "*");
			}
			_tmp53_ = _data1_->_metadata;
			rygel_av_transport_set_track_metadata (self, _tmp53_);
			_tmp54_ = _data1_->_uri;
			rygel_av_transport_set_track_uri (self, _tmp54_);
			_tmp55_ = self->priv->controller;
			rygel_player_controller_set_n_tracks (_tmp55_, (guint) 1);
			_tmp56_ = self->priv->controller;
			rygel_player_controller_set_track (_tmp56_, (guint) 1);
			_tmp57_ = _data1_->action;
			gupnp_service_action_return (_tmp57_);
		}
		_g_free0 (features);
		_g_free0 (mime);
	}
}


static void ____lambda4__soup_message_finished (SoupMessage* _sender, gpointer self) {
	___lambda4_ (self, _sender);
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	Block1Data* _data1_;
	GUPnPServiceAction* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GUPnPServiceAction* _tmp4_;
	RygelPlayerController* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	__vala_GUPnPServiceAction_free0 (_data1_->action);
	_data1_->action = _tmp1_;
	_tmp2_ = _data1_->action;
	_tmp3_ = rygel_av_transport_check_instance_id (self, _tmp2_);
	if (!_tmp3_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp4_ = _data1_->action;
	gupnp_service_action_get (_tmp4_, "CurrentURI", G_TYPE_STRING, &_data1_->_uri, "CurrentURIMetaData", G_TYPE_STRING, &_data1_->_metadata, NULL);
	_tmp5_ = self->priv->controller;
	rygel_player_controller_set_playlist (_tmp5_, NULL);
	_tmp7_ = _data1_->_uri;
	_tmp8_ = g_str_has_prefix (_tmp7_, "http://");
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = _data1_->_uri;
		_tmp10_ = g_str_has_prefix (_tmp9_, "https://");
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		const gchar* _tmp12_;
		SoupMessage* _tmp13_;
		SoupMessage* message;
		SoupMessage* _tmp14_;
		SoupMessageHeaders* _tmp15_;
		SoupMessage* _tmp16_;
		SoupSession* _tmp17_;
		SoupMessage* _tmp18_;
		SoupMessage* _tmp19_;
		_tmp12_ = _data1_->_uri;
		_tmp13_ = soup_message_new ("HEAD", _tmp12_);
		message = _tmp13_;
		_tmp14_ = message;
		_tmp15_ = _tmp14_->request_headers;
		soup_message_headers_append (_tmp15_, "getContentFeatures.dlna.org", "1");
		_tmp16_ = message;
		g_signal_connect_data (_tmp16_, "finished", (GCallback) ____lambda4__soup_message_finished, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp17_ = self->priv->session;
		_tmp18_ = message;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		soup_session_queue_message (_tmp17_, _tmp19_, NULL, NULL);
		_g_object_unref0 (message);
	} else {
		RygelPlayerController* _tmp20_;
		const gchar* _tmp21_;
		RygelPlayerController* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GUPnPServiceAction* _tmp29_;
		_tmp20_ = self->priv->controller;
		_tmp21_ = _data1_->_metadata;
		rygel_player_controller_set_metadata (_tmp20_, _tmp21_);
		_tmp22_ = self->priv->controller;
		_tmp23_ = _data1_->_uri;
		rygel_player_controller_set_uri (_tmp22_, _tmp23_);
		_tmp24_ = _data1_->_uri;
		if (g_strcmp0 (_tmp24_, "") == 0) {
			RygelPlayerController* _tmp25_;
			RygelPlayerController* _tmp26_;
			_tmp25_ = self->priv->controller;
			rygel_player_controller_set_n_tracks (_tmp25_, (guint) 0);
			_tmp26_ = self->priv->controller;
			rygel_player_controller_set_track (_tmp26_, (guint) 0);
		} else {
			RygelPlayerController* _tmp27_;
			RygelPlayerController* _tmp28_;
			_tmp27_ = self->priv->controller;
			rygel_player_controller_set_n_tracks (_tmp27_, (guint) 1);
			_tmp28_ = self->priv->controller;
			rygel_player_controller_set_track (_tmp28_, (guint) 1);
		}
		_tmp29_ = _data1_->action;
		gupnp_service_action_return (_tmp29_);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* normalized;
	const gchar* _tmp6_;
	RygelMediaPlayer* _tmp7_;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mime;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = mime;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, " ", "");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	normalized = _tmp5_;
	_tmp6_ = normalized;
	_tmp7_ = self->priv->player;
	_tmp9_ = rygel_media_player_get_mime_types (_tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_tmp11_ = _vala_string_array_contains (_tmp10_, _tmp8_, _tmp6_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp11_;
	_g_free0 (normalized);
	return result;
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GUPnPServiceAction* _tmp9_;
	RygelPlayerController* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	RygelPlayerController* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GUPnPServiceAction* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > ((guint) 1)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp5_;
	} else {
		RygelMediaPlayer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->player;
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (media_duration);
		media_duration = _tmp8_;
	}
	_tmp9_ = action;
	_tmp10_ = self->priv->controller;
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = media_duration;
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->controller;
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	gupnp_service_action_set (_tmp9_, "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp20_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp20_);
	_tmp21_ = action;
	gupnp_service_action_return (_tmp21_);
	_g_free0 (media_duration);
}


static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GUPnPServiceAction* _tmp9_;
	RygelPlayerController* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
	RygelPlayerController* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelPlayerController* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GUPnPServiceAction* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > ((guint) 1)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp5_;
	} else {
		RygelMediaPlayer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->player;
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (media_duration);
		media_duration = _tmp8_;
	}
	_tmp9_ = action;
	_tmp10_ = self->priv->controller;
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = media_duration;
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->controller;
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	gupnp_service_action_set (_tmp9_, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp20_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_g_free0 (_tmp20_);
	_tmp21_ = action;
	gupnp_service_action_return (_tmp21_);
	_g_free0 (media_duration);
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	RygelMediaPlayer* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->player;
	_tmp4_ = rygel_media_player_get_playback_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = rygel_av_transport_get_status (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->player;
	_tmp10_ = rygel_media_player_get_playback_speed (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp6_, "CurrentTransportStatus", G_TYPE_STRING, _tmp8_, "CurrentSpeed", G_TYPE_STRING, _tmp12_, NULL);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp6_);
	_tmp13_ = action;
	gupnp_service_action_return (_tmp13_);
}


static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelPlayerController* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GUPnPServiceAction* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->controller;
	_tmp4_ = rygel_player_controller_get_current_transport_actions (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gupnp_service_action_set (_tmp2_, "Actions", G_TYPE_STRING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = action;
	gupnp_service_action_return (_tmp7_);
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	RygelPlayerController* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	RygelMediaPlayer* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RygelMediaPlayer* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GUPnPServiceAction* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->controller;
	_tmp4_ = rygel_player_controller_get_track (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = rygel_av_transport_get_track_metadata (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = rygel_av_transport_get_track_uri (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->player;
	_tmp17_ = rygel_media_player_get_position_as_str (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->player;
	_tmp21_ = rygel_media_player_get_position_as_str (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp24_ = G_MAXINT;
	_tmp25_ = G_MAXINT;
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp5_, "TrackDuration", G_TYPE_STRING, _tmp9_, "TrackMetaData", G_TYPE_STRING, _tmp12_, "TrackURI", G_TYPE_STRING, _tmp15_, "RelTime", G_TYPE_STRING, _tmp19_, "AbsTime", G_TYPE_STRING, _tmp23_, "RelCount", G_TYPE_INT, _tmp24_, "AbsCount", G_TYPE_INT, _tmp25_, NULL);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp26_ = action;
	gupnp_service_action_return (_tmp26_);
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	GUPnPServiceAction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp3_ = action;
	gupnp_service_action_return (_tmp3_);
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUPnPServiceAction* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = rygel_av_transport_get_mode (self);
	_tmp4_ = _tmp3_;
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp4_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	GUPnPServiceAction* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->player;
	rygel_media_player_set_playback_state (_tmp2_, "STOPPED");
	_tmp3_ = action;
	gupnp_service_action_return (_tmp3_);
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaPlayer* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp8_;
	RygelMediaPlayer* _tmp11_;
	RygelMediaPlayer* _tmp12_;
	const gchar* _tmp13_;
	GUPnPServiceAction* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
	_tmp3_ = speed;
	_tmp4_ = self->priv->player;
	_tmp5_ = rygel_media_player_get_allowed_playback_speeds (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = !_vala_string_array_contains (_tmp7_, _tmp6__length1, _tmp3_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp8_) {
		GUPnPServiceAction* _tmp9_;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = action;
		_tmp10_ = _ ("Play speed not supported");
		gupnp_service_action_return_error (_tmp9_, (guint) 717, _tmp10_);
		_g_free0 (speed);
		return;
	}
	_tmp11_ = self->priv->player;
	rygel_media_player_set_playback_state (_tmp11_, "PLAYING");
	_tmp12_ = self->priv->player;
	_tmp13_ = speed;
	rygel_media_player_set_playback_speed (_tmp12_, _tmp13_);
	_tmp14_ = action;
	gupnp_service_action_return (_tmp14_);
	_g_free0 (speed);
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelMediaPlayer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	RygelMediaPlayer* _tmp9_;
	GUPnPServiceAction* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->player;
	_tmp3_ = rygel_media_player_get_playback_state (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "PLAYING") != 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		GUPnPServiceAction* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = action;
		_tmp8_ = _ ("Transition not available");
		gupnp_service_action_return_error (_tmp7_, (guint) 701, _tmp8_);
		return;
	}
	_tmp9_ = self->priv->player;
	rygel_media_player_set_playback_state (_tmp9_, "PAUSED_PLAYBACK");
	_tmp10_ = action;
	gupnp_service_action_return (_tmp10_);
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
	_tmp3_ = unit;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				RygelMediaPlayer* _tmp8_;
				const gchar* _tmp9_;
				gint64 _tmp10_ = 0LL;
				gboolean _tmp11_ = FALSE;
				GUPnPServiceAction* _tmp14_;
				_tmp7_ = target;
				g_debug ("rygel-av-transport.vala:595: Seeking to %s.", _tmp7_);
				_tmp8_ = self->priv->player;
				_tmp9_ = target;
				_tmp10_ = rygel_time_utils_time_from_string (_tmp9_);
				_tmp11_ = rygel_media_player_seek (_tmp8_, _tmp10_);
				if (!_tmp11_) {
					GUPnPServiceAction* _tmp12_;
					const gchar* _tmp13_ = NULL;
					_tmp12_ = action;
					_tmp13_ = _ ("Seek mode not supported");
					gupnp_service_action_return_error (_tmp12_, (guint) 710, _tmp13_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp14_ = action;
				gupnp_service_action_return (_tmp14_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("TRACK_NR")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_ = 0;
				gint track;
				gboolean _tmp18_ = FALSE;
				gint _tmp19_;
				gboolean _tmp24_;
				RygelPlayerController* _tmp27_;
				gint _tmp28_;
				GUPnPServiceAction* _tmp29_;
				_tmp15_ = target;
				g_debug ("rygel-av-transport.vala:607: Setting track to %s.", _tmp15_);
				_tmp16_ = target;
				_tmp17_ = atoi (_tmp16_);
				track = _tmp17_;
				_tmp19_ = track;
				if (_tmp19_ < 1) {
					_tmp18_ = TRUE;
				} else {
					gint _tmp20_;
					RygelPlayerController* _tmp21_;
					guint _tmp22_;
					guint _tmp23_;
					_tmp20_ = track;
					_tmp21_ = self->priv->controller;
					_tmp22_ = rygel_player_controller_get_n_tracks (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp18_ = ((guint) _tmp20_) > _tmp23_;
				}
				_tmp24_ = _tmp18_;
				if (_tmp24_) {
					GUPnPServiceAction* _tmp25_;
					const gchar* _tmp26_ = NULL;
					_tmp25_ = action;
					_tmp26_ = _ ("Illegal seek target");
					gupnp_service_action_return_error (_tmp25_, (guint) 711, _tmp26_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp27_ = self->priv->controller;
				_tmp28_ = track;
				rygel_player_controller_set_track (_tmp27_, (guint) _tmp28_);
				_tmp29_ = action;
				gupnp_service_action_return (_tmp29_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GUPnPServiceAction* _tmp30_;
				const gchar* _tmp31_ = NULL;
				_tmp30_ = action;
				_tmp31_ = _ ("Seek mode not supported");
				gupnp_service_action_return_error (_tmp30_, (guint) 710, _tmp31_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	}
	_g_free0 (target);
	_g_free0 (unit);
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_next (_tmp0_);
	if (_tmp1_) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return (_tmp2_);
	} else {
		GUPnPServiceAction* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = action;
		_tmp4_ = _ ("Illegal seek target");
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
	}
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_previous (_tmp0_);
	if (_tmp1_) {
		GUPnPServiceAction* _tmp2_;
		_tmp2_ = action;
		gupnp_service_action_return (_tmp2_);
	} else {
		GUPnPServiceAction* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = action;
		_tmp4_ = _ ("Illegal seek target");
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
	}
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* state;
	RygelChangeLog* _tmp3_;
	RygelChangeLog* _tmp4_;
	RygelPlayerController* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	state = _tmp2_;
	_tmp3_ = self->priv->changelog;
	rygel_change_log_log (_tmp3_, "TransportState", state);
	_tmp4_ = self->priv->changelog;
	_tmp5_ = self->priv->controller;
	_tmp6_ = rygel_player_controller_get_current_transport_actions (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	rygel_change_log_log (_tmp4_, "CurrentTransportActions", _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (state);
}


static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_n_tracks (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "NumberOfTracks", _tmp5_);
	_g_free0 (_tmp5_);
}


static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "CurrentTrack", _tmp5_);
	_g_free0 (_tmp5_);
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelMediaPlayer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	RygelChangeLog* _tmp5_;
	RygelMediaPlayer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->player;
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->changelog;
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
	_g_free0 (_tmp9_);
}


static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = rygel_av_transport_get_track_uri (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp3_);
	_g_free0 (_tmp3_);
}


static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (_tmp0_, "AVTransportURI", _tmp3_);
}


static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = rygel_av_transport_get_track_metadata (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "CurrentTrackMetaData", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_;
	RygelPlayerController* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
	_tmp6_ = _tmp5_;
	rygel_change_log_log (_tmp0_, "AVTransportURIMetaData", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}


static void rygel_av_transport_handle_playlist_data_free (gpointer _data) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _data;
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAvTransportHandlePlaylistData, _data_);
}


static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelAvTransportHandlePlaylistData* _data_;
	RygelAVTransport* _tmp0_;
	GUPnPServiceAction* _tmp1_;
	GUPnPServiceAction* _tmp2_;
	_data_ = g_slice_new0 (RygelAvTransportHandlePlaylistData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_av_transport_handle_playlist);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_av_transport_handle_playlist_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = action;
	_tmp2_ = __vala_GUPnPServiceAction_copy0 (_tmp1_);
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_data_->action = _tmp2_;
	rygel_av_transport_handle_playlist_co (_data_);
}


static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelAVTransport * self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda5_ (Block2Data* _data2_) {
	RygelAVTransport * self;
	self = _data2_->self;
	rygel_av_transport_handle_playlist_co (_data2_->_async_data_);
}


static void ___lambda5__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda5_ (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->controller;
	_data_->_tmp1_ = rygel_player_controller_get_uri (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = soup_message_new ("GET", _data_->_tmp2_);
	_data_->message = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->session;
	_data_->_tmp5_ = _data_->message;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	soup_session_queue_message (_data_->_tmp4_, _data_->_tmp6_, ___lambda5__soup_session_callback, _data_->_data2_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp7_ = _data_->message;
	_data_->_tmp8_ = 0U;
	g_object_get (_data_->_tmp7_, "status-code", &_data_->_tmp8_, NULL);
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_tmp9_ != ((guint) 200)) {
		_data_->_tmp10_ = _data_->action;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Resource not found");
		gupnp_service_action_return_error (_data_->_tmp10_, (guint) 716, _data_->_tmp11_);
		_g_object_unref0 (_data_->message);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->message;
	_data_->_tmp13_ = _data_->_tmp12_->response_body;
	_data_->_tmp14_ = _data_->_tmp13_->data;
	_data_->_tmp14__length1 = (gint) _data_->_tmp13_->length;
	_data_->xml_string = (const gchar*) _data_->_tmp14_;
	_data_->_tmp15_ = _data_->xml_string;
	_data_->_tmp16_ = gupnp_media_collection_new_from_string (_data_->_tmp15_);
	_data_->collection = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->collection;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = gupnp_media_collection_get_items (_data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = 0U;
	_data_->_tmp20_ = g_list_length (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_ == ((guint) 0);
	__g_list_free__g_object_unref0_0 (_data_->_tmp19_);
	if (_data_->_tmp21_) {
		_data_->_tmp22_ = _data_->action;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _ ("Resource not found");
		gupnp_service_action_return_error (_data_->_tmp22_, (guint) 716, _data_->_tmp23_);
		_g_object_unref0 (_data_->collection);
		_g_object_unref0 (_data_->message);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = _data_->self->priv->controller;
	_data_->_tmp25_ = _data_->collection;
	rygel_player_controller_set_playlist (_data_->_tmp24_, _data_->_tmp25_);
	_data_->_tmp26_ = _data_->action;
	gupnp_service_action_return (_data_->_tmp26_);
	_g_object_unref0 (_data_->collection);
	_g_object_unref0 (_data_->message);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_av_transport_unescape (RygelAVTransport* self, const gchar* input) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = string_replace (_tmp0_, "&quot;", "\"");
	_result_ = _tmp1_;
	_tmp2_ = _result_;
	_tmp3_ = string_replace (_tmp2_, "&lt;", "<");
	_g_free0 (_result_);
	_result_ = _tmp3_;
	_tmp4_ = _result_;
	_tmp5_ = string_replace (_tmp4_, "&gt;", ">");
	_g_free0 (_result_);
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	_tmp7_ = string_replace (_tmp6_, "&apos;", "'");
	_g_free0 (_result_);
	_result_ = _tmp7_;
	_tmp8_ = _result_;
	_tmp9_ = string_replace (_tmp8_, "&amp;", "&");
	_g_free0 (_result_);
	_result_ = _tmp9_;
	result = _result_;
	return result;
}


static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime != NULL, FALSE);
	_tmp2_ = mime;
	if (g_strcmp0 (_tmp2_, "text/xml") == 0) {
		const gchar* _tmp3_;
		_tmp3_ = features;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = features;
		_tmp6_ = g_str_has_prefix (_tmp5_, "DLNA.ORG_PN=DIDL_S");
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
	return self;
}


RygelAVTransport* rygel_av_transport_new (void) {
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
}


gchar* rygel_av_transport_get_track_metadata (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	result = _tmp3_;
	return result;
}


void rygel_av_transport_set_track_metadata (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_str_has_prefix (_tmp0_, "&lt;");
	if (_tmp1_) {
		RygelMediaPlayer* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = self->priv->player;
		_tmp3_ = value;
		_tmp4_ = rygel_av_transport_unescape (self, _tmp3_);
		_tmp5_ = _tmp4_;
		rygel_media_player_set_metadata (_tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		RygelMediaPlayer* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->player;
		_tmp7_ = value;
		rygel_media_player_set_metadata (_tmp6_, _tmp7_);
	}
	g_object_notify ((GObject *) self, "track-metadata");
}


gchar* rygel_av_transport_get_track_uri (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		RygelMediaPlayer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp5_ = self->priv->player;
		_tmp6_ = rygel_media_player_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		result = _tmp10_;
		return result;
	} else {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("");
		result = _tmp11_;
		return result;
	}
}


void rygel_av_transport_set_track_uri (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = value;
	rygel_media_player_set_uri (_tmp0_, _tmp1_);
	g_object_notify ((GObject *) self, "track-uri");
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_status);
	self->priv->_status = _tmp1_;
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->_status;
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
	g_object_notify ((GObject *) self, "status");
}


gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_playback_speed (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	RygelMediaPlayer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = value;
	rygel_media_player_set_playback_speed (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->player;
	_tmp4_ = rygel_media_player_get_playback_speed (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp6_);
	_g_free0 (_tmp6_);
	g_object_notify ((GObject *) self, "speed");
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	RygelChangeLog* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mode);
	self->priv->_mode = _tmp1_;
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->_mode;
	rygel_change_log_log (_tmp2_, "CurrentPlayMode", _tmp3_);
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK_METADATA, g_param_spec_string ("track-metadata", "track-metadata", "track-metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_TRACK_URI, g_param_spec_string ("track-uri", "track-uri", "track-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("OK");
	self->priv->_status = _tmp0_;
	_tmp1_ = g_strdup ("NORMAL");
	self->priv->_mode = _tmp1_;
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	_g_object_unref0 (self->priv->session);
	_g_free0 (self->priv->protocol_info);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (gupnp_service_get_type (), "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_TRACK_METADATA:
		g_value_take_string (value, rygel_av_transport_get_track_metadata (self));
		break;
		case RYGEL_AV_TRANSPORT_TRACK_URI:
		g_value_take_string (value, rygel_av_transport_get_track_uri (self));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_av_transport_get_status (self));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		g_value_take_string (value, rygel_av_transport_get_speed (self));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_TRACK_METADATA:
		rygel_av_transport_set_track_metadata (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_TRACK_URI:
		rygel_av_transport_set_track_uri (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_STATUS:
		rygel_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		rygel_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		rygel_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



