/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;


/**
 * An event represeting action by a {@link org.gnu.gtk.Range} widget.
 * @see RangeListener
 * @see org.gnu.gtk.Range
 */
public class RangeEvent extends GtkEvent {

	public static class Type extends EventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * This event indicates that the menu item has been activated.
		 */
		public static final Type VALUE_CHANGED = new Type(1, "VALUE_CHANGED");
	}

	/**
	 * Creates a new Spin Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public RangeEvent(Object source) {
	    super(source, Type.VALUE_CHANGED);
	}
}
