package filechooser;

import org.gnu.gdk.Pixbuf;
import org.gnu.gtk.FileChooserAction;
import org.gnu.gtk.FileChooserDialog;
import org.gnu.gtk.FileFilter;
import org.gnu.gtk.Gtk;
import org.gnu.gtk.Image;
import org.gnu.gtk.ResponseType;
import org.gnu.gtk.event.FileChooserEvent;
import org.gnu.gtk.event.FileChooserListener;
import org.gnu.gtk.event.LifeCycleEvent;
import org.gnu.gtk.event.LifeCycleListener;

/**
 * This is an example that demonstrates the new FileChooser object.
 */
public class FileChooserExample {

    private Image preview = new Image();

    private FileChooserDialog dialog;

    public FileChooserExample() {
        dialog = new FileChooserDialog("File Chooser", null,
                FileChooserAction.ACTION_OPEN);
        dialog.addListener(new LifeCycleListener() {
            public void lifeCycleEvent(LifeCycleEvent event) {
            }

            public boolean lifeCycleQuery(LifeCycleEvent event) {
                if (event.isOfType(LifeCycleEvent.Type.DESTROY)
                        || event.isOfType(LifeCycleEvent.Type.DELETE)) {
                    Gtk.mainQuit();
                }
                return false;
            }
        });

        FileFilter filter = new FileFilter();
        filter.setName("PNG Picture");
        filter.addPattern("*.png");
        dialog.addFilter(filter);

        filter = new FileFilter();
        filter.setName("JPEG Picture");
        filter.addPattern("*.jpg");
        dialog.addFilter(filter);

        filter = new FileFilter();
        filter.setName("All Files");
        filter.addPattern("*.*");
        dialog.addFilter(filter);

        dialog.setPreviewWidget(preview);

        // Use FileChooserAdapter instead if you don't care about all of the
        // events generated by this Listener
        dialog.addListener(new FileChooserListener() {

            public void currentFolderChanged(FileChooserEvent event) {
                System.out.println("currentFolderChanged");
            }

            public void fileActivated(FileChooserEvent event) {
                System.out.println("fileActivated");
            }

            public void selectionChanged(FileChooserEvent event) {
                System.out.println("selectionChanged");
            }

            public void updatePreview(FileChooserEvent event) {
                System.out.println("updatePreview");
                updatePreviewWidget();
            }
        });

        int response = dialog.open();
        if (ResponseType.OK.getValue() == response) {
            System.out.println("File name selected: " + dialog.getFilename());
        }
        dialog.destroy();
    }

    private void updatePreviewWidget() {
        Pixbuf pixbuf;
        String fileName = dialog.getPreviewFilename();
        try {
            pixbuf = new Pixbuf(fileName, 128, 128, false);
        } catch (Exception e) {
            dialog.setPreviewWidgetActive(false);
            return;
        }

        preview.set(pixbuf);
        dialog.setPreviewWidgetActive(true);
    }

    public static void main(String[] args) {
        // Initialize GTK
        Gtk.init(args);

        FileChooserExample example = new FileChooserExample();

        Gtk.main();
    }
}
