/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Enum;

/**
 * The type of message to be displayed in a dialog.
 */
public class MessageType extends Enum {
    /***************************************************************************
     * BEGINNING OF GENERATED CODE
     **************************************************************************/
    static final private int _INFO = 0;

    /**
     * Informational message.
     */
    static final public org.gnu.gtk.MessageType INFO = new org.gnu.gtk.MessageType(
            _INFO);

    static final private int _WARNING = 1;

    /**
     * Nonfatal warning message.
     */
    static final public org.gnu.gtk.MessageType WARNING = new org.gnu.gtk.MessageType(
            _WARNING);

    static final private int _QUESTION = 2;

    /**
     * Question requiring a choice.
     */
    static final public org.gnu.gtk.MessageType QUESTION = new org.gnu.gtk.MessageType(
            _QUESTION);

    static final private int _ERROR = 3;

    /**
     * Fatal error message.
     */
    static final public org.gnu.gtk.MessageType ERROR = new org.gnu.gtk.MessageType(
            _ERROR);

    static final private org.gnu.gtk.MessageType[] theInterned = new org.gnu.gtk.MessageType[] {
            INFO, WARNING, QUESTION, ERROR }

    ;

    static private java.util.Hashtable theInternedExtras;

    static final private org.gnu.gtk.MessageType theSacrificialOne = new org.gnu.gtk.MessageType(
            0);

    static public org.gnu.gtk.MessageType intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.gtk.MessageType already = (org.gnu.gtk.MessageType) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new org.gnu.gtk.MessageType(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private MessageType(int value) {
        value_ = value;
    }

    public org.gnu.gtk.MessageType or(org.gnu.gtk.MessageType other) {
        return intern(value_ | other.value_);
    }

    public org.gnu.gtk.MessageType and(org.gnu.gtk.MessageType other) {
        return intern(value_ & other.value_);
    }

    public org.gnu.gtk.MessageType xor(org.gnu.gtk.MessageType other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(org.gnu.gtk.MessageType other) {
        return (value_ & other.value_) == other.value_;
    }

    /***************************************************************************
     * END OF GENERATED CODE
     **************************************************************************/
}
