/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event represeting action by a {@link org.gnu.gtk.Adjustment} object.
 * 
 * @see AdjustmentListener
 * @see org.gnu.gtk.Adjustment
 */
public class AdjustmentEvent extends GtkEvent {

    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static final Type VALUE_CHANGED = new Type(1, "VALUE_CHANGED");

        public static final Type CHANGED = new Type(2, "CHANGED");
    }

    /**
     * Construct a AdjustmentEvent object.
     */
    public AdjustmentEvent(Object source, EventType type) {
        super(source, type);
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(AdjustmentEvent.Type aType) {
        return (type.getID() == aType.getID());
    }
}
