// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PRINTER_H
#define _GTKMM_PRINTER_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPrinter GtkPrinter;
typedef struct _GtkPrinterClass GtkPrinterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Printer_Class; } // namespace Gtk
namespace Gtk
{

/** A Printer object represents a printer. You only need to deal directly with printers if you use the 
 * non-portable PrintUnixDialog API.
 *
 * A Printer object allows to get status information about the printer, such as its description, its location, 
 * the number of queued jobs, etc. Most importantly, a Printer object can be used to create a PrintJob object, 
 * which lets you print to the printer.
 *
 * @newin2p10
 *
 * @ingroup Printing
 */

class Printer : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Printer CppObjectType;
  typedef Printer_Class CppClassType;
  typedef GtkPrinter BaseObjectType;
  typedef GtkPrinterClass BaseClassType;

private:  friend class Printer_Class;
  static CppClassType printer_class_;

private:
  // noncopyable
  Printer(const Printer&);
  Printer& operator=(const Printer&);

protected:
  explicit Printer(const Glib::ConstructParams& construct_params);
  explicit Printer(GtkPrinter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Printer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPrinter*       gobj()       { return reinterpret_cast<GtkPrinter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPrinter* gobj() const { return reinterpret_cast<GtkPrinter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPrinter* gobj_copy();

private:

  //This is not available in on Win32.
//This source file will not be compiled,
//and the class will not be registered in wrap_init.h or wrap_init.cc


public:
  //TODO: _WRAP_CREATE() - probably not, it's only accessible through PrintUnixDialog + GtkPrintBackend should be ignored
  
  //TODO: I think these are not needed as well, and that Printer should generally be read-only - marko.
  
  
  bool equal(const Glib::RefPtr<Printer>& other) const;

  //TODO: _WRAP_METHOD(Glib::RefPtr<PrintBackend> get_backend(), gtk_printer_get_backend. refreturn)
  //_WRAP_METHOD(Glib::RefPtr<const PrintBackend> get_backend() const, gtk_printer_get_backend, refreturn, constversion)
  
  Glib::ustring get_name() const;
  
  Glib::ustring get_state_message() const;
  
  Glib::ustring get_description() const;
  
  Glib::ustring get_location() const;
  
  Glib::ustring get_icon_name() const;
  
  int get_job_count() const;
  
  bool is_active() const;
  
  bool is_virtual() const;
  
  bool is_default() const;
  
  bool accepts_pdf() const;
  
  bool accepts_ps() const;
  
  
   /**
   * @par Prototype:
   * <tt>void %details_acquired(bool success)</tt>
   */

  Glib::SignalProxy1< void,bool > signal_details_acquired();

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //TODO: _WRAP_PROPERTY("backend", Glib::RefPtr<PrintBackend>)
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** FALSE if this represents a real hardware printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_virtual() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** String giving the current state of the printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_state_message() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The location of the printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_location() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The icon name to use for the printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of jobs queued in the printer.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_job_count() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if this printer can accept PDF.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_accepts_pdf() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if this printer can accept PostScript.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_accepts_ps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_details_acquired(bool success);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

/** @relates Gtk::Printer */
inline bool operator==(const Glib::RefPtr<Printer>& lhs, const Glib::RefPtr<Printer>& rhs)
  { return lhs->equal(rhs); }

/** @relates Gtk::Printer */
inline bool operator!=(const Glib::RefPtr<Printer>& lhs, const Glib::RefPtr<Printer>& rhs)
  { return !lhs->equal(rhs); }

/** For example, 
 * bool on_enumerate_printers(const Glib::RefPtr<Printer>& printer);
 *
 * TODO: document return value.
 *
 * @relates Gtk::Printer
 */
typedef sigc::slot< bool, const Glib::RefPtr<Printer>& > SlotPrinterEnumerator;

/** TODO: document this
 *
 * @relates Gtk::Printer
 */
void enumerate_printers(const SlotPrinterEnumerator& slot, bool wait = true);

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Printer
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::Printer> wrap(GtkPrinter* object, bool take_copy = false);
}


#endif /* _GTKMM_PRINTER_H */

