// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_PIXBUF_H
#define _GDKMM_PIXBUF_H

#include <gdkmmconfig.h>


#include <glibmm.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 // This is for including the config header before any code (such as
// the #ifndef GDKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <gdkmm/drawable.h>
#include <gdkmm/image.h>
#include <gdkmm/pixmap.h>
#include <gdkmm/bitmap.h>
#include <gdkmm/pixbufformat.h>
#include <gdkmm/types.h>
#include <giomm/inputstream.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkPixbuf GdkPixbuf;
typedef struct _GdkPixbufClass GdkPixbufClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Pixbuf_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum Colorspace
{
  COLORSPACE_RGB
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Colorspace> : public Glib::Value_Enum<Gdk::Colorspace>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum InterpType
{
  INTERP_NEAREST,
  INTERP_TILES,
  INTERP_BILINEAR,
  INTERP_HYPER
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::InterpType> : public Glib::Value_Enum<Gdk::InterpType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufAlphaMode
{
  PIXBUF_ALPHA_BILEVEL,
  PIXBUF_ALPHA_FULL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufAlphaMode> : public Glib::Value_Enum<Gdk::PixbufAlphaMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum PixbufRotation
{
  PIXBUF_ROTATE_NONE = 0,
  PIXBUF_ROTATE_COUNTERCLOCKWISE = 90,
  PIXBUF_ROTATE_UPSIDEDOWN = 180,
  PIXBUF_ROTATE_CLOCKWISE = 270
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufRotation> : public Glib::Value_Enum<Gdk::PixbufRotation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


/** Exception class for Gdk::Pixbuf errors.
 */
class PixbufError : public Glib::Error
{
public:
  enum Code
  {
    CORRUPT_IMAGE,
    INSUFFICIENT_MEMORY,
    BAD_OPTION,
    UNKNOWN_TYPE,
    UNSUPPORTED_OPERATION,
    FAILED
  };

  PixbufError(Code error_code, const Glib::ustring& error_message);
  explicit PixbufError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::PixbufError::Code> : public Glib::Value_Enum<Gdk::PixbufError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct PixbufFormatTraits
{
  typedef PixbufFormat  CppType;
  typedef const GdkPixbufFormat*      CType;
  typedef GdkPixbufFormat*            CTypeNonConst;

  static CType   to_c_type      (const CppType& obj) { return obj.gobj();     }
  static CType   to_c_type      (CType          ptr) { return ptr;                   }
  static CppType to_cpp_type    (CType          ptr) { return PixbufFormat(ptr); /* Does not take ownership */ }
  static void    release_c_type (CType          /* ptr */) { /* Doesn't happen */ }
};
#endif //DOXYGEN_SHOULD_SKIP_THIS


class Pixbuf : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pixbuf CppObjectType;
  typedef Pixbuf_Class CppClassType;
  typedef GdkPixbuf BaseObjectType;
  typedef GdkPixbufClass BaseClassType;

private:  friend class Pixbuf_Class;
  static CppClassType pixbuf_class_;

private:
  // noncopyable
  Pixbuf(const Pixbuf&);
  Pixbuf& operator=(const Pixbuf&);

protected:
  explicit Pixbuf(const Glib::ConstructParams& construct_params);
  explicit Pixbuf(GdkPixbuf* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pixbuf();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkPixbuf*       gobj()       { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkPixbuf* gobj() const { return reinterpret_cast<GdkPixbuf*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkPixbuf* gobj_copy();

private:

  
protected:

  /** Creates a pixbuf object from a drawable.
   *
   * Transfers image data from a Drawable and converts it to an RGB(A)
   * representation inside a Pixbuf. In other words, copies
   * image data from a server-side drawable to a client-side RGB(A) buffer.
   * This allows you to efficiently read individual pixels on the client side.
   *
   * If the drawable @src has no colormap (See Gdk::Drawable::get_colormap()),
   * then a suitable colormap must be specified. Otherwise, you may use the
   * constructor that takes no colormap argument.
   * Typically a Gdk::Window or a pixmap created by passing a Gdk:Window
   * to the Gdk::Pixbuf constructor will already have a colormap associated with
   * it.  If the drawable is a bitmap (1 bit per pixel pixmap),
   * then a colormap is not required; pixels with a value of 1 are
   * assumed to be white, and pixels with a value of 0 are assumed to be
   * black. For taking screenshots, Gdk::Colormap::get_system() returns
   * the correct colormap to use.
   *
   * This will create an RGB pixbuf with 8 bits per channel and no
   * alpha, with the same size specified by the @a width and @a height
   * arguments.
   *
   * If the specified drawable is a pixmap, then the requested source
   * rectangle must be completely contained within the pixmap, otherwise
   * the constructor will fail. For pixmaps only (not for windows)
   * passing -1 for width or height is allowed to mean the full width
   * or height of the pixmap.
   *
   * If the specified drawable is a window, and the window is off the
   * screen, then there is no image data in the obscured/offscreen
   * regions to be placed in the pixbuf. The contents of portions of the
   * pixbuf corresponding to the offscreen region are undefined.
   *
   * If the window you're obtaining data from is partially obscured by
   * other windows, then the contents of the pixbuf areas corresponding
   * to the obscured regions are undefined.
   *
   * See alo Gdk::Drawable::get_image().
   *
   * @param src Source drawable.
   * @param cmap: A colormap.
   * @param src_x Source X coordinate within drawable.
   * @param src_y Source Y coordinate within drawable.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
   Pixbuf(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int width, int height);

  /** Creates a pixbuf object from a drawable, using the colormap from the drawable.
   *
   * @param src Source drawable.
   * @param src_x Source X coordinate within drawable.
   * @param src_y Source Y coordinate within drawable.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
   Pixbuf(const Glib::RefPtr<Drawable>& src,
         int src_x, int src_y, int width, int height);

  #ifndef GDKMM_DISABLE_DEPRECATED

   /// @deprecated Use the constructor without dest_x and dest_y parameters.
   Pixbuf(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int dest_x, int dest_y, int width, int height);
  #endif // GDKMM_DISABLE_DEPRECATED


  /** Creates a pixbuf object from an image.
   *
   * @param src Source Image.
   * @param cmap A colormap.
   * @param src_x Source X coordinate within the image.
   * @param src_y Source Y coordinate within the image.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
  Pixbuf(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int width, int height);

  /** Creates a pixbuf object from an image, using the colormap from the image.
   *
   * @param src Source Image.
   * @param src_x Source X coordinate within the image.
   * @param src_y Source Y coordinate within the image.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newinp212
   */
  Pixbuf(const Glib::RefPtr<Image>& src,
         int src_x, int src_y, int width, int height);

  #ifndef GDKMM_DISABLE_DEPRECATED

  /// @deprecated Use the constructors without dest_x and dest_y parameters.
  Pixbuf(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap,
         int src_x, int src_y, int dest_x, int dest_y, int width, int height);
  #endif // GDKMM_DISABLE_DEPRECATED


public:
  typedef sigc::slot<void, const guint8*> SlotDestroyData;

  // Hand-coded so the implementation in the .ccg is also only
  // built when GDKMM_DISABLE_DEPRECATED is defined.
  #ifndef GDKMM_DISABLE_DEPRECATED

  /** @deprecated Use the create() methods that don't have the unused dest_x and dest_y parameters. */
  static Glib::RefPtr<Gdk::Pixbuf> create(const Glib::RefPtr<Drawable>& src,
                                          const Glib::RefPtr<Colormap>& cmap,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height);

  /** @deprecated Use the create() methods that that don't have the unused dest_x and dest_y parameters. */
  static Glib::RefPtr<Gdk::Pixbuf> create(const Glib::RefPtr<Image>& src,
                                          const Glib::RefPtr<Colormap>& cmap,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height);
  #endif // GDKMM_DISABLE_DEPRECATED


  /** Creates a pixbuf object from a drawable.
   *
   * Transfers image data from a Drawable and converts it to an RGB(A)
   * representation inside a Pixbuf. In other words, copies
   * image data from a server-side drawable to a client-side RGB(A) buffer.
   * This allows you to efficiently read individual pixels on the client side.
   *
   * If the drawable @src has no colormap (See Gdk::Drawable::get_colormap()),
   * then a suitable colormap must be specified. Otherwise, you may use the
   * constructor that takes no colormap argument.
   * Typically a Gdk::Window or a pixmap created by passing a Gdk:Window
   * to the Gdk::Pixbuf constructor will already have a colormap associated with
   * it.  If the drawable is a bitmap (1 bit per pixel pixmap),
   * then a colormap is not required; pixels with a value of 1 are
   * assumed to be white, and pixels with a value of 0 are assumed to be
   * black. For taking screenshots, Gdk::Colormap::get_system() returns
   * the correct colormap to use.
   *
   * This will create an RGB pixbuf with 8 bits per channel and no
   * alpha, with the same size specified by the @a width and @a height
   * arguments.
   *
   * If the specified drawable is a pixmap, then the requested source
   * rectangle must be completely contained within the pixmap, otherwise
   * the constructor will fail. For pixmaps only (not for windows)
   * passing -1 for width or height is allowed to mean the full width
   * or height of the pixmap.
   *
   * If the specified drawable is a window, and the window is off the
   * screen, then there is no image data in the obscured/offscreen
   * regions to be placed in the pixbuf. The contents of portions of the
   * pixbuf corresponding to the offscreen region are undefined.
   *
   * If the window you're obtaining data from is partially obscured by
   * other windows, then the contents of the pixbuf areas corresponding
   * to the obscured regions are undefined.
   *
   * See alo Gdk::Drawable::get_image().
   *
   * @param src Source drawable.
   * @param cmap: A colormap.
   * @param src_x Source X coordinate within drawable.
   * @param src_y Source Y coordinate within drawable.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Drawable>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int width, int height);


  /** Creates a pixbuf object from a drawable, using the colormap from the drawable.
   *
   * @param src Source drawable.
   * @param src_x Source X coordinate within drawable.
   * @param src_y Source Y coordinate within drawable.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Drawable>& src, int src_x, int src_y, int width, int height);


  /** Creates a pixbuf object from an image.
   *
   * @param src Source Image.
   * @param cmap A colormap.
   * @param src_x Source X coordinate within the image.
   * @param src_y Source Y coordinate within the image.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newin{2,12}
   */
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Image>& src, const Glib::RefPtr<Colormap>& cmap, int src_x, int src_y, int width, int height);


  /** Creates a pixbuf object from an image, using the colormap from the image.
   *
   * @param src Source Image.
   * @param src_x Source X coordinate within the image.
   * @param src_y Source Y coordinate within the image.
   * @param width Width in pixels of region to get.
   * @param height Height in pixels of region to get.
   *
   * @newinp212
   */
  
  static Glib::RefPtr<Pixbuf> create(const Glib::RefPtr<Image>& src, int src_x, int src_y, int width, int height);


  /** Creates a new Gdk::Pixbuf with a copy of the information in the specified
   *  @a pixbuf.
   * @return A newly-created pixbuf with a reference count of 1, or <tt>0</tt> if
   * not enough memory could be allocated.
   */
  Glib::RefPtr<Pixbuf> copy() const;

  
  /** Creates a new Gdk::Pixbuf structure and allocates a buffer for it.  The 
   * buffer has an optimal rowstride.  Note that the buffer is not cleared;
   * you will have to fill it completely yourself.
   * @param colorspace Color space for image.
   * @param has_alpha Whether the image should have transparency information.
   * @param bits_per_sample Number of bits per color sample.
   * @param width Width of image in pixels, must be > 0.
   * @param height Height of image in pixels, must be > 0.
   * @return A newly-created Gdk::Pixbuf with a reference count of 1, or 
   * <tt>0</tt> if not enough memory could be allocated for the image buffer.
   */
  static Glib::RefPtr<Pixbuf> create(
                   Colorspace colorspace, bool has_alpha,
                   int bits_per_sample, int width, int height);

  
  /** Creates a new pixbuf which represents a sub-region of
   *  @a src_pixbuf. The new pixbuf shares its pixels with the
   * original pixbuf, so writing to one affects both.
   * The new pixbuf holds a reference to @a src_pixbuf, so
   *  @a src_pixbuf will not be finalized until the new pixbuf
   * is finalized.
   * @param src_pixbuf A Gdk::Pixbuf.
   * @param src_x X coord in @a src_pixbuf.
   * @param src_y Y coord in @a src_pixbuf.
   * @param width Width of region in @a src_pixbuf.
   * @param height Height of region in @a src_pixbuf.
   * @return A new pixbuf.
   */
  static Glib::RefPtr<Pixbuf> create_subpixbuf(
                  const Glib::RefPtr<Pixbuf>& src_pixbuf,
                  int src_x, int src_y, int width, int height);

  
  /** Creates a new pixbuf by loading an image from a file. The file format is detected automatically.
   * @param filename The path to the pixbuf file.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename);
#else
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Creates a new pixbuf by loading an image from a file. The file format is detected automatically.
   * The image will be scaled to fit in the requested size.
   * @param filename The path to the pixbuf file.
   * @param width The desired width
   * @param height The desired height
   * @param preserve_aspect_ratio: Whether the image's aspect ratio will be preserved when scaling.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename, int width, int height, bool preserve_aspect_ratio = true);
#else
  static Glib::RefPtr<Pixbuf> create_from_file(const std::string& filename, int width, int height, bool preserve_aspect_ratio, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

   //gdk_pixbuf_new_from_file_at_size() just calls gdk_pixbuf_new_from_file_at_scale().

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride);

  /** Creates a new Gdk::Pixbuf out of in-memory image data.
   * Currently only RGB images with 8 bits per sample are supported.
   *
   * @param data %Image data in 8-bit/sample packed format.
   * @param colorspace Colorspace for the image data.
   * @param has_alpha Whether the data has an opacity channel.
   * @param bits_per_sample Number of bits per sample.
   * @param width Width of the image in pixels.
   * @param height Height of the image in pixels.
   * @param rowstride Distance in bytes between rows.
   * @param destroy_slot Slot used to free the data when the pixbuf's
   * reference count drops to zero.
   * @return A newly-created Gdk::Pixbuf object.
   */
  static Glib::RefPtr<Pixbuf> create_from_data(const guint8* data, Colorspace colorspace,
                                               bool has_alpha, int bits_per_sample,
                                               int width, int height, int rowstride,
                                               const SlotDestroyData& destroy_slot);

  
  /** Creates a new pixbuf by parsing XPM data in memory.  This data is commonly
   * the result of including an XPM file into a program's C source.
   * @param data Pointer to inline XPM data.
   * @return A newly-created pixbuf with a reference count of 1.
   */
  static Glib::RefPtr<Pixbuf> create_from_xpm_data(const char *const * data);

  
  /** Create a Gdk::Pixbuf from a flat representation that is suitable for
   * storing as inline data in a program.  This is useful if you want to ship a
   * program with images, but don't want to depend on any external files.
   *
   * GTK+ ships with a program called <tt>gdk-pixbuf-csource</tt> which allows
   * for conversion of GdkPixbufs into such a inline representation. In almost
   * all cases, you should pass the <tt>--raw</tt> flag to
   * <tt>gdk-pixbuf-csource</tt>. A sample invocation would be:
   *
   * <tt>gdk-pixbuf-csource --raw --name=myimage_inline myimage.png</tt>
   *
   * For the typical case where the inline pixbuf is read-only static data, you
   * don't need to copy the pixel data unless you intend to write to it, so you
   * can pass <tt>false</tt> for @a copy_pixels. (If you pass <tt>--rle</tt> to
   * <tt>gdk-pixbuf-csource</tt>, a copy will be made even if @a copy_pixels is
   * <tt>false</tt>, so using this option is generally a bad idea.)
   *
   * If you create a pixbuf from const inline data compiled into your program,
   * it's probably safe to ignore errors, since things will always succeed. For
   * non-const inline data, you could get out of memory. For untrusted inline
   * data located at runtime, you could have corrupt inline data in addition.
   *
   * @param data_length Length in bytes of the @a data argument.
   * @param data Byte data containing a serialized GdkPixdata structure.
   * @param copy_pixels Whether to copy the pixel data, or use direct pointers
   * to @a data for the resulting pixbuf.
   * @throw Gdk::PixbufError
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_inline(int data_length, const guint8* data,
                                                 bool copy_pixels = false);
#else
  static Glib::RefPtr<Pixbuf> create_from_inline(int data_length, const guint8* data, bool copy_pixels, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Creates a new pixbuf by loading an image from an input stream.  
   * 
   * The file format is detected automatically. If <tt>0</tt> is returned, then 
   *  @a error will be set. The @a cancellable can be used to abort the operation
   * from another thread. If the operation was cancelled, the error 
   * Gio::ERROR_CANCELLED will be returned. Other possible errors are in 
   * the Gdk::PIXBUF_ERROR and IO_ERROR domains. 
   * 
   * The stream is not closed.
   * @param stream A InputStream to load the pixbuf from.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A newly-created pixbuf, or <tt>0</tt> if any of several error 
   * conditions occurred: the file could not be opened, the image format is 
   * not supported, there was not enough memory to allocate the image buffer, 
   * the stream contained invalid data, or the operation was cancelled.
   * 
   * @newin{2,14}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream, const Glib::RefPtr<Gio::Cancellable>& cancelable);
#else
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream, const Glib::RefPtr<Gio::Cancellable>& cancelable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream);
#else
  static Glib::RefPtr<Pixbuf> create_from_stream(const Glib::RefPtr<Gio::InputStream>& stream, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Creates a new pixbuf by loading an image from an input stream.  
   * 
   * The file format is detected automatically. If <tt>0</tt> is returned, then 
   *  @a error will be set. The @a cancellable can be used to abort the operation
   * from another thread. If the operation was cancelled, the error 
   * Gio::ERROR_CANCELLED will be returned. Other possible errors are in 
   * the Gdk::PIXBUF_ERROR and IO_ERROR domains. 
   * 
   * The image will be scaled to fit in the requested size, optionally 
   * preserving the image's aspect ratio. When preserving the aspect ratio, 
   * a @a width of -1 will cause the image to be scaled to the exact given 
   * height, and a @a height of -1 will cause the image to be scaled to the 
   * exact given width. When not preserving aspect ratio, a @a width or 
   *  @a height of -1 means to not scale the image at all in that dimension.
   * 
   * The stream is not closed.
   * @param stream A InputStream to load the pixbuf from.
   * @param width The width the image should have or -1 to not constrain the width.
   * @param height The height the image should have or -1 to not constrain the height.
   * @param preserve_aspect_ratio <tt>true</tt> to preserve the image's aspect ratio.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A newly-created pixbuf, or <tt>0</tt> if any of several error 
   * conditions occurred: the file could not be opened, the image format is 
   * not supported, there was not enough memory to allocate the image buffer, 
   * the stream contained invalid data, or the operation was cancelled.
   * 
   * @newin{2,14}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio, const Glib::RefPtr<Gio::Cancellable>& cancelable);
#else
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio, const Glib::RefPtr<Gio::Cancellable>& cancelable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio);
#else
  static Glib::RefPtr<Pixbuf> create_from_stream_at_scale(const Glib::RefPtr<Gio::InputStream>& stream, int width, int height, bool preserve_aspect_ratio, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Queries the color space of a pixbuf.
   * @return Color space.
   */
  Colorspace get_colorspace() const;

  
  /** Queries the number of channels of a pixbuf.
   * @return Number of channels.
   */
  int get_n_channels() const;
  
  /** Queries whether a pixbuf has an alpha channel (opacity information).
   * @return <tt>true</tt> if it has an alpha channel, <tt>false</tt> otherwise.
   */
  bool get_has_alpha() const;
  
  /** Queries the number of bits per color sample in a pixbuf.
   * @return Number of bits per color sample.
   */
  int get_bits_per_sample() const;
  
  /** Queries a pointer to the pixel data of a pixbuf.
   * @return A pointer to the pixbuf's pixel data.  Please see <xref linkend="image-data"/>
   * for information about how the pixel data is stored in
   * memory.
   */
  guint8* get_pixels() const;
  
  /** Queries the width of a pixbuf.
   * @return Width in pixels.
   */
  int get_width() const;
  
  /** Queries the height of a pixbuf.
   * @return Height in pixels.
   */
  int get_height() const;
  
  /** Queries the rowstride of a pixbuf, which is the number of bytes between the start of a row
   * and the start of the next row.
   * @return Distance between row starts.
   */
  int get_rowstride() const;

  
  /** Clears a pixbuf to the given RGBA value, converting the RGBA value into
   * the pixbuf's pixel format. The alpha will be ignored if the pixbuf
   * doesn't have an alpha channel.
   * @param pixel RGBA pixel to clear to
   * (0xffffffff is opaque white, 0x00000000 transparent black).
   */
  void fill(guint32 pixel);

  /** Saves pixbuf to a file in format @a type.
   * By default, "jpeg", "png", "ico" and "bmp" are possible file formats to save in, but more formats may be installed.
   * TThe list of all writable formats can be determined by using Gdk::Pixbuf::get_formats() with
   * Gdk::PixbufFormat::is_writable().
   *
   * @param filename The path of the file to be created.
   * @param type The file type.
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  void save(const std::string& filename, const Glib::ustring& type);
  #else
  void save(const std::string& filename, const Glib::ustring& type, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Saves pixbuf to a file in format @a type.
   * By default, "jpeg", "png", "ico" and "bmp" are possible file formats to save in, but more formats may be installed.
   * TThe list of all writable formats can be determined by using Gdk::Pixbuf::get_formats() with
   * Gdk::PixbufFormat::is_writable().
   *
   * The @a option_keys and @option_values, if not empty, should contain pairs of strings that modify the save parameters.
   * For example,  "quality", "100".
   *
   * Currently only a few parameters exist. JPEG images can be saved with a "quality" parameter;
   * its value should be in the range [0,100]. Text chunks can be attached to PNG images by specifying parameters of the
   * form "tEXt::key", where key is an ASCII string of length 1-79. The values are UTF-8 encoded strings. ICO images can be
   * saved in depth 16, 24, or 32, by using the "depth" parameter. When the ICO saver is given "x_hot" and "y_hot"
   * parameters, it produces a CUR instead of an ICO.
   *
   * @param filename The path of the file to be created.
   * @param type The file type.
   * @param option_keys
   * @param option_values
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  void save(const std::string& filename, const Glib::ustring& type,
            const Glib::StringArrayHandle& option_keys,
            const Glib::StringArrayHandle& option_values);
  #else
  void save(const std::string& filename, const Glib::ustring& type,
            const Glib::StringArrayHandle& option_keys,
            const Glib::StringArrayHandle& option_values, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
/* TODO:
typedef gboolean (*GdkPixbufSaveFunc)   (const gchar *buf,
					 gsize count,
					 GError **error,
					 gpointer data);

gboolean gdk_pixbuf_save_to_callback    (GdkPixbuf  *pixbuf,
					 GdkPixbufSaveFunc save_func,
					 gpointer user_data,
					 const char *type,
					 GError    **error,
					 ...);

gboolean gdk_pixbuf_save_to_callbackv   (GdkPixbuf  *pixbuf,
					 GdkPixbufSaveFunc save_func,
					 gpointer user_data,
					 const char *type,
					 char      **option_keys,
					 char      **option_values,
					 GError    **error);

*/

  /* Saves the pixbuf to a new buffer in format @a type.
   * Note that the buffer is not nul-terminated and may contain embedded nulls.
   * @see save().
   *
   * @param buffer This will be set to the address of a new buffer.
   * @param size This will be set to the size of the @a buffer.
   * @param type Currently "jpeg", "png", "ico" or "bmp".
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type = "png");
  #else
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  /* Saves the pixbuf to a new buffer in format @a type.
   * Note that the buffer is not nul-terminated and may contain embedded nulls.
   * @see save().
   *
   * @param buffer This will be set to the address of a new buffer.
   * @param size This will be set to the size of the @a buffer.
   * @param type Currently "jpeg", "png", "ico" or "bmp".
   *
   * @throw Glib::FileError
   * @throw Gdk::PixbufError
   */
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type,
                      const Glib::StringArrayHandle& option_keys,
                      const Glib::StringArrayHandle& option_values);
  #else
  void save_to_buffer(gchar*& buffer, gsize& buffer_size,
                      const Glib::ustring& type,
                      const Glib::StringArrayHandle& option_keys,
                      const Glib::StringArrayHandle& option_values, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
  

  /** Takes an existing pixbuf and adds an alpha channel to it.
   * If the existing pixbuf already had an alpha channel, the channel
   * values are copied from the original; otherwise, the alpha channel
   * is initialized to 255 (full opacity).
   * 
   * If @a substitute_color is <tt>true</tt>, then the color specified by ( @a r, @a g, @a b) will be
   * assigned zero opacity. That is, if you pass (255, 255, 255) for the
   * substitute color, all white pixels will become fully transparent.
   * @param substitute_color Whether to set a color to zero opacity.  If this
   * is <tt>false</tt>, then the ( @a r, @a g, @a b) arguments will be ignored.
   * @param r Red value to substitute.
   * @param g Green value to substitute.
   * @param b Blue value to substitute.
   * @return A newly-created pixbuf with a reference count of 1.
   */
  Glib::RefPtr<Gdk::Pixbuf> add_alpha(
                   bool substitute_color, guint8 r, guint8 g, guint8 b) const;

  
  /** Copies a rectangular area from @a src_pixbuf to @a dest_pixbuf.  Conversion of
   * pixbuf formats is done automatically.
   * 
   * If the source rectangle overlaps the destination rectangle on the
   * same pixbuf, it will be overwritten during the copy operation.
   * Therefore, you can not use this function to scroll a pixbuf.
   * @param src_x Source X coordinate within @a src_pixbuf.
   * @param src_y Source Y coordinate within @a src_pixbuf.
   * @param width Width of the area to copy.
   * @param height Height of the area to copy.
   * @param dest_pixbuf Destination pixbuf.
   * @param dest_x X coordinate within @a dest_pixbuf.
   * @param dest_y Y coordinate within @a dest_pixbuf.
   */
  void copy_area(
                   int src_x, int src_y, int width, int height,
                   const Glib::RefPtr<Gdk::Pixbuf>& dest_pixbuf,
                   int dest_x, int dest_y) const;

  
  /** Modifies saturation and optionally pixelates @a src, placing the result in
   *  @a dest. @a src and @a dest may be the same pixbuf with no ill effects.  If
   *  @a saturation is 1.0 then saturation is not changed. If it's less than 1.0,
   * saturation is reduced (the image turns toward grayscale); if greater than
   * 1.0, saturation is increased (the image gets more vivid colors). If @a pixelate
   * is <tt>true</tt>, then pixels are faded in a checkerboard pattern to create a
   * pixelated image. @a src and @a dest must have the same image format, size, and
   * rowstride.
   * @param dest Place to write modified version of @a src.
   * @param saturation Saturation factor.
   * @param pixelate Whether to pixelate.
   */
  void saturate_and_pixelate(
                   const Glib::RefPtr<Gdk::Pixbuf>& dest,
                   float saturation, bool pixelate) const;


  /** Creates a transformation of the source image @a src by scaling by
   *  @a scale_x and @a scale_y then translating by @a offset_x and @a offset_y,
   * then renders the rectangle ( @a dest_x, @a dest_y, @a dest_width,
   *  @a dest_height) of the resulting image onto the destination image
   * replacing the previous contents.
   * 
   * Try to use scale_simple() first, this function is
   * the industrial-strength power tool you can fall back to if
   * scale_simple() isn't powerful enough.
   * 
   * If the source rectangle overlaps the destination rectangle on the
   * same pixbuf, it will be overwritten during the scaling which
   * results in rendering artifacts.
   * @param dest The Gdk::Pixbuf into which to render the results.
   * @param dest_x The left coordinate for region to render.
   * @param dest_y The top coordinate for region to render.
   * @param dest_width The width of the region to render.
   * @param dest_height The height of the region to render.
   * @param offset_x The offset in the X direction (currently rounded to an integer).
   * @param offset_y The offset in the Y direction (currently rounded to an integer).
   * @param scale_x The scale factor in the X direction.
   * @param scale_y The scale factor in the Y direction.
   * @param interp_type The interpolation type for the transformation.
   */
  void scale(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                          int    dest_x,      int    dest_y,
                          int    dest_width,  int    dest_height,
                          double offset_x,    double offset_y,
                          double scale_x,     double scale_y,
                          InterpType interp_type) const;

  
  /** Creates a transformation of the source image @a src by scaling by
   *  @a scale_x and @a scale_y then translating by @a offset_x and @a offset_y.
   * This gives an image in the coordinates of the destination pixbuf.
   * The rectangle ( @a dest_x, @a dest_y, @a dest_width, @a dest_height)
   * is then composited onto the corresponding rectangle of the
   * original destination image.
   * 
   * When the destination rectangle contains parts not in the source 
   * image, the data at the edges of the source image is replicated
   * to infinity. 
   * 
   * <figure id="pixbuf-composite-diagram">
   * <title>Compositing of pixbufs</title>
   * <graphic fileref="composite.png" format="PNG"/>
   * </figure>
   * @param dest The Gdk::Pixbuf into which to render the results.
   * @param dest_x The left coordinate for region to render.
   * @param dest_y The top coordinate for region to render.
   * @param dest_width The width of the region to render.
   * @param dest_height The height of the region to render.
   * @param offset_x The offset in the X direction (currently rounded to an integer).
   * @param offset_y The offset in the Y direction (currently rounded to an integer).
   * @param scale_x The scale factor in the X direction.
   * @param scale_y The scale factor in the Y direction.
   * @param interp_type The interpolation type for the transformation.
   * @param overall_alpha Overall alpha for source image (0..255).
   */
  void composite(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                              int    dest_x,      int    dest_y,
                              int    dest_width,  int    dest_height,
                              double offset_x,    double offset_y,
                              double scale_x,     double scale_y,
                              InterpType interp_type,
                              int overall_alpha) const;

  
  /** Creates a transformation of the source image @a src by scaling by
   *  @a scale_x and @a scale_y then translating by @a offset_x and @a offset_y,
   * then composites the rectangle ( @a dest_x , @a dest_y, @a dest_width,
   *  @a dest_height) of the resulting image with a checkboard of the
   * colors @a color1 and @a color2 and renders it onto the destination
   * image.
   * 
   * See composite_color_simple() for a simpler variant of this
   * function suitable for many tasks.
   * @param dest The Gdk::Pixbuf into which to render the results.
   * @param dest_x The left coordinate for region to render.
   * @param dest_y The top coordinate for region to render.
   * @param dest_width The width of the region to render.
   * @param dest_height The height of the region to render.
   * @param offset_x The offset in the X direction (currently rounded to an integer).
   * @param offset_y The offset in the Y direction (currently rounded to an integer).
   * @param scale_x The scale factor in the X direction.
   * @param scale_y The scale factor in the Y direction.
   * @param interp_type The interpolation type for the transformation.
   * @param overall_alpha Overall alpha for source image (0..255).
   * @param check_x The X offset for the checkboard (origin of checkboard is at - @a check_x, - @a check_y).
   * @param check_y The Y offset for the checkboard.
   * @param check_size The size of checks in the checkboard (must be a power of two).
   * @param color1 The color of check at upper left.
   * @param color2 The color of the other check.
   */
  void composite_color(const Glib::RefPtr<Gdk::Pixbuf>& dest,
                                    int    dest_x,      int    dest_y,
                                    int    dest_width,  int    dest_height,
                                    double offset_x,    double offset_y,
                                    double scale_x,     double scale_y,
                                    InterpType interp_type,
                                    int overall_alpha,
                                    int check_x, int check_y,
                                    int check_size,
                                    guint32 color1, guint32 color2) const;

  
  /** Create a new Gdk::Pixbuf containing a copy of @a src scaled to
   *  @a dest_width x @a dest_height. Leaves @a src unaffected.  @a interp_type
   * should be Gdk::INTERP_NEAREST if you want maximum speed (but when
   * scaling down Gdk::INTERP_NEAREST is usually unusably ugly).  The
   * default @a interp_type should be Gdk::INTERP_BILINEAR which offers
   * reasonable quality and speed.
   * 
   * You can scale a sub-portion of @a src by creating a sub-pixbuf
   * pointing into @a src; see new_subpixbuf().
   * 
   * For more complicated scaling/compositing see scale()
   * and composite().
   * @param dest_width The width of destination image.
   * @param dest_height The height of destination image.
   * @param interp_type The interpolation type for the transformation.
   * @return The new Gdk::Pixbuf, or <tt>0</tt> if not enough memory could be
   * allocated for it.
   */
  Glib::RefPtr<Gdk::Pixbuf> scale_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type) const;

  
  /** Creates a new Gdk::Pixbuf by scaling @a src to @a dest_width x
   *  @a dest_height and compositing the result with a checkboard of colors
   *  @a color1 and @a color2.
   * @param dest_width The width of destination image.
   * @param dest_height The height of destination image.
   * @param interp_type The interpolation type for the transformation.
   * @param overall_alpha Overall alpha for source image (0..255).
   * @param check_size The size of checks in the checkboard (must be a power of two).
   * @param color1 The color of check at upper left.
   * @param color2 The color of the other check.
   * @return The new Gdk::Pixbuf, or <tt>0</tt> if not enough memory could be
   * allocated for it.
   */
  Glib::RefPtr<Gdk::Pixbuf> composite_color_simple(
                   int dest_width, int dest_height,
                   InterpType interp_type,
                   int overall_alpha, int check_size,
                   guint32 color1, guint32 color2) const;

  
  /** Rotates a pixbuf by a multiple of 90 degrees, and returns the
   * result in a new pixbuf.
   * @param angle The angle to rotate by.
   * @return The new Gdk::Pixbuf, or <tt>0</tt> if not enough memory could be
   * allocated for it.
   * 
   * @newin{2,6}.
   */
  Glib::RefPtr<Gdk::Pixbuf> rotate_simple(PixbufRotation angle) const;
  
  /** Flips a pixbuf horizontally or vertically and returns the
   * result in a new pixbuf.
   * @param horizontal <tt>true</tt> to flip horizontally, <tt>false</tt> to flip vertically.
   * @return The new Gdk::Pixbuf, or <tt>0</tt> if not enough memory could be
   * allocated for it.
   * 
   * @newin{2,6}.
   */
  Glib::RefPtr<Gdk::Pixbuf> flip(bool horizontal = true) const;

  
  /** Takes the opacity values in a rectangular portion of a pixbuf and thresholds
   * them to produce a bi-level alpha mask that can be used as a clipping mask for
   * a drawable.
   * @param bitmap Bitmap where the bilevel mask will be painted to.
   * @param src_x Source X coordinate.
   * @param src_y Source Y coordinate.
   * @param dest_x Destination X coordinate.
   * @param dest_y Destination Y coordinate.
   * @param width Width of region to threshold, or -1 to use pixbuf width.
   * @param height Height of region to threshold, or -1 to use pixbuf height.
   * @param alpha_threshold Opacity values below this will be painted as zero; all
   * other values will be painted as one.
   */
  void render_threshold_alpha(const Glib::RefPtr<Gdk::Bitmap>& bitmap,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          int alpha_threshold);

  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Renders a rectangular portion of a pixbuf to a drawable while using the
   * specified GC.  This is done using GdkRGB, so the specified drawable must have
   * the GdkRGB visual and colormap.  Note that this function will ignore the
   * opacity information for images with an alpha channel; the GC must already
   * have the clipping mask set if you want transparent regions to show through.
   * 
   * For an explanation of dither offsets, see the GdkRGB documentation.  In
   * brief, the dither offset is important when re-rendering partial regions of an
   * image to a rendered version of the full image, or for when the offsets to a
   * base position change, as in scrolling.  The dither matrix has to be shifted
   * for consistent visual results.  If you do not have any of these cases, the
   * dither offsets can be both zero.
   * 
   * Deprecated: 2.4: This function is obsolete. Use gdk_draw_pixbuf() instead.
   * @deprecated Use Gdk::Drawable::draw_pixbuf() instead.
   * @param drawable Destination drawable.
   * @param gc GC used for rendering.
   * @param src_x Source X coordinate within pixbuf.
   * @param src_y Source Y coordinate within pixbuf.
   * @param dest_x Destination X coordinate within drawable.
   * @param dest_y Destination Y coordinate within drawable.
   * @param width Width of region to render, in pixels, or -1 to use pixbuf width.
   * @param height Height of region to render, in pixels, or -1 to use pixbuf height.
   * @param dither Dithering mode for GdkRGB.
   * @param x_dither X offset for dither.
   * @param y_dither Y offset for dither.
   */
  void render_to_drawable(const Glib::RefPtr<Drawable>& drawable,
                                          const Glib::RefPtr<Gdk::GC>& gc,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          RgbDither dither,
                                          int x_dither, int y_dither);
#endif // GDKMM_DISABLE_DEPRECATED


#ifndef GDKMM_DISABLE_DEPRECATED

  /** Renders a rectangular portion of a pixbuf to a drawable.  The destination
   * drawable must have a colormap. All windows have a colormap, however, pixmaps
   * only have colormap by default if they were created with a non-<tt>0</tt> window argument.
   * Otherwise a colormap must be set on them with gdk_drawable_set_colormap.
   * 
   * On older X servers, rendering pixbufs with an alpha channel involves round trips
   * to the X server, and may be somewhat slow.
   * 
   * Deprecated: 2.4: This function is obsolete. Use gdk_draw_pixbuf() instead.
   * @deprecated Use Gdk::Drawable::draw_pixbuf() instead.
   * @param drawable Destination drawable.
   * @param src_x Source X coordinate within pixbuf.
   * @param src_y Source Y coordinates within pixbuf.
   * @param dest_x Destination X coordinate within drawable.
   * @param dest_y Destination Y coordinate within drawable.
   * @param width Width of region to render, in pixels, or -1 to use pixbuf width.
   * @param height Height of region to render, in pixels, or -1 to use pixbuf height.
   * @param alpha_mode Ignored. Present for backwards compatibility.
   * @param alpha_threshold Ignored. Present for backwards compatibility.
   * @param dither Dithering mode for GdkRGB.
   * @param x_dither X offset for dither.
   * @param y_dither Y offset for dither.
   */
  void render_to_drawable_alpha(const Glib::RefPtr<Drawable>& drawable,
                                          int src_x, int src_y,
                                          int dest_x, int dest_y,
                                          int width, int height,
                                          PixbufAlphaMode alpha_mode,
                                          int alpha_threshold,
                                          RgbDither dither,
                                          int x_dither, int y_dither);
#endif // GDKMM_DISABLE_DEPRECATED


  void render_pixmap_and_mask_for_colormap(const Glib::RefPtr<Colormap>& colormap,
                                           Glib::RefPtr<Pixmap>& pixmap_return,
                                           Glib::RefPtr<Bitmap>& mask_return,
                                           int alpha_threshold);

  void render_pixmap_and_mask(Glib::RefPtr<Pixmap>& pixmap_return,
                              Glib::RefPtr<Bitmap>& mask_return, int alpha_threshold);

  
  /** Looks up @a key in the list of options that may have been attached to the
   *  @a pixbuf when it was loaded, or that may have been attached by another
   * function using set_option().
   * 
   * For instance, the ANI loader provides "Title" and "Artist" options. 
   * The ICO, XBM, and XPM loaders provide "x_hot" and "y_hot" hot-spot 
   * options for cursor definitions. The PNG loader provides the tEXt ancillary
   * chunk key/value pairs as options. Since 2.12, the TIFF and JPEG loaders
   * return an "orientation" option string that corresponds to the embedded 
   * TIFF/Exif orientation tag (if present).
   * @param key A nul-terminated string.
   * @return The value associated with @a key. This is a nul-terminated 
   * string that should not be freed or <tt>0</tt> if @a key was not found.
   */
  Glib::ustring get_option(const Glib::ustring& key) const;


  typedef Glib::SListHandle< Glib::RefPtr<PixbufFormat>, PixbufFormatTraits > SListHandle_PixbufFormat;
  static SListHandle_PixbufFormat get_formats();
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Pixbuf
   */
  Glib::RefPtr<Gdk::Pixbuf> wrap(GdkPixbuf* object, bool take_copy = false);
}


#endif /* _GDKMM_PIXBUF_H */

