/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>


#ifndef _Included_org_gnu_gtk_Action
#define _Included_org_gnu_gtk_Action
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Action_gtk_1action_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_action_get_type();
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_get_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Action_gtk_1action_1get_1name
  (JNIEnv *env, jclass cls, jint action)
{
	const gchar* name = gtk_action_get_name((GtkAction*)action);
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_activate
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Action_gtk_1action_1activate
  (JNIEnv *env, jclass cls, jint action)
{
	gtk_action_activate((GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_create_icon
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Action_gtk_1action_1create_1icon
  (JNIEnv *env, jclass cls, jint action, jint iconSize)
{
	return (jint)gtk_action_create_icon((GtkAction*)action, (GtkIconSize)iconSize);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_create_menu_item
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Action_gtk_1action_1create_1menu_1item
  (JNIEnv *env, jclass cls, jint action)
{
	return (jint)gtk_action_create_menu_item((GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_create_tool_item
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Action_gtk_1action_1create_1tool_1item
  (JNIEnv *env, jclass cls, jint action)
{
	return (jint)gtk_action_create_tool_item((GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_connect_proxy
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Action_gtk_1action_1connect_1proxy
  (JNIEnv *env, jclass cls, jint action, jint proxy)
{
	gtk_action_connect_proxy((GtkAction*)action, (GtkWidget*)proxy);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_disconnect_proxy
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Action_gtk_1action_1disconnect_1proxy
  (JNIEnv *env, jclass cls, jint action, jint proxy)
{
	gtk_action_disconnect_proxy((GtkAction*)action, (GtkWidget*)proxy);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_get_proxies
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_Action_gtk_1action_1get_1proxies
  (JNIEnv *env, jclass cls, jint action)
{
	GSList *list = gtk_action_get_proxies((GtkAction*)action);
	if (NULL == list)
		return NULL;
	 guint len = g_slist_length(list);
	 jintArray ar = (*env)->NewIntArray(env, len);
	 int i = 0;
	for (i = 0; i < len; i++) {
		GSList *item = g_slist_nth(list, i);
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)item->data);
	}
	return ar;
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_connect_accelerator
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Action_gtk_1action_1connect_1accelerator
  (JNIEnv *env, jclass cls, jint action)
{
	gtk_action_connect_accelerator((GtkAction*)action);
}

/*
 * Class:     org_gnu_gtk_Action
 * Method:    gtk_action_disconnect_accelerator
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Action_gtk_1action_1disconnect_1accelerator
  (JNIEnv *env, jclass cls, jint action)
{
	gtk_action_disconnect_accelerator((GtkAction*)action);
}

#ifdef __cplusplus
}
#endif
#endif
