dnl This file is part of Java-GNOME.
dnl
dnl Java-GNOME is free software; you can redistribute it and/or modify it
dnl under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl Java-GNOME is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with Jade; see the file COPYING.  If not, write to
dnl the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

dnl Copied blatantly from other source.
dnl Configure paths for GTK+
dnl Owen Taylor     97-11-3

dnl AM_PATH_GTK([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GTK, and define GTK_CFLAGS and GTK_LIBS
dnl
AC_DEFUN(AM_PATH_GTK,
[dnl 
dnl Get the cflags and libraries from the gtk-config script
dnl
AC_ARG_WITH(gtk-prefix,[  --with-gtk-prefix=PFX   Prefix where GTK is installed (optional)],
            gtk_config_prefix="$withval", gtk_config_prefix="")
AC_ARG_WITH(gtk-exec-prefix,[  --with-gtk-exec-prefix=PFX Exec prefix where GTK is installed (optional)],
            gtk_config_exec_prefix="$withval", gtk_config_exec_prefix="")
AC_ARG_ENABLE(gtktest, [  --disable-gtktest       Do not try to compile and run a test GTK program],
		    , enable_gtktest=yes)

  for module in . $4
  do
      case "$module" in
         gthread) 
             gtk_config_args="$gtk_config_args gthread"
         ;;
      esac
  done

  if test x$gtk_config_exec_prefix != x ; then
     gtk_config_args="$gtk_config_args --exec-prefix=$gtk_config_exec_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_exec_prefix/bin/gtk-config
     fi
  fi
  if test x$gtk_config_prefix != x ; then
     gtk_config_args="$gtk_config_args --prefix=$gtk_config_prefix"
     if test x${GTK_CONFIG+set} != xset ; then
        GTK_CONFIG=$gtk_config_prefix/bin/gtk-config
     fi
  fi

  AC_PATH_PROG(GTK_CONFIG, gtk-config, no)
  min_gtk_version=ifelse([$1], ,1.2.0,$1)
  AC_MSG_CHECKING(for GTK - version >= $min_gtk_version)
  no_gtk=""
  if test "$GTK_CONFIG" = "no" ; then
    no_gtk=yes
  else
    GTK_CFLAGS=`$GTK_CONFIG $gtk_config_args --cflags`
    GTK_LIBS=`$GTK_CONFIG $gtk_config_args --libs`
    gtk_config_major_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gtk_config_minor_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gtk_config_micro_version=`$GTK_CONFIG $gtk_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_gtktest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $GTK_CFLAGS"
      LIBS="$GTK_LIBS $LIBS"
dnl
dnl Now check if the installed GTK is sufficiently new. (Also sanity
dnl checks the results of gtk-config to some extent
dnl
      rm -f conf.gtktest
      AC_TRY_RUN([
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.gtktest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_gtk_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_gtk_version");
     exit(1);
   }

  if ((gtk_major_version != $gtk_config_major_version) ||
      (gtk_minor_version != $gtk_config_minor_version) ||
      (gtk_micro_version != $gtk_config_micro_version))
    {
      printf("\n*** 'gtk-config --version' returned %d.%d.%d, but GTK+ (%d.%d.%d)\n", 
             $gtk_config_major_version, $gtk_config_minor_version, $gtk_config_micro_version,
             gtk_major_version, gtk_minor_version, gtk_micro_version);
      printf ("*** was found! If gtk-config was correct, then it is best\n");
      printf ("*** to remove the old version of GTK+. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If gtk-config was wrong, set the environment variable GTK_CONFIG\n");
      printf("*** to point to the correct copy of gtk-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
#if defined (GTK_MAJOR_VERSION) && defined (GTK_MINOR_VERSION) && defined (GTK_MICRO_VERSION)
  else if ((gtk_major_version != GTK_MAJOR_VERSION) ||
	   (gtk_minor_version != GTK_MINOR_VERSION) ||
           (gtk_micro_version != GTK_MICRO_VERSION))
    {
      printf("*** GTK+ header files (version %d.%d.%d) do not match\n",
	     GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     gtk_major_version, gtk_minor_version, gtk_micro_version);
    }
#endif /* defined (GTK_MAJOR_VERSION) ... */
  else
    {
      if ((gtk_major_version > major) ||
        ((gtk_major_version == major) && (gtk_minor_version > minor)) ||
        ((gtk_major_version == major) && (gtk_minor_version == minor) && (gtk_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of GTK+ (%d.%d.%d) was found.\n",
               gtk_major_version, gtk_minor_version, gtk_micro_version);
        printf("*** You need a version of GTK+ newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** GTK+ is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the gtk-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of GTK+, but you can also set the GTK_CONFIG environment to point to the\n");
        printf("*** correct copy of gtk-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_gtk=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gtk" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GTK_CONFIG" = "no" ; then
       echo "*** The gtk-config script installed by GTK could not be found"
       echo "*** If GTK was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GTK_CONFIG environment variable to the"
       echo "*** full path to gtk-config."
     else
       if test -f conf.gtktest ; then
        :
       else
          echo "*** Could not run GTK test program, checking why..."
          CFLAGS="$CFLAGS $GTK_CFLAGS"
          LIBS="$LIBS $GTK_LIBS"
          AC_TRY_LINK([
#include <gtk/gtk.h>
#include <stdio.h>
],      [ return ((gtk_major_version) || (gtk_minor_version) || (gtk_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GTK or finding the wrong"
          echo "*** version of GTK. If it is not finding GTK, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GTK was incorrectly installed"
          echo "*** or that you have moved GTK since it was installed. In the latter case, you"
          echo "*** may want to edit the gtk-config script: $GTK_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GTK_CFLAGS=""
     GTK_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GTK_CFLAGS)
  AC_SUBST(GTK_LIBS)
  rm -f conf.gtktest
])

dnl Borrowed HEAVILY from AM_PATH_GTK
dnl
dnl AM_PATH_GNOME([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for GNOME, and define GNOME_CFLAGS and GNOME_LIBS
dnl
AC_DEFUN(AM_PATH_GNOME,
[dnl 
dnl Get the cflags and libraries from the gnome-config script
dnl
AC_ARG_WITH(gnome-prefix,[  --with-gnome-prefix=PFX   Prefix where GNOME is installed (optional)],
            gnome_config_prefix="$withval", gnome_config_prefix="")
AC_ARG_WITH(gnome-exec-prefix,[  --with-gnome-exec-prefix=PFX Exec prefix where GNOME is installed (optional)],
            gnome_config_exec_prefix="$withval", gnome_config_exec_prefix="")

  for module in . $4
  do
      case "$module" in
	 glib)
             gnome_config_args="$gnome_config_args glib"
	     ;;
	 idl)
             gnome_config_args="$gnome_config_args idl"
	     ;;
	 gnome)
             gnome_config_args="$gnome_config_args gnome"
	     ;;
	 gnomeui)
             gnome_config_args="$gnome_config_args gnomeui"
	     ;;
	 gnorba)
             gnome_config_args="$gnome_config_args gnorba"
	     ;;
	 gtk)
             gnome_config_args="$gnome_config_args gtk"
	     ;;
	 gtkxmhtml)
             gnome_config_args="$gnome_config_args gtkxmhtml"
	     ;;
	 zvt)
             gnome_config_args="$gnome_config_args zvt"
         ;;
      esac
  done

  if test x$gnome_config_exec_prefix != x ; then
     gnome_config_args="$gnome_config_args --exec-prefix=$gnome_config_exec_prefix"
     if test x${GNOME_CONFIG+set} != xset ; then
        GNOME_CONFIG=$gnome_config_exec_prefix/bin/gnome-config
     fi
  fi
  if test x$gnome_config_prefix != x ; then
     gnome_config_args="$gnome_config_args --prefix=$gnome_config_prefix"
     if test x${GNOME_CONFIG+set} != xset ; then
        GNOME_CONFIG=$gnome_config_prefix/bin/gnome-config
     fi
  fi

  AC_PATH_PROG(GNOME_CONFIG, gnome-config, no)
  min_gnome_version=ifelse([$1], ,1.2.0,$1)
  AC_MSG_CHECKING(for GNOME - version >= $min_gnome_version)
  no_gnome=""
  if test "$GNOME_CONFIG" = "no" ; then
     no_gnome=yes
  else
     GNOME_CFLAGS=`$GNOME_CONFIG $gnome_config_args --cflags`
     GNOME_LIBS=`$GNOME_CONFIG $gnome_config_args --libs`
     gnome_config_major_version=`$GNOME_CONFIG $gnome_config_args --version | \
           sed 's/.*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
     gnome_config_minor_version=`$GNOME_CONFIG $gnome_config_args --version | \
           sed 's/.*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
     gnome_config_micro_version=`$GNOME_CONFIG $gnome_config_args --version | \
           sed 's/.*\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
     AC_TRY_RUN([
#include <stdio.h>

main()
{
    if ((1$gnome_config_major_version > 1$min_gnome_config_major_version) ||
	((1$gnome_config_major_version == 1$min_gnome_config_major_version) &&
	    (1$gnome_config_minor_version > 1$min_gnome_config_minor_version)) ||
	((1$gnome_config_major_version == 1$min_gnome_config_major_version) &&
	    (1$gnome_config_minor_version == 1$min_gnome_config_minor_version) &&
	    (1$gnome_config_micro_version >= 1$min_gnome_config_micro_version)))
    {
	return(0);
    }
    else
    {
	return(1);
    }
}], , no_gnome=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])

  fi
  if test "x$no_gnome" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(GNOME_CFLAGS)
  AC_SUBST(GNOME_LIBS)
])

dnl Borrowed HEAVILY from AM_PATH_GTK
dnl
dnl AM_PATH_JAVA([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for Java, and define JAVADOC, JAVAC, JAVA, JAR, CLASSPATH and 
dnl JAVA_INCLUDES
dnl
AC_DEFUN(AM_PATH_JAVA,
[dnl 
dnl Get the environmental variables necessary for Java.
dnl
AC_ARG_WITH(java-prefix,[  --with-java-prefix=PFX   Prefix where Java is installed (optional)],
            java_prefix="$withval", java_prefix="")
AC_ARG_WITH(java-exec-prefix,[  --with-java-exec-prefix=PFX Exec prefix where Java is installed (optional)],
            java_exec_prefix="$withval", java_exec_prefix="")

  if test x$java_exec_prefix != x ; then
    JAVA_HOME=$java_exec_prefix
  fi
  if test x$java_prefix != x ; then
    JAVA_HOME=$java_prefix
  fi

  dnl 
  dnl CHANGE: Now FIRST put JAVA_HOME/bin in the path before testing for 
  dnl the java executable.
  dnl
  if test x$JAVA_HOME != x ; then
    echo "Add $JAVA_HOME/bin to path and check again."
    PATH="$JAVA_HOME/bin:$PATH"
    unset ac_cv_path_JAVA
  fi
  AC_PATH_PROG(JAVA, java, no)

  min_java_version=ifelse([$0], ,1.1.7,$1)
  AC_MSG_CHECKING(for Java - version >= $min_java_version)
  min_java_major_version=`echo $min_java_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\1/'`
  min_java_minor_version=`echo $min_java_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\2/'`
  min_java_micro_version=`echo $min_java_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\3/'`
  if test "$JAVA" = "no" ; then
    no_java=yes
  else
    java_version=`$JAVA -version 2>&1 | sed 's/.*ersion //;s/\"//g'`
    java_major_version=`echo $java_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\1/'`
    java_minor_version=`echo $java_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\2/'`
    java_micro_version=`echo $java_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\3/'`
    AC_TRY_RUN([
#include <stdio.h>

main()
{
    if ((1$java_major_version > 1$min_java_major_version) ||
	((1$java_major_version == 1$min_java_major_version) &&
	    (1$java_minor_version > 1$min_java_minor_version)) ||
	((1$java_major_version == 1$min_java_major_version) &&
	    (1$java_minor_version == 1$min_java_minor_version) &&
	    (1$java_micro_version >= 1$min_java_micro_version)))
    {
	return(0);
    }
    else
    {
	return(1);
    }
}], , no_java=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])
  fi
  if test "x$no_java" = x ; then
     AC_MSG_RESULT(yes)
     dnl
     dnl Check for java executables and set appropriate viarable
     dnl
     AC_PATH_PROG(JAVADOC, javadoc, no)
dnl     AC_CHECK_PROG(JAVAC, jikes, $JAVA_HOME/bin/jikes)
     AC_PATH_PROG(JAVAC, javac, no)
     AC_PATH_PROG(JAVA, java, no)
     AC_PATH_PROG(JAR, jar, no)
     dnl
     dnl Set CLASSPATH and JAVA_INCLUDES
     dnl
     if test x$JAVA_HOME != x ; then
        :
     else
        JAVA_HOME=`which java | sed 's/\(.*\).bin.*java/\1/'`
     fi
     dnl
     dnl Test to see if we have a JDK > 1.3
     dnl
    AC_TRY_RUN([
#include <stdio.h>

main()
{
    if ((1$java_major_version > 11) ||
	((1$java_major_version == 11) &&
	    (1$java_minor_version > 13)) ||
	((1$java_major_version == 11) &&
	    (1$java_minor_version == 13) &&
	    (1$java_micro_version >= 10)))
    {
	return(0);
    }
    else
    {
	return(1);
    }
}], jdk_1_3=yes, , [echo $ac_n "cross compiling; assumed OK... $ac_c"])
     if test x$jdk_1_3 != x ; then
       CLASSPATH=""
       OS_INCLUDES=`(cd ${JAVA_HOME}/include/; ls */jni_md.h) |\
         sed "s/\(.*\).jni_md.h/\1/"`
       JAVA_INCLUDES="-I ${JAVA_HOME}/include -I ${JAVA_HOME}/include/${OS_INCLUDES}"
     else
       CLASSPATH="${JAVA_HOME}/lib/classes.zip:"
       OS_INCLUDES=`(cd ${JAVA_HOME}/include/; ls */jni_md.h) |\
         sed "s/\(.*\).jni_md.h/\1/"`
       JAVA_INCLUDES="-I ${JAVA_HOME}/include -I ${JAVA_HOME}/include/${OS_INCLUDES}"
     fi
     AC_SUBST(CLASSPATH)
     AC_SUBST(JAVA_INCLUDES)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     echo "***"
     echo "*** If you have Java installed and it is a newer version than $min_java_version, either set"
     echo "*** the JAVA_HOME variable or add the directory where the Java binaries are to"
     echo "*** the PATH.  Alternatively try \"./configure --with-java-prefix=<java_home>\","
     echo "*** e.g. \"./configure --with-java-prefix=/usr/jdk\"."
     echo "***"
     echo "*** Also make sure that configure does not find the wrong version of Java by"
     echo "*** looking at the output of \"which java\"."
     echo "***"
     ifelse([$3], , :, [$3])
  fi
])

dnl Borrowed HEAVILY from AM_PATH_GTK
dnl
dnl AM_PATH_kaffe([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for Kaffe, and define JAVADOC, JAVAC, JAVA, JAR, CLASSPATH and 
dnl JAVA_INCLUDES
dnl
AC_DEFUN(AM_PATH_KAFFE,
[dnl 
dnl Get the environmental variables necessary for Kaffe.
dnl
AC_ARG_WITH(kaffe-prefix,[  --with-kaffe-prefix=PFX   Prefix where Kaffe is installed (optional)],
            kaffe_prefix="$withval", kaffe_prefix="")
AC_ARG_WITH(kaffe-exec-prefix,[  --with-kaffe-exec-prefix=PFX Exec prefix where Kaffe is installed (optional)],
            kaffe_exec_prefix="$withval", kaffe_exec_prefix="")

  if test x$kaffe_exec_prefix != x ; then
    JAVA_HOME=$kaffe_exec_prefix
  fi
  if test x$kaffe_prefix != x ; then
    JAVA_HOME=$kaffe_prefix
  fi

  dnl 
  dnl FIRST put JAVA_HOME/bin in the path before testing for 
  dnl the kaffe executable.
  dnl
  if test x$JAVA_HOME != x ; then
    echo "Add $JAVA_HOME/bin to path and check again."
    PATH="$JAVA_HOME/bin:$PATH"
    unset ac_cv_path_KAFFE
  fi
  AC_PATH_PROG(KAFFE, kaffe, no)

  min_kaffe_version=ifelse([$0], ,1.1,$1)
  AC_MSG_CHECKING(for Kaffe - Java Version >= $min_kaffe_version)
  min_kaffe_major_version=`echo $min_kaffe_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).*/\1/'`
  min_kaffe_minor_version=`echo $min_kaffe_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).*/\2/'`
  if test "$KAFFE" = "no" ; then
    no_kaffe=yes
  else
    kaffe_version=`$KAFFE -version 2>&1 | grep -i "version" | sed 's/.*Version: *//;s/\"//g'`
    kaffe_major_version=`echo $kaffe_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.*/\1/'`
    kaffe_minor_version=`echo $kaffe_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.*/\2/'`
    AC_TRY_RUN([
#include <stdio.h>

main()
{
    if ((1$kaffe_major_version > 1$min_kaffe_major_version) ||
	((1$kaffe_major_version == 1$min_kaffe_major_version) &&
	    (1$kaffe_minor_version >= 1$min_kaffe_minor_version)))
    {
	return(0);
    }
    else
    {
	return(1);
    }
}], , no_kaffe=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])
  fi
  if test "x$no_kaffe" = x ; then
     AC_MSG_RESULT(yes)
     dnl
     dnl Check for kaffe executables and set appropriate viarable
     dnl
     AC_PATH_PROG(JAVADOC, javadoc, no)
     AC_PATH_PROG(JAVAC, javac, no)
     AC_PATH_PROG(JAVA, kaffe, no)
     AC_PATH_PROG(JAR, jar, no)
     dnl
     dnl Set CLASSPATH and JAVA_INCLUDES
     dnl
     if test x$JAVA_HOME != x ; then
        :
     else
        JAVA_HOME=`which kaffe | sed 's/\(.*\).bin.*kaffe/\1/'`
     fi
     dnl
     dnl Test to see if we have a JDK > 1.3
     dnl
     CLASSPATH="${JAVA_HOME}/share/kaffe/Klasses.jar:"
     JAVA_INCLUDES="-I ${JAVA_HOME}/include/kaffe"
     AC_SUBST(CLASSPATH)
     AC_SUBST(JAVA_INCLUDES)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     echo "***"
     echo "*** If you have Kaffe installed and it is a newer version than $min_kaffe_version, either set"
     echo "*** the JAVA_HOME variable or add the directory where the Kaffe binaries are to"
     echo "*** the PATH.  Alternatively try "
     echo "*** \"./configure --with-kaffe --with-kaffe-prefix=<JAVA_HOME>\","
     echo "*** e.g. \"./configure --with-kaffe --with-kaffe-prefix=/usr\"."
     echo "***"
     echo "*** Also make sure that configure does not find the wrong version of Kaffe by"
     echo "*** looking at the output of \"which kaffe\"."
     echo "***"
     ifelse([$3], , :, [$3])
  fi
])

dnl 
dnl For now we have to include it since I am to dumb to know how to use
dnl it from the aclocal directory
dnl
dnl AM_PATH_LIBGLADE([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]])
dnl Test to see if libglade is installed, and define LIBGLADE_CFLAGS, LIBS
dnl
AC_DEFUN(AM_PATH_LIBGLADE,
[dnl
dnl Get the cflags and libraries from the libglade-config script
dnl
AC_ARG_WITH(libglade-config,
[  --with-libglade-config=LIBGLADE_CONFIG  Location of libglade-config],
LIBGLADE_CONFIG="$withval")

module_args=
for module in . $3; do
  case "$module" in
    gnome)
      module_args="$module_args gnome"
      ;;
    bonobo)
      module_args="$module_args bonobo"
      ;;
  esac
done

AC_PATH_PROG(LIBGLADE_CONFIG, libglade-config, no)
AC_MSG_CHECKING(for libglade)
if test "$LIBGLADE_CONFIG" = "no"; then
  AC_MSG_RESULT(no)
  ifelse([$2], , :, [$2])
else
  if $LIBGLADE_CONFIG --check $module_args; then
    LIBGLADE_CFLAGS=`$LIBGLADE_CONFIG --cflags $module_args`
    LIBGLADE_LIBS=`$LIBGLADE_CONFIG --libs $module_args`
    AC_MSG_RESULT(yes)
    ifelse([$1], , :, [$1])
  else
    echo "*** libglade was not compiled with support for $module_args" 1>&2
    AC_MSG_RESULT(no)
    ifelse([$2], , :, [$2])
  fi
fi
AC_SUBST(LIBGLADE_CFLAGS)
AC_SUBST(LIBGLADE_LIBS)
])


dnl Borrowed HEAVILY from AM_PATH_GTK
dnl
dnl AM_PATH_GCJ([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for GCJ
dnl
AC_DEFUN(AM_PATH_GCJ,
[dnl 
dnl Get the environmental variables necessary for GCJ
dnl
AC_ARG_WITH(gcj-prefix,[  --with-gcj-prefix=PFX   Prefix where gcj is installed (optional)],
            gcj_prefix="$withval", gcj_prefix="")

  if test x$gcj_prefix != x ; then
    GCJ_HOME=$gcj_prefix
  fi

  dnl 
  dnl CHANGE: Now FIRST put GCJ_HOME/bin in the path before testing for 
  dnl the java executable.
  dnl
  if test x$GCJ_HOME != x ; then
    echo "Add $GCJ_HOME/bin to path and check again."
    PATH="$GCJ_HOME/bin:$PATH"
  fi
  AC_PATH_PROG(GCJ, gcj, no)

  min_gcj_version=ifelse([$0], ,3.0.0,$1)
  AC_MSG_CHECKING(for GCJ - version >= $min_gcj_version)
  min_gcj_major_version=`echo $min_gcj_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\1/'`
  min_gcj_minor_version=`echo $min_gcj_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\2/'`
  min_gcj_micro_version=`echo $min_gcj_version |\
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\3/'`
  if test "$GCJ" = "no" ; then
    no_gcj=yes
  else
    gcj_version=`$GCJ --version 2>&1 | grep GCC | sed 's/gcj (GCC) \([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\1.\2.\3/'`
    gcj_major_version=`echo $gcj_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\1/'`
    gcj_minor_version=`echo $gcj_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\2/'`
    gcj_micro_version=`echo $gcj_version | \
           sed 's/\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\).*/\3/'`
    AC_TRY_RUN([
#include <stdio.h>

main()
{
    if ((1$gcj_major_version > 1$min_gcj_major_version) ||
	((1$gcj_major_version == 1$min_gcj_major_version) &&
	    (1$gcj_minor_version > 1$min_gcj_minor_version)) ||
	((1$gcj_major_version == 1$min_gcj_major_version) &&
	    (1$gcj_minor_version == 1$min_gcj_minor_version) &&
	    (1$gcj_micro_version >= 1$min_gcj_micro_version)))
    {
	return(0);
    }
    else
    {
	return(1);
    }
}], , no_gcj=yes, [echo $ac_n "cross compiling; assumed OK... $ac_c"])
  fi
  if test "x$no_gcj" = x ; then
     AC_MSG_RESULT(yes)
     dnl
     dnl Check for gcj executables and set appropriate viarable
     dnl
     AC_PATH_PROG(GCJ, gcj, no)
     AC_PATH_PROG(JAR, jar, no)
     dnl
     dnl Set CLASSPATH
     dnl
     if test x$GCJ_HOME != x ; then
        :
     else
        GCJ_HOME=`which gcj | sed 's/\(.*\).bin.*gcj/\1/'`
     fi

     GCJ_JAR=`locate libgcj | grep libgcj.*\.jar`
     if test x$GCJ_JAR != x ; then
        GCJ_CLASSPATH="${GCJ_JAR}:${CLASSPATH}"
     else
	   echo "***"
	   echo "*** Unable to locate libgcj.jar needed by gcj"
	   echo "***"
 	   ifelse([$3], , :, [$3])
    fi	
     AC_SUBST(GCJ_CLASSPATH)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
     echo "***"
     echo "*** If you have GCJ installed and it is a newer version than $min_java_version, either set"
     echo "*** the GCJ_HOME variable or add the top directory where the GCJ binaries are to"
     echo "*** the PATH.  Alternatively try \"./configure --with-gcj-prefix=<java_home>\","
     echo "***"
     echo "*** Also make sure that configure does not find the wrong version of GCJ by"
     echo "*** looking at the output of \"which gcj\"."
     echo "***"
     ifelse([$3], , :, [$3])
  fi
])


dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN(PKG_CHECK_MODULES, [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     if ! $PKG_CONFIG --atleast-pkgconfig-version 0.7.0; then
        echo "*** Your version of pkg-config is too old. You need version 0.7.0 or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     else
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            ## If we have a custom action on failure, don't print errors, but 
            ## do set a variable so people can do so.
            $1_PKG_ERRORS=`$PKG_CONFIG --errors-to-stdout --print-errors "$2"`
            ifelse([$4], ,echo $$1_PKG_ERRORS,)
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])


AC_DEFUN([AM_PATH_DOCBOOK],[
AC_REQUIRE([AC_EXEEXT])dnl
AC_PATH_PROG(DB1, db2html$EXEEXT, nocommand)
if test "$DB1" = nocommand; then
	AC_PATH_PROG(DB2, docbook2html$EXEEXT, nocommand)
  	if test "$DB2" = nocommand; then
    		AC_MSG_ERROR([docbook not found in $PATH])
	else
		DOCBOOK=$DB2
  	fi;dnl
else
	DOCBOOK=$DB1
fi;dnl
AC_SUBST(DOCBOOK)
])
