/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 07:28:00 EDT
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.Button;
import org.gnu.gtk.Container;
import org.gnu.gtk.Widget;
import org.gnu.gtk.Window;
/**
 * The GNOME druid is a system for assisting the user with installing a
 * service. It is roughly equivalent in functionality to the Wizards
 * available in Windows.
 */
public class Druid extends Container {
	
	/**
	 * Construct a new Druid object.
	 */
	public Druid() {
		noopInit();
	}
	
	/**
	 * Construct a new Druid from a handle to a native resource.
	 */
	public Druid(int handle) {
	    super(handle);
	}
	
	protected void noopInit() {
		if (-1 == handle) {
			handle = gnome_druid_new();
			initializeEventHandlers();
		}
	}
	
	/**
	 * Construct a new Druid object that already contains a window.
	 */
	public Druid(String title, Window parent, boolean closeOnCancel, Widget window) {
		handle = gnome_druid_new_with_window(title, parent.getHandle(), closeOnCancel, window.getHandle());
		initializeEventHandlers();
	}
	
	/**
	 * Sets the sensitivity of the buttons on the Druid dialog.
	 * @param backSensitive Determines if the "Back" button is sensitive.
	 * @param nextSensitive Determines if the "Next" button is sensitive.
	 * @param cancelSensitive Determines if the "Cancel" button is sensitive.
	 * @param helpSensitive Determines if the "Help" button is sensitive.
	 */
	public void setButtonsSensitive(boolean backSensitive, boolean nextSensitive, boolean cancelSensitive, boolean helpSensitive) {
		gnome_druid_set_buttons_sensitive(handle, backSensitive, nextSensitive, cancelSensitive, helpSensitive);
	}
	
	/**
	 * Sets the text on the last button of the dialog.  If <i>showFinish</i> is true the text
	 * becomes "Finish".  Otherwise the text is set to "Cancel".
	 * @param showFinish Determines the text of the last button on the dialog.
	 */
	public void setShowFinish(boolean showFinish) {
		gnome_druid_set_show_finish(handle, showFinish);
	}

	/**
	 * Sets whether the help button should be displayed 
	 */
	public void setShowHelp( boolean showHelp ){
		gnome_druid_set_show_help( handle, showHelp );
	}
	
	/**
	 * Prepends a DruidPage into the list of pages for this dialog.
	 * @param page The page to prepend.
	 */
	public void prependPage(DruidPage page) {
		gnome_druid_prepend_page(handle, page.getHandle());
	}
	
	/**
	 * Append a DruidPage into the list of pages for this dialog.
	 * @param page The page to append.
	 */
	public void appendPage(DruidPage page) {
		gnome_druid_append_page(handle, page.getHandle());
	}
	
	/**
	 * Insert <i>page</i> after <i>backPage</i> into the list of pages for
	 * this dialog.  If </i>backPage is not present or null, </i>page</i> will
	 * be prepended.
	 * @param backPage
	 * @param page
	 */
	public void insertPage(DruidPage backPage, DruidPage page) {
		gnome_druid_insert_page(handle, backPage.getHandle(), page.getHandle());
	}
	
	/**
	 * Set the currently displayed page to <i>page</i>.
	 * @param page The page to make the current page.
	 */
	public void setPage(DruidPage page) {
		gnome_druid_set_page(handle, page.getHandle());
	}
	
	/**
	 * Retrieve the "Help" button.
	 */
	public Button getHelpButton() {
		return new Button(getHelp(handle));
	}
	
	/**
	 * Retrieve the "Back" button.
	 */
	public Button getBackButton() {
		return new Button(getBack(handle));
	}
	
	/**
	 * Retrieve the "Next" button.
	 */
	public Button getNextButton() {
		return new Button(getNext(handle));
	}
	
	/**
	 * Retrieve the "Cancel" button.
	 */
	public Button getCancelButton() {
		return new Button(getCancel(handle));
	}
	
	/**
	 * Retrieve the "Finish" button.
	 */
	public Button getFinishButton() {
		return new Button(getFinish(handle));
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_druid_get_type());
	}
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getHelp(int cptr);
	native static final protected int getBack(int cptr);
	native static final protected int getNext(int cptr);
	native static final protected int getCancel(int cptr);
	native static final protected int getFinish(int cptr);
	native static final protected int gnome_druid_get_type();
	native static final protected int gnome_druid_new();
	native static final protected void gnome_druid_set_buttons_sensitive(int druid, boolean backSensitive, boolean nextSensitive, boolean cancelSensitive, boolean helpSensitive);
	native static final protected void gnome_druid_set_show_finish(int druid, boolean showFinish);
	native static final protected void gnome_druid_set_show_help(int druid, boolean showHelp);
	native static final protected void gnome_druid_prepend_page(int druid, int page);
	native static final protected void gnome_druid_insert_page(int druid, int backPage, int page);
	native static final protected void gnome_druid_append_page(int druid, int page);
	native static final protected void gnome_druid_set_page(int druid, int page);
	native static final protected int gnome_druid_new_with_window(String title, int parent, boolean closeOnCancel, int window);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
