/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.Pixbuf;
import org.gnu.gdk.Screen;
import org.gnu.glib.GObject;

/**
 */
public class IconTheme extends GObject {
	
	public IconTheme() {
		handle = gtk_icon_theme_new();
	}
	
	private IconTheme(int handle) {
		this.handle = handle;
	}
	
	static public IconTheme getDefault(){
		return new IconTheme(gtk_icon_theme_get_default()); 
	}
	
	static public IconTheme getForSceen(Screen screen) {
		return new IconTheme(gtk_icon_theme_get_for_screen(screen.getHandle()));
	}
	
	public void setScreen(Screen screen) {
		gtk_icon_theme_set_screen(handle, screen.getHandle());
	}
	
	public void setSearchPath(String[] path) {
		gtk_icon_theme_set_search_path(handle, path, path.length);
	}
	
	public String[] getSearchPath() {
		return gtk_icon_theme_get_search_path(handle);
	}
	
	public void appendSearchPath(String path) {
		gtk_icon_theme_append_search_path(handle, path);
	}
	
	public void prependSearchPath(String path) {
		gtk_icon_theme_prepend_search_path(handle, path);
	}
	
	public void setCustomtTheme(String name) {
		gtk_icon_theme_set_custom_theme(handle, name);
	}
	
	public boolean hasIcon(String iconName) {
		return gtk_icon_theme_has_icon(handle, iconName);
	}
	
	public IconInfo lookupIcon(String name, int size, IconLookupFlags flags) {
		return new IconInfo(gtk_icon_theme_lookup_icon(handle, name, size, flags.getValue()));
	}
	
	public Pixbuf loadIcon(String name, int size, IconLookupFlags flags) {
		return new Pixbuf(gtk_icon_theme_load_icon(handle, name, size, flags.getValue(), new int[] {}));
	}
	
	public String[] listIcons(String context) {
		return gtk_icon_theme_list_icons(handle, context);
	}
	
	public boolean rescanIfNeeded() {
		return gtk_icon_theme_rescan_if_needed(handle);
	}
	
	public static void addBuiltinIcon(String name, int size, Pixbuf pixbuf) {
		gtk_icon_theme_add_builtin_icon(name, size, pixbuf.getHandle());
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_icon_theme_get_type ();
	native static final protected int gtk_icon_theme_new();
	native static final protected int gtk_icon_theme_get_default();
	native static final protected int gtk_icon_theme_get_for_screen(int screen);
	native static final protected void gtk_icon_theme_set_screen(int itheme, int screen);
	native static final protected void gtk_icon_theme_set_search_path(int itheme, String[] path, int pathlen);
	native static final protected String[] gtk_icon_theme_get_search_path(int itheme);
	native static final protected void gtk_icon_theme_append_search_path(int itheme, String path);
	native static final protected void gtk_icon_theme_prepend_search_path(int itheme, String path);
	native static final protected void gtk_icon_theme_set_custom_theme(int itheme, String name);
	native static final protected boolean gtk_icon_theme_has_icon(int itheme, String iconName);
	native static final protected int gtk_icon_theme_lookup_icon(int itheme, String iconName, int size, int iconLookupFlags);
	native static final protected int gtk_icon_theme_load_icon(int itheme, String iconName, int size, int iconLookupflags, int[] error);
	native static final protected String[] gtk_icon_theme_list_icons(int itheme, String context);
	native static final protected String gtk_icon_theme_get_example_icon_name(int itheme);
	native static final protected boolean gtk_icon_theme_rescan_if_needed(int itheme);
	native static final protected void gtk_icon_theme_add_builtin_icon(String iconName, int size, int pixbuf);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
	
}
