/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
/**
 * The GnomeCanvasWidget is not a widget - it is a GnomeCanvasItem that
 * is capable of containing a widget. You can use a to display any
 * widget in a GnomeCanvas as if the widget were a GnomeCanvasItem.
 */
public class CanvasWidget extends CanvasItem {
	/**
	 * Constructs an instance of CanvasWidget from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasWidget(int handle) {
		super(handle);
	}

	protected void noopInit() {
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_widget_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getWidget(int cptr);
	native final protected void setWidget(int cptr, int widget);
	native static final protected double getX(int cptr);
	native final protected void setX(int cptr, double x);
	native static final protected double getY(int cptr);
	native final protected void setY(int cptr, double y);
	native static final protected double getWidth(int cptr);
	native final protected void setWidth(int cptr, double width);
	native static final protected double getHeight(int cptr);
	native final protected void setHeight(int cptr, double height);
	native static final protected int getAnchor(int cptr);
	native final protected void setAnchor(int cptr, int anchor);
	native static final protected boolean getSizePixels(int cptr);
	native final protected void setSizePixels(int cptr, boolean size_pixels);
	native static final protected int gnome_canvas_widget_get_type();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
