/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * Document everything.
  * What is the gdk_drawable_get_type(), what should i do with it?
  */
  
package org.gnu.gdk;
import org.gnu.glib.GObject;
import org.gnu.pango.Font;
import org.gnu.pango.GlyphString;
import org.gnu.pango.Layout;
import org.gnu.pango.LayoutLine;

/**
 *
 */
 
public class Drawable extends GObject 
{
	
	public Drawable(int handle){
		super(handle);
	}
	
	public Dimension getSize(){
		int width[]=new int[1];
		int height[]=new int[1];
		Drawable.gdk_drawable_get_size(getHandle(),width,height);
		return new Dimension(width[0],height[0]);
	}
	
	public void setColormap(Colormap cmap){
		Drawable.gdk_drawable_set_colormap(getHandle(),cmap.getHandle());
	}
	
	public Colormap getColormap(){
		int hndl = gdk_drawable_get_colormap(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Colormap)obj;
		return new Colormap(hndl);
	}
	
	public Visual getVisual(){
		int hndl = gdk_drawable_get_visual(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Visual)obj;
		return new Visual(hndl);
	}
	
	
	public int getDepth(){
		return Drawable.gdk_drawable_get_depth(getHandle());
	}
	
	public Image getImage(int x, int y, int width, int height){
		int hndl = gdk_drawable_get_image(getHandle(),x,y,width,height);
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Image)obj;
		return new Image(hndl);
	}
	
	public Region getClipRegion(){
		return new Region(Drawable.gdk_drawable_get_clip_region(getHandle()));
	}
	
	public Region getVisibleRegion(){
		return new Region(Drawable.gdk_drawable_get_visible_region(getHandle()));
	}
	
	public void drawRGBImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_rgb_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawRGBImageDitherAlign(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, int xdith, int ydith) {
		gdk_draw_rgb_image_dithalign(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, xdith, ydith);
	}

	public void drawRGB32Image(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_rgb_32_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawRGB32ImageDitherAlign(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, int xdith, int ydith) {
		gdk_draw_rgb_32_image_dithalign(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, xdith, ydith);
	}

	
	public void drawGrayImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride) {
		gdk_draw_gray_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride);
	}

	public void drawIndexedImage(GC gc, int x, int y, int width, int height, RgbDither dither, byte[] buffer, int rowStride, RgbCmap cmap) {
		gdk_draw_indexed_image(getHandle(), gc.getHandle(), x, y, width, height, dither.getValue(), buffer, rowStride, cmap.getHandle());
	}

	public void drawPolygon(GC gc, boolean filled, Point[] points) {
		int[] hndls = new int[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_polygon(getHandle(), gc.getHandle(), filled, hndls, hndls.length);
	}
	
	public void drawDrawable(GC gc, Drawable src, int xsrc, int ysrc, int xdest, int ydest, int width, int height) {
		gdk_draw_drawable(getHandle(), gc.getHandle(), src.getHandle(), xsrc, ysrc, xdest, ydest, width, height);
	}
	
	public void drawImage(GC gc, Image image, int xsrc, int ysrc, int xdest, int ydest, int width, int height) {
		gdk_draw_image(getHandle(), gc.getHandle(), image.getHandle(), xsrc, ysrc, xdest, ydest, width, height);
	}
	
	public void drawPoints(GC gc, Point[] points) {
		int[] hndls = new int[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_points(getHandle(), gc.getHandle(), hndls, hndls.length);
	}

	public void drawSegments(GC gc, Segment[] segments) {
		int[] hndls = new int[segments.length];
		for (int i = 0; i < segments.length; i++) {
			hndls[i] = segments[i].getHandle();
		}
		gdk_draw_segments(getHandle(), gc.getHandle(), hndls, hndls.length);
	}
	
	public void drawLines(GC gc, Point[] points) {
		int[] hndls = new int[points.length];
		for (int i = 0; i < points.length; i++) {
			hndls[i] = points[i].getHandle();
		}
		gdk_draw_lines(getHandle(), gc.getHandle(), hndls, hndls.length);
	}

	public void drawGlyphs(GC gc, Font font, int x, int y, GlyphString glyphs) {
		gdk_draw_glyphs(getHandle(), gc.getHandle(), font.getHandle(), x, y, glyphs.getHandle());
	}

	public void drawLayoutLine(GC gc, int x, int y, LayoutLine line) {
		gdk_draw_layout_line(getHandle(), gc.getHandle(), x, y, line.getHandle());
	}

	public void drawLayout(GC gc, int x, int y, Layout layout) {
		gdk_draw_layout(getHandle(), gc.getHandle(), x, y, layout.getHandle());
	}
	
	public void drawLayoutLineWithColors(GC gc, int x, int y, LayoutLine line, Color foreground, Color background) {
		gdk_draw_layout_line_with_colors(getHandle(), gc.getHandle(), x, y, line.getHandle(), foreground.getHandle(), background.getHandle());
	}
	
	public void drawLayoutWithColors(GC gc, int x, int y, Layout layout, Color foreground, Color background) {
		gdk_draw_layout_with_colors(getHandle(), gc.getHandle(), x, y, layout.getHandle(), foreground.getHandle(), background.getHandle());
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_drawable_get_type (); // ??? not in the api
    native static final protected void gdk_drawable_get_size (int drawable, int [] width, int [] 
        height);
    native static final protected void gdk_drawable_set_colormap (int drawable, int colormap);
    native static final protected int gdk_drawable_get_colormap (int drawable);
    native static final protected int gdk_drawable_get_visual (int drawable);
    native static final protected int gdk_drawable_get_depth (int drawable);
    native static final protected int gdk_drawable_get_image (int drawable, int x, int y, int 
        width, int height);
    native static final protected int gdk_drawable_get_clip_region (int drawable);
    native static final protected int gdk_drawable_get_visible_region (int drawable);

    // moved from Gdk
    native static final protected void gdk_draw_rgb_image (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_rgb_image_dithalign (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride, int xDith, int yDith);
    native static final protected void gdk_draw_rgb_32_image (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_rgb_32_image_dithalign (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride, int xDith, int yDith);
    native static final protected void gdk_draw_gray_image (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] rgbBuf, int rowstride);
    native static final protected void gdk_draw_indexed_image (int drawable, int gc, int x, int y, int width, int height, int dith, byte[] buf, int rowstride, int cmap);
    native static final protected void gdk_draw_polygon (int window, int gc, boolean filled, int [] points, int numPoints);
    native static final protected void gdk_draw_drawable (int drawable, int gc, int src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
    native static final protected void gdk_draw_image (int drawable, int gc, int image, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
    native static final protected void gdk_draw_points (int drawable, int gc, int [] points, int numPoints);
    native static final protected void gdk_draw_segments (int drawable, int gc, int [] segments, int numSegs);
    native static final protected void gdk_draw_lines (int window, int gc, int [] points, int numPoints);
    native static final protected void gdk_draw_glyphs (int drawable, int gc, int font, int x, int y, int glyphs);
    native static final protected void gdk_draw_layout_line (int drawable, int gc, int x, int y, int line);
    native static final protected void gdk_draw_layout (int drawable, int gc, int x, int y, int layout);
    native static final protected void gdk_draw_layout_line_with_colors (int drawable, int gc, int x, int y, int line, int foreground, int background);
    native static final protected void gdk_draw_layout_with_colors (int drawable, int gc, int x, int y, int layout, int foreground, int background);
    
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

