/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-09-28 10:15:52 BST
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_n_columns
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1n_1columns
    (JNIEnv *env, jclass cls, jint model) 
{
	return (jint)gtk_tree_model_get_n_columns ((GtkTreeModel*)model);
}
                                                                                                                            

/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_column_type
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1column_1type
  (JNIEnv *env, jclass cls, jint model, jint index)
{
	return (jint)gtk_tree_model_get_column_type ((GtkTreeModel*)model, (gint)index);
}

/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter
  (JNIEnv *env, jclass cls, jint model, jint path)
{
	GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	gboolean value = gtk_tree_model_get_iter((GtkTreeModel*)model, iter, (GtkTreePath*)path);
	if (TRUE == value)
		return (jint)iter;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter_from_string
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1from_1string
  (JNIEnv *env, jclass cls, jint model, jstring path)
{
	GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	gboolean value = gtk_tree_model_get_iter_from_string((GtkTreeModel*)model, iter, p);
	(*env)->ReleaseStringUTFChars(env, path, p);
	if (TRUE == value)
		return (jint)iter;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_string_from_iter
 * Signature: (II)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1string_1from_1iter
  (JNIEnv *env, jclass cls, jint model, jint iter)
{
	return (*env)->NewStringUTF(env, gtk_tree_model_get_string_from_iter((GtkTreeModel*)model, (GtkTreeIter*)iter));
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_iter_first
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1iter_1first
  (JNIEnv *env, jclass cls, jint model)
{
	GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	gboolean value = gtk_tree_model_get_iter_first((GtkTreeModel*)model, iter);
	if (TRUE == value)
		return (jint)iter;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_path
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1path
  (JNIEnv *env, jclass cls, jint model, jint iter)
{
	return (jint)gtk_tree_model_get_path((GtkTreeModel*)model, (GtkTreeIter*)iter);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_get_value
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1get_1value
  (JNIEnv *env, jclass cls, jint model, jint iter, jint column)
{
	GValue *value = (GValue*)g_malloc(sizeof(GValue));
	value->g_type = 0;
	gtk_tree_model_get_value((GtkTreeModel*)model, (GtkTreeIter*)iter, (gint)column, value);
	return (jint)value;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_next
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1next
  (JNIEnv *env, jclass cls, jint model, jint iter)
{
	GtkTreeIter* i = (GtkTreeIter*)iter;
	gboolean value = gtk_tree_model_iter_next((GtkTreeModel*)model, i);
	if (TRUE == value)
		return (jint)i;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_children
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1children
  (JNIEnv *env, jclass cls, jint model, jint parent)
{
	GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	gboolean value = gtk_tree_model_iter_children((GtkTreeModel*)model, iter, (GtkTreeIter*)parent);
	if (TRUE == value)
		return (jint)iter;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_has_child
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1has_1child
  (JNIEnv *env, jclass cls, jint model, jint iter)
{
	return (jboolean)gtk_tree_model_iter_has_child((GtkTreeModel*)model, (GtkTreeIter*)iter);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_n_children
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1n_1children
  (JNIEnv *env, jclass cls, jint model, jint iter)
{
	return (jint)gtk_tree_model_iter_n_children((GtkTreeModel*)model, (GtkTreeIter*)iter);
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_nth_child
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1nth_1child
  (JNIEnv *env, jclass cls, jint model, jint parent, jint n)
{
	GtkTreeIter* iter = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	gboolean value = gtk_tree_model_iter_nth_child((GtkTreeModel*)model, iter, (GtkTreeIter*)parent, (gint)n);
	if (TRUE == value)
		return (jint)iter;
	else
		return (jint)-1;
}
                                                                                                                            
/*
 * Class:     org_gnu_gtk_TreeModel
 * Method:    gtk_tree_model_iter_parent
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1iter_1parent
  (JNIEnv *env, jclass cls, jint model, jint child)
{
	GtkTreeIter* parent = (GtkTreeIter*)g_malloc(sizeof(GtkTreeIter));
	gboolean value = gtk_tree_model_iter_parent((GtkTreeModel*)model, parent, (GtkTreeIter*)child);
	if (TRUE == value)
		return (jint)parent;
	else
		return (jint)-1;
}
                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_changed
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1changed
//  (JNIEnv *env, jclass cls, jint model, jint path, jint iter)
//{
//	gtk_tree_model_row_changed((GtkTreeModel*)model, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_inserted
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1inserted
//  (JNIEnv *env, jclass cls, jint model, jint path, jint iter)
//{
//	gtk_tree_model_row_inserted((GtkTreeModel*)model, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_has_child_toggled
// * Signature: (III)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1has_1child_1toggled
//  (JNIEnv *env, jclass cls, jint model, jint path, jint iter)
//{
//	gtk_tree_model_row_has_child_toggled((GtkTreeModel*)model, (GtkTreePath*)path, (GtkTreeIter*)iter);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_row_deleted
// * Signature: (II)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1row_1deleted
//  (JNIEnv *env, jclass cls, jint model, jint path)
//{
//	gtk_tree_model_row_deleted((GtkTreeModel*)model, (GtkTreePath*)path);
//}
//                                                                                                                            
///*
// * Class:     org_gnu_gtk_TreeModel
// * Method:    gtk_tree_model_rows_reordered
// * Signature: (III[I)V
// */
//JNIEXPORT void JNICALL Java_org_gnu_gtk_TreeModel_gtk_1tree_1model_1rows_1reordered
//  (JNIEnv *env, jclass cls, jint model, jint path, jint iter, jintArray order)
//{
//	gint* newOrder = (gint*)(*env)->GetIntArrayElements(env, order, NULL);
//	gtk_tree_model_rows_reordered((GtkTreeModel*)model, (GtkTreePath*)path, (GtkTreeIter*)iter, newOrder);
//}


#ifdef __cplusplus
}

#endif
