/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1type (JNIEnv *env, jclass 
    cls) 
{
    return (jint)gdk_drawable_get_type ();
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_size
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1size (JNIEnv *env, jclass 
    cls, jobject drawable, jintArray width, jintArray height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    gint *width_g = (gint *) (*env)->GetIntArrayElements (env, width, NULL);
    gint *height_g = (gint *) (*env)->GetIntArrayElements (env, height, NULL);
    gdk_drawable_get_size (drawable_g, width_g, height_g);
    (*env)->ReleaseIntArrayElements (env, width, (jint *) width_g, 0);
    (*env)->ReleaseIntArrayElements (env, height, (jint *) height_g, 0);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_set_colormap
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1set_1colormap (JNIEnv *env, 
    jclass cls, jobject drawable, jobject colormap) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    gdk_drawable_set_colormap (drawable_g, colormap_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_colormap
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1colormap (JNIEnv *env, 
    jclass cls, jobject drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    return getHandleFromPointer(env, gdk_drawable_get_colormap (drawable_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_visual
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1visual (JNIEnv *env, 
    jclass cls, jobject drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    return getHandleFromPointer(env, gdk_drawable_get_visual (drawable_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_depth
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1depth (JNIEnv *env, jclass 
    cls, jobject drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    return (jint) (gdk_drawable_get_depth (drawable_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_image
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1image (JNIEnv *env, jclass 
    cls, jobject drawable, jint x, jint y, jint width, jint height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    return getHandleFromPointer(env, gdk_drawable_get_image (drawable_g, x_g, y_g, width_g, height_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_clip_region
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1clip_1region (JNIEnv *env, 
    jclass cls, jobject drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    return getHandleFromPointer(env, gdk_drawable_get_clip_region (drawable_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_drawable_get_visible_region
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Drawable_gdk_1drawable_1get_1visible_1region (JNIEnv 
    *env, jclass cls, jobject drawable) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    return getHandleFromPointer(env, gdk_drawable_get_visible_region (drawable_g));
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_image
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_1image (JNIEnv *env, jclass cls, 
    jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    gdk_draw_rgb_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_image_dithalign
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_1image_1dithalign (JNIEnv *env, 
    jclass cls, jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, 
    jbyteArray rgbBuf, jint rowstride, jint xDith, jint yDith) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    gint32 xDith_g = (gint32) xDith;
    gint32 yDith_g = (gint32) yDith;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    gdk_draw_rgb_image_dithalign (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, 
            rgbBuf_g, rowstride_g, xDith_g, yDith_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_32_image
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_132_1image (JNIEnv *env, jclass cls, 
    jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    gdk_draw_rgb_32_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_rgb_32_image_dithalign
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1rgb_132_1image_1dithalign (JNIEnv *env, 
    jclass cls, jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, 
    jbyteArray rgbBuf, jint rowstride, jint xDith, jint yDith) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    gint32 xDith_g = (gint32) xDith;
    gint32 yDith_g = (gint32) yDith;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    gdk_draw_rgb_32_image_dithalign (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, 
            rgbBuf_g, rowstride_g, xDith_g, yDith_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_gray_image
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1gray_1image (JNIEnv *env, jclass cls, 
    jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray 
    rgbBuf, jint rowstride) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint rgbBuf_len = (*env)->GetArrayLength(env, rgbBuf);
    gchar* rgbBuf_g = (gchar*)g_malloc(rgbBuf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    (*env)->GetByteArrayRegion(env, rgbBuf, 0, rgbBuf_len, (jbyte*)rgbBuf_g);
    rgbBuf_g[rgbBuf_len] = 0;
    gdk_draw_gray_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, rgbBuf_g, 
            rowstride_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_indexed_image
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1indexed_1image (JNIEnv *env, jclass cls, 
    jobject drawable, jobject gc, jint x, jint y, jint width, jint height, jint dith, jbyteArray buf, 
    jint rowstride, jint cmap) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    GdkRgbDither dith_g = (GdkRgbDither) dith;
    jint buf_len = (*env)->GetArrayLength(env, buf);
    gchar* buf_g = (gchar*)g_malloc(buf_len + 1);
    gint32 rowstride_g = (gint32) rowstride;
    GdkRgbCmap *cmap_g = (GdkRgbCmap *)cmap;
    (*env)->GetByteArrayRegion(env, buf, 0, buf_len, (jbyte*)buf_g);
    buf_g[buf_len] = 0;
    gdk_draw_indexed_image (drawable_g, gc_g, x_g, y_g, width_g, height_g, dith_g, buf_g, 
            rowstride_g, cmap_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_polygon
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1polygon (JNIEnv *env, jclass cls, jobject 
    window, jobject gc, jboolean filled, jobjectArray points) 
{
    GdkWindow *window_g = (GdkWindow *)getPointerFromHandle(env, window);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gboolean filled_g = (gboolean) filled;
    GdkPoint *points_g = (GdkPoint *)getPointerArrayFromHandles(env, points);
    gint32 numPoints_g = (*env)->GetArrayLength(env, points);
    gdk_draw_polygon (window_g, gc_g, filled_g, points_g, numPoints_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_drawable
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1drawable (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jobject src, jint xsrc, jint ysrc, jint xdest, jint ydest, jint width, jint 
    height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    GdkDrawable *src_g = (GdkDrawable *)getPointerFromHandle(env, src);
    gint32 xsrc_g = (gint32) xsrc;
    gint32 ysrc_g = (gint32) ysrc;
    gint32 xdest_g = (gint32) xdest;
    gint32 ydest_g = (gint32) ydest;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    gdk_draw_drawable (drawable_g, gc_g, src_g, xsrc_g, ysrc_g, xdest_g, ydest_g, width_g, 
            height_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_image
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1image (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jobject image, jint xsrc, jint ysrc, jint xdest, jint ydest, jint width, 
    jint height) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    GdkImage *image_g = (GdkImage *)getPointerFromHandle(env, image);
    gint32 xsrc_g = (gint32) xsrc;
    gint32 ysrc_g = (gint32) ysrc;
    gint32 xdest_g = (gint32) xdest;
    gint32 ydest_g = (gint32) ydest;
    gint32 width_g = (gint32) width;
    gint32 height_g = (gint32) height;
    gdk_draw_image (drawable_g, gc_g, image_g, xsrc_g, ysrc_g, xdest_g, ydest_g, width_g, 
            height_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_points
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1points (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jobjectArray points) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    GdkPoint *points_g = (GdkPoint *)getPointerArrayFromHandles(env, points);
    gint32 numPoints_g = (gint32)(*env)->GetArrayLength(env, points);
    gdk_draw_points (drawable_g, gc_g, points_g, numPoints_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_segments
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1segments (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jobjectArray segments) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    GdkSegment *segments_g = (GdkSegment *)getPointerArrayFromHandles(env, segments);
    gint32 numSegs_g = (gint32)(*env)->GetArrayLength(env, segments);
    gdk_draw_segments (drawable_g, gc_g, segments_g, numSegs_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_lines
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1lines (JNIEnv *env, jclass cls, jobject 
    window, jobject gc, jobjectArray points) 
{
    GdkWindow *window_g = (GdkWindow *)window;
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    GdkPoint *points_g = (GdkPoint *)getPointerArrayFromHandles(env, points);
    gint32 numPoints_g = (gint32)(*env)->GetArrayLength(env, points);
    gdk_draw_lines (window_g, gc_g, points_g, numPoints_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_glyphs
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1glyphs (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jobject font, jint x, jint y, jobject glyphs) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    PangoFont *font_g = (PangoFont *)getPointerFromHandle(env, font);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoGlyphString *glyphs_g = (PangoGlyphString *)getPointerFromHandle(env, glyphs);
    gdk_draw_glyphs (drawable_g, gc_g, font_g, x_g, y_g, glyphs_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_line
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1line (JNIEnv *env, jclass cls, 
    jobject drawable, jobject gc, jint x, jint y, jobject line) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayoutLine *line_g = (PangoLayoutLine *)getPointerFromHandle(env, line);
    gdk_draw_layout_line (drawable_g, gc_g, x_g, y_g, line_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout (JNIEnv *env, jclass cls, jobject 
    drawable, jobject gc, jint x, jint y, jobject layout) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayout *layout_g = (PangoLayout *)getPointerFromHandle(env, layout);
    gdk_draw_layout (drawable_g, gc_g, x_g, y_g, layout_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_line_with_colors
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1line_1with_1colors (JNIEnv *env, 
    jclass cls, jobject drawable, jobject gc, jint x, jint y, jobject line, jobject foreground, jobject 
    background) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayoutLine *line_g = (PangoLayoutLine *)getPointerFromHandle(env, line);
    GdkColor *foreground_g = (GdkColor *)getPointerFromHandle(env, foreground);
    GdkColor *background_g = (GdkColor *)getPointerFromHandle(env, background);
    gdk_draw_layout_line_with_colors (drawable_g, gc_g, x_g, y_g, line_g, foreground_g, 
            background_g);
}

/*
 * Class:     org.gnu.gdk.Drawable
 * Method:    gdk_draw_layout_with_colors
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Drawable_gdk_1draw_1layout_1with_1colors (JNIEnv *env, 
    jclass cls, jobject drawable, jobject gc, jint x, jint y, jobject layout, jobject foreground, jobject 
    background) 
{
    GdkDrawable *drawable_g = (GdkDrawable *)getPointerFromHandle(env, drawable);
    GdkGC *gc_g = (GdkGC *)getPointerFromHandle(env, gc);
    gint32 x_g = (gint32) x;
    gint32 y_g = (gint32) y;
    PangoLayout *layout_g = (PangoLayout *)getPointerFromHandle(env, layout);
    GdkColor *foreground_g = (GdkColor *)getPointerFromHandle(env, foreground);
    GdkColor *background_g = (GdkColor *)getPointerFromHandle(env, background);
    gdk_draw_layout_with_colors (drawable_g, gc_g, x_g, y_g, layout_g, foreground_g, 
            background_g);
}

#ifdef __cplusplus
}

#endif
