/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventClient_get_type (GdkEventClient * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventClient
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventClient_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventClient *obj_g = (GdkEventClient *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventClient_get_type (obj_g));
}

GdkWindow * GdkEventClient_get_window (GdkEventClient * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventClient
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventClient_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventClient *obj_g = (GdkEventClient *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventClient_get_window (obj_g));
}

gint32 GdkEventClient_get_send_event (GdkEventClient * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventClient
 * Method:    getSendEvent
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventClient_getSendEvent (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventClient *obj_g = (GdkEventClient *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventClient_get_send_event (obj_g));
}

GdkAtom * GdkEventClient_get_message_type (GdkEventClient * cptr) 
{
    return (GdkAtom *)cptr->message_type;
}

/*
 * Class:     org.gnu.gdk.EventClient
 * Method:    getMessageType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventClient_getMessageType (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventClient *obj_g = (GdkEventClient *)getPointerFromHandle(env, obj);
    return (jint)GdkEventClient_get_message_type (obj_g);
}

gshort GdkEventClient_get_data_format (GdkEventClient * cptr) 
{
    return cptr->data_format;
}

/*
 * Class:     org.gnu.gdk.EventClient
 * Method:    getDataFormat
 */
JNIEXPORT jshort JNICALL Java_org_gnu_gdk_EventClient_getDataFormat (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventClient *obj_g = (GdkEventClient *)getPointerFromHandle(env, obj);
    return (jshort) (GdkEventClient_get_data_format (obj_g));
}

#ifdef __cplusplus
}

#endif
