/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Defines the interface for a <code>fire</code> method, which is
 * used by {@link Timer} to signal that its interval has elapsed.
 *
 * @see org.gnu.glib.Timer
 * @author Tom Ball
 */
public interface Fireable {
    /**
     * A generic signal callback, which returns <code>true</code> if
     * the subsystem that called it should continue firing (that is,
     * continue invoking this callback).
     * 
     * @return <code>true</code> if the caller should continue calling 
     * this method, or <code>false</code> if this should be the last
     * invocation.
     */
    boolean fire();
}
