// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/event.h>
#include <gdkmm/private/event_p.h>

#include <gdk/gdk.h>

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdkmm/screen.h>
#include <gdkmm/seat.h>
#include <gdkmm/window.h>

namespace Gdk
{

Event::operator bool() const noexcept
{
  return gobj() != nullptr;
}

bool Event::is_send_event() const
{
  return gobj()->any.send_event;
}

} //namespace Gdk

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::Event::Type>::value_type()
{
  return gdk_event_type_get_type();
}


namespace Glib
{

Gdk::Event wrap(GdkEvent* object, bool take_copy)
{
  return Gdk::Event(object, take_copy);
}

} // namespace Glib

namespace Gdk
{


// static
GType Event::get_type()
{
  return gdk_event_get_type();
}

Event::Event()
:
  gobject_(nullptr)
{
}

Event::Event(GdkEvent* gobject, bool make_a_copy)
:
  gobject_((make_a_copy && gobject) ? gdk_event_copy(gobject) : gobject)
{}


Event::Event(const Event& other)
:
  gobject_((other.gobject_) ? gdk_event_copy(other.gobject_) : nullptr)
{}

Event::Event(Event&& other) noexcept
:
  gobject_(other.gobject_)
{
  other.gobject_ = nullptr;
}

Event& Event::operator=(const Event& other)
{
  Event temp(other);
  swap(temp);
  return *this;
}

Event& Event::operator=(Event&& other) noexcept
{
  Event temp(std::move(other));
  swap(temp);
  return *this;
}

Event::~Event() noexcept
{
  if (gobject_)
    gdk_event_free(gobject_);
}

void Event::swap(Event& other) noexcept
{
  GdkEvent *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GdkEvent* Event::gobj_copy() const
{
  return gdk_event_copy(gobject_);
}

// The reinterpret_cast works because Event is a standard-layout class
// whose only data member is a GdkEvent pointer.
const Event& wrap_event(const GdkEvent*& event)
{
  return reinterpret_cast<const Event&>(event);
}

Event& wrap_event(GdkEvent*& event)
{
  return reinterpret_cast<Event&>(event);
}


Event::Type Event::get_event_type() const
{
  return static_cast<Event::Type>(gdk_event_get_event_type(const_cast<GdkEvent*>(gobj())));
}

Glib::RefPtr<Gdk::Window> Event::get_window()
{
  Glib::RefPtr<Gdk::Window> ref_ptr(Glib::wrap(gobj()->any.window));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gdk::Window> Event::get_window() const
{
  Glib::RefPtr<const Gdk::Window> ref_ptr(Glib::wrap(gobj()->any.window));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

void Event::set_show_events(bool show_events)
{
  gdk_set_show_events(static_cast<int>(show_events));
}

bool Event::get_show_events()
{
  return gdk_get_show_events();
}

Glib::RefPtr<Screen> Event::get_screen()
{
  auto retvalue = Glib::wrap(gdk_event_get_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Screen> Event::get_screen() const
{
  return const_cast<Event*>(this)->get_screen();
}

Glib::RefPtr<Seat> Event::get_seat()
{
  auto retvalue = Glib::wrap(gdk_event_get_seat(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Seat> Event::get_seat() const
{
  return const_cast<Event*>(this)->get_seat();
}

Event Event::get()
{
  return Glib::wrap(gdk_event_get());
}

Event Event::peek()
{
  return Glib::wrap(gdk_event_peek());
}

void Event::put()
{
  gdk_event_put(gobj());
}

bool Event::events_pending()
{
  return gdk_events_pending();
}


} // namespace Gdk


