/* == Start of generated table == */
/*
 * The following tables are generated by running:
 *
 *   ./gen-break-table.py SentenceBreakProperty.txt IndicSyllabicCategory.txt | indent
 *
 * on files with these headers:
 *
 * # SentenceBreakProperty-11.0.0.txt
 * # Date: 2018-03-15, 04:28:45 GMT
 * # © 2018 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see http://www.unicode.org/terms_of_use.html
 * #
 * # Unicode Character Database
 * #   For documentation, see http://www.unicode.org/reports/tr44/
 * 
 * # IndicSyllabicCategory-11.0.0.txt
 * # Date: 2018-05-21, 18:33:00 GMT [KW, RP]
 * # © 2018 Unicode®, Inc.
 * # Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
 * # For terms of use, see http://www.unicode.org/terms_of_use.html
 * #
 * # For documentation, see UAX #44: Unicode Character Database,
 * # at http://www.unicode.org/reports/tr44/
 * #
 * # This file defines the following property:
 * #
 * #    Indic_Syllabic_Category     enumerated property
 * #
 * # Scope: This property is aimed at two general problem
 * # areas involving the analysis and processing of Indic scripts:
 * #
 * #   1. Specification of syllabic structure.
 * #   2. Specification of segmentation rules.
 * #
 * # Both of these problem areas may benefit from having defined subtypes
 * # of Indic script characters which are relevant to how Indic
 * # syllables (or aksaras) are constructed. Note that rules for
 * # syllabic structure in Indic scripts may differ significantly
 * # from how phonological syllables are defined.
 * #
 * # Format:
 * #    Field 0  Unicode code point value or range of code point values
 * #    Field 1  Indic_Syllabic_Category property value
 * #
 * # Field 1 is followed by a comment field, starting with the number sign '#',
 * # which shows the General_Category property value, the Unicode character name
 * # or names, and, in lines with ranges of code points, the code point count in
 * # square brackets.
 * #
 * # The scripts assessed as Indic in the structural sense used for the
 * # Indic_Syllabic_Category are the following:
 * #
 * # Ahom, Balinese, Batak, Bengali, Bhaiksuki, Brahmi, Buginese, Buhid,
 * # Chakma, Cham, Devanagari, Dogra, Grantha, Gujarati, Gunjala Gondi,
 * # Gurmukhi, Hanunoo, Javanese, Kaithi, Kannada, Kayah Li, Kharoshthi,
 * # Khmer, Khojki, Khudawadi, Lao, Lepcha, Limbu, Mahajani, Makasar,
 * # Malayalam, Marchen, Masaram Gondi, Meetei Mayek, Modi, Multani,
 * # Myanmar, Newa, New Tai Lue, Oriya, Phags-pa, Rejang, Saurashtra,
 * # Sharada, Siddham, Sinhala, Soyombo, Sundanese, Syloti Nagri,
 * # Tagalog, Tagbanwa, Tai Le, Tai Tham, Tai Viet, Takri, Tamil,
 * # Telugu, Thai, Tibetan, Tirhuta, and Zanabazar Square.
 * #
 * # All characters for all other scripts not in that list
 * # take the default value for this property, unless they
 * # are individually listed in this data file.
 * #
 * 
 */

#ifndef PANGO_BREAK_TABLE_H
#define PANGO_BREAK_TABLE_H

#include <glib.h>


static inline gboolean
_pango_is_STerm (gunichar wc)
{
  if ((wc >= 0x0021 && wc <= 0x1803))
    {
      if (wc == 0x0021 ||
	  wc == 0x003F || wc == 0x0589 || (wc >= 0x061E && wc <= 0x061F))
	return TRUE;
      if (wc == 0x06D4 ||
	  (wc >= 0x0700 && wc <= 0x0702) || wc == 0x07F9 || wc == 0x0837)
	return TRUE;
      if (wc == 0x0839 ||
	  (wc >= 0x083D && wc <= 0x083E) ||
	  (wc >= 0x0964 && wc <= 0x0965) || (wc >= 0x104A && wc <= 0x104B))
	return TRUE;
      if ((wc >= 0x1362 && wc <= 0x1803))
	{
	  if (wc == 0x1362)
	    return TRUE;
	  if ((wc >= 0x1367 && wc <= 0x1368))
	    return TRUE;
	  if (wc == 0x166E)
	    return TRUE;
	  if ((wc >= 0x1735 && wc <= 0x1736) || wc == 0x1803)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x1809 && wc <= 0xA8CF))
    {
      if (wc == 0x1809 ||
	  (wc >= 0x1944 && wc <= 0x1945) ||
	  (wc >= 0x1AA8 && wc <= 0x1AAB) || (wc >= 0x1B5A && wc <= 0x1B5B))
	return TRUE;
      if ((wc >= 0x1B5E && wc <= 0x2049))
	{
	  if ((wc >= 0x1B5E && wc <= 0x1B5F))
	    return TRUE;
	  if ((wc >= 0x1C3B && wc <= 0x1C3C))
	    return TRUE;
	  if ((wc >= 0x1C7E && wc <= 0x1C7F))
	    return TRUE;
	  if ((wc >= 0x203C && wc <= 0x203D) ||
	      (wc >= 0x2047 && wc <= 0x2049))
	    return TRUE;
	  return FALSE;
	}
      if (wc == 0x2E2E || wc == 0x2E3C || wc == 0x3002 || wc == 0xA4FF)
	return TRUE;
      if ((wc >= 0xA60E && wc <= 0xA8CF))
	{
	  if ((wc >= 0xA60E && wc <= 0xA60F))
	    return TRUE;
	  if (wc == 0xA6F3)
	    return TRUE;
	  if (wc == 0xA6F7)
	    return TRUE;
	  if ((wc >= 0xA876 && wc <= 0xA877) ||
	      (wc >= 0xA8CE && wc <= 0xA8CF))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0xA92F && wc <= 0x111DF))
    {
      if (wc == 0xA92F ||
	  (wc >= 0xA9C8 && wc <= 0xA9C9) ||
	  (wc >= 0xAA5D && wc <= 0xAA5F) || (wc >= 0xAAF0 && wc <= 0xAAF1))
	return TRUE;
      if (wc == 0xABEB ||
	  (wc >= 0xFE56 && wc <= 0xFE57) || wc == 0xFF01 || wc == 0xFF1F)
	return TRUE;
      if (wc == 0xFF61 ||
	  (wc >= 0x10A56 && wc <= 0x10A57) ||
	  (wc >= 0x10F55 && wc <= 0x10F59) ||
	  (wc >= 0x11047 && wc <= 0x11048))
	return TRUE;
      if ((wc >= 0x110BE && wc <= 0x111DF))
	{
	  if ((wc >= 0x110BE && wc <= 0x110C1))
	    return TRUE;
	  if ((wc >= 0x11141 && wc <= 0x11143))
	    return TRUE;
	  if ((wc >= 0x111C5 && wc <= 0x111C6))
	    return TRUE;
	  if (wc == 0x111CD || (wc >= 0x111DE && wc <= 0x111DF))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x11238 && wc <= 0x1DA88))
    {
      if ((wc >= 0x11238 && wc <= 0x11239) ||
	  (wc >= 0x1123B && wc <= 0x1123C) ||
	  wc == 0x112A9 || (wc >= 0x1144B && wc <= 0x1144C))
	return TRUE;
      if ((wc >= 0x115C2 && wc <= 0x11A43))
	{
	  if ((wc >= 0x115C2 && wc <= 0x115C3))
	    return TRUE;
	  if ((wc >= 0x115C9 && wc <= 0x115D7))
	    return TRUE;
	  if ((wc >= 0x11641 && wc <= 0x11642))
	    return TRUE;
	  if ((wc >= 0x1173C && wc <= 0x1173E) ||
	      (wc >= 0x11A42 && wc <= 0x11A43))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11A9B && wc <= 0x11A9C) ||
	  (wc >= 0x11C41 && wc <= 0x11C42) ||
	  (wc >= 0x11EF7 && wc <= 0x11EF8) ||
	  (wc >= 0x16A6E && wc <= 0x16A6F))
	return TRUE;
      if ((wc >= 0x16AF5 && wc <= 0x1DA88))
	{
	  if (wc == 0x16AF5)
	    return TRUE;
	  if ((wc >= 0x16B37 && wc <= 0x16B38) || wc == 0x16B44)
	    return TRUE;
	  if (wc == 0x16E98)
	    return TRUE;
	  if (wc == 0x1BC9F || wc == 0x1DA88)
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Virama (gunichar wc)
{
  if ((wc >= 0x094D && wc <= 0x0BCD))
    {
      if (wc == 0x094D)
	return TRUE;
      if (wc == 0x09CD || wc == 0x0A4D)
	return TRUE;
      if (wc == 0x0ACD)
	return TRUE;
      if (wc == 0x0B4D || wc == 0x0BCD)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x0C4D && wc <= 0xA8C4))
    {
      if (wc == 0x0C4D)
	return TRUE;
      if (wc == 0x0CCD || wc == 0x0D4D)
	return TRUE;
      if (wc == 0x0DCA)
	return TRUE;
      if (wc == 0x1B44 || wc == 0xA8C4)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0xA9C0 && wc <= 0x1134D))
    {
      if (wc == 0xA9C0)
	return TRUE;
      if (wc == 0x11046 || wc == 0x110B9)
	return TRUE;
      if (wc == 0x111C0)
	return TRUE;
      if (wc == 0x11235 || wc == 0x1134D)
	return TRUE;
      return FALSE;
    }
  if ((wc >= 0x11442 && wc <= 0x11C3F))
    {
      if (wc == 0x11442)
	return TRUE;
      if (wc == 0x114C2 || wc == 0x115BF)
	return TRUE;
      if (wc == 0x1163F)
	return TRUE;
      if (wc == 0x116B6 || wc == 0x11839 || wc == 0x11C3F)
	return TRUE;
      return FALSE;
    }
  return FALSE;
}

static inline gboolean
_pango_is_Vowel_Dependent (gunichar wc)
{
  if ((wc >= 0x093A && wc <= 0x0C63))
    {
      if ((wc >= 0x093A && wc <= 0x09C8))
	{
	  if ((wc >= 0x093A && wc <= 0x093B))
	    return TRUE;
	  if ((wc >= 0x093E && wc <= 0x094C) ||
	      (wc >= 0x094E && wc <= 0x094F))
	    return TRUE;
	  if ((wc >= 0x0955 && wc <= 0x0957))
	    return TRUE;
	  if ((wc >= 0x0962 && wc <= 0x0963) ||
	      (wc >= 0x09BE && wc <= 0x09C4) ||
	      (wc >= 0x09C7 && wc <= 0x09C8))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x09CB && wc <= 0x0AC9))
	{
	  if ((wc >= 0x09CB && wc <= 0x09CC) || wc == 0x09D7)
	    return TRUE;
	  if ((wc >= 0x09E2 && wc <= 0x09E3) ||
	      (wc >= 0x0A3E && wc <= 0x0A42))
	    return TRUE;
	  if ((wc >= 0x0A47 && wc <= 0x0A48) ||
	      (wc >= 0x0A4B && wc <= 0x0A4C))
	    return TRUE;
	  if ((wc >= 0x0ABE && wc <= 0x0AC5) ||
	      (wc >= 0x0AC7 && wc <= 0x0AC9))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0ACB && wc <= 0x0B63))
	{
	  if ((wc >= 0x0ACB && wc <= 0x0ACC))
	    return TRUE;
	  if ((wc >= 0x0AE2 && wc <= 0x0AE3) ||
	      (wc >= 0x0B3E && wc <= 0x0B44))
	    return TRUE;
	  if ((wc >= 0x0B47 && wc <= 0x0B48))
	    return TRUE;
	  if ((wc >= 0x0B4B && wc <= 0x0B4C) ||
	      (wc >= 0x0B56 && wc <= 0x0B57) ||
	      (wc >= 0x0B62 && wc <= 0x0B63))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0BBE && wc <= 0x0C63))
	{
	  if ((wc >= 0x0BBE && wc <= 0x0BC2) ||
	      (wc >= 0x0BC6 && wc <= 0x0BC8))
	    return TRUE;
	  if ((wc >= 0x0BCA && wc <= 0x0BCC) || wc == 0x0BD7)
	    return TRUE;
	  if ((wc >= 0x0C3E && wc <= 0x0C44) ||
	      (wc >= 0x0C46 && wc <= 0x0C48))
	    return TRUE;
	  if ((wc >= 0x0C4A && wc <= 0x0C4C) ||
	      (wc >= 0x0C55 && wc <= 0x0C56) ||
	      (wc >= 0x0C62 && wc <= 0x0C63))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x0CBE && wc <= 0x1733))
    {
      if ((wc >= 0x0CBE && wc <= 0x0D48))
	{
	  if ((wc >= 0x0CBE && wc <= 0x0CC4))
	    return TRUE;
	  if ((wc >= 0x0CC6 && wc <= 0x0CC8) ||
	      (wc >= 0x0CCA && wc <= 0x0CCC))
	    return TRUE;
	  if ((wc >= 0x0CD5 && wc <= 0x0CD6))
	    return TRUE;
	  if ((wc >= 0x0CE2 && wc <= 0x0CE3) ||
	      (wc >= 0x0D3E && wc <= 0x0D44) ||
	      (wc >= 0x0D46 && wc <= 0x0D48))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0D4A && wc <= 0x0E39))
	{
	  if ((wc >= 0x0D4A && wc <= 0x0D4C) || wc == 0x0D57)
	    return TRUE;
	  if ((wc >= 0x0D62 && wc <= 0x0D63) ||
	      (wc >= 0x0DCF && wc <= 0x0DD4))
	    return TRUE;
	  if (wc == 0x0DD6 || (wc >= 0x0DD8 && wc <= 0x0DDF))
	    return TRUE;
	  if ((wc >= 0x0DF2 && wc <= 0x0DF3) ||
	      (wc >= 0x0E30 && wc <= 0x0E39))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x0E40 && wc <= 0x0F81))
	{
	  if ((wc >= 0x0E40 && wc <= 0x0E45))
	    return TRUE;
	  if (wc == 0x0E47 || (wc >= 0x0EB0 && wc <= 0x0EB9))
	    return TRUE;
	  if (wc == 0x0EBB)
	    return TRUE;
	  if ((wc >= 0x0EC0 && wc <= 0x0EC4) ||
	      (wc >= 0x0F71 && wc <= 0x0F7D) ||
	      (wc >= 0x0F80 && wc <= 0x0F81))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x102B && wc <= 0x1733))
	{
	  if ((wc >= 0x102B && wc <= 0x1035) ||
	      (wc >= 0x1056 && wc <= 0x1059))
	    return TRUE;
	  if (wc == 0x1062 || (wc >= 0x1067 && wc <= 0x1068))
	    return TRUE;
	  if ((wc >= 0x1071 && wc <= 0x1074) ||
	      (wc >= 0x1083 && wc <= 0x1086))
	    return TRUE;
	  if ((wc >= 0x109C && wc <= 0x109D) ||
	      (wc >= 0x1712 && wc <= 0x1713) ||
	      (wc >= 0x1732 && wc <= 0x1733))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x1752 && wc <= 0x111BF))
    {
      if ((wc >= 0x1752 && wc <= 0x19C0))
	{
	  if ((wc >= 0x1752 && wc <= 0x1753))
	    return TRUE;
	  if ((wc >= 0x1772 && wc <= 0x1773) ||
	      (wc >= 0x17B6 && wc <= 0x17C5))
	    return TRUE;
	  if (wc == 0x17C8)
	    return TRUE;
	  if ((wc >= 0x1920 && wc <= 0x1928) ||
	      wc == 0x193A || (wc >= 0x19B0 && wc <= 0x19C0))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x1A17 && wc <= 0xA8C3))
	{
	  if ((wc >= 0x1A17 && wc <= 0x1A1B) ||
	      (wc >= 0x1A61 && wc <= 0x1A73))
	    return TRUE;
	  if ((wc >= 0x1B35 && wc <= 0x1B43) ||
	      (wc >= 0x1BA4 && wc <= 0x1BA9))
	    return TRUE;
	  if ((wc >= 0x1BE7 && wc <= 0x1BEF) ||
	      (wc >= 0x1C26 && wc <= 0x1C2C))
	    return TRUE;
	  if ((wc >= 0xA823 && wc <= 0xA827) ||
	      (wc >= 0xA8B5 && wc <= 0xA8C3))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xA8FF && wc <= 0xAAEF))
	{
	  if (wc == 0xA8FF)
	    return TRUE;
	  if ((wc >= 0xA947 && wc <= 0xA94E) ||
	      (wc >= 0xA9B4 && wc <= 0xA9BC))
	    return TRUE;
	  if (wc == 0xA9E5)
	    return TRUE;
	  if ((wc >= 0xAA29 && wc <= 0xAA32) ||
	      (wc >= 0xAAB0 && wc <= 0xAABE) ||
	      (wc >= 0xAAEB && wc <= 0xAAEF))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0xABE3 && wc <= 0x111BF))
	{
	  if ((wc >= 0xABE3 && wc <= 0xABEA) ||
	      (wc >= 0x10A01 && wc <= 0x10A03))
	    return TRUE;
	  if ((wc >= 0x10A05 && wc <= 0x10A06) ||
	      (wc >= 0x10A0C && wc <= 0x10A0D))
	    return TRUE;
	  if ((wc >= 0x11038 && wc <= 0x11045) ||
	      (wc >= 0x110B0 && wc <= 0x110B8))
	    return TRUE;
	  if ((wc >= 0x11127 && wc <= 0x11132) ||
	      (wc >= 0x11145 && wc <= 0x11146) ||
	      (wc >= 0x111B3 && wc <= 0x111BF))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  if ((wc >= 0x111CB && wc <= 0x11EF6))
    {
      if ((wc >= 0x111CB && wc <= 0x11363))
	{
	  if ((wc >= 0x111CB && wc <= 0x111CC) ||
	      (wc >= 0x1122C && wc <= 0x11233))
	    return TRUE;
	  if ((wc >= 0x112E0 && wc <= 0x112E8) ||
	      (wc >= 0x1133E && wc <= 0x11344))
	    return TRUE;
	  if ((wc >= 0x11347 && wc <= 0x11348) ||
	      (wc >= 0x1134B && wc <= 0x1134C))
	    return TRUE;
	  if (wc == 0x11357 || (wc >= 0x11362 && wc <= 0x11363))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11435 && wc <= 0x116B5))
	{
	  if ((wc >= 0x11435 && wc <= 0x11441) ||
	      (wc >= 0x114B0 && wc <= 0x114BE))
	    return TRUE;
	  if ((wc >= 0x115AF && wc <= 0x115B5) ||
	      (wc >= 0x115B8 && wc <= 0x115BB))
	    return TRUE;
	  if ((wc >= 0x115DC && wc <= 0x115DD) ||
	      (wc >= 0x11630 && wc <= 0x1163C))
	    return TRUE;
	  if (wc == 0x11640 || (wc >= 0x116AD && wc <= 0x116B5))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11720 && wc <= 0x11D36))
	{
	  if ((wc >= 0x11720 && wc <= 0x1172A) ||
	      (wc >= 0x1182C && wc <= 0x11836))
	    return TRUE;
	  if ((wc >= 0x11A01 && wc <= 0x11A0A) ||
	      (wc >= 0x11A51 && wc <= 0x11A5B))
	    return TRUE;
	  if ((wc >= 0x11C2F && wc <= 0x11C36) ||
	      (wc >= 0x11C38 && wc <= 0x11C3B))
	    return TRUE;
	  if ((wc >= 0x11CB0 && wc <= 0x11CB4) ||
	      (wc >= 0x11D31 && wc <= 0x11D36))
	    return TRUE;
	  return FALSE;
	}
      if ((wc >= 0x11D3A && wc <= 0x11EF6))
	{
	  if (wc == 0x11D3A || (wc >= 0x11D3C && wc <= 0x11D3D))
	    return TRUE;
	  if (wc == 0x11D3F || wc == 0x11D43)
	    return TRUE;
	  if ((wc >= 0x11D8A && wc <= 0x11D8E) ||
	      (wc >= 0x11D90 && wc <= 0x11D91))
	    return TRUE;
	  if ((wc >= 0x11D93 && wc <= 0x11D94) ||
	      (wc >= 0x11EF3 && wc <= 0x11EF6))
	    return TRUE;
	  return FALSE;
	}
      return FALSE;
    }
  return FALSE;
}

#endif /* PANGO_BREAK_TABLE_H */

/* == End of generated table == */
