/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaSet* property_fields;
	ValaDataType* _base_type;
	gboolean* boolean_type;
	gboolean* integer_type;
	gboolean* floating_type;
	gboolean* decimal_floating_type;
	gboolean* simple_type;
	gint* _rank;
	gint* _width;
	gboolean* _signed;
	gboolean* _is_immutable;
	ValaCreationMethod* _default_construction_method;
};

static gint ValaStruct_private_offset;
static gpointer vala_struct_parent_class = NULL;

static void vala_struct_real_add_constant (ValaSymbol* base,
                                    ValaConstant* c);
static void vala_struct_real_add_field (ValaSymbol* base,
                                 ValaField* f);
static void vala_struct_real_add_method (ValaSymbol* base,
                                  ValaMethod* m);
static void vala_struct_set_default_construction_method (ValaStruct* self,
                                                  ValaCreationMethod* value);
static void vala_struct_real_add_property (ValaSymbol* base,
                                    ValaProperty* prop);
static void vala_struct_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean* _bool_dup (gboolean* self);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                const gchar* name);
static void vala_struct_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                         ValaTypeSymbol* t);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self,
                                              ValaDataType* type);
static gboolean vala_struct_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gint* _int_dup (gint* self);
static void vala_struct_finalize (ValaCodeNode * obj);

static inline gpointer
vala_struct_get_instance_private (ValaStruct* self)
{
	return G_STRUCT_MEMBER_P (self, ValaStruct_private_offset);
}

/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct*
vala_struct_construct (GType object_type,
                       const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaStruct* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaStruct*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaStruct*
vala_struct_new (const gchar* name,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_struct_add_type_parameter (ValaStruct* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}

/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_struct_get_type_parameters (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
static void
vala_struct_real_add_constant (ValaSymbol* base,
                               ValaConstant* c)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}

/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
static void
vala_struct_real_add_field (ValaSymbol* base,
                            ValaField* f)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (f != NULL);
	vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp0_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp0_, f);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) f);
}

/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList*
vala_struct_get_fields (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_struct_get_constants (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_struct_real_add_method (ValaSymbol* base,
                             ValaMethod* m)
{
	ValaStruct * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaList* _tmp53_;
	ValaScope* _tmp54_;
	ValaScope* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	self = (ValaStruct*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		_tmp3_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_parameter_new ("this", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		vala_method_set_this_parameter (m, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp4_);
		_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_method_get_this_parameter (m);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_get_this_parameter (m);
		_tmp14_ = _tmp13_;
		vala_scope_add (_tmp8_, _tmp12_, (ValaSymbol*) _tmp14_);
	}
	_tmp16_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp17_ = _tmp16_;
	if (!VALA_IS_VOID_TYPE (_tmp17_)) {
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = vala_method_get_postconditions (m);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_ > 0;
		_vala_iterable_unref0 (_tmp19_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		_tmp22_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_data_type_copy (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_local_variable_new (_tmp25_, "result", NULL, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		vala_local_variable_set_is_result (_tmp31_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp34_;
		gboolean _tmp35_ = FALSE;
		ValaCreationMethod* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == NULL) {
			vala_struct_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp34_;
		_tmp36_ = cm;
		_tmp37_ = vala_creation_method_get_class_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (_tmp38_ != NULL) {
			ValaCreationMethod* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp39_ = cm;
			_tmp40_ = vala_creation_method_get_class_name (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp43_ = _tmp42_;
			_tmp35_ = g_strcmp0 (_tmp41_, _tmp43_) != 0;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			ValaSourceReference* _tmp44_;
			ValaSourceReference* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			ValaCreationMethod* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = cm;
			_tmp49_ = vala_creation_method_get_class_name (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp47_, _tmp50_);
			_tmp52_ = _tmp51_;
			vala_report_error (_tmp45_, _tmp52_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp53_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp53_, m);
	_tmp54_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp57_ = _tmp56_;
	vala_scope_add (_tmp55_, _tmp57_, (ValaSymbol*) m);
}

/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_struct_get_methods (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this struct.
 *
 * @param prop a property
 */
static void
vala_struct_real_add_property (ValaSymbol* base,
                               ValaProperty* prop)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaParameter* _tmp7_;
	ValaParameter* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaParameter* _tmp15_;
	ValaParameter* _tmp16_;
	ValaField* _tmp17_;
	ValaField* _tmp18_;
	self = (ValaStruct*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	vala_collection_add ((ValaCollection*) _tmp0_, prop);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) prop);
	_tmp5_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaSymbol*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_parameter_new ("this", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	vala_property_set_this_parameter (prop, _tmp8_);
	_vala_code_node_unref0 (_tmp8_);
	_vala_code_node_unref0 (_tmp6_);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_property_get_this_parameter (prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_property_get_this_parameter (prop);
	_tmp16_ = _tmp15_;
	vala_scope_add (_tmp10_, _tmp14_, (ValaSymbol*) _tmp16_);
	_tmp17_ = vala_property_get_field (prop);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaField* _tmp19_;
		ValaField* _tmp20_;
		ValaSet* _tmp21_;
		ValaField* _tmp22_;
		ValaField* _tmp23_;
		_tmp19_ = vala_property_get_field (prop);
		_tmp20_ = _tmp19_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp20_);
		_tmp21_ = self->priv->property_fields;
		_tmp22_ = vala_property_get_field (prop);
		_tmp23_ = _tmp22_;
		vala_collection_add ((ValaCollection*) _tmp21_, _tmp23_);
	}
}

/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
ValaList*
vala_struct_get_properties (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_struct_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_struct (visitor, self);
}

static void
vala_struct_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_struct_get_base_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _p_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _p_index = 0;
		_tmp4_ = self->priv->type_parameters;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_p_list = _tmp5_;
		_tmp6_ = _p_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaTypeParameter* _tmp11_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = vala_list_get (_tmp9_, _p_index);
			p = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _f_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _f_index = 0;
		_tmp12_ = self->priv->fields;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_f_list = _tmp13_;
		_tmp14_ = _f_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_f_size = _tmp16_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaField* _tmp19_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp17_ = _f_list;
			_tmp18_ = vala_list_get (_tmp17_, _f_index);
			f = (ValaField*) _tmp18_;
			_tmp19_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _c_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _c_index = 0;
		_tmp20_ = self->priv->constants;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_c_list = _tmp21_;
		_tmp22_ = _c_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_c_size = _tmp24_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaConstant* _tmp27_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp25_ = _c_list;
			_tmp26_ = vala_list_get (_tmp25_, _c_index);
			c = (ValaConstant*) _tmp26_;
			_tmp27_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		gint _m_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _m_index = 0;
		_tmp28_ = self->priv->methods;
		_tmp29_ = _vala_iterable_ref0 (_tmp28_);
		_m_list = _tmp29_;
		_tmp30_ = _m_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_m_size = _tmp32_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaMethod* _tmp35_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp33_ = _m_list;
			_tmp34_ = vala_list_get (_tmp33_, _m_index);
			m = (ValaMethod*) _tmp34_;
			_tmp35_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _prop_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _prop_index = 0;
		_tmp36_ = self->priv->properties;
		_tmp37_ = _vala_iterable_ref0 (_tmp36_);
		_prop_list = _tmp37_;
		_tmp38_ = _prop_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_prop_size = _tmp40_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaProperty* _tmp43_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp41_ = _prop_list;
			_tmp42_ = vala_list_get (_tmp41_, _prop_index);
			prop = (ValaProperty*) _tmp42_;
			_tmp43_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp43_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
}

/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_struct_is_boolean_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_boolean_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->boolean_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		gboolean _tmp8_;
		gboolean* _tmp9_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
		_tmp8_ = _tmp7_ != NULL;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (self->priv->boolean_type);
		self->priv->boolean_type = _tmp9_;
	}
	_tmp10_ = self->priv->boolean_type;
	result = *_tmp10_;
	_vala_code_node_unref0 (st);
	return result;
}

/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean
vala_struct_is_integer_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_integer_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->integer_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		gboolean _tmp8_;
		gboolean* _tmp9_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
		_tmp8_ = _tmp7_ != NULL;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (self->priv->integer_type);
		self->priv->integer_type = _tmp9_;
	}
	_tmp10_ = self->priv->integer_type;
	result = *_tmp10_;
	_vala_code_node_unref0 (st);
	return result;
}

/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean
vala_struct_is_floating_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp10_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_floating_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->floating_type;
	if (_tmp6_ == NULL) {
		ValaAttribute* _tmp7_;
		gboolean _tmp8_;
		gboolean* _tmp9_;
		_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
		_tmp8_ = _tmp7_ != NULL;
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (self->priv->floating_type);
		self->priv->floating_type = _tmp9_;
	}
	_tmp10_ = self->priv->floating_type;
	result = *_tmp10_;
	_vala_code_node_unref0 (st);
	return result;
}

gboolean
vala_struct_is_decimal_floating_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp9_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_decimal_floating_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->decimal_floating_type;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_;
		gboolean* _tmp8_;
		_tmp7_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "FloatingType", "decimal", FALSE);
		_tmp8_ = __bool_dup0 (&_tmp7_);
		_g_free0 (self->priv->decimal_floating_type);
		self->priv->decimal_floating_type = _tmp8_;
	}
	_tmp9_ = self->priv->decimal_floating_type;
	result = *_tmp9_;
	_vala_code_node_unref0 (st);
	return result;
}

static gint
vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                           const gchar* name)
{
	ValaStruct * self;
	gint i = 0;
	gint result = 0;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = _p_list;
			_tmp6_ = vala_list_get (_tmp5_, _p_index);
			p = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = p;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
			_tmp9_ = _tmp8_;
			if (g_strcmp0 (_tmp9_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				_vala_iterable_unref0 (_p_list);
				return result;
			}
			_tmp10_ = i;
			i = _tmp10_ + 1;
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	result = -1;
	return result;
}

/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean
vala_struct_is_simple_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp6_;
	gboolean* _tmp15_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp3_ = vala_struct_is_simple_type (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp6_ = self->priv->simple_type;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		ValaAttribute* _tmp10_;
		gboolean* _tmp14_;
		_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType");
		if (_tmp10_ != NULL) {
			_tmp9_ = TRUE;
		} else {
			ValaAttribute* _tmp11_;
			_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
			_tmp9_ = _tmp11_ != NULL;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			ValaAttribute* _tmp12_;
			_tmp12_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
			_tmp8_ = _tmp12_ != NULL;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			ValaAttribute* _tmp13_;
			_tmp13_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
			_tmp7_ = _tmp13_ != NULL;
		}
		_tmp14_ = __bool_dup0 (&_tmp7_);
		_g_free0 (self->priv->simple_type);
		self->priv->simple_type = _tmp14_;
	}
	_tmp15_ = self->priv->simple_type;
	result = *_tmp15_;
	_vala_code_node_unref0 (st);
	return result;
}

/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void
vala_struct_set_simple_type (ValaStruct* self,
                             gboolean simple_type)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&simple_type);
	_g_free0 (self->priv->simple_type);
	self->priv->simple_type = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SimpleType", simple_type, NULL);
}

static void
vala_struct_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_struct_set_base_type (self, new_type);
	}
}

static gboolean
vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                ValaTypeSymbol* t)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean result = FALSE;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp3_ = vala_struct_get_base_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_get_data_type (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_tmp7_ = vala_struct_get_base_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp2_ = vala_typesymbol_is_subtype_of (_tmp10_, t);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_struct_is_disposable (ValaStruct* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "destroy_function", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _f_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _f_index = 0;
		_tmp3_ = self->priv->fields;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_f_list = _tmp4_;
		_tmp5_ = _f_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_f_size = _tmp7_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaField* _tmp12_;
			ValaMemberBinding _tmp13_;
			ValaMemberBinding _tmp14_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp8_ = _f_list;
			_tmp9_ = vala_list_get (_tmp8_, _f_index);
			f = (ValaField*) _tmp9_;
			_tmp12_ = f;
			_tmp13_ = vala_field_get_binding (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp15_;
				_tmp15_ = f;
				_tmp11_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp15_, "CCode", "delegate_target", TRUE);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaField* _tmp16_;
				ValaDataType* _tmp17_;
				ValaDataType* _tmp18_;
				_tmp16_ = f;
				_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp10_ = vala_data_type_is_disposable (_tmp18_);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	result = FALSE;
	return result;
}

static gboolean
vala_struct_is_recursive_value_type (ValaStruct* self,
                                     ValaDataType* type)
{
	ValaStructValueType* struct_type = NULL;
	ValaStructValueType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaStructValueType* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_STRUCT_VALUE_TYPE (type) ? ((ValaStructValueType*) type) : NULL);
	struct_type = _tmp0_;
	_tmp2_ = struct_type;
	if (_tmp2_ != NULL) {
		ValaStructValueType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = struct_type;
		_tmp4_ = vala_data_type_get_nullable ((ValaDataType*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaStruct* st = NULL;
		ValaStructValueType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaStruct* _tmp10_;
		_tmp6_ = struct_type;
		_tmp7_ = vala_value_type_get_type_symbol ((ValaValueType*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct));
		st = _tmp9_;
		_tmp10_ = st;
		if (_tmp10_ == self) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (struct_type);
			return result;
		}
		{
			ValaList* _f_list = NULL;
			ValaStruct* _tmp11_;
			ValaList* _tmp12_;
			ValaList* _tmp13_;
			gint _f_size = 0;
			ValaList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _f_index = 0;
			_tmp11_ = st;
			_tmp12_ = _tmp11_->priv->fields;
			_tmp13_ = _vala_iterable_ref0 (_tmp12_);
			_f_list = _tmp13_;
			_tmp14_ = _f_list;
			_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_f_size = _tmp16_;
			_f_index = -1;
			while (TRUE) {
				ValaField* f = NULL;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				gboolean _tmp19_ = FALSE;
				ValaField* _tmp20_;
				ValaMemberBinding _tmp21_;
				ValaMemberBinding _tmp22_;
				_f_index = _f_index + 1;
				if (!(_f_index < _f_size)) {
					break;
				}
				_tmp17_ = _f_list;
				_tmp18_ = vala_list_get (_tmp17_, _f_index);
				f = (ValaField*) _tmp18_;
				_tmp20_ = f;
				_tmp21_ = vala_field_get_binding (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == VALA_MEMBER_BINDING_INSTANCE) {
					ValaField* _tmp23_;
					ValaDataType* _tmp24_;
					ValaDataType* _tmp25_;
					_tmp23_ = f;
					_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp19_ = vala_struct_is_recursive_value_type (self, _tmp25_);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					_vala_iterable_unref0 (_f_list);
					_vala_code_node_unref0 (st);
					_vala_code_node_unref0 (struct_type);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		_vala_code_node_unref0 (st);
	}
	result = FALSE;
	_vala_code_node_unref0 (struct_type);
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_struct_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaStruct * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	gboolean _tmp162_ = FALSE;
	gboolean _tmp163_;
	gboolean _tmp164_;
	ValaSemanticAnalyzer* _tmp198_;
	ValaSemanticAnalyzer* _tmp199_;
	ValaSourceFile* _tmp200_;
	ValaSemanticAnalyzer* _tmp201_;
	ValaSemanticAnalyzer* _tmp202_;
	ValaSymbol* _tmp203_;
	gboolean _tmp204_;
	gboolean _tmp205_;
	gboolean result = FALSE;
	self = (ValaStruct*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_struct_get_base_type (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		_tmp26_ = vala_struct_get_base_type (self);
		_tmp27_ = _tmp26_;
		vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
		_tmp28_ = vala_struct_get_base_type (self);
		_tmp29_ = _tmp28_;
		if (!VALA_IS_VALUE_TYPE (_tmp29_)) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_struct_get_base_type (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup_printf ("The base type `%s' of struct `%s' is not a struct", _tmp35_, _tmp37_);
			_tmp39_ = _tmp38_;
			vala_report_error (_tmp31_, _tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _p_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _p_index = 0;
		_tmp40_ = self->priv->type_parameters;
		_tmp41_ = _vala_iterable_ref0 (_tmp40_);
		_p_list = _tmp41_;
		_tmp42_ = _p_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_p_size = _tmp44_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaTypeParameter* _tmp47_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp45_ = _p_list;
			_tmp46_ = vala_list_get (_tmp45_, _p_index);
			p = (ValaTypeParameter*) _tmp46_;
			_tmp47_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp47_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp48_;
		ValaList* _tmp49_;
		gint _f_size = 0;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _f_index = 0;
		_tmp48_ = self->priv->fields;
		_tmp49_ = _vala_iterable_ref0 (_tmp48_);
		_f_list = _tmp49_;
		_tmp50_ = _f_list;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_f_size = _tmp52_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaField* _tmp55_;
			gboolean _tmp56_ = FALSE;
			ValaField* _tmp57_;
			ValaMemberBinding _tmp58_;
			ValaMemberBinding _tmp59_;
			gboolean _tmp66_ = FALSE;
			ValaField* _tmp67_;
			ValaMemberBinding _tmp68_;
			ValaMemberBinding _tmp69_;
			gboolean _tmp76_ = FALSE;
			ValaField* _tmp77_;
			ValaMemberBinding _tmp78_;
			ValaMemberBinding _tmp79_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp53_ = _f_list;
			_tmp54_ = vala_list_get (_tmp53_, _f_index);
			f = (ValaField*) _tmp54_;
			_tmp55_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp55_, context);
			_tmp57_ = f;
			_tmp58_ = vala_field_get_binding (_tmp57_);
			_tmp59_ = _tmp58_;
			if (_tmp59_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp60_;
				ValaDataType* _tmp61_;
				ValaDataType* _tmp62_;
				_tmp60_ = f;
				_tmp61_ = vala_variable_get_variable_type ((ValaVariable*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp56_ = vala_struct_is_recursive_value_type (self, _tmp62_);
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaField* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp63_ = f;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				vala_report_error (_tmp65_, "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp67_ = f;
			_tmp68_ = vala_field_get_binding (_tmp67_);
			_tmp69_ = _tmp68_;
			if (_tmp69_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = f;
				_tmp71_ = vala_variable_get_initializer ((ValaVariable*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp66_ = _tmp72_ != NULL;
			} else {
				_tmp66_ = FALSE;
			}
			if (_tmp66_) {
				ValaField* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = f;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "Instance field initializers not supported");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp77_ = f;
			_tmp78_ = vala_field_get_binding (_tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_ == VALA_MEMBER_BINDING_STATIC) {
				ValaField* _tmp80_;
				ValaExpression* _tmp81_;
				ValaExpression* _tmp82_;
				_tmp80_ = f;
				_tmp81_ = vala_variable_get_initializer ((ValaVariable*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp76_ = _tmp82_ != NULL;
			} else {
				_tmp76_ = FALSE;
			}
			if (_tmp76_) {
				gboolean _tmp83_ = FALSE;
				gboolean _tmp84_ = FALSE;
				gboolean _tmp85_ = FALSE;
				ValaSet* _tmp86_;
				ValaField* _tmp87_;
				_tmp86_ = self->priv->property_fields;
				_tmp87_ = f;
				if (!vala_collection_contains ((ValaCollection*) _tmp86_, _tmp87_)) {
					ValaField* _tmp88_;
					ValaExpression* _tmp89_;
					ValaExpression* _tmp90_;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					_tmp88_ = f;
					_tmp89_ = vala_variable_get_initializer ((ValaVariable*) _tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = vala_expression_get_value_type (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp85_ = !VALA_IS_NULL_TYPE (_tmp92_);
				} else {
					_tmp85_ = FALSE;
				}
				if (_tmp85_) {
					ValaField* _tmp93_;
					ValaDataType* _tmp94_;
					ValaDataType* _tmp95_;
					_tmp93_ = f;
					_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp84_ = vala_data_type_is_disposable (_tmp95_);
				} else {
					_tmp84_ = FALSE;
				}
				if (_tmp84_) {
					ValaField* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					gboolean _tmp99_;
					gboolean _tmp100_;
					_tmp96_ = f;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_data_type_get_value_owned (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp83_ = _tmp100_;
				} else {
					_tmp83_ = FALSE;
				}
				if (_tmp83_) {
					ValaField* _tmp101_;
					ValaExpression* _tmp102_;
					ValaExpression* _tmp103_;
					ValaSourceReference* _tmp104_;
					ValaSourceReference* _tmp105_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp101_ = f;
					_tmp102_ = vala_variable_get_initializer ((ValaVariable*) _tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp103_);
					_tmp105_ = _tmp104_;
					vala_report_error (_tmp105_, "Owned static struct fields can only be initialized in a function or me" \
"thod");
				}
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp106_;
		ValaList* _tmp107_;
		gint _c_size = 0;
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _c_index = 0;
		_tmp106_ = self->priv->constants;
		_tmp107_ = _vala_iterable_ref0 (_tmp106_);
		_c_list = _tmp107_;
		_tmp108_ = _c_list;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_c_size = _tmp110_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp111_;
			gpointer _tmp112_;
			ValaConstant* _tmp113_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp111_ = _c_list;
			_tmp112_ = vala_list_get (_tmp111_, _c_index);
			c = (ValaConstant*) _tmp112_;
			_tmp113_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp113_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		gint _m_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _m_index = 0;
		_tmp114_ = self->priv->methods;
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_m_list = _tmp115_;
		_tmp116_ = _m_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_m_size = _tmp118_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp119_;
			gpointer _tmp120_;
			ValaMethod* _tmp121_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp119_ = _m_list;
			_tmp120_ = vala_list_get (_tmp119_, _m_index);
			m = (ValaMethod*) _tmp120_;
			_tmp121_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp121_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp122_;
		ValaList* _tmp123_;
		gint _prop_size = 0;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gint _prop_index = 0;
		_tmp122_ = self->priv->properties;
		_tmp123_ = _vala_iterable_ref0 (_tmp122_);
		_prop_list = _tmp123_;
		_tmp124_ = _prop_list;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		_prop_size = _tmp126_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp127_;
			gpointer _tmp128_;
			ValaProperty* _tmp129_;
			ValaProperty* _tmp130_;
			ValaMemberBinding _tmp131_;
			ValaMemberBinding _tmp132_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp127_ = _prop_list;
			_tmp128_ = vala_list_get (_tmp127_, _prop_index);
			prop = (ValaProperty*) _tmp128_;
			_tmp129_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp129_, context);
			_tmp130_ = prop;
			_tmp131_ = vala_property_get_binding (_tmp130_);
			_tmp132_ = _tmp131_;
			if (_tmp132_ == VALA_MEMBER_BINDING_STATIC) {
				ValaField* field = NULL;
				ValaProperty* _tmp133_;
				ValaField* _tmp134_;
				ValaField* _tmp135_;
				gboolean _tmp136_ = FALSE;
				gboolean _tmp137_ = FALSE;
				gboolean _tmp138_ = FALSE;
				gboolean _tmp139_ = FALSE;
				ValaField* _tmp140_;
				_tmp133_ = prop;
				_tmp134_ = vala_property_get_field (_tmp133_);
				_tmp135_ = _tmp134_;
				field = _tmp135_;
				_tmp140_ = field;
				if (_tmp140_ != NULL) {
					ValaField* _tmp141_;
					ValaExpression* _tmp142_;
					ValaExpression* _tmp143_;
					_tmp141_ = field;
					_tmp142_ = vala_variable_get_initializer ((ValaVariable*) _tmp141_);
					_tmp143_ = _tmp142_;
					_tmp139_ = _tmp143_ != NULL;
				} else {
					_tmp139_ = FALSE;
				}
				if (_tmp139_) {
					ValaField* _tmp144_;
					ValaExpression* _tmp145_;
					ValaExpression* _tmp146_;
					ValaDataType* _tmp147_;
					ValaDataType* _tmp148_;
					_tmp144_ = field;
					_tmp145_ = vala_variable_get_initializer ((ValaVariable*) _tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_expression_get_value_type (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp138_ = !VALA_IS_NULL_TYPE (_tmp148_);
				} else {
					_tmp138_ = FALSE;
				}
				if (_tmp138_) {
					ValaField* _tmp149_;
					ValaDataType* _tmp150_;
					ValaDataType* _tmp151_;
					_tmp149_ = field;
					_tmp150_ = vala_variable_get_variable_type ((ValaVariable*) _tmp149_);
					_tmp151_ = _tmp150_;
					_tmp137_ = vala_data_type_is_disposable (_tmp151_);
				} else {
					_tmp137_ = FALSE;
				}
				if (_tmp137_) {
					ValaField* _tmp152_;
					ValaDataType* _tmp153_;
					ValaDataType* _tmp154_;
					gboolean _tmp155_;
					gboolean _tmp156_;
					_tmp152_ = field;
					_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp152_);
					_tmp154_ = _tmp153_;
					_tmp155_ = vala_data_type_get_value_owned (_tmp154_);
					_tmp156_ = _tmp155_;
					_tmp136_ = _tmp156_;
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					ValaField* _tmp157_;
					ValaExpression* _tmp158_;
					ValaExpression* _tmp159_;
					ValaSourceReference* _tmp160_;
					ValaSourceReference* _tmp161_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp157_ = field;
					_tmp158_ = vala_variable_get_initializer ((ValaVariable*) _tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp159_);
					_tmp161_ = _tmp160_;
					vala_report_error (_tmp161_, "Owned static struct properties can only be initialized in a function o" \
"r method");
				}
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp163_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp164_ = _tmp163_;
	if (!_tmp164_) {
		gboolean _tmp165_;
		gboolean _tmp166_;
		_tmp165_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp166_ = _tmp165_;
		_tmp162_ = !_tmp166_;
	} else {
		_tmp162_ = FALSE;
	}
	if (_tmp162_) {
		gboolean has_instance_field = FALSE;
		gboolean _tmp177_ = FALSE;
		gboolean _tmp178_ = FALSE;
		gboolean _tmp179_ = FALSE;
		gboolean _tmp180_ = FALSE;
		ValaDataType* _tmp181_;
		ValaDataType* _tmp182_;
		has_instance_field = FALSE;
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp167_;
			ValaList* _tmp168_;
			gint _f_size = 0;
			ValaList* _tmp169_;
			gint _tmp170_;
			gint _tmp171_;
			gint _f_index = 0;
			_tmp167_ = self->priv->fields;
			_tmp168_ = _vala_iterable_ref0 (_tmp167_);
			_f_list = _tmp168_;
			_tmp169_ = _f_list;
			_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
			_tmp171_ = _tmp170_;
			_f_size = _tmp171_;
			_f_index = -1;
			while (TRUE) {
				ValaField* f = NULL;
				ValaList* _tmp172_;
				gpointer _tmp173_;
				ValaField* _tmp174_;
				ValaMemberBinding _tmp175_;
				ValaMemberBinding _tmp176_;
				_f_index = _f_index + 1;
				if (!(_f_index < _f_size)) {
					break;
				}
				_tmp172_ = _f_list;
				_tmp173_ = vala_list_get (_tmp172_, _f_index);
				f = (ValaField*) _tmp173_;
				_tmp174_ = f;
				_tmp175_ = vala_field_get_binding (_tmp174_);
				_tmp176_ = _tmp175_;
				if (_tmp176_ == VALA_MEMBER_BINDING_INSTANCE) {
					has_instance_field = TRUE;
					_vala_code_node_unref0 (f);
					break;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		_tmp181_ = vala_struct_get_base_type (self);
		_tmp182_ = _tmp181_;
		if (_tmp182_ == NULL) {
			_tmp180_ = !has_instance_field;
		} else {
			_tmp180_ = FALSE;
		}
		if (_tmp180_) {
			_tmp179_ = !vala_struct_is_boolean_type (self);
		} else {
			_tmp179_ = FALSE;
		}
		if (_tmp179_) {
			_tmp178_ = !vala_struct_is_integer_type (self);
		} else {
			_tmp178_ = FALSE;
		}
		if (_tmp178_) {
			_tmp177_ = !vala_struct_is_floating_type (self);
		} else {
			_tmp177_ = FALSE;
		}
		if (_tmp177_) {
			ValaSourceReference* _tmp183_;
			ValaSourceReference* _tmp184_;
			gchar* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp184_ = _tmp183_;
			_tmp185_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp186_ = _tmp185_;
			_tmp187_ = g_strdup_printf ("struct `%s' cannot be empty", _tmp186_);
			_tmp188_ = _tmp187_;
			vala_report_error (_tmp184_, _tmp188_);
			_g_free0 (_tmp188_);
			_g_free0 (_tmp186_);
		} else {
			gboolean _tmp189_ = FALSE;
			ValaDataType* _tmp190_;
			ValaDataType* _tmp191_;
			_tmp190_ = vala_struct_get_base_type (self);
			_tmp191_ = _tmp190_;
			if (_tmp191_ != NULL) {
				_tmp189_ = has_instance_field;
			} else {
				_tmp189_ = FALSE;
			}
			if (_tmp189_) {
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp195_ = _tmp194_;
				_tmp196_ = g_strdup_printf ("derived struct `%s' may not have instance fields", _tmp195_);
				_tmp197_ = _tmp196_;
				vala_report_error (_tmp193_, _tmp197_);
				_g_free0 (_tmp197_);
				_g_free0 (_tmp195_);
			}
		}
	}
	_tmp198_ = vala_code_context_get_analyzer (context);
	_tmp199_ = _tmp198_;
	_tmp200_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp199_, _tmp200_);
	_tmp201_ = vala_code_context_get_analyzer (context);
	_tmp202_ = _tmp201_;
	_tmp203_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp202_, _tmp203_);
	_tmp204_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp205_ = _tmp204_;
	result = !_tmp205_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaDataType*
vala_struct_get_base_type (ValaStruct* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}

void
vala_struct_set_base_type (ValaStruct* self,
                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) value, (ValaCodeNode*) self);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_type);
	self->priv->_base_type = _tmp0_;
}

ValaStruct*
vala_struct_get_base_struct (ValaStruct* self)
{
	ValaStruct* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = vala_data_type_get_data_type (_tmp1_);
		_tmp3_ = _tmp2_;
		result = VALA_IS_STRUCT (_tmp3_) ? ((ValaStruct*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}

ValaCreationMethod*
vala_struct_get_default_construction_method (ValaStruct* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_struct_set_default_construction_method (ValaStruct* self,
                                             ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

gboolean
vala_struct_get_is_immutable (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp3_;
	}
	_tmp4_ = self->priv->_is_immutable;
	result = *_tmp4_;
	return result;
}

void
vala_struct_set_is_immutable (ValaStruct* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

gint
vala_struct_get_width (ValaStruct* self)
{
	gint result;
	gint* _tmp0_;
	gint* _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	if (_tmp0_ == NULL) {
		if (vala_struct_is_integer_type (self)) {
			gint _tmp1_;
			gint* _tmp2_;
			_tmp1_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", 32);
			_tmp2_ = __int_dup0 (&_tmp1_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp2_;
		} else {
			gint _tmp3_;
			gint* _tmp4_;
			_tmp3_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", 32);
			_tmp4_ = __int_dup0 (&_tmp3_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp4_;
		}
	}
	_tmp5_ = self->priv->_width;
	result = *_tmp5_;
	return result;
}

void
vala_struct_set_width (ValaStruct* self,
                       gint value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&value);
	_g_free0 (self->priv->_width);
	self->priv->_width = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", value, NULL);
	} else {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", value, NULL);
	}
}

gboolean
vala_struct_get_signed (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signed;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_signed);
		self->priv->_signed = _tmp2_;
	}
	_tmp3_ = self->priv->_signed;
	result = *_tmp3_;
	return result;
}

void
vala_struct_set_signed (ValaStruct* self,
                        gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_signed);
	self->priv->_signed = _tmp0_;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", value, NULL);
}

gint
vala_struct_get_rank (ValaStruct* self)
{
	gint result;
	gint* _tmp0_;
	gint* _tmp16_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		if (vala_struct_is_integer_type (self)) {
			_tmp1_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "IntegerType", "rank");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint _tmp2_;
			gint* _tmp3_;
			_tmp2_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", 0);
			_tmp3_ = __int_dup0 (&_tmp2_);
			_g_free0 (self->priv->_rank);
			self->priv->_rank = _tmp3_;
		} else {
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "FloatingType", "rank")) {
				gint _tmp4_;
				gint* _tmp5_;
				_tmp4_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", 0);
				_tmp5_ = __int_dup0 (&_tmp4_);
				_g_free0 (self->priv->_rank);
				self->priv->_rank = _tmp5_;
			} else {
				ValaStruct* st = NULL;
				ValaStruct* _tmp6_;
				ValaStruct* _tmp7_;
				ValaStruct* _tmp8_;
				ValaStruct* _tmp9_;
				_tmp6_ = vala_struct_get_base_struct (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _vala_code_node_ref0 (_tmp7_);
				st = _tmp8_;
				_tmp9_ = st;
				if (_tmp9_ != NULL) {
					ValaStruct* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint* _tmp13_;
					_tmp10_ = st;
					_tmp11_ = vala_struct_get_rank (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = __int_dup0 (&_tmp12_);
					_g_free0 (self->priv->_rank);
					self->priv->_rank = _tmp13_;
				} else {
					ValaSourceReference* _tmp14_;
					ValaSourceReference* _tmp15_;
					_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp15_ = _tmp14_;
					vala_report_error (_tmp15_, "internal error: struct has no rank");
					result = 0;
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	_tmp16_ = self->priv->_rank;
	result = *_tmp16_;
	return result;
}

void
vala_struct_set_rank (ValaStruct* self,
                      gint value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&value);
	_g_free0 (self->priv->_rank);
	self->priv->_rank = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		gint* _tmp1_;
		_tmp1_ = self->priv->_rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", *_tmp1_, NULL);
	} else {
		gint* _tmp2_;
		_tmp2_ = self->priv->_rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", *_tmp2_, NULL);
	}
}

static void
vala_struct_class_init (ValaStructClass * klass,
                        gpointer klass_data)
{
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_struct_finalize;
	g_type_class_adjust_private_offset (klass, &ValaStruct_private_offset);
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_struct_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_struct_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_struct_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_struct_real_add_property;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept_children;
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_struct_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_struct_real_replace_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_struct_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_struct_real_check;
}

static void
vala_struct_instance_init (ValaStruct * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashSet* _tmp12_;
	self->priv = vala_struct_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_hash;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_set_new (VALA_TYPE_FIELD, NULL, NULL, _tmp10_, _tmp11_);
	self->priv->property_fields = (ValaSet*) _tmp12_;
	self->priv->_base_type = NULL;
}

static void
vala_struct_finalize (ValaCodeNode * obj)
{
	ValaStruct * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_STRUCT, ValaStruct);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->property_fields);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->boolean_type);
	_g_free0 (self->priv->integer_type);
	_g_free0 (self->priv->floating_type);
	_g_free0 (self->priv->decimal_floating_type);
	_g_free0 (self->priv->simple_type);
	_g_free0 (self->priv->_rank);
	_g_free0 (self->priv->_width);
	_g_free0 (self->priv->_signed);
	_g_free0 (self->priv->_is_immutable);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}

/**
 * Represents a struct declaration in the source code.
 */
GType
vala_struct_get_type (void)
{
	static volatile gsize vala_struct_type_id__volatile = 0;
	if (g_once_init_enter (&vala_struct_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		GType vala_struct_type_id;
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
		ValaStruct_private_offset = g_type_add_instance_private (vala_struct_type_id, sizeof (ValaStructPrivate));
		g_once_init_leave (&vala_struct_type_id__volatile, vala_struct_type_id);
	}
	return vala_struct_type_id__volatile;
}

