/* rygel-ruih-servicemanager.c generated by valac 0.48.5, the Vala compiler
 * generated from rygel-ruih-servicemanager.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Neha Shanbhag <N.Shanbhag@cablelabs.com>
 * Contact: http://www.cablelabs.com/
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <rygel-core.h>

#define RYGEL_TYPE_RUIH_SERVICE_MANAGER (rygel_ruih_service_manager_get_type ())
#define RYGEL_RUIH_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManager))
#define RYGEL_RUIH_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManagerClass))
#define RYGEL_IS_RUIH_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER))
#define RYGEL_IS_RUIH_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RUIH_SERVICE_MANAGER))
#define RYGEL_RUIH_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManagerClass))

typedef struct _RygelRuihServiceManager RygelRuihServiceManager;
typedef struct _RygelRuihServiceManagerClass RygelRuihServiceManagerClass;
typedef struct _RygelRuihServiceManagerPrivate RygelRuihServiceManagerPrivate;

#define TYPE_UI_LISTING (ui_listing_get_type ())
#define UI_LISTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UI_LISTING, UIListing))
#define UI_LISTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UI_LISTING, UIListingClass))
#define IS_UI_LISTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UI_LISTING))
#define IS_UI_LISTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UI_LISTING))
#define UI_LISTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UI_LISTING, UIListingClass))

typedef struct _UIListing UIListing;
typedef struct _UIListingClass UIListingClass;

#define TYPE_UI_ELEM (ui_elem_get_type ())
#define UI_ELEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UI_ELEM, UIElem))
#define UI_ELEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UI_ELEM, UIElemClass))
#define IS_UI_ELEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UI_ELEM))
#define IS_UI_ELEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UI_ELEM))
#define UI_ELEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UI_ELEM, UIElemClass))

typedef struct _UIElem UIElem;
typedef struct _UIElemClass UIElemClass;
enum  {
	RYGEL_RUIH_SERVICE_MANAGER_0_PROPERTY,
	RYGEL_RUIH_SERVICE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* rygel_ruih_service_manager_properties[RYGEL_RUIH_SERVICE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_xml_utils_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_xml_utils_iterator_unref (var), NULL)))
#define _ui_listing_unref0(var) ((var == NULL) ? NULL : (var = (ui_listing_unref (var), NULL)))

#define TYPE_FILTER_ENTRY (filter_entry_get_type ())
#define FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_ENTRY, FilterEntry))
#define FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_ENTRY, FilterEntryClass))
#define IS_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_ENTRY))
#define IS_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_ENTRY))
#define FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_ENTRY, FilterEntryClass))

typedef struct _FilterEntry FilterEntry;
typedef struct _FilterEntryClass FilterEntryClass;
#define _filter_entry_unref0(var) ((var == NULL) ? NULL : (var = (filter_entry_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_WILD_CARD_FILTER_ENTRY (wild_card_filter_entry_get_type ())
#define WILD_CARD_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntry))
#define WILD_CARD_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntryClass))
#define IS_WILD_CARD_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WILD_CARD_FILTER_ENTRY))
#define IS_WILD_CARD_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WILD_CARD_FILTER_ENTRY))
#define WILD_CARD_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WILD_CARD_FILTER_ENTRY, WildCardFilterEntryClass))

typedef struct _WildCardFilterEntry WildCardFilterEntry;
typedef struct _WildCardFilterEntryClass WildCardFilterEntryClass;
enum  {
	RYGEL_RUIH_SERVICE_MANAGER_UPDATED_SIGNAL,
	RYGEL_RUIH_SERVICE_MANAGER_NUM_SIGNALS
};
static guint rygel_ruih_service_manager_signals[RYGEL_RUIH_SERVICE_MANAGER_NUM_SIGNALS] = {0};

struct _RygelRuihServiceManager {
	GObject parent_instance;
	RygelRuihServiceManagerPrivate * priv;
	GCancellable* cancellable;
};

struct _RygelRuihServiceManagerClass {
	GObjectClass parent_class;
};

struct _RygelRuihServiceManagerPrivate {
	GeeArrayList* ui_list;
	gchar* ui_listing_full_path;
	GFileMonitor* ui_file_monitor;
};

struct _Block1Data {
	int _ref_count_;
	RygelRuihServiceManager* self;
	GFile* ui_file;
};

typedef enum  {
	RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED = 701,
	RYGEL_RUIH_SERVICE_ERROR_INVALID_FILTER = 702
} RygelRuihServiceError;
#define RYGEL_RUIH_SERVICE_ERROR rygel_ruih_service_error_quark ()

static gint RygelRuihServiceManager_private_offset;
static gpointer rygel_ruih_service_manager_parent_class = NULL;
static gchar* rygel_ruih_service_manager_PRE_RESULT;
static gchar* rygel_ruih_service_manager_PRE_RESULT = NULL;
static gchar* rygel_ruih_service_manager_POST_RESULT;
static gchar* rygel_ruih_service_manager_POST_RESULT = NULL;
static RygelRuihServiceManager* rygel_ruih_service_manager_instance;
static RygelRuihServiceManager* rygel_ruih_service_manager_instance = NULL;

GType rygel_ruih_service_manager_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelRuihServiceManager, g_object_unref)
gpointer ui_listing_ref (gpointer instance);
void ui_listing_unref (gpointer instance);
GParamSpec* param_spec_ui_listing (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_ui_listing (GValue* value,
                           gpointer v_object);
void value_take_ui_listing (GValue* value,
                            gpointer v_object);
gpointer value_get_ui_listing (const GValue* value);
GType ui_listing_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UIListing, ui_listing_unref)
GType ui_elem_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UIElem, ui_listing_unref)
#define RYGEL_RUIH_SERVICE_MANAGER_DEVICEPROFILE "deviceprofile"
#define RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL "protocol"
#define RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO "protocolInfo"
#define RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME "shortName"
#define RYGEL_RUIH_SERVICE_MANAGER_UI "ui"
#define RYGEL_RUIH_SERVICE_MANAGER_UILIST "uilist"
#define RYGEL_RUIH_SERVICE_MANAGER_UI_LISTING_FILE_NAME "UIList.xml"
RygelRuihServiceManager* rygel_ruih_service_manager_get_default (void);
RygelRuihServiceManager* rygel_ruih_service_manager_new (void);
RygelRuihServiceManager* rygel_ruih_service_manager_construct (GType object_type);
static void rygel_ruih_service_manager_real_constructed (GObject* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GQuark rygel_ruih_service_error_quark (void);
void rygel_ruih_service_manager_set_ui_list (RygelRuihServiceManager* self,
                                             const gchar* ui_list_file_path,
                                             GError** error);
static void ___lambda4_ (Block1Data* _data1_,
                  GFile* src,
                  GFile* dest,
                  GFileMonitorEvent event);
static void ____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
gboolean rygel_ruih_service_manager_ui_list_available (RygelRuihServiceManager* self);
UIElem* ui_elem_new (xmlNode* node,
                     GError** error);
UIElem* ui_elem_construct (GType object_type,
                           xmlNode* node,
                           GError** error);
gchar* rygel_ruih_service_manager_get_compatible_uis (RygelRuihServiceManager* self,
                                                      const gchar* device_profile,
                                                      const gchar* filter,
                                                      GError** error);
gpointer filter_entry_ref (gpointer instance);
void filter_entry_unref (gpointer instance);
GParamSpec* param_spec_filter_entry (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_filter_entry (GValue* value,
                             gpointer v_object);
void value_take_filter_entry (GValue* value,
                              gpointer v_object);
gpointer value_get_filter_entry (const GValue* value);
GType filter_entry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilterEntry, filter_entry_unref)
FilterEntry* filter_entry_new (const gchar* name,
                               const gchar* value);
FilterEntry* filter_entry_construct (GType object_type,
                                     const gchar* name,
                                     const gchar* value);
static void rygel_ruih_service_manager_convert_device_profile_to_filter (RygelRuihServiceManager* self,
                                                                  xmlNode* node,
                                                                  GeeList* filter_entries);
static void rygel_ruih_service_manager_convert_filter_string (RygelRuihServiceManager* self,
                                                       xmlNode* device_profile_node,
                                                       const gchar* filter,
                                                       GeeList* filter_entries,
                                                       GError** error);
gchar* ui_listing_to_ui_listing (UIListing* self,
                                 GeeArrayList* filters);
WildCardFilterEntry* wild_card_filter_entry_new (void);
WildCardFilterEntry* wild_card_filter_entry_construct (GType object_type);
GType wild_card_filter_entry_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WildCardFilterEntry, filter_entry_unref)
static void rygel_ruih_service_manager_finalize (GObject * obj);
static GType rygel_ruih_service_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_ruih_service_manager_get_instance_private (RygelRuihServiceManager* self)
{
	return G_STRUCT_MEMBER_P (self, RygelRuihServiceManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelRuihServiceManager*
rygel_ruih_service_manager_get_default (void)
{
	RygelRuihServiceManager* _tmp0_;
	RygelRuihServiceManager* _tmp2_;
	RygelRuihServiceManager* _tmp3_;
	RygelRuihServiceManager* result = NULL;
	_tmp0_ = rygel_ruih_service_manager_instance;
	if (_tmp0_ == NULL) {
		RygelRuihServiceManager* _tmp1_;
		_tmp1_ = rygel_ruih_service_manager_new ();
		_g_object_unref0 (rygel_ruih_service_manager_instance);
		rygel_ruih_service_manager_instance = _tmp1_;
	}
	_tmp2_ = rygel_ruih_service_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelRuihServiceManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->ui_file);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GFile* src,
             GFile* dest,
             GFileMonitorEvent event)
{
	RygelRuihServiceManager* self;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (src != NULL);
	_tmp0_ = _data1_->ui_file;
	if (g_file_equal (_tmp0_, src)) {
		{
			const gchar* _tmp1_;
			_tmp1_ = self->priv->ui_listing_full_path;
			rygel_ruih_service_manager_set_ui_list (self, _tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
					goto __catch0_rygel_ruih_service_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_rygel_ruih_service_error:
		{
			GError* e = NULL;
			const gchar* _tmp2_;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = self->priv->ui_listing_full_path;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning (_ ("Failed to set UIList for file %s — %s"), _tmp2_, _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_signal_emit (self, rygel_ruih_service_manager_signals[RYGEL_RUIH_SERVICE_MANAGER_UPDATED_SIGNAL], 0);
	}
}

static void
____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda4_ (self, file, other_file, event_type);
}

static void
rygel_ruih_service_manager_real_constructed (GObject* base)
{
	RygelRuihServiceManager * self;
	GeeArrayList* _tmp0_;
	const gchar* config_dir = NULL;
	const gchar* _tmp1_;
	GCancellable* _tmp2_;
	gchar* ui_listing_directory = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (RygelRuihServiceManager*) base;
	G_OBJECT_CLASS (rygel_ruih_service_manager_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (TYPE_UI_ELEM, (GBoxedCopyFunc) ui_listing_ref, (GDestroyNotify) ui_listing_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->ui_list);
	self->priv->ui_list = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	config_dir = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp2_;
	_tmp3_ = g_build_filename (config_dir, "Rygel", NULL);
	ui_listing_directory = _tmp3_;
	_tmp4_ = g_build_filename (ui_listing_directory, RYGEL_RUIH_SERVICE_MANAGER_UI_LISTING_FILE_NAME, NULL);
	_g_free0 (self->priv->ui_listing_full_path);
	self->priv->ui_listing_full_path = _tmp4_;
	g_mkdir_with_parents (ui_listing_directory, 0755);
	{
		Block1Data* _data1_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* config_dir_file = NULL;
		GFile* _tmp8_;
		GFileMonitor* _tmp9_ = NULL;
		GFile* _tmp10_;
		GCancellable* _tmp11_;
		GFileMonitor* _tmp12_;
		GFileMonitor* _tmp13_;
		GFileMonitor* _tmp14_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp5_ = self->priv->ui_listing_full_path;
		rygel_ruih_service_manager_set_ui_list (self, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				goto __catch0_rygel_ruih_service_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_free0 (ui_listing_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = self->priv->ui_listing_full_path;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_data1_->ui_file = _tmp7_;
		_tmp8_ = g_file_new_for_path (ui_listing_directory);
		config_dir_file = _tmp8_;
		_tmp10_ = config_dir_file;
		_tmp11_ = self->cancellable;
		_tmp12_ = g_file_monitor_directory (_tmp10_, G_FILE_MONITOR_NONE, _tmp11_, &_inner_error0_);
		_tmp9_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config_dir_file);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				goto __catch0_rygel_ruih_service_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_free0 (ui_listing_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp13_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (self->priv->ui_file_monitor);
		self->priv->ui_file_monitor = _tmp13_;
		_tmp14_ = self->priv->ui_file_monitor;
		g_signal_connect_data (_tmp14_, "changed", (GCallback) ____lambda4__g_file_monitor_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (config_dir_file);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	goto __finally0;
	__catch0_rygel_ruih_service_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = self->priv->ui_listing_full_path;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning (_ ("Failed to set initial UI list for file %s — %s"), _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = self->priv->ui_listing_full_path;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning (_ ("Failed to monitor the file %s — %s"), _tmp18_, _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (ui_listing_directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (ui_listing_directory);
}

gboolean
rygel_ruih_service_manager_ui_list_available (RygelRuihServiceManager* self)
{
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ui_list;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}

void
rygel_ruih_service_manager_set_ui_list (RygelRuihServiceManager* self,
                                        const gchar* ui_list_file_path,
                                        GError** error)
{
	GeeArrayList* _tmp0_;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp1_;
	xmlDoc* _tmp2_;
	xmlNode* ui_list_node = NULL;
	xmlDoc* _tmp9_;
	xmlNode* _tmp10_;
	gboolean _tmp11_ = FALSE;
	xmlNode* _tmp12_;
	xmlDoc* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_list_file_path != NULL);
	_tmp0_ = self->priv->ui_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	if (ui_list_file_path == NULL) {
		return;
	}
	_tmp1_ = xmlParseFile (ui_list_file_path);
	doc = _tmp1_;
	_tmp2_ = doc;
	if (_tmp2_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp3_ = g_strdup (_ ("Unable to parse UI list file %s"));
		msg = _tmp3_;
		_tmp4_ = msg;
		_tmp5_ = g_strdup_printf (_tmp4_, ui_list_file_path);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			return;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (msg);
	}
	_tmp9_ = doc;
	_tmp10_ = xmlDocGetRootElement (_tmp9_);
	ui_list_node = _tmp10_;
	_tmp12_ = ui_list_node;
	if (_tmp12_ != NULL) {
		xmlNode* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = ui_list_node;
		_tmp14_ = _tmp13_->name;
		_tmp11_ = g_strcmp0 (_tmp14_, RYGEL_RUIH_SERVICE_MANAGER_UILIST) == 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		{
			RygelXMLUtilsIterator* _node_it = NULL;
			xmlNode* _tmp15_;
			RygelXMLUtilsChildIterator* _tmp16_;
			RygelXMLUtilsChildIterator* _tmp17_;
			RygelXMLUtilsIterator* _tmp18_;
			RygelXMLUtilsIterator* _tmp19_;
			_tmp15_ = ui_list_node;
			_tmp16_ = rygel_xml_utils_child_iterator_new (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = rygel_xml_utils_iterator_iterator ((RygelXMLUtilsIterator*) _tmp17_);
			_tmp19_ = _tmp18_;
			_rygel_xml_utils_iterator_unref0 (_tmp17_);
			_node_it = _tmp19_;
			while (TRUE) {
				RygelXMLUtilsIterator* _tmp20_;
				xmlNode* node = NULL;
				RygelXMLUtilsIterator* _tmp21_;
				xmlNode* _tmp22_;
				xmlNode* _tmp23_;
				const gchar* _tmp24_;
				_tmp20_ = _node_it;
				if (!rygel_xml_utils_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _node_it;
				_tmp22_ = rygel_xml_utils_iterator_get (_tmp21_);
				node = _tmp22_;
				_tmp23_ = node;
				_tmp24_ = _tmp23_->name;
				if (g_strcmp0 (_tmp24_, RYGEL_RUIH_SERVICE_MANAGER_UI) == 0) {
					UIElem* _tmp25_ = NULL;
					xmlNode* _tmp26_;
					UIElem* _tmp27_;
					GeeArrayList* _tmp28_;
					_tmp26_ = node;
					_tmp27_ = ui_elem_new (_tmp26_, &_inner_error0_);
					_tmp25_ = _tmp27_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_rygel_xml_utils_iterator_unref0 (_node_it);
							return;
						} else {
							_rygel_xml_utils_iterator_unref0 (_node_it);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp28_ = self->priv->ui_list;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp25_);
					_ui_listing_unref0 (_tmp25_);
				}
			}
			_rygel_xml_utils_iterator_unref0 (_node_it);
		}
	}
	_tmp29_ = doc;
	xmlFreeDoc (_tmp29_);
}

gchar*
rygel_ruih_service_manager_get_compatible_uis (RygelRuihServiceManager* self,
                                               const gchar* device_profile,
                                               const gchar* filter,
                                               GError** error)
{
	GeeArrayList* filter_entries = NULL;
	GeeArrayList* _tmp0_;
	xmlNode* device_profile_node = NULL;
	xmlDoc* doc = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp16_ = FALSE;
	xmlNode* _tmp17_;
	xmlNode* _tmp21_;
	GeeArrayList* _tmp22_;
	xmlNode* _tmp23_;
	GeeArrayList* _tmp24_;
	xmlDoc* _tmp25_;
	GString* _result_ = NULL;
	const gchar* _tmp26_;
	GString* _tmp27_;
	gboolean _tmp28_ = FALSE;
	GeeArrayList* _tmp29_;
	GString* _tmp52_;
	const gchar* _tmp53_;
	GString* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_profile != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_FILTER_ENTRY, (GBoxedCopyFunc) filter_entry_ref, (GDestroyNotify) filter_entry_unref, NULL, NULL, NULL);
	filter_entries = _tmp0_;
	device_profile_node = NULL;
	doc = NULL;
	if (device_profile != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = strlen (device_profile);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_;
		gint _tmp5_;
		xmlDoc* _tmp6_;
		xmlDoc* _tmp7_;
		xmlDoc* _tmp14_;
		xmlNode* _tmp15_;
		_tmp4_ = strlen (device_profile);
		_tmp5_ = _tmp4_;
		_tmp6_ = xmlParseMemory (device_profile, _tmp5_);
		doc = _tmp6_;
		_tmp7_ = doc;
		if (_tmp7_ == NULL) {
			gchar* msg = NULL;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			GError* _tmp13_;
			_tmp8_ = g_strdup (_ ("Unable to parse device profile data: %s"));
			msg = _tmp8_;
			_tmp9_ = msg;
			_tmp10_ = g_strdup_printf (_tmp9_, device_profile);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			_inner_error0_ = _tmp13_;
			if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				_g_object_unref0 (filter_entries);
				return NULL;
			} else {
				_g_free0 (msg);
				_g_object_unref0 (filter_entries);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (msg);
		}
		_tmp14_ = doc;
		_tmp15_ = xmlDocGetRootElement (_tmp14_);
		device_profile_node = _tmp15_;
	}
	_tmp17_ = device_profile_node;
	if (_tmp17_ == NULL) {
		_tmp16_ = g_strcmp0 (filter, "") == 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GeeArrayList* _tmp18_;
		FilterEntry* _tmp19_;
		FilterEntry* _tmp20_;
		_tmp18_ = filter_entries;
		_tmp19_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME, "*HTML5*");
		_tmp20_ = _tmp19_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp20_);
		_filter_entry_unref0 (_tmp20_);
	}
	_tmp21_ = device_profile_node;
	_tmp22_ = filter_entries;
	rygel_ruih_service_manager_convert_device_profile_to_filter (self, _tmp21_, (GeeList*) _tmp22_);
	_tmp23_ = device_profile_node;
	_tmp24_ = filter_entries;
	rygel_ruih_service_manager_convert_filter_string (self, _tmp23_, filter, (GeeList*) _tmp24_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (filter_entries);
			return NULL;
		} else {
			_g_object_unref0 (filter_entries);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp25_ = doc;
	xmlFreeDoc (_tmp25_);
	_tmp26_ = rygel_ruih_service_manager_PRE_RESULT;
	_tmp27_ = g_string_new (_tmp26_);
	_result_ = _tmp27_;
	_tmp29_ = self->priv->ui_list;
	if (_tmp29_ != NULL) {
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp30_ = self->priv->ui_list;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp28_ = _tmp32_ > 0;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		GString* result_content = NULL;
		GString* _tmp33_;
		GString* _tmp46_;
		const gchar* _tmp47_;
		GString* _tmp49_;
		GString* _tmp50_;
		const gchar* _tmp51_;
		_tmp33_ = g_string_new ("");
		result_content = _tmp33_;
		{
			GeeArrayList* _ui_list = NULL;
			GeeArrayList* _tmp34_;
			GeeArrayList* _tmp35_;
			gint _ui_size = 0;
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _ui_index = 0;
			_tmp34_ = self->priv->ui_list;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_ui_list = _tmp35_;
			_tmp36_ = _ui_list;
			_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_ui_size = _tmp38_;
			_ui_index = -1;
			while (TRUE) {
				UIElem* ui = NULL;
				GeeArrayList* _tmp39_;
				gpointer _tmp40_;
				GString* _tmp41_;
				UIElem* _tmp42_;
				GeeArrayList* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_ui_index = _ui_index + 1;
				if (!(_ui_index < _ui_size)) {
					break;
				}
				_tmp39_ = _ui_list;
				_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _ui_index);
				ui = (UIElem*) _tmp40_;
				_tmp41_ = result_content;
				_tmp42_ = ui;
				_tmp43_ = filter_entries;
				_tmp44_ = ui_listing_to_ui_listing ((UIListing*) _tmp42_, _tmp43_);
				_tmp45_ = _tmp44_;
				g_string_append (_tmp41_, _tmp45_);
				_g_free0 (_tmp45_);
				_ui_listing_unref0 (ui);
			}
			_g_object_unref0 (_ui_list);
		}
		_tmp46_ = result_content;
		_tmp47_ = _tmp46_->str;
		if (g_strcmp0 (_tmp47_, "") == 0) {
			gchar* _tmp48_;
			_tmp48_ = g_strdup ("");
			result = _tmp48_;
			_g_string_free0 (result_content);
			_g_string_free0 (_result_);
			_g_object_unref0 (filter_entries);
			return result;
		}
		_tmp49_ = _result_;
		_tmp50_ = result_content;
		_tmp51_ = _tmp50_->str;
		g_string_append (_tmp49_, _tmp51_);
		_g_string_free0 (result_content);
	}
	_tmp52_ = _result_;
	_tmp53_ = rygel_ruih_service_manager_POST_RESULT;
	g_string_append (_tmp52_, _tmp53_);
	_tmp54_ = _result_;
	_tmp55_ = _tmp54_->str;
	_tmp56_ = g_strdup (_tmp55_);
	result = _tmp56_;
	_g_string_free0 (_result_);
	_g_object_unref0 (filter_entries);
	return result;
}

static void
rygel_ruih_service_manager_convert_device_profile_to_filter (RygelRuihServiceManager* self,
                                                             xmlNode* node,
                                                             GeeList* filter_entries)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter_entries != NULL);
	if (node == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = node->name;
		_tmp0_ = g_strcmp0 (_tmp1_, RYGEL_RUIH_SERVICE_MANAGER_DEVICEPROFILE) != 0;
	}
	if (_tmp0_) {
		return;
	}
	{
		RygelXMLUtilsIterator* _child_node_it = NULL;
		RygelXMLUtilsChildIterator* _tmp2_;
		RygelXMLUtilsChildIterator* _tmp3_;
		RygelXMLUtilsIterator* _tmp4_;
		RygelXMLUtilsIterator* _tmp5_;
		_tmp2_ = rygel_xml_utils_child_iterator_new (node);
		_tmp3_ = _tmp2_;
		_tmp4_ = rygel_xml_utils_iterator_iterator ((RygelXMLUtilsIterator*) _tmp3_);
		_tmp5_ = _tmp4_;
		_rygel_xml_utils_iterator_unref0 (_tmp3_);
		_child_node_it = _tmp5_;
		while (TRUE) {
			RygelXMLUtilsIterator* _tmp6_;
			xmlNode* child_node = NULL;
			RygelXMLUtilsIterator* _tmp7_;
			xmlNode* _tmp8_;
			xmlNode* _tmp9_;
			xmlElementType _tmp10_;
			xmlNode* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp30_ = FALSE;
			xmlNode* _tmp31_;
			const gchar* _tmp32_;
			_tmp6_ = _child_node_it;
			if (!rygel_xml_utils_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _child_node_it;
			_tmp8_ = rygel_xml_utils_iterator_get (_tmp7_);
			child_node = _tmp8_;
			_tmp9_ = child_node;
			_tmp10_ = _tmp9_->type;
			if (_tmp10_ == XML_TEXT_NODE) {
				continue;
			}
			_tmp11_ = child_node;
			_tmp12_ = _tmp11_->name;
			if (g_strcmp0 (_tmp12_, RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL) == 0) {
				{
					xmlAttr* prop = NULL;
					xmlNode* _tmp13_;
					xmlAttr* _tmp14_;
					_tmp13_ = child_node;
					_tmp14_ = _tmp13_->properties;
					prop = _tmp14_;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							xmlAttr* _tmp18_;
							gboolean _tmp19_ = FALSE;
							xmlAttr* _tmp20_;
							const gchar* _tmp21_;
							if (!_tmp15_) {
								xmlAttr* _tmp16_;
								xmlAttr* _tmp17_;
								_tmp16_ = prop;
								_tmp17_ = _tmp16_->next;
								prop = _tmp17_;
							}
							_tmp15_ = FALSE;
							_tmp18_ = prop;
							if (!(_tmp18_ != NULL)) {
								break;
							}
							_tmp20_ = prop;
							_tmp21_ = _tmp20_->name;
							if (g_strcmp0 (_tmp21_, RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME) == 0) {
								xmlAttr* _tmp22_;
								xmlNode* _tmp23_;
								const gchar* _tmp24_;
								_tmp22_ = prop;
								_tmp23_ = _tmp22_->children;
								_tmp24_ = _tmp23_->content;
								_tmp19_ = _tmp24_ != NULL;
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								FilterEntry* entry = NULL;
								xmlAttr* _tmp25_;
								xmlNode* _tmp26_;
								const gchar* _tmp27_;
								FilterEntry* _tmp28_;
								FilterEntry* _tmp29_;
								_tmp25_ = prop;
								_tmp26_ = _tmp25_->children;
								_tmp27_ = _tmp26_->content;
								_tmp28_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_SHORT_NAME, _tmp27_);
								entry = _tmp28_;
								_tmp29_ = entry;
								gee_collection_add ((GeeCollection*) filter_entries, _tmp29_);
								_filter_entry_unref0 (entry);
							}
						}
					}
				}
			}
			_tmp31_ = child_node;
			_tmp32_ = _tmp31_->name;
			if (g_strcmp0 (_tmp32_, RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO) == 0) {
				xmlNode* _tmp33_;
				const gchar* _tmp34_;
				_tmp33_ = child_node;
				_tmp34_ = _tmp33_->content;
				_tmp30_ = _tmp34_ != NULL;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				FilterEntry* entry = NULL;
				xmlNode* _tmp35_;
				const gchar* _tmp36_;
				FilterEntry* _tmp37_;
				FilterEntry* _tmp38_;
				_tmp35_ = child_node;
				_tmp36_ = _tmp35_->content;
				_tmp37_ = filter_entry_new (RYGEL_RUIH_SERVICE_MANAGER_PROTOCOL_INFO, _tmp36_);
				entry = _tmp37_;
				_tmp38_ = entry;
				gee_collection_add ((GeeCollection*) filter_entries, _tmp38_);
				_filter_entry_unref0 (entry);
			}
		}
		_rygel_xml_utils_iterator_unref0 (_child_node_it);
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
rygel_ruih_service_manager_convert_filter_string (RygelRuihServiceManager* self,
                                                  xmlNode* device_profile_node,
                                                  const gchar* filter,
                                                  GeeList* filter_entries,
                                                  GError** error)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean filter_is_wildcard = FALSE;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	g_return_if_fail (filter_entries != NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	if (g_strcmp0 (filter, "*") == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (filter, "\"*\"") == 0;
	}
	filter_is_wildcard = _tmp2_;
	if (device_profile_node == NULL) {
		_tmp3_ = filter_is_wildcard;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		WildCardFilterEntry* _tmp4_;
		WildCardFilterEntry* _tmp5_;
		_tmp4_ = wild_card_filter_entry_new ();
		_tmp5_ = _tmp4_;
		gee_collection_add ((GeeCollection*) filter_entries, (FilterEntry*) _tmp5_);
		_filter_entry_unref0 (_tmp5_);
	} else {
		if (!filter_is_wildcard) {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gchar** entries = NULL;
			gchar** _tmp20_;
			gchar** _tmp21_;
			gint entries_length1;
			gint _entries_size_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			if (string_get_char (filter, (glong) 0) != ((gunichar) '"')) {
				_tmp7_ = TRUE;
			} else {
				gboolean _tmp8_ = FALSE;
				gint _tmp9_;
				gint _tmp10_;
				_tmp9_ = strlen (filter);
				_tmp10_ = _tmp9_;
				if (string_get_char (filter, (glong) (_tmp10_ - 1)) != ((gunichar) '"')) {
					gint _tmp11_;
					gint _tmp12_;
					_tmp11_ = strlen (filter);
					_tmp12_ = _tmp11_;
					_tmp8_ = string_get_char (filter, (glong) (_tmp12_ - 1)) != ((gunichar) ',');
				} else {
					_tmp8_ = FALSE;
				}
				_tmp7_ = _tmp8_;
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp13_ = FALSE;
				if (!string_contains (filter, ",")) {
					_tmp13_ = string_contains (filter, ";");
				} else {
					_tmp13_ = FALSE;
				}
				_tmp6_ = _tmp13_;
			}
			if (_tmp6_) {
				gchar* msg = NULL;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				GError* _tmp18_;
				GError* _tmp19_;
				_tmp14_ = g_strdup (_ ("Invalid UI filter: %s"));
				msg = _tmp14_;
				_tmp15_ = msg;
				_tmp16_ = g_strdup_printf (_tmp15_, filter);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_INVALID_FILTER, _tmp17_);
				_tmp19_ = _tmp18_;
				_g_free0 (_tmp17_);
				_inner_error0_ = _tmp19_;
				if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (msg);
			}
			_tmp21_ = _tmp20_ = g_strsplit (filter, ",", 0);
			entries = _tmp21_;
			entries_length1 = _vala_array_length (_tmp20_);
			_entries_size_ = entries_length1;
			_tmp22_ = entries;
			_tmp22__length1 = entries_length1;
			{
				gchar** str_collection = NULL;
				gint str_collection_length1 = 0;
				gint _str_collection_size_ = 0;
				gint str_it = 0;
				str_collection = _tmp22_;
				str_collection_length1 = _tmp22__length1;
				for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
					const gchar* str = NULL;
					str = str_collection[str_it];
					{
						const gchar* _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						gchar** name_value = NULL;
						const gchar* _tmp26_;
						gchar** _tmp27_;
						gchar** _tmp28_;
						gint name_value_length1;
						gint _name_value_size_;
						gboolean _tmp29_ = FALSE;
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_ = FALSE;
						gchar** _tmp32_;
						gint _tmp32__length1;
						_tmp23_ = str;
						_tmp24_ = strlen (_tmp23_);
						_tmp25_ = _tmp24_;
						if (_tmp25_ == 0) {
							continue;
						}
						_tmp26_ = str;
						_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, "=", 0);
						name_value = _tmp28_;
						name_value_length1 = _vala_array_length (_tmp27_);
						_name_value_size_ = name_value_length1;
						_tmp32_ = name_value;
						_tmp32__length1 = name_value_length1;
						if (_tmp32_ != NULL) {
							gchar** _tmp33_;
							gint _tmp33__length1;
							_tmp33_ = name_value;
							_tmp33__length1 = name_value_length1;
							_tmp31_ = _tmp33__length1 == 2;
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							gchar** _tmp34_;
							gint _tmp34__length1;
							const gchar* _tmp35_;
							_tmp34_ = name_value;
							_tmp34__length1 = name_value_length1;
							_tmp35_ = _tmp34_[1];
							_tmp30_ = _tmp35_ != NULL;
						} else {
							_tmp30_ = FALSE;
						}
						if (_tmp30_) {
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							gint _tmp38_;
							gint _tmp39_;
							_tmp36_ = name_value;
							_tmp36__length1 = name_value_length1;
							_tmp37_ = _tmp36_[1];
							_tmp38_ = strlen (_tmp37_);
							_tmp39_ = _tmp38_;
							_tmp29_ = _tmp39_ > 2;
						} else {
							_tmp29_ = FALSE;
						}
						if (_tmp29_) {
							gboolean _tmp40_ = FALSE;
							gchar** _tmp41_;
							gint _tmp41__length1;
							const gchar* _tmp42_;
							_tmp41_ = name_value;
							_tmp41__length1 = name_value_length1;
							_tmp42_ = _tmp41_[1];
							if (string_get_char (_tmp42_, (glong) 0) == ((gunichar) '"')) {
								gchar** _tmp43_;
								gint _tmp43__length1;
								const gchar* _tmp44_;
								gchar** _tmp45_;
								gint _tmp45__length1;
								const gchar* _tmp46_;
								gint _tmp47_;
								gint _tmp48_;
								_tmp43_ = name_value;
								_tmp43__length1 = name_value_length1;
								_tmp44_ = _tmp43_[1];
								_tmp45_ = name_value;
								_tmp45__length1 = name_value_length1;
								_tmp46_ = _tmp45_[1];
								_tmp47_ = strlen (_tmp46_);
								_tmp48_ = _tmp47_;
								_tmp40_ = string_get_char (_tmp44_, (glong) (_tmp48_ - 1)) == ((gunichar) '"');
							} else {
								_tmp40_ = FALSE;
							}
							if (_tmp40_) {
								gchar* value = NULL;
								gchar** _tmp49_;
								gint _tmp49__length1;
								const gchar* _tmp50_;
								gchar** _tmp51_;
								gint _tmp51__length1;
								const gchar* _tmp52_;
								gint _tmp53_;
								gint _tmp54_;
								gchar* _tmp55_;
								gchar** _tmp56_;
								gint _tmp56__length1;
								const gchar* _tmp57_;
								const gchar* _tmp58_;
								FilterEntry* _tmp59_;
								FilterEntry* _tmp60_;
								_tmp49_ = name_value;
								_tmp49__length1 = name_value_length1;
								_tmp50_ = _tmp49_[1];
								_tmp51_ = name_value;
								_tmp51__length1 = name_value_length1;
								_tmp52_ = _tmp51_[1];
								_tmp53_ = strlen (_tmp52_);
								_tmp54_ = _tmp53_;
								_tmp55_ = string_substring (_tmp50_, (glong) 1, (glong) (_tmp54_ - 1));
								value = _tmp55_;
								_tmp56_ = name_value;
								_tmp56__length1 = name_value_length1;
								_tmp57_ = _tmp56_[0];
								_tmp58_ = value;
								_tmp59_ = filter_entry_new (_tmp57_, _tmp58_);
								_tmp60_ = _tmp59_;
								gee_collection_add ((GeeCollection*) filter_entries, _tmp60_);
								_filter_entry_unref0 (_tmp60_);
								_g_free0 (value);
							}
						}
						name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}

RygelRuihServiceManager*
rygel_ruih_service_manager_construct (GType object_type)
{
	RygelRuihServiceManager * self = NULL;
	self = (RygelRuihServiceManager*) g_object_new (object_type, NULL);
	return self;
}

RygelRuihServiceManager*
rygel_ruih_service_manager_new (void)
{
	return rygel_ruih_service_manager_construct (RYGEL_TYPE_RUIH_SERVICE_MANAGER);
}

static void
rygel_ruih_service_manager_class_init (RygelRuihServiceManagerClass * klass,
                                       gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	rygel_ruih_service_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelRuihServiceManager_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_ruih_service_manager_real_constructed;
	G_OBJECT_CLASS (klass)->finalize = rygel_ruih_service_manager_finalize;
	rygel_ruih_service_manager_signals[RYGEL_RUIH_SERVICE_MANAGER_UPDATED_SIGNAL] = g_signal_new ("updated", RYGEL_TYPE_RUIH_SERVICE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" "<" RYGEL_RUIH_SERVICE_MANAGER_UILIST " xmlns=\"urn:schemas-upnp-org:remoteui:uilist-1-0\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:remoteui:uilist-1-0 " "CompatibleUIs.xsd\">\n");
	rygel_ruih_service_manager_PRE_RESULT = _tmp0_;
	_tmp1_ = g_strdup ("</" RYGEL_RUIH_SERVICE_MANAGER_UILIST ">\n");
	rygel_ruih_service_manager_POST_RESULT = _tmp1_;
}

static void
rygel_ruih_service_manager_instance_init (RygelRuihServiceManager * self,
                                          gpointer klass)
{
	self->priv = rygel_ruih_service_manager_get_instance_private (self);
}

static void
rygel_ruih_service_manager_finalize (GObject * obj)
{
	RygelRuihServiceManager * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_RUIH_SERVICE_MANAGER, RygelRuihServiceManager);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
	_g_object_unref0 (self->priv->ui_list);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->priv->ui_listing_full_path);
	_g_object_unref0 (self->priv->ui_file_monitor);
	G_OBJECT_CLASS (rygel_ruih_service_manager_parent_class)->finalize (obj);
}

static GType
rygel_ruih_service_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelRuihServiceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_ruih_service_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRuihServiceManager), 0, (GInstanceInitFunc) rygel_ruih_service_manager_instance_init, NULL };
	GType rygel_ruih_service_manager_type_id;
	rygel_ruih_service_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelRuihServiceManager", &g_define_type_info, 0);
	RygelRuihServiceManager_private_offset = g_type_add_instance_private (rygel_ruih_service_manager_type_id, sizeof (RygelRuihServiceManagerPrivate));
	return rygel_ruih_service_manager_type_id;
}

GType
rygel_ruih_service_manager_get_type (void)
{
	static volatile gsize rygel_ruih_service_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_ruih_service_manager_type_id__volatile)) {
		GType rygel_ruih_service_manager_type_id;
		rygel_ruih_service_manager_type_id = rygel_ruih_service_manager_get_type_once ();
		g_once_init_leave (&rygel_ruih_service_manager_type_id__volatile, rygel_ruih_service_manager_type_id);
	}
	return rygel_ruih_service_manager_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

