/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};

static gint ValaInterface_private_offset;
static gpointer vala_interface_parent_class = NULL;

static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);

static inline gpointer
vala_interface_get_instance_private (ValaInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValaInterface_private_offset);
}

/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}

/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}

static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}

static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}

static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp8_;
		gint _p_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _p_index = 0;
		_tmp8_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp8_;
		_tmp9_ = _p_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_p_size = _tmp11_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaTypeParameter* _tmp14_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = vala_list_get (_tmp12_, _p_index);
			p = (ValaTypeParameter*) _tmp13_;
			_tmp14_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp15_;
		gint _en_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _en_index = 0;
		_tmp15_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp15_;
		_tmp16_ = _en_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_en_size = _tmp18_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaEnum* _tmp21_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp19_ = _en_list;
			_tmp20_ = vala_list_get (_tmp19_, _en_index);
			en = (ValaEnum*) _tmp20_;
			_tmp21_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp22_;
		gint _m_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _m_index = 0;
		_tmp22_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp22_;
		_tmp23_ = _m_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_m_size = _tmp25_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaMethod* _tmp28_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp26_ = _m_list;
			_tmp27_ = vala_list_get (_tmp26_, _m_index);
			m = (ValaMethod*) _tmp27_;
			_tmp28_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp29_;
		gint _f_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _f_index = 0;
		_tmp29_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp29_;
		_tmp30_ = _f_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_f_size = _tmp32_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp33_;
			gpointer _tmp34_;
			ValaField* _tmp35_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp33_ = _f_list;
			_tmp34_ = vala_list_get (_tmp33_, _f_index);
			f = (ValaField*) _tmp34_;
			_tmp35_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp36_;
		gint _c_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _c_index = 0;
		_tmp36_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp36_;
		_tmp37_ = _c_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_c_size = _tmp39_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			ValaConstant* _tmp42_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp40_ = _c_list;
			_tmp41_ = vala_list_get (_tmp40_, _c_index);
			c = (ValaConstant*) _tmp41_;
			_tmp42_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp43_;
		gint _prop_size = 0;
		ValaList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _prop_index = 0;
		_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp43_;
		_tmp44_ = _prop_list;
		_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_prop_size = _tmp46_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp47_;
			gpointer _tmp48_;
			ValaProperty* _tmp49_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp47_ = _prop_list;
			_tmp48_ = vala_list_get (_tmp47_, _prop_index);
			prop = (ValaProperty*) _tmp48_;
			_tmp49_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp50_;
		gint _sig_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _sig_index = 0;
		_tmp50_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp50_;
		_tmp51_ = _sig_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_sig_size = _tmp53_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaSignal* _tmp56_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp54_ = _sig_list;
			_tmp55_ = vala_list_get (_tmp54_, _sig_index);
			sig = (ValaSignal*) _tmp55_;
			_tmp56_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp56_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp57_;
		gint _cl_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _cl_index = 0;
		_tmp57_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp57_;
		_tmp58_ = _cl_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_cl_size = _tmp60_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaClass* _tmp63_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp61_ = _cl_list;
			_tmp62_ = vala_list_get (_tmp61_, _cl_index);
			cl = (ValaClass*) _tmp62_;
			_tmp63_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp63_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp64_;
		gint _st_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _st_index = 0;
		_tmp64_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp64_;
		_tmp65_ = _st_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_st_size = _tmp67_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaStruct* _tmp70_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp68_ = _st_list;
			_tmp69_ = vala_list_get (_tmp68_, _st_index);
			st = (ValaStruct*) _tmp69_;
			_tmp70_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp71_;
		gint _d_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _d_index = 0;
		_tmp71_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp71_;
		_tmp72_ = _d_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_d_size = _tmp74_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp75_;
			gpointer _tmp76_;
			ValaDelegate* _tmp77_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp75_ = _d_list;
			_tmp76_ = vala_list_get (_tmp75_, _d_index);
			d = (ValaDelegate*) _tmp76_;
			_tmp77_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}

static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_prerequisite_index = _prerequisite_index + 1;
			if (!(_prerequisite_index < _prerequisite_size)) {
				break;
			}
			_tmp5_ = _prerequisite_list;
			_tmp6_ = vala_list_get (_tmp5_, _prerequisite_index);
			prerequisite = (ValaDataType*) _tmp6_;
			_tmp8_ = prerequisite;
			_tmp9_ = vala_data_type_get_data_type (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = prerequisite;
				_tmp12_ = vala_data_type_get_data_type (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp13_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}

static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->prerequisites;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->prerequisites;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->prerequisites;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp116_;
	gboolean _tmp117_;
	ValaMap* positions = NULL;
	GHashFunc _tmp224_;
	GEqualFunc _tmp225_;
	GEqualFunc _tmp226_;
	ValaHashMap* _tmp227_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	ValaSemanticAnalyzer* _tmp301_;
	ValaSemanticAnalyzer* _tmp302_;
	ValaSourceFile* _tmp303_;
	ValaSemanticAnalyzer* _tmp304_;
	ValaSemanticAnalyzer* _tmp305_;
	ValaSymbol* _tmp306_;
	gboolean _tmp307_;
	gboolean _tmp308_;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaSemanticAnalyzer* _tmp30_;
			ValaSemanticAnalyzer* _tmp31_;
			ValaDataType* _tmp32_;
			_prerequisite_reference_index = _prerequisite_reference_index + 1;
			if (!(_prerequisite_reference_index < _prerequisite_reference_size)) {
				break;
			}
			_tmp28_ = _prerequisite_reference_list;
			_tmp29_ = vala_list_get (_tmp28_, _prerequisite_reference_index);
			prerequisite_reference = (ValaDataType*) _tmp29_;
			_tmp30_ = vala_code_context_get_analyzer (context);
			_tmp31_ = _tmp30_;
			_tmp32_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp31_, (ValaSymbol*) self, _tmp32_)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = prerequisite_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup_printf ("prerequisite `%s' is less accessible than interface `%s'", _tmp37_, _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp34_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp42_;
		gint _prereq_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _prereq_index = 0;
		_tmp42_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp42_;
		_tmp43_ = _prereq_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_prereq_size = _tmp45_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp46_ = _prereq_list;
			_tmp47_ = vala_list_get (_tmp46_, _prereq_index);
			prereq = (ValaDataType*) _tmp47_;
			_tmp48_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp48_)) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaDataType* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp50_ = _tmp49_;
				_tmp51_ = prereq;
				_tmp52_ = vala_code_node_to_string ((ValaCodeNode*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp55_ = _tmp54_;
				_tmp56_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp53_, _tmp55_);
				_tmp57_ = _tmp56_;
				vala_report_error (_tmp50_, _tmp57_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp58_ = prereq;
			_tmp59_ = vala_data_type_get_data_type (_tmp58_);
			_tmp60_ = _tmp59_;
			if (VALA_IS_CLASS (_tmp60_)) {
				ValaClass* _tmp61_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaClass* _tmp79_;
				_tmp61_ = prereq_class;
				if (_tmp61_ != NULL) {
					ValaSourceReference* _tmp62_;
					ValaSourceReference* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					ValaDataType* _tmp66_;
					ValaTypeSymbol* _tmp67_;
					ValaTypeSymbol* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					ValaClass* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp63_ = _tmp62_;
					_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					_tmp66_ = prereq;
					_tmp67_ = vala_data_type_get_data_type (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = prereq_class;
					_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp65_, _tmp70_, _tmp73_);
					_tmp75_ = _tmp74_;
					vala_report_error (_tmp63_, _tmp75_);
					_g_free0 (_tmp75_);
					_g_free0 (_tmp73_);
					_g_free0 (_tmp70_);
					_g_free0 (_tmp65_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp76_ = prereq;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp79_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _type_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _type_index = 0;
		_tmp80_ = self->priv->prerequisites;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_type_list = _tmp81_;
		_tmp82_ = _type_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_type_size = _tmp84_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaDataType* _tmp87_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp85_ = _type_list;
			_tmp86_ = vala_list_get (_tmp85_, _type_index);
			type = (ValaDataType*) _tmp86_;
			_tmp87_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp87_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp88_;
		gint _p_size = 0;
		ValaList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _p_index = 0;
		_tmp88_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp88_;
		_tmp89_ = _p_list;
		_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_p_size = _tmp91_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaTypeParameter* _tmp94_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp92_ = _p_list;
			_tmp93_ = vala_list_get (_tmp92_, _p_index);
			p = (ValaTypeParameter*) _tmp93_;
			_tmp94_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp94_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp95_;
		gint _en_size = 0;
		ValaList* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _en_index = 0;
		_tmp95_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp95_;
		_tmp96_ = _en_list;
		_tmp97_ = vala_collection_get_size ((ValaCollection*) _tmp96_);
		_tmp98_ = _tmp97_;
		_en_size = _tmp98_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp99_;
			gpointer _tmp100_;
			ValaEnum* _tmp101_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp99_ = _en_list;
			_tmp100_ = vala_list_get (_tmp99_, _en_index);
			en = (ValaEnum*) _tmp100_;
			_tmp101_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp102_;
		gint _f_size = 0;
		ValaList* _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _f_index = 0;
		_tmp102_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp102_;
		_tmp103_ = _f_list;
		_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
		_tmp105_ = _tmp104_;
		_f_size = _tmp105_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp106_;
			gpointer _tmp107_;
			ValaField* _tmp108_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp106_ = _f_list;
			_tmp107_ = vala_list_get (_tmp106_, _f_index);
			f = (ValaField*) _tmp107_;
			_tmp108_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp109_;
		gint _c_size = 0;
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint _c_index = 0;
		_tmp109_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp109_;
		_tmp110_ = _c_list;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_c_size = _tmp112_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp113_;
			gpointer _tmp114_;
			ValaConstant* _tmp115_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp113_ = _c_list;
			_tmp114_ = vala_list_get (_tmp113_, _c_index);
			c = (ValaConstant*) _tmp114_;
			_tmp115_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp115_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp116_ = vala_code_context_get_abi_stability (context);
	_tmp117_ = _tmp116_;
	if (_tmp117_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp118_;
			gint _s_size = 0;
			ValaList* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			gint _s_index = 0;
			_tmp118_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp118_;
			_tmp119_ = _s_list;
			_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
			_tmp121_ = _tmp120_;
			_s_size = _tmp121_;
			_s_index = -1;
			while (TRUE) {
				ValaSymbol* s = NULL;
				ValaList* _tmp122_;
				gpointer _tmp123_;
				ValaSymbol* _tmp124_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp122_ = _s_list;
				_tmp123_ = vala_list_get (_tmp122_, _s_index);
				s = (ValaSymbol*) _tmp123_;
				_tmp124_ = s;
				if (VALA_IS_METHOD (_tmp124_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp125_;
					ValaMethod* _tmp126_;
					ValaMethod* _tmp127_;
					gboolean _tmp128_ = FALSE;
					ValaMethod* _tmp129_;
					gboolean _tmp130_;
					gboolean _tmp131_;
					_tmp125_ = s;
					_tmp126_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp126_;
					_tmp127_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp127_, context);
					_tmp129_ = m;
					_tmp130_ = vala_method_get_is_virtual (_tmp129_);
					_tmp131_ = _tmp130_;
					if (_tmp131_) {
						_tmp128_ = TRUE;
					} else {
						ValaMethod* _tmp132_;
						gboolean _tmp133_;
						gboolean _tmp134_;
						_tmp132_ = m;
						_tmp133_ = vala_method_get_is_abstract (_tmp132_);
						_tmp134_ = _tmp133_;
						_tmp128_ = _tmp134_;
					}
					if (_tmp128_) {
						ValaList* _tmp135_;
						ValaMethod* _tmp136_;
						_tmp135_ = self->priv->virtuals;
						_tmp136_ = m;
						vala_collection_add ((ValaCollection*) _tmp135_, (ValaSymbol*) _tmp136_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp137_;
					_tmp137_ = s;
					if (VALA_IS_SIGNAL (_tmp137_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp138_;
						ValaSignal* _tmp139_;
						ValaSignal* _tmp140_;
						ValaSignal* _tmp141_;
						gboolean _tmp142_;
						gboolean _tmp143_;
						_tmp138_ = s;
						_tmp139_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp139_;
						_tmp140_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp140_, context);
						_tmp141_ = sig;
						_tmp142_ = vala_signal_get_is_virtual (_tmp141_);
						_tmp143_ = _tmp142_;
						if (_tmp143_) {
							ValaList* _tmp144_;
							ValaSignal* _tmp145_;
							_tmp144_ = self->priv->virtuals;
							_tmp145_ = sig;
							vala_collection_add ((ValaCollection*) _tmp144_, (ValaSymbol*) _tmp145_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp146_;
						_tmp146_ = s;
						if (VALA_IS_PROPERTY (_tmp146_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp147_;
							ValaProperty* _tmp148_;
							ValaProperty* _tmp149_;
							gboolean _tmp150_ = FALSE;
							ValaProperty* _tmp151_;
							gboolean _tmp152_;
							gboolean _tmp153_;
							_tmp147_ = s;
							_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp148_;
							_tmp149_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp149_, context);
							_tmp151_ = prop;
							_tmp152_ = vala_property_get_is_virtual (_tmp151_);
							_tmp153_ = _tmp152_;
							if (_tmp153_) {
								_tmp150_ = TRUE;
							} else {
								ValaProperty* _tmp154_;
								gboolean _tmp155_;
								gboolean _tmp156_;
								_tmp154_ = prop;
								_tmp155_ = vala_property_get_is_abstract (_tmp154_);
								_tmp156_ = _tmp155_;
								_tmp150_ = _tmp156_;
							}
							if (_tmp150_) {
								ValaList* _tmp157_;
								ValaProperty* _tmp158_;
								_tmp157_ = self->priv->virtuals;
								_tmp158_ = prop;
								vala_collection_add ((ValaCollection*) _tmp157_, (ValaSymbol*) _tmp158_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp159_;
			gint _m_size = 0;
			ValaList* _tmp160_;
			gint _tmp161_;
			gint _tmp162_;
			gint _m_index = 0;
			_tmp159_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp159_;
			_tmp160_ = _m_list;
			_tmp161_ = vala_collection_get_size ((ValaCollection*) _tmp160_);
			_tmp162_ = _tmp161_;
			_m_size = _tmp162_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp163_;
				gpointer _tmp164_;
				ValaMethod* _tmp165_;
				gboolean _tmp166_ = FALSE;
				ValaMethod* _tmp167_;
				gboolean _tmp168_;
				gboolean _tmp169_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp163_ = _m_list;
				_tmp164_ = vala_list_get (_tmp163_, _m_index);
				m = (ValaMethod*) _tmp164_;
				_tmp165_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp165_, context);
				_tmp167_ = m;
				_tmp168_ = vala_method_get_is_virtual (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_) {
					_tmp166_ = TRUE;
				} else {
					ValaMethod* _tmp170_;
					gboolean _tmp171_;
					gboolean _tmp172_;
					_tmp170_ = m;
					_tmp171_ = vala_method_get_is_abstract (_tmp170_);
					_tmp172_ = _tmp171_;
					_tmp166_ = _tmp172_;
				}
				if (_tmp166_) {
					ValaList* _tmp173_;
					ValaMethod* _tmp174_;
					_tmp173_ = self->priv->virtuals;
					_tmp174_ = m;
					vala_collection_add ((ValaCollection*) _tmp173_, (ValaSymbol*) _tmp174_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp175_;
			gint _sig_size = 0;
			ValaList* _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			gint _sig_index = 0;
			_tmp175_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp175_;
			_tmp176_ = _sig_list;
			_tmp177_ = vala_collection_get_size ((ValaCollection*) _tmp176_);
			_tmp178_ = _tmp177_;
			_sig_size = _tmp178_;
			_sig_index = -1;
			while (TRUE) {
				ValaSignal* sig = NULL;
				ValaList* _tmp179_;
				gpointer _tmp180_;
				ValaSignal* _tmp181_;
				ValaSignal* _tmp182_;
				gboolean _tmp183_;
				gboolean _tmp184_;
				_sig_index = _sig_index + 1;
				if (!(_sig_index < _sig_size)) {
					break;
				}
				_tmp179_ = _sig_list;
				_tmp180_ = vala_list_get (_tmp179_, _sig_index);
				sig = (ValaSignal*) _tmp180_;
				_tmp181_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp181_, context);
				_tmp182_ = sig;
				_tmp183_ = vala_signal_get_is_virtual (_tmp182_);
				_tmp184_ = _tmp183_;
				if (_tmp184_) {
					ValaList* _tmp185_;
					ValaSignal* _tmp186_;
					_tmp185_ = self->priv->virtuals;
					_tmp186_ = sig;
					vala_collection_add ((ValaCollection*) _tmp185_, (ValaSymbol*) _tmp186_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp187_;
			gint _prop_size = 0;
			ValaList* _tmp188_;
			gint _tmp189_;
			gint _tmp190_;
			gint _prop_index = 0;
			_tmp187_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp187_;
			_tmp188_ = _prop_list;
			_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
			_tmp190_ = _tmp189_;
			_prop_size = _tmp190_;
			_prop_index = -1;
			while (TRUE) {
				ValaProperty* prop = NULL;
				ValaList* _tmp191_;
				gpointer _tmp192_;
				ValaProperty* _tmp193_;
				gboolean _tmp194_ = FALSE;
				ValaProperty* _tmp195_;
				gboolean _tmp196_;
				gboolean _tmp197_;
				_prop_index = _prop_index + 1;
				if (!(_prop_index < _prop_size)) {
					break;
				}
				_tmp191_ = _prop_list;
				_tmp192_ = vala_list_get (_tmp191_, _prop_index);
				prop = (ValaProperty*) _tmp192_;
				_tmp193_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp193_, context);
				_tmp195_ = prop;
				_tmp196_ = vala_property_get_is_virtual (_tmp195_);
				_tmp197_ = _tmp196_;
				if (_tmp197_) {
					_tmp194_ = TRUE;
				} else {
					ValaProperty* _tmp198_;
					gboolean _tmp199_;
					gboolean _tmp200_;
					_tmp198_ = prop;
					_tmp199_ = vala_property_get_is_abstract (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp194_ = _tmp200_;
				}
				if (_tmp194_) {
					ValaList* _tmp201_;
					ValaProperty* _tmp202_;
					_tmp201_ = self->priv->virtuals;
					_tmp202_ = prop;
					vala_collection_add ((ValaCollection*) _tmp201_, (ValaSymbol*) _tmp202_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp203_;
		gint _cl_size = 0;
		ValaList* _tmp204_;
		gint _tmp205_;
		gint _tmp206_;
		gint _cl_index = 0;
		_tmp203_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp203_;
		_tmp204_ = _cl_list;
		_tmp205_ = vala_collection_get_size ((ValaCollection*) _tmp204_);
		_tmp206_ = _tmp205_;
		_cl_size = _tmp206_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp207_;
			gpointer _tmp208_;
			ValaClass* _tmp209_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp207_ = _cl_list;
			_tmp208_ = vala_list_get (_tmp207_, _cl_index);
			cl = (ValaClass*) _tmp208_;
			_tmp209_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp209_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp210_;
		gint _st_size = 0;
		ValaList* _tmp211_;
		gint _tmp212_;
		gint _tmp213_;
		gint _st_index = 0;
		_tmp210_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp210_;
		_tmp211_ = _st_list;
		_tmp212_ = vala_collection_get_size ((ValaCollection*) _tmp211_);
		_tmp213_ = _tmp212_;
		_st_size = _tmp213_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp214_;
			gpointer _tmp215_;
			ValaStruct* _tmp216_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp214_ = _st_list;
			_tmp215_ = vala_list_get (_tmp214_, _st_index);
			st = (ValaStruct*) _tmp215_;
			_tmp216_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp217_;
		gint _d_size = 0;
		ValaList* _tmp218_;
		gint _tmp219_;
		gint _tmp220_;
		gint _d_index = 0;
		_tmp217_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp217_;
		_tmp218_ = _d_list;
		_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
		_tmp220_ = _tmp219_;
		_d_size = _tmp220_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp221_;
			gpointer _tmp222_;
			ValaDelegate* _tmp223_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp221_ = _d_list;
			_tmp222_ = vala_list_get (_tmp221_, _d_index);
			d = (ValaDelegate*) _tmp222_;
			_tmp223_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp223_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp224_ = g_direct_hash;
	_tmp225_ = g_direct_equal;
	_tmp226_ = g_direct_equal;
	_tmp227_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp224_, _tmp225_, _tmp226_);
	positions = (ValaMap*) _tmp227_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp228_;
		ValaList* _tmp229_;
		gint _sym_size = 0;
		ValaList* _tmp230_;
		gint _tmp231_;
		gint _tmp232_;
		gint _sym_index = 0;
		_tmp228_ = self->priv->virtuals;
		_tmp229_ = _vala_iterable_ref0 (_tmp228_);
		_sym_list = _tmp229_;
		_tmp230_ = _sym_list;
		_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
		_tmp232_ = _tmp231_;
		_sym_size = _tmp232_;
		_sym_index = -1;
		while (TRUE) {
			ValaSymbol* sym = NULL;
			ValaList* _tmp233_;
			gpointer _tmp234_;
			gint ordering = 0;
			ValaSymbol* _tmp235_;
			gboolean ordered = FALSE;
			gboolean _tmp244_ = FALSE;
			gboolean _tmp245_ = FALSE;
			gboolean _tmp254_ = FALSE;
			gboolean _tmp255_ = FALSE;
			gboolean _tmp256_ = FALSE;
			gboolean _tmp265_ = FALSE;
			gboolean _tmp266_ = FALSE;
			_sym_index = _sym_index + 1;
			if (!(_sym_index < _sym_size)) {
				break;
			}
			_tmp233_ = _sym_list;
			_tmp234_ = vala_list_get (_tmp233_, _sym_index);
			sym = (ValaSymbol*) _tmp234_;
			_tmp235_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp235_, "CCode", "ordering", -1);
			if (ordering < -1) {
				ValaSymbol* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaSymbol* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				_tmp236_ = sym;
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp236_);
				_tmp238_ = _tmp237_;
				_tmp239_ = sym;
				_tmp240_ = vala_symbol_get_full_name (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = g_strdup_printf ("%s: Invalid ordering", _tmp241_);
				_tmp243_ = _tmp242_;
				vala_report_error (_tmp238_, _tmp243_);
				_g_free0 (_tmp243_);
				_g_free0 (_tmp241_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			ordered = ordering != -1;
			if (ordered) {
				_tmp245_ = unordered_seen;
			} else {
				_tmp245_ = FALSE;
			}
			if (_tmp245_) {
				_tmp244_ = !ordered_seen;
			} else {
				_tmp244_ = FALSE;
			}
			if (_tmp244_) {
				ValaSymbol* _tmp246_;
				ValaSourceReference* _tmp247_;
				ValaSourceReference* _tmp248_;
				ValaSymbol* _tmp249_;
				gchar* _tmp250_;
				gchar* _tmp251_;
				gchar* _tmp252_;
				gchar* _tmp253_;
				_tmp246_ = sym;
				_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = sym;
				_tmp250_ = vala_symbol_get_full_name (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp251_);
				_tmp253_ = _tmp252_;
				vala_report_error (_tmp248_, _tmp253_);
				_g_free0 (_tmp253_);
				_g_free0 (_tmp251_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (ordered_seen) {
				_tmp254_ = TRUE;
			} else {
				_tmp254_ = ordered;
			}
			ordered_seen = _tmp254_;
			if (!ordered) {
				_tmp256_ = !unordered_seen;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				_tmp255_ = ordered_seen;
			} else {
				_tmp255_ = FALSE;
			}
			if (_tmp255_) {
				ValaSymbol* _tmp257_;
				ValaSourceReference* _tmp258_;
				ValaSourceReference* _tmp259_;
				ValaSymbol* _tmp260_;
				gchar* _tmp261_;
				gchar* _tmp262_;
				gchar* _tmp263_;
				gchar* _tmp264_;
				_tmp257_ = sym;
				_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp257_);
				_tmp259_ = _tmp258_;
				_tmp260_ = sym;
				_tmp261_ = vala_symbol_get_full_name (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp262_);
				_tmp264_ = _tmp263_;
				vala_report_error (_tmp259_, _tmp264_);
				_g_free0 (_tmp264_);
				_g_free0 (_tmp262_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (unordered_seen) {
				_tmp265_ = TRUE;
			} else {
				_tmp265_ = !ordered;
			}
			unordered_seen = _tmp265_;
			if (!ordered_seen) {
				_tmp266_ = TRUE;
			} else {
				_tmp266_ = !unordered_seen;
			}
			if (_tmp266_) {
				if (ordered) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp267_;
					gpointer _tmp268_;
					ValaSymbol* _tmp269_;
					ValaMap* _tmp281_;
					ValaSymbol* _tmp282_;
					_tmp267_ = positions;
					_tmp268_ = vala_map_get (_tmp267_, (gpointer) ((gintptr) ordering));
					prev = (ValaSymbol*) _tmp268_;
					_tmp269_ = prev;
					if (_tmp269_ != NULL) {
						ValaSymbol* _tmp270_;
						ValaSourceReference* _tmp271_;
						ValaSourceReference* _tmp272_;
						ValaSymbol* _tmp273_;
						gchar* _tmp274_;
						gchar* _tmp275_;
						ValaSymbol* _tmp276_;
						const gchar* _tmp277_;
						const gchar* _tmp278_;
						gchar* _tmp279_;
						gchar* _tmp280_;
						_tmp270_ = sym;
						_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp270_);
						_tmp272_ = _tmp271_;
						_tmp273_ = sym;
						_tmp274_ = vala_symbol_get_full_name (_tmp273_);
						_tmp275_ = _tmp274_;
						_tmp276_ = prev;
						_tmp277_ = vala_symbol_get_name (_tmp276_);
						_tmp278_ = _tmp277_;
						_tmp279_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp275_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_report_error (_tmp272_, _tmp280_);
						_g_free0 (_tmp280_);
						_g_free0 (_tmp275_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp281_ = positions;
					_tmp282_ = sym;
					vala_map_set (_tmp281_, (gpointer) ((gintptr) ordering), _tmp282_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	if (ordered_seen) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp283_ = FALSE;
				_tmp283_ = TRUE;
				while (TRUE) {
					ValaList* _tmp285_;
					gint _tmp286_;
					gint _tmp287_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp288_;
					gpointer _tmp289_;
					ValaSymbol* _tmp290_;
					gboolean _tmp297_;
					gboolean _tmp298_;
					if (!_tmp283_) {
						gint _tmp284_;
						_tmp284_ = i;
						i = _tmp284_ + 1;
					}
					_tmp283_ = FALSE;
					_tmp285_ = self->priv->virtuals;
					_tmp286_ = vala_collection_get_size ((ValaCollection*) _tmp285_);
					_tmp287_ = _tmp286_;
					if (!(i < _tmp287_)) {
						break;
					}
					_tmp288_ = positions;
					_tmp289_ = vala_map_get (_tmp288_, (gpointer) ((gintptr) i));
					sym = (ValaSymbol*) _tmp289_;
					_tmp290_ = sym;
					if (_tmp290_ == NULL) {
						ValaSourceReference* _tmp291_;
						ValaSourceReference* _tmp292_;
						gchar* _tmp293_;
						gchar* _tmp294_;
						gchar* _tmp295_;
						gchar* _tmp296_;
						_tmp291_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp292_ = _tmp291_;
						_tmp293_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp294_ = _tmp293_;
						_tmp295_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp294_, i);
						_tmp296_ = _tmp295_;
						vala_report_error (_tmp292_, _tmp296_);
						_g_free0 (_tmp296_);
						_g_free0 (_tmp294_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp297_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp298_ = _tmp297_;
					if (!_tmp298_) {
						ValaList* _tmp299_;
						ValaSymbol* _tmp300_;
						_tmp299_ = self->priv->virtuals;
						_tmp300_ = sym;
						vala_list_set (_tmp299_, i, _tmp300_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp301_ = vala_code_context_get_analyzer (context);
	_tmp302_ = _tmp301_;
	_tmp303_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp302_, _tmp303_);
	_tmp304_ = vala_code_context_get_analyzer (context);
	_tmp305_ = _tmp304_;
	_tmp306_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp305_, _tmp306_);
	_tmp307_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp308_ = _tmp307_;
	result = !_tmp308_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_interface_class_init (ValaInterfaceClass * klass,
                           gpointer klass_data)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_adjust_private_offset (klass, &ValaInterface_private_offset);
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}

static void
vala_interface_instance_init (ValaInterface * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}

static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}

/**
 * Represents an interface declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		ValaInterface_private_offset = g_type_add_instance_private (vala_interface_type_id, sizeof (ValaInterfacePrivate));
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}

