/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp23_;
	ValaLocalVariable* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaList* _tmp36_;
	ValaList* _tmp45_;
	ValaBlock* _tmp54_;
	ValaBlock* _tmp55_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeParameter* _tmp6_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp4_ = _p_list;
			_tmp5_ = vala_list_get (_tmp4_, _p_index);
			p = (ValaTypeParameter*) _tmp5_;
			_tmp6_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp7_ = vala_method_get_base_interface_type (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_method_get_base_interface_type (self);
		_tmp10_ = _tmp9_;
		vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
	}
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _param_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _param_index = 0;
		_tmp15_ = self->priv->parameters;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_param_list = _tmp16_;
		_tmp17_ = _param_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_param_size = _tmp19_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = vala_list_get (_tmp20_, _param_index);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp23_ = self->error_types;
	if (_tmp23_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _error_type_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _error_type_index = 0;
			_tmp24_ = self->error_types;
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_error_type_list = _tmp25_;
			_tmp26_ = _error_type_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_error_type_size = _tmp28_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaDataType* _tmp31_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp29_ = _error_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _error_type_index);
				error_type = (ValaDataType*) _tmp30_;
				_tmp31_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaLocalVariable* _tmp34_;
		ValaLocalVariable* _tmp35_;
		_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp35_ = _tmp34_;
		vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
	}
	_tmp36_ = self->priv->preconditions;
	if (_tmp36_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _precondition_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _precondition_index = 0;
			_tmp37_ = self->priv->preconditions;
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_precondition_list = _tmp38_;
			_tmp39_ = _precondition_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_precondition_size = _tmp41_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaExpression* _tmp44_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp42_ = _precondition_list;
				_tmp43_ = vala_list_get (_tmp42_, _precondition_index);
				precondition = (ValaExpression*) _tmp43_;
				_tmp44_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp45_ = self->priv->postconditions;
	if (_tmp45_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _postcondition_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _postcondition_index = 0;
			_tmp46_ = self->priv->postconditions;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_postcondition_list = _tmp47_;
			_tmp48_ = _postcondition_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_postcondition_size = _tmp50_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp51_ = _postcondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp52_;
				_tmp53_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		ValaBlock* _tmp56_;
		ValaBlock* _tmp57_;
		_tmp56_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp57_ = _tmp56_;
		vala_code_node_accept ((ValaCodeNode*) _tmp57_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* return_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	ValaObjectType* _tmp66_;
	ValaList* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp78_;
	ValaIterator* _tmp79_;
	gint param_index = 0;
	ValaIterator* _tmp127_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp129_;
	ValaArrayList* _tmp130_;
	ValaArrayList* _tmp131_;
	ValaList* _tmp132_;
	gboolean _tmp153_;
	gboolean _tmp154_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp17_;
				ValaGenericType* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaObjectType* _tmp20_;
				ValaGenericType* _tmp21_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp15_ = _type_parameter_list;
				_tmp16_ = vala_list_get (_tmp15_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp16_;
				_tmp17_ = type_parameter;
				_tmp18_ = vala_generic_type_new (_tmp17_);
				type_arg = _tmp18_;
				_tmp19_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp19_, TRUE);
				_tmp20_ = object_type;
				_tmp21_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp20_, (ValaDataType*) _tmp21_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp22_ = vala_method_get_type_parameters (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp25_ < _tmp29_;
	_vala_iterable_unref0 (_tmp27_);
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gboolean _tmp40_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_method_get_type_parameters (base_method);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp35_ > _tmp39_;
		_vala_iterable_unref0 (_tmp37_);
		_vala_iterable_unref0 (_tmp33_);
		if (_tmp40_) {
			gchar* _tmp41_;
			_tmp41_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp41_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp42_;
		ValaArrayList* _tmp43_;
		_tmp42_ = g_direct_equal;
		_tmp43_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp42_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp43_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp44_;
			gint _type_parameter_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _type_parameter_index = 0;
			_tmp44_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp44_;
			_tmp45_ = _type_parameter_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_type_parameter_size = _tmp47_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_data_type_copy (_tmp56_);
	return_type = _tmp57_;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "returns_floating_reference")) {
		ValaDataType* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp58_ = return_type;
		_tmp59_ = vala_method_get_returns_floating_reference (self);
		_tmp60_ = _tmp59_;
		vala_data_type_set_floating_reference (_tmp58_, _tmp60_);
	} else {
		ValaDataType* _tmp61_;
		gboolean _tmp62_;
		gboolean _tmp63_;
		_tmp61_ = return_type;
		_tmp62_ = vala_method_get_returns_floating_reference (base_method);
		_tmp63_ = _tmp62_;
		vala_data_type_set_floating_reference (_tmp61_, _tmp63_);
	}
	_tmp64_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp65_ = _tmp64_;
	_tmp66_ = object_type;
	_tmp67_ = method_type_args;
	_tmp68_ = vala_data_type_get_actual_type (_tmp65_, (ValaDataType*) _tmp66_, _tmp67_, node_reference);
	actual_base_type = _tmp68_;
	_tmp69_ = return_type;
	_tmp70_ = actual_base_type;
	if (!vala_data_type_equals (_tmp69_, _tmp70_)) {
		ValaDataType* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaDataType* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp71_ = actual_base_type;
		_tmp72_ = vala_data_type_to_prototype_string (_tmp71_, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = return_type;
		_tmp75_ = vala_data_type_to_prototype_string (_tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp73_, _tmp76_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp77_;
		_g_free0 (_tmp76_);
		_g_free0 (_tmp73_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp78_ = self->priv->parameters;
	_tmp79_ = vala_iterable_iterator ((ValaIterable*) _tmp78_);
	method_params_it = _tmp79_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _base_param_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _base_param_index = 0;
		_tmp80_ = base_method->priv->parameters;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_base_param_list = _tmp81_;
		_tmp82_ = _base_param_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_base_param_size = _tmp84_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaIterator* _tmp87_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp89_;
			gpointer _tmp90_;
			ValaParameter* _tmp91_;
			gboolean _tmp92_;
			gboolean _tmp93_;
			ValaParameter* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			ValaParameter* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			ValaParameter* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			ValaParameter* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			gint _tmp126_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp85_ = _base_param_list;
			_tmp86_ = vala_list_get (_tmp85_, _base_param_index);
			base_param = (ValaParameter*) _tmp86_;
			_tmp87_ = method_params_it;
			if (!vala_iterator_next (_tmp87_)) {
				gchar* _tmp88_;
				_tmp88_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp88_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp89_ = method_params_it;
			_tmp90_ = vala_iterator_get (_tmp89_);
			param = (ValaParameter*) _tmp90_;
			_tmp91_ = base_param;
			_tmp92_ = vala_parameter_get_ellipsis (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = param;
			_tmp95_ = vala_parameter_get_ellipsis (_tmp94_);
			_tmp96_ = _tmp95_;
			if (_tmp93_ != _tmp96_) {
				gchar* _tmp97_;
				_tmp97_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp97_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp98_ = base_param;
			_tmp99_ = vala_parameter_get_params_array (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = param;
			_tmp102_ = vala_parameter_get_params_array (_tmp101_);
			_tmp103_ = _tmp102_;
			if (_tmp100_ != _tmp103_) {
				gchar* _tmp104_;
				_tmp104_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp104_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp105_ = base_param;
			_tmp106_ = vala_parameter_get_ellipsis (_tmp105_);
			_tmp107_ = _tmp106_;
			if (!_tmp107_) {
				ValaParameter* _tmp108_;
				ValaParameterDirection _tmp109_;
				ValaParameterDirection _tmp110_;
				ValaParameter* _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameterDirection _tmp113_;
				ValaParameter* _tmp115_;
				ValaDataType* _tmp116_;
				ValaDataType* _tmp117_;
				ValaObjectType* _tmp118_;
				ValaList* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaParameter* _tmp122_;
				ValaDataType* _tmp123_;
				ValaDataType* _tmp124_;
				_tmp108_ = base_param;
				_tmp109_ = vala_parameter_get_direction (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = param;
				_tmp112_ = vala_parameter_get_direction (_tmp111_);
				_tmp113_ = _tmp112_;
				if (_tmp110_ != _tmp113_) {
					gchar* _tmp114_;
					_tmp114_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp114_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp115_ = base_param;
				_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = object_type;
				_tmp119_ = method_type_args;
				_tmp120_ = vala_data_type_get_actual_type (_tmp117_, (ValaDataType*) _tmp118_, _tmp119_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp120_;
				_tmp121_ = actual_base_type;
				_tmp122_ = param;
				_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) _tmp122_);
				_tmp124_ = _tmp123_;
				if (!vala_data_type_equals (_tmp121_, _tmp124_)) {
					gchar* _tmp125_;
					_tmp125_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp125_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp126_ = param_index;
			param_index = _tmp126_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp127_ = method_params_it;
	if (vala_iterator_next (_tmp127_)) {
		gchar* _tmp128_;
		_tmp128_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp128_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp129_ = g_direct_equal;
	_tmp130_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp129_);
	base_method_errors = _tmp130_;
	_tmp131_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp131_, NULL);
	_tmp132_ = self->error_types;
	if (_tmp132_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp133_;
			ValaList* _tmp134_;
			gint _method_error_type_size = 0;
			ValaList* _tmp135_;
			gint _tmp136_;
			gint _tmp137_;
			gint _method_error_type_index = 0;
			_tmp133_ = self->error_types;
			_tmp134_ = _vala_iterable_ref0 (_tmp133_);
			_method_error_type_list = _tmp134_;
			_tmp135_ = _method_error_type_list;
			_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
			_tmp137_ = _tmp136_;
			_method_error_type_size = _tmp137_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp138_;
				gpointer _tmp139_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp138_ = _method_error_type_list;
				_tmp139_ = vala_list_get (_tmp138_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp139_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp140_;
					ValaArrayList* _tmp141_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp142_;
					gint _tmp143_;
					gint _tmp144_;
					gint _base_method_error_type_index = 0;
					_tmp140_ = base_method_errors;
					_tmp141_ = _vala_iterable_ref0 (_tmp140_);
					_base_method_error_type_list = _tmp141_;
					_tmp142_ = _base_method_error_type_list;
					_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
					_tmp144_ = _tmp143_;
					_base_method_error_type_size = _tmp144_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp145_;
						gpointer _tmp146_;
						ValaDataType* _tmp147_;
						ValaDataType* _tmp148_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp145_ = _base_method_error_type_list;
						_tmp146_ = vala_list_get ((ValaList*) _tmp145_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp146_;
						_tmp147_ = method_error_type;
						_tmp148_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp147_, _tmp148_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp149_;
					gchar* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					_tmp149_ = method_error_type;
					_tmp150_ = vala_code_node_to_string ((ValaCodeNode*) _tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = g_strdup_printf ("incompatible error type `%s'", _tmp151_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp152_;
					_g_free0 (_tmp151_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp153_ = base_method->priv->_coroutine;
	_tmp154_ = self->priv->_coroutine;
	if (_tmp153_ != _tmp154_) {
		gchar* _tmp155_;
		_tmp155_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp155_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp38_;
	ValaClass* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (VALA_IS_METHOD (_tmp12_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			ValaMethod* _tmp37_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_tmp37_ = base_method;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp37_, "CCode", "returns_floating_reference");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp38_ = vala_class_get_base_class (cl);
	_tmp39_ = _tmp38_;
	if (_tmp39_ != NULL) {
		ValaClass* _tmp40_;
		ValaClass* _tmp41_;
		_tmp40_ = vala_class_get_base_class (cl);
		_tmp41_ = _tmp40_;
		vala_method_find_base_class_method (self, _tmp41_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp4_ = _type_list;
			_tmp5_ = vala_list_get (_tmp4_, _type_index);
			type = (ValaDataType*) _tmp5_;
			_tmp6_ = type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (VALA_IS_INTERFACE (_tmp8_)) {
				gboolean _tmp9_ = FALSE;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaScope* _tmp22_;
				ValaScope* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp34_;
				_tmp10_ = vala_method_get_base_interface_type (self);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != NULL) {
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					_tmp12_ = vala_method_get_base_interface_type (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = vala_data_type_get_data_type (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = type;
					_tmp17_ = vala_data_type_get_data_type (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp9_ = _tmp15_ != _tmp18_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp19_ = type;
				_tmp20_ = vala_data_type_get_data_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_scope_lookup (_tmp23_, _tmp25_);
				sym = _tmp26_;
				_tmp27_ = sym;
				if (VALA_IS_SIGNAL (_tmp27_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp28_;
					ValaSignal* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp28_ = sym;
					_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp29_;
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
					_vala_code_node_unref0 (sig);
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					ValaMethod* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp35_ = sym;
					_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp36_;
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		ValaMethod* _tmp70_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_tmp70_ = base_match;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp70_, "CCode", "returns_floating_reference");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp71_ = FALSE;
		gboolean _tmp72_;
		gboolean _tmp73_;
		_tmp72_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp73_ = _tmp72_;
		if (!_tmp73_) {
			ValaMethod* _tmp74_;
			_tmp74_ = invalid_base_match;
			_tmp71_ = _tmp74_ != NULL;
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp75_;
			ValaMethodType* _tmp76_;
			ValaSourceReference* _tmp77_;
			ValaSourceReference* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			ValaMethodType* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			const gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp75_ = invalid_base_match;
			_tmp76_ = vala_method_type_new (_tmp75_);
			base_method_type = _tmp76_;
			_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp78_ = _tmp77_;
			_tmp79_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp80_ = _tmp79_;
			_tmp81_ = base_method_type;
			_tmp82_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp81_, NULL);
			_tmp83_ = _tmp82_;
			_tmp84_ = invalid_error;
			_tmp85_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp80_, _tmp83_, _tmp84_);
			_tmp86_ = _tmp85_;
			vala_report_error (_tmp78_, _tmp86_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp83_);
			_g_free0 (_tmp80_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp87_ = vala_method_get_base_interface_type (self);
	_tmp88_ = _tmp87_;
	if (_tmp88_ != NULL) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp92_);
		_tmp94_ = _tmp93_;
		vala_report_error (_tmp90_, _tmp94_);
		_g_free0 (_tmp94_);
		_g_free0 (_tmp92_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp110_;
	ValaSemanticAnalyzer* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSourceFile* _tmp113_;
	ValaSourceFile* _tmp114_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	ValaDataType* _tmp136_;
	ValaDataType* _tmp137_;
	ValaTypeSymbol* _tmp138_;
	ValaTypeSymbol* _tmp139_;
	ValaSemanticAnalyzer* _tmp140_;
	ValaSemanticAnalyzer* _tmp141_;
	ValaDataType* _tmp142_;
	ValaTypeSymbol* _tmp143_;
	ValaTypeSymbol* _tmp144_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp155_;
	ValaAttribute* _tmp156_;
	ValaAttribute* _tmp157_;
	ValaDataType* _tmp164_;
	ValaDataType* _tmp165_;
	gboolean _tmp168_ = FALSE;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_ = FALSE;
	ValaList* _tmp171_;
	gint _tmp172_;
	gint _tmp173_;
	gboolean _tmp187_ = FALSE;
	ValaAttribute* _tmp188_;
	gboolean optional_param = FALSE;
	gboolean _tmp260_;
	ValaList* _tmp274_;
	ValaLocalVariable* _tmp295_;
	ValaLocalVariable* _tmp296_;
	ValaList* _tmp299_;
	ValaList* _tmp308_;
	ValaBlock* _tmp317_;
	ValaBlock* _tmp318_;
	ValaSemanticAnalyzer* _tmp321_;
	ValaSemanticAnalyzer* _tmp322_;
	ValaStruct* _tmp323_;
	ValaStruct* _tmp324_;
	gboolean _tmp382_ = FALSE;
	gboolean _tmp383_ = FALSE;
	ValaDataType* _tmp384_;
	ValaDataType* _tmp385_;
	ValaSemanticAnalyzer* _tmp429_;
	ValaSemanticAnalyzer* _tmp430_;
	ValaSourceFile* _tmp431_;
	ValaSemanticAnalyzer* _tmp432_;
	ValaSemanticAnalyzer* _tmp433_;
	ValaSymbol* _tmp434_;
	gboolean _tmp435_ = FALSE;
	gboolean _tmp436_ = FALSE;
	gboolean _tmp437_ = FALSE;
	gboolean _tmp438_;
	gboolean _tmp439_;
	ValaSemanticAnalyzer* _tmp455_;
	ValaSemanticAnalyzer* _tmp456_;
	ValaDataType* _tmp457_;
	ValaDataType* _tmp458_;
	gboolean _tmp505_ = FALSE;
	ValaBlock* _tmp506_;
	ValaBlock* _tmp507_;
	gboolean _tmp548_ = FALSE;
	gboolean _tmp549_ = FALSE;
	gboolean _tmp550_ = FALSE;
	gboolean _tmp551_ = FALSE;
	gboolean _tmp552_ = FALSE;
	ValaAttribute* _tmp610_;
	gboolean _tmp611_;
	gboolean _tmp612_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (VALA_IS_CLASS (_tmp11_)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaClass* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaClass* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp17_;
		_tmp19_ = cl;
		_tmp20_ = vala_class_get_is_compact (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			_tmp22_ = cl;
			_tmp23_ = vala_class_get_base_class (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp29_ = self->priv->_is_abstract;
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp30_;
			_tmp30_ = self->priv->_is_virtual;
			_tmp28_ = _tmp30_;
		}
		_tmp27_ = _tmp28_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp32_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (VALA_IS_CLASS (_tmp35_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		_tmp78_ = self->priv->_is_abstract;
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			gboolean _tmp79_;
			_tmp79_ = self->priv->_is_virtual;
			_tmp77_ = _tmp79_;
		}
		if (_tmp77_) {
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp80_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp76_ = _tmp81_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp82_;
			ValaSourceReference* _tmp83_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp83_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp85_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaBlock* _tmp87_;
				ValaBlock* _tmp88_;
				_tmp87_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = _tmp88_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_;
				_tmp94_ = self->priv->_is_abstract;
				if (!_tmp94_) {
					gboolean _tmp95_;
					gboolean _tmp96_;
					_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp93_ = !_tmp96_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaSourceFileType _tmp97_;
					ValaSourceFileType _tmp98_;
					_tmp97_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp98_ = _tmp97_;
					_tmp92_ = _tmp98_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaBlock* _tmp99_;
					ValaBlock* _tmp100_;
					_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp100_ = _tmp99_;
					_tmp91_ = _tmp100_ == NULL;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp105_ = self->priv->_coroutine;
	if (_tmp105_) {
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp106_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		_tmp104_ = !_tmp107_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		_tmp103_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp109_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp110_ = vala_code_context_get_analyzer (context);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_semantic_analyzer_get_current_source_file (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_source_file_ref0 (_tmp113_);
	old_source_file = _tmp114_;
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_symbol (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (_tmp118_);
	old_symbol = _tmp119_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaSourceFile* _tmp126_;
		ValaSourceFile* _tmp127_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_source_reference_get_file (_tmp125_);
		_tmp127_ = _tmp126_;
		vala_semantic_analyzer_set_current_source_file (_tmp123_, _tmp127_);
	}
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, (ValaSymbol*) self);
	_tmp130_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_method_get_returns_floating_reference (self);
	_tmp133_ = _tmp132_;
	vala_data_type_set_floating_reference (_tmp131_, _tmp133_);
	_tmp134_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp135_ = _tmp134_;
	vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
	_tmp136_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_data_type_get_data_type (_tmp137_);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_code_context_get_analyzer (context);
	_tmp141_ = _tmp140_;
	_tmp142_ = _tmp141_->va_list_type;
	_tmp143_ = vala_data_type_get_data_type (_tmp142_);
	_tmp144_ = _tmp143_;
	if (_tmp139_ == _tmp144_) {
		ValaSourceReference* _tmp145_;
		ValaSourceReference* _tmp146_;
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		ValaTypeSymbol* _tmp149_;
		ValaTypeSymbol* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_data_type_get_data_type (_tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp150_);
		_tmp152_ = _tmp151_;
		_tmp153_ = g_strdup_printf ("`%s' not supported as return type", _tmp152_);
		_tmp154_ = _tmp153_;
		vala_report_error (_tmp146_, _tmp154_);
		_g_free0 (_tmp154_);
		_g_free0 (_tmp152_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp155_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp156_ = _vala_code_node_ref0 (_tmp155_);
	init_attr = _tmp156_;
	_tmp157_ = init_attr;
	if (_tmp157_ != NULL) {
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaSourceFile* _tmp160_;
		ValaSourceFile* _tmp161_;
		ValaCodeContext* _tmp162_;
		ValaCodeContext* _tmp163_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_source_reference_get_file (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_source_file_get_context (_tmp161_);
		_tmp163_ = _tmp162_;
		vala_code_context_set_module_init_method (_tmp163_, self);
	}
	_tmp164_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp165_ = _tmp164_;
	if (_tmp165_ != NULL) {
		ValaDataType* _tmp166_;
		ValaDataType* _tmp167_;
		_tmp166_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp167_ = _tmp166_;
		vala_code_node_check ((ValaCodeNode*) _tmp167_, context);
	}
	_tmp171_ = self->priv->parameters;
	_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
	_tmp173_ = _tmp172_;
	if (_tmp173_ == 1) {
		ValaList* _tmp174_;
		gpointer _tmp175_;
		ValaParameter* _tmp176_;
		gboolean _tmp177_;
		gboolean _tmp178_;
		_tmp174_ = self->priv->parameters;
		_tmp175_ = vala_list_get (_tmp174_, 0);
		_tmp176_ = (ValaParameter*) _tmp175_;
		_tmp177_ = vala_parameter_get_ellipsis (_tmp176_);
		_tmp178_ = _tmp177_;
		_tmp170_ = _tmp178_;
		_vala_code_node_unref0 (_tmp176_);
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaBlock* _tmp179_;
		ValaBlock* _tmp180_;
		_tmp179_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp180_ = _tmp179_;
		_tmp169_ = _tmp180_ != NULL;
	} else {
		_tmp169_ = FALSE;
	}
	if (_tmp169_) {
		ValaMemberBinding _tmp181_;
		_tmp181_ = self->priv->_binding;
		_tmp168_ = _tmp181_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		ValaList* _tmp182_;
		gpointer _tmp183_;
		ValaParameter* _tmp184_;
		ValaSourceReference* _tmp185_;
		ValaSourceReference* _tmp186_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp182_ = self->priv->parameters;
		_tmp183_ = vala_list_get (_tmp182_, 0);
		_tmp184_ = (ValaParameter*) _tmp183_;
		_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp184_);
		_tmp186_ = _tmp185_;
		vala_report_error (_tmp186_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp184_);
	}
	_tmp188_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp188_ != NULL) {
		gboolean _tmp189_ = FALSE;
		ValaList* _tmp190_;
		gint _tmp191_;
		gint _tmp192_;
		_tmp190_ = self->priv->parameters;
		_tmp191_ = vala_collection_get_size ((ValaCollection*) _tmp190_);
		_tmp192_ = _tmp191_;
		if (_tmp192_ != 1) {
			_tmp189_ = TRUE;
		} else {
			ValaList* _tmp193_;
			gpointer _tmp194_;
			ValaParameter* _tmp195_;
			ValaDataType* _tmp196_;
			ValaDataType* _tmp197_;
			ValaTypeSymbol* _tmp198_;
			ValaTypeSymbol* _tmp199_;
			ValaSemanticAnalyzer* _tmp200_;
			ValaSemanticAnalyzer* _tmp201_;
			ValaDataType* _tmp202_;
			ValaTypeSymbol* _tmp203_;
			ValaTypeSymbol* _tmp204_;
			_tmp193_ = self->priv->parameters;
			_tmp194_ = vala_list_get (_tmp193_, 0);
			_tmp195_ = (ValaParameter*) _tmp194_;
			_tmp196_ = vala_variable_get_variable_type ((ValaVariable*) _tmp195_);
			_tmp197_ = _tmp196_;
			_tmp198_ = vala_data_type_get_data_type (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_code_context_get_analyzer (context);
			_tmp201_ = _tmp200_;
			_tmp202_ = _tmp201_->string_type;
			_tmp203_ = vala_data_type_get_data_type (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp189_ = _tmp199_ != _tmp204_;
			_vala_code_node_unref0 (_tmp195_);
		}
		_tmp187_ = _tmp189_;
	} else {
		_tmp187_ = FALSE;
	}
	if (_tmp187_) {
		ValaSourceReference* _tmp205_;
		ValaSourceReference* _tmp206_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp206_ = _tmp205_;
		vala_report_error (_tmp206_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp207_;
		ValaList* _tmp208_;
		gint _param_size = 0;
		ValaList* _tmp209_;
		gint _tmp210_;
		gint _tmp211_;
		gint _param_index = 0;
		_tmp207_ = self->priv->parameters;
		_tmp208_ = _vala_iterable_ref0 (_tmp207_);
		_param_list = _tmp208_;
		_tmp209_ = _param_list;
		_tmp210_ = vala_collection_get_size ((ValaCollection*) _tmp209_);
		_tmp211_ = _tmp210_;
		_param_size = _tmp211_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp212_;
			gpointer _tmp213_;
			ValaParameter* _tmp214_;
			gboolean _tmp215_ = FALSE;
			gboolean _tmp216_;
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_ = FALSE;
			gboolean _tmp225_;
			gboolean _tmp226_;
			gboolean _tmp245_;
			gboolean _tmp246_ = FALSE;
			gboolean _tmp247_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp212_ = _param_list;
			_tmp213_ = vala_list_get (_tmp212_, _param_index);
			param = (ValaParameter*) _tmp213_;
			_tmp214_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp214_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp216_ = self->priv->_coroutine;
			if (_tmp216_) {
				ValaParameter* _tmp217_;
				ValaParameterDirection _tmp218_;
				ValaParameterDirection _tmp219_;
				_tmp217_ = param;
				_tmp218_ = vala_parameter_get_direction (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp215_ = _tmp219_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp215_ = FALSE;
			}
			if (_tmp215_) {
				ValaParameter* _tmp220_;
				ValaSourceReference* _tmp221_;
				ValaSourceReference* _tmp222_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp220_ = param;
				_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp220_);
				_tmp222_ = _tmp221_;
				vala_report_error (_tmp222_, "Reference parameters are not supported for async methods");
			}
			_tmp225_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp226_ = _tmp225_;
			if (!_tmp226_) {
				gboolean _tmp227_;
				_tmp227_ = self->priv->_coroutine;
				_tmp224_ = _tmp227_;
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				gboolean _tmp228_ = FALSE;
				ValaParameter* _tmp229_;
				gboolean _tmp230_;
				gboolean _tmp231_;
				_tmp229_ = param;
				_tmp230_ = vala_parameter_get_ellipsis (_tmp229_);
				_tmp231_ = _tmp230_;
				if (_tmp231_) {
					_tmp228_ = TRUE;
				} else {
					ValaParameter* _tmp232_;
					ValaDataType* _tmp233_;
					ValaDataType* _tmp234_;
					ValaTypeSymbol* _tmp235_;
					ValaTypeSymbol* _tmp236_;
					ValaSemanticAnalyzer* _tmp237_;
					ValaSemanticAnalyzer* _tmp238_;
					ValaDataType* _tmp239_;
					ValaTypeSymbol* _tmp240_;
					ValaTypeSymbol* _tmp241_;
					_tmp232_ = param;
					_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) _tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_data_type_get_data_type (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = vala_code_context_get_analyzer (context);
					_tmp238_ = _tmp237_;
					_tmp239_ = _tmp238_->va_list_type;
					_tmp240_ = vala_data_type_get_data_type (_tmp239_);
					_tmp241_ = _tmp240_;
					_tmp228_ = _tmp236_ == _tmp241_;
				}
				_tmp223_ = _tmp228_;
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaParameter* _tmp242_;
				ValaSourceReference* _tmp243_;
				ValaSourceReference* _tmp244_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp242_ = param;
				_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp242_);
				_tmp244_ = _tmp243_;
				vala_report_error (_tmp244_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp245_ = self->priv->_coroutine;
			if (_tmp245_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp248_;
				ValaExpression* _tmp249_;
				ValaExpression* _tmp250_;
				_tmp248_ = param;
				_tmp249_ = vala_variable_get_initializer ((ValaVariable*) _tmp248_);
				_tmp250_ = _tmp249_;
				_tmp247_ = _tmp250_ == NULL;
			} else {
				_tmp247_ = FALSE;
			}
			if (_tmp247_) {
				ValaParameter* _tmp251_;
				gboolean _tmp252_;
				gboolean _tmp253_;
				_tmp251_ = param;
				_tmp252_ = vala_parameter_get_ellipsis (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp246_ = !_tmp253_;
			} else {
				_tmp246_ = FALSE;
			}
			if (_tmp246_) {
				ValaParameter* _tmp254_;
				ValaSourceReference* _tmp255_;
				ValaSourceReference* _tmp256_;
				_tmp254_ = param;
				_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp254_);
				_tmp256_ = _tmp255_;
				vala_report_warning (_tmp256_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp257_;
				ValaExpression* _tmp258_;
				ValaExpression* _tmp259_;
				_tmp257_ = param;
				_tmp258_ = vala_variable_get_initializer ((ValaVariable*) _tmp257_);
				_tmp259_ = _tmp258_;
				if (_tmp259_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp260_ = self->priv->_coroutine;
	if (_tmp260_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp261_;
			gint _tmp262_;
			gint _tmp263_;
			_tmp261_ = self->priv->parameters;
			_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
			_tmp263_ = _tmp262_;
			i = _tmp263_ - 1;
			{
				gboolean _tmp264_ = FALSE;
				_tmp264_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp266_;
					gpointer _tmp267_;
					ValaParameter* _tmp268_;
					ValaParameterDirection _tmp269_;
					ValaParameterDirection _tmp270_;
					if (!_tmp264_) {
						gint _tmp265_;
						_tmp265_ = i;
						i = _tmp265_ - 1;
					}
					_tmp264_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp266_ = self->priv->parameters;
					_tmp267_ = vala_list_get (_tmp266_, i);
					param = (ValaParameter*) _tmp267_;
					_tmp268_ = param;
					_tmp269_ = vala_parameter_get_direction (_tmp268_);
					_tmp270_ = _tmp269_;
					if (_tmp270_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp271_;
							ValaSourceReference* _tmp272_;
							ValaSourceReference* _tmp273_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp271_ = param;
							_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp271_);
							_tmp273_ = _tmp272_;
							vala_report_error (_tmp273_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp274_ = self->error_types;
	if (_tmp274_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp275_;
			ValaList* _tmp276_;
			gint _error_type_size = 0;
			ValaList* _tmp277_;
			gint _tmp278_;
			gint _tmp279_;
			gint _error_type_index = 0;
			_tmp275_ = self->error_types;
			_tmp276_ = _vala_iterable_ref0 (_tmp275_);
			_error_type_list = _tmp276_;
			_tmp277_ = _error_type_list;
			_tmp278_ = vala_collection_get_size ((ValaCollection*) _tmp277_);
			_tmp279_ = _tmp278_;
			_error_type_size = _tmp279_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp280_;
				gpointer _tmp281_;
				ValaDataType* _tmp282_;
				ValaSemanticAnalyzer* _tmp283_;
				ValaSemanticAnalyzer* _tmp284_;
				ValaDataType* _tmp285_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp280_ = _error_type_list;
				_tmp281_ = vala_list_get (_tmp280_, _error_type_index);
				error_type = (ValaDataType*) _tmp281_;
				_tmp282_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp282_, context);
				_tmp283_ = vala_code_context_get_analyzer (context);
				_tmp284_ = _tmp283_;
				_tmp285_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp284_, (ValaSymbol*) self, _tmp285_)) {
					ValaSourceReference* _tmp286_;
					ValaSourceReference* _tmp287_;
					ValaDataType* _tmp288_;
					gchar* _tmp289_;
					gchar* _tmp290_;
					gchar* _tmp291_;
					gchar* _tmp292_;
					gchar* _tmp293_;
					gchar* _tmp294_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp286_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp287_ = _tmp286_;
					_tmp288_ = error_type;
					_tmp289_ = vala_code_node_to_string ((ValaCodeNode*) _tmp288_);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp292_ = _tmp291_;
					_tmp293_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp290_, _tmp292_);
					_tmp294_ = _tmp293_;
					vala_report_error (_tmp287_, _tmp294_);
					_g_free0 (_tmp294_);
					_g_free0 (_tmp292_);
					_g_free0 (_tmp290_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp295_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp296_ = _tmp295_;
	if (_tmp296_ != NULL) {
		ValaLocalVariable* _tmp297_;
		ValaLocalVariable* _tmp298_;
		_tmp297_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp298_ = _tmp297_;
		vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
	}
	_tmp299_ = self->priv->preconditions;
	if (_tmp299_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp300_;
			ValaList* _tmp301_;
			gint _precondition_size = 0;
			ValaList* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gint _precondition_index = 0;
			_tmp300_ = self->priv->preconditions;
			_tmp301_ = _vala_iterable_ref0 (_tmp300_);
			_precondition_list = _tmp301_;
			_tmp302_ = _precondition_list;
			_tmp303_ = vala_collection_get_size ((ValaCollection*) _tmp302_);
			_tmp304_ = _tmp303_;
			_precondition_size = _tmp304_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp305_;
				gpointer _tmp306_;
				ValaExpression* _tmp307_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp305_ = _precondition_list;
				_tmp306_ = vala_list_get (_tmp305_, _precondition_index);
				precondition = (ValaExpression*) _tmp306_;
				_tmp307_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp307_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp308_ = self->priv->postconditions;
	if (_tmp308_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp309_;
			ValaList* _tmp310_;
			gint _postcondition_size = 0;
			ValaList* _tmp311_;
			gint _tmp312_;
			gint _tmp313_;
			gint _postcondition_index = 0;
			_tmp309_ = self->priv->postconditions;
			_tmp310_ = _vala_iterable_ref0 (_tmp309_);
			_postcondition_list = _tmp310_;
			_tmp311_ = _postcondition_list;
			_tmp312_ = vala_collection_get_size ((ValaCollection*) _tmp311_);
			_tmp313_ = _tmp312_;
			_postcondition_size = _tmp313_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp314_;
				gpointer _tmp315_;
				ValaExpression* _tmp316_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp314_ = _postcondition_list;
				_tmp315_ = vala_list_get (_tmp314_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp315_;
				_tmp316_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp316_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp317_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp318_ = _tmp317_;
	if (_tmp318_ != NULL) {
		ValaBlock* _tmp319_;
		ValaBlock* _tmp320_;
		_tmp319_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp320_ = _tmp319_;
		vala_code_node_check ((ValaCodeNode*) _tmp320_, context);
	}
	_tmp321_ = vala_code_context_get_analyzer (context);
	_tmp322_ = _tmp321_;
	_tmp323_ = vala_semantic_analyzer_get_current_struct (_tmp322_);
	_tmp324_ = _tmp323_;
	if (_tmp324_ != NULL) {
		gboolean _tmp325_ = FALSE;
		gboolean _tmp326_ = FALSE;
		gboolean _tmp327_;
		_tmp327_ = self->priv->_is_abstract;
		if (_tmp327_) {
			_tmp326_ = TRUE;
		} else {
			gboolean _tmp328_;
			_tmp328_ = self->priv->_is_virtual;
			_tmp326_ = _tmp328_;
		}
		if (_tmp326_) {
			_tmp325_ = TRUE;
		} else {
			gboolean _tmp329_;
			_tmp329_ = self->priv->_overrides;
			_tmp325_ = _tmp329_;
		}
		if (_tmp325_) {
			ValaSourceReference* _tmp330_;
			ValaSourceReference* _tmp331_;
			gchar* _tmp332_;
			gchar* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp330_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp331_ = _tmp330_;
			_tmp332_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp333_ = _tmp332_;
			_tmp334_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp333_);
			_tmp335_ = _tmp334_;
			vala_report_error (_tmp331_, _tmp335_);
			_g_free0 (_tmp335_);
			_g_free0 (_tmp333_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp336_ = FALSE;
		gboolean _tmp337_ = FALSE;
		gboolean _tmp338_ = FALSE;
		gboolean _tmp339_;
		_tmp339_ = self->priv->_overrides;
		if (_tmp339_) {
			ValaMethod* _tmp340_;
			ValaMethod* _tmp341_;
			_tmp340_ = vala_method_get_base_method (self);
			_tmp341_ = _tmp340_;
			_tmp338_ = _tmp341_ == NULL;
		} else {
			_tmp338_ = FALSE;
		}
		if (_tmp338_) {
			ValaMethod* _tmp342_;
			ValaMethod* _tmp343_;
			_tmp342_ = vala_method_get_base_interface_method (self);
			_tmp343_ = _tmp342_;
			_tmp337_ = _tmp343_ != NULL;
		} else {
			_tmp337_ = FALSE;
		}
		if (_tmp337_) {
			ValaMethod* _tmp344_;
			ValaMethod* _tmp345_;
			gboolean _tmp346_;
			_tmp344_ = vala_method_get_base_interface_method (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = _tmp345_->priv->_is_abstract;
			_tmp336_ = _tmp346_;
		} else {
			_tmp336_ = FALSE;
		}
		if (_tmp336_) {
			ValaSourceReference* _tmp347_;
			ValaSourceReference* _tmp348_;
			ValaMethod* _tmp349_;
			ValaMethod* _tmp350_;
			gchar* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			_tmp347_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp348_ = _tmp347_;
			_tmp349_ = vala_method_get_base_interface_method (self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp350_);
			_tmp352_ = _tmp351_;
			_tmp353_ = g_strdup_printf ("`override' not required to implement `abstract' interface method `%s'", _tmp352_);
			_tmp354_ = _tmp353_;
			vala_report_warning (_tmp348_, _tmp354_);
			_g_free0 (_tmp354_);
			_g_free0 (_tmp352_);
			vala_method_set_overrides (self, FALSE);
		} else {
			gboolean _tmp355_ = FALSE;
			gboolean _tmp356_ = FALSE;
			gboolean _tmp357_;
			_tmp357_ = self->priv->_overrides;
			if (_tmp357_) {
				ValaMethod* _tmp358_;
				ValaMethod* _tmp359_;
				_tmp358_ = vala_method_get_base_method (self);
				_tmp359_ = _tmp358_;
				_tmp356_ = _tmp359_ == NULL;
			} else {
				_tmp356_ = FALSE;
			}
			if (_tmp356_) {
				ValaMethod* _tmp360_;
				ValaMethod* _tmp361_;
				_tmp360_ = vala_method_get_base_interface_method (self);
				_tmp361_ = _tmp360_;
				_tmp355_ = _tmp361_ == NULL;
			} else {
				_tmp355_ = FALSE;
			}
			if (_tmp355_) {
				ValaSourceReference* _tmp362_;
				ValaSourceReference* _tmp363_;
				gchar* _tmp364_;
				gchar* _tmp365_;
				gchar* _tmp366_;
				gchar* _tmp367_;
				_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp363_ = _tmp362_;
				_tmp364_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp365_ = _tmp364_;
				_tmp366_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp365_);
				_tmp367_ = _tmp366_;
				vala_report_error (_tmp363_, _tmp367_);
				_g_free0 (_tmp367_);
				_g_free0 (_tmp365_);
			} else {
				gboolean _tmp368_ = FALSE;
				gboolean _tmp369_ = FALSE;
				gboolean _tmp370_ = FALSE;
				gboolean _tmp371_;
				_tmp371_ = self->priv->_is_abstract;
				if (_tmp371_) {
					_tmp370_ = TRUE;
				} else {
					gboolean _tmp372_;
					_tmp372_ = self->priv->_is_virtual;
					_tmp370_ = _tmp372_;
				}
				if (_tmp370_) {
					_tmp369_ = TRUE;
				} else {
					gboolean _tmp373_;
					_tmp373_ = self->priv->_overrides;
					_tmp369_ = _tmp373_;
				}
				if (_tmp369_) {
					ValaSymbolAccessibility _tmp374_;
					ValaSymbolAccessibility _tmp375_;
					_tmp374_ = vala_symbol_get_access ((ValaSymbol*) self);
					_tmp375_ = _tmp374_;
					_tmp368_ = _tmp375_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp368_ = FALSE;
				}
				if (_tmp368_) {
					ValaSourceReference* _tmp376_;
					ValaSourceReference* _tmp377_;
					gchar* _tmp378_;
					gchar* _tmp379_;
					gchar* _tmp380_;
					gchar* _tmp381_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp376_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp377_ = _tmp376_;
					_tmp378_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp379_ = _tmp378_;
					_tmp380_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp379_);
					_tmp381_ = _tmp380_;
					vala_report_error (_tmp377_, _tmp381_);
					_g_free0 (_tmp381_);
					_g_free0 (_tmp379_);
					result = FALSE;
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
		}
	}
	_tmp384_ = vala_method_get_base_interface_type (self);
	_tmp385_ = _tmp384_;
	if (_tmp385_ != NULL) {
		ValaMethod* _tmp386_;
		ValaMethod* _tmp387_;
		_tmp386_ = vala_method_get_base_interface_method (self);
		_tmp387_ = _tmp386_;
		_tmp383_ = _tmp387_ != NULL;
	} else {
		_tmp383_ = FALSE;
	}
	if (_tmp383_) {
		ValaSymbol* _tmp388_;
		ValaSymbol* _tmp389_;
		_tmp388_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp389_ = _tmp388_;
		_tmp382_ = VALA_IS_CLASS (_tmp389_);
	} else {
		_tmp382_ = FALSE;
	}
	if (_tmp382_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp390_;
		ValaSymbol* _tmp391_;
		ValaClass* _tmp392_;
		_tmp390_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp391_ = _tmp390_;
		_tmp392_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp391_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp392_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp393_;
			ValaList* _tmp394_;
			gint _m_size = 0;
			ValaList* _tmp395_;
			gint _tmp396_;
			gint _tmp397_;
			gint _m_index = 0;
			_tmp393_ = cl;
			_tmp394_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp393_);
			_m_list = _tmp394_;
			_tmp395_ = _m_list;
			_tmp396_ = vala_collection_get_size ((ValaCollection*) _tmp395_);
			_tmp397_ = _tmp396_;
			_m_size = _tmp397_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp398_;
				gpointer _tmp399_;
				gboolean _tmp400_ = FALSE;
				ValaMethod* _tmp401_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp398_ = _m_list;
				_tmp399_ = vala_list_get (_tmp398_, _m_index);
				m = (ValaMethod*) _tmp399_;
				_tmp401_ = m;
				if (_tmp401_ != self) {
					ValaMethod* _tmp402_;
					ValaMethod* _tmp403_;
					ValaMethod* _tmp404_;
					ValaMethod* _tmp405_;
					ValaMethod* _tmp406_;
					_tmp402_ = m;
					_tmp403_ = vala_method_get_base_interface_method (_tmp402_);
					_tmp404_ = _tmp403_;
					_tmp405_ = vala_method_get_base_interface_method (self);
					_tmp406_ = _tmp405_;
					_tmp400_ = _tmp404_ == _tmp406_;
				} else {
					_tmp400_ = FALSE;
				}
				if (_tmp400_) {
					ValaMethod* _tmp407_;
					ValaMethod* _tmp408_;
					ValaSourceReference* _tmp409_;
					ValaSourceReference* _tmp410_;
					ValaClass* _tmp411_;
					gchar* _tmp412_;
					gchar* _tmp413_;
					ValaMethod* _tmp414_;
					ValaMethod* _tmp415_;
					gchar* _tmp416_;
					gchar* _tmp417_;
					gchar* _tmp418_;
					gchar* _tmp419_;
					ValaMethod* _tmp420_;
					ValaSourceReference* _tmp421_;
					ValaSourceReference* _tmp422_;
					ValaMethod* _tmp423_;
					ValaMethod* _tmp424_;
					gchar* _tmp425_;
					gchar* _tmp426_;
					gchar* _tmp427_;
					gchar* _tmp428_;
					_tmp407_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp407_, TRUE);
					_tmp408_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp408_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp409_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp410_ = _tmp409_;
					_tmp411_ = cl;
					_tmp412_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp411_);
					_tmp413_ = _tmp412_;
					_tmp414_ = vala_method_get_base_interface_method (self);
					_tmp415_ = _tmp414_;
					_tmp416_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp415_);
					_tmp417_ = _tmp416_;
					_tmp418_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp413_, _tmp417_);
					_tmp419_ = _tmp418_;
					vala_report_error (_tmp410_, _tmp419_);
					_g_free0 (_tmp419_);
					_g_free0 (_tmp417_);
					_g_free0 (_tmp413_);
					_tmp420_ = m;
					_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp420_);
					_tmp422_ = _tmp421_;
					_tmp423_ = vala_method_get_base_interface_method (self);
					_tmp424_ = _tmp423_;
					_tmp425_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp424_);
					_tmp426_ = _tmp425_;
					_tmp427_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp426_);
					_tmp428_ = _tmp427_;
					vala_report_notice (_tmp422_, _tmp428_);
					_g_free0 (_tmp428_);
					_g_free0 (_tmp426_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp429_ = vala_code_context_get_analyzer (context);
	_tmp430_ = _tmp429_;
	_tmp431_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp430_, _tmp431_);
	_tmp432_ = vala_code_context_get_analyzer (context);
	_tmp433_ = _tmp432_;
	_tmp434_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp433_, _tmp434_);
	_tmp438_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp439_ = _tmp438_;
	if (!_tmp439_) {
		gboolean _tmp440_;
		_tmp440_ = self->priv->_overrides;
		_tmp437_ = !_tmp440_;
	} else {
		_tmp437_ = FALSE;
	}
	if (_tmp437_) {
		gboolean _tmp441_;
		gboolean _tmp442_;
		_tmp441_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp442_ = _tmp441_;
		_tmp436_ = !_tmp442_;
	} else {
		_tmp436_ = FALSE;
	}
	if (_tmp436_) {
		ValaSymbol* _tmp443_;
		ValaSymbol* _tmp444_;
		_tmp443_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp444_ = _tmp443_;
		_tmp435_ = _tmp444_ != NULL;
		_vala_code_node_unref0 (_tmp444_);
	} else {
		_tmp435_ = FALSE;
	}
	if (_tmp435_) {
		ValaSourceReference* _tmp445_;
		ValaSourceReference* _tmp446_;
		gchar* _tmp447_;
		gchar* _tmp448_;
		ValaSymbol* _tmp449_;
		ValaSymbol* _tmp450_;
		gchar* _tmp451_;
		gchar* _tmp452_;
		gchar* _tmp453_;
		gchar* _tmp454_;
		_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp446_ = _tmp445_;
		_tmp447_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp448_ = _tmp447_;
		_tmp449_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_symbol_get_full_name (_tmp450_);
		_tmp452_ = _tmp451_;
		_tmp453_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp448_, _tmp452_);
		_tmp454_ = _tmp453_;
		vala_report_warning (_tmp446_, _tmp454_);
		_g_free0 (_tmp454_);
		_g_free0 (_tmp452_);
		_vala_code_node_unref0 (_tmp450_);
		_g_free0 (_tmp448_);
	}
	_tmp455_ = vala_code_context_get_analyzer (context);
	_tmp456_ = _tmp455_;
	_tmp457_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp458_ = _tmp457_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp456_, (ValaSymbol*) self, _tmp458_)) {
		ValaSourceReference* _tmp459_;
		ValaSourceReference* _tmp460_;
		ValaDataType* _tmp461_;
		ValaDataType* _tmp462_;
		gchar* _tmp463_;
		gchar* _tmp464_;
		gchar* _tmp465_;
		gchar* _tmp466_;
		gchar* _tmp467_;
		gchar* _tmp468_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp459_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp462_ = _tmp461_;
		_tmp463_ = vala_code_node_to_string ((ValaCodeNode*) _tmp462_);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp466_ = _tmp465_;
		_tmp467_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp464_, _tmp466_);
		_tmp468_ = _tmp467_;
		vala_report_error (_tmp460_, _tmp468_);
		_g_free0 (_tmp468_);
		_g_free0 (_tmp466_);
		_g_free0 (_tmp464_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp469_;
		gint _precondition_size = 0;
		ValaList* _tmp470_;
		gint _tmp471_;
		gint _tmp472_;
		gint _precondition_index = 0;
		_tmp469_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp469_;
		_tmp470_ = _precondition_list;
		_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
		_tmp472_ = _tmp471_;
		_precondition_size = _tmp472_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp473_;
			gpointer _tmp474_;
			ValaExpression* _tmp475_;
			gboolean _tmp476_;
			gboolean _tmp477_;
			ValaExpression* _tmp478_;
			ValaDataType* _tmp479_;
			ValaDataType* _tmp480_;
			ValaSemanticAnalyzer* _tmp481_;
			ValaSemanticAnalyzer* _tmp482_;
			ValaDataType* _tmp483_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp473_ = _precondition_list;
			_tmp474_ = vala_list_get (_tmp473_, _precondition_index);
			precondition = (ValaExpression*) _tmp474_;
			_tmp475_ = precondition;
			_tmp476_ = vala_code_node_get_error ((ValaCodeNode*) _tmp475_);
			_tmp477_ = _tmp476_;
			if (_tmp477_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp478_ = precondition;
			_tmp479_ = vala_expression_get_value_type (_tmp478_);
			_tmp480_ = _tmp479_;
			_tmp481_ = vala_code_context_get_analyzer (context);
			_tmp482_ = _tmp481_;
			_tmp483_ = _tmp482_->bool_type;
			if (!vala_data_type_compatible (_tmp480_, _tmp483_)) {
				ValaExpression* _tmp484_;
				ValaSourceReference* _tmp485_;
				ValaSourceReference* _tmp486_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp484_ = precondition;
				_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp484_);
				_tmp486_ = _tmp485_;
				vala_report_error (_tmp486_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp487_;
		gint _postcondition_size = 0;
		ValaList* _tmp488_;
		gint _tmp489_;
		gint _tmp490_;
		gint _postcondition_index = 0;
		_tmp487_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp487_;
		_tmp488_ = _postcondition_list;
		_tmp489_ = vala_collection_get_size ((ValaCollection*) _tmp488_);
		_tmp490_ = _tmp489_;
		_postcondition_size = _tmp490_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp491_;
			gpointer _tmp492_;
			ValaExpression* _tmp493_;
			gboolean _tmp494_;
			gboolean _tmp495_;
			ValaExpression* _tmp496_;
			ValaDataType* _tmp497_;
			ValaDataType* _tmp498_;
			ValaSemanticAnalyzer* _tmp499_;
			ValaSemanticAnalyzer* _tmp500_;
			ValaDataType* _tmp501_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp491_ = _postcondition_list;
			_tmp492_ = vala_list_get (_tmp491_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp492_;
			_tmp493_ = postcondition;
			_tmp494_ = vala_code_node_get_error ((ValaCodeNode*) _tmp493_);
			_tmp495_ = _tmp494_;
			if (_tmp495_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp496_ = postcondition;
			_tmp497_ = vala_expression_get_value_type (_tmp496_);
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_code_context_get_analyzer (context);
			_tmp500_ = _tmp499_;
			_tmp501_ = _tmp500_->bool_type;
			if (!vala_data_type_compatible (_tmp498_, _tmp501_)) {
				ValaExpression* _tmp502_;
				ValaSourceReference* _tmp503_;
				ValaSourceReference* _tmp504_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp502_ = postcondition;
				_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp502_);
				_tmp504_ = _tmp503_;
				vala_report_error (_tmp504_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp506_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp507_ = _tmp506_;
	if (_tmp507_ != NULL) {
		ValaBlock* _tmp508_;
		ValaBlock* _tmp509_;
		gboolean _tmp510_;
		gboolean _tmp511_;
		_tmp508_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp509_ = _tmp508_;
		_tmp510_ = vala_code_node_get_error ((ValaCodeNode*) _tmp509_);
		_tmp511_ = _tmp510_;
		_tmp505_ = !_tmp511_;
	} else {
		_tmp505_ = FALSE;
	}
	if (_tmp505_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp512_;
		ValaArrayList* _tmp513_;
		ValaBlock* _tmp514_;
		ValaBlock* _tmp515_;
		ValaArrayList* _tmp516_;
		_tmp512_ = g_direct_equal;
		_tmp513_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp512_);
		body_errors = _tmp513_;
		_tmp514_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp515_ = _tmp514_;
		_tmp516_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp515_, (ValaCollection*) _tmp516_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp517_;
			ValaArrayList* _tmp518_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp519_;
			gint _tmp520_;
			gint _tmp521_;
			gint _body_error_type_index = 0;
			_tmp517_ = body_errors;
			_tmp518_ = _vala_iterable_ref0 (_tmp517_);
			_body_error_type_list = _tmp518_;
			_tmp519_ = _body_error_type_list;
			_tmp520_ = vala_collection_get_size ((ValaCollection*) _tmp519_);
			_tmp521_ = _tmp520_;
			_body_error_type_size = _tmp521_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp522_;
				gpointer _tmp523_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp524_;
				gboolean _tmp534_ = FALSE;
				ValaDataType* _tmp535_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp539_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp522_ = _body_error_type_list;
				_tmp523_ = vala_list_get ((ValaList*) _tmp522_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp523_;
				can_propagate_error = FALSE;
				_tmp524_ = self->error_types;
				if (_tmp524_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp525_;
						ValaList* _tmp526_;
						gint _method_error_type_size = 0;
						ValaList* _tmp527_;
						gint _tmp528_;
						gint _tmp529_;
						gint _method_error_type_index = 0;
						_tmp525_ = self->error_types;
						_tmp526_ = _vala_iterable_ref0 (_tmp525_);
						_method_error_type_list = _tmp526_;
						_tmp527_ = _method_error_type_list;
						_tmp528_ = vala_collection_get_size ((ValaCollection*) _tmp527_);
						_tmp529_ = _tmp528_;
						_method_error_type_size = _tmp529_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp530_;
							gpointer _tmp531_;
							ValaDataType* _tmp532_;
							ValaDataType* _tmp533_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp530_ = _method_error_type_list;
							_tmp531_ = vala_list_get (_tmp530_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp531_;
							_tmp532_ = body_error_type;
							_tmp533_ = method_error_type;
							if (vala_data_type_compatible (_tmp532_, _tmp533_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp535_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp535_)) {
					ValaDataType* _tmp536_;
					gboolean _tmp537_;
					gboolean _tmp538_;
					_tmp536_ = body_error_type;
					_tmp537_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp536_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp538_ = _tmp537_;
					_tmp534_ = _tmp538_;
				} else {
					_tmp534_ = FALSE;
				}
				is_dynamic_error = _tmp534_;
				if (!can_propagate_error) {
					_tmp539_ = !is_dynamic_error;
				} else {
					_tmp539_ = FALSE;
				}
				if (_tmp539_) {
					ValaDataType* _tmp540_;
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaDataType* _tmp543_;
					gchar* _tmp544_;
					gchar* _tmp545_;
					gchar* _tmp546_;
					gchar* _tmp547_;
					_tmp540_ = body_error_type;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = body_error_type;
					_tmp544_ = vala_code_node_to_string ((ValaCodeNode*) _tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = g_strdup_printf ("unhandled error `%s'", _tmp545_);
					_tmp547_ = _tmp546_;
					vala_report_warning (_tmp542_, _tmp547_);
					_g_free0 (_tmp547_);
					_g_free0 (_tmp545_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp553_;
		_tmp553_ = self->priv->_binding;
		_tmp552_ = _tmp553_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp552_ = FALSE;
	}
	if (_tmp552_) {
		gboolean _tmp554_;
		_tmp554_ = self->priv->_overrides;
		_tmp551_ = !_tmp554_;
	} else {
		_tmp551_ = FALSE;
	}
	if (_tmp551_) {
		ValaSymbolAccessibility _tmp555_;
		ValaSymbolAccessibility _tmp556_;
		_tmp555_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp556_ = _tmp555_;
		_tmp550_ = _tmp556_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp550_ = FALSE;
	}
	if (_tmp550_) {
		ValaSymbol* _tmp557_;
		ValaSymbol* _tmp558_;
		_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp558_ = _tmp557_;
		_tmp549_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp558_);
	} else {
		_tmp549_ = FALSE;
	}
	if (_tmp549_) {
		ValaSymbol* _tmp559_;
		ValaSymbol* _tmp560_;
		ValaAttribute* _tmp561_;
		_tmp559_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp560_ = _tmp559_;
		_tmp561_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp560_, "DBus");
		_tmp548_ = _tmp561_ != NULL;
	} else {
		_tmp548_ = FALSE;
	}
	if (_tmp548_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp562_;
		ValaAttribute* _tmp563_;
		gboolean _tmp564_ = FALSE;
		ValaAttribute* _tmp565_;
		_tmp562_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp563_ = _vala_code_node_ref0 (_tmp562_);
		dbus_attr = _tmp563_;
		_tmp565_ = dbus_attr;
		if (_tmp565_ == NULL) {
			_tmp564_ = TRUE;
		} else {
			ValaAttribute* _tmp566_;
			_tmp566_ = dbus_attr;
			_tmp564_ = vala_attribute_get_bool (_tmp566_, "visible", TRUE);
		}
		if (_tmp564_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp567_;
			ValaArrayList* _tmp568_;
			ValaArrayList* _tmp569_;
			gboolean _tmp586_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp567_ = g_direct_equal;
			_tmp568_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp567_);
			error_types = _tmp568_;
			_tmp569_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp569_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp570_;
				ValaArrayList* _tmp571_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp572_;
				gint _tmp573_;
				gint _tmp574_;
				gint _error_type_index = 0;
				_tmp570_ = error_types;
				_tmp571_ = _vala_iterable_ref0 (_tmp570_);
				_error_type_list = _tmp571_;
				_tmp572_ = _error_type_list;
				_tmp573_ = vala_collection_get_size ((ValaCollection*) _tmp572_);
				_tmp574_ = _tmp573_;
				_error_type_size = _tmp574_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp575_;
					gpointer _tmp576_;
					ValaDataType* _tmp577_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp578_;
					ValaErrorDomain* _tmp579_;
					ValaErrorDomain* _tmp580_;
					ValaErrorDomain* _tmp581_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp582_;
					gchar* _tmp583_;
					const gchar* _tmp584_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp575_ = _error_type_list;
					_tmp576_ = vala_list_get ((ValaList*) _tmp575_, _error_type_index);
					error_type = (ValaDataType*) _tmp576_;
					_tmp577_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp577_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp578_ = error_type;
					_tmp579_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp578_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp580_ = _tmp579_;
					error_domain = _tmp580_;
					_tmp581_ = error_domain;
					if (_tmp581_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp582_ = error_domain;
					_tmp583_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp582_);
					full_error_domain = _tmp583_;
					_tmp584_ = full_error_domain;
					if (g_strcmp0 (_tmp584_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp585_;
						_tmp585_ = full_error_domain;
						if (g_strcmp0 (_tmp585_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp587_ = FALSE;
				if (throws_gioerror) {
					_tmp587_ = throws_gdbuserror;
				} else {
					_tmp587_ = FALSE;
				}
				_tmp586_ = !_tmp587_;
			} else {
				_tmp586_ = FALSE;
			}
			if (_tmp586_) {
				ValaSourceReference* _tmp588_;
				ValaSourceReference* _tmp589_;
				_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp589_ = _tmp588_;
				vala_report_warning (_tmp589_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp590_;
		ValaMethod* _tmp591_;
		gboolean _tmp600_;
		gboolean _tmp601_;
		gboolean _tmp604_;
		gboolean _tmp607_;
		_tmp590_ = vala_code_context_get_entry_point (context);
		_tmp591_ = _tmp590_;
		if (_tmp591_ != NULL) {
			ValaSourceReference* _tmp592_;
			ValaSourceReference* _tmp593_;
			ValaMethod* _tmp594_;
			ValaMethod* _tmp595_;
			gchar* _tmp596_;
			gchar* _tmp597_;
			gchar* _tmp598_;
			gchar* _tmp599_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp593_ = _tmp592_;
			_tmp594_ = vala_code_context_get_entry_point (context);
			_tmp595_ = _tmp594_;
			_tmp596_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp595_);
			_tmp597_ = _tmp596_;
			_tmp598_ = g_strdup_printf ("program already has an entry point `%s'", _tmp597_);
			_tmp599_ = _tmp598_;
			vala_report_error (_tmp593_, _tmp599_);
			_g_free0 (_tmp599_);
			_g_free0 (_tmp597_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp600_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp601_ = _tmp600_;
		if (_tmp601_) {
			ValaSourceReference* _tmp602_;
			ValaSourceReference* _tmp603_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp603_ = _tmp602_;
			vala_report_error (_tmp603_, "\"main\" method cannot throw errors");
		}
		_tmp604_ = self->priv->_is_inline;
		if (_tmp604_) {
			ValaSourceReference* _tmp605_;
			ValaSourceReference* _tmp606_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp605_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp606_ = _tmp605_;
			vala_report_error (_tmp606_, "\"main\" method cannot be inline");
		}
		_tmp607_ = self->priv->_coroutine;
		if (_tmp607_) {
			ValaSourceReference* _tmp608_;
			ValaSourceReference* _tmp609_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp608_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp609_ = _tmp608_;
			vala_report_error (_tmp609_, "\"main\" method cannot be async");
		}
	}
	_tmp610_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp610_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp611_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp612_ = _tmp611_;
	result = !_tmp612_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!VALA_IS_ARRAY_TYPE (_tmp43_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp30_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			gint _param_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_param_list = _tmp22_;
			_tmp23_ = _param_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_param_size = _tmp25_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp26_;
				gpointer _tmp27_;
				ValaMethod* _tmp28_;
				ValaTypeParameter* _tmp29_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp26_ = _param_list;
				_tmp27_ = vala_list_get (_tmp26_, _param_index);
				param = (ValaTypeParameter*) _tmp27_;
				_tmp28_ = self->priv->end_method;
				_tmp29_ = param;
				vala_method_add_type_parameter (_tmp28_, _tmp29_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp30_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp30_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp31_ = self->priv->end_method;
	_tmp32_ = _vala_code_node_ref0 (_tmp31_);
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	gboolean _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_closure;
	if (_tmp4_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

