// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib::StaticType;
use glib::Value;
use glib_sys;
use gobject_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;
use DBusConnection;
use DBusInterface;
use DBusInterfaceSkeletonFlags;
use DBusMethodInvocation;

glib_wrapper! {
    pub struct DBusInterfaceSkeleton(Object<gio_sys::GDBusInterfaceSkeleton, gio_sys::GDBusInterfaceSkeletonClass, DBusInterfaceSkeletonClass>) @implements DBusInterface;

    match fn {
        get_type => || gio_sys::g_dbus_interface_skeleton_get_type(),
    }
}

pub const NONE_DBUS_INTERFACE_SKELETON: Option<&DBusInterfaceSkeleton> = None;

pub trait DBusInterfaceSkeletonExt: 'static {
    fn export(&self, connection: &DBusConnection, object_path: &str) -> Result<(), glib::Error>;

    fn flush(&self);

    fn get_connection(&self) -> Option<DBusConnection>;

    fn get_connections(&self) -> Vec<DBusConnection>;

    fn get_flags(&self) -> DBusInterfaceSkeletonFlags;

    fn get_object_path(&self) -> Option<GString>;

    fn get_properties(&self) -> Option<glib::Variant>;

    //fn get_vtable(&self) -> /*Ignored*/Option<DBusInterfaceVTable>;

    fn has_connection(&self, connection: &DBusConnection) -> bool;

    fn set_flags(&self, flags: DBusInterfaceSkeletonFlags);

    fn unexport(&self);

    fn unexport_from_connection(&self, connection: &DBusConnection);

    fn get_property_g_flags(&self) -> DBusInterfaceSkeletonFlags;

    fn set_property_g_flags(&self, g_flags: DBusInterfaceSkeletonFlags);

    fn connect_g_authorize_method<F: Fn(&Self, &DBusMethodInvocation) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_g_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DBusInterfaceSkeleton>> DBusInterfaceSkeletonExt for O {
    fn export(&self, connection: &DBusConnection, object_path: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gio_sys::g_dbus_interface_skeleton_export(
                self.as_ref().to_glib_none().0,
                connection.to_glib_none().0,
                object_path.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn flush(&self) {
        unsafe {
            gio_sys::g_dbus_interface_skeleton_flush(self.as_ref().to_glib_none().0);
        }
    }

    fn get_connection(&self) -> Option<DBusConnection> {
        unsafe {
            from_glib_none(gio_sys::g_dbus_interface_skeleton_get_connection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_connections(&self) -> Vec<DBusConnection> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(
                gio_sys::g_dbus_interface_skeleton_get_connections(self.as_ref().to_glib_none().0),
            )
        }
    }

    fn get_flags(&self) -> DBusInterfaceSkeletonFlags {
        unsafe {
            from_glib(gio_sys::g_dbus_interface_skeleton_get_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_object_path(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_dbus_interface_skeleton_get_object_path(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_properties(&self) -> Option<glib::Variant> {
        unsafe {
            from_glib_full(gio_sys::g_dbus_interface_skeleton_get_properties(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn get_vtable(&self) -> /*Ignored*/Option<DBusInterfaceVTable> {
    //    unsafe { TODO: call gio_sys:g_dbus_interface_skeleton_get_vtable() }
    //}

    fn has_connection(&self, connection: &DBusConnection) -> bool {
        unsafe {
            from_glib(gio_sys::g_dbus_interface_skeleton_has_connection(
                self.as_ref().to_glib_none().0,
                connection.to_glib_none().0,
            ))
        }
    }

    fn set_flags(&self, flags: DBusInterfaceSkeletonFlags) {
        unsafe {
            gio_sys::g_dbus_interface_skeleton_set_flags(
                self.as_ref().to_glib_none().0,
                flags.to_glib(),
            );
        }
    }

    fn unexport(&self) {
        unsafe {
            gio_sys::g_dbus_interface_skeleton_unexport(self.as_ref().to_glib_none().0);
        }
    }

    fn unexport_from_connection(&self, connection: &DBusConnection) {
        unsafe {
            gio_sys::g_dbus_interface_skeleton_unexport_from_connection(
                self.as_ref().to_glib_none().0,
                connection.to_glib_none().0,
            );
        }
    }

    fn get_property_g_flags(&self) -> DBusInterfaceSkeletonFlags {
        unsafe {
            let mut value =
                Value::from_type(<DBusInterfaceSkeletonFlags as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"g-flags\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `g-flags` getter")
                .unwrap()
        }
    }

    fn set_property_g_flags(&self, g_flags: DBusInterfaceSkeletonFlags) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"g-flags\0".as_ptr() as *const _,
                Value::from(&g_flags).to_glib_none().0,
            );
        }
    }

    fn connect_g_authorize_method<F: Fn(&Self, &DBusMethodInvocation) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn g_authorize_method_trampoline<
            P,
            F: Fn(&P, &DBusMethodInvocation) -> bool + 'static,
        >(
            this: *mut gio_sys::GDBusInterfaceSkeleton,
            invocation: *mut gio_sys::GDBusMethodInvocation,
            f: glib_sys::gpointer,
        ) -> glib_sys::gboolean
        where
            P: IsA<DBusInterfaceSkeleton>,
        {
            let f: &F = &*(f as *const F);
            f(
                &DBusInterfaceSkeleton::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(invocation),
            )
            .to_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"g-authorize-method\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    g_authorize_method_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_g_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_g_flags_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gio_sys::GDBusInterfaceSkeleton,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<DBusInterfaceSkeleton>,
        {
            let f: &F = &*(f as *const F);
            f(&DBusInterfaceSkeleton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::g-flags\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_g_flags_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for DBusInterfaceSkeleton {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DBusInterfaceSkeleton")
    }
}
