// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib;
use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use gst_sys;
use Object;

glib_wrapper! {
    pub struct BufferPool(Object<gst_sys::GstBufferPool, gst_sys::GstBufferPoolClass, BufferPoolClass>) @extends Object;

    match fn {
        get_type => || gst_sys::gst_buffer_pool_get_type(),
    }
}

unsafe impl Send for BufferPool {}
unsafe impl Sync for BufferPool {}

pub const NONE_BUFFER_POOL: Option<&BufferPool> = None;

pub trait BufferPoolExt: 'static {
    fn get_options(&self) -> Vec<GString>;

    fn has_option(&self, option: &str) -> bool;

    fn is_active(&self) -> bool;

    fn set_active(&self, active: bool) -> Result<(), glib::error::BoolError>;

    fn set_flushing(&self, flushing: bool);
}

impl<O: IsA<BufferPool>> BufferPoolExt for O {
    fn get_options(&self) -> Vec<GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(gst_sys::gst_buffer_pool_get_options(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_option(&self, option: &str) -> bool {
        unsafe {
            from_glib(gst_sys::gst_buffer_pool_has_option(
                self.as_ref().to_glib_none().0,
                option.to_glib_none().0,
            ))
        }
    }

    fn is_active(&self) -> bool {
        unsafe {
            from_glib(gst_sys::gst_buffer_pool_is_active(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_active(&self, active: bool) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib_result_from_gboolean!(
                gst_sys::gst_buffer_pool_set_active(
                    self.as_ref().to_glib_none().0,
                    active.to_glib()
                ),
                "Failed to activate buffer pool"
            )
        }
    }

    fn set_flushing(&self, flushing: bool) {
        unsafe {
            gst_sys::gst_buffer_pool_set_flushing(
                self.as_ref().to_glib_none().0,
                flushing.to_glib(),
            );
        }
    }
}
