// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gst_sys;
use std::boxed::Box as Box_;
use std::mem::transmute;
use ClockTime;
use Message;
use Object;

glib_wrapper! {
    pub struct Bus(Object<gst_sys::GstBus, gst_sys::GstBusClass, BusClass>) @extends Object;

    match fn {
        get_type => || gst_sys::gst_bus_get_type(),
    }
}

impl Bus {
    pub fn new() -> Bus {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(gst_sys::gst_bus_new()) }
    }

    pub fn add_signal_watch(&self) {
        unsafe {
            gst_sys::gst_bus_add_signal_watch(self.to_glib_none().0);
        }
    }

    //pub fn async_signal_func(&self, message: &Message, data: /*Unimplemented*/Option<Fundamental: Pointer>) -> bool {
    //    unsafe { TODO: call gst_sys:gst_bus_async_signal_func() }
    //}

    pub fn disable_sync_message_emission(&self) {
        unsafe {
            gst_sys::gst_bus_disable_sync_message_emission(self.to_glib_none().0);
        }
    }

    pub fn enable_sync_message_emission(&self) {
        unsafe {
            gst_sys::gst_bus_enable_sync_message_emission(self.to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v1_14", feature = "dox"))]
    //pub fn get_pollfd(&self, fd: /*Ignored*/glib::PollFD) {
    //    unsafe { TODO: call gst_sys:gst_bus_get_pollfd() }
    //}

    pub fn have_pending(&self) -> bool {
        unsafe { from_glib(gst_sys::gst_bus_have_pending(self.to_glib_none().0)) }
    }

    pub fn peek(&self) -> Option<Message> {
        unsafe { from_glib_full(gst_sys::gst_bus_peek(self.to_glib_none().0)) }
    }

    pub fn pop(&self) -> Option<Message> {
        unsafe { from_glib_full(gst_sys::gst_bus_pop(self.to_glib_none().0)) }
    }

    pub fn post(&self, message: &Message) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib_result_from_gboolean!(
                gst_sys::gst_bus_post(self.to_glib_none().0, message.to_glib_full()),
                "Failed to post message"
            )
        }
    }

    pub fn remove_signal_watch(&self) {
        unsafe {
            gst_sys::gst_bus_remove_signal_watch(self.to_glib_none().0);
        }
    }

    pub fn remove_watch(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib_result_from_gboolean!(
                gst_sys::gst_bus_remove_watch(self.to_glib_none().0),
                "Bus has no event source"
            )
        }
    }

    pub fn set_flushing(&self, flushing: bool) {
        unsafe {
            gst_sys::gst_bus_set_flushing(self.to_glib_none().0, flushing.to_glib());
        }
    }

    //pub fn sync_signal_handler(&self, message: &Message, data: /*Unimplemented*/Option<Fundamental: Pointer>) -> BusSyncReply {
    //    unsafe { TODO: call gst_sys:gst_bus_sync_signal_handler() }
    //}

    pub fn timed_pop(&self, timeout: ClockTime) -> Option<Message> {
        unsafe {
            from_glib_full(gst_sys::gst_bus_timed_pop(
                self.to_glib_none().0,
                timeout.to_glib(),
            ))
        }
    }

    pub fn connect_message<F: Fn(&Bus, &Message) + Send + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn message_trampoline<F: Fn(&Bus, &Message) + Send + 'static>(
            this: *mut gst_sys::GstBus,
            message: *mut gst_sys::GstMessage,
            f: glib_sys::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"message\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn connect_sync_message<F: Fn(&Bus, &Message) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn sync_message_trampoline<
            F: Fn(&Bus, &Message) + Send + Sync + 'static,
        >(
            this: *mut gst_sys::GstBus,
            message: *mut gst_sys::GstMessage,
            f: glib_sys::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"sync-message\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    sync_message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Bus {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for Bus {}
unsafe impl Sync for Bus {}
