// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gtk;
use handy_sys;
use libc;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use NavigationDirection;
use SwipeTracker;

glib_wrapper! {
    pub struct Swipeable(Interface<handy_sys::HdySwipeable>) @requires gtk::Widget, gtk::Buildable;

    match fn {
        get_type => || handy_sys::hdy_swipeable_get_type(),
    }
}

pub const NONE_SWIPEABLE: Option<&Swipeable> = None;

pub trait SwipeableExt: 'static {
    fn emit_child_switched(&self, index: u32, duration: i64);

    fn get_cancel_progress(&self) -> f64;

    fn get_distance(&self) -> f64;

    fn get_progress(&self) -> f64;

    fn get_snap_points(&self) -> Vec<f64>;

    fn get_swipe_area(
        &self,
        navigation_direction: NavigationDirection,
        is_drag: bool,
    ) -> gdk::Rectangle;

    fn get_swipe_tracker(&self) -> Option<SwipeTracker>;

    fn switch_child(&self, index: u32, duration: i64);

    fn connect_child_switched<F: Fn(&Self, u32, i64) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Swipeable>> SwipeableExt for O {
    fn emit_child_switched(&self, index: u32, duration: i64) {
        unsafe {
            handy_sys::hdy_swipeable_emit_child_switched(
                self.as_ref().to_glib_none().0,
                index,
                duration,
            );
        }
    }

    fn get_cancel_progress(&self) -> f64 {
        unsafe { handy_sys::hdy_swipeable_get_cancel_progress(self.as_ref().to_glib_none().0) }
    }

    fn get_distance(&self) -> f64 {
        unsafe { handy_sys::hdy_swipeable_get_distance(self.as_ref().to_glib_none().0) }
    }

    fn get_progress(&self) -> f64 {
        unsafe { handy_sys::hdy_swipeable_get_progress(self.as_ref().to_glib_none().0) }
    }

    fn get_snap_points(&self) -> Vec<f64> {
        unsafe {
            let mut n_snap_points = mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_full_num(
                handy_sys::hdy_swipeable_get_snap_points(
                    self.as_ref().to_glib_none().0,
                    n_snap_points.as_mut_ptr(),
                ),
                n_snap_points.assume_init() as usize,
            );
            ret
        }
    }

    fn get_swipe_area(
        &self,
        navigation_direction: NavigationDirection,
        is_drag: bool,
    ) -> gdk::Rectangle {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            handy_sys::hdy_swipeable_get_swipe_area(
                self.as_ref().to_glib_none().0,
                navigation_direction.to_glib(),
                is_drag.to_glib(),
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    fn get_swipe_tracker(&self) -> Option<SwipeTracker> {
        unsafe {
            from_glib_none(handy_sys::hdy_swipeable_get_swipe_tracker(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn switch_child(&self, index: u32, duration: i64) {
        unsafe {
            handy_sys::hdy_swipeable_switch_child(self.as_ref().to_glib_none().0, index, duration);
        }
    }

    fn connect_child_switched<F: Fn(&Self, u32, i64) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn child_switched_trampoline<P, F: Fn(&P, u32, i64) + 'static>(
            this: *mut handy_sys::HdySwipeable,
            index: libc::c_uint,
            duration: i64,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Swipeable>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Swipeable::from_glib_borrow(this).unsafe_cast_ref(),
                index,
                duration,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"child-switched\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    child_switched_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Swipeable {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Swipeable")
    }
}
