/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_set_left (ValaAssignment* self,
                               ValaExpression* value);
static void vala_assignment_set_operator (ValaAssignment* self,
                                   ValaAssignmentOperator value);
static void vala_assignment_set_right (ValaAssignment* self,
                                ValaExpression* value);
static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

static void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

static void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaExpression* _tmp98_;
	ValaExpression* _tmp242_;
	ValaExpression* _tmp243_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp244_;
	ValaExpression* _tmp245_;
	gboolean _tmp246_ = FALSE;
	gboolean _tmp247_ = FALSE;
	ValaAssignmentOperator _tmp248_;
	ValaMemberAccess* _tmp295_;
	ValaExpression* _tmp594_;
	ValaExpression* _tmp595_;
	ValaDataType* _tmp596_;
	ValaDataType* _tmp597_;
	ValaDataType* _tmp606_;
	ValaDataType* _tmp607_;
	gboolean _tmp610_;
	gboolean _tmp611_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp82_;
		ValaSemanticAnalyzer* _tmp83_;
		ValaList* _tmp84_;
		ValaCodeNode* _tmp85_;
		ValaCodeNode* _tmp86_;
		ValaExpressionStatement* _tmp87_;
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpressionStatement* _tmp90_;
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp38_;
				gint _tmp39_;
				ValaExpression* expr = NULL;
				ValaList* _tmp40_;
				gpointer _tmp41_;
				ValaExpressionStatement* _tmp42_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				ValaExpression* _tmp51_;
				ValaExpression* _tmp52_;
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaMemberAccess* _tmp55_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaElementAccess* _tmp60_;
				ValaElementAccess* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ValaExpression* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				ValaIntegerLiteral* _tmp67_;
				ValaIntegerLiteral* _tmp68_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp69_;
				ValaElementAccess* _tmp70_;
				ValaAssignmentOperator _tmp71_;
				ValaExpression* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaAssignment* _tmp75_;
				ValaAssignment* _tmp76_;
				ValaExpression* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				ValaExpressionStatement* _tmp80_;
				gint _tmp81_;
				_expr_index = _expr_index + 1;
				_tmp38_ = _expr_index;
				_tmp39_ = _expr_size;
				if (!(_tmp38_ < _tmp39_)) {
					break;
				}
				_tmp40_ = _expr_list;
				_tmp41_ = vala_list_get (_tmp40_, _expr_index);
				expr = (ValaExpression*) _tmp41_;
				_tmp42_ = stmt;
				if (_tmp42_ != NULL) {
					ValaSemanticAnalyzer* _tmp43_;
					ValaSemanticAnalyzer* _tmp44_;
					ValaBlock* _tmp45_;
					ValaExpressionStatement* _tmp46_;
					ValaExpressionStatement* _tmp47_;
					_tmp43_ = vala_code_context_get_analyzer (context);
					_tmp44_ = _tmp43_;
					_tmp45_ = _tmp44_->insert_block;
					_tmp46_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp45_, (ValaStatement*) _tmp46_);
					_tmp47_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp47_, context);
				}
				_tmp48_ = local;
				_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_assignment_get_right (self);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_member_access_new_simple (_tmp50_, _tmp54_);
				temp_access = _tmp55_;
				_tmp56_ = temp_access;
				_tmp57_ = expr;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_element_access_new ((ValaExpression*) _tmp56_, _tmp59_);
				ea = _tmp60_;
				_tmp61_ = ea;
				_tmp62_ = g_strdup_printf ("%i", i);
				_tmp63_ = _tmp62_;
				_tmp64_ = expr;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_integer_literal_new (_tmp63_, _tmp66_);
				_tmp68_ = _tmp67_;
				vala_element_access_append_index (_tmp61_, (ValaExpression*) _tmp68_);
				_vala_code_node_unref0 (_tmp68_);
				_g_free0 (_tmp63_);
				_tmp69_ = expr;
				_tmp70_ = ea;
				_tmp71_ = self->priv->_operator;
				_tmp72_ = expr;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_assignment_new (_tmp69_, (ValaExpression*) _tmp70_, _tmp71_, _tmp74_);
				assign = _tmp75_;
				_tmp76_ = assign;
				_tmp77_ = expr;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = vala_expression_statement_new ((ValaExpression*) _tmp76_, _tmp79_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp80_;
				_tmp81_ = i;
				i = _tmp81_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp82_ = vala_code_context_get_analyzer (context);
		_tmp83_ = _tmp82_;
		_tmp84_ = _tmp83_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp84_, (ValaCodeNode*) self);
		_tmp85_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = stmt;
		_tmp88_ = vala_expression_statement_get_expression (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_node_replace_expression (_tmp86_, (ValaExpression*) self, _tmp89_);
		_tmp90_ = stmt;
		_tmp91_ = vala_expression_statement_get_expression (_tmp90_);
		_tmp92_ = _tmp91_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	vala_expression_set_lvalue (_tmp94_, TRUE);
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp96_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp97_ = vala_assignment_get_left (self);
	_tmp98_ = _tmp97_;
	if (VALA_IS_MEMBER_ACCESS (_tmp98_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaMemberAccess* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaMemberAccess* _tmp104_;
		ValaSymbol* _tmp105_;
		ValaSymbol* _tmp106_;
		ValaMemberAccess* _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp134_ = FALSE;
		ValaMemberAccess* _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp137_;
		ValaMemberAccess* _tmp141_;
		ValaSymbol* _tmp142_;
		ValaSymbol* _tmp143_;
		_tmp99_ = vala_assignment_get_left (self);
		_tmp100_ = _tmp99_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp101_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp101_);
		_tmp104_ = ma;
		_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp104_);
		_tmp106_ = _tmp105_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp106_)) {
			ValaMemberAccess* _tmp107_;
			ValaDataType* _tmp108_;
			ValaDataType* _tmp109_;
			_tmp107_ = ma;
			_tmp108_ = vala_expression_get_value_type ((ValaExpression*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp103_ = _tmp109_ == NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			_tmp102_ = TRUE;
		} else {
			gboolean _tmp110_ = FALSE;
			gboolean _tmp111_ = FALSE;
			ValaMemberAccess* _tmp112_;
			ValaExpression* _tmp113_;
			ValaExpression* _tmp114_;
			_tmp112_ = ma;
			_tmp113_ = vala_member_access_get_inner (_tmp112_);
			_tmp114_ = _tmp113_;
			if (_tmp114_ == NULL) {
				ValaMemberAccess* _tmp115_;
				const gchar* _tmp116_;
				const gchar* _tmp117_;
				_tmp115_ = ma;
				_tmp116_ = vala_member_access_get_member_name (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp111_ = g_strcmp0 (_tmp117_, "this") == 0;
			} else {
				_tmp111_ = FALSE;
			}
			if (_tmp111_) {
				ValaSemanticAnalyzer* _tmp118_;
				ValaSemanticAnalyzer* _tmp119_;
				_tmp118_ = vala_code_context_get_analyzer (context);
				_tmp119_ = _tmp118_;
				_tmp110_ = vala_semantic_analyzer_is_in_instance_method (_tmp119_);
			} else {
				_tmp110_ = FALSE;
			}
			_tmp102_ = _tmp110_;
		}
		if (_tmp102_) {
			ValaSourceReference* _tmp120_;
			ValaSourceReference* _tmp121_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp121_ = _tmp120_;
			vala_report_error (_tmp121_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp122_ = ma;
		_tmp123_ = vala_member_access_get_prototype_access (_tmp122_);
		_tmp124_ = _tmp123_;
		if (_tmp124_) {
			ValaSourceReference* _tmp125_;
			ValaSourceReference* _tmp126_;
			ValaMemberAccess* _tmp127_;
			ValaSymbol* _tmp128_;
			ValaSymbol* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = ma;
			_tmp128_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_symbol_get_full_name (_tmp129_);
			_tmp131_ = _tmp130_;
			_tmp132_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp131_);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp126_, _tmp133_);
			_g_free0 (_tmp133_);
			_g_free0 (_tmp131_);
			result = FALSE;
			return result;
		}
		_tmp135_ = ma;
		_tmp136_ = vala_code_node_get_error ((ValaCodeNode*) _tmp135_);
		_tmp137_ = _tmp136_;
		if (_tmp137_) {
			_tmp134_ = TRUE;
		} else {
			ValaMemberAccess* _tmp138_;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp138_ = ma;
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp134_ = _tmp140_ == NULL;
		}
		if (_tmp134_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp141_ = ma;
		_tmp142_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp141_);
		_tmp143_ = _tmp142_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp143_)) {
		} else {
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaMemberAccess* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			ValaExpression* _tmp151_;
			ValaExpression* _tmp152_;
			ValaMemberAccess* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			_tmp144_ = vala_assignment_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = ma;
			_tmp147_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_data_type_copy (_tmp148_);
			_tmp150_ = _tmp149_;
			vala_expression_set_formal_target_type (_tmp145_, _tmp150_);
			_vala_code_node_unref0 (_tmp150_);
			_tmp151_ = vala_assignment_get_right (self);
			_tmp152_ = _tmp151_;
			_tmp153_ = ma;
			_tmp154_ = vala_expression_get_value_type ((ValaExpression*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_data_type_copy (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_expression_set_target_type (_tmp152_, _tmp157_);
			_vala_code_node_unref0 (_tmp157_);
		}
	} else {
		ValaExpression* _tmp158_;
		ValaExpression* _tmp159_;
		_tmp158_ = vala_assignment_get_left (self);
		_tmp159_ = _tmp158_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp159_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp160_;
			ValaExpression* _tmp161_;
			ValaElementAccess* _tmp162_;
			ValaExpression* _tmp163_;
			ValaExpression* _tmp164_;
			ValaElementAccess* _tmp165_;
			ValaExpression* _tmp166_;
			ValaExpression* _tmp167_;
			ValaDataType* _tmp168_;
			ValaDataType* _tmp169_;
			ValaTypeSymbol* _tmp170_;
			ValaTypeSymbol* _tmp171_;
			ValaSemanticAnalyzer* _tmp172_;
			ValaSemanticAnalyzer* _tmp173_;
			ValaDataType* _tmp174_;
			ValaTypeSymbol* _tmp175_;
			ValaTypeSymbol* _tmp176_;
			_tmp160_ = vala_assignment_get_left (self);
			_tmp161_ = _tmp160_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp162_ = ea;
			_tmp163_ = vala_element_access_get_container (_tmp162_);
			_tmp164_ = _tmp163_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp164_) ? ((ValaMemberAccess*) _tmp164_) : NULL);
			_tmp165_ = ea;
			_tmp166_ = vala_element_access_get_container (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_expression_get_value_type (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_data_type_get_type_symbol (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_code_context_get_analyzer (context);
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_->string_type;
			_tmp175_ = vala_data_type_get_type_symbol (_tmp174_);
			_tmp176_ = _tmp175_;
			if (_tmp171_ == _tmp176_) {
				ValaElementAccess* _tmp177_;
				ValaSourceReference* _tmp178_;
				ValaSourceReference* _tmp179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = ea;
				_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp179_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp180_;
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaDataType* _tmp183_;
				ValaDataType* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				gboolean _tmp187_;
				_tmp180_ = ea;
				_tmp181_ = vala_element_access_get_container (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_expression_get_value_type (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_data_type_get_member (_tmp184_, "set");
				_tmp186_ = _tmp185_;
				_tmp187_ = VALA_IS_METHOD (_tmp186_);
				_vala_code_node_unref0 (_tmp186_);
				if (_tmp187_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp188_;
					ValaExpression* _tmp189_;
					ValaExpression* _tmp190_;
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaMemberAccess* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaSourceReference* _tmp195_;
					ValaSourceReference* _tmp196_;
					ValaMethodCall* _tmp197_;
					ValaMethodCall* _tmp198_;
					ValaMethodCall* _tmp211_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaCodeNode* _tmp214_;
					ValaCodeNode* _tmp215_;
					ValaMethodCall* _tmp216_;
					ValaMethodCall* _tmp217_;
					_tmp188_ = ea;
					_tmp189_ = vala_element_access_get_container (_tmp188_);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_member_access_new (_tmp190_, "set", _tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_method_call_new ((ValaExpression*) _tmp194_, _tmp196_);
					_tmp198_ = _tmp197_;
					_vala_code_node_unref0 (_tmp194_);
					set_call = _tmp198_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp199_;
						ValaList* _tmp200_;
						ValaList* _tmp201_;
						gint _e_size = 0;
						ValaList* _tmp202_;
						gint _tmp203_;
						gint _tmp204_;
						gint _e_index = 0;
						_tmp199_ = ea;
						_tmp200_ = vala_element_access_get_indices (_tmp199_);
						_tmp201_ = _vala_iterable_ref0 (_tmp200_);
						_e_list = _tmp201_;
						_tmp202_ = _e_list;
						_tmp203_ = vala_collection_get_size ((ValaCollection*) _tmp202_);
						_tmp204_ = _tmp203_;
						_e_size = _tmp204_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp205_;
							gint _tmp206_;
							ValaExpression* e = NULL;
							ValaList* _tmp207_;
							gpointer _tmp208_;
							ValaMethodCall* _tmp209_;
							ValaExpression* _tmp210_;
							_e_index = _e_index + 1;
							_tmp205_ = _e_index;
							_tmp206_ = _e_size;
							if (!(_tmp205_ < _tmp206_)) {
								break;
							}
							_tmp207_ = _e_list;
							_tmp208_ = vala_list_get (_tmp207_, _e_index);
							e = (ValaExpression*) _tmp208_;
							_tmp209_ = set_call;
							_tmp210_ = e;
							vala_method_call_add_argument (_tmp209_, _tmp210_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp211_ = set_call;
					_tmp212_ = vala_assignment_get_right (self);
					_tmp213_ = _tmp212_;
					vala_method_call_add_argument (_tmp211_, _tmp213_);
					_tmp214_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = set_call;
					vala_code_node_replace_expression (_tmp215_, (ValaExpression*) self, (ValaExpression*) _tmp216_);
					_tmp217_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					ValaExpression* _tmp220_;
					ValaExpression* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					_tmp218_ = vala_assignment_get_right (self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_assignment_get_left (self);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_expression_get_value_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_data_type_copy (_tmp223_);
					_tmp225_ = _tmp224_;
					vala_expression_set_target_type (_tmp219_, _tmp225_);
					_vala_code_node_unref0 (_tmp225_);
				}
			}
		} else {
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			_tmp226_ = vala_assignment_get_left (self);
			_tmp227_ = _tmp226_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp227_)) {
				ValaExpression* _tmp228_;
				ValaExpression* _tmp229_;
				ValaExpression* _tmp230_;
				ValaExpression* _tmp231_;
				ValaDataType* _tmp232_;
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				ValaDataType* _tmp235_;
				_tmp228_ = vala_assignment_get_right (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_assignment_get_left (self);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_expression_get_value_type (_tmp231_);
				_tmp233_ = _tmp232_;
				_tmp234_ = vala_data_type_copy (_tmp233_);
				_tmp235_ = _tmp234_;
				vala_expression_set_target_type (_tmp229_, _tmp235_);
				_vala_code_node_unref0 (_tmp235_);
			} else {
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp236_ = vala_assignment_get_left (self);
				_tmp237_ = _tmp236_;
				if (VALA_IS_LITERAL (_tmp237_)) {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					vala_report_error (_tmp239_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					vala_report_error (_tmp241_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp242_ = vala_assignment_get_right (self);
	_tmp243_ = _tmp242_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp243_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp244_ = vala_assignment_get_left (self);
	_tmp245_ = _tmp244_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp245_) ? ((ValaMemberAccess*) _tmp245_) : NULL;
	_tmp248_ = self->priv->_operator;
	if (_tmp248_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp249_;
		_tmp249_ = ma;
		_tmp247_ = _tmp249_ != NULL;
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		gboolean _tmp250_ = FALSE;
		ValaExpression* _tmp251_;
		ValaExpression* _tmp252_;
		ValaDataType* _tmp253_;
		ValaDataType* _tmp254_;
		_tmp251_ = vala_assignment_get_left (self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_expression_get_value_type (_tmp252_);
		_tmp254_ = _tmp253_;
		if (vala_data_type_is_non_null_simple_type (_tmp254_)) {
			ValaMemberAccess* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp255_ = ma;
			_tmp256_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp255_);
			_tmp257_ = _tmp256_;
			_tmp250_ = VALA_IS_LOCAL_VARIABLE (_tmp257_);
		} else {
			_tmp250_ = FALSE;
		}
		_tmp246_ = !_tmp250_;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp258_;
		ValaExpression* _tmp259_;
		ValaExpression* _tmp260_;
		ValaMemberAccess* _tmp261_;
		const gchar* _tmp262_;
		const gchar* _tmp263_;
		ValaMemberAccess* _tmp264_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp265_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp268_;
		ValaMemberAccess* _tmp269_;
		ValaExpression* _tmp270_;
		ValaExpression* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaDataType* _tmp278_;
		ValaDataType* _tmp279_;
		ValaExpression* _tmp280_;
		ValaExpression* _tmp281_;
		ValaExpression* _tmp282_;
		ValaExpression* _tmp283_;
		ValaDataType* _tmp284_;
		ValaDataType* _tmp285_;
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		ValaExpression* _tmp288_;
		ValaExpression* _tmp289_;
		ValaDataType* _tmp290_;
		ValaDataType* _tmp291_;
		ValaBinaryExpression* _tmp292_;
		ValaExpression* _tmp293_;
		ValaExpression* _tmp294_;
		_tmp258_ = ma;
		_tmp259_ = vala_member_access_get_inner (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = ma;
		_tmp262_ = vala_member_access_get_member_name (_tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_member_access_new (_tmp260_, _tmp263_, NULL);
		old_value = _tmp264_;
		_tmp265_ = self->priv->_operator;
		switch (_tmp265_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp266_;
				ValaSourceReference* _tmp267_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp266_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp267_ = _tmp266_;
				vala_report_error (_tmp267_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp268_ = bop;
		_tmp269_ = old_value;
		_tmp270_ = vala_assignment_get_right (self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (_tmp268_, (ValaExpression*) _tmp269_, _tmp271_, _tmp273_);
		bin = _tmp274_;
		_tmp275_ = bin;
		_tmp276_ = vala_assignment_get_right (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_expression_get_target_type (_tmp277_);
		_tmp279_ = _tmp278_;
		vala_expression_set_target_type ((ValaExpression*) _tmp275_, _tmp279_);
		_tmp280_ = vala_assignment_get_right (self);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_assignment_get_right (self);
		_tmp283_ = _tmp282_;
		_tmp284_ = vala_expression_get_target_type (_tmp283_);
		_tmp285_ = _tmp284_;
		_tmp286_ = vala_data_type_copy (_tmp285_);
		_tmp287_ = _tmp286_;
		vala_expression_set_target_type (_tmp281_, _tmp287_);
		_vala_code_node_unref0 (_tmp287_);
		_tmp288_ = vala_assignment_get_right (self);
		_tmp289_ = _tmp288_;
		_tmp290_ = vala_expression_get_target_type (_tmp289_);
		_tmp291_ = _tmp290_;
		vala_data_type_set_value_owned (_tmp291_, FALSE);
		_tmp292_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp292_);
		_tmp293_ = vala_assignment_get_right (self);
		_tmp294_ = _tmp293_;
		vala_code_node_check ((ValaCodeNode*) _tmp294_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp295_ = ma;
	if (_tmp295_ != NULL) {
		ValaMemberAccess* _tmp296_;
		ValaSymbol* _tmp297_;
		ValaSymbol* _tmp298_;
		gboolean _tmp407_ = FALSE;
		ValaExpression* _tmp408_;
		ValaExpression* _tmp409_;
		ValaDataType* _tmp410_;
		ValaDataType* _tmp411_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp466_;
		ValaExpression* _tmp467_;
		gboolean _tmp468_ = FALSE;
		ValaMemberAccess* _tmp469_;
		_tmp296_ = ma;
		_tmp297_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp296_);
		_tmp298_ = _tmp297_;
		if (VALA_IS_PROPERTY (_tmp298_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp302_;
			ValaDynamicProperty* _tmp303_;
			_tmp299_ = ma;
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp299_);
			_tmp301_ = _tmp300_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp302_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp302_) ? ((ValaDynamicProperty*) _tmp302_) : NULL;
			_tmp303_ = dynamic_prop;
			if (_tmp303_ != NULL) {
				ValaDynamicProperty* _tmp304_;
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				ValaDataType* _tmp310_;
				ValaExpression* _tmp311_;
				ValaExpression* _tmp312_;
				ValaDynamicProperty* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				_tmp304_ = dynamic_prop;
				_tmp305_ = vala_assignment_get_right (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_expression_get_value_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = vala_data_type_copy (_tmp308_);
				_tmp310_ = _tmp309_;
				vala_property_set_property_type ((ValaProperty*) _tmp304_, _tmp310_);
				_vala_code_node_unref0 (_tmp310_);
				_tmp311_ = vala_assignment_get_left (self);
				_tmp312_ = _tmp311_;
				_tmp313_ = dynamic_prop;
				_tmp314_ = vala_property_get_property_type ((ValaProperty*) _tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_data_type_copy (_tmp315_);
				_tmp317_ = _tmp316_;
				vala_expression_set_value_type (_tmp312_, _tmp317_);
				_vala_code_node_unref0 (_tmp317_);
			}
		} else {
			gboolean _tmp318_ = FALSE;
			ValaMemberAccess* _tmp319_;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			_tmp319_ = ma;
			_tmp320_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp319_);
			_tmp321_ = _tmp320_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp321_)) {
				ValaMemberAccess* _tmp322_;
				ValaExpression* _tmp323_;
				ValaExpression* _tmp324_;
				ValaDataType* _tmp325_;
				ValaDataType* _tmp326_;
				gboolean _tmp327_;
				gboolean _tmp328_;
				_tmp322_ = ma;
				_tmp323_ = vala_member_access_get_inner (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_expression_get_value_type (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp328_ = _tmp327_;
				_tmp318_ = _tmp328_;
			} else {
				_tmp318_ = FALSE;
			}
			if (_tmp318_) {
				ValaSourceReference* _tmp329_;
				ValaSourceReference* _tmp330_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				vala_report_error (_tmp330_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp331_ = FALSE;
				ValaMemberAccess* _tmp332_;
				ValaSymbol* _tmp333_;
				ValaSymbol* _tmp334_;
				_tmp332_ = ma;
				_tmp333_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp332_);
				_tmp334_ = _tmp333_;
				if (VALA_IS_VARIABLE (_tmp334_)) {
					ValaExpression* _tmp335_;
					ValaExpression* _tmp336_;
					ValaDataType* _tmp337_;
					ValaDataType* _tmp338_;
					_tmp335_ = vala_assignment_get_right (self);
					_tmp336_ = _tmp335_;
					_tmp337_ = vala_expression_get_value_type (_tmp336_);
					_tmp338_ = _tmp337_;
					_tmp331_ = VALA_IS_METHOD_TYPE (_tmp338_);
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp339_;
					ValaSymbol* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaVariable* _tmp342_;
					ValaDataType* _tmp343_;
					ValaDataType* _tmp344_;
					_tmp339_ = ma;
					_tmp340_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp339_);
					_tmp341_ = _tmp340_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp342_ = variable;
					_tmp343_ = vala_variable_get_variable_type (_tmp342_);
					_tmp344_ = _tmp343_;
					if (VALA_IS_DELEGATE_TYPE (_tmp344_)) {
						ValaExpression* _tmp345_;
						ValaExpression* _tmp346_;
						ValaDataType* _tmp347_;
						ValaDataType* _tmp348_;
						ValaVariable* _tmp349_;
						ValaDataType* _tmp350_;
						ValaDataType* _tmp351_;
						_tmp345_ = vala_assignment_get_right (self);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_expression_get_value_type (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = variable;
						_tmp350_ = vala_variable_get_variable_type (_tmp349_);
						_tmp351_ = _tmp350_;
						if (!vala_data_type_compatible (_tmp348_, _tmp351_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp352_;
							ValaExpression* _tmp353_;
							ValaSymbol* _tmp354_;
							ValaSymbol* _tmp355_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp356_;
							ValaDataType* _tmp357_;
							ValaDataType* _tmp358_;
							ValaDelegate* _tmp359_;
							ValaDelegate* _tmp360_;
							ValaSourceReference* _tmp361_;
							ValaSourceReference* _tmp362_;
							ValaMethod* _tmp363_;
							gchar* _tmp364_;
							gchar* _tmp365_;
							ValaDelegate* _tmp366_;
							gchar* _tmp367_;
							gchar* _tmp368_;
							gchar* _tmp369_;
							gchar* _tmp370_;
							_tmp352_ = vala_assignment_get_right (self);
							_tmp353_ = _tmp352_;
							_tmp354_ = vala_expression_get_symbol_reference (_tmp353_);
							_tmp355_ = _tmp354_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp355_, VALA_TYPE_METHOD, ValaMethod);
							_tmp356_ = variable;
							_tmp357_ = vala_variable_get_variable_type (_tmp356_);
							_tmp358_ = _tmp357_;
							_tmp359_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp358_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp360_ = _tmp359_;
							cb = _tmp360_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp361_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp362_ = _tmp361_;
							_tmp363_ = m;
							_tmp364_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp363_);
							_tmp365_ = _tmp364_;
							_tmp366_ = cb;
							_tmp367_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp366_);
							_tmp368_ = _tmp367_;
							_tmp369_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp365_, _tmp368_);
							_tmp370_ = _tmp369_;
							vala_report_error (_tmp362_, _tmp370_);
							_g_free0 (_tmp370_);
							_g_free0 (_tmp368_);
							_g_free0 (_tmp365_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp371_;
						ValaSourceReference* _tmp372_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp372_ = _tmp371_;
						vala_report_error (_tmp372_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					ValaMemberAccess* _tmp373_;
					ValaSymbol* _tmp374_;
					ValaSymbol* _tmp375_;
					_tmp373_ = ma;
					_tmp374_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp373_);
					_tmp375_ = _tmp374_;
					if (VALA_IS_VARIABLE (_tmp375_)) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp376_;
						ValaSymbol* _tmp377_;
						ValaSymbol* _tmp378_;
						ValaArrayType* variable_array_type = NULL;
						ValaVariable* _tmp379_;
						ValaDataType* _tmp380_;
						ValaDataType* _tmp381_;
						gboolean _tmp382_ = FALSE;
						gboolean _tmp383_ = FALSE;
						gboolean _tmp384_ = FALSE;
						ValaArrayType* _tmp385_;
						_tmp376_ = ma;
						_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
						_tmp378_ = _tmp377_;
						variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp378_, VALA_TYPE_VARIABLE, ValaVariable);
						_tmp379_ = variable;
						_tmp380_ = vala_variable_get_variable_type (_tmp379_);
						_tmp381_ = _tmp380_;
						variable_array_type = VALA_IS_ARRAY_TYPE (_tmp381_) ? ((ValaArrayType*) _tmp381_) : NULL;
						_tmp385_ = variable_array_type;
						if (_tmp385_ != NULL) {
							ValaArrayType* _tmp386_;
							gboolean _tmp387_;
							gboolean _tmp388_;
							_tmp386_ = variable_array_type;
							_tmp387_ = vala_array_type_get_inline_allocated (_tmp386_);
							_tmp388_ = _tmp387_;
							_tmp384_ = _tmp388_;
						} else {
							_tmp384_ = FALSE;
						}
						if (_tmp384_) {
							ValaExpression* _tmp389_;
							ValaExpression* _tmp390_;
							_tmp389_ = vala_assignment_get_right (self);
							_tmp390_ = _tmp389_;
							_tmp383_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp390_);
						} else {
							_tmp383_ = FALSE;
						}
						if (_tmp383_) {
							ValaExpression* _tmp391_;
							ValaExpression* _tmp392_;
							ValaInitializerList* _tmp393_;
							ValaInitializerList* _tmp394_;
							_tmp391_ = vala_assignment_get_right (self);
							_tmp392_ = _tmp391_;
							_tmp393_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp392_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
							_tmp394_ = _tmp393_;
							_tmp382_ = _tmp394_ == NULL;
						} else {
							_tmp382_ = FALSE;
						}
						if (_tmp382_) {
							ValaSourceReference* _tmp395_;
							ValaSourceReference* _tmp396_;
							ValaCodeNode* _tmp397_;
							ValaCodeNode* _tmp398_;
							ValaCodeNode* _tmp399_;
							ValaCodeNode* _tmp400_;
							ValaCodeNode* _tmp401_;
							ValaCodeNode* _tmp402_;
							ValaSourceReference* _tmp403_;
							ValaSourceReference* _tmp404_;
							ValaEmptyStatement* _tmp405_;
							ValaEmptyStatement* _tmp406_;
							_tmp395_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp396_ = _tmp395_;
							vala_report_warning (_tmp396_, "Inline allocated arrays don't require an explicit instantiation");
							_tmp397_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp398_ = _tmp397_;
							_tmp399_ = vala_code_node_get_parent_node (_tmp398_);
							_tmp400_ = _tmp399_;
							_tmp401_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_empty_statement_new (_tmp404_);
							_tmp406_ = _tmp405_;
							vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp400_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp402_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp406_);
							_vala_code_node_unref0 (_tmp406_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
		_tmp408_ = vala_assignment_get_left (self);
		_tmp409_ = _tmp408_;
		_tmp410_ = vala_expression_get_value_type (_tmp409_);
		_tmp411_ = _tmp410_;
		if (_tmp411_ != NULL) {
			ValaExpression* _tmp412_;
			ValaExpression* _tmp413_;
			ValaDataType* _tmp414_;
			ValaDataType* _tmp415_;
			_tmp412_ = vala_assignment_get_right (self);
			_tmp413_ = _tmp412_;
			_tmp414_ = vala_expression_get_value_type (_tmp413_);
			_tmp415_ = _tmp414_;
			_tmp407_ = _tmp415_ != NULL;
		} else {
			_tmp407_ = FALSE;
		}
		if (_tmp407_) {
			ValaExpression* _tmp416_;
			ValaExpression* _tmp417_;
			ValaDataType* _tmp418_;
			ValaDataType* _tmp419_;
			ValaExpression* _tmp420_;
			ValaExpression* _tmp421_;
			ValaDataType* _tmp422_;
			ValaDataType* _tmp423_;
			ValaMemberAccess* _tmp440_;
			ValaSymbol* _tmp441_;
			ValaSymbol* _tmp442_;
			_tmp416_ = vala_assignment_get_right (self);
			_tmp417_ = _tmp416_;
			_tmp418_ = vala_expression_get_value_type (_tmp417_);
			_tmp419_ = _tmp418_;
			_tmp420_ = vala_assignment_get_left (self);
			_tmp421_ = _tmp420_;
			_tmp422_ = vala_expression_get_value_type (_tmp421_);
			_tmp423_ = _tmp422_;
			if (!vala_data_type_compatible (_tmp419_, _tmp423_)) {
				ValaSourceReference* _tmp424_;
				ValaSourceReference* _tmp425_;
				ValaExpression* _tmp426_;
				ValaExpression* _tmp427_;
				ValaDataType* _tmp428_;
				ValaDataType* _tmp429_;
				gchar* _tmp430_;
				gchar* _tmp431_;
				ValaExpression* _tmp432_;
				ValaExpression* _tmp433_;
				ValaDataType* _tmp434_;
				ValaDataType* _tmp435_;
				gchar* _tmp436_;
				gchar* _tmp437_;
				gchar* _tmp438_;
				gchar* _tmp439_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp424_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp425_ = _tmp424_;
				_tmp426_ = vala_assignment_get_right (self);
				_tmp427_ = _tmp426_;
				_tmp428_ = vala_expression_get_value_type (_tmp427_);
				_tmp429_ = _tmp428_;
				_tmp430_ = vala_code_node_to_string ((ValaCodeNode*) _tmp429_);
				_tmp431_ = _tmp430_;
				_tmp432_ = vala_assignment_get_left (self);
				_tmp433_ = _tmp432_;
				_tmp434_ = vala_expression_get_value_type (_tmp433_);
				_tmp435_ = _tmp434_;
				_tmp436_ = vala_code_node_to_string ((ValaCodeNode*) _tmp435_);
				_tmp437_ = _tmp436_;
				_tmp438_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp431_, _tmp437_);
				_tmp439_ = _tmp438_;
				vala_report_error (_tmp425_, _tmp439_);
				_g_free0 (_tmp439_);
				_g_free0 (_tmp437_);
				_g_free0 (_tmp431_);
				result = FALSE;
				return result;
			}
			_tmp440_ = ma;
			_tmp441_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp440_);
			_tmp442_ = _tmp441_;
			if (!VALA_IS_PROPERTY (_tmp442_)) {
				ValaExpression* _tmp443_;
				ValaExpression* _tmp444_;
				ValaDataType* _tmp445_;
				ValaDataType* _tmp446_;
				_tmp443_ = vala_assignment_get_right (self);
				_tmp444_ = _tmp443_;
				_tmp445_ = vala_expression_get_value_type (_tmp444_);
				_tmp446_ = _tmp445_;
				if (vala_data_type_is_disposable (_tmp446_)) {
					gboolean _tmp447_ = FALSE;
					ValaExpression* _tmp448_;
					ValaExpression* _tmp449_;
					ValaDataType* _tmp450_;
					ValaDataType* _tmp451_;
					_tmp448_ = vala_assignment_get_left (self);
					_tmp449_ = _tmp448_;
					_tmp450_ = vala_expression_get_value_type (_tmp449_);
					_tmp451_ = _tmp450_;
					if (!VALA_IS_POINTER_TYPE (_tmp451_)) {
						ValaExpression* _tmp452_;
						ValaExpression* _tmp453_;
						ValaDataType* _tmp454_;
						ValaDataType* _tmp455_;
						gboolean _tmp456_;
						gboolean _tmp457_;
						_tmp452_ = vala_assignment_get_left (self);
						_tmp453_ = _tmp452_;
						_tmp454_ = vala_expression_get_value_type (_tmp453_);
						_tmp455_ = _tmp454_;
						_tmp456_ = vala_data_type_get_value_owned (_tmp455_);
						_tmp457_ = _tmp456_;
						_tmp447_ = !_tmp457_;
					} else {
						_tmp447_ = FALSE;
					}
					if (_tmp447_) {
						ValaSourceReference* _tmp458_;
						ValaSourceReference* _tmp459_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp458_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp459_ = _tmp458_;
						vala_report_error (_tmp459_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp460_;
					ValaExpression* _tmp461_;
					ValaDataType* _tmp462_;
					ValaDataType* _tmp463_;
					gboolean _tmp464_;
					gboolean _tmp465_;
					_tmp460_ = vala_assignment_get_left (self);
					_tmp461_ = _tmp460_;
					_tmp462_ = vala_expression_get_value_type (_tmp461_);
					_tmp463_ = _tmp462_;
					_tmp464_ = vala_data_type_get_value_owned (_tmp463_);
					_tmp465_ = _tmp464_;
					if (_tmp465_) {
					}
				}
			}
		}
		_tmp466_ = vala_assignment_get_right (self);
		_tmp467_ = _tmp466_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp467_) ? ((ValaMemberAccess*) _tmp467_) : NULL;
		_tmp469_ = right_ma;
		if (_tmp469_ != NULL) {
			ValaMemberAccess* _tmp470_;
			ValaSymbol* _tmp471_;
			ValaSymbol* _tmp472_;
			ValaMemberAccess* _tmp473_;
			ValaSymbol* _tmp474_;
			ValaSymbol* _tmp475_;
			_tmp470_ = ma;
			_tmp471_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp470_);
			_tmp472_ = _tmp471_;
			_tmp473_ = right_ma;
			_tmp474_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp473_);
			_tmp475_ = _tmp474_;
			_tmp468_ = _tmp472_ == _tmp475_;
		} else {
			_tmp468_ = FALSE;
		}
		if (_tmp468_) {
			gboolean _tmp476_ = FALSE;
			ValaMemberAccess* _tmp477_;
			ValaSymbol* _tmp478_;
			ValaSymbol* _tmp479_;
			_tmp477_ = ma;
			_tmp478_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp477_);
			_tmp479_ = _tmp478_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp479_)) {
				_tmp476_ = TRUE;
			} else {
				ValaMemberAccess* _tmp480_;
				ValaSymbol* _tmp481_;
				ValaSymbol* _tmp482_;
				_tmp480_ = ma;
				_tmp481_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp480_);
				_tmp482_ = _tmp481_;
				_tmp476_ = VALA_IS_PARAMETER (_tmp482_);
			}
			if (_tmp476_) {
				ValaSourceReference* _tmp483_;
				ValaSourceReference* _tmp484_;
				_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp484_ = _tmp483_;
				vala_report_warning (_tmp484_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp485_;
				ValaSymbol* _tmp486_;
				ValaSymbol* _tmp487_;
				_tmp485_ = ma;
				_tmp486_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp485_);
				_tmp487_ = _tmp486_;
				if (VALA_IS_FIELD (_tmp487_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp488_;
					ValaSymbol* _tmp489_;
					ValaSymbol* _tmp490_;
					ValaField* _tmp491_;
					ValaMemberBinding _tmp492_;
					ValaMemberBinding _tmp493_;
					_tmp488_ = ma;
					_tmp489_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp488_);
					_tmp490_ = _tmp489_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp490_, VALA_TYPE_FIELD, ValaField);
					_tmp491_ = f;
					_tmp492_ = vala_field_get_binding (_tmp491_);
					_tmp493_ = _tmp492_;
					if (_tmp493_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp494_;
						ValaSourceReference* _tmp495_;
						_tmp494_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp495_ = _tmp494_;
						vala_report_warning (_tmp495_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp496_;
						ValaExpression* _tmp497_;
						ValaExpression* _tmp498_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp499_;
						ValaExpression* _tmp500_;
						ValaExpression* _tmp501_;
						gboolean _tmp502_ = FALSE;
						gboolean _tmp503_ = FALSE;
						gboolean _tmp504_ = FALSE;
						gboolean _tmp505_ = FALSE;
						gboolean _tmp506_ = FALSE;
						ValaMemberAccess* _tmp507_;
						_tmp496_ = ma;
						_tmp497_ = vala_member_access_get_inner (_tmp496_);
						_tmp498_ = _tmp497_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp498_) ? ((ValaMemberAccess*) _tmp498_) : NULL;
						_tmp499_ = right_ma;
						_tmp500_ = vala_member_access_get_inner (_tmp499_);
						_tmp501_ = _tmp500_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp501_) ? ((ValaMemberAccess*) _tmp501_) : NULL;
						_tmp507_ = ma_inner;
						if (_tmp507_ != NULL) {
							ValaMemberAccess* _tmp508_;
							const gchar* _tmp509_;
							const gchar* _tmp510_;
							_tmp508_ = ma_inner;
							_tmp509_ = vala_member_access_get_member_name (_tmp508_);
							_tmp510_ = _tmp509_;
							_tmp506_ = g_strcmp0 (_tmp510_, "this") == 0;
						} else {
							_tmp506_ = FALSE;
						}
						if (_tmp506_) {
							ValaMemberAccess* _tmp511_;
							ValaExpression* _tmp512_;
							ValaExpression* _tmp513_;
							_tmp511_ = ma_inner;
							_tmp512_ = vala_member_access_get_inner (_tmp511_);
							_tmp513_ = _tmp512_;
							_tmp505_ = _tmp513_ == NULL;
						} else {
							_tmp505_ = FALSE;
						}
						if (_tmp505_) {
							ValaMemberAccess* _tmp514_;
							_tmp514_ = right_ma_inner;
							_tmp504_ = _tmp514_ != NULL;
						} else {
							_tmp504_ = FALSE;
						}
						if (_tmp504_) {
							ValaMemberAccess* _tmp515_;
							const gchar* _tmp516_;
							const gchar* _tmp517_;
							_tmp515_ = right_ma_inner;
							_tmp516_ = vala_member_access_get_member_name (_tmp515_);
							_tmp517_ = _tmp516_;
							_tmp503_ = g_strcmp0 (_tmp517_, "this") == 0;
						} else {
							_tmp503_ = FALSE;
						}
						if (_tmp503_) {
							ValaMemberAccess* _tmp518_;
							ValaExpression* _tmp519_;
							ValaExpression* _tmp520_;
							_tmp518_ = right_ma_inner;
							_tmp519_ = vala_member_access_get_inner (_tmp518_);
							_tmp520_ = _tmp519_;
							_tmp502_ = _tmp520_ == NULL;
						} else {
							_tmp502_ = FALSE;
						}
						if (_tmp502_) {
							ValaSourceReference* _tmp521_;
							ValaSourceReference* _tmp522_;
							_tmp521_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							vala_report_warning (_tmp522_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaExpression* _tmp523_;
		ValaExpression* _tmp524_;
		_tmp523_ = vala_assignment_get_left (self);
		_tmp524_ = _tmp523_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp524_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp525_;
			ValaExpression* _tmp526_;
			ValaExpression* _tmp527_;
			ValaExpression* _tmp528_;
			ValaDataType* _tmp529_;
			ValaDataType* _tmp530_;
			ValaExpression* _tmp531_;
			ValaExpression* _tmp532_;
			ValaDataType* _tmp533_;
			ValaDataType* _tmp534_;
			ValaExpression* _tmp551_;
			ValaExpression* _tmp552_;
			ValaDataType* _tmp553_;
			ValaDataType* _tmp554_;
			_tmp525_ = vala_assignment_get_left (self);
			_tmp526_ = _tmp525_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp526_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp527_ = vala_assignment_get_right (self);
			_tmp528_ = _tmp527_;
			_tmp529_ = vala_expression_get_value_type (_tmp528_);
			_tmp530_ = _tmp529_;
			_tmp531_ = vala_assignment_get_left (self);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_expression_get_value_type (_tmp532_);
			_tmp534_ = _tmp533_;
			if (!vala_data_type_compatible (_tmp530_, _tmp534_)) {
				ValaSourceReference* _tmp535_;
				ValaSourceReference* _tmp536_;
				ValaExpression* _tmp537_;
				ValaExpression* _tmp538_;
				ValaDataType* _tmp539_;
				ValaDataType* _tmp540_;
				gchar* _tmp541_;
				gchar* _tmp542_;
				ValaExpression* _tmp543_;
				ValaExpression* _tmp544_;
				ValaDataType* _tmp545_;
				ValaDataType* _tmp546_;
				gchar* _tmp547_;
				gchar* _tmp548_;
				gchar* _tmp549_;
				gchar* _tmp550_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_assignment_get_right (self);
				_tmp538_ = _tmp537_;
				_tmp539_ = vala_expression_get_value_type (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = vala_code_node_to_string ((ValaCodeNode*) _tmp540_);
				_tmp542_ = _tmp541_;
				_tmp543_ = vala_assignment_get_left (self);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_expression_get_value_type (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = vala_code_node_to_string ((ValaCodeNode*) _tmp546_);
				_tmp548_ = _tmp547_;
				_tmp549_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp542_, _tmp548_);
				_tmp550_ = _tmp549_;
				vala_report_error (_tmp536_, _tmp550_);
				_g_free0 (_tmp550_);
				_g_free0 (_tmp548_);
				_g_free0 (_tmp542_);
				result = FALSE;
				return result;
			}
			_tmp551_ = vala_assignment_get_right (self);
			_tmp552_ = _tmp551_;
			_tmp553_ = vala_expression_get_value_type (_tmp552_);
			_tmp554_ = _tmp553_;
			if (vala_data_type_is_disposable (_tmp554_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp555_;
				ValaExpression* _tmp556_;
				ValaExpression* _tmp557_;
				ValaDataType* _tmp558_;
				ValaDataType* _tmp559_;
				gboolean _tmp581_ = FALSE;
				ValaDataType* _tmp582_;
				_tmp555_ = ea;
				_tmp556_ = vala_element_access_get_container (_tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_expression_get_value_type (_tmp557_);
				_tmp559_ = _tmp558_;
				if (VALA_IS_ARRAY_TYPE (_tmp559_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp560_;
					ValaExpression* _tmp561_;
					ValaExpression* _tmp562_;
					ValaDataType* _tmp563_;
					ValaDataType* _tmp564_;
					ValaArrayType* _tmp565_;
					ValaDataType* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					_tmp560_ = ea;
					_tmp561_ = vala_element_access_get_container (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = vala_expression_get_value_type (_tmp562_);
					_tmp564_ = _tmp563_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp564_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp565_ = array_type;
					_tmp566_ = vala_array_type_get_element_type (_tmp565_);
					_tmp567_ = _tmp566_;
					_tmp568_ = _vala_code_node_ref0 (_tmp567_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp568_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp569_;
					ValaExpression* _tmp570_;
					ValaExpression* _tmp571_;
					ValaDataType* _tmp572_;
					ValaDataType* _tmp573_;
					ValaList* _tmp574_;
					ValaList* _tmp575_;
					ValaList* _tmp576_;
					gint _tmp577_;
					gint _tmp578_;
					ValaList* _tmp579_;
					gpointer _tmp580_;
					_tmp569_ = ea;
					_tmp570_ = vala_element_access_get_container (_tmp569_);
					_tmp571_ = _tmp570_;
					_tmp572_ = vala_expression_get_value_type (_tmp571_);
					_tmp573_ = _tmp572_;
					_tmp574_ = vala_data_type_get_type_arguments (_tmp573_);
					_tmp575_ = _vala_iterable_ref0 (_tmp574_);
					args = _tmp575_;
					_tmp576_ = args;
					_tmp577_ = vala_collection_get_size ((ValaCollection*) _tmp576_);
					_tmp578_ = _tmp577_;
					_vala_assert (_tmp578_ == 1, "args.size == 1");
					_tmp579_ = args;
					_tmp580_ = vala_list_get (_tmp579_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp580_;
					_vala_iterable_unref0 (args);
				}
				_tmp582_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp582_)) {
					ValaDataType* _tmp583_;
					gboolean _tmp584_;
					gboolean _tmp585_;
					_tmp583_ = element_type;
					_tmp584_ = vala_data_type_get_value_owned (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp581_ = !_tmp585_;
				} else {
					_tmp581_ = FALSE;
				}
				if (_tmp581_) {
					ValaSourceReference* _tmp586_;
					ValaSourceReference* _tmp587_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp587_ = _tmp586_;
					vala_report_error (_tmp587_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp588_;
				ValaExpression* _tmp589_;
				ValaDataType* _tmp590_;
				ValaDataType* _tmp591_;
				gboolean _tmp592_;
				gboolean _tmp593_;
				_tmp588_ = vala_assignment_get_left (self);
				_tmp589_ = _tmp588_;
				_tmp590_ = vala_expression_get_value_type (_tmp589_);
				_tmp591_ = _tmp590_;
				_tmp592_ = vala_data_type_get_value_owned (_tmp591_);
				_tmp593_ = _tmp592_;
				if (_tmp593_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp594_ = vala_assignment_get_left (self);
	_tmp595_ = _tmp594_;
	_tmp596_ = vala_expression_get_value_type (_tmp595_);
	_tmp597_ = _tmp596_;
	if (_tmp597_ != NULL) {
		ValaExpression* _tmp598_;
		ValaExpression* _tmp599_;
		ValaDataType* _tmp600_;
		ValaDataType* _tmp601_;
		ValaDataType* _tmp602_;
		ValaDataType* _tmp603_;
		ValaDataType* _tmp604_;
		ValaDataType* _tmp605_;
		_tmp598_ = vala_assignment_get_left (self);
		_tmp599_ = _tmp598_;
		_tmp600_ = vala_expression_get_value_type (_tmp599_);
		_tmp601_ = _tmp600_;
		_tmp602_ = vala_data_type_copy (_tmp601_);
		_tmp603_ = _tmp602_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp603_);
		_vala_code_node_unref0 (_tmp603_);
		_tmp604_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp605_ = _tmp604_;
		vala_data_type_set_value_owned (_tmp605_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp606_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp607_ = _tmp606_;
	if (_tmp607_ != NULL) {
		ValaDataType* _tmp608_;
		ValaDataType* _tmp609_;
		_tmp608_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp609_ = _tmp608_;
		vala_code_node_check ((ValaCodeNode*) _tmp609_, context);
	}
	_tmp610_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp611_ = _tmp610_;
	result = !_tmp611_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_, NULL);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_, NULL);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

