(use-modules (g-wrap) (gtk-wrap))

(open-c-file "guile_gtk_defs")

(define gint int)
(define guint int)
(define gchar* char*)
(define guchar* char*)
(define gchar gint)
(define gfloat float)
(define GtkArrowType gint)
(define GtkShadowType gint)
(define GtkUpdateType gint)
(define GtkDirectionType gint)
(define GtkSelectionMode gint)
(define GtkMenuFactoryType gint)
(define GtkSubmenuPlacement gint)
(define GtkPositionType gint)
(define GtkPreviewType gint)
(define GtkMetricType gint)
(define GtkPolicyType gint)
(define GtkStateType gint)
(define GtkWindowType gint)
(define GtkWindowPosition gint)
(define GdkEventMask gint)
(define GdkVisualType gint)
(define GdkWindowType gint)
(define GdkCursorType gint)
(define GdkGCValuesMask gint)
(define GdkFunction gint)
(define GdkFill gint)
(define GdkSubwindowMode gint)
(define GdkLineStyle gint)
(define GdkCapStyle gint)
(define GdkJoinStyle gint)
(define GdkImageType gint)
(define GdkAtom gint)
(define GdkPropMode gint)

(wrap-gtk-typed-ptrs
 GSList* GList* GdkVisual* GdkColormap* GdkEvent* GdkWindow* GdkCursor*
 GdkWindowAttr* GdkColor* GdkPixmap* GdkGC* GdkGCValues* GdkFont*
 GdkBitmap* GdkImage* GdkDrawable* GdkPoint* GdkSegment* GdkRectangle*
 GtkAcceleratorTable* GtkStyle* GtkRequisition* GtkAllocation*
 GtkTooltips* GtkMenuFactory* GtkMenuEntry* GtkMenuPath*
 GtkTypeInfo*)

(define accelerator-table GtkAcceleratorTable*)
(define style GtkStyle*)
(define requisition GtkRequisition*)
(define allocation GtkAllocation*)
(define tooltips GtkTooltips*)
(define menu-factory GtkMenuFactory*)
(define menu-entry GtkMenuEntry*)
(define menu-path GtkMenuPath*)
(define type-info GtkTypeInfo*)

(define GdkBitmap** (make-ptr-ptr-type GdkBitmap*))

(new-c-code "tptr_make_GdkColor_" "make-GdkColor*"
	    GdkColor*
	    (list "  ret = (GdkColor*)malloc (sizeof (GdkColor));\n")
	    '()
	    "")

(wrap-gtk-types 
 tree-item tree text scrolled-window viewport radio-menu-item
 radio-button progress-bar pixmap option-menu notebook menu-path
 menu-bar menu menu-shell list-item list-widget image ruler
 file-selection drawing-area color-selection-dialog
 color-selection-dialog-class color-selection color-selection-class
 table scale range adjustment label entry preview-info preview window
 check-menu-item menu-item item toggle-button button box arrow misc
 aspect-frame frame alignment container widget object-class object
 dialog)

(wrap-gtk-accessors color-selection-dialog 
		    (widget colorsel)
		    (widget ok-button)
		    (widget cancel-button))

(wrap-gtk-accessors notebook
		    (guint tab-pos))

(wrap-gtk-accessors dialog
		    (widget vbox)
		    (widget action-area))

(wrap-gtk-accessors progress-bar
		    (gfloat percentage))

(wrap-gtk-funcs
 ; (void gdk-init (int* char***))
 (void gdk-exit (int))
 (gint gdk-events-pending (void))
 ; (gint gdk-event-get (GdkEvent* GdkEventFunc gpointer))
 (void gdk-event-put (GdkEvent*))
 (void gdk-set-debug-level (gint))
 (void gdk-set-show-events (gint))
 (void gdk-set-use-xshm (gint))
 (gint gdk-get-debug-level (void))
 (gint gdk-get-show-events (void))
 (gint gdk-get-use-xshm (void))
 (void gdk-timer-set (guint))
 (void gdk-timer-enable (void))
 (void gdk-timer-disable (void))
 ; (gint gdk-input-add (gint GdkInputCondition GdkInputFunction gpointer))
 (void gdk-input-remove (gint))
 (gint gdk-pointer-grab (GdkWindow* gint GdkEventMask GdkWindow* GdkCursor* guint))
 (void gdk-pointer-ungrab (guint))
 (gint gdk-keyboard-grab (GdkWindow* gint guint))
 (void gdk-keyboard-ungrab (guint))
 (gint gdk-screen-width (void))
 (gint gdk-screen-height (void))
 (void gdk-flush (void))
 (void gdk-beep (void))
 (void gdk-key-repeat-disable (void))
 (void gdk-key-repeat-restore (void))
 (gint gdk-visual-get-best-depth (void))
 (GdkVisualType gdk-visual-get-best-type (void))
 (GdkVisual* gdk-visual-get-system (void))
 (GdkVisual* gdk-visual-get-best (void))
 (GdkVisual* gdk-visual-get-best-with-depth (gint))
 (GdkVisual* gdk-visual-get-best-with-type (GdkVisualType))
 (GdkVisual* gdk-visual-get-best-with-both (gint GdkVisualType))
 ; (void gdk-query-depths (gint** gint*))
 ; (void gdk-query-visual-types (GdkVisualType** gint*))
 ; (void gdk-query-visuals (GdkVisual** gint*))
 (GdkWindow* gdk-window-new (GdkWindow* GdkWindowAttr* gint))
 (void gdk-window-destroy (GdkWindow*))
 (void gdk-window-show (GdkWindow*))
 (void gdk-window-hide (GdkWindow*))
 (void gdk-window-move (GdkWindow* gint gint))
 (void gdk-window-resize (GdkWindow* gint gint))
 (void gdk-window-move-resize (GdkWindow* gint gint gint gint))
 (void gdk-window-reparent (GdkWindow* GdkWindow* gint gint))
 (void gdk-window-clear (GdkWindow*))
 (void gdk-window-clear-area (GdkWindow* gint gint gint gint))
 (void gdk-window-raise (GdkWindow*))
 (void gdk-window-lower (GdkWindow*))
 ; (void gdk-window-set-user-data (GdkWindow* gpointer))
 (void gdk-window-set-hints (GdkWindow* gint gint gint gint gint gint gint))
 (void gdk-window-set-title (GdkWindow* gchar*))
 (void gdk-window-set-background (GdkWindow* GdkColor*))
 (void gdk-window-set-back-pixmap (GdkWindow* GdkPixmap* gint))
 (void gdk-window-set-cursor (GdkWindow* GdkCursor*))
 (void gdk-window-set-colormap (GdkWindow* GdkColormap*))
 ; (void gdk-window-get-user-data (GdkWindow* gpointer*))
 ; (void gdk-window-get-geometry (GdkWindow* gint* gint* gint* gint* gint*))
 ; (void gdk-window-get-position (GdkWindow* gint* gint*))
 ; (void gdk-window-get-size (GdkWindow* gint* gint*))
 (GdkVisual* gdk-window-get-visual (GdkWindow*))
 (GdkColormap* gdk-window-get-colormap (GdkWindow*))
 (GdkWindowType gdk-window-get-type (GdkWindow*))
 ; (gint gdk-window-get-origin (GdkWindow* gint* gint*))
 ; (GdkWindow* gdk-window-get-pointer (GdkWindow* gint* gint* GdkModifierType*))
 (GdkWindow* gdk-window-get-parent (GdkWindow*))
 (GdkWindow* gdk-window-get-toplevel (GdkWindow*))
 (GList* gdk-window-get-children (GdkWindow*))
 (GdkCursor* gdk-cursor-new (GdkCursorType))
 (void gdk-cursor-destroy (GdkCursor*))
 (GdkGC* gdk-gc-new (GdkWindow*))
 (GdkGC* gdk-gc-new-with-values (GdkWindow* GdkGCValues* GdkGCValuesMask))
 (void gdk-gc-destroy (GdkGC*))
 (void gdk-gc-get-values (GdkGC* GdkGCValues*))
 (void gdk-gc-set-foreground (GdkGC* GdkColor*))
 (void gdk-gc-set-background (GdkGC* GdkColor*))
 (void gdk-gc-set-font (GdkGC* GdkFont*))
 (void gdk-gc-set-function (GdkGC* GdkFunction))
 (void gdk-gc-set-fill (GdkGC* GdkFill))
 (void gdk-gc-set-tile (GdkGC* GdkPixmap*))
 (void gdk-gc-set-stipple (GdkGC* GdkPixmap*))
 (void gdk-gc-set-ts-origin (GdkGC* gint gint))
 (void gdk-gc-set-clip-origin (GdkGC* gint gint))
 (void gdk-gc-set-clip-mask (GdkGC* GdkBitmap*))
 (void gdk-gc-set-subwindow (GdkGC* GdkSubwindowMode))
 (void gdk-gc-set-exposures (GdkGC* gint))
 (void gdk-gc-set-line-attributes (GdkGC* gint GdkLineStyle GdkCapStyle GdkJoinStyle))
 (GdkPixmap* gdk-pixmap-new (GdkWindow* gint gint gint))
 (GdkBitmap* gdk-bitmap-create-from-data (GdkWindow* gchar* gint gint))
 (GdkPixmap* gdk-pixmap-create-from-data (GdkWindow* gchar* gint gint gint GdkColor* GdkColor*))
 (GdkPixmap* gdk-pixmap-create-from-xpm (GdkWindow* GdkBitmap** GdkColor* gchar*))
 ; (GdkPixmap* gdk-pixmap-create-from-xpm-d (GdkWindow* GdkBitmap** GdkColor* gchar**))
 (void gdk-pixmap-destroy (GdkPixmap*))
 (GdkImage* gdk-image-new (GdkImageType GdkVisual* gint gint))
 (GdkImage* gdk-image-get (GdkWindow* gint gint gint gint))
 (void gdk-image-put-pixel (GdkImage* gint gint guint))
 (void gdk-image-destroy (GdkImage*))
 (GdkColormap* gdk-colormap-new (GdkVisual* gint))
 (void gdk-colormap-destroy (GdkColormap*))
 (GdkColormap* gdk-colormap-get-system (void))
 (gint gdk-colormap-get-system-size (void))
 (void gdk-colormap-change (GdkColormap* gint))
 (void gdk-colors-store (GdkColormap* GdkColor* gint))
 ; (gint gdk-colors-alloc (GdkColormap* gint gulong* gint gulong* gint))
 ; (void gdk-colors-free (GdkColormap* gulong* gint gulong))
 (gint gdk-color-white (GdkColormap* GdkColor*))
 (gint gdk-color-black (GdkColormap* GdkColor*))
 (gint gdk-color-parse (gchar* GdkColor*))
 (gint gdk-color-alloc (GdkColormap* GdkColor*))
 (gint gdk-color-change (GdkColormap* GdkColor*))
 (gint gdk-color-equal (GdkColor* GdkColor*))
 (GdkFont* gdk-font-load (gchar*))
 (void gdk-font-free (GdkFont*))
 (void gdk-font-ref (GdkFont*))
 (gint gdk-font-id (GdkFont*))
 (gint gdk-font-equal (GdkFont* GdkFont*))
 (gint gdk-string-width (GdkFont* gchar*))
 (gint gdk-text-width (GdkFont* gchar* gint))
 (gint gdk-char-width (GdkFont* gchar))
 (gint gdk-string-measure (GdkFont* gchar*))
 (gint gdk-text-measure (GdkFont* gchar* gint))
 (gint gdk-char-measure (GdkFont* gchar))
 (void gdk-draw-line (GdkDrawable* GdkGC* gint gint gint gint))
 (void gdk-draw-rectangle (GdkDrawable* GdkGC* gint gint gint gint gint))
 (void gdk-draw-arc (GdkDrawable* GdkGC* gint gint gint gint gint gint gint))
 (void gdk-draw-polygon (GdkDrawable* GdkGC* gint GdkPoint* gint))
 (void gdk-draw-string (GdkDrawable* GdkGC* gint gint gchar*))
 (void gdk-draw-text (GdkDrawable* GdkGC* gint gint gchar* gint))
 (void gdk-draw-pixmap (GdkDrawable* GdkGC* GdkDrawable* gint gint gint gint gint gint))
 (void gdk-draw-bitmap (GdkDrawable* GdkGC* GdkDrawable* gint gint gint gint gint gint))
 (void gdk-draw-image (GdkDrawable* GdkGC* GdkImage* gint gint gint gint gint gint))
 (void gdk-draw-points (GdkDrawable* GdkGC* GdkPoint* gint))
 (void gdk-draw-segments (GdkDrawable* GdkGC* GdkSegment* gint))
 (gint gdk-selection-owner-set (GdkWindow* GdkAtom guint gint))
 (GdkWindow* gdk-selection-owner-get (GdkAtom))
 (void gdk-selection-convert (GdkWindow* GdkAtom guint))
 ; (void gdk-selection-get (GdkWindow* guchar**))
 (void gdk-selection-set (guint GdkAtom GdkAtom guint guchar* gint))
 (GdkAtom gdk-atom-intern (gchar* gint))
 ; (gint gdk-property-get (GdkWindow* GdkAtom GdkAtom gulong gulong gint GdkAtom* gint* guchar**))
 (void gdk-property-change (GdkWindow* GdkAtom GdkAtom gint GdkPropMode guchar* gint))
 (void gdk-property-delete (GdkWindow* GdkAtom))
 (gint gdk-rectangle-intersect (GdkRectangle* GdkRectangle* GdkRectangle*))
 (guint gtk-type-unique (guint type-info))
 (gchar* gtk-type-name (guint))
 (guint gtk-type-from-name (gchar*))
 (guint gtk-type-parent (guint))
 ; (gpointer gtk-type-class (guint))
 ; (gpointer gtk-type-new (guint))
 (void gtk-type-describe-heritage (guint))
 (void gtk-type-describe-tree (guint gint))
 (gint gtk-type-is-a (guint guint))
 ; (void gtk-type-set-arg (object guint arg))
 (guint gtk-object-get-type (void))
 ; (void gtk-object-class-add-signals (object-class gint* gint))
 (void gtk-object-ref (object))
 (void gtk-object-unref (object))
 ; (object gtk-object-new (guint dots))
 ; (object gtk-object-newv (guint gint arg))
 ; (void gtk-object-set (object dots))
 ; (void gtk-object-setv (object gint arg))
 ; (void gtk-object-add-arg-type (char* GtkArgType))
 ; (GtkArgType gtk-object-get-arg-type (char*))
 (void gtk-object-destroy (object))
 ; (void gtk-object-set-data (object dots gpointer))
 ; (gpointer gtk-object-get-data (object dots))
 ; (void gtk-object-remove-data (object dots))
 ; (void gtk-object-set-user-data (object gpointer))
 ; (gpointer gtk-object-get-user-data (object))
 (object gtk-object-check-cast (object guint))
 (object-class gtk-object-check-class-cast (object-class guint))
 (accelerator-table gtk-accelerator-table-new (void))
 (accelerator-table gtk-accelerator-table-find (object gchar* gchar guint))
 (void gtk-accelerator-table-destroy (accelerator-table))
 (void gtk-accelerator-table-ref (accelerator-table))
 (void gtk-accelerator-table-unref (accelerator-table))
 (void gtk-accelerator-table-install (accelerator-table object gchar* gchar guint))
 (void gtk-accelerator-table-remove (accelerator-table object gchar*))
 (gint gtk-accelerator-table-check (accelerator-table gchar guint))
 (guint gtk-data-get-type (void))
 (guint gtk-adjustment-get-type (void))
 (object gtk-adjustment-new (gfloat gfloat gfloat gfloat gfloat gfloat))
 (style gtk-style-new (void))
 (style gtk-style-attach (style GdkWindow*))
 (void gtk-style-detach (style))
 (void gtk-style-ref (style))
 (void gtk-style-unref (style))
 (void gtk-style-set-background (style GdkWindow* GtkStateType))
 (void gtk-draw-hline (style GdkWindow* GtkStateType gint gint gint))
 (void gtk-draw-vline (style GdkWindow* GtkStateType gint gint gint))
 (void gtk-draw-shadow (style GdkWindow* GtkStateType GtkShadowType gint gint gint gint))
 (void gtk-draw-polygon (style GdkWindow* GtkStateType GtkShadowType GdkPoint* gint gint))
 (void gtk-draw-arrow (style GdkWindow* GtkStateType GtkShadowType GtkArrowType gint gint gint gint gint))
 (void gtk-draw-diamond (style GdkWindow* GtkStateType GtkShadowType gint gint gint gint))
 (void gtk-draw-oval (style GdkWindow* GtkStateType GtkShadowType gint gint gint gint))
 (void gtk-draw-string (style GdkWindow* GtkStateType gint gint gchar*))
 (guint gtk-widget-get-type (void))
 ; (widget gtk-widget-new (guint dots))
 ; (widget gtk-widget-newv (guint gint arg))
 ; (void gtk-widget-set (widget dots))
 ; (void gtk-widget-setv (widget gint arg))
 (void gtk-widget-destroy (widget))
 (void gtk-widget-unparent (widget))
 (void gtk-widget-show (widget))
 (void gtk-widget-hide (widget))
 (void gtk-widget-map (widget))
 (void gtk-widget-unmap (widget))
 (void gtk-widget-realize (widget))
 (void gtk-widget-unrealize (widget))
 (void gtk-widget-draw (widget GdkRectangle*))
 (void gtk-widget-draw-focus (widget))
 (void gtk-widget-draw-default (widget))
 (void gtk-widget-draw-children (widget))
 (void gtk-widget-size-request (widget requisition))
 (void gtk-widget-size-allocate (widget allocation))
 (void gtk-widget-install-accelerator (widget accelerator-table gchar* gchar guint))
 (void gtk-widget-remove-accelerator (widget accelerator-table gchar*))
 (gint gtk-widget-event (widget GdkEvent*))
 (void gtk-widget-activate (widget))
 (void gtk-widget-reparent (widget widget))
 (void gtk-widget-popup (widget gint gint))
 (gint gtk-widget-intersect (widget GdkRectangle* GdkRectangle*))
 (gint gtk-widget-basic (widget))
 (void gtk-widget-grab-focus (widget))
 (void gtk-widget-grab-default (widget))
 (void gtk-widget-restore-state (widget))
 (void gtk-widget-set-name (widget gchar*))
 (gchar* gtk-widget-get-name (widget))
 (void gtk-widget-set-state (widget GtkStateType))
 (void gtk-widget-set-sensitive (widget gint))
 (void gtk-widget-set-parent (widget widget))
 (void gtk-widget-set-style (widget style))
 (void gtk-widget-set-uposition (widget gint gint))
 (void gtk-widget-set-usize (widget gint gint))
 (void gtk-widget-set-events (widget gint))
 (widget gtk-widget-get-toplevel (widget))
 (widget gtk-widget-get-ancestor (widget gint))
 (GdkColormap* gtk-widget-get-colormap (widget))
 (GdkVisual* gtk-widget-get-visual (widget))
 (style gtk-widget-get-style (widget))
 (gint gtk-widget-get-events (widget))
 ; (void gtk-widget-get-pointer (widget gint* gint*))
 (void gtk-widget-push-colormap (GdkColormap*))
 (void gtk-widget-push-visual (GdkVisual*))
 (void gtk-widget-push-style (style))
 (void gtk-widget-pop-colormap (void))
 (void gtk-widget-pop-visual (void))
 (void gtk-widget-pop-style (void))
 (void gtk-widget-set-default-colormap (GdkColormap*))
 (void gtk-widget-set-default-visual (GdkVisual*))
 (void gtk-widget-set-default-style (style))
 (GdkColormap* gtk-widget-get-default-colormap (void))
 (GdkVisual* gtk-widget-get-default-visual (void))
 (style gtk-widget-get-default-style (void))
 (guint gtk-container-get-type (void))
 (void gtk-container-border-width (container gint))
 (void gtk-container-add (container widget))
 (void gtk-container-remove (container widget))
 (void gtk-container-disable-resize (container))
 (void gtk-container-enable-resize (container))
 (void gtk-container-block-resize (container))
 (void gtk-container-unblock-resize (container))
 (gint gtk-container-need-resize (container widget))
 (void gtk-container-check-resize (container widget))
 ; (void gtk-container-foreach (container GtkCallback gpointer))
 (gint gtk-container-focus (container GtkDirectionType))
 (GList* gtk-container-children (container))
 (guint gtk-bin-get-type (void))
 (guint gtk-alignment-get-type (void))
 (widget gtk-alignment-new (gfloat gfloat gfloat gfloat))
 (void gtk-alignment-set (alignment gfloat gfloat gfloat gfloat))
 (guint gtk-frame-get-type (void))
 (widget gtk-frame-new (gchar*))
 (void gtk-frame-set-label (frame gchar*))
 (void gtk-frame-set-label-align (frame gfloat gfloat))
 (void gtk-frame-set-shadow-type (frame GtkShadowType))
 (guint gtk-aspect-frame-get-type (void))
 (widget gtk-aspect-frame-new (gchar* gfloat gfloat gfloat gint))
 (void gtk-aspect-frame-set (aspect-frame gfloat gfloat gfloat gint))
 (guint gtk-misc-get-type (void))
 (void gtk-misc-set-alignment (misc gfloat gfloat))
 (void gtk-misc-set-padding (misc gint gint))
 (guint gtk-arrow-get-type (void))
 (widget gtk-arrow-new (GtkArrowType GtkShadowType))
 (void gtk-arrow-set (arrow GtkArrowType GtkShadowType))
 (guint gtk-box-get-type (void))
 (void gtk-box-pack-start (box widget gint gint gint))
 (void gtk-box-pack-end (box widget gint gint gint))
 (void gtk-box-pack-start-defaults (box widget))
 (void gtk-box-pack-end-defaults (box widget))
 (void gtk-box-set-homogeneous (box gint))
 (void gtk-box-set-spacing (box gint))
 (guint gtk-button-get-type (void))
 (widget gtk-button-new (void))
 (widget gtk-button-new-with-label (gchar*))
 (void gtk-button-pressed (button))
 (void gtk-button-released (button))
 (void gtk-button-clicked (button))
 (void gtk-button-enter (button))
 (void gtk-button-leave (button))
 (guint gtk-toggle-button-get-type (void))
 (widget gtk-toggle-button-new (void))
 (widget gtk-toggle-button-new-with-label (gchar*))
 (void gtk-toggle-button-set-mode (toggle-button gint))
 (void gtk-toggle-button-set-state (toggle-button gint))
 (void gtk-toggle-button-toggled (toggle-button))
 (guint gtk-check-button-get-type (void))
 (widget gtk-check-button-new (void))
 (widget gtk-check-button-new-with-label (gchar*))
 (guint gtk-item-get-type (void))
 (void gtk-item-select (item))
 (void gtk-item-deselect (item))
 (void gtk-item-toggle (item))
 (guint gtk-menu-item-get-type (void))
 (widget gtk-menu-item-new (void))
 (widget gtk-menu-item-new-with-label (gchar*))
 (void gtk-menu-item-set-submenu (menu-item widget))
 (void gtk-menu-item-set-placement (menu-item GtkSubmenuPlacement))
 (void gtk-menu-item-accelerator-size (menu-item))
 (void gtk-menu-item-accelerator-text (menu-item gchar*))
 (void gtk-menu-item-configure (menu-item gint gint))
 (void gtk-menu-item-select (menu-item))
 (void gtk-menu-item-deselect (menu-item))
 (void gtk-menu-item-activate (menu-item))
 (guint gtk-check-menu-item-get-type (void))
 (widget gtk-check-menu-item-new (void))
 (widget gtk-check-menu-item-new-with-label (gchar*))
 (void gtk-check-menu-item-set-state (check-menu-item gint))
 (void gtk-check-menu-item-toggled (check-menu-item))
 (guint gtk-window-get-type (void))
 (widget gtk-window-new (GtkWindowType))
 (void gtk-window-set-title (window gchar*))
 (void gtk-window-set-focus (window widget))
 (void gtk-window-set-default (window widget))
 (void gtk-window-set-policy (window gint gint gint))
 (void gtk-window-add-accelerator-table (window accelerator-table))
 (void gtk-window-remove-accelerator-table (window accelerator-table))
 (void gtk-window-position (window GtkWindowPosition))
 (guint gtk-vbox-get-type (void))
 (widget gtk-vbox-new (gint gint))
 (guint gtk-preview-get-type (void))
 (void gtk-preview-uninit (void))
 (widget gtk-preview-new (GtkPreviewType))
 (void gtk-preview-size (preview gint gint))
 (void gtk-preview-put (preview GdkWindow* GdkGC* gint gint gint gint gint gint))
 (void gtk-preview-put-row (preview guchar* guchar* gint gint gint))
 (void gtk-preview-draw-row (preview guchar* gint gint gint))
 (void gtk-preview-set-expand (preview gint))
 (void gtk-preview-set-gamma (double))
 (void gtk-preview-set-color-cube (guint guint guint guint))
 (void gtk-preview-set-install-cmap (gint))
 (void gtk-preview-set-reserved (gint))
 (GdkVisual* gtk-preview-get-visual (void))
 (GdkColormap* gtk-preview-get-cmap (void))
 (preview-info gtk-preview-get-info (void))
 (guint gtk-entry-get-type (void))
 (widget gtk-entry-new (void))
 (void gtk-entry-set-text (entry gchar*))
 (void gtk-entry-append-text (entry gchar*))
 (void gtk-entry-prepend-text (entry gchar*))
 (void gtk-entry-set-position (entry gint))
 (gchar* gtk-entry-get-text (entry))
 (guint gtk-hbox-get-type (void))
 (widget gtk-hbox-new (gint gint))
 (guint gtk-label-get-type (void))
 (widget gtk-label-new (char*))
 (void gtk-label-set (label char*))
 ; (void gtk-label-get (label char**))
 ; (void gtk-init (int* char***))
 (void gtk-exit (gint))
 (void gtk-main (void))
 (void gtk-main-quit (void))
 (gint gtk-main-iteration (void))
 (void gtk-grab-add (widget))
 (void gtk-grab-remove (widget))
 ; (void gtk-init-add (GtkFunction gpointer))
 ; (gint gtk-timeout-add (guint GtkFunction gpointer))
 (void gtk-timeout-remove (gint))
 ; (gint gtk-idle-add (GtkFunction gpointer))
 (void gtk-idle-remove (gint))
 (void gtk-get-current-event (GdkEvent*))
 (widget gtk-get-event-widget (GdkEvent*))
 ; (gint gtk-signal-new (gchar* GtkSignalRunType gint gint GtkSignalMarshaller GtkArgType gint dots))
 (gint gtk-signal-lookup (gchar* gint))
 (gchar* gtk-signal-name (gint))
 ; (gint gtk-signal-emit (object gint dots))
 ; (gint gtk-signal-emit-by-name (object gchar* dots))
 (void gtk-signal-emit-stop (object gint))
 (void gtk-signal-emit-stop-by-name (object gchar*))
 ; (gint gtk-signal-connect (object gchar* GtkSignalFunc gpointer))
 ; (gint gtk-signal-connect-after (object gchar* GtkSignalFunc gpointer))
 ; (gint gtk-signal-connect-object (object gchar* GtkSignalFunc object))
 ; (gint gtk-signal-connect-object-after (object gchar* GtkSignalFunc object))
 (void gtk-signal-disconnect (object gint))
 ; (void gtk-signal-disconnect-by-data (object gpointer))
 (void gtk-signal-handler-block (object gint))
 ; (void gtk-signal-handler-block-by-data (object gpointer))
 (void gtk-signal-handler-unblock (object gint))
 ; (void gtk-signal-handler-unblock-by-data (object gpointer))
 (void gtk-signal-handlers-destroy (object))
 ; (void gtk-signal-default-marshaller (object GtkSignalFunc gpointer arg))
 ; (void gtk-signal-set-funcs (GtkSignalMarshal GtkSignalDestroy))
 (guint gtk-range-get-type (void))
 (adjustment gtk-range-get-adjustment (range))
 (void gtk-range-set-update-policy (range GtkUpdateType))
 (void gtk-range-set-adjustment (range adjustment))
 (void gtk-range-draw-background (range))
 (void gtk-range-draw-trough (range))
 (void gtk-range-draw-slider (range))
 (void gtk-range-draw-step-forw (range))
 (void gtk-range-draw-step-back (range))
 (void gtk-range-slider-update (range))
 (gint gtk-range-trough-click (range gint gint))
 (void gtk-range-default-hslider-update (range))
 (void gtk-range-default-vslider-update (range))
 (gint gtk-range-default-htrough-click (range gint gint))
 (gint gtk-range-default-vtrough-click (range gint gint))
 (void gtk-range-default-hmotion (range gint gint))
 (void gtk-range-default-vmotion (range gint gint))
 (gfloat gtk-range-calc-value (range gint))
 (guint gtk-scale-get-type (void))
 (void gtk-scale-set-digits (scale gint))
 (void gtk-scale-set-draw-value (scale gint))
 (void gtk-scale-set-value-pos (scale GtkPositionType))
 (gint gtk-scale-value-width (scale))
 (void gtk-scale-draw-value (scale))
 (guint gtk-hscale-get-type (void))
 (widget gtk-hscale-new (adjustment))
 (guint gtk-table-get-type (void))
 (widget gtk-table-new (gint gint gint))
 (void gtk-table-attach (table widget gint gint gint gint gint gint gint gint))
 (void gtk-table-attach-defaults (table widget gint gint gint gint))
 (void gtk-table-set-row-spacing (table gint gint))
 (void gtk-table-set-col-spacing (table gint gint))
 (void gtk-table-set-row-spacings (table gint))
 (void gtk-table-set-col-spacings (table gint))
 (guint gtk-color-selection-get-type (void))
 (void gtk-color-selection-class-init (color-selection-class))
 (void gtk-color-selection-init (color-selection))
 (widget gtk-color-selection-new (void))
 (void gtk-color-selection-set-update-policy (color-selection GtkUpdateType))
 (void gtk-color-selection-set-opacity (color-selection gint))
 ; (void gtk-color-selection-set-color (color-selection gdouble*))
 ; (void gtk-color-selection-get-color (color-selection gdouble*))
 (guint gtk-color-selection-dialog-get-type (void))
 (void gtk-color-selection-dialog-class-init (color-selection-dialog-class))
 (void gtk-color-selection-dialog-init (color-selection-dialog))
 (widget gtk-color-selection-dialog-new (gchar*))
 (guint gtk-dialog-get-type (void))
 (widget gtk-dialog-new (void))
 (guint gtk-drawing-area-get-type (void))
 (widget gtk-drawing-area-new (void))
 (void gtk-drawing-area-size (drawing-area gint gint))
 (guint gtk-file-selection-get-type (void))
 (widget gtk-file-selection-new (gchar*))
 (void gtk-file-selection-set-filename (file-selection gchar*))
 (gchar* gtk-file-selection-get-filename (file-selection))
 (GdkGC* gtk-gc-get (gint GdkColormap* GdkGCValues* GdkGCValuesMask))
 (void gtk-gc-release (GdkGC*))
 (guint gtk-ruler-get-type (void))
 (void gtk-ruler-set-metric (ruler GtkMetricType))
 (void gtk-ruler-set-range (ruler gfloat gfloat gfloat gfloat))
 (void gtk-ruler-draw-ticks (ruler))
 (void gtk-ruler-draw-pos (ruler))
 (guint gtk-hruler-get-type (void))
 (widget gtk-hruler-new (void))
 (guint gtk-scrollbar-get-type (void))
 (guint gtk-hscrollbar-get-type (void))
 (widget gtk-hscrollbar-new (adjustment))
 (guint gtk-separator-get-type (void))
 (guint gtk-hseparator-get-type (void))
 (widget gtk-hseparator-new (void))
 (guint gtk-image-get-type (void))
 (widget gtk-image-new (GdkImage* GdkBitmap*))
 (void gtk-image-set (image GdkImage* GdkBitmap*))
 ; (void gtk-image-get (image GdkImage** GdkBitmap**))
 (guint gtk-list-get-type (void))
 (widget gtk-list-new (void))
 (void gtk-list-insert-items (list-widget GList* gint))
 (void gtk-list-append-items (list-widget GList*))
 (void gtk-list-prepend-items (list-widget GList*))
 (void gtk-list-remove-items (list-widget GList*))
 (void gtk-list-clear-items (list-widget gint gint))
 (void gtk-list-select-item (list-widget gint))
 (void gtk-list-unselect-item (list-widget gint))
 (void gtk-list-select-child (list-widget widget))
 (void gtk-list-unselect-child (list-widget widget))
 (gint gtk-list-child-position (list-widget widget))
 (void gtk-list-set-selection-mode (list-widget GtkSelectionMode))
 (guint gtk-list-item-get-type (void))
 (widget gtk-list-item-new (void))
 (widget gtk-list-item-new-with-label (gchar*))
 (void gtk-list-item-select (list-item))
 (void gtk-list-item-deselect (list-item))
 (guint gtk-menu-shell-get-type (void))
 (void gtk-menu-shell-append (menu-shell widget))
 (void gtk-menu-shell-prepend (menu-shell widget))
 (void gtk-menu-shell-insert (menu-shell widget gint))
 (void gtk-menu-shell-deactivate (menu-shell))
 (guint gtk-menu-get-type (void))
 (widget gtk-menu-new (void))
 (void gtk-menu-append (menu widget))
 (void gtk-menu-prepend (menu widget))
 (void gtk-menu-insert (menu widget gint))
 ; (void gtk-menu-popup (menu widget widget GtkMenuPositionFunc gpointer gint guint))
 (void gtk-menu-popdown (menu))
 (widget gtk-menu-get-active (menu))
 (void gtk-menu-set-active (menu gint))
 (void gtk-menu-set-accelerator-table (menu accelerator-table))
 (guint gtk-menu-bar-get-type (void))
 (widget gtk-menu-bar-new (void))
 (void gtk-menu-bar-append (menu-bar widget))
 (void gtk-menu-bar-prepend (menu-bar widget))
 (void gtk-menu-bar-insert (menu-bar widget gint))
 (menu-factory gtk-menu-factory-new (GtkMenuFactoryType))
 (void gtk-menu-factory-destroy (menu-factory))
 (void gtk-menu-factory-add-entries (menu-factory menu-entry int))
 (void gtk-menu-factory-add-subfactory (menu-factory menu-factory char*))
 ; (void gtk-menu-factory-remove-paths (menu-factory char** int))
 (void gtk-menu-factory-remove-entries (menu-factory menu-entry int))
 (void gtk-menu-factory-remove-subfactory (menu-factory menu-factory char*))
 (menu-path gtk-menu-factory-find (menu-factory char*))
 (guint gtk-notebook-get-type (void))
 (widget gtk-notebook-new (void))
 (void gtk-notebook-append-page (notebook widget widget))
 (void gtk-notebook-prepend-page (notebook widget widget))
 (void gtk-notebook-insert-page (notebook widget widget gint))
 (void gtk-notebook-remove-page (notebook gint))
 (gint gtk-notebook-current-page (notebook))
 (void gtk-notebook-set-page (notebook gint))
 (void gtk-notebook-next-page (notebook))
 (void gtk-notebook-prev-page (notebook))
 (void gtk-notebook-set-tab-pos (notebook GtkPositionType))
 (void gtk-notebook-set-show-tabs (notebook gint))
 (void gtk-notebook-set-show-border (notebook gint))
 (guint gtk-option-menu-get-type (void))
 (widget gtk-option-menu-new (void))
 (widget gtk-option-menu-get-menu (option-menu))
 (void gtk-option-menu-set-menu (option-menu widget))
 (void gtk-option-menu-remove-menu (option-menu))
 (void gtk-option-menu-set-history (option-menu gint))
 (guint gtk-pixmap-get-type (void))
 (widget gtk-pixmap-new (GdkPixmap* GdkBitmap*))
 (void gtk-pixmap-set (pixmap GdkPixmap* GdkBitmap*))
 ; (void gtk-pixmap-get (pixmap GdkPixmap** GdkBitmap**))
 (guint gtk-progress-bar-get-type (void))
 (widget gtk-progress-bar-new (void))
 (void gtk-progress-bar-update (progress-bar gfloat))
 (guint gtk-radio-button-get-type (void))
 (widget gtk-radio-button-new (GSList*))
 (widget gtk-radio-button-new-with-label (GSList* gchar*))
 (GSList* gtk-radio-button-group (radio-button))
 (guint gtk-radio-menu-item-get-type (void))
 (widget gtk-radio-menu-item-new (GSList*))
 (widget gtk-radio-menu-item-new-with-label (GSList* gchar*))
 (GSList* gtk-radio-menu-item-group (radio-menu-item))
 (void gtk-rc-init (void))
 (void gtk-rc-parse (char*))
 (style gtk-rc-get-style (widget))
 (void gtk-rc-add-widget-name-style (style char*))
 (void gtk-rc-add-widget-class-style (style char*))
 (guint gtk-vscrollbar-get-type (void))
 (widget gtk-vscrollbar-new (adjustment))
 (guint gtk-viewport-get-type (void))
 (widget gtk-viewport-new (adjustment adjustment))
 (adjustment gtk-viewport-get-hadjustment (viewport))
 (adjustment gtk-viewport-get-vadjustment (viewport))
 (void gtk-viewport-set-hadjustment (viewport adjustment))
 (void gtk-viewport-set-vadjustment (viewport adjustment))
 (void gtk-viewport-set-shadow-type (viewport GtkShadowType))
 (guint gtk-scrolled-window-get-type (void))
 (widget gtk-scrolled-window-new (adjustment adjustment))
 (adjustment gtk-scrolled-window-get-hadjustment (scrolled-window))
 (adjustment gtk-scrolled-window-get-vadjustment (scrolled-window))
 (void gtk-scrolled-window-set-policy (scrolled-window GtkPolicyType GtkPolicyType))
 (guint gtk-text-get-type (void))
 (widget gtk-text-new (adjustment adjustment))
 (void gtk-text-set-editable (text gint))
 (void gtk-text-set-adjustments (text adjustment adjustment))
 (void gtk-text-set-point (text guint))
 (guint gtk-text-get-point (text))
 (guint gtk-text-get-length (text))
 (void gtk-text-freeze (text))
 (void gtk-text-thaw (text))
 ; (void gtk-text-insert (text GdkFont* GdkColor* GdkColor* dots gint))
 (gint gtk-text-backward-delete (text guint))
 (gint gtk-text-foreward-delete (text guint))
 (tooltips gtk-tooltips-new (void))
 (void gtk-tooltips-destroy (tooltips))
 (void gtk-tooltips-enable (tooltips))
 (void gtk-tooltips-disable (tooltips))
 (void gtk-tooltips-set-delay (tooltips gint))
 (void gtk-tooltips-set-tips (tooltips widget gchar*))
 (void gtk-tooltips-set-colors (tooltips GdkColor* GdkColor*))
 (guint gtk-tree-get-type (void))
 (widget gtk-tree-new (void))
 (void gtk-tree-append (tree widget))
 (void gtk-tree-prepend (tree widget))
 (void gtk-tree-insert (tree widget gint))
 (guint gtk-tree-item-get-type (void))
 (widget gtk-tree-item-new (void))
 (widget gtk-tree-item-new-with-label (gchar*))
 (void gtk-tree-item-set-subtree (tree-item widget))
 (void gtk-tree-item-select (tree-item))
 (void gtk-tree-item-deselect (tree-item))
 (void gtk-tree-item-expand (tree-item))
 (void gtk-tree-item-collapse (tree-item))
 (guint gtk-vruler-get-type (void))
 (widget gtk-vruler-new (void))
 (guint gtk-vscale-get-type (void))
 (widget gtk-vscale-new (adjustment))
 (guint gtk-vseparator-get-type (void))
 (widget gtk-vseparator-new (void)))

(new-function "GTK_WIDGET_SET_FLAGS" "gtk-widget-set-flags"
	      void (list widget guint) "")

(new-function "GTK_WIDGET_VISIBLE" "gtk-widget-visible?"
	      bool (list widget) "")

(wrap-gtk-consts
 GDK_WINDOW_ROOT GDK_WINDOW_TOPLEVEL GDK_WINDOW_CHILD
 GDK_WINDOW_DIALOG GDK_WINDOW_TEMP GDK_WINDOW_PIXMAP GDK_INPUT_OUTPUT
 GDK_INPUT_ONLY GDK_IMAGE_NORMAL GDK_IMAGE_SHARED GDK_IMAGE_FASTEST
 GDK_VISUAL_STATIC_GRAY GDK_VISUAL_GRAYSCALE GDK_VISUAL_STATIC_COLOR
 GDK_VISUAL_PSEUDO_COLOR GDK_VISUAL_TRUE_COLOR GDK_VISUAL_DIRECT_COLOR
 GDK_WA_TITLE GDK_WA_X GDK_WA_Y GDK_WA_CURSOR GDK_WA_COLORMAP
 GDK_WA_VISUAL GDK_HINT_POS GDK_HINT_MIN_SIZE GDK_HINT_MAX_SIZE
 GDK_COPY GDK_INVERT GDK_XOR GDK_SOLID GDK_TILED GDK_STIPPLED
 GDK_OPAQUE_STIPPLED GDK_LINE_SOLID GDK_LINE_ON_OFF_DASH
 GDK_LINE_DOUBLE_DASH GDK_CAP_NOT_LAST GDK_CAP_BUTT GDK_CAP_ROUND
 GDK_CAP_PROJECTING GDK_JOIN_MITER GDK_JOIN_ROUND GDK_JOIN_BEVEL
 GDK_NUM_GLYPHS GDK_X_CURSOR GDK_ARROW GDK_BASED_ARROW_DOWN
 GDK_BASED_ARROW_UP GDK_BOAT GDK_BOGOSITY GDK_BOTTOM_LEFT_CORNER
 GDK_BOTTOM_RIGHT_CORNER GDK_BOTTOM_SIDE GDK_BOTTOM_TEE GDK_BOX_SPIRAL
 GDK_CENTER_PTR GDK_CIRCLE GDK_CLOCK GDK_COFFEE_MUG GDK_CROSS
 GDK_CROSS_REVERSE GDK_CROSSHAIR GDK_DIAMOND_CROSS GDK_DOT GDK_DOTBOX
 GDK_DOUBLE_ARROW GDK_DRAFT_LARGE GDK_DRAFT_SMALL GDK_DRAPED_BOX
 GDK_EXCHANGE GDK_FLEUR GDK_GOBBLER GDK_GUMBY GDK_HAND1 GDK_HAND2
 GDK_HEART GDK_ICON GDK_IRON_CROSS GDK_LEFT_PTR GDK_LEFT_SIDE
 GDK_LEFT_TEE GDK_LEFTBUTTON GDK_LL_ANGLE GDK_LR_ANGLE GDK_MAN
 GDK_MIDDLEBUTTON GDK_MOUSE GDK_PENCIL GDK_PIRATE GDK_PLUS
 GDK_QUESTION_ARROW GDK_RIGHT_PTR GDK_RIGHT_SIDE GDK_RIGHT_TEE
 GDK_RIGHTBUTTON GDK_RTL_LOGO GDK_SAILBOAT GDK_SB_DOWN_ARROW
 GDK_SB_H_DOUBLE_ARROW GDK_SB_LEFT_ARROW GDK_SB_RIGHT_ARROW
 GDK_SB_UP_ARROW GDK_SB_V_DOUBLE_ARROW GDK_SHUTTLE GDK_SIZING
 GDK_SPIDER GDK_SPRAYCAN GDK_STAR GDK_TARGET GDK_TCROSS
 GDK_TOP_LEFT_ARROW GDK_TOP_LEFT_CORNER GDK_TOP_RIGHT_CORNER
 GDK_TOP_SIDE GDK_TOP_TEE GDK_TREK GDK_UL_ANGLE GDK_UMBRELLA
 GDK_UR_ANGLE GDK_WATCH GDK_XTERM GDK_LAST_CURSOR GDK_NOTHING
 GDK_DELETE GDK_DESTROY GDK_EXPOSE GDK_MOTION_NOTIFY GDK_BUTTON_PRESS
 GDK_2BUTTON_PRESS GDK_3BUTTON_PRESS GDK_BUTTON_RELEASE GDK_KEY_PRESS
 GDK_KEY_RELEASE GDK_ENTER_NOTIFY GDK_LEAVE_NOTIFY GDK_FOCUS_CHANGE
 GDK_CONFIGURE GDK_MAP GDK_UNMAP GDK_PROPERTY_NOTIFY
 GDK_SELECTION_CLEAR GDK_SELECTION_REQUEST GDK_SELECTION_NOTIFY
 GDK_OTHER_EVENT GDK_EXPOSURE_MASK GDK_POINTER_MOTION_MASK
 GDK_POINTER_MOTION_HINT_MASK GDK_BUTTON_MOTION_MASK
 GDK_BUTTON1_MOTION_MASK GDK_BUTTON2_MOTION_MASK
 GDK_BUTTON3_MOTION_MASK GDK_BUTTON_PRESS_MASK GDK_BUTTON_RELEASE_MASK
 GDK_KEY_PRESS_MASK GDK_KEY_RELEASE_MASK GDK_ENTER_NOTIFY_MASK
 GDK_LEAVE_NOTIFY_MASK GDK_FOCUS_CHANGE_MASK GDK_STRUCTURE_MASK
 GDK_ALL_EVENTS_MASK GDK_NOTIFY_ANCESTOR GDK_NOTIFY_VIRTUAL
 GDK_NOTIFY_INFERIOR GDK_NOTIFY_NONLINEAR GDK_NOTIFY_NONLINEAR_VIRTUAL
 GDK_NOTIFY_UNKNOWN GDK_SHIFT_MASK GDK_LOCK_MASK GDK_CONTROL_MASK
 GDK_MOD1_MASK GDK_MOD2_MASK GDK_MOD3_MASK GDK_MOD4_MASK GDK_MOD5_MASK
 GDK_BUTTON1_MASK GDK_BUTTON2_MASK GDK_BUTTON3_MASK GDK_BUTTON4_MASK
 GDK_BUTTON5_MASK GDK_CLIP_BY_CHILDREN GDK_INCLUDE_INFERIORS
 GDK_INPUT_READ GDK_INPUT_WRITE GDK_INPUT_EXCEPTION GDK_OK GDK_ERROR
 GDK_ERROR_PARAM GDK_ERROR_FILE GDK_ERROR_MEM GDK_LSB_FIRST
 GDK_MSB_FIRST GDK_GC_FOREGROUND GDK_GC_BACKGROUND GDK_GC_FONT
 GDK_GC_FUNCTION GDK_GC_FILL GDK_GC_TILE GDK_GC_STIPPLE
 GDK_GC_CLIP_MASK GDK_GC_SUBWINDOW GDK_GC_TS_X_ORIGIN
 GDK_GC_TS_Y_ORIGIN GDK_GC_CLIP_X_ORIGIN GDK_GC_CLIP_Y_ORIGIN
 GDK_GC_EXPOSURES GDK_GC_LINE_WIDTH GDK_GC_LINE_STYLE GDK_GC_CAP_STYLE
 GDK_GC_JOIN_STYLE GDK_SELECTION_PRIMARY GDK_SELECTION_SECONDARY
 GDK_PROPERTY_NEW_VALUE GDK_PROPERTY_DELETE GDK_PROP_MODE_REPLACE
 GDK_PROP_MODE_PREPEND GDK_PROP_MODE_APPEND GTK_ARG_INVALID
 GTK_ARG_NONE GTK_ARG_CHAR GTK_ARG_SHORT GTK_ARG_INT GTK_ARG_LONG
 GTK_ARG_POINTER GTK_ARG_OBJECT GTK_ARG_FUNCTION GTK_ARG_SIGNAL
 GTK_STATE_NORMAL GTK_STATE_ACTIVE GTK_STATE_PRELIGHT
 GTK_STATE_SELECTED GTK_STATE_INSENSITIVE GTK_WINDOW_TOPLEVEL
 GTK_WINDOW_DIALOG GTK_WINDOW_POPUP GTK_DIR_TAB_FORWARD
 GTK_DIR_TAB_BACKWARD GTK_DIR_UP GTK_DIR_DOWN GTK_DIR_LEFT
 GTK_DIR_RIGHT GTK_SHADOW_NONE GTK_SHADOW_IN GTK_SHADOW_OUT
 GTK_SHADOW_ETCHED_IN GTK_SHADOW_ETCHED_OUT GTK_ARROW_UP GTK_ARROW_DOWN
 GTK_ARROW_LEFT GTK_ARROW_RIGHT GTK_PACK_START GTK_PACK_END
 GTK_POLICY_ALWAYS GTK_POLICY_AUTOMATIC GTK_UPDATE_CONTINUOUS
 GTK_UPDATE_DISCONTINUOUS GTK_UPDATE_DELAYED GTK_EXPAND GTK_SHRINK
 GTK_FILL GTK_RUN_FIRST GTK_RUN_LAST GTK_RUN_BOTH GTK_RUN_MASK
 GTK_RUN_NO_RECURSE GTK_WIN_POS_NONE GTK_WIN_POS_CENTER
 GTK_WIN_POS_MOUSE GTK_DIRECTION_LEFT GTK_DIRECTION_RIGHT
 GTK_TOP_BOTTOM GTK_LEFT_RIGHT GTK_MENU_FACTORY_MENU
 GTK_MENU_FACTORY_MENU_BAR GTK_MENU_FACTORY_OPTION_MENU GTK_PIXELS
 GTK_INCHES GTK_CENTIMETERS GTK_SCROLL_NONE GTK_SCROLL_STEP_BACKWARD
 GTK_SCROLL_STEP_FORWARD GTK_SCROLL_PAGE_BACKWARD
 GTK_SCROLL_PAGE_FORWARD GTK_TROUGH_NONE GTK_TROUGH_START
 GTK_TROUGH_END GTK_POS_LEFT GTK_POS_RIGHT GTK_POS_TOP GTK_POS_BOTTOM
 GTK_PREVIEW_COLOR GTK_PREVIEW_GRAYSCALE GTK_NEED_DESTROY
 GTK_BEING_DESTROYED GTK_IN_CALL GTK_VISIBLE GTK_MAPPED GTK_UNMAPPED
 GTK_REALIZED GTK_SENSITIVE GTK_PARENT_SENSITIVE GTK_NO_WINDOW
 GTK_HAS_FOCUS GTK_CAN_FOCUS GTK_HAS_DEFAULT GTK_CAN_DEFAULT
 GTK_PROPAGATE_STATE GTK_ANCHORED GTK_BASIC GTK_USER_STYLE
 GTK_SELECTION_SINGLE GTK_SELECTION_BROWSE GTK_SELECTION_MULTIPLE
 GTK_SELECTION_EXTENDED)

(close-c-file)
