/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include "eval.h"
#include "dict.h"
#include "util.h"
#include "funclib.h"

static func_t * dict[DICT_LEN];
static int dictsize=0;


/*make builtin function and return it*/
func_t *
d_makebifunc(char *id, dictfunc f, int args)
{
	func_t *n;

	n=(func_t *)g_malloc(sizeof(func_t));
	n->id=(char *)g_malloc(strlen(id)+1);
	strcpy(n->id,id);
	n->data.func=f;
	n->args=args;
	n->type=BUILTIN_FUNC;

	return n;
}

/*make a user function and return it*/
func_t *
d_makeufunc(char *id, tree_t *value, int args)
{
	func_t *n;

	n=(func_t *)g_malloc(sizeof(func_t));
	n->id=(char *)g_malloc(strlen(id)+1);
	strcpy(n->id,id);
	n->data.value=value;
	n->args=args;
	n->type=USER_FUNC;

	return n;
}

/*add a functuion struct to the dict*/
int
d_addfunc(func_t *func)
{
	func_t *n;
	if(dictsize>=DICT_LEN) {
		freefunc(func);
		return FALSE;
	}
	n=d_lookup(func->id);
	if(n) {
		replacefunc(n,func);
		return TRUE;
	}
	dict[dictsize++]=func;
	return TRUE;
}

/*dictionary functions*/

func_t *
d_lookup(char *id)
{
	int i;

	for(i=0;i<dictsize;i++)
		if(strcmp(dict[i]->id,id)==0)
			return dict[i];
	return NULL;
}

int
d_delete(char *id)
{
	/*FIXME: Delete function!*/
	return FALSE;
}

void
freefunc(func_t *n)
{
	if(!n)
		return;
	if(n->id)
		g_free(n->id);
	if(n->type==USER_FUNC && n->data.value) 
		freetree(n->data.value);
	g_free(n);
}

/*replace old with stuff from new and free new*/
void
replacefunc(func_t *old,func_t *new)
{
	if(!old || !new)
		return;
	if(old->id)
		g_free(old->id);
	if(old->type==USER_FUNC && old->data.value) 
		freetree(old->data.value);
	old->id=new->id;
	old->type=new->type;
	old->data=new->data;
	g_free(new);
}
