/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _EVAL_H_
#define _EVAL_H_

#include <gmp.h>

/*declarations of structures*/
#include "structs.h"

typedef struct {
	tree_t * * stack;
	int size;
	int top;
} evalstack_t;

/* builtins */
#define E_EQUALS	1
#define E_PLUS		2
#define E_MINUS		3
#define E_MUL		4
#define E_DIV		5
#define E_MOD		6
#define E_NEG		7
#define E_EXP		8
#define E_FACT		9

/*functions for manipulating a tree*/
tree_t * makenum_z(mpz_t num);
tree_t * makenum_z_ui(unsigned long num);
tree_t * makenum_q(mpq_t num);
tree_t * makenum_f(mpf_t num);
tree_t * makefuncb(int func, evalstack_t * stack);
tree_t * makefuncd(func_t * func, evalstack_t * stack);

/*returns 1 or 2 depending if the operation has one or two branches*/
int branches(int op);

/*sets s to the string representation of the primitive, s has to be big
enough! */
void primstr(char *s, int op);

/*stack manipulation*/
int t_push(tree_t *n,evalstack_t * stack);
tree_t *t_pop(evalstack_t * stack);

/*functions for reclaiming memory*/
void freenode(tree_t *n);
void freetree(tree_t *n);
/*free arguments to a dictionary function*/
void freeargs(tree_t *n);

/*copy a node*/
tree_t * copynode(tree_t *o);

/*evaluate a treenode, the treenode will become a number node*/
/*the tree will be freed*/
tree_t *evalnode(tree_t *n);

/*make both number nodes the same type*/
void makesame(tree_t *l,tree_t *r);

/*make node float*/
void makefloat(tree_t *n);

/*make n an int if at all possible*/
void makeint(tree_t *n);

/*make float node rational*/
void makefloatrational(tree_t *n);

/*operations take two/one number nodes and return a number node*/
tree_t *plusop(tree_t *l,tree_t *r);
tree_t *minusop(tree_t *l,tree_t *r);
tree_t *mulop(tree_t *l,tree_t *r);
tree_t *divop(tree_t *l,tree_t *r);
tree_t *modop(tree_t *l,tree_t *r);
tree_t *negop(tree_t *l);
tree_t *expop(tree_t *l, tree_t *r);
tree_t *factop(tree_t *l);
tree_t *equalsop(tree_t *l, tree_t *r);

/*helper functions*/

/*this can do integer exponantiation with ints and rationals*/
tree_t * expopint(tree_t *l, tree_t *r);

/*my own power function for floats, very simple :) */
void mympf_pow_ui(mpf_t rop,mpf_t op,unsigned long e);

/*this can do rational exponantiation
  this is hardly an optimized calculaton!!!!!!!*/
tree_t * expoprat(tree_t *l, tree_t *r);

#endif
