/* Generated by gen-typeinfo func from "gtk.defs". */

#include <libguile.h>
#include <gtk/gtk.h>

#include "guile-gtk.h"
#include "gtk-compat.h"
#include "gtk-types.h"

SCM_PROC (s_gtk_style_get_white_interp, "gtk-style-get-white", 1, 0, 0, sgtk_style_get_white_interp);
SCM
sgtk_style_get_white_interp (SCM p_style)
{
  GdkColor* c_ret;
  GtkStyle* c_style;
  SCM_ASSERT (sgtk_valid_boxed (p_style, &sgtk_style_info), p_style, SCM_ARG1, s_gtk_style_get_white_interp);

  SCM_DEFER_INTS;
  c_style = (GtkStyle*)sgtk_scm2boxed (p_style);
  c_ret = gtk_style_get_white_interp (c_style);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_color_info, 1);
}

SCM_PROC (s_gdk_font_load, "gdk-font-load", 1, 0, 0, sgtk_gdk_font_load);
SCM
sgtk_gdk_font_load (SCM p_name)
{
  GdkFont* c_ret;
  char* c_name;
  p_name = sgtk_string_conversion (p_name);
  SCM_ASSERT ((SCM_NIMP(p_name) && SCM_STRINGP(p_name)), p_name, SCM_ARG1, s_gdk_font_load);

  SCM_DEFER_INTS;
  c_name = ((p_name) == SCM_BOOL_F? NULL : SCM_CHARS(p_name));
  c_ret = gdk_font_load (c_name);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_font_info, 1);
}

SCM_PROC (s_gtk_exit, "gtk-exit", 0, 1, 0, sgtk_exit);
SCM
sgtk_exit (SCM p_code)
{
  int c_code;
  if (p_code != SCM_UNDEFINED)
    SCM_ASSERT (SCM_INUMP (p_code), p_code, SCM_ARG1, s_gtk_exit);

  SCM_DEFER_INTS;
  if (p_code == SCM_UNDEFINED)
    c_code = 0;
  else
    c_code = SCM_INUM (p_code);
  gtk_exit (c_code);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_main, "gtk-main", 0, 0, 0, sgtk_main);
SCM
sgtk_main ()
{
  gtk_main ();

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_main_quit, "gtk-main-quit", 0, 0, 0, sgtk_main_quit);
SCM
sgtk_main_quit ()
{

  SCM_DEFER_INTS;
  gtk_main_quit ();
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_main_iteration, "gtk-main-iteration", 0, 0, 0, sgtk_main_iteration);
SCM
sgtk_main_iteration ()
{
  int c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_main_iteration ();
  SCM_ALLOW_INTS;

  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_timeout_add_interp, "gtk-timeout-add", 2, 0, 0, sgtk_timeout_add_interp);
SCM
sgtk_timeout_add_interp (SCM p_interval, SCM p_function)
{
  int c_ret;
  int c_interval;
  SCM c_function;
  SCM_ASSERT (SCM_INUMP (p_interval), p_interval, SCM_ARG1, s_gtk_timeout_add_interp);
  SCM_ASSERT ((scm_procedure_p(p_function) == SCM_BOOL_T), p_function, SCM_ARG2, s_gtk_timeout_add_interp);

  SCM_DEFER_INTS;
  c_interval = SCM_INUM (p_interval);
  c_function = sgtk_protect_scm (p_function);
  c_ret = gtk_timeout_add_interp (c_interval, sgtk_callback_marshal, (gpointer)c_function, sgtk_callback_destroy);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_timeout_remove, "gtk-timeout-remove", 1, 0, 0, sgtk_timeout_remove);
SCM
sgtk_timeout_remove (SCM p_tag)
{
  int c_tag;
  SCM_ASSERT (SCM_INUMP (p_tag), p_tag, SCM_ARG1, s_gtk_timeout_remove);

  SCM_DEFER_INTS;
  c_tag = SCM_INUM (p_tag);
  gtk_timeout_remove (c_tag);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_idle_add_interp, "gtk-idle-add", 1, 0, 0, sgtk_idle_add_interp);
SCM
sgtk_idle_add_interp (SCM p_function)
{
  int c_ret;
  SCM c_function;
  SCM_ASSERT ((scm_procedure_p(p_function) == SCM_BOOL_T), p_function, SCM_ARG1, s_gtk_idle_add_interp);

  SCM_DEFER_INTS;
  c_function = sgtk_protect_scm (p_function);
  c_ret = gtk_idle_add_interp (sgtk_callback_marshal, (gpointer)c_function, sgtk_callback_destroy);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_idle_remove, "gtk-idle-remove", 1, 0, 0, sgtk_idle_remove);
SCM
sgtk_idle_remove (SCM p_tag)
{
  int c_tag;
  SCM_ASSERT (SCM_INUMP (p_tag), p_tag, SCM_ARG1, s_gtk_idle_remove);

  SCM_DEFER_INTS;
  c_tag = SCM_INUM (p_tag);
  gtk_idle_remove (c_tag);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_input_add_interp, "gtk-input-add", 3, 0, 0, sgtk_input_add_interp);
SCM
sgtk_input_add_interp (SCM p_source, SCM p_condition, SCM p_callback)
{
  int c_ret;
  int c_source;
  GdkInputCondition c_condition;
  SCM c_callback;
  SCM_ASSERT ((SCM_NIMP (p_source) && SCM_TYP16 (p_source) == scm_tc16_fport && SCM_OPPORTP (p_source)), p_source, SCM_ARG1, s_gtk_input_add_interp);
  SCM_ASSERT (sgtk_valid_flags (p_condition, &sgtk_gdk_input_condition_info), p_condition, SCM_ARG2, s_gtk_input_add_interp);
  SCM_ASSERT ((scm_procedure_p(p_callback) == SCM_BOOL_T), p_callback, SCM_ARG3, s_gtk_input_add_interp);

  SCM_DEFER_INTS;
  c_source = fileno ((FILE *) SCM_STREAM (p_source));
  c_condition = sgtk_scm2flags (p_condition, &sgtk_gdk_input_condition_info);
  c_callback = sgtk_protect_scm (p_callback);
  c_ret = gtk_input_add_interp (c_source, c_condition, sgtk_callback_marshal, (gpointer)c_callback, sgtk_callback_destroy);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_input_remove, "gtk-input-remove", 1, 0, 0, sgtk_input_remove);
SCM
sgtk_input_remove (SCM p_tag)
{
  int c_tag;
  SCM_ASSERT (SCM_INUMP (p_tag), p_tag, SCM_ARG1, s_gtk_input_remove);

  SCM_DEFER_INTS;
  c_tag = SCM_INUM (p_tag);
  gtk_input_remove (c_tag);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_rc_parse, "gtk-rc-parse", 1, 0, 0, sgtk_rc_parse);
SCM
sgtk_rc_parse (SCM p_file)
{
  char* c_file;
  p_file = sgtk_string_conversion (p_file);
  SCM_ASSERT ((SCM_NIMP(p_file) && SCM_STRINGP(p_file)), p_file, SCM_ARG1, s_gtk_rc_parse);

  SCM_DEFER_INTS;
  c_file = ((p_file) == SCM_BOOL_F? NULL : SCM_CHARS(p_file));
  gtk_rc_parse (c_file);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_g_mem_chunk_info, "g-mem-chunk-info", 0, 0, 0, sgtk_g_mem_chunk_info);
SCM
sgtk_g_mem_chunk_info ()
{

  SCM_DEFER_INTS;
  g_mem_chunk_info ();
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_object_destroy, "gtk-object-destroy", 1, 0, 0, sgtk_object_destroy);
SCM
sgtk_object_destroy (SCM p_object)
{
  GtkObject* c_object;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_object_get_type (), p_object), p_object, SCM_ARG1, s_gtk_object_destroy);

  SCM_DEFER_INTS;
  c_object = (GtkObject*)sgtk_get_gtkobj (p_object);
  gtk_object_destroy (c_object);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_signal_connect_interp, "gtk-signal-connect", 3, 1, 0, sgtk_signal_connect_interp);
SCM
sgtk_signal_connect_interp (SCM p_object, SCM p_name, SCM p_func, SCM p_after)
{
  int c_ret;
  GtkObject* c_object;
  char* c_name;
  SCM c_func;
  int c_after;
  p_name = sgtk_string_conversion (p_name);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_object_get_type (), p_object), p_object, SCM_ARG1, s_gtk_signal_connect_interp);
  SCM_ASSERT ((SCM_NIMP(p_name) && SCM_STRINGP(p_name)), p_name, SCM_ARG2, s_gtk_signal_connect_interp);
  SCM_ASSERT ((scm_procedure_p(p_func) == SCM_BOOL_T), p_func, SCM_ARG3, s_gtk_signal_connect_interp);
  if (p_after != SCM_UNDEFINED)
    SCM_ASSERT (((p_after) == SCM_BOOL_T || (p_after) == SCM_BOOL_F), p_after, SCM_ARG4, s_gtk_signal_connect_interp);

  SCM_DEFER_INTS;
  c_object = (GtkObject*)sgtk_get_gtkobj (p_object);
  c_name = ((p_name) == SCM_BOOL_F? NULL : SCM_CHARS(p_name));
  c_func = sgtk_protect_scm (p_func);
  if (p_after == SCM_UNDEFINED)
    c_after = 0;
  else
    c_after = SCM_NFALSEP (p_after);
  c_ret = gtk_signal_connect_interp (c_object, c_name, sgtk_callback_marshal, (gpointer)c_func, sgtk_callback_destroy, c_after);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_signal_disconnect, "gtk-signal-disconnect", 2, 0, 0, sgtk_signal_disconnect);
SCM
sgtk_signal_disconnect (SCM p_object, SCM p_id)
{
  GtkObject* c_object;
  int c_id;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_object_get_type (), p_object), p_object, SCM_ARG1, s_gtk_signal_disconnect);
  SCM_ASSERT (SCM_INUMP (p_id), p_id, SCM_ARG2, s_gtk_signal_disconnect);

  SCM_DEFER_INTS;
  c_object = (GtkObject*)sgtk_get_gtkobj (p_object);
  c_id = SCM_INUM (p_id);
  gtk_signal_disconnect (c_object, c_id);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_p, "gtk-widget?", 1, 0, 0, sgtk_widget_p);
SCM
sgtk_widget_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_widget_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_widget_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_widget_style, "gtk-widget-style", 1, 0, 0, sgtk_widget_style);
SCM
sgtk_widget_style (SCM p_obj)
{
  GtkStyle* c_ret;
  GtkWidget* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_widget_style);
  c_obj = (GtkWidget*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->style;

  return sgtk_boxed2scm (c_ret, &sgtk_style_info, 1);
}

SCM_PROC (s_gtk_grab_add, "gtk-grab-add", 1, 0, 0, sgtk_grab_add);
SCM
sgtk_grab_add (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_grab_add);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_grab_add (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_grab_remove, "gtk-grab-remove", 1, 0, 0, sgtk_grab_remove);
SCM
sgtk_grab_remove (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_grab_remove);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_grab_remove (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_state, "gtk-widget-state", 1, 0, 0, sgtk_widget_state);
SCM
sgtk_widget_state (SCM p_widget)
{
  GtkStateType c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_state);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = GTK_WIDGET_STATE (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_enum2scm (c_ret, &sgtk_state_type_info);
}

SCM_PROC (s_gtk_widget_flags, "gtk-widget-flags", 1, 0, 0, sgtk_widget_flags);
SCM
sgtk_widget_flags (SCM p_widget)
{
  GtkWidgetFlags c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_flags);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = GTK_WIDGET_FLAGS (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_flags2scm (c_ret, &sgtk_widget_flags_info);
}

SCM_PROC (s_gtk_widget_set_flags, "gtk-widget-set-flags", 2, 0, 0, sgtk_widget_set_flags);
SCM
sgtk_widget_set_flags (SCM p_widget, SCM p_flags)
{
  GtkWidget* c_widget;
  GtkWidgetFlags c_flags;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_flags);
  SCM_ASSERT (sgtk_valid_flags (p_flags, &sgtk_widget_flags_info), p_flags, SCM_ARG2, s_gtk_widget_set_flags);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_flags = sgtk_scm2flags (p_flags, &sgtk_widget_flags_info);
  GTK_WIDGET_SET_FLAGS (c_widget, c_flags);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_unset_flags, "gtk-widget-unset-flags", 2, 0, 0, sgtk_widget_unset_flags);
SCM
sgtk_widget_unset_flags (SCM p_widget, SCM p_flags)
{
  GtkWidget* c_widget;
  GtkWidgetFlags c_flags;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_unset_flags);
  SCM_ASSERT (sgtk_valid_flags (p_flags, &sgtk_widget_flags_info), p_flags, SCM_ARG2, s_gtk_widget_unset_flags);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_flags = sgtk_scm2flags (p_flags, &sgtk_widget_flags_info);
  GTK_WIDGET_UNSET_FLAGS (c_widget, c_flags);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_destroy, "gtk-widget-destroy", 1, 0, 0, sgtk_widget_destroy);
SCM
sgtk_widget_destroy (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_destroy);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_destroy (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_unparent, "gtk-widget-unparent", 1, 0, 0, sgtk_widget_unparent);
SCM
sgtk_widget_unparent (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_unparent);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_unparent (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_show, "gtk-widget-show", 1, 0, 0, sgtk_widget_show);
SCM
sgtk_widget_show (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_show);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_show (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_hide, "gtk-widget-hide", 1, 0, 0, sgtk_widget_hide);
SCM
sgtk_widget_hide (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_hide);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_hide (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_map, "gtk-widget-map", 1, 0, 0, sgtk_widget_map);
SCM
sgtk_widget_map (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_map);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_map (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_unmap, "gtk-widget-unmap", 1, 0, 0, sgtk_widget_unmap);
SCM
sgtk_widget_unmap (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_unmap);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_unmap (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_realize, "gtk-widget-realize", 1, 0, 0, sgtk_widget_realize);
SCM
sgtk_widget_realize (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_realize);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_realize (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_unrealize, "gtk-widget-unrealize", 1, 0, 0, sgtk_widget_unrealize);
SCM
sgtk_widget_unrealize (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_unrealize);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_unrealize (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_remove_accelerator, "gtk-widget-remove-accelerator", 3, 0, 0, sgtk_widget_remove_accelerator);
SCM
sgtk_widget_remove_accelerator (SCM p_widget, SCM p_table, SCM p_signal_name)
{
  GtkWidget* c_widget;
  GtkAcceleratorTable* c_table;
  char* c_signal_name;
  p_signal_name = sgtk_string_conversion (p_signal_name);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_remove_accelerator);
  SCM_ASSERT (sgtk_valid_boxed (p_table, &sgtk_accelerator_table_info), p_table, SCM_ARG2, s_gtk_widget_remove_accelerator);
  SCM_ASSERT ((SCM_NIMP(p_signal_name) && SCM_STRINGP(p_signal_name)), p_signal_name, SCM_ARG3, s_gtk_widget_remove_accelerator);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_table = (GtkAcceleratorTable*)sgtk_scm2boxed (p_table);
  c_signal_name = ((p_signal_name) == SCM_BOOL_F? NULL : SCM_CHARS(p_signal_name));
  gtk_widget_remove_accelerator (c_widget, c_table, c_signal_name);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_event, "gtk-widget-event", 2, 0, 0, sgtk_widget_event);
SCM
sgtk_widget_event (SCM p_widget, SCM p_event)
{
  int c_ret;
  GtkWidget* c_widget;
  GdkEvent* c_event;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_event);
  SCM_ASSERT (sgtk_valid_boxed (p_event, &sgtk_gdk_event_info), p_event, SCM_ARG2, s_gtk_widget_event);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_event = (GdkEvent*)sgtk_scm2boxed (p_event);
  c_ret = gtk_widget_event (c_widget, c_event);
  SCM_ALLOW_INTS;

  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_widget_activate, "gtk-widget-activate", 1, 0, 0, sgtk_widget_activate);
SCM
sgtk_widget_activate (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_activate);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_activate (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_reparent, "gtk-widget-reparent", 2, 0, 0, sgtk_widget_reparent);
SCM
sgtk_widget_reparent (SCM p_widget, SCM p_new_parent)
{
  GtkWidget* c_widget;
  GtkWidget* c_new_parent;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_reparent);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_new_parent), p_new_parent, SCM_ARG2, s_gtk_widget_reparent);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_new_parent = (GtkWidget*)sgtk_get_gtkobj (p_new_parent);
  gtk_widget_reparent (c_widget, c_new_parent);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_popup, "gtk-widget-popup", 3, 0, 0, sgtk_widget_popup);
SCM
sgtk_widget_popup (SCM p_widget, SCM p_x, SCM p_y)
{
  GtkWidget* c_widget;
  int c_x;
  int c_y;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_popup);
  SCM_ASSERT (SCM_INUMP (p_x), p_x, SCM_ARG2, s_gtk_widget_popup);
  SCM_ASSERT (SCM_INUMP (p_y), p_y, SCM_ARG3, s_gtk_widget_popup);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_x = SCM_INUM (p_x);
  c_y = SCM_INUM (p_y);
  gtk_widget_popup (c_widget, c_x, c_y);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_basic, "gtk-widget-basic", 1, 0, 0, sgtk_widget_basic);
SCM
sgtk_widget_basic (SCM p_widget)
{
  int c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_basic);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_basic (c_widget);
  SCM_ALLOW_INTS;

  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_widget_grab_focus, "gtk-widget-grab-focus", 1, 0, 0, sgtk_widget_grab_focus);
SCM
sgtk_widget_grab_focus (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_grab_focus);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_grab_focus (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_grab_default, "gtk-widget-grab-default", 1, 0, 0, sgtk_widget_grab_default);
SCM
sgtk_widget_grab_default (SCM p_widget)
{
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_grab_default);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_widget_grab_default (c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_name, "gtk-widget-set-name", 2, 0, 0, sgtk_widget_set_name);
SCM
sgtk_widget_set_name (SCM p_widget, SCM p_name)
{
  GtkWidget* c_widget;
  char* c_name;
  p_name = sgtk_string_conversion (p_name);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_name);
  SCM_ASSERT ((SCM_NIMP(p_name) && SCM_STRINGP(p_name)), p_name, SCM_ARG2, s_gtk_widget_set_name);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_name = ((p_name) == SCM_BOOL_F? NULL : SCM_CHARS(p_name));
  gtk_widget_set_name (c_widget, c_name);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_get_name, "gtk-widget-get-name", 1, 0, 0, sgtk_widget_get_name);
SCM
sgtk_widget_get_name (SCM p_widget)
{
  char* c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_name);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_name (c_widget);
  SCM_ALLOW_INTS;

  return (c_ret == NULL? SCM_BOOL_F : scm_makfrom0str (c_ret));
}

SCM_PROC (s_gtk_widget_set_state, "gtk-widget-set-state", 2, 0, 0, sgtk_widget_set_state);
SCM
sgtk_widget_set_state (SCM p_widget, SCM p_state)
{
  GtkWidget* c_widget;
  GtkStateType c_state;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_state);
  SCM_ASSERT (sgtk_valid_enum (p_state, &sgtk_state_type_info), p_state, SCM_ARG2, s_gtk_widget_set_state);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_state = sgtk_scm2enum (p_state, &sgtk_state_type_info);
  gtk_widget_set_state (c_widget, c_state);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_sensitive, "gtk-widget-set-sensitive", 2, 0, 0, sgtk_widget_set_sensitive);
SCM
sgtk_widget_set_sensitive (SCM p_widget, SCM p_sensitive)
{
  GtkWidget* c_widget;
  int c_sensitive;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_sensitive);
  SCM_ASSERT (((p_sensitive) == SCM_BOOL_T || (p_sensitive) == SCM_BOOL_F), p_sensitive, SCM_ARG2, s_gtk_widget_set_sensitive);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_sensitive = SCM_NFALSEP (p_sensitive);
  gtk_widget_set_sensitive (c_widget, c_sensitive);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_style, "gtk-widget-set-style", 2, 0, 0, sgtk_widget_set_style);
SCM
sgtk_widget_set_style (SCM p_widget, SCM p_style)
{
  GtkWidget* c_widget;
  GtkStyle* c_style;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_style);
  SCM_ASSERT (sgtk_valid_boxed (p_style, &sgtk_style_info), p_style, SCM_ARG2, s_gtk_widget_set_style);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_style = (GtkStyle*)sgtk_scm2boxed (p_style);
  gtk_widget_set_style (c_widget, c_style);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_uposition, "gtk-widget-set-uposition", 3, 0, 0, sgtk_widget_set_uposition);
SCM
sgtk_widget_set_uposition (SCM p_widget, SCM p_x, SCM p_y)
{
  GtkWidget* c_widget;
  int c_x;
  int c_y;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_uposition);
  SCM_ASSERT (SCM_INUMP (p_x), p_x, SCM_ARG2, s_gtk_widget_set_uposition);
  SCM_ASSERT (SCM_INUMP (p_y), p_y, SCM_ARG3, s_gtk_widget_set_uposition);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_x = SCM_INUM (p_x);
  c_y = SCM_INUM (p_y);
  gtk_widget_set_uposition (c_widget, c_x, c_y);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_usize, "gtk-widget-set-usize", 3, 0, 0, sgtk_widget_set_usize);
SCM
sgtk_widget_set_usize (SCM p_widget, SCM p_height, SCM p_width)
{
  GtkWidget* c_widget;
  int c_height;
  int c_width;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_usize);
  SCM_ASSERT (SCM_INUMP (p_height), p_height, SCM_ARG2, s_gtk_widget_set_usize);
  SCM_ASSERT (SCM_INUMP (p_width), p_width, SCM_ARG3, s_gtk_widget_set_usize);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_height = SCM_INUM (p_height);
  c_width = SCM_INUM (p_width);
  gtk_widget_set_usize (c_widget, c_height, c_width);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_events, "gtk-widget-set-events", 2, 0, 0, sgtk_widget_set_events);
SCM
sgtk_widget_set_events (SCM p_widget, SCM p_events)
{
  GtkWidget* c_widget;
  GdkEventMask c_events;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_events);
  SCM_ASSERT (sgtk_valid_flags (p_events, &sgtk_gdk_event_mask_info), p_events, SCM_ARG2, s_gtk_widget_set_events);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_events = sgtk_scm2flags (p_events, &sgtk_gdk_event_mask_info);
  gtk_widget_set_events (c_widget, c_events);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_extension_events, "gtk-widget-set-extension-events", 2, 0, 0, sgtk_widget_set_extension_events);
SCM
sgtk_widget_set_extension_events (SCM p_widget, SCM p_events)
{
  GtkWidget* c_widget;
  GdkEventMask c_events;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_set_extension_events);
  SCM_ASSERT (sgtk_valid_flags (p_events, &sgtk_gdk_event_mask_info), p_events, SCM_ARG2, s_gtk_widget_set_extension_events);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_events = sgtk_scm2flags (p_events, &sgtk_gdk_event_mask_info);
  gtk_widget_set_extension_events (c_widget, c_events);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_get_toplevel, "gtk-widget-get-toplevel", 1, 0, 0, sgtk_widget_get_toplevel);
SCM
sgtk_widget_get_toplevel (SCM p_widget)
{
  GtkWidget* c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_toplevel);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_toplevel (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_widget_get_colormap, "gtk-widget-get-colormap", 1, 0, 0, sgtk_widget_get_colormap);
SCM
sgtk_widget_get_colormap (SCM p_widget)
{
  GdkColormap* c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_colormap);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_colormap (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_colormap_info, 1);
}

SCM_PROC (s_gtk_widget_get_visual, "gtk-widget-get-visual", 1, 0, 0, sgtk_widget_get_visual);
SCM
sgtk_widget_get_visual (SCM p_widget)
{
  GdkVisual* c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_visual);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_visual (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_visual_info, 1);
}

SCM_PROC (s_gtk_widget_get_style, "gtk-widget-get-style", 1, 0, 0, sgtk_widget_get_style);
SCM
sgtk_widget_get_style (SCM p_widget)
{
  GtkStyle* c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_style);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_style (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_style_info, 1);
}

SCM_PROC (s_gtk_widget_get_events, "gtk-widget-get-events", 1, 0, 0, sgtk_widget_get_events);
SCM
sgtk_widget_get_events (SCM p_widget)
{
  GdkEventMask c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_events);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_events (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_flags2scm (c_ret, &sgtk_gdk_event_mask_info);
}

SCM_PROC (s_gtk_widget_get_extension_events, "gtk-widget-get-extension-events", 1, 0, 0, sgtk_widget_get_extension_events);
SCM
sgtk_widget_get_extension_events (SCM p_widget)
{
  GdkEventMask c_ret;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG1, s_gtk_widget_get_extension_events);

  SCM_DEFER_INTS;
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_ret = gtk_widget_get_extension_events (c_widget);
  SCM_ALLOW_INTS;

  return sgtk_flags2scm (c_ret, &sgtk_gdk_event_mask_info);
}

SCM_PROC (s_gtk_widget_push_colormap, "gtk-widget-push-colormap", 1, 0, 0, sgtk_widget_push_colormap);
SCM
sgtk_widget_push_colormap (SCM p_cmap)
{
  GdkColormap* c_cmap;
  SCM_ASSERT (sgtk_valid_boxed (p_cmap, &sgtk_gdk_colormap_info), p_cmap, SCM_ARG1, s_gtk_widget_push_colormap);

  SCM_DEFER_INTS;
  c_cmap = (GdkColormap*)sgtk_scm2boxed (p_cmap);
  gtk_widget_push_colormap (c_cmap);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_push_visual, "gtk-widget-push-visual", 1, 0, 0, sgtk_widget_push_visual);
SCM
sgtk_widget_push_visual (SCM p_visual)
{
  GdkVisual* c_visual;
  SCM_ASSERT (sgtk_valid_boxed (p_visual, &sgtk_gdk_visual_info), p_visual, SCM_ARG1, s_gtk_widget_push_visual);

  SCM_DEFER_INTS;
  c_visual = (GdkVisual*)sgtk_scm2boxed (p_visual);
  gtk_widget_push_visual (c_visual);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_push_style, "gtk-widget-push-style", 1, 0, 0, sgtk_widget_push_style);
SCM
sgtk_widget_push_style (SCM p_style)
{
  GtkStyle* c_style;
  SCM_ASSERT (sgtk_valid_boxed (p_style, &sgtk_style_info), p_style, SCM_ARG1, s_gtk_widget_push_style);

  SCM_DEFER_INTS;
  c_style = (GtkStyle*)sgtk_scm2boxed (p_style);
  gtk_widget_push_style (c_style);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_pop_colormap, "gtk-widget-pop-colormap", 0, 0, 0, sgtk_widget_pop_colormap);
SCM
sgtk_widget_pop_colormap ()
{

  SCM_DEFER_INTS;
  gtk_widget_pop_colormap ();
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_pop_visual, "gtk-widget-pop-visual", 0, 0, 0, sgtk_widget_pop_visual);
SCM
sgtk_widget_pop_visual ()
{

  SCM_DEFER_INTS;
  gtk_widget_pop_visual ();
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_pop_style, "gtk-widget-pop-style", 0, 0, 0, sgtk_widget_pop_style);
SCM
sgtk_widget_pop_style ()
{

  SCM_DEFER_INTS;
  gtk_widget_pop_style ();
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_default_colormap, "gtk-widget-set-default-colormap", 1, 0, 0, sgtk_widget_set_default_colormap);
SCM
sgtk_widget_set_default_colormap (SCM p_cmap)
{
  GdkColormap* c_cmap;
  SCM_ASSERT (sgtk_valid_boxed (p_cmap, &sgtk_gdk_colormap_info), p_cmap, SCM_ARG1, s_gtk_widget_set_default_colormap);

  SCM_DEFER_INTS;
  c_cmap = (GdkColormap*)sgtk_scm2boxed (p_cmap);
  gtk_widget_set_default_colormap (c_cmap);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_default_visual, "gtk-widget-set-default-visual", 1, 0, 0, sgtk_widget_set_default_visual);
SCM
sgtk_widget_set_default_visual (SCM p_visual)
{
  GdkVisual* c_visual;
  SCM_ASSERT (sgtk_valid_boxed (p_visual, &sgtk_gdk_visual_info), p_visual, SCM_ARG1, s_gtk_widget_set_default_visual);

  SCM_DEFER_INTS;
  c_visual = (GdkVisual*)sgtk_scm2boxed (p_visual);
  gtk_widget_set_default_visual (c_visual);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_set_default_style, "gtk-widget-set-default-style", 1, 0, 0, sgtk_widget_set_default_style);
SCM
sgtk_widget_set_default_style (SCM p_style)
{
  GtkStyle* c_style;
  SCM_ASSERT (sgtk_valid_boxed (p_style, &sgtk_style_info), p_style, SCM_ARG1, s_gtk_widget_set_default_style);

  SCM_DEFER_INTS;
  c_style = (GtkStyle*)sgtk_scm2boxed (p_style);
  gtk_widget_set_default_style (c_style);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_widget_get_default_colormap, "gtk-widget-get-default-colormap", 0, 0, 0, sgtk_widget_get_default_colormap);
SCM
sgtk_widget_get_default_colormap ()
{
  GdkColormap* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_widget_get_default_colormap ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_colormap_info, 1);
}

SCM_PROC (s_gtk_widget_get_default_visual, "gtk-widget-get-default-visual", 0, 0, 0, sgtk_widget_get_default_visual);
SCM
sgtk_widget_get_default_visual ()
{
  GdkVisual* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_widget_get_default_visual ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_visual_info, 1);
}

SCM_PROC (s_gtk_widget_get_default_style, "gtk-widget-get-default-style", 0, 0, 0, sgtk_widget_get_default_style);
SCM
sgtk_widget_get_default_style ()
{
  GtkStyle* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_widget_get_default_style ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_style_info, 1);
}

SCM_PROC (s_gtk_container_p, "gtk-container?", 1, 0, 0, sgtk_container_p);
SCM
sgtk_container_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_container_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_container_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_container_border_width, "gtk-container-border-width", 2, 0, 0, sgtk_container_border_width);
SCM
sgtk_container_border_width (SCM p_container, SCM p_border_width)
{
  GtkContainer* c_container;
  int c_border_width;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_border_width);
  SCM_ASSERT (SCM_INUMP (p_border_width), p_border_width, SCM_ARG2, s_gtk_container_border_width);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  c_border_width = SCM_INUM (p_border_width);
  gtk_container_border_width (c_container, c_border_width);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_add, "gtk-container-add", 2, 0, 0, sgtk_container_add);
SCM
sgtk_container_add (SCM p_container, SCM p_widget)
{
  GtkContainer* c_container;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_add);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG2, s_gtk_container_add);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_container_add (c_container, c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_remove, "gtk-container-remove", 2, 0, 0, sgtk_container_remove);
SCM
sgtk_container_remove (SCM p_container, SCM p_widget)
{
  GtkContainer* c_container;
  GtkWidget* c_widget;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_remove);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG2, s_gtk_container_remove);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  gtk_container_remove (c_container, c_widget);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_disable_resize, "gtk-container-disable-resize", 1, 0, 0, sgtk_container_disable_resize);
SCM
sgtk_container_disable_resize (SCM p_container)
{
  GtkContainer* c_container;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_disable_resize);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  gtk_container_disable_resize (c_container);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_enable_resize, "gtk-container-enable-resize", 1, 0, 0, sgtk_container_enable_resize);
SCM
sgtk_container_enable_resize (SCM p_container)
{
  GtkContainer* c_container;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_enable_resize);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  gtk_container_enable_resize (c_container);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_block_resize, "gtk-container-block-resize", 1, 0, 0, sgtk_container_block_resize);
SCM
sgtk_container_block_resize (SCM p_container)
{
  GtkContainer* c_container;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_block_resize);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  gtk_container_block_resize (c_container);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_unblock_resize, "gtk-container-unblock-resize", 1, 0, 0, sgtk_container_unblock_resize);
SCM
sgtk_container_unblock_resize (SCM p_container)
{
  GtkContainer* c_container;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_unblock_resize);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  gtk_container_unblock_resize (c_container);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_container_need_resize, "gtk-container-need-resize", 1, 0, 0, sgtk_container_need_resize);
SCM
sgtk_container_need_resize (SCM p_container)
{
  int c_ret;
  GtkContainer* c_container;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_need_resize);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  c_ret = gtk_container_need_resize (c_container);
  SCM_ALLOW_INTS;

  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_container_focus, "gtk-container-focus", 2, 0, 0, sgtk_container_focus);
SCM
sgtk_container_focus (SCM p_container, SCM p_direction)
{
  GtkDirectionType c_ret;
  GtkContainer* c_container;
  GtkDirectionType c_direction;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_container_get_type (), p_container), p_container, SCM_ARG1, s_gtk_container_focus);
  SCM_ASSERT (sgtk_valid_enum (p_direction, &sgtk_direction_type_info), p_direction, SCM_ARG2, s_gtk_container_focus);

  SCM_DEFER_INTS;
  c_container = (GtkContainer*)sgtk_get_gtkobj (p_container);
  c_direction = sgtk_scm2enum (p_direction, &sgtk_direction_type_info);
  c_ret = gtk_container_focus (c_container, c_direction);
  SCM_ALLOW_INTS;

  return sgtk_enum2scm (c_ret, &sgtk_direction_type_info);
}

SCM_PROC (s_gtk_bin_p, "gtk-bin?", 1, 0, 0, sgtk_bin_p);
SCM
sgtk_bin_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_bin_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_bin_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_window_p, "gtk-window?", 1, 0, 0, sgtk_window_p);
SCM
sgtk_window_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_window_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_window_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_window_new, "gtk-window-new", 1, 0, 0, sgtk_window_new);
SCM
sgtk_window_new (SCM p_type)
{
  GtkWidget* c_ret;
  GtkWindowType c_type;
  SCM_ASSERT (sgtk_valid_enum (p_type, &sgtk_window_type_info), p_type, SCM_ARG1, s_gtk_window_new);

  SCM_DEFER_INTS;
  c_type = sgtk_scm2enum (p_type, &sgtk_window_type_info);
  c_ret = gtk_window_new (c_type);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_window_set_title, "gtk-window-set-title", 2, 0, 0, sgtk_window_set_title);
SCM
sgtk_window_set_title (SCM p_window, SCM p_title)
{
  GtkWindow* c_window;
  char* c_title;
  p_title = sgtk_string_conversion (p_title);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_set_title);
  SCM_ASSERT ((SCM_NIMP(p_title) && SCM_STRINGP(p_title)), p_title, SCM_ARG2, s_gtk_window_set_title);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_title = ((p_title) == SCM_BOOL_F? NULL : SCM_CHARS(p_title));
  gtk_window_set_title (c_window, c_title);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_set_focus, "gtk-window-set-focus", 2, 0, 0, sgtk_window_set_focus);
SCM
sgtk_window_set_focus (SCM p_window, SCM p_focus)
{
  GtkWindow* c_window;
  GtkWidget* c_focus;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_set_focus);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_focus), p_focus, SCM_ARG2, s_gtk_window_set_focus);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_focus = (GtkWidget*)sgtk_get_gtkobj (p_focus);
  gtk_window_set_focus (c_window, c_focus);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_set_default, "gtk-window-set-default", 2, 0, 0, sgtk_window_set_default);
SCM
sgtk_window_set_default (SCM p_window, SCM p_default)
{
  GtkWindow* c_window;
  GtkWidget* c_default;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_set_default);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_default), p_default, SCM_ARG2, s_gtk_window_set_default);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_default = (GtkWidget*)sgtk_get_gtkobj (p_default);
  gtk_window_set_default (c_window, c_default);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_set_policy, "gtk-window-set-policy", 4, 0, 0, sgtk_window_set_policy);
SCM
sgtk_window_set_policy (SCM p_window, SCM p_allow_shrink, SCM p_allow_grow, SCM p_auto_shrink)
{
  GtkWindow* c_window;
  int c_allow_shrink;
  int c_allow_grow;
  int c_auto_shrink;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_set_policy);
  SCM_ASSERT (((p_allow_shrink) == SCM_BOOL_T || (p_allow_shrink) == SCM_BOOL_F), p_allow_shrink, SCM_ARG2, s_gtk_window_set_policy);
  SCM_ASSERT (((p_allow_grow) == SCM_BOOL_T || (p_allow_grow) == SCM_BOOL_F), p_allow_grow, SCM_ARG3, s_gtk_window_set_policy);
  SCM_ASSERT (((p_auto_shrink) == SCM_BOOL_T || (p_auto_shrink) == SCM_BOOL_F), p_auto_shrink, SCM_ARG4, s_gtk_window_set_policy);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_allow_shrink = SCM_NFALSEP (p_allow_shrink);
  c_allow_grow = SCM_NFALSEP (p_allow_grow);
  c_auto_shrink = SCM_NFALSEP (p_auto_shrink);
  gtk_window_set_policy (c_window, c_allow_shrink, c_allow_grow, c_auto_shrink);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_add_accelerator_table, "gtk-window-add-accelerator-table", 2, 0, 0, sgtk_window_add_accelerator_table);
SCM
sgtk_window_add_accelerator_table (SCM p_window, SCM p_table)
{
  GtkWindow* c_window;
  GtkAcceleratorTable* c_table;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_add_accelerator_table);
  SCM_ASSERT (sgtk_valid_boxed (p_table, &sgtk_accelerator_table_info), p_table, SCM_ARG2, s_gtk_window_add_accelerator_table);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_table = (GtkAcceleratorTable*)sgtk_scm2boxed (p_table);
  gtk_window_add_accelerator_table (c_window, c_table);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_remove_accelerator_table, "gtk-window-remove-accelerator-table", 2, 0, 0, sgtk_window_remove_accelerator_table);
SCM
sgtk_window_remove_accelerator_table (SCM p_window, SCM p_table)
{
  GtkWindow* c_window;
  GtkAcceleratorTable* c_table;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_remove_accelerator_table);
  SCM_ASSERT (sgtk_valid_boxed (p_table, &sgtk_accelerator_table_info), p_table, SCM_ARG2, s_gtk_window_remove_accelerator_table);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_table = (GtkAcceleratorTable*)sgtk_scm2boxed (p_table);
  gtk_window_remove_accelerator_table (c_window, c_table);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_window_position, "gtk-window-position", 2, 0, 0, sgtk_window_position);
SCM
sgtk_window_position (SCM p_window, SCM p_position)
{
  GtkWindow* c_window;
  GtkWindowPosition c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_window_get_type (), p_window), p_window, SCM_ARG1, s_gtk_window_position);
  SCM_ASSERT (sgtk_valid_enum (p_position, &sgtk_window_position_info), p_position, SCM_ARG2, s_gtk_window_position);

  SCM_DEFER_INTS;
  c_window = (GtkWindow*)sgtk_get_gtkobj (p_window);
  c_position = sgtk_scm2enum (p_position, &sgtk_window_position_info);
  gtk_window_position (c_window, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_p, "gtk-box?", 1, 0, 0, sgtk_box_p);
SCM
sgtk_box_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_box_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_box_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_box_pack_start, "gtk-box-pack-start", 2, 3, 0, sgtk_box_pack_start);
SCM
sgtk_box_pack_start (SCM p_box, SCM p_child, SCM p_expand, SCM p_fill, SCM p_padding)
{
  GtkBox* c_box;
  GtkWidget* c_child;
  int c_expand;
  int c_fill;
  int c_padding;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_pack_start);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_box_pack_start);
  if (p_expand != SCM_UNDEFINED)
    SCM_ASSERT (((p_expand) == SCM_BOOL_T || (p_expand) == SCM_BOOL_F), p_expand, SCM_ARG3, s_gtk_box_pack_start);
  if (p_fill != SCM_UNDEFINED)
    SCM_ASSERT (((p_fill) == SCM_BOOL_T || (p_fill) == SCM_BOOL_F), p_fill, SCM_ARG4, s_gtk_box_pack_start);
  if (p_padding != SCM_UNDEFINED)
    SCM_ASSERT (SCM_INUMP (p_padding), p_padding, SCM_ARG5, s_gtk_box_pack_start);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  if (p_expand == SCM_UNDEFINED)
    c_expand = TRUE;
  else
    c_expand = SCM_NFALSEP (p_expand);
  if (p_fill == SCM_UNDEFINED)
    c_fill = TRUE;
  else
    c_fill = SCM_NFALSEP (p_fill);
  if (p_padding == SCM_UNDEFINED)
    c_padding = 0;
  else
    c_padding = SCM_INUM (p_padding);
  gtk_box_pack_start (c_box, c_child, c_expand, c_fill, c_padding);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_pack_end, "gtk-box-pack-end", 2, 3, 0, sgtk_box_pack_end);
SCM
sgtk_box_pack_end (SCM p_box, SCM p_child, SCM p_expand, SCM p_fill, SCM p_padding)
{
  GtkBox* c_box;
  GtkWidget* c_child;
  int c_expand;
  int c_fill;
  int c_padding;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_pack_end);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_box_pack_end);
  if (p_expand != SCM_UNDEFINED)
    SCM_ASSERT (((p_expand) == SCM_BOOL_T || (p_expand) == SCM_BOOL_F), p_expand, SCM_ARG3, s_gtk_box_pack_end);
  if (p_fill != SCM_UNDEFINED)
    SCM_ASSERT (((p_fill) == SCM_BOOL_T || (p_fill) == SCM_BOOL_F), p_fill, SCM_ARG4, s_gtk_box_pack_end);
  if (p_padding != SCM_UNDEFINED)
    SCM_ASSERT (SCM_INUMP (p_padding), p_padding, SCM_ARG5, s_gtk_box_pack_end);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  if (p_expand == SCM_UNDEFINED)
    c_expand = TRUE;
  else
    c_expand = SCM_NFALSEP (p_expand);
  if (p_fill == SCM_UNDEFINED)
    c_fill = TRUE;
  else
    c_fill = SCM_NFALSEP (p_fill);
  if (p_padding == SCM_UNDEFINED)
    c_padding = 0;
  else
    c_padding = SCM_INUM (p_padding);
  gtk_box_pack_end (c_box, c_child, c_expand, c_fill, c_padding);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_pack_start_defaults, "gtk-box-pack-start-defaults", 2, 0, 0, sgtk_box_pack_start_defaults);
SCM
sgtk_box_pack_start_defaults (SCM p_box, SCM p_child)
{
  GtkBox* c_box;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_pack_start_defaults);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_box_pack_start_defaults);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_box_pack_start_defaults (c_box, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_pack_end_defaults, "gtk-box-pack-end-defaults", 2, 0, 0, sgtk_box_pack_end_defaults);
SCM
sgtk_box_pack_end_defaults (SCM p_box, SCM p_child)
{
  GtkBox* c_box;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_pack_end_defaults);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_box_pack_end_defaults);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_box_pack_end_defaults (c_box, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_set_homogeneous, "gtk-box-set-homogeneous", 2, 0, 0, sgtk_box_set_homogeneous);
SCM
sgtk_box_set_homogeneous (SCM p_box, SCM p_homogenous)
{
  GtkBox* c_box;
  int c_homogenous;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_set_homogeneous);
  SCM_ASSERT (((p_homogenous) == SCM_BOOL_T || (p_homogenous) == SCM_BOOL_F), p_homogenous, SCM_ARG2, s_gtk_box_set_homogeneous);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_homogenous = SCM_NFALSEP (p_homogenous);
  gtk_box_set_homogeneous (c_box, c_homogenous);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_box_set_spacing, "gtk-box-set-spacing", 2, 0, 0, sgtk_box_set_spacing);
SCM
sgtk_box_set_spacing (SCM p_box, SCM p_spacing)
{
  GtkBox* c_box;
  int c_spacing;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_box_get_type (), p_box), p_box, SCM_ARG1, s_gtk_box_set_spacing);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG2, s_gtk_box_set_spacing);

  SCM_DEFER_INTS;
  c_box = (GtkBox*)sgtk_get_gtkobj (p_box);
  c_spacing = SCM_INUM (p_spacing);
  gtk_box_set_spacing (c_box, c_spacing);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_p, "gtk-table?", 1, 0, 0, sgtk_table_p);
SCM
sgtk_table_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_table_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_table_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_table_new, "gtk-table-new", 3, 0, 0, sgtk_table_new);
SCM
sgtk_table_new (SCM p_rows, SCM p_columns, SCM p_homogenous)
{
  GtkWidget* c_ret;
  int c_rows;
  int c_columns;
  int c_homogenous;
  SCM_ASSERT (SCM_INUMP (p_rows), p_rows, SCM_ARG1, s_gtk_table_new);
  SCM_ASSERT (SCM_INUMP (p_columns), p_columns, SCM_ARG2, s_gtk_table_new);
  SCM_ASSERT (((p_homogenous) == SCM_BOOL_T || (p_homogenous) == SCM_BOOL_F), p_homogenous, SCM_ARG3, s_gtk_table_new);

  SCM_DEFER_INTS;
  c_rows = SCM_INUM (p_rows);
  c_columns = SCM_INUM (p_columns);
  c_homogenous = SCM_NFALSEP (p_homogenous);
  c_ret = gtk_table_new (c_rows, c_columns, c_homogenous);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_table_attach, "gtk-table-attach", 6, 4, 0, sgtk_table_attach);
SCM
sgtk_table_attach (SCM p_table, SCM p_child, SCM p_left_attach, SCM p_right_attach, SCM p_top_attach, SCM p_bottom_attach, SCM p_xoptions, SCM p_yoptions, SCM p_xpadding, SCM p_ypadding)
{
  GtkTable* c_table;
  GtkWidget* c_child;
  int c_left_attach;
  int c_right_attach;
  int c_top_attach;
  int c_bottom_attach;
  GtkAttachOptions c_xoptions;
  GtkAttachOptions c_yoptions;
  int c_xpadding;
  int c_ypadding;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_attach);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_table_attach);
  SCM_ASSERT (SCM_INUMP (p_left_attach), p_left_attach, SCM_ARG3, s_gtk_table_attach);
  SCM_ASSERT (SCM_INUMP (p_right_attach), p_right_attach, SCM_ARG4, s_gtk_table_attach);
  SCM_ASSERT (SCM_INUMP (p_top_attach), p_top_attach, SCM_ARG5, s_gtk_table_attach);
  SCM_ASSERT (SCM_INUMP (p_bottom_attach), p_bottom_attach, SCM_ARG6, s_gtk_table_attach);
  if (p_xoptions != SCM_UNDEFINED)
    SCM_ASSERT (sgtk_valid_flags (p_xoptions, &sgtk_attach_options_info), p_xoptions, SCM_ARG7, s_gtk_table_attach);
  if (p_yoptions != SCM_UNDEFINED)
    SCM_ASSERT (sgtk_valid_flags (p_yoptions, &sgtk_attach_options_info), p_yoptions, SCM_ARGn, s_gtk_table_attach);
  if (p_xpadding != SCM_UNDEFINED)
    SCM_ASSERT (SCM_INUMP (p_xpadding), p_xpadding, SCM_ARGn, s_gtk_table_attach);
  if (p_ypadding != SCM_UNDEFINED)
    SCM_ASSERT (SCM_INUMP (p_ypadding), p_ypadding, SCM_ARGn, s_gtk_table_attach);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_left_attach = SCM_INUM (p_left_attach);
  c_right_attach = SCM_INUM (p_right_attach);
  c_top_attach = SCM_INUM (p_top_attach);
  c_bottom_attach = SCM_INUM (p_bottom_attach);
  if (p_xoptions == SCM_UNDEFINED)
    c_xoptions = GTK_EXPAND|GTK_FILL;
  else
    c_xoptions = sgtk_scm2flags (p_xoptions, &sgtk_attach_options_info);
  if (p_yoptions == SCM_UNDEFINED)
    c_yoptions = GTK_EXPAND|GTK_FILL;
  else
    c_yoptions = sgtk_scm2flags (p_yoptions, &sgtk_attach_options_info);
  if (p_xpadding == SCM_UNDEFINED)
    c_xpadding = 0;
  else
    c_xpadding = SCM_INUM (p_xpadding);
  if (p_ypadding == SCM_UNDEFINED)
    c_ypadding = 0;
  else
    c_ypadding = SCM_INUM (p_ypadding);
  gtk_table_attach (c_table, c_child, c_left_attach, c_right_attach, c_top_attach, c_bottom_attach, c_xoptions, c_yoptions, c_xpadding, c_ypadding);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_attach_defaults, "gtk-table-attach-defaults", 6, 0, 0, sgtk_table_attach_defaults);
SCM
sgtk_table_attach_defaults (SCM p_table, SCM p_child, SCM p_left_attach, SCM p_right_attach, SCM p_top_attach, SCM p_bottom_attach)
{
  GtkTable* c_table;
  GtkWidget* c_child;
  int c_left_attach;
  int c_right_attach;
  int c_top_attach;
  int c_bottom_attach;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_attach_defaults);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_table_attach_defaults);
  SCM_ASSERT (SCM_INUMP (p_left_attach), p_left_attach, SCM_ARG3, s_gtk_table_attach_defaults);
  SCM_ASSERT (SCM_INUMP (p_right_attach), p_right_attach, SCM_ARG4, s_gtk_table_attach_defaults);
  SCM_ASSERT (SCM_INUMP (p_top_attach), p_top_attach, SCM_ARG5, s_gtk_table_attach_defaults);
  SCM_ASSERT (SCM_INUMP (p_bottom_attach), p_bottom_attach, SCM_ARG6, s_gtk_table_attach_defaults);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_left_attach = SCM_INUM (p_left_attach);
  c_right_attach = SCM_INUM (p_right_attach);
  c_top_attach = SCM_INUM (p_top_attach);
  c_bottom_attach = SCM_INUM (p_bottom_attach);
  gtk_table_attach_defaults (c_table, c_child, c_left_attach, c_right_attach, c_top_attach, c_bottom_attach);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_set_row_spacing, "gtk-table-set-row-spacing", 3, 0, 0, sgtk_table_set_row_spacing);
SCM
sgtk_table_set_row_spacing (SCM p_table, SCM p_row, SCM p_spacing)
{
  GtkTable* c_table;
  int c_row;
  int c_spacing;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_set_row_spacing);
  SCM_ASSERT (SCM_INUMP (p_row), p_row, SCM_ARG2, s_gtk_table_set_row_spacing);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG3, s_gtk_table_set_row_spacing);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_row = SCM_INUM (p_row);
  c_spacing = SCM_INUM (p_spacing);
  gtk_table_set_row_spacing (c_table, c_row, c_spacing);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_set_col_spacing, "gtk-table-set-col-spacing", 3, 0, 0, sgtk_table_set_col_spacing);
SCM
sgtk_table_set_col_spacing (SCM p_table, SCM p_column, SCM p_spacing)
{
  GtkTable* c_table;
  int c_column;
  int c_spacing;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_set_col_spacing);
  SCM_ASSERT (SCM_INUMP (p_column), p_column, SCM_ARG2, s_gtk_table_set_col_spacing);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG3, s_gtk_table_set_col_spacing);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_column = SCM_INUM (p_column);
  c_spacing = SCM_INUM (p_spacing);
  gtk_table_set_col_spacing (c_table, c_column, c_spacing);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_set_row_spacings, "gtk-table-set-row-spacings", 2, 0, 0, sgtk_table_set_row_spacings);
SCM
sgtk_table_set_row_spacings (SCM p_table, SCM p_spacing)
{
  GtkTable* c_table;
  int c_spacing;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_set_row_spacings);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG2, s_gtk_table_set_row_spacings);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_spacing = SCM_INUM (p_spacing);
  gtk_table_set_row_spacings (c_table, c_spacing);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_table_set_col_spacings, "gtk-table-set-col-spacings", 2, 0, 0, sgtk_table_set_col_spacings);
SCM
sgtk_table_set_col_spacings (SCM p_table, SCM p_spacing)
{
  GtkTable* c_table;
  int c_spacing;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_table_get_type (), p_table), p_table, SCM_ARG1, s_gtk_table_set_col_spacings);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG2, s_gtk_table_set_col_spacings);

  SCM_DEFER_INTS;
  c_table = (GtkTable*)sgtk_get_gtkobj (p_table);
  c_spacing = SCM_INUM (p_spacing);
  gtk_table_set_col_spacings (c_table, c_spacing);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_button_p, "gtk-button?", 1, 0, 0, sgtk_button_p);
SCM
sgtk_button_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_button_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_button_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_button_new, "gtk-button-new", 0, 0, 0, sgtk_button_new);
SCM
sgtk_button_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_button_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_button_new_with_label, "gtk-button-new-with-label", 1, 0, 0, sgtk_button_new_with_label);
SCM
sgtk_button_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_button_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_button_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_button_pressed, "gtk-button-pressed", 1, 0, 0, sgtk_button_pressed);
SCM
sgtk_button_pressed (SCM p_button)
{
  GtkButton* c_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_button_get_type (), p_button), p_button, SCM_ARG1, s_gtk_button_pressed);

  SCM_DEFER_INTS;
  c_button = (GtkButton*)sgtk_get_gtkobj (p_button);
  gtk_button_pressed (c_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_button_released, "gtk-button-released", 1, 0, 0, sgtk_button_released);
SCM
sgtk_button_released (SCM p_button)
{
  GtkButton* c_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_button_get_type (), p_button), p_button, SCM_ARG1, s_gtk_button_released);

  SCM_DEFER_INTS;
  c_button = (GtkButton*)sgtk_get_gtkobj (p_button);
  gtk_button_released (c_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_button_clicked, "gtk-button-clicked", 1, 0, 0, sgtk_button_clicked);
SCM
sgtk_button_clicked (SCM p_button)
{
  GtkButton* c_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_button_get_type (), p_button), p_button, SCM_ARG1, s_gtk_button_clicked);

  SCM_DEFER_INTS;
  c_button = (GtkButton*)sgtk_get_gtkobj (p_button);
  gtk_button_clicked (c_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_button_enter, "gtk-button-enter", 1, 0, 0, sgtk_button_enter);
SCM
sgtk_button_enter (SCM p_button)
{
  GtkButton* c_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_button_get_type (), p_button), p_button, SCM_ARG1, s_gtk_button_enter);

  SCM_DEFER_INTS;
  c_button = (GtkButton*)sgtk_get_gtkobj (p_button);
  gtk_button_enter (c_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_button_leave, "gtk-button-leave", 1, 0, 0, sgtk_button_leave);
SCM
sgtk_button_leave (SCM p_button)
{
  GtkButton* c_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_button_get_type (), p_button), p_button, SCM_ARG1, s_gtk_button_leave);

  SCM_DEFER_INTS;
  c_button = (GtkButton*)sgtk_get_gtkobj (p_button);
  gtk_button_leave (c_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_toggle_button_p, "gtk-toggle-button?", 1, 0, 0, sgtk_toggle_button_p);
SCM
sgtk_toggle_button_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_toggle_button_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_toggle_button_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_toggle_button_new, "gtk-toggle-button-new", 0, 0, 0, sgtk_toggle_button_new);
SCM
sgtk_toggle_button_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_toggle_button_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_toggle_button_new_with_label, "gtk-toggle-button-new-with-label", 1, 0, 0, sgtk_toggle_button_new_with_label);
SCM
sgtk_toggle_button_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_toggle_button_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_toggle_button_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_toggle_button_set_mode, "gtk-toggle-button-set-mode", 2, 0, 0, sgtk_toggle_button_set_mode);
SCM
sgtk_toggle_button_set_mode (SCM p_toggle_button, SCM p_draw_indicator)
{
  GtkToggleButton* c_toggle_button;
  int c_draw_indicator;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_toggle_button_get_type (), p_toggle_button), p_toggle_button, SCM_ARG1, s_gtk_toggle_button_set_mode);
  SCM_ASSERT (((p_draw_indicator) == SCM_BOOL_T || (p_draw_indicator) == SCM_BOOL_F), p_draw_indicator, SCM_ARG2, s_gtk_toggle_button_set_mode);

  SCM_DEFER_INTS;
  c_toggle_button = (GtkToggleButton*)sgtk_get_gtkobj (p_toggle_button);
  c_draw_indicator = SCM_NFALSEP (p_draw_indicator);
  gtk_toggle_button_set_mode (c_toggle_button, c_draw_indicator);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_toggle_button_set_state, "gtk-toggle-button-set-state", 2, 0, 0, sgtk_toggle_button_set_state);
SCM
sgtk_toggle_button_set_state (SCM p_toggle_button, SCM p_state)
{
  GtkToggleButton* c_toggle_button;
  int c_state;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_toggle_button_get_type (), p_toggle_button), p_toggle_button, SCM_ARG1, s_gtk_toggle_button_set_state);
  SCM_ASSERT (((p_state) == SCM_BOOL_T || (p_state) == SCM_BOOL_F), p_state, SCM_ARG2, s_gtk_toggle_button_set_state);

  SCM_DEFER_INTS;
  c_toggle_button = (GtkToggleButton*)sgtk_get_gtkobj (p_toggle_button);
  c_state = SCM_NFALSEP (p_state);
  gtk_toggle_button_set_state (c_toggle_button, c_state);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_toggle_button_toggled, "gtk-toggle-button-toggled", 1, 0, 0, sgtk_toggle_button_toggled);
SCM
sgtk_toggle_button_toggled (SCM p_toggle_button)
{
  GtkToggleButton* c_toggle_button;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_toggle_button_get_type (), p_toggle_button), p_toggle_button, SCM_ARG1, s_gtk_toggle_button_toggled);

  SCM_DEFER_INTS;
  c_toggle_button = (GtkToggleButton*)sgtk_get_gtkobj (p_toggle_button);
  gtk_toggle_button_toggled (c_toggle_button);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_check_button_p, "gtk-check-button?", 1, 0, 0, sgtk_check_button_p);
SCM
sgtk_check_button_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_check_button_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_check_button_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_check_button_new, "gtk-check-button-new", 0, 0, 0, sgtk_check_button_new);
SCM
sgtk_check_button_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_check_button_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_check_button_new_with_label, "gtk-check-button-new-with-label", 1, 0, 0, sgtk_check_button_new_with_label);
SCM
sgtk_check_button_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_check_button_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_check_button_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_radio_button_p, "gtk-radio-button?", 1, 0, 0, sgtk_radio_button_p);
SCM
sgtk_radio_button_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_radio_button_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_radio_button_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_radio_button_new_interp, "gtk-radio-button-new", 1, 0, 0, sgtk_radio_button_new_interp);
SCM
sgtk_radio_button_new_interp (SCM p_group)
{
  GtkWidget* c_ret;
  GtkRadioButton* c_group;
  SCM_ASSERT (p_group == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_radio_button_get_type (), p_group), p_group, SCM_ARG1, s_gtk_radio_button_new_interp);

  SCM_DEFER_INTS;
  c_group = (GtkRadioButton*)sgtk_get_gtkobj (p_group);
  c_ret = gtk_radio_button_new_interp (c_group);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_radio_button_new_with_label_interp, "gtk-radio-button-new-with-label", 2, 0, 0, sgtk_radio_button_new_with_label_interp);
SCM
sgtk_radio_button_new_with_label_interp (SCM p_group, SCM p_label)
{
  GtkWidget* c_ret;
  GtkRadioButton* c_group;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT (p_group == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_radio_button_get_type (), p_group), p_group, SCM_ARG1, s_gtk_radio_button_new_with_label_interp);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG2, s_gtk_radio_button_new_with_label_interp);

  SCM_DEFER_INTS;
  c_group = (GtkRadioButton*)sgtk_get_gtkobj (p_group);
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_radio_button_new_with_label_interp (c_group, c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_misc_p, "gtk-misc?", 1, 0, 0, sgtk_misc_p);
SCM
sgtk_misc_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_misc_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_misc_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_misc_set_alignment, "gtk-misc-set-alignment", 3, 0, 0, sgtk_misc_set_alignment);
SCM
sgtk_misc_set_alignment (SCM p_misc, SCM p_xalign, SCM p_yalign)
{
  GtkMisc* c_misc;
  gfloat c_xalign;
  gfloat c_yalign;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_misc_get_type (), p_misc), p_misc, SCM_ARG1, s_gtk_misc_set_alignment);
  SCM_ASSERT (sgtk_valid_float (p_xalign), p_xalign, SCM_ARG2, s_gtk_misc_set_alignment);
  SCM_ASSERT (sgtk_valid_float (p_yalign), p_yalign, SCM_ARG3, s_gtk_misc_set_alignment);

  SCM_DEFER_INTS;
  c_misc = (GtkMisc*)sgtk_get_gtkobj (p_misc);
  c_xalign = sgtk_scm2float (p_xalign);
  c_yalign = sgtk_scm2float (p_yalign);
  gtk_misc_set_alignment (c_misc, c_xalign, c_yalign);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_misc_set_padding, "gtk-misc-set-padding", 3, 0, 0, sgtk_misc_set_padding);
SCM
sgtk_misc_set_padding (SCM p_misc, SCM p_xpad, SCM p_ypad)
{
  GtkMisc* c_misc;
  int c_xpad;
  int c_ypad;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_misc_get_type (), p_misc), p_misc, SCM_ARG1, s_gtk_misc_set_padding);
  SCM_ASSERT (SCM_INUMP (p_xpad), p_xpad, SCM_ARG2, s_gtk_misc_set_padding);
  SCM_ASSERT (SCM_INUMP (p_ypad), p_ypad, SCM_ARG3, s_gtk_misc_set_padding);

  SCM_DEFER_INTS;
  c_misc = (GtkMisc*)sgtk_get_gtkobj (p_misc);
  c_xpad = SCM_INUM (p_xpad);
  c_ypad = SCM_INUM (p_ypad);
  gtk_misc_set_padding (c_misc, c_xpad, c_ypad);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_label_p, "gtk-label?", 1, 0, 0, sgtk_label_p);
SCM
sgtk_label_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_label_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_label_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_label_new, "gtk-label-new", 1, 0, 0, sgtk_label_new);
SCM
sgtk_label_new (SCM p_str)
{
  GtkWidget* c_ret;
  char* c_str;
  p_str = sgtk_string_conversion (p_str);
  SCM_ASSERT ((SCM_NIMP(p_str) && SCM_STRINGP(p_str)), p_str, SCM_ARG1, s_gtk_label_new);

  SCM_DEFER_INTS;
  c_str = ((p_str) == SCM_BOOL_F? NULL : SCM_CHARS(p_str));
  c_ret = gtk_label_new (c_str);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_label_set, "gtk-label-set", 2, 0, 0, sgtk_label_set);
SCM
sgtk_label_set (SCM p_label, SCM p_str)
{
  GtkLabel* c_label;
  char* c_str;
  p_str = sgtk_string_conversion (p_str);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_label_get_type (), p_label), p_label, SCM_ARG1, s_gtk_label_set);
  SCM_ASSERT ((SCM_NIMP(p_str) && SCM_STRINGP(p_str)), p_str, SCM_ARG2, s_gtk_label_set);

  SCM_DEFER_INTS;
  c_label = (GtkLabel*)sgtk_get_gtkobj (p_label);
  c_str = ((p_str) == SCM_BOOL_F? NULL : SCM_CHARS(p_str));
  gtk_label_set (c_label, c_str);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_label_get_interp, "gtk-label-get", 1, 0, 0, sgtk_label_get_interp);
SCM
sgtk_label_get_interp (SCM p_label)
{
  char* c_ret;
  GtkLabel* c_label;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_label_get_type (), p_label), p_label, SCM_ARG1, s_gtk_label_get_interp);

  SCM_DEFER_INTS;
  c_label = (GtkLabel*)sgtk_get_gtkobj (p_label);
  c_ret = gtk_label_get_interp (c_label);
  SCM_ALLOW_INTS;

  return (c_ret == NULL? SCM_BOOL_F : scm_makfrom0str (c_ret));
}

SCM_PROC (s_gtk_vbox_p, "gtk-vbox?", 1, 0, 0, sgtk_vbox_p);
SCM
sgtk_vbox_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_vbox_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_vbox_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_vbox_new, "gtk-vbox-new", 2, 0, 0, sgtk_vbox_new);
SCM
sgtk_vbox_new (SCM p_homogenous, SCM p_spacing)
{
  GtkWidget* c_ret;
  int c_homogenous;
  int c_spacing;
  SCM_ASSERT (((p_homogenous) == SCM_BOOL_T || (p_homogenous) == SCM_BOOL_F), p_homogenous, SCM_ARG1, s_gtk_vbox_new);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG2, s_gtk_vbox_new);

  SCM_DEFER_INTS;
  c_homogenous = SCM_NFALSEP (p_homogenous);
  c_spacing = SCM_INUM (p_spacing);
  c_ret = gtk_vbox_new (c_homogenous, c_spacing);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_hbox_p, "gtk-hbox?", 1, 0, 0, sgtk_hbox_p);
SCM
sgtk_hbox_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_hbox_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_hbox_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hbox_new, "gtk-hbox-new", 2, 0, 0, sgtk_hbox_new);
SCM
sgtk_hbox_new (SCM p_homogenous, SCM p_spacing)
{
  GtkWidget* c_ret;
  int c_homogenous;
  int c_spacing;
  SCM_ASSERT (((p_homogenous) == SCM_BOOL_T || (p_homogenous) == SCM_BOOL_F), p_homogenous, SCM_ARG1, s_gtk_hbox_new);
  SCM_ASSERT (SCM_INUMP (p_spacing), p_spacing, SCM_ARG2, s_gtk_hbox_new);

  SCM_DEFER_INTS;
  c_homogenous = SCM_NFALSEP (p_homogenous);
  c_spacing = SCM_INUM (p_spacing);
  c_ret = gtk_hbox_new (c_homogenous, c_spacing);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_separator_p, "gtk-separator?", 1, 0, 0, sgtk_separator_p);
SCM
sgtk_separator_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_separator_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_separator_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hseparator_p, "gtk-hseparator?", 1, 0, 0, sgtk_hseparator_p);
SCM
sgtk_hseparator_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_hseparator_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_hseparator_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hseparator_new, "gtk-hseparator-new", 0, 0, 0, sgtk_hseparator_new);
SCM
sgtk_hseparator_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_hseparator_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_vseparator_p, "gtk-vseparator?", 1, 0, 0, sgtk_vseparator_p);
SCM
sgtk_vseparator_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_vseparator_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_vseparator_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_vseparator_new, "gtk-vseparator-new", 0, 0, 0, sgtk_vseparator_new);
SCM
sgtk_vseparator_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_vseparator_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_frame_p, "gtk-frame?", 1, 0, 0, sgtk_frame_p);
SCM
sgtk_frame_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_frame_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_frame_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_frame_new, "gtk-frame-new", 1, 0, 0, sgtk_frame_new);
SCM
sgtk_frame_new (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT (p_label == SCM_BOOL_F || (SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_frame_new);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_frame_new (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_frame_set_label, "gtk-frame-set-label", 2, 0, 0, sgtk_frame_set_label);
SCM
sgtk_frame_set_label (SCM p_frame, SCM p_label)
{
  GtkFrame* c_frame;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_frame_get_type (), p_frame), p_frame, SCM_ARG1, s_gtk_frame_set_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG2, s_gtk_frame_set_label);

  SCM_DEFER_INTS;
  c_frame = (GtkFrame*)sgtk_get_gtkobj (p_frame);
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  gtk_frame_set_label (c_frame, c_label);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_frame_set_label_align, "gtk-frame-set-label-align", 3, 0, 0, sgtk_frame_set_label_align);
SCM
sgtk_frame_set_label_align (SCM p_frame, SCM p_xalign, SCM p_yalign)
{
  GtkFrame* c_frame;
  gfloat c_xalign;
  gfloat c_yalign;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_frame_get_type (), p_frame), p_frame, SCM_ARG1, s_gtk_frame_set_label_align);
  SCM_ASSERT (sgtk_valid_float (p_xalign), p_xalign, SCM_ARG2, s_gtk_frame_set_label_align);
  SCM_ASSERT (sgtk_valid_float (p_yalign), p_yalign, SCM_ARG3, s_gtk_frame_set_label_align);

  SCM_DEFER_INTS;
  c_frame = (GtkFrame*)sgtk_get_gtkobj (p_frame);
  c_xalign = sgtk_scm2float (p_xalign);
  c_yalign = sgtk_scm2float (p_yalign);
  gtk_frame_set_label_align (c_frame, c_xalign, c_yalign);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_frame_set_shadow_type, "gtk-frame-set-shadow-type", 2, 0, 0, sgtk_frame_set_shadow_type);
SCM
sgtk_frame_set_shadow_type (SCM p_frame, SCM p_type)
{
  GtkFrame* c_frame;
  GtkShadowType c_type;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_frame_get_type (), p_frame), p_frame, SCM_ARG1, s_gtk_frame_set_shadow_type);
  SCM_ASSERT (sgtk_valid_enum (p_type, &sgtk_shadow_type_info), p_type, SCM_ARG2, s_gtk_frame_set_shadow_type);

  SCM_DEFER_INTS;
  c_frame = (GtkFrame*)sgtk_get_gtkobj (p_frame);
  c_type = sgtk_scm2enum (p_type, &sgtk_shadow_type_info);
  gtk_frame_set_shadow_type (c_frame, c_type);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_progress_bar_p, "gtk-progress-bar?", 1, 0, 0, sgtk_progress_bar_p);
SCM
sgtk_progress_bar_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_progress_bar_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_progress_bar_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_progress_bar_percentage, "gtk-progress-bar-percentage", 1, 0, 0, sgtk_progress_bar_percentage);
SCM
sgtk_progress_bar_percentage (SCM p_obj)
{
  gfloat c_ret;
  GtkProgressBar* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_progress_bar_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_progress_bar_percentage);
  c_obj = (GtkProgressBar*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->percentage;

  return sgtk_float2scm (c_ret);
}

SCM_PROC (s_gtk_progress_bar_new, "gtk-progress-bar-new", 0, 0, 0, sgtk_progress_bar_new);
SCM
sgtk_progress_bar_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_progress_bar_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_progress_bar_update, "gtk-progress-bar-update", 2, 0, 0, sgtk_progress_bar_update);
SCM
sgtk_progress_bar_update (SCM p_progress_bar, SCM p_percentage)
{
  GtkProgressBar* c_progress_bar;
  gfloat c_percentage;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_progress_bar_get_type (), p_progress_bar), p_progress_bar, SCM_ARG1, s_gtk_progress_bar_update);
  SCM_ASSERT (sgtk_valid_float (p_percentage), p_percentage, SCM_ARG2, s_gtk_progress_bar_update);

  SCM_DEFER_INTS;
  c_progress_bar = (GtkProgressBar*)sgtk_get_gtkobj (p_progress_bar);
  c_percentage = sgtk_scm2float (p_percentage);
  gtk_progress_bar_update (c_progress_bar, c_percentage);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_tooltips_new, "gtk-tooltips-new", 0, 0, 0, sgtk_tooltips_new);
SCM
sgtk_tooltips_new ()
{
  GtkTooltips* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_tooltips_new ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_tooltips_info, 1);
}

SCM_PROC (s_gtk_tooltips_enable, "gtk-tooltips-enable", 1, 0, 0, sgtk_tooltips_enable);
SCM
sgtk_tooltips_enable (SCM p_tooltips)
{
  GtkTooltips* c_tooltips;
  SCM_ASSERT (sgtk_valid_boxed (p_tooltips, &sgtk_tooltips_info), p_tooltips, SCM_ARG1, s_gtk_tooltips_enable);

  SCM_DEFER_INTS;
  c_tooltips = (GtkTooltips*)sgtk_scm2boxed (p_tooltips);
  gtk_tooltips_enable (c_tooltips);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_tooltips_disable, "gtk-tooltips-disable", 1, 0, 0, sgtk_tooltips_disable);
SCM
sgtk_tooltips_disable (SCM p_tooltips)
{
  GtkTooltips* c_tooltips;
  SCM_ASSERT (sgtk_valid_boxed (p_tooltips, &sgtk_tooltips_info), p_tooltips, SCM_ARG1, s_gtk_tooltips_disable);

  SCM_DEFER_INTS;
  c_tooltips = (GtkTooltips*)sgtk_scm2boxed (p_tooltips);
  gtk_tooltips_disable (c_tooltips);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_tooltips_set_delay, "gtk-tooltips-set-delay", 2, 0, 0, sgtk_tooltips_set_delay);
SCM
sgtk_tooltips_set_delay (SCM p_tooltips, SCM p_delay)
{
  GtkTooltips* c_tooltips;
  int c_delay;
  SCM_ASSERT (sgtk_valid_boxed (p_tooltips, &sgtk_tooltips_info), p_tooltips, SCM_ARG1, s_gtk_tooltips_set_delay);
  SCM_ASSERT (SCM_INUMP (p_delay), p_delay, SCM_ARG2, s_gtk_tooltips_set_delay);

  SCM_DEFER_INTS;
  c_tooltips = (GtkTooltips*)sgtk_scm2boxed (p_tooltips);
  c_delay = SCM_INUM (p_delay);
  gtk_tooltips_set_delay (c_tooltips, c_delay);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_tooltips_set_tips, "gtk-tooltips-set-tips", 3, 0, 0, sgtk_tooltips_set_tips);
SCM
sgtk_tooltips_set_tips (SCM p_tooltips, SCM p_widget, SCM p_tips_text)
{
  GtkTooltips* c_tooltips;
  GtkWidget* c_widget;
  char* c_tips_text;
  p_tips_text = sgtk_string_conversion (p_tips_text);
  SCM_ASSERT (sgtk_valid_boxed (p_tooltips, &sgtk_tooltips_info), p_tooltips, SCM_ARG1, s_gtk_tooltips_set_tips);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_widget), p_widget, SCM_ARG2, s_gtk_tooltips_set_tips);
  SCM_ASSERT (p_tips_text == SCM_BOOL_F || (SCM_NIMP(p_tips_text) && SCM_STRINGP(p_tips_text)), p_tips_text, SCM_ARG3, s_gtk_tooltips_set_tips);

  SCM_DEFER_INTS;
  c_tooltips = (GtkTooltips*)sgtk_scm2boxed (p_tooltips);
  c_widget = (GtkWidget*)sgtk_get_gtkobj (p_widget);
  c_tips_text = ((p_tips_text) == SCM_BOOL_F? NULL : SCM_CHARS(p_tips_text));
  gtk_tooltips_set_tips (c_tooltips, c_widget, c_tips_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_tooltips_set_colors, "gtk-tooltips-set-colors", 3, 0, 0, sgtk_tooltips_set_colors);
SCM
sgtk_tooltips_set_colors (SCM p_tooltips, SCM p_background, SCM p_foreground)
{
  GtkTooltips* c_tooltips;
  GdkColor* c_background;
  GdkColor* c_foreground;
  p_background = sgtk_color_conversion (p_background);
  p_foreground = sgtk_color_conversion (p_foreground);
  SCM_ASSERT (sgtk_valid_boxed (p_tooltips, &sgtk_tooltips_info), p_tooltips, SCM_ARG1, s_gtk_tooltips_set_colors);
  SCM_ASSERT (sgtk_valid_boxed (p_background, &sgtk_gdk_color_info), p_background, SCM_ARG2, s_gtk_tooltips_set_colors);
  SCM_ASSERT (sgtk_valid_boxed (p_foreground, &sgtk_gdk_color_info), p_foreground, SCM_ARG3, s_gtk_tooltips_set_colors);

  SCM_DEFER_INTS;
  c_tooltips = (GtkTooltips*)sgtk_scm2boxed (p_tooltips);
  c_background = (GdkColor*)sgtk_scm2boxed (p_background);
  c_foreground = (GdkColor*)sgtk_scm2boxed (p_foreground);
  gtk_tooltips_set_colors (c_tooltips, c_background, c_foreground);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_shell_p, "gtk-menu-shell?", 1, 0, 0, sgtk_menu_shell_p);
SCM
sgtk_menu_shell_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_menu_shell_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_menu_shell_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_menu_shell_append, "gtk-menu-shell-append", 2, 0, 0, sgtk_menu_shell_append);
SCM
sgtk_menu_shell_append (SCM p_menu_shell, SCM p_child)
{
  GtkMenuShell* c_menu_shell;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_shell_get_type (), p_menu_shell), p_menu_shell, SCM_ARG1, s_gtk_menu_shell_append);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_shell_append);

  SCM_DEFER_INTS;
  c_menu_shell = (GtkMenuShell*)sgtk_get_gtkobj (p_menu_shell);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_shell_append (c_menu_shell, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_shell_prepend, "gtk-menu-shell-prepend", 2, 0, 0, sgtk_menu_shell_prepend);
SCM
sgtk_menu_shell_prepend (SCM p_menu_shell, SCM p_child)
{
  GtkMenuShell* c_menu_shell;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_shell_get_type (), p_menu_shell), p_menu_shell, SCM_ARG1, s_gtk_menu_shell_prepend);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_shell_prepend);

  SCM_DEFER_INTS;
  c_menu_shell = (GtkMenuShell*)sgtk_get_gtkobj (p_menu_shell);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_shell_prepend (c_menu_shell, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_shell_insert, "gtk-menu-shell-insert", 3, 0, 0, sgtk_menu_shell_insert);
SCM
sgtk_menu_shell_insert (SCM p_menu_shell, SCM p_child, SCM p_position)
{
  GtkMenuShell* c_menu_shell;
  GtkWidget* c_child;
  int c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_shell_get_type (), p_menu_shell), p_menu_shell, SCM_ARG1, s_gtk_menu_shell_insert);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_shell_insert);
  SCM_ASSERT (SCM_INUMP (p_position), p_position, SCM_ARG3, s_gtk_menu_shell_insert);

  SCM_DEFER_INTS;
  c_menu_shell = (GtkMenuShell*)sgtk_get_gtkobj (p_menu_shell);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_position = SCM_INUM (p_position);
  gtk_menu_shell_insert (c_menu_shell, c_child, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_shell_deactivate, "gtk-menu-shell-deactivate", 1, 0, 0, sgtk_menu_shell_deactivate);
SCM
sgtk_menu_shell_deactivate (SCM p_menu_shell)
{
  GtkMenuShell* c_menu_shell;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_shell_get_type (), p_menu_shell), p_menu_shell, SCM_ARG1, s_gtk_menu_shell_deactivate);

  SCM_DEFER_INTS;
  c_menu_shell = (GtkMenuShell*)sgtk_get_gtkobj (p_menu_shell);
  gtk_menu_shell_deactivate (c_menu_shell);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_bar_p, "gtk-menu-bar?", 1, 0, 0, sgtk_menu_bar_p);
SCM
sgtk_menu_bar_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_menu_bar_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_menu_bar_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_menu_bar_new, "gtk-menu-bar-new", 0, 0, 0, sgtk_menu_bar_new);
SCM
sgtk_menu_bar_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_menu_bar_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_menu_bar_append, "gtk-menu-bar-append", 2, 0, 0, sgtk_menu_bar_append);
SCM
sgtk_menu_bar_append (SCM p_menu_bar, SCM p_child)
{
  GtkMenuBar* c_menu_bar;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_bar_get_type (), p_menu_bar), p_menu_bar, SCM_ARG1, s_gtk_menu_bar_append);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_bar_append);

  SCM_DEFER_INTS;
  c_menu_bar = (GtkMenuBar*)sgtk_get_gtkobj (p_menu_bar);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_bar_append (c_menu_bar, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_bar_prepend, "gtk-menu-bar-prepend", 2, 0, 0, sgtk_menu_bar_prepend);
SCM
sgtk_menu_bar_prepend (SCM p_menu_bar, SCM p_child)
{
  GtkMenuBar* c_menu_bar;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_bar_get_type (), p_menu_bar), p_menu_bar, SCM_ARG1, s_gtk_menu_bar_prepend);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_bar_prepend);

  SCM_DEFER_INTS;
  c_menu_bar = (GtkMenuBar*)sgtk_get_gtkobj (p_menu_bar);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_bar_prepend (c_menu_bar, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_bar_insert, "gtk-menu-bar-insert", 3, 0, 0, sgtk_menu_bar_insert);
SCM
sgtk_menu_bar_insert (SCM p_menu_bar, SCM p_child, SCM p_position)
{
  GtkMenuBar* c_menu_bar;
  GtkWidget* c_child;
  int c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_bar_get_type (), p_menu_bar), p_menu_bar, SCM_ARG1, s_gtk_menu_bar_insert);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_bar_insert);
  SCM_ASSERT (SCM_INUMP (p_position), p_position, SCM_ARG3, s_gtk_menu_bar_insert);

  SCM_DEFER_INTS;
  c_menu_bar = (GtkMenuBar*)sgtk_get_gtkobj (p_menu_bar);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_position = SCM_INUM (p_position);
  gtk_menu_bar_insert (c_menu_bar, c_child, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_p, "gtk-menu?", 1, 0, 0, sgtk_menu_p);
SCM
sgtk_menu_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_menu_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_menu_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_menu_new, "gtk-menu-new", 0, 0, 0, sgtk_menu_new);
SCM
sgtk_menu_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_menu_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_menu_append, "gtk-menu-append", 2, 0, 0, sgtk_menu_append);
SCM
sgtk_menu_append (SCM p_menu, SCM p_child)
{
  GtkMenu* c_menu;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_append);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_append);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_append (c_menu, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_prepend, "gtk-menu-prepend", 2, 0, 0, sgtk_menu_prepend);
SCM
sgtk_menu_prepend (SCM p_menu, SCM p_child)
{
  GtkMenu* c_menu;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_prepend);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_prepend);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_menu_prepend (c_menu, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_insert, "gtk-menu-insert", 3, 0, 0, sgtk_menu_insert);
SCM
sgtk_menu_insert (SCM p_menu, SCM p_child, SCM p_position)
{
  GtkMenu* c_menu;
  GtkWidget* c_child;
  int c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_insert);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_menu_insert);
  SCM_ASSERT (SCM_INUMP (p_position), p_position, SCM_ARG3, s_gtk_menu_insert);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_position = SCM_INUM (p_position);
  gtk_menu_insert (c_menu, c_child, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_popup_interp, "gtk-menu-popup", 5, 0, 0, sgtk_menu_popup_interp);
SCM
sgtk_menu_popup_interp (SCM p_menu, SCM p_parent_menu_shell, SCM p_parent_menu_item, SCM p_button, SCM p_activate_time)
{
  GtkMenu* c_menu;
  GtkWidget* c_parent_menu_shell;
  GtkWidget* c_parent_menu_item;
  int c_button;
  int c_activate_time;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_popup_interp);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_parent_menu_shell), p_parent_menu_shell, SCM_ARG2, s_gtk_menu_popup_interp);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_parent_menu_item), p_parent_menu_item, SCM_ARG3, s_gtk_menu_popup_interp);
  SCM_ASSERT (SCM_INUMP (p_button), p_button, SCM_ARG4, s_gtk_menu_popup_interp);
  SCM_ASSERT (SCM_INUMP (p_activate_time), p_activate_time, SCM_ARG5, s_gtk_menu_popup_interp);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_parent_menu_shell = (GtkWidget*)sgtk_get_gtkobj (p_parent_menu_shell);
  c_parent_menu_item = (GtkWidget*)sgtk_get_gtkobj (p_parent_menu_item);
  c_button = SCM_INUM (p_button);
  c_activate_time = SCM_INUM (p_activate_time);
  gtk_menu_popup_interp (c_menu, c_parent_menu_shell, c_parent_menu_item, c_button, c_activate_time);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_popdown, "gtk-menu-popdown", 1, 0, 0, sgtk_menu_popdown);
SCM
sgtk_menu_popdown (SCM p_menu)
{
  GtkMenu* c_menu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_popdown);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  gtk_menu_popdown (c_menu);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_get_active, "gtk-menu-get-active", 1, 0, 0, sgtk_menu_get_active);
SCM
sgtk_menu_get_active (SCM p_menu)
{
  GtkWidget* c_ret;
  GtkMenu* c_menu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_get_active);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_ret = gtk_menu_get_active (c_menu);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_menu_set_active, "gtk-menu-set-active", 2, 0, 0, sgtk_menu_set_active);
SCM
sgtk_menu_set_active (SCM p_menu, SCM p_index)
{
  GtkMenu* c_menu;
  int c_index;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_set_active);
  SCM_ASSERT (SCM_INUMP (p_index), p_index, SCM_ARG2, s_gtk_menu_set_active);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_index = SCM_INUM (p_index);
  gtk_menu_set_active (c_menu, c_index);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_set_accelerator_table, "gtk-menu-set-accelerator-table", 2, 0, 0, sgtk_menu_set_accelerator_table);
SCM
sgtk_menu_set_accelerator_table (SCM p_menu, SCM p_table)
{
  GtkMenu* c_menu;
  GtkAcceleratorTable* c_table;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_get_type (), p_menu), p_menu, SCM_ARG1, s_gtk_menu_set_accelerator_table);
  SCM_ASSERT (sgtk_valid_boxed (p_table, &sgtk_accelerator_table_info), p_table, SCM_ARG2, s_gtk_menu_set_accelerator_table);

  SCM_DEFER_INTS;
  c_menu = (GtkMenu*)sgtk_get_gtkobj (p_menu);
  c_table = (GtkAcceleratorTable*)sgtk_scm2boxed (p_table);
  gtk_menu_set_accelerator_table (c_menu, c_table);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_item_p, "gtk-item?", 1, 0, 0, sgtk_item_p);
SCM
sgtk_item_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_item_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_item_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_item_select, "gtk-item-select", 1, 0, 0, sgtk_item_select);
SCM
sgtk_item_select (SCM p_item)
{
  GtkItem* c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_item_get_type (), p_item), p_item, SCM_ARG1, s_gtk_item_select);

  SCM_DEFER_INTS;
  c_item = (GtkItem*)sgtk_get_gtkobj (p_item);
  gtk_item_select (c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_item_deselect, "gtk-item-deselect", 1, 0, 0, sgtk_item_deselect);
SCM
sgtk_item_deselect (SCM p_item)
{
  GtkItem* c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_item_get_type (), p_item), p_item, SCM_ARG1, s_gtk_item_deselect);

  SCM_DEFER_INTS;
  c_item = (GtkItem*)sgtk_get_gtkobj (p_item);
  gtk_item_deselect (c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_item_toggle, "gtk-item-toggle", 1, 0, 0, sgtk_item_toggle);
SCM
sgtk_item_toggle (SCM p_item)
{
  GtkItem* c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_item_get_type (), p_item), p_item, SCM_ARG1, s_gtk_item_toggle);

  SCM_DEFER_INTS;
  c_item = (GtkItem*)sgtk_get_gtkobj (p_item);
  gtk_item_toggle (c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_p, "gtk-menu-item?", 1, 0, 0, sgtk_menu_item_p);
SCM
sgtk_menu_item_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_menu_item_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_menu_item_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_menu_item_new, "gtk-menu-item-new", 0, 0, 0, sgtk_menu_item_new);
SCM
sgtk_menu_item_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_menu_item_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_menu_item_new_with_label, "gtk-menu-item-new-with-label", 1, 0, 0, sgtk_menu_item_new_with_label);
SCM
sgtk_menu_item_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_menu_item_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_menu_item_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_menu_item_set_submenu, "gtk-menu-item-set-submenu", 2, 0, 0, sgtk_menu_item_set_submenu);
SCM
sgtk_menu_item_set_submenu (SCM p_menu_item, SCM p_submenu)
{
  GtkMenuItem* c_menu_item;
  GtkWidget* c_submenu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_set_submenu);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_submenu), p_submenu, SCM_ARG2, s_gtk_menu_item_set_submenu);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  c_submenu = (GtkWidget*)sgtk_get_gtkobj (p_submenu);
  gtk_menu_item_set_submenu (c_menu_item, c_submenu);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_set_placement, "gtk-menu-item-set-placement", 2, 0, 0, sgtk_menu_item_set_placement);
SCM
sgtk_menu_item_set_placement (SCM p_menu_item, SCM p_placement)
{
  GtkMenuItem* c_menu_item;
  GtkSubmenuPlacement c_placement;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_set_placement);
  SCM_ASSERT (sgtk_valid_enum (p_placement, &sgtk_submenu_placement_info), p_placement, SCM_ARG2, s_gtk_menu_item_set_placement);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  c_placement = sgtk_scm2enum (p_placement, &sgtk_submenu_placement_info);
  gtk_menu_item_set_placement (c_menu_item, c_placement);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_accelerator_size, "gtk-menu-item-accelerator-size", 1, 0, 0, sgtk_menu_item_accelerator_size);
SCM
sgtk_menu_item_accelerator_size (SCM p_menu_item)
{
  GtkMenuItem* c_menu_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_accelerator_size);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  gtk_menu_item_accelerator_size (c_menu_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_configure, "gtk-menu-item-configure", 3, 0, 0, sgtk_menu_item_configure);
SCM
sgtk_menu_item_configure (SCM p_menu_item, SCM p_show_toggle_indicator, SCM p_show_submenu_indicator)
{
  GtkMenuItem* c_menu_item;
  int c_show_toggle_indicator;
  int c_show_submenu_indicator;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_configure);
  SCM_ASSERT (((p_show_toggle_indicator) == SCM_BOOL_T || (p_show_toggle_indicator) == SCM_BOOL_F), p_show_toggle_indicator, SCM_ARG2, s_gtk_menu_item_configure);
  SCM_ASSERT (((p_show_submenu_indicator) == SCM_BOOL_T || (p_show_submenu_indicator) == SCM_BOOL_F), p_show_submenu_indicator, SCM_ARG3, s_gtk_menu_item_configure);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  c_show_toggle_indicator = SCM_NFALSEP (p_show_toggle_indicator);
  c_show_submenu_indicator = SCM_NFALSEP (p_show_submenu_indicator);
  gtk_menu_item_configure (c_menu_item, c_show_toggle_indicator, c_show_submenu_indicator);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_select, "gtk-menu-item-select", 1, 0, 0, sgtk_menu_item_select);
SCM
sgtk_menu_item_select (SCM p_menu_item)
{
  GtkMenuItem* c_menu_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_select);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  gtk_menu_item_select (c_menu_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_deselect, "gtk-menu-item-deselect", 1, 0, 0, sgtk_menu_item_deselect);
SCM
sgtk_menu_item_deselect (SCM p_menu_item)
{
  GtkMenuItem* c_menu_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_deselect);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  gtk_menu_item_deselect (c_menu_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_menu_item_activate, "gtk-menu-item-activate", 1, 0, 0, sgtk_menu_item_activate);
SCM
sgtk_menu_item_activate (SCM p_menu_item)
{
  GtkMenuItem* c_menu_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_menu_item_get_type (), p_menu_item), p_menu_item, SCM_ARG1, s_gtk_menu_item_activate);

  SCM_DEFER_INTS;
  c_menu_item = (GtkMenuItem*)sgtk_get_gtkobj (p_menu_item);
  gtk_menu_item_activate (c_menu_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_check_menu_item_p, "gtk-check-menu-item?", 1, 0, 0, sgtk_check_menu_item_p);
SCM
sgtk_check_menu_item_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_check_menu_item_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_check_menu_item_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_check_menu_item_new, "gtk-check-menu-item-new", 0, 0, 0, sgtk_check_menu_item_new);
SCM
sgtk_check_menu_item_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_check_menu_item_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_check_menu_item_new_with_label, "gtk-check-menu-item-new-with-label", 1, 0, 0, sgtk_check_menu_item_new_with_label);
SCM
sgtk_check_menu_item_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_check_menu_item_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_check_menu_item_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_check_menu_item_set_state, "gtk-check-menu-item-set-state", 2, 0, 0, sgtk_check_menu_item_set_state);
SCM
sgtk_check_menu_item_set_state (SCM p_check_menu_item, SCM p_state)
{
  GtkCheckMenuItem* c_check_menu_item;
  int c_state;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_check_menu_item_get_type (), p_check_menu_item), p_check_menu_item, SCM_ARG1, s_gtk_check_menu_item_set_state);
  SCM_ASSERT (((p_state) == SCM_BOOL_T || (p_state) == SCM_BOOL_F), p_state, SCM_ARG2, s_gtk_check_menu_item_set_state);

  SCM_DEFER_INTS;
  c_check_menu_item = (GtkCheckMenuItem*)sgtk_get_gtkobj (p_check_menu_item);
  c_state = SCM_NFALSEP (p_state);
  gtk_check_menu_item_set_state (c_check_menu_item, c_state);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_check_menu_item_toggled, "gtk-check-menu-item-toggled", 1, 0, 0, sgtk_check_menu_item_toggled);
SCM
sgtk_check_menu_item_toggled (SCM p_check_menu_item)
{
  GtkCheckMenuItem* c_check_menu_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_check_menu_item_get_type (), p_check_menu_item), p_check_menu_item, SCM_ARG1, s_gtk_check_menu_item_toggled);

  SCM_DEFER_INTS;
  c_check_menu_item = (GtkCheckMenuItem*)sgtk_get_gtkobj (p_check_menu_item);
  gtk_check_menu_item_toggled (c_check_menu_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_radio_menu_item_p, "gtk-radio-menu-item?", 1, 0, 0, sgtk_radio_menu_item_p);
SCM
sgtk_radio_menu_item_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_radio_menu_item_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_radio_menu_item_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_radio_menu_item_new_interp, "gtk-radio-menu-item-new", 1, 0, 0, sgtk_radio_menu_item_new_interp);
SCM
sgtk_radio_menu_item_new_interp (SCM p_group)
{
  GtkWidget* c_ret;
  GtkRadioMenuItem* c_group;
  SCM_ASSERT (p_group == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_radio_menu_item_get_type (), p_group), p_group, SCM_ARG1, s_gtk_radio_menu_item_new_interp);

  SCM_DEFER_INTS;
  c_group = (GtkRadioMenuItem*)sgtk_get_gtkobj (p_group);
  c_ret = gtk_radio_menu_item_new_interp (c_group);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_radio_menu_item_new_with_label_interp, "gtk-radio-menu-item-new-with-label", 2, 0, 0, sgtk_radio_menu_item_new_with_label_interp);
SCM
sgtk_radio_menu_item_new_with_label_interp (SCM p_group, SCM p_label)
{
  GtkWidget* c_ret;
  GtkRadioMenuItem* c_group;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT (p_group == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_radio_menu_item_get_type (), p_group), p_group, SCM_ARG1, s_gtk_radio_menu_item_new_with_label_interp);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG2, s_gtk_radio_menu_item_new_with_label_interp);

  SCM_DEFER_INTS;
  c_group = (GtkRadioMenuItem*)sgtk_get_gtkobj (p_group);
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_radio_menu_item_new_with_label_interp (c_group, c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_option_menu_p, "gtk-option-menu?", 1, 0, 0, sgtk_option_menu_p);
SCM
sgtk_option_menu_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_option_menu_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_option_menu_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_option_menu_new, "gtk-option-menu-new", 0, 0, 0, sgtk_option_menu_new);
SCM
sgtk_option_menu_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_option_menu_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_option_menu_get_menu, "gtk-option-menu-get-menu", 1, 0, 0, sgtk_option_menu_get_menu);
SCM
sgtk_option_menu_get_menu (SCM p_option_menu)
{
  GtkWidget* c_ret;
  GtkOptionMenu* c_option_menu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_option_menu_get_type (), p_option_menu), p_option_menu, SCM_ARG1, s_gtk_option_menu_get_menu);

  SCM_DEFER_INTS;
  c_option_menu = (GtkOptionMenu*)sgtk_get_gtkobj (p_option_menu);
  c_ret = gtk_option_menu_get_menu (c_option_menu);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_option_menu_set_menu, "gtk-option-menu-set-menu", 2, 0, 0, sgtk_option_menu_set_menu);
SCM
sgtk_option_menu_set_menu (SCM p_option_menu, SCM p_menu)
{
  GtkOptionMenu* c_option_menu;
  GtkWidget* c_menu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_option_menu_get_type (), p_option_menu), p_option_menu, SCM_ARG1, s_gtk_option_menu_set_menu);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_menu), p_menu, SCM_ARG2, s_gtk_option_menu_set_menu);

  SCM_DEFER_INTS;
  c_option_menu = (GtkOptionMenu*)sgtk_get_gtkobj (p_option_menu);
  c_menu = (GtkWidget*)sgtk_get_gtkobj (p_menu);
  gtk_option_menu_set_menu (c_option_menu, c_menu);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_option_menu_remove_menu, "gtk-option-menu-remove-menu", 1, 0, 0, sgtk_option_menu_remove_menu);
SCM
sgtk_option_menu_remove_menu (SCM p_option_menu)
{
  GtkOptionMenu* c_option_menu;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_option_menu_get_type (), p_option_menu), p_option_menu, SCM_ARG1, s_gtk_option_menu_remove_menu);

  SCM_DEFER_INTS;
  c_option_menu = (GtkOptionMenu*)sgtk_get_gtkobj (p_option_menu);
  gtk_option_menu_remove_menu (c_option_menu);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_option_menu_set_history, "gtk-option-menu-set-history", 2, 0, 0, sgtk_option_menu_set_history);
SCM
sgtk_option_menu_set_history (SCM p_option_menu, SCM p_index)
{
  GtkOptionMenu* c_option_menu;
  int c_index;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_option_menu_get_type (), p_option_menu), p_option_menu, SCM_ARG1, s_gtk_option_menu_set_history);
  SCM_ASSERT (SCM_INUMP (p_index), p_index, SCM_ARG2, s_gtk_option_menu_set_history);

  SCM_DEFER_INTS;
  c_option_menu = (GtkOptionMenu*)sgtk_get_gtkobj (p_option_menu);
  c_index = SCM_INUM (p_index);
  gtk_option_menu_set_history (c_option_menu, c_index);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_pixmap_p, "gtk-pixmap?", 1, 0, 0, sgtk_pixmap_p);
SCM
sgtk_pixmap_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_pixmap_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_pixmap_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_pixmap_new_interp, "gtk-pixmap-new", 2, 0, 0, sgtk_pixmap_new_interp);
SCM
sgtk_pixmap_new_interp (SCM p_xpm_file, SCM p_intended_parent)
{
  GtkWidget* c_ret;
  char* c_xpm_file;
  GtkWidget* c_intended_parent;
  p_xpm_file = sgtk_string_conversion (p_xpm_file);
  SCM_ASSERT ((SCM_NIMP(p_xpm_file) && SCM_STRINGP(p_xpm_file)), p_xpm_file, SCM_ARG1, s_gtk_pixmap_new_interp);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_intended_parent), p_intended_parent, SCM_ARG2, s_gtk_pixmap_new_interp);

  SCM_DEFER_INTS;
  c_xpm_file = ((p_xpm_file) == SCM_BOOL_F? NULL : SCM_CHARS(p_xpm_file));
  c_intended_parent = (GtkWidget*)sgtk_get_gtkobj (p_intended_parent);
  c_ret = gtk_pixmap_new_interp (c_xpm_file, c_intended_parent);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_data_p, "gtk-data?", 1, 0, 0, sgtk_data_p);
SCM
sgtk_data_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_data_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_data_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_adjustment_p, "gtk-adjustment?", 1, 0, 0, sgtk_adjustment_p);
SCM
sgtk_adjustment_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_adjustment_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_adjustment_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_adjustment_new, "gtk-adjustment-new", 6, 0, 0, sgtk_adjustment_new);
SCM
sgtk_adjustment_new (SCM p_value, SCM p_lower, SCM p_upper, SCM p_step_increment, SCM p_page_increment, SCM p_page_size)
{
  GtkObject* c_ret;
  gfloat c_value;
  gfloat c_lower;
  gfloat c_upper;
  gfloat c_step_increment;
  gfloat c_page_increment;
  gfloat c_page_size;
  SCM_ASSERT (sgtk_valid_float (p_value), p_value, SCM_ARG1, s_gtk_adjustment_new);
  SCM_ASSERT (sgtk_valid_float (p_lower), p_lower, SCM_ARG2, s_gtk_adjustment_new);
  SCM_ASSERT (sgtk_valid_float (p_upper), p_upper, SCM_ARG3, s_gtk_adjustment_new);
  SCM_ASSERT (sgtk_valid_float (p_step_increment), p_step_increment, SCM_ARG4, s_gtk_adjustment_new);
  SCM_ASSERT (sgtk_valid_float (p_page_increment), p_page_increment, SCM_ARG5, s_gtk_adjustment_new);
  SCM_ASSERT (sgtk_valid_float (p_page_size), p_page_size, SCM_ARG6, s_gtk_adjustment_new);

  SCM_DEFER_INTS;
  c_value = sgtk_scm2float (p_value);
  c_lower = sgtk_scm2float (p_lower);
  c_upper = sgtk_scm2float (p_upper);
  c_step_increment = sgtk_scm2float (p_step_increment);
  c_page_increment = sgtk_scm2float (p_page_increment);
  c_page_size = sgtk_scm2float (p_page_size);
  c_ret = gtk_adjustment_new (c_value, c_lower, c_upper, c_step_increment, c_page_increment, c_page_size);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_scrolled_window_p, "gtk-scrolled-window?", 1, 0, 0, sgtk_scrolled_window_p);
SCM
sgtk_scrolled_window_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_scrolled_window_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_scrolled_window_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_scrolled_window_new, "gtk-scrolled-window-new", 0, 2, 0, sgtk_scrolled_window_new);
SCM
sgtk_scrolled_window_new (SCM p_hadjustment, SCM p_vadjustment)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_hadjustment;
  GtkAdjustment* c_vadjustment;
  if (p_hadjustment != SCM_UNDEFINED)
    SCM_ASSERT (p_hadjustment == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_hadjustment), p_hadjustment, SCM_ARG1, s_gtk_scrolled_window_new);
  if (p_vadjustment != SCM_UNDEFINED)
    SCM_ASSERT (p_vadjustment == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_vadjustment), p_vadjustment, SCM_ARG2, s_gtk_scrolled_window_new);

  SCM_DEFER_INTS;
  if (p_hadjustment == SCM_UNDEFINED)
    c_hadjustment = NULL;
  else
    c_hadjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_hadjustment);
  if (p_vadjustment == SCM_UNDEFINED)
    c_vadjustment = NULL;
  else
    c_vadjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_vadjustment);
  c_ret = gtk_scrolled_window_new (c_hadjustment, c_vadjustment);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_scrolled_window_get_hadjustment, "gtk-scrolled-window-get-hadjustment", 1, 0, 0, sgtk_scrolled_window_get_hadjustment);
SCM
sgtk_scrolled_window_get_hadjustment (SCM p_scrolled_window)
{
  GtkAdjustment* c_ret;
  GtkScrolledWindow* c_scrolled_window;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scrolled_window_get_type (), p_scrolled_window), p_scrolled_window, SCM_ARG1, s_gtk_scrolled_window_get_hadjustment);

  SCM_DEFER_INTS;
  c_scrolled_window = (GtkScrolledWindow*)sgtk_get_gtkobj (p_scrolled_window);
  c_ret = gtk_scrolled_window_get_hadjustment (c_scrolled_window);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_scrolled_window_get_vadjustment, "gtk-scrolled-window-get-vadjustment", 1, 0, 0, sgtk_scrolled_window_get_vadjustment);
SCM
sgtk_scrolled_window_get_vadjustment (SCM p_scrolled_window)
{
  GtkAdjustment* c_ret;
  GtkScrolledWindow* c_scrolled_window;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scrolled_window_get_type (), p_scrolled_window), p_scrolled_window, SCM_ARG1, s_gtk_scrolled_window_get_vadjustment);

  SCM_DEFER_INTS;
  c_scrolled_window = (GtkScrolledWindow*)sgtk_get_gtkobj (p_scrolled_window);
  c_ret = gtk_scrolled_window_get_vadjustment (c_scrolled_window);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_scrolled_window_set_policy, "gtk-scrolled-window-set-policy", 3, 0, 0, sgtk_scrolled_window_set_policy);
SCM
sgtk_scrolled_window_set_policy (SCM p_scrolled_window, SCM p_hscrollbar_policy, SCM p_vscrollbar_policy)
{
  GtkScrolledWindow* c_scrolled_window;
  GtkPolicyType c_hscrollbar_policy;
  GtkPolicyType c_vscrollbar_policy;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scrolled_window_get_type (), p_scrolled_window), p_scrolled_window, SCM_ARG1, s_gtk_scrolled_window_set_policy);
  SCM_ASSERT (sgtk_valid_enum (p_hscrollbar_policy, &sgtk_policy_type_info), p_hscrollbar_policy, SCM_ARG2, s_gtk_scrolled_window_set_policy);
  SCM_ASSERT (sgtk_valid_enum (p_vscrollbar_policy, &sgtk_policy_type_info), p_vscrollbar_policy, SCM_ARG3, s_gtk_scrolled_window_set_policy);

  SCM_DEFER_INTS;
  c_scrolled_window = (GtkScrolledWindow*)sgtk_get_gtkobj (p_scrolled_window);
  c_hscrollbar_policy = sgtk_scm2enum (p_hscrollbar_policy, &sgtk_policy_type_info);
  c_vscrollbar_policy = sgtk_scm2enum (p_vscrollbar_policy, &sgtk_policy_type_info);
  gtk_scrolled_window_set_policy (c_scrolled_window, c_hscrollbar_policy, c_vscrollbar_policy);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_item_p, "gtk-list-item?", 1, 0, 0, sgtk_list_item_p);
SCM
sgtk_list_item_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_list_item_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_list_item_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_list_item_new, "gtk-list-item-new", 0, 0, 0, sgtk_list_item_new);
SCM
sgtk_list_item_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_list_item_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_list_item_new_with_label, "gtk-list-item-new-with-label", 1, 0, 0, sgtk_list_item_new_with_label);
SCM
sgtk_list_item_new_with_label (SCM p_label)
{
  GtkWidget* c_ret;
  char* c_label;
  p_label = sgtk_string_conversion (p_label);
  SCM_ASSERT ((SCM_NIMP(p_label) && SCM_STRINGP(p_label)), p_label, SCM_ARG1, s_gtk_list_item_new_with_label);

  SCM_DEFER_INTS;
  c_label = ((p_label) == SCM_BOOL_F? NULL : SCM_CHARS(p_label));
  c_ret = gtk_list_item_new_with_label (c_label);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_list_item_select, "gtk-list-item-select", 1, 0, 0, sgtk_list_item_select);
SCM
sgtk_list_item_select (SCM p_list_item)
{
  GtkListItem* c_list_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_item_get_type (), p_list_item), p_list_item, SCM_ARG1, s_gtk_list_item_select);

  SCM_DEFER_INTS;
  c_list_item = (GtkListItem*)sgtk_get_gtkobj (p_list_item);
  gtk_list_item_select (c_list_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_item_deselect, "gtk-list-item-deselect", 1, 0, 0, sgtk_list_item_deselect);
SCM
sgtk_list_item_deselect (SCM p_list_item)
{
  GtkListItem* c_list_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_item_get_type (), p_list_item), p_list_item, SCM_ARG1, s_gtk_list_item_deselect);

  SCM_DEFER_INTS;
  c_list_item = (GtkListItem*)sgtk_get_gtkobj (p_list_item);
  gtk_list_item_deselect (c_list_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_p, "gtk-list?", 1, 0, 0, sgtk_list_p);
SCM
sgtk_list_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_list_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_list_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_list_new, "gtk-list-new", 0, 0, 0, sgtk_list_new);
SCM
sgtk_list_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_list_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_list_append_item, "gtk-list-append-item", 2, 0, 0, sgtk_list_append_item);
SCM
sgtk_list_append_item (SCM p_list, SCM p_item)
{
  GtkList* c_list;
  GtkListItem* c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_append_item);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_item_get_type (), p_item), p_item, SCM_ARG2, s_gtk_list_append_item);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_item = (GtkListItem*)sgtk_get_gtkobj (p_item);
  gtk_list_append_item (c_list, c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_prepend_item, "gtk-list-prepend-item", 2, 0, 0, sgtk_list_prepend_item);
SCM
sgtk_list_prepend_item (SCM p_list, SCM p_item)
{
  GtkList* c_list;
  GtkListItem* c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_prepend_item);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_item_get_type (), p_item), p_item, SCM_ARG2, s_gtk_list_prepend_item);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_item = (GtkListItem*)sgtk_get_gtkobj (p_item);
  gtk_list_prepend_item (c_list, c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_clear_items, "gtk-list-clear-items", 3, 0, 0, sgtk_list_clear_items);
SCM
sgtk_list_clear_items (SCM p_list, SCM p_start, SCM p_end)
{
  GtkList* c_list;
  int c_start;
  int c_end;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_clear_items);
  SCM_ASSERT (SCM_INUMP (p_start), p_start, SCM_ARG2, s_gtk_list_clear_items);
  SCM_ASSERT (SCM_INUMP (p_end), p_end, SCM_ARG3, s_gtk_list_clear_items);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_start = SCM_INUM (p_start);
  c_end = SCM_INUM (p_end);
  gtk_list_clear_items (c_list, c_start, c_end);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_select_item, "gtk-list-select-item", 2, 0, 0, sgtk_list_select_item);
SCM
sgtk_list_select_item (SCM p_list, SCM p_item)
{
  GtkList* c_list;
  int c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_select_item);
  SCM_ASSERT (SCM_INUMP (p_item), p_item, SCM_ARG2, s_gtk_list_select_item);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_item = SCM_INUM (p_item);
  gtk_list_select_item (c_list, c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_unselect_item, "gtk-list-unselect-item", 2, 0, 0, sgtk_list_unselect_item);
SCM
sgtk_list_unselect_item (SCM p_list, SCM p_item)
{
  GtkList* c_list;
  int c_item;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_unselect_item);
  SCM_ASSERT (SCM_INUMP (p_item), p_item, SCM_ARG2, s_gtk_list_unselect_item);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_item = SCM_INUM (p_item);
  gtk_list_unselect_item (c_list, c_item);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_select_child, "gtk-list-select-child", 2, 0, 0, sgtk_list_select_child);
SCM
sgtk_list_select_child (SCM p_list, SCM p_child)
{
  GtkList* c_list;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_select_child);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_list_select_child);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_list_select_child (c_list, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_unselect_child, "gtk-list-unselect-child", 2, 0, 0, sgtk_list_unselect_child);
SCM
sgtk_list_unselect_child (SCM p_list, SCM p_child)
{
  GtkList* c_list;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_unselect_child);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_list_unselect_child);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_list_unselect_child (c_list, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_list_child_position, "gtk-list-child-position", 2, 0, 0, sgtk_list_child_position);
SCM
sgtk_list_child_position (SCM p_list, SCM p_child)
{
  int c_ret;
  GtkList* c_list;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_child_position);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_list_child_position);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_ret = gtk_list_child_position (c_list, c_child);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_list_set_selection_mode, "gtk-list-set-selection-mode", 2, 0, 0, sgtk_list_set_selection_mode);
SCM
sgtk_list_set_selection_mode (SCM p_list, SCM p_mode)
{
  GtkList* c_list;
  GtkSelectionMode c_mode;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_list_get_type (), p_list), p_list, SCM_ARG1, s_gtk_list_set_selection_mode);
  SCM_ASSERT (sgtk_valid_enum (p_mode, &sgtk_selection_mode_info), p_mode, SCM_ARG2, s_gtk_list_set_selection_mode);

  SCM_DEFER_INTS;
  c_list = (GtkList*)sgtk_get_gtkobj (p_list);
  c_mode = sgtk_scm2enum (p_mode, &sgtk_selection_mode_info);
  gtk_list_set_selection_mode (c_list, c_mode);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_p, "gtk-notebook?", 1, 0, 0, sgtk_notebook_p);
SCM
sgtk_notebook_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_notebook_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_notebook_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_notebook_tab_pos, "gtk-notebook-tab-pos", 1, 0, 0, sgtk_notebook_tab_pos);
SCM
sgtk_notebook_tab_pos (SCM p_obj)
{
  GtkPositionType c_ret;
  GtkNotebook* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_notebook_tab_pos);
  c_obj = (GtkNotebook*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->tab_pos;

  return sgtk_enum2scm (c_ret, &sgtk_position_type_info);
}

SCM_PROC (s_gtk_notebook_new, "gtk-notebook-new", 0, 0, 0, sgtk_notebook_new);
SCM
sgtk_notebook_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_notebook_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_notebook_append_page, "gtk-notebook-append-page", 3, 0, 0, sgtk_notebook_append_page);
SCM
sgtk_notebook_append_page (SCM p_notebook, SCM p_child, SCM p_tab_label)
{
  GtkNotebook* c_notebook;
  GtkWidget* c_child;
  GtkWidget* c_tab_label;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_append_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_notebook_append_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_tab_label), p_tab_label, SCM_ARG3, s_gtk_notebook_append_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_tab_label = (GtkWidget*)sgtk_get_gtkobj (p_tab_label);
  gtk_notebook_append_page (c_notebook, c_child, c_tab_label);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_prepend_page, "gtk-notebook-prepend-page", 3, 0, 0, sgtk_notebook_prepend_page);
SCM
sgtk_notebook_prepend_page (SCM p_notebook, SCM p_child, SCM p_tab_label)
{
  GtkNotebook* c_notebook;
  GtkWidget* c_child;
  GtkWidget* c_tab_label;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_prepend_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_notebook_prepend_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_tab_label), p_tab_label, SCM_ARG3, s_gtk_notebook_prepend_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_tab_label = (GtkWidget*)sgtk_get_gtkobj (p_tab_label);
  gtk_notebook_prepend_page (c_notebook, c_child, c_tab_label);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_insert_page, "gtk-notebook-insert-page", 4, 0, 0, sgtk_notebook_insert_page);
SCM
sgtk_notebook_insert_page (SCM p_notebook, SCM p_child, SCM p_tab_label, SCM p_position)
{
  GtkNotebook* c_notebook;
  GtkWidget* c_child;
  GtkWidget* c_tab_label;
  int c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_insert_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_notebook_insert_page);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_tab_label), p_tab_label, SCM_ARG3, s_gtk_notebook_insert_page);
  SCM_ASSERT (SCM_INUMP (p_position), p_position, SCM_ARG4, s_gtk_notebook_insert_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  c_tab_label = (GtkWidget*)sgtk_get_gtkobj (p_tab_label);
  c_position = SCM_INUM (p_position);
  gtk_notebook_insert_page (c_notebook, c_child, c_tab_label, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_remove_page, "gtk-notebook-remove-page", 2, 0, 0, sgtk_notebook_remove_page);
SCM
sgtk_notebook_remove_page (SCM p_notebook, SCM p_page_num)
{
  GtkNotebook* c_notebook;
  int c_page_num;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_remove_page);
  SCM_ASSERT (SCM_INUMP (p_page_num), p_page_num, SCM_ARG2, s_gtk_notebook_remove_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_page_num = SCM_INUM (p_page_num);
  gtk_notebook_remove_page (c_notebook, c_page_num);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_current_page, "gtk-notebook-current-page", 1, 0, 0, sgtk_notebook_current_page);
SCM
sgtk_notebook_current_page (SCM p_notebook)
{
  int c_ret;
  GtkNotebook* c_notebook;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_current_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_ret = gtk_notebook_current_page (c_notebook);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_notebook_set_page, "gtk-notebook-set-page", 2, 0, 0, sgtk_notebook_set_page);
SCM
sgtk_notebook_set_page (SCM p_notebook, SCM p_page_num)
{
  GtkNotebook* c_notebook;
  int c_page_num;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_set_page);
  SCM_ASSERT (SCM_INUMP (p_page_num), p_page_num, SCM_ARG2, s_gtk_notebook_set_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_page_num = SCM_INUM (p_page_num);
  gtk_notebook_set_page (c_notebook, c_page_num);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_next_page, "gtk-notebook-next-page", 1, 0, 0, sgtk_notebook_next_page);
SCM
sgtk_notebook_next_page (SCM p_notebook)
{
  GtkNotebook* c_notebook;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_next_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  gtk_notebook_next_page (c_notebook);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_prev_page, "gtk-notebook-prev-page", 1, 0, 0, sgtk_notebook_prev_page);
SCM
sgtk_notebook_prev_page (SCM p_notebook)
{
  GtkNotebook* c_notebook;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_prev_page);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  gtk_notebook_prev_page (c_notebook);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_set_tab_pos, "gtk-notebook-set-tab-pos", 2, 0, 0, sgtk_notebook_set_tab_pos);
SCM
sgtk_notebook_set_tab_pos (SCM p_notebook, SCM p_pos)
{
  GtkNotebook* c_notebook;
  GtkPositionType c_pos;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_set_tab_pos);
  SCM_ASSERT (sgtk_valid_enum (p_pos, &sgtk_position_type_info), p_pos, SCM_ARG2, s_gtk_notebook_set_tab_pos);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_pos = sgtk_scm2enum (p_pos, &sgtk_position_type_info);
  gtk_notebook_set_tab_pos (c_notebook, c_pos);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_set_show_tabs, "gtk-notebook-set-show-tabs", 2, 0, 0, sgtk_notebook_set_show_tabs);
SCM
sgtk_notebook_set_show_tabs (SCM p_notebook, SCM p_show_tabs)
{
  GtkNotebook* c_notebook;
  int c_show_tabs;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_set_show_tabs);
  SCM_ASSERT (((p_show_tabs) == SCM_BOOL_T || (p_show_tabs) == SCM_BOOL_F), p_show_tabs, SCM_ARG2, s_gtk_notebook_set_show_tabs);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_show_tabs = SCM_NFALSEP (p_show_tabs);
  gtk_notebook_set_show_tabs (c_notebook, c_show_tabs);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_notebook_set_show_border, "gtk-notebook-set-show-border", 2, 0, 0, sgtk_notebook_set_show_border);
SCM
sgtk_notebook_set_show_border (SCM p_notebook, SCM p_show_border)
{
  GtkNotebook* c_notebook;
  int c_show_border;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_notebook_get_type (), p_notebook), p_notebook, SCM_ARG1, s_gtk_notebook_set_show_border);
  SCM_ASSERT (((p_show_border) == SCM_BOOL_T || (p_show_border) == SCM_BOOL_F), p_show_border, SCM_ARG2, s_gtk_notebook_set_show_border);

  SCM_DEFER_INTS;
  c_notebook = (GtkNotebook*)sgtk_get_gtkobj (p_notebook);
  c_show_border = SCM_NFALSEP (p_show_border);
  gtk_notebook_set_show_border (c_notebook, c_show_border);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_p, "gtk-entry?", 1, 0, 0, sgtk_entry_p);
SCM
sgtk_entry_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_entry_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_entry_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_entry_new, "gtk-entry-new", 0, 0, 0, sgtk_entry_new);
SCM
sgtk_entry_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_entry_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_entry_set_text, "gtk-entry-set-text", 2, 0, 0, sgtk_entry_set_text);
SCM
sgtk_entry_set_text (SCM p_entry, SCM p_text)
{
  GtkEntry* c_entry;
  char* c_text;
  p_text = sgtk_string_conversion (p_text);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_set_text);
  SCM_ASSERT ((SCM_NIMP(p_text) && SCM_STRINGP(p_text)), p_text, SCM_ARG2, s_gtk_entry_set_text);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_text = ((p_text) == SCM_BOOL_F? NULL : SCM_CHARS(p_text));
  gtk_entry_set_text (c_entry, c_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_append_text, "gtk-entry-append-text", 2, 0, 0, sgtk_entry_append_text);
SCM
sgtk_entry_append_text (SCM p_entry, SCM p_text)
{
  GtkEntry* c_entry;
  char* c_text;
  p_text = sgtk_string_conversion (p_text);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_append_text);
  SCM_ASSERT ((SCM_NIMP(p_text) && SCM_STRINGP(p_text)), p_text, SCM_ARG2, s_gtk_entry_append_text);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_text = ((p_text) == SCM_BOOL_F? NULL : SCM_CHARS(p_text));
  gtk_entry_append_text (c_entry, c_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_prepend_text, "gtk-entry-prepend-text", 2, 0, 0, sgtk_entry_prepend_text);
SCM
sgtk_entry_prepend_text (SCM p_entry, SCM p_text)
{
  GtkEntry* c_entry;
  char* c_text;
  p_text = sgtk_string_conversion (p_text);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_prepend_text);
  SCM_ASSERT ((SCM_NIMP(p_text) && SCM_STRINGP(p_text)), p_text, SCM_ARG2, s_gtk_entry_prepend_text);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_text = ((p_text) == SCM_BOOL_F? NULL : SCM_CHARS(p_text));
  gtk_entry_prepend_text (c_entry, c_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_set_position, "gtk-entry-set-position", 2, 0, 0, sgtk_entry_set_position);
SCM
sgtk_entry_set_position (SCM p_entry, SCM p_position)
{
  GtkEntry* c_entry;
  int c_position;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_set_position);
  SCM_ASSERT (SCM_INUMP (p_position), p_position, SCM_ARG2, s_gtk_entry_set_position);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_position = SCM_INUM (p_position);
  gtk_entry_set_position (c_entry, c_position);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_get_text, "gtk-entry-get-text", 1, 0, 0, sgtk_entry_get_text);
SCM
sgtk_entry_get_text (SCM p_entry)
{
  char* c_ret;
  GtkEntry* c_entry;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_get_text);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_ret = gtk_entry_get_text (c_entry);
  SCM_ALLOW_INTS;

  return (c_ret == NULL? SCM_BOOL_F : scm_makfrom0str (c_ret));
}

SCM_PROC (s_gtk_entry_select_region, "gtk-entry-select-region", 3, 0, 0, sgtk_entry_select_region);
SCM
sgtk_entry_select_region (SCM p_entry, SCM p_start, SCM p_end)
{
  GtkEntry* c_entry;
  int c_start;
  int c_end;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_select_region);
  SCM_ASSERT (SCM_INUMP (p_start), p_start, SCM_ARG2, s_gtk_entry_select_region);
  SCM_ASSERT (SCM_INUMP (p_end), p_end, SCM_ARG3, s_gtk_entry_select_region);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_start = SCM_INUM (p_start);
  c_end = SCM_INUM (p_end);
  gtk_entry_select_region (c_entry, c_start, c_end);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_set_visibility, "gtk-entry-set-visibility", 2, 0, 0, sgtk_entry_set_visibility);
SCM
sgtk_entry_set_visibility (SCM p_entry, SCM p_visible)
{
  GtkEntry* c_entry;
  int c_visible;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_set_visibility);
  SCM_ASSERT (((p_visible) == SCM_BOOL_T || (p_visible) == SCM_BOOL_F), p_visible, SCM_ARG2, s_gtk_entry_set_visibility);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_visible = SCM_NFALSEP (p_visible);
  gtk_entry_set_visibility (c_entry, c_visible);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_entry_set_editable, "gtk-entry-set-editable", 2, 0, 0, sgtk_entry_set_editable);
SCM
sgtk_entry_set_editable (SCM p_entry, SCM p_editable)
{
  GtkEntry* c_entry;
  int c_editable;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_entry_get_type (), p_entry), p_entry, SCM_ARG1, s_gtk_entry_set_editable);
  SCM_ASSERT (((p_editable) == SCM_BOOL_T || (p_editable) == SCM_BOOL_F), p_editable, SCM_ARG2, s_gtk_entry_set_editable);

  SCM_DEFER_INTS;
  c_entry = (GtkEntry*)sgtk_get_gtkobj (p_entry);
  c_editable = SCM_NFALSEP (p_editable);
  gtk_entry_set_editable (c_entry, c_editable);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_p, "gtk-text?", 1, 0, 0, sgtk_text_p);
SCM
sgtk_text_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_text_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_text_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_text_new, "gtk-text-new", 2, 0, 0, sgtk_text_new);
SCM
sgtk_text_new (SCM p_hadj, SCM p_vadj)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_hadj;
  GtkAdjustment* c_vadj;
  SCM_ASSERT (p_hadj == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_hadj), p_hadj, SCM_ARG1, s_gtk_text_new);
  SCM_ASSERT (p_vadj == SCM_BOOL_F || sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_vadj), p_vadj, SCM_ARG2, s_gtk_text_new);

  SCM_DEFER_INTS;
  c_hadj = (GtkAdjustment*)sgtk_get_gtkobj (p_hadj);
  c_vadj = (GtkAdjustment*)sgtk_get_gtkobj (p_vadj);
  c_ret = gtk_text_new (c_hadj, c_vadj);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_text_set_editable, "gtk-text-set-editable", 2, 0, 0, sgtk_text_set_editable);
SCM
sgtk_text_set_editable (SCM p_text, SCM p_editable)
{
  GtkText* c_text;
  int c_editable;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_set_editable);
  SCM_ASSERT (((p_editable) == SCM_BOOL_T || (p_editable) == SCM_BOOL_F), p_editable, SCM_ARG2, s_gtk_text_set_editable);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_editable = SCM_NFALSEP (p_editable);
  gtk_text_set_editable (c_text, c_editable);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_set_adjustments, "gtk-text-set-adjustments", 3, 0, 0, sgtk_text_set_adjustments);
SCM
sgtk_text_set_adjustments (SCM p_text, SCM p_hadj, SCM p_vadj)
{
  GtkText* c_text;
  GtkAdjustment* c_hadj;
  GtkAdjustment* c_vadj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_set_adjustments);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_hadj), p_hadj, SCM_ARG2, s_gtk_text_set_adjustments);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_vadj), p_vadj, SCM_ARG3, s_gtk_text_set_adjustments);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_hadj = (GtkAdjustment*)sgtk_get_gtkobj (p_hadj);
  c_vadj = (GtkAdjustment*)sgtk_get_gtkobj (p_vadj);
  gtk_text_set_adjustments (c_text, c_hadj, c_vadj);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_set_point, "gtk-text-set-point", 2, 0, 0, sgtk_text_set_point);
SCM
sgtk_text_set_point (SCM p_text, SCM p_index)
{
  GtkText* c_text;
  unsigned int c_index;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_set_point);
  SCM_ASSERT (SCM_INUMP (p_index), p_index, SCM_ARG2, s_gtk_text_set_point);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_index = SCM_INUM (p_index);
  gtk_text_set_point (c_text, c_index);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_get_point, "gtk-text-get-point", 1, 0, 0, sgtk_text_get_point);
SCM
sgtk_text_get_point (SCM p_text)
{
  unsigned int c_ret;
  GtkText* c_text;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_get_point);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_ret = gtk_text_get_point (c_text);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_text_get_length, "gtk-text-get-length", 1, 0, 0, sgtk_text_get_length);
SCM
sgtk_text_get_length (SCM p_text)
{
  unsigned int c_ret;
  GtkText* c_text;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_get_length);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_ret = gtk_text_get_length (c_text);
  SCM_ALLOW_INTS;

  return SCM_MAKINUM (c_ret);
}

SCM_PROC (s_gtk_text_freeze, "gtk-text-freeze", 1, 0, 0, sgtk_text_freeze);
SCM
sgtk_text_freeze (SCM p_text)
{
  GtkText* c_text;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_freeze);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  gtk_text_freeze (c_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_thaw, "gtk-text-thaw", 1, 0, 0, sgtk_text_thaw);
SCM
sgtk_text_thaw (SCM p_text)
{
  GtkText* c_text;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_thaw);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  gtk_text_thaw (c_text);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_insert, "gtk-text-insert", 6, 0, 0, sgtk_text_insert);
SCM
sgtk_text_insert (SCM p_text, SCM p_font, SCM p_fore, SCM p_back, SCM p_chars, SCM p_length)
{
  GtkText* c_text;
  GdkFont* c_font;
  GdkColor* c_fore;
  GdkColor* c_back;
  char* c_chars;
  int c_length;
  p_font = sgtk_font_conversion (p_font);
  p_fore = sgtk_color_conversion (p_fore);
  p_back = sgtk_color_conversion (p_back);
  p_chars = sgtk_string_conversion (p_chars);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_insert);
  SCM_ASSERT (p_font == SCM_BOOL_F || sgtk_valid_boxed (p_font, &sgtk_gdk_font_info), p_font, SCM_ARG2, s_gtk_text_insert);
  SCM_ASSERT (p_fore == SCM_BOOL_F || sgtk_valid_boxed (p_fore, &sgtk_gdk_color_info), p_fore, SCM_ARG3, s_gtk_text_insert);
  SCM_ASSERT (p_back == SCM_BOOL_F || sgtk_valid_boxed (p_back, &sgtk_gdk_color_info), p_back, SCM_ARG4, s_gtk_text_insert);
  SCM_ASSERT ((SCM_NIMP(p_chars) && SCM_STRINGP(p_chars)), p_chars, SCM_ARG5, s_gtk_text_insert);
  SCM_ASSERT (SCM_INUMP (p_length), p_length, SCM_ARG6, s_gtk_text_insert);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_font = (GdkFont*)sgtk_scm2boxed (p_font);
  c_fore = (GdkColor*)sgtk_scm2boxed (p_fore);
  c_back = (GdkColor*)sgtk_scm2boxed (p_back);
  c_chars = ((p_chars) == SCM_BOOL_F? NULL : SCM_CHARS(p_chars));
  c_length = SCM_INUM (p_length);
  gtk_text_insert (c_text, c_font, c_fore, c_back, c_chars, c_length);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_backward_delete, "gtk-text-backward-delete", 2, 0, 0, sgtk_text_backward_delete);
SCM
sgtk_text_backward_delete (SCM p_text, SCM p_nchars)
{
  GtkText* c_text;
  unsigned int c_nchars;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_backward_delete);
  SCM_ASSERT (SCM_INUMP (p_nchars), p_nchars, SCM_ARG2, s_gtk_text_backward_delete);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_nchars = SCM_INUM (p_nchars);
  gtk_text_backward_delete (c_text, c_nchars);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_text_forward_delete, "gtk-text-forward-delete", 2, 0, 0, sgtk_text_forward_delete);
SCM
sgtk_text_forward_delete (SCM p_text, SCM p_nchars)
{
  GtkText* c_text;
  unsigned int c_nchars;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_text_get_type (), p_text), p_text, SCM_ARG1, s_gtk_text_forward_delete);
  SCM_ASSERT (SCM_INUMP (p_nchars), p_nchars, SCM_ARG2, s_gtk_text_forward_delete);

  SCM_DEFER_INTS;
  c_text = (GtkText*)sgtk_get_gtkobj (p_text);
  c_nchars = SCM_INUM (p_nchars);
  gtk_text_forward_delete (c_text, c_nchars);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_alignment_p, "gtk-alignment?", 1, 0, 0, sgtk_alignment_p);
SCM
sgtk_alignment_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_alignment_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_alignment_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_alignment_new, "gtk-alignment-new", 4, 0, 0, sgtk_alignment_new);
SCM
sgtk_alignment_new (SCM p_xalign, SCM p_yalign, SCM p_xscale, SCM p_yscale)
{
  GtkWidget* c_ret;
  gfloat c_xalign;
  gfloat c_yalign;
  gfloat c_xscale;
  gfloat c_yscale;
  SCM_ASSERT (sgtk_valid_float (p_xalign), p_xalign, SCM_ARG1, s_gtk_alignment_new);
  SCM_ASSERT (sgtk_valid_float (p_yalign), p_yalign, SCM_ARG2, s_gtk_alignment_new);
  SCM_ASSERT (sgtk_valid_float (p_xscale), p_xscale, SCM_ARG3, s_gtk_alignment_new);
  SCM_ASSERT (sgtk_valid_float (p_yscale), p_yscale, SCM_ARG4, s_gtk_alignment_new);

  SCM_DEFER_INTS;
  c_xalign = sgtk_scm2float (p_xalign);
  c_yalign = sgtk_scm2float (p_yalign);
  c_xscale = sgtk_scm2float (p_xscale);
  c_yscale = sgtk_scm2float (p_yscale);
  c_ret = gtk_alignment_new (c_xalign, c_yalign, c_xscale, c_yscale);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_alignment_set, "gtk-alignment-set", 5, 0, 0, sgtk_alignment_set);
SCM
sgtk_alignment_set (SCM p_alignment, SCM p_xalign, SCM p_yalign, SCM p_xscale, SCM p_yscale)
{
  GtkAlignment* c_alignment;
  gfloat c_xalign;
  gfloat c_yalign;
  gfloat c_xscale;
  gfloat c_yscale;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_alignment_get_type (), p_alignment), p_alignment, SCM_ARG1, s_gtk_alignment_set);
  SCM_ASSERT (sgtk_valid_float (p_xalign), p_xalign, SCM_ARG2, s_gtk_alignment_set);
  SCM_ASSERT (sgtk_valid_float (p_yalign), p_yalign, SCM_ARG3, s_gtk_alignment_set);
  SCM_ASSERT (sgtk_valid_float (p_xscale), p_xscale, SCM_ARG4, s_gtk_alignment_set);
  SCM_ASSERT (sgtk_valid_float (p_yscale), p_yscale, SCM_ARG5, s_gtk_alignment_set);

  SCM_DEFER_INTS;
  c_alignment = (GtkAlignment*)sgtk_get_gtkobj (p_alignment);
  c_xalign = sgtk_scm2float (p_xalign);
  c_yalign = sgtk_scm2float (p_yalign);
  c_xscale = sgtk_scm2float (p_xscale);
  c_yscale = sgtk_scm2float (p_yscale);
  gtk_alignment_set (c_alignment, c_xalign, c_yalign, c_xscale, c_yscale);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gdk_color_parse_interp, "gdk-color-parse", 1, 0, 0, sgtk_gdk_color_parse_interp);
SCM
sgtk_gdk_color_parse_interp (SCM p_spec)
{
  GdkColor* c_ret;
  char* c_spec;
  p_spec = sgtk_string_conversion (p_spec);
  SCM_ASSERT ((SCM_NIMP(p_spec) && SCM_STRINGP(p_spec)), p_spec, SCM_ARG1, s_gdk_color_parse_interp);

  SCM_DEFER_INTS;
  c_spec = ((p_spec) == SCM_BOOL_F? NULL : SCM_CHARS(p_spec));
  c_ret = gdk_color_parse_interp (c_spec);
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_color_info, 1);
}

SCM_PROC (s_gtk_preview_p, "gtk-preview?", 1, 0, 0, sgtk_preview_p);
SCM
sgtk_preview_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_preview_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_preview_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_drawing_area_p, "gtk-drawing-area?", 1, 0, 0, sgtk_drawing_area_p);
SCM
sgtk_drawing_area_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_drawing_area_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_drawing_area_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_drawing_area_new, "gtk-drawing-area-new", 0, 0, 0, sgtk_drawing_area_new);
SCM
sgtk_drawing_area_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_drawing_area_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_preview_set_install_cmap, "gtk-preview-set-install-cmap", 1, 0, 0, sgtk_preview_set_install_cmap);
SCM
sgtk_preview_set_install_cmap (SCM p_install_cmap)
{
  int c_install_cmap;
  SCM_ASSERT (((p_install_cmap) == SCM_BOOL_T || (p_install_cmap) == SCM_BOOL_F), p_install_cmap, SCM_ARG1, s_gtk_preview_set_install_cmap);

  SCM_DEFER_INTS;
  c_install_cmap = SCM_NFALSEP (p_install_cmap);
  gtk_preview_set_install_cmap (c_install_cmap);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_preview_set_reserved, "gtk-preview-set-reserved", 1, 0, 0, sgtk_preview_set_reserved);
SCM
sgtk_preview_set_reserved (SCM p_nreserved)
{
  int c_nreserved;
  SCM_ASSERT (SCM_INUMP (p_nreserved), p_nreserved, SCM_ARG1, s_gtk_preview_set_reserved);

  SCM_DEFER_INTS;
  c_nreserved = SCM_INUM (p_nreserved);
  gtk_preview_set_reserved (c_nreserved);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_preview_get_visual, "gtk-preview-get-visual", 0, 0, 0, sgtk_preview_get_visual);
SCM
sgtk_preview_get_visual ()
{
  GdkVisual* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_preview_get_visual ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_visual_info, 1);
}

SCM_PROC (s_gtk_preview_get_cmap, "gtk-preview-get-cmap", 0, 0, 0, sgtk_preview_get_cmap);
SCM
sgtk_preview_get_cmap ()
{
  GdkColormap* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_preview_get_cmap ();
  SCM_ALLOW_INTS;

  return sgtk_boxed2scm (c_ret, &sgtk_gdk_colormap_info, 1);
}

SCM_PROC (s_gtk_file_selection_p, "gtk-file-selection?", 1, 0, 0, sgtk_file_selection_p);
SCM
sgtk_file_selection_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_file_selection_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_file_selection_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_file_selection_dir_list, "gtk-file-selection-dir-list", 1, 0, 0, sgtk_file_selection_dir_list);
SCM
sgtk_file_selection_dir_list (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_dir_list);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->dir_list;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_file_list, "gtk-file-selection-file-list", 1, 0, 0, sgtk_file_selection_file_list);
SCM
sgtk_file_selection_file_list (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_file_list);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->file_list;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_selection_entry, "gtk-file-selection-selection-entry", 1, 0, 0, sgtk_file_selection_selection_entry);
SCM
sgtk_file_selection_selection_entry (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_selection_entry);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->selection_entry;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_selection_text, "gtk-file-selection-selection-text", 1, 0, 0, sgtk_file_selection_selection_text);
SCM
sgtk_file_selection_selection_text (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_selection_text);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->selection_text;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_main_vbox, "gtk-file-selection-main-vbox", 1, 0, 0, sgtk_file_selection_main_vbox);
SCM
sgtk_file_selection_main_vbox (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_main_vbox);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->main_vbox;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_ok_button, "gtk-file-selection-ok-button", 1, 0, 0, sgtk_file_selection_ok_button);
SCM
sgtk_file_selection_ok_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_ok_button);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->ok_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_cancel_button, "gtk-file-selection-cancel-button", 1, 0, 0, sgtk_file_selection_cancel_button);
SCM
sgtk_file_selection_cancel_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_cancel_button);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->cancel_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_help_button, "gtk-file-selection-help-button", 1, 0, 0, sgtk_file_selection_help_button);
SCM
sgtk_file_selection_help_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkFileSelection* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_file_selection_help_button);
  c_obj = (GtkFileSelection*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->help_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_new, "gtk-file-selection-new", 1, 0, 0, sgtk_file_selection_new);
SCM
sgtk_file_selection_new (SCM p_title)
{
  GtkWidget* c_ret;
  char* c_title;
  p_title = sgtk_string_conversion (p_title);
  SCM_ASSERT ((SCM_NIMP(p_title) && SCM_STRINGP(p_title)), p_title, SCM_ARG1, s_gtk_file_selection_new);

  SCM_DEFER_INTS;
  c_title = ((p_title) == SCM_BOOL_F? NULL : SCM_CHARS(p_title));
  c_ret = gtk_file_selection_new (c_title);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_file_selection_set_filename, "gtk-file-selection-set-filename", 2, 0, 0, sgtk_file_selection_set_filename);
SCM
sgtk_file_selection_set_filename (SCM p_filesel, SCM p_filename)
{
  GtkFileSelection* c_filesel;
  char* c_filename;
  p_filename = sgtk_string_conversion (p_filename);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_filesel), p_filesel, SCM_ARG1, s_gtk_file_selection_set_filename);
  SCM_ASSERT ((SCM_NIMP(p_filename) && SCM_STRINGP(p_filename)), p_filename, SCM_ARG2, s_gtk_file_selection_set_filename);

  SCM_DEFER_INTS;
  c_filesel = (GtkFileSelection*)sgtk_get_gtkobj (p_filesel);
  c_filename = ((p_filename) == SCM_BOOL_F? NULL : SCM_CHARS(p_filename));
  gtk_file_selection_set_filename (c_filesel, c_filename);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_file_selection_get_filename, "gtk-file-selection-get-filename", 1, 0, 0, sgtk_file_selection_get_filename);
SCM
sgtk_file_selection_get_filename (SCM p_filesel)
{
  char* c_ret;
  GtkFileSelection* c_filesel;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_file_selection_get_type (), p_filesel), p_filesel, SCM_ARG1, s_gtk_file_selection_get_filename);

  SCM_DEFER_INTS;
  c_filesel = (GtkFileSelection*)sgtk_get_gtkobj (p_filesel);
  c_ret = gtk_file_selection_get_filename (c_filesel);
  SCM_ALLOW_INTS;

  return (c_ret == NULL? SCM_BOOL_F : scm_makfrom0str (c_ret));
}

SCM_PROC (s_gtk_color_selection_dialog_p, "gtk-color-selection-dialog?", 1, 0, 0, sgtk_color_selection_dialog_p);
SCM
sgtk_color_selection_dialog_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_color_selection_dialog_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_color_selection_dialog_colorsel, "gtk-color-selection-dialog-colorsel", 1, 0, 0, sgtk_color_selection_dialog_colorsel);
SCM
sgtk_color_selection_dialog_colorsel (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_colorsel);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->colorsel;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_main_vbox, "gtk-color-selection-dialog-main-vbox", 1, 0, 0, sgtk_color_selection_dialog_main_vbox);
SCM
sgtk_color_selection_dialog_main_vbox (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_main_vbox);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->main_vbox;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_ok_button, "gtk-color-selection-dialog-ok-button", 1, 0, 0, sgtk_color_selection_dialog_ok_button);
SCM
sgtk_color_selection_dialog_ok_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_ok_button);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->ok_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_reset_button, "gtk-color-selection-dialog-reset-button", 1, 0, 0, sgtk_color_selection_dialog_reset_button);
SCM
sgtk_color_selection_dialog_reset_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_reset_button);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->reset_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_cancel_button, "gtk-color-selection-dialog-cancel-button", 1, 0, 0, sgtk_color_selection_dialog_cancel_button);
SCM
sgtk_color_selection_dialog_cancel_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_cancel_button);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->cancel_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_help_button, "gtk-color-selection-dialog-help-button", 1, 0, 0, sgtk_color_selection_dialog_help_button);
SCM
sgtk_color_selection_dialog_help_button (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkColorSelectionDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_color_selection_dialog_help_button);
  c_obj = (GtkColorSelectionDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->help_button;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_dialog_new, "gtk-color-selection-dialog-new", 1, 0, 0, sgtk_color_selection_dialog_new);
SCM
sgtk_color_selection_dialog_new (SCM p_title)
{
  GtkWidget* c_ret;
  char* c_title;
  p_title = sgtk_string_conversion (p_title);
  SCM_ASSERT ((SCM_NIMP(p_title) && SCM_STRINGP(p_title)), p_title, SCM_ARG1, s_gtk_color_selection_dialog_new);

  SCM_DEFER_INTS;
  c_title = ((p_title) == SCM_BOOL_F? NULL : SCM_CHARS(p_title));
  c_ret = gtk_color_selection_dialog_new (c_title);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_p, "gtk-color-selection?", 1, 0, 0, sgtk_color_selection_p);
SCM
sgtk_color_selection_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_color_selection_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_color_selection_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_color_selection_new, "gtk-color-selection-new", 0, 0, 0, sgtk_color_selection_new);
SCM
sgtk_color_selection_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_color_selection_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_color_selection_set_update_policy, "gtk-color-selection-set-update-policy", 2, 0, 0, sgtk_color_selection_set_update_policy);
SCM
sgtk_color_selection_set_update_policy (SCM p_colorsel, SCM p_policy)
{
  GtkColorSelection* c_colorsel;
  GtkUpdateType c_policy;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_get_type (), p_colorsel), p_colorsel, SCM_ARG1, s_gtk_color_selection_set_update_policy);
  SCM_ASSERT (sgtk_valid_enum (p_policy, &sgtk_update_type_info), p_policy, SCM_ARG2, s_gtk_color_selection_set_update_policy);

  SCM_DEFER_INTS;
  c_colorsel = (GtkColorSelection*)sgtk_get_gtkobj (p_colorsel);
  c_policy = sgtk_scm2enum (p_policy, &sgtk_update_type_info);
  gtk_color_selection_set_update_policy (c_colorsel, c_policy);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_color_selection_set_opacity, "gtk-color-selection-set-opacity", 2, 0, 0, sgtk_color_selection_set_opacity);
SCM
sgtk_color_selection_set_opacity (SCM p_colorsel, SCM p_use_opacity)
{
  GtkColorSelection* c_colorsel;
  int c_use_opacity;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_color_selection_get_type (), p_colorsel), p_colorsel, SCM_ARG1, s_gtk_color_selection_set_opacity);
  SCM_ASSERT (((p_use_opacity) == SCM_BOOL_T || (p_use_opacity) == SCM_BOOL_F), p_use_opacity, SCM_ARG2, s_gtk_color_selection_set_opacity);

  SCM_DEFER_INTS;
  c_colorsel = (GtkColorSelection*)sgtk_get_gtkobj (p_colorsel);
  c_use_opacity = SCM_NFALSEP (p_use_opacity);
  gtk_color_selection_set_opacity (c_colorsel, c_use_opacity);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_range_p, "gtk-range?", 1, 0, 0, sgtk_range_p);
SCM
sgtk_range_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_range_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_range_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_range_get_adjustment, "gtk-range-get-adjustment", 1, 0, 0, sgtk_range_get_adjustment);
SCM
sgtk_range_get_adjustment (SCM p_range)
{
  GtkAdjustment* c_ret;
  GtkRange* c_range;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_range_get_type (), p_range), p_range, SCM_ARG1, s_gtk_range_get_adjustment);

  SCM_DEFER_INTS;
  c_range = (GtkRange*)sgtk_get_gtkobj (p_range);
  c_ret = gtk_range_get_adjustment (c_range);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_range_set_update_policy, "gtk-range-set-update-policy", 2, 0, 0, sgtk_range_set_update_policy);
SCM
sgtk_range_set_update_policy (SCM p_range, SCM p_policy)
{
  GtkRange* c_range;
  GtkUpdateType c_policy;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_range_get_type (), p_range), p_range, SCM_ARG1, s_gtk_range_set_update_policy);
  SCM_ASSERT (sgtk_valid_enum (p_policy, &sgtk_update_type_info), p_policy, SCM_ARG2, s_gtk_range_set_update_policy);

  SCM_DEFER_INTS;
  c_range = (GtkRange*)sgtk_get_gtkobj (p_range);
  c_policy = sgtk_scm2enum (p_policy, &sgtk_update_type_info);
  gtk_range_set_update_policy (c_range, c_policy);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_range_set_adjustment, "gtk-range-set-adjustment", 2, 0, 0, sgtk_range_set_adjustment);
SCM
sgtk_range_set_adjustment (SCM p_range, SCM p_adjustment)
{
  GtkRange* c_range;
  GtkAdjustment* c_adjustment;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_range_get_type (), p_range), p_range, SCM_ARG1, s_gtk_range_set_adjustment);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_adjustment), p_adjustment, SCM_ARG2, s_gtk_range_set_adjustment);

  SCM_DEFER_INTS;
  c_range = (GtkRange*)sgtk_get_gtkobj (p_range);
  c_adjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_adjustment);
  gtk_range_set_adjustment (c_range, c_adjustment);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_scale_p, "gtk-scale?", 1, 0, 0, sgtk_scale_p);
SCM
sgtk_scale_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_scale_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_scale_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_scale_set_digits, "gtk-scale-set-digits", 2, 0, 0, sgtk_scale_set_digits);
SCM
sgtk_scale_set_digits (SCM p_scale, SCM p_digits)
{
  GtkScale* c_scale;
  int c_digits;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scale_get_type (), p_scale), p_scale, SCM_ARG1, s_gtk_scale_set_digits);
  SCM_ASSERT (((p_digits) == SCM_BOOL_T || (p_digits) == SCM_BOOL_F), p_digits, SCM_ARG2, s_gtk_scale_set_digits);

  SCM_DEFER_INTS;
  c_scale = (GtkScale*)sgtk_get_gtkobj (p_scale);
  c_digits = SCM_NFALSEP (p_digits);
  gtk_scale_set_digits (c_scale, c_digits);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_scale_set_draw_value, "gtk-scale-set-draw-value", 2, 0, 0, sgtk_scale_set_draw_value);
SCM
sgtk_scale_set_draw_value (SCM p_scale, SCM p_draw_value)
{
  GtkScale* c_scale;
  int c_draw_value;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scale_get_type (), p_scale), p_scale, SCM_ARG1, s_gtk_scale_set_draw_value);
  SCM_ASSERT (((p_draw_value) == SCM_BOOL_T || (p_draw_value) == SCM_BOOL_F), p_draw_value, SCM_ARG2, s_gtk_scale_set_draw_value);

  SCM_DEFER_INTS;
  c_scale = (GtkScale*)sgtk_get_gtkobj (p_scale);
  c_draw_value = SCM_NFALSEP (p_draw_value);
  gtk_scale_set_draw_value (c_scale, c_draw_value);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_scale_set_value_pos, "gtk-scale-set-value-pos", 2, 0, 0, sgtk_scale_set_value_pos);
SCM
sgtk_scale_set_value_pos (SCM p_scale, SCM p_pos)
{
  GtkScale* c_scale;
  GtkPositionType c_pos;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_scale_get_type (), p_scale), p_scale, SCM_ARG1, s_gtk_scale_set_value_pos);
  SCM_ASSERT (sgtk_valid_enum (p_pos, &sgtk_position_type_info), p_pos, SCM_ARG2, s_gtk_scale_set_value_pos);

  SCM_DEFER_INTS;
  c_scale = (GtkScale*)sgtk_get_gtkobj (p_scale);
  c_pos = sgtk_scm2enum (p_pos, &sgtk_position_type_info);
  gtk_scale_set_value_pos (c_scale, c_pos);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_hscale_p, "gtk-hscale?", 1, 0, 0, sgtk_hscale_p);
SCM
sgtk_hscale_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_hscale_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_hscale_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hscale_new, "gtk-hscale-new", 1, 0, 0, sgtk_hscale_new);
SCM
sgtk_hscale_new (SCM p_adjustment)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_adjustment;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_adjustment), p_adjustment, SCM_ARG1, s_gtk_hscale_new);

  SCM_DEFER_INTS;
  c_adjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_adjustment);
  c_ret = gtk_hscale_new (c_adjustment);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_vscale_p, "gtk-vscale?", 1, 0, 0, sgtk_vscale_p);
SCM
sgtk_vscale_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_vscale_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_vscale_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_vscale_new, "gtk-vscale-new", 1, 0, 0, sgtk_vscale_new);
SCM
sgtk_vscale_new (SCM p_adjustment)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_adjustment;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_adjustment), p_adjustment, SCM_ARG1, s_gtk_vscale_new);

  SCM_DEFER_INTS;
  c_adjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_adjustment);
  c_ret = gtk_vscale_new (c_adjustment);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_scrollbar_p, "gtk-scrollbar?", 1, 0, 0, sgtk_scrollbar_p);
SCM
sgtk_scrollbar_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_scrollbar_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_scrollbar_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hscrollbar_p, "gtk-hscrollbar?", 1, 0, 0, sgtk_hscrollbar_p);
SCM
sgtk_hscrollbar_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_hscrollbar_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_hscrollbar_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hscrollbar_new, "gtk-hscrollbar-new", 1, 0, 0, sgtk_hscrollbar_new);
SCM
sgtk_hscrollbar_new (SCM p_adjustment)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_adjustment;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_adjustment), p_adjustment, SCM_ARG1, s_gtk_hscrollbar_new);

  SCM_DEFER_INTS;
  c_adjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_adjustment);
  c_ret = gtk_hscrollbar_new (c_adjustment);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_vscrollbar_p, "gtk-vscrollbar?", 1, 0, 0, sgtk_vscrollbar_p);
SCM
sgtk_vscrollbar_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_vscrollbar_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_vscrollbar_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_vscrollbar_new, "gtk-vscrollbar-new", 1, 0, 0, sgtk_vscrollbar_new);
SCM
sgtk_vscrollbar_new (SCM p_adjustment)
{
  GtkWidget* c_ret;
  GtkAdjustment* c_adjustment;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_adjustment_get_type (), p_adjustment), p_adjustment, SCM_ARG1, s_gtk_vscrollbar_new);

  SCM_DEFER_INTS;
  c_adjustment = (GtkAdjustment*)sgtk_get_gtkobj (p_adjustment);
  c_ret = gtk_vscrollbar_new (c_adjustment);
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_dialog_p, "gtk-dialog?", 1, 0, 0, sgtk_dialog_p);
SCM
sgtk_dialog_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_dialog_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_dialog_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_dialog_vbox, "gtk-dialog-vbox", 1, 0, 0, sgtk_dialog_vbox);
SCM
sgtk_dialog_vbox (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_dialog_vbox);
  c_obj = (GtkDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->vbox;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_dialog_action_area, "gtk-dialog-action-area", 1, 0, 0, sgtk_dialog_action_area);
SCM
sgtk_dialog_action_area (SCM p_obj)
{
  GtkWidget* c_ret;
  GtkDialog* c_obj;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_dialog_get_type (), p_obj), p_obj, SCM_ARG1, s_gtk_dialog_action_area);
  c_obj = (GtkDialog*)sgtk_get_gtkobj (p_obj);
  c_ret = c_obj->action_area;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_dialog_new, "gtk-dialog-new", 0, 0, 0, sgtk_dialog_new);
SCM
sgtk_dialog_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_dialog_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_paned_p, "gtk-paned?", 1, 0, 0, sgtk_paned_p);
SCM
sgtk_paned_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_paned_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_paned_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_paned_add1, "gtk-paned-add1", 2, 0, 0, sgtk_paned_add1);
SCM
sgtk_paned_add1 (SCM p_paned, SCM p_child)
{
  GtkPaned* c_paned;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_paned_get_type (), p_paned), p_paned, SCM_ARG1, s_gtk_paned_add1);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_paned_add1);

  SCM_DEFER_INTS;
  c_paned = (GtkPaned*)sgtk_get_gtkobj (p_paned);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_paned_add1 (c_paned, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_paned_add2, "gtk-paned-add2", 2, 0, 0, sgtk_paned_add2);
SCM
sgtk_paned_add2 (SCM p_paned, SCM p_child)
{
  GtkPaned* c_paned;
  GtkWidget* c_child;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_paned_get_type (), p_paned), p_paned, SCM_ARG1, s_gtk_paned_add2);
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_widget_get_type (), p_child), p_child, SCM_ARG2, s_gtk_paned_add2);

  SCM_DEFER_INTS;
  c_paned = (GtkPaned*)sgtk_get_gtkobj (p_paned);
  c_child = (GtkWidget*)sgtk_get_gtkobj (p_child);
  gtk_paned_add2 (c_paned, c_child);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_paned_handle_size, "gtk-paned-handle-size", 2, 0, 0, sgtk_paned_handle_size);
SCM
sgtk_paned_handle_size (SCM p_paned, SCM p_size)
{
  GtkPaned* c_paned;
  int c_size;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_paned_get_type (), p_paned), p_paned, SCM_ARG1, s_gtk_paned_handle_size);
  SCM_ASSERT (SCM_INUMP (p_size), p_size, SCM_ARG2, s_gtk_paned_handle_size);

  SCM_DEFER_INTS;
  c_paned = (GtkPaned*)sgtk_get_gtkobj (p_paned);
  c_size = SCM_INUM (p_size);
  gtk_paned_handle_size (c_paned, c_size);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_paned_gutter_size, "gtk-paned-gutter-size", 2, 0, 0, sgtk_paned_gutter_size);
SCM
sgtk_paned_gutter_size (SCM p_paned, SCM p_size)
{
  GtkPaned* c_paned;
  int c_size;
  SCM_ASSERT (sgtk_is_a_gtkobj (gtk_paned_get_type (), p_paned), p_paned, SCM_ARG1, s_gtk_paned_gutter_size);
  SCM_ASSERT (SCM_INUMP (p_size), p_size, SCM_ARG2, s_gtk_paned_gutter_size);

  SCM_DEFER_INTS;
  c_paned = (GtkPaned*)sgtk_get_gtkobj (p_paned);
  c_size = SCM_INUM (p_size);
  gtk_paned_gutter_size (c_paned, c_size);
  SCM_ALLOW_INTS;

  return SCM_UNSPECIFIED;
}

SCM_PROC (s_gtk_hpaned_p, "gtk-hpaned?", 1, 0, 0, sgtk_hpaned_p);
SCM
sgtk_hpaned_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_hpaned_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_hpaned_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_hpaned_new, "gtk-hpaned-new", 0, 0, 0, sgtk_hpaned_new);
SCM
sgtk_hpaned_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_hpaned_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

SCM_PROC (s_gtk_vpaned_p, "gtk-vpaned?", 1, 0, 0, sgtk_vpaned_p);
SCM
sgtk_vpaned_p (SCM p_obj)
{
  int c_ret;
  SCM c_obj;
  SCM_ASSERT (TRUE, p_obj, SCM_ARG1, s_gtk_vpaned_p);
  c_obj = p_obj;
  c_ret = sgtk_is_a_gtkobj (gtk_vpaned_get_type (), c_obj);
  return ((c_ret)? SCM_BOOL_T : SCM_BOOL_F);
}

SCM_PROC (s_gtk_vpaned_new, "gtk-vpaned-new", 0, 0, 0, sgtk_vpaned_new);
SCM
sgtk_vpaned_new ()
{
  GtkWidget* c_ret;

  SCM_DEFER_INTS;
  c_ret = gtk_vpaned_new ();
  SCM_ALLOW_INTS;

  return sgtk_wrap_gtkobj ((GtkObject*)c_ret);
}

void
sgtk_init_gtk_defs ()
{
#include "gtk-funcs.x"
}
