#include "obgtk.h"

@implementation Gtk_List
- init
{
  gtklist = GTK_LIST(gtk_list_new());
  return [super castGtkContainer:GTK_CONTAINER(gtklist)];
}

- insert_items:(GList *) items
	  aPos:(gint) position
{
  gtk_list_insert_items(gtklist, items, position);
  return self;
}

- append_items:(GList *) items
{
  gtk_list_append_items(gtklist, items);
  return self;
}

- prepend_items:(GList *) items
{
  gtk_list_prepend_items(gtklist, items);
  return self;
}

- remove_items:(GList *) items
{
  gtk_list_remove_items(gtklist, items);
  return self;
}

- remove:(Gtk_Widget *) item
{
  GList *alist = g_list_append(NULL, (gpointer) item->gtkwidget);
  [self remove_items:alist];
  g_list_free(alist);
  return self;
}

- clear_items:(gint) start
       theEnd:(gint) end
{
  gtk_list_clear_items(gtklist, start, end);
  return self;
}

- select_item:(gint) item
{
  gtk_list_select_item(gtklist, item);
  return self;
}

- unselect_item:(gint) item
{
  gtk_list_unselect_item(gtklist, item);
  return self;
}

- select_child:(Gtk_Widget *) child
{
  gtk_list_select_child(gtklist, child->gtkwidget);
  return self;
}

- unselect_child:(Gtk_Widget *) child
{
  gtk_list_unselect_child(gtklist, child->gtkwidget);
  return self;
}

- set_selection_mode:(GtkSelectionMode) mode
{
  gtk_list_set_selection_mode(gtklist, mode);
  return self;
}
@end
