#include "obgtk.h"

#include <objc/objc-api.h>
#include <string.h>
#include <stdlib.h>

/* #define DEBUG 1 */

gint
obgtk_signal_relay(GtkObject *object,
		   gpointer data,
		   gint nparams,
		   GtkArg *args)
{
  id anobj = nil, sigobj = nil;
  gint retval;
  char *selname;
  IMP callfunc;
  SEL callsel;
  g_return_if_fail(object != NULL);
  g_return_if_fail(data != NULL);

  sigobj = gtk_object_get_data(object, "objc_id");
  selname = g_malloc(strlen(data) + 30);

  /* We always send the destroy signal on
     to actual objects... */
  if(strcmp(data, "destroy"))
    {
	sprintf(selname, "obgtk_signal_object_%s", data);
	anobj = gtk_object_get_data(object, selname);
#ifdef DEBUG
	printf("We got data %#x for %s\n", anobj, selname);
#endif
    }

  if(!anobj)
    anobj = sigobj;

#ifdef DEBUG
  printf("Call to method %s on %#x\n", data, anobj);
#endif

  if(!anobj)
    {
      printf("We don't even have anobj for signal %s\n", data);
      return;
    }

  if(!strcmp(data, "destroy"))
    sprintf(selname, "free");
  else
    sprintf(selname, "%s:", (char *)data);
  callsel = sel_get_uid(selname);
  if(!callsel) {
    g_free(selname);
    objc_error(anobj, 99, "Couldn't find method %s on object.", data);
    return;
  }
  callfunc = objc_msg_lookup(anobj, callsel);

  if(callfunc)
    retval = (gint)callfunc(anobj, callsel, sigobj);
  else
    objc_error(anobj, 99, "Couldn't find method %s on object.", data);
  g_free(selname);
  return retval;
}

gint
obgtk_callback_relay(GtkObject *object,
		     gpointer data)
{
  id anobj = nil, sigobj = nil;
  gint retval;
  char *selname;
  IMP callfunc;
  SEL callsel;
  g_return_if_fail(object != NULL);
  g_return_if_fail(data != NULL);

  sigobj = gtk_object_get_data(object, "objc_id");
  selname = g_malloc(strlen(data) + 30);

  anobj = gtk_object_get_data(object, "obgtk_callback_relay");
#ifdef DEBUG
  printf("We got data %#x for %s\n", anobj, selname);
#endif

  if(!anobj)
    anobj = sigobj;

#ifdef DEBUG
  printf("Call to method %s on %#x\n", data, anobj);
#endif

  if(!anobj)
    {
      printf("We don't even have anobj for callback %s\n", data);
      return;
    }

  sprintf(selname, "%s:", (char *)data);
  callsel = sel_get_uid(selname);
  if(!callsel) {
    g_free(selname);
    objc_error(anobj, 99, "Couldn't find method %s on object.", data);
    return;
  }
  callfunc = objc_msg_lookup(anobj, callsel);

  if(callfunc)
    retval = (gint)callfunc(anobj, callsel, sigobj);
  else
    objc_error(anobj, 99, "Couldn't find method %s on object.", data);
  g_free(selname);
  return retval;
}

@implementation Gtk_Object
- init
{
  self = [super init];
  gtkobject = NULL;
  objc_error(self, 99, "Call to [Gtk_Object init] - probably not calling subclass initFooBlah\n");
  return self;
}

- castGtkObject:(GtkObject *)castitem
{
  self = [super init];
  gtkobject = castitem;
/*  gtk_object_ref(gtkobject); */
  gtk_object_set_data(gtkobject, "objc_id", self);
  return [self connect:"destroy"];
}

- connect:(gchar *) signal_name
{
  gchar *datid;

  g_return_val_if_fail(signal_name != NULL, self);

  datid = g_malloc(strlen(signal_name) + 30);
  sprintf(datid, "obgtk_signal_object_%s", signal_name);
  gtk_object_remove_data(gtkobject, datid);
  gtk_signal_connect_interp(gtkobject, signal_name,
			    (GtkCallbackMarshal) obgtk_signal_relay,
			    signal_name, NULL, 1);
  return self;
}

- connectObj:(gchar *) signal_name
	    :(id) signalObject
{
  gchar *datid;

  g_return_val_if_fail(signal_name != NULL, self);

  datid = g_malloc(strlen(signal_name) + 30);
  sprintf(datid, "obgtk_signal_object_%s", signal_name);
  gtk_object_set_data(gtkobject, datid, signalObject);
  gtk_signal_connect_interp(gtkobject, signal_name,
			    (GtkCallbackMarshal) obgtk_signal_relay,
			    signal_name, NULL, 1);
  return self;
}

- signal_connect:(gchar *) signal_name
      signalFunc:(GtkSignalFunc) signalfunc
	funcData:(gpointer) funcdata
{
  gtk_signal_connect(gtkobject, signal_name, signalfunc, funcdata);
  return self;
}

- free
{
  if(gtkobject) /* We need this here because gtkwidget has to do its
		   own destroy thingie */
    {
      gtk_object_remove_data(GTK_OBJECT(gtkobject), "objc_id");
/*  gtk_object_unref(gtkobject); */
      gtk_object_destroy(gtkobject);
    }
  return [super free];
}

- set_user_data:(gpointer) thedata
{
  gtk_object_set_user_data(gtkobject, thedata);
  return self;
}

- (gpointer)get_user_data
{
  return gtk_object_get_user_data(gtkobject);
}

- set_data:(const gchar *) key
	  :(gpointer) data
{
  gtk_object_set_data(gtkobject, key, data);
  return self;
}

- (gpointer)
  get_data:(const gchar *) key
{
  return gtk_object_get_data(gtkobject, key);
}

- ref
{
  gtk_object_ref(gtkobject);
  return self;
}

- unref
{
  gtk_object_unref(gtkobject);
  return self;
}
@end
