/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _EVAL_H_
#define _EVAL_H_

#include "mpwrap.h"

/*declarations of structures*/
#include "structs.h"

typedef struct _evalstack_t {
	tree_t * * stack;
	int size;
	int top;
} evalstack_t;

/* builtin primitives */
#define E_SEPAR		1
#define E_EQUALS	2
#define E_PLUS		3
#define E_MINUS		4
#define E_MUL		5
#define E_DIV		6
#define E_MOD		7
#define E_NEG		8
#define E_EXP		9
#define E_FACT		10
#define E_FUNCDEF	11
#define E_IF_CONS	12
#define E_IFELSE_CONS	13
#define E_WHILE_CONS	14
#define E_EQ_CMP	15
#define E_NE_CMP	16
#define E_CMP_CMP	17
#define E_LT_CMP	18
#define E_GT_CMP	19
#define E_LE_CMP	20
#define E_GE_CMP	21
#define E_LOGICAL_AND	22
#define E_LOGICAL_OR	23
#define E_LOGICAL_XOR	24
#define E_LOGICAL_NOT	25


/*functions for manipulating a tree*/
tree_t * makenum(mpw_t num);
tree_t * makenum_ui(unsigned long num);
tree_t * makenum_si(long num);
tree_t * makefuncb(int func, evalstack_t * stack);
tree_t * makefuncd(func_t * func, evalstack_t * stack);
/*same as above but used for declarations, it doesn'y pop any arguments of
  the stack and doesn't build an argument array*/
tree_t * makefuncd0(func_t * func);

/*returns 1 or 2 depending if the operation has one or two branches*/
int branches(int op);

/*similiar to the above, which branches should be evaluated*/
int brancheseval(int op);

/*stack manipulation*/
int t_push(tree_t *n,evalstack_t * stack);
tree_t *t_pop(evalstack_t * stack);

/*functions for reclaiming memory*/
void freenode(tree_t *n);
void freetree(tree_t *n);
/*free arguments to a dictionary function*/
void freeargs(tree_t *n);

/*copy a node*/
tree_t * copynode(tree_t *o);

/*evaluate arguments of a function*/
tree_t * evalargs(tree_t *n);

/*evaluate a user function*/
tree_t * evaluserfunc(tree_t *n);

/*evaluate branches of a primitive, returns 0 if all ok, 1 if n should
  be returned or 2 on a serious error*/
int evalbranches(tree_t *n);

/*return TRUE if node is true (a number node !=0), false otherwise*/
int isnodetrue(tree_t *n);

/*evaluate a treenode, the treenode will become a number node*/
/*the tree will be freed*/
tree_t *evalnode(tree_t *n);

/*operations take two/one number nodes and return a number node*/
tree_t *plusop(tree_t *l,tree_t *r);
tree_t *minusop(tree_t *l,tree_t *r);
tree_t *mulop(tree_t *l,tree_t *r);
tree_t *divop(tree_t *l,tree_t *r);
tree_t *modop(tree_t *l,tree_t *r);
tree_t *negop(tree_t *l);
tree_t *expop(tree_t *l, tree_t *r);
tree_t *factop(tree_t *l);
tree_t *equalsop(tree_t *l, tree_t *r);
tree_t *funcdefop(tree_t *l, tree_t *r);
/*tree_t *ifconsop(tree_t *l, tree_t *r);
tree_t *ifelseconsop(tree_t *l, tree_t *r, tree_t *sr);
tree_t *whileconsop(tree_t *l, tree_t *r);*/
tree_t *eqcmpop(tree_t *l, tree_t *r);
tree_t *necmpop(tree_t *l, tree_t *r);
tree_t *cmpcmpop(tree_t *l, tree_t *r);
tree_t *ltcmpop(tree_t *l, tree_t *r);
tree_t *gtcmpop(tree_t *l, tree_t *r);
tree_t *lecmpop(tree_t *l, tree_t *r);
tree_t *gecmpop(tree_t *l, tree_t *r);
tree_t *logicalandop(tree_t *l, tree_t *r);
tree_t *logicalorop(tree_t *l, tree_t *r);
tree_t *logicalxorop(tree_t *l, tree_t *r);
tree_t *logicalnotop(tree_t *r);

/*compare nodes, return -1 if first one is smaller, 0 if they are
  equal, 1 if the first one is greater
  makes them the same type as a side effect*/
int cmpnodes(tree_t *l, tree_t *r);

#endif
