/* GnomENIUS Calculator
 * Copyright (C) 1997 George Lebl.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome.h>
#include <gtk/gtk.h>

#include <string.h>
#include <stdlib.h>

#include "genius.h"
#include "calc.h"
#include "util.h"

/*Globals:*/

/*calculator state*/
calcstate_t curstate={
	INFIX_NOTATION,
	256,
	INFIX_NOTATION,
	12,
	FALSE,
	FALSE,
	FALSE
	};

/*static int base=10;*/
static GtkWidget *history; /*history list*/
static GtkWidget *scrolledwin; /*history list scrolled window*/
static GtkWidget *entry;

static GtkWidget *frame, *numframe, *sciframe,*optframe;

static char *errors=NULL;

/* show/hide frame */
void
showhide(GtkWidget * widget,gpointer * data)
{
	GtkWidget *frm=NULL;

	switch((long int)data) {
		case 1: frm=numframe; break;
		case 2: frm=sciframe; break;
		case 3: frm=optframe; break;
	}

	if(GTK_CHECK_MENU_ITEM(widget)->active)
		gtk_widget_show(frm);
	else
		gtk_widget_hide(frm);
}

/* add the key's label to entry in data */
void
addkey(gchar c)
{
	char *t;
	int curpos;

	curpos=GTK_ENTRY(entry)->current_pos;

	t=getentry(entry);
	shiftstr(&t[curpos],1);
	t[curpos]=c;
	gtk_entry_set_text(GTK_ENTRY(entry),t);
	gtk_entry_set_position(GTK_ENTRY(entry),curpos+1);
	g_free(t);
}

/* add the key's label to entry in data */
void
addkeycb(GtkWidget * widget, gpointer * data)
{
	char *p;

	gtk_label_get(GTK_LABEL(GTK_BUTTON(widget)->child),&p);
	addkey(p[1]);
}

/*display a message in a messagebox*/
void
geniuserrorbox(char *s)
{
	GtkWidget *mb;

	mb=gnome_messagebox_new(s,GNOME_MESSAGEBOX_ERROR,"OK",NULL,NULL);

	gtk_signal_connect_object(GTK_OBJECT(GNOME_MESSAGEBOX(mb)->button1),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(mb));

	gtk_widget_show(mb);
}

/*get error message*/
void
geniuserror(char *s)
{
	if(errors) {
		errors=my_realloc(errors,strlen(errors)+1,
			strlen(errors)+1+strlen(s)+1);
		strcat(errors,"\n");
		strcat(errors,s);
	} else {
		errors=g_malloc(strlen(s)+1);
		strcpy(errors,s);
	}
}


/* parse and evaluate the xpression and get answer and stick it down
  the history list*/
void
dorun(GtkWidget * widget, gpointer * data)
{
	char *t;
	char *o;
	GtkAdjustment *adj;

	t=getentry(entry);
	if(!t || t[0]=='\0')
		return;
	t=addparenth(t); /*add missing parenthesis*/
	o=evalexp(t,curstate,geniuserror);

	if(errors) {
		geniuserrorbox(errors);
		g_free(errors);
		errors=NULL;
	}
	if(!o)
		return;

	list_additem(history,t);
	g_free(t);


	o=prependstr(o," =");
	list_additem(history,o);
	g_free(o);

	adj=gtk_scrolled_window_get_vadjustment(
		GTK_SCROLLED_WINDOW(scrolledwin));
	adj->value=adj->upper;
	gtk_range_set_adjustment(
		GTK_RANGE(GTK_SCROLLED_WINDOW(scrolledwin)->vscrollbar),adj);
	/*clear the input box*/
	gtk_entry_set_text(GTK_ENTRY(entry),"");
}

/*about box*/
void
aboutcb(GtkWidget * widget, gpointer * data)
{
	GtkWidget *mb;

	mb=gnome_messagebox_new("GnomENIUS Calculator\n\nby George Lebl",
		GNOME_MESSAGEBOX_INFO,"OK",NULL,NULL);

	gtk_signal_connect_object(GTK_OBJECT(GNOME_MESSAGEBOX(mb)->button1),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(mb));

	gtk_widget_show(mb);
}

/* quit */
void
quitapp(GtkWidget * widget, gpointer * data)
{
	gtk_main_quit();
}

/*set notation functions*/
void
infixnot(GtkWidget * widget, gpointer * data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		curstate.notation_in=INFIX_NOTATION;
}
void
prefixnot(GtkWidget * widget, gpointer * data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		curstate.notation_in=PREFIX_NOTATION;
}
void
postfixnot(GtkWidget * widget, gpointer * data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		curstate.notation_in=POSTFIX_NOTATION;
}

/*exact answer callback*/
void
exactanscb(GtkWidget * widget, gpointer * data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		curstate.max_digits=0;
	else
		curstate.max_digits=12;
}

/*option callback*/
void
optioncb(GtkWidget * widget, gpointer * data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		*(int *)data=TRUE;
	else
		*(int *)data=FALSE;
}

/*keypress event handler*/
static gint
windowkeypress(GtkWidget *widget, GdkEventKey *event)
{
	char key=*(event->string);

	if(key==3 || key==17) /* ^C || ^Q */
		quitapp(NULL,NULL);
	else if(!GTK_WIDGET_HAS_FOCUS(entry) &&
		strchr("\t\v ",key)==NULL)
		gtk_widget_grab_focus(entry);

	if(key=='\r' ||
		key=='\n')
		dorun(NULL,NULL);

	return TRUE;
}

GtkMenuEntry genius_menu [] = {
        { "Calculator/Quit","<control>Q",(GtkMenuCallback)quitapp,NULL },
        { "View/<check>Numpad",NULL,(GtkMenuCallback)showhide,(gpointer)1 },
        { "View/<check>Scientific",NULL,(GtkMenuCallback)showhide,(gpointer)2 },
        { "View/<check>Options",NULL,(GtkMenuCallback)showhide,(gpointer)3 },
        { "Help/About",NULL,(GtkMenuCallback)aboutcb,NULL },
};

#define ELEMENTS(x) (sizeof (x) / sizeof (x [0]))

/*make us a menubar, slightly copied from same-gnome:)*/
GtkMenuFactory *
create_menu(void)
{
        GtkMenuFactory *mf;
        GtkMenuPath *p;

        mf=gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
        gtk_menu_factory_add_entries(mf,
		genius_menu,ELEMENTS(genius_menu));

	if((p=gtk_menu_factory_find(mf, "Help")))
		gtk_menu_item_right_justify(GTK_MENU_ITEM(p->widget));

	if((p=gtk_menu_factory_find(mf, "View/Numpad")))
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(p->widget),
			TRUE);
	if((p=gtk_menu_factory_find(mf, "View/Options")))
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(p->widget),
			TRUE);
        return mf;
}

/*main window creation, slightly copied from same-gnome:)*/
GtkWidget *
create_main_window(void)
{
	GtkWidget *w;
        w=gnome_app_new("genius", "GnomENIUS Calculator");

        gtk_signal_connect(GTK_OBJECT(w), "delete_event",
		GTK_SIGNAL_FUNC(quitapp), NULL);
        gtk_window_set_policy(GTK_WINDOW(w),1,1,0);
        return w;
}


/*
 * Kind of a long main but all the gui stuff is here and that I guess
 * should be kept in one place
 */
int
main(int argc, char *argv[])
{
	GtkWidget *window;
	GtkMenuFactory *mf;
	GtkWidget *w,*wt; /*widget temp variable*/
	GtkWidget *box,*boxm,*boxh,*boxt;
	GtkWidget *table;
	GtkTooltips *tips;


	/*numpad button labels*/
	char *numpad[5][4]={
		{" ( "," ) "," ^ "," % "},
		{" 7 "," 8 "," 9 "," / "},
		{" 4 "," 5 "," 6 "," * "},
		{" 1 "," 2 "," 3 "," - "},
		{" 0 "," . "," ~ "," + "}
	};
	int x,y;

	gnome_init(&argc, &argv);

	/*set up the top level window*/
	window=create_main_window();



	/*set up the tooltips*/
	tips=gtk_tooltips_new();

	/*the main box to put everything in*/
	boxm=gtk_vbox_new(FALSE,0);


	boxh=gtk_hbox_new(FALSE,0);

	frame=gtk_frame_new("Display");
	box=gtk_vbox_new(FALSE,0);

	scrolledwin=gtk_scrolled_window_new(NULL,NULL);
	gtk_widget_set_usize(scrolledwin,200,100);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(box),scrolledwin,TRUE,TRUE,0);
	gtk_widget_show(scrolledwin);

	history=gtk_list_new();
	gtk_container_add(GTK_CONTAINER(scrolledwin),history);
	gtk_widget_show(history);

	boxt=gtk_hbox_new(FALSE,0);
	entry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(boxt),entry,TRUE,TRUE,0);
	gtk_widget_show(entry);
	w=gtk_button_new_with_label(" = ");
	gtk_signal_connect(GTK_OBJECT(w), "clicked",
		GTK_SIGNAL_FUNC(dorun), entry);
	gtk_box_pack_start(GTK_BOX(boxt),w,FALSE,FALSE,0);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(box),boxt,FALSE,FALSE,0);
	gtk_widget_show(boxt);



	gtk_container_add(GTK_CONTAINER(frame),box);
	gtk_widget_show(box);
	gtk_box_pack_start(GTK_BOX(boxh),frame,TRUE,TRUE,0);
	gtk_widget_show(frame);




	/*numpad*/
	numframe=gtk_frame_new("Numpad");
	table=gtk_table_new(7,6,0);
	gtk_table_set_col_spacings(GTK_TABLE(table),5);
	gtk_table_set_row_spacings(GTK_TABLE(table),5);
	for(x=0;x<4;x++) {
		for(y=0;y<5;y++) {
			w=gtk_button_new_with_label(numpad[y][x]);
			gtk_signal_connect(GTK_OBJECT(w), "clicked",
				GTK_SIGNAL_FUNC(addkeycb), NULL);
			gtk_table_attach_defaults(GTK_TABLE(table),w,
				x+1,x+2,y+1,y+2);
			gtk_widget_show(w);
		}
	}


	gtk_container_add(GTK_CONTAINER(numframe),table);
	gtk_widget_show(table);
	gtk_box_pack_start(GTK_BOX(boxh),numframe,FALSE,FALSE,0);
	gtk_widget_show(numframe);

	/*scientific*/
	sciframe=gtk_frame_new("Scientific");
	gtk_box_pack_start(GTK_BOX(boxh),sciframe,FALSE,FALSE,0);
	/*gtk_widget_show(sciframe);*/
	


	gtk_box_pack_start(GTK_BOX(boxm),boxh,TRUE,TRUE,5);
	gtk_widget_show(boxh);



	/*options area*/
	optframe=gtk_frame_new("Options");
	box=gtk_vbox_new(FALSE,0);

	boxt=gtk_hbox_new(FALSE,0);
	wt=gtk_radio_button_new_with_label(NULL,
		"Prefix notation");
	gtk_signal_connect(GTK_OBJECT(wt), "toggled",
		   GTK_SIGNAL_FUNC(prefixnot),NULL);
	gtk_box_pack_start(GTK_BOX(boxt),wt,TRUE,TRUE,5);
	gtk_widget_show(wt);
	w=gtk_radio_button_new_with_label(
		gtk_radio_button_group(GTK_RADIO_BUTTON(wt)),
		"Infix notation");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(infixnot),NULL);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(w),1);
	w=gtk_radio_button_new_with_label(
		gtk_radio_button_group(GTK_RADIO_BUTTON(wt)),
		"Postfix notation (RPN)");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(postfixnot),NULL);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(box),boxt,FALSE,FALSE,5);
	gtk_widget_show(boxt);

	boxt=gtk_hbox_new(FALSE,0);
	w=gtk_check_button_new_with_label("Full (exact) answers");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(exactanscb),NULL);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	w=gtk_check_button_new_with_label(
		"Make floats integers (e.g. 10.0=10)");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(optioncb),
		   (gpointer *)&curstate.make_floats_ints);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(box),boxt,FALSE,FALSE,5);
	gtk_widget_show(boxt);

	boxt=gtk_hbox_new(FALSE,0);
	w=gtk_check_button_new_with_label("Results as floats");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(optioncb),
		   (gpointer *)&curstate.results_as_floats);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	w=gtk_check_button_new_with_label("Floats in scientific notation");
	gtk_signal_connect(GTK_OBJECT(w), "toggled",
		   GTK_SIGNAL_FUNC(optioncb),
		   (gpointer *)&curstate.scientific_notation);
	gtk_box_pack_start(GTK_BOX(boxt),w,TRUE,TRUE,5);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(box),boxt,FALSE,FALSE,5);
	gtk_widget_show(boxt);

	gtk_container_add(GTK_CONTAINER(optframe),box);
	gtk_widget_show(box);
	gtk_box_pack_start(GTK_BOX(boxm),optframe,FALSE,FALSE,5);
	gtk_widget_show(optframe);


	/*set up the keypress handler*/
	gtk_signal_connect(GTK_OBJECT(window), "key_press_event",
                      GTK_SIGNAL_FUNC(windowkeypress), NULL);
	gtk_widget_set_events(window, GDK_KEY_PRESS_MASK);

	/*set up the menu*/
	mf=create_menu();
	gnome_app_set_menus(GNOME_APP(window), GTK_MENU_BAR(mf->widget));
	gnome_app_menu_set_position(GNOME_APP(window),GNOME_APP_POS_TOP);

	/*set up the main window*/
	gnome_app_set_contents(GNOME_APP(window), boxm);
	gtk_container_border_width(
		GTK_CONTAINER(GNOME_APP(window)->contents),5);

	gtk_widget_show(boxm);
	gtk_widget_show(window);

	gtk_widget_grab_focus(entry);
	gtk_main();

	return 0;
}
