#include "procview.h"
#include "fromtop.h"
//#include "gtkclist.h"

#include <gnome.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/param.h>
#include <asm/page.h>
#include <linux/tasks.h>
#include <time.h>

#define CF ((proc_field *)c->data)
#define CG (*((gint *)g->data))

static GtkWidget *nLabel;
static GtkWidget *table;
static GtkWidget *clist;

static GList *field_list = NULL;
static GList *geometry_list = NULL;
static gint field_list_length;

static gint p_pmem;
static gint p_seconds;
static gint p_current_time;
static time_t p_time;
static float p_elapsed_time;
static gint p_total_time;
static gint p_cl_sum = 0;     // cumulative mode
static unsigned p_gl_main_mem;

static PROCTAB *pt;
static proc_t **proc_tab;

static gint first = 1;

static gint procview_update (gpointer);
static void procview_init (gchar *, gchar *);
static GtkWidget * procview_clist_prepare ();

void
addProcessView () {

     nLabel = gtk_label_new (" Processes ");
/*     procview_init (gnome_config_get_string
		    ("/gtop/procview/fields=0,1,2,3,4,5,6,7,8,9,10,11"),
		    gnome_config_get_string
		    ("/gtop/procview/geometry=50,100,30,30,50,50,50,50,60,60,50,200"));
*/
     procview_init (
		    "0,1,2,3,4,5,6,7,8,9,10,11",
		    "50,100,30,30,50,50,50,50,60,60,50,200");

     clist = procview_clist_prepare ();
     gtk_container_border_width (GTK_CONTAINER (clist), GNOME_PAD);

     gtk_notebook_append_page (GTK_NOTEBOOK (notebook), clist, nLabel);

     gtk_widget_show (nLabel);
     gtk_widget_show (clist);

     pt = openproc (PROC_FILLUSR);
     // when I don't call meminfo, nice & priority values are malformed
     // don't know why ?!?
     meminfo ();
     procview_update (NULL);
     gtk_timeout_add (3000, procview_update, NULL);
}

#define CMP_INT(NAME) static int cmp_ ## NAME (proc_t **P, proc_t **Q) \
{ \
	  return sort_order * ((*P)-> ## NAME - (*Q)-> ## NAME); \
}

#define CMP_STR(NAME) static int cmp_ ## NAME (proc_t **P, proc_t **Q) \
{ \
	  return sort_order * strcasecmp ((*P)-> ## NAME, (*Q)-> ## NAME); \
}

#define SORT_ASC 1
#define SORT_DSC -1

static sort_field = 8;
static sort_order = SORT_ASC;

CMP_INT (pid)
CMP_INT (pcpu)
CMP_INT (size)
CMP_INT (rss)
CMP_INT (nice)
CMP_INT (priority)
CMP_INT (share)

CMP_STR (user)
CMP_STR (cmd)

struct proc_field {
	gchar *label;
	p_fmt fmt;
	int (*compare) (const void *, const void *);
	gint order;
	gint flag;
	GtkJustification justification;
} p_fields [] = {
	{ "PID", P_PID, cmp_pid, SORT_ASC, 0, GTK_JUSTIFY_RIGHT},
	{ "User", P_USER, cmp_user, SORT_ASC, PROC_FILLUSR, GTK_JUSTIFY_LEFT},
	{ "Pri", P_PRIORITY, cmp_priority, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "Ni", P_NICE, cmp_nice, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "Size", P_SIZE, cmp_size, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "RSS", P_RSS, cmp_rss, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "Share", P_SHARE, cmp_share, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "Stat", P_STATE, NULL, SORT_ASC, 0, GTK_JUSTIFY_LEFT},
	{ "%CPU", P_PCPU, cmp_pcpu, SORT_DSC, 0, GTK_JUSTIFY_RIGHT},
	{ "%MEM", P_PMEM, NULL, SORT_ASC, 0, GTK_JUSTIFY_RIGHT},
	{ "Time", P_TIME, NULL, SORT_ASC, 0, GTK_JUSTIFY_RIGHT},
	{ "Cmd", P_CMD, cmp_cmd, SORT_ASC, PROC_FILLCMD, GTK_JUSTIFY_LEFT},
};

void
procview_click_column (GtkCList *cl, gint n)
{
	sort_field = n;
	procview_update (NULL);
}

static GtkWidget *
procview_clist_prepare ()
{
	GtkWidget *cl;
	gint i=0;
	GList *c = field_list;
	GList *g = geometry_list;
	gchar **text = new (gchar *) [field_list_length];

	while (c) {
		text [i++] = CF->label;
		c = c->next;
	}

	cl = gtk_clist_new_with_titles (field_list_length, text);
	gtk_clist_set_policy (GTK_CLIST (cl),
			      GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_signal_connect (GTK_OBJECT (cl), "click_column",
			    GTK_SIGNAL_FUNC (procview_click_column), NULL);
        

	delete [] text;

	c = field_list;
	i = 0;
	while (c) {
		gtk_clist_set_column_justification (GTK_CLIST (cl), i,
						    CF->justification);
		gtk_clist_set_column_width (GTK_CLIST (cl), i++, CG);
		c = c->next;
		g = g->next;
	}

	return cl;
}

void
procview_init (gchar *s, gchar *g)
{
	gchar *c = g_strdup (s);
	gchar *t;
	gchar *gc = g_strdup (g);
	gchar *gt;
	gchar *cc=c;
	gchar *gcc=gc;
	gint index;
	gint *ip;

	//printf ("procview init: %s\n", s);

	field_list_length = 0;
	do {
		t=strchr (c, ',');
		if (c && *c) {
			if (t)
				*t=0;
			index = atoi (c);
			//printf ("%s %d: %s\n", s, index, p_fields [index].label);
			field_list = g_list_append (field_list, p_fields+index);
			field_list_length++;
			if (t)
				c=t+1;
		}	     

		gt=strchr (gc, ',');
		if (gc && *gc) {
			if (gt)
				*gt=0;
			ip = new gint;
			*ip = atoi (gc);
			//printf ("%s %d\n", g, *ip);
			geometry_list = g_list_append (geometry_list, ip);
			if (gt)
				gc=gt+1;
		}	     
	} while (t && gt);

	g_free (cc);
	g_free (gcc);
}

gchar *
sprint_fmt (proc_t *t, p_fmt fmt)
{
	gchar tmp[256];
	gchar *rv;

	switch (fmt) {
	case P_PID:
	case P_PRIORITY:
	case P_NICE:
	case P_RSS:
	case P_SIZE:
	case P_SHARE:
	case P_PCPU:
	case P_PMEM:
		switch (fmt) {
		case P_PID:
			sprintf (tmp, "%d", t->pid);
			break;
		case P_PRIORITY:
			sprintf (tmp, "%d", t->priority);
			break;
		case P_NICE:
			sprintf (tmp, "%d", t->nice);
			break;
		case P_RSS:
			sprintf (tmp, "%d", t->rss << (PAGE_SHIFT - 10));
			break;
		case P_SIZE:
			sprintf (tmp, "%d", t->size << (PAGE_SHIFT - 10));
			break;
		case P_SHARE:
			sprintf (tmp, "%d", t->share << (PAGE_SHIFT - 10));
			break;
		case P_PCPU:
			sprintf (tmp, "%2d.%1d", t->pcpu / 10, t->pcpu % 10);
			break;
		case P_PMEM:
			sprintf (tmp, "%2d.%1d", p_pmem / 10, p_pmem % 10);
			break;
		}
		rv = tmp;
		break;
	case P_STATE:
		rv = status (t);
		break;
	case P_USER:
		rv = t->user;
		break;
	case P_CMD:
		rv = t->cmd;
		break;
	default:
		rv = "?";
	}

	return g_strdup (rv);
}

int
procview_clist_thaw (gpointer)
{
	gtk_clist_thaw (GTK_CLIST (clist));

	return FALSE;
}

void
procview_update_clist (proc_t **t)
{
	gint i=0;
	gint j, k;
	gchar **text = new (gchar *) [field_list_length];
	proc_t *p;
	GList *c;
	float old_adj_hval = GTK_SCROLLBAR (GTK_CLIST (clist)->hscrollbar)
		->range.adjustment->value;
	float old_adj_vval = GTK_SCROLLBAR (GTK_CLIST (clist)->vscrollbar)
		->range.adjustment->value;
	gint old_hoffset = GTK_CLIST (clist)->hoffset;
	gint old_voffset = GTK_CLIST (clist)->voffset;
	
	gtk_clist_freeze (GTK_CLIST (clist));
	gtk_clist_clear (GTK_CLIST (clist));

	while ((p = t[i])) {
		i++;
		c = field_list;
		j = 0;

		// PMEM
		p_pmem = p->rss * 1000 / (p_gl_main_mem >> PAGE_SHIFT);

		while (c) {
			text [j] = sprint_fmt (p, CF->fmt);
			j++;
			c = c->next;
		}
		gtk_clist_append (GTK_CLIST (clist), text);

		for (k=0; k<j; k++)
			g_free (text [k]);
	}

	// keep old view position - somewhat ughly, but works now
	GTK_SCROLLBAR (GTK_CLIST (clist)->hscrollbar)
		->range.adjustment->value = old_adj_hval;
	GTK_SCROLLBAR (GTK_CLIST (clist)->vscrollbar)
		->range.adjustment->value = old_adj_vval;

	GTK_CLIST (clist)->hoffset = old_hoffset;
	GTK_CLIST (clist)->voffset = old_voffset;

	gtk_clist_thaw (GTK_CLIST (clist));

	delete [] text;
}

gint
procview_update (gpointer)
{
	// printf ("procview update\n");

	static struct save_hist save_history[NR_TASKS];
	struct save_hist New_save_hist[NR_TASKS];
	static int prev_count = 0;
	int stime, utime;

	gint i, n=0;
	proc_t *p;

	proc_tab = readproctab (PROC_FILLUSR | PROC_FILLMEM);

	p_current_time = uptime(0, 0);
	p_time = time (NULL);
	p_elapsed_time = get_elapsed_time ();
	p_gl_main_mem = read_total_main ();

	// count number of processes
	//   and compute some values
	while ((p = proc_tab [n])) {
		// compute some values
		p_total_time = (p->utime + p->stime +
				(p_cl_sum ? p->cutime + p->cstime : 0));
		// p_seconds = ((p_current_time * HZ) - p->start_time);
		// PCPU

		New_save_hist[n].ticks = p_total_time;
		New_save_hist[n].pid = p->pid;
		stime = p->stime;
		utime = p->utime;
		New_save_hist[n].stime = stime;
		New_save_hist[n].utime = utime;
		/* find matching entry from previous pass */
		i = 0;
		while (!first && i < prev_count) {
			if (save_history[i].pid == p->pid) {
				p_total_time -= save_history[i].ticks;
				stime -= save_history[i].stime;
				utime -= save_history[i].utime;

				i = NR_TASKS;
			}
			i++;
		}

		if (first) {
			p_elapsed_time = (p_current_time*100 - p->start_time)/HZ;
			//printf ("%d %d %f\n", HZ, p_current_time, p_elapsed_time);
		}

		p->pcpu = (p_elapsed_time > 0.001) ? (unsigned int)
			(((p_total_time * 10 * 100)/HZ) / p_elapsed_time) : 0;
		if (p->pcpu > 999)
			p->pcpu = 999;
		n++;
	}

	for (i = 0; i < n; i++) {
		/* copy the relevant info for the next pass */
		save_history[i].pid = New_save_hist[i].pid;
		save_history[i].ticks = New_save_hist[i].ticks;
		save_history[i].stime = New_save_hist[i].stime;
		save_history[i].utime = New_save_hist[i].utime;
	}
	prev_count = n;

	if (p_fields [sort_field].compare) {
		sort_order = p_fields [sort_field].order;
		qsort (proc_tab, n, sizeof (proc_t *), p_fields [sort_field].compare);
	}

	// update screen
	//if (!first)
		procview_update_clist (proc_tab);
		//else
		first = 0;

	freeproctab (proc_tab);
}
