/* GNOME GUI Library
 * Copyright (C) 1997 the Free Software Foundation
 *
 * Authors: Eckehard Berns
 */

#ifndef __GNOME_STOCK_H__
#define __GNOME_STOCK_H__


/* Use of gdk_imlib can be disabled here.
 */
#undef USE_GDK_IMLIB


#include <libgnome/gnome-defs.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkpixmap.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkbutton.h>
#include <libgnomeui/gnome-pixmap.h>

#ifdef USE_GDK_IMLIB
#include <gdk_imlib.h>
#endif


/* A short description:
 *
 *  These functions provide an applications programmer with default
 *  icons for toolbars, menu pixmaps, etc. One such `icon' should have
 *  at least three pixmaps to reflect it's state. There is a `regular'
 *  pixmap, a `disabled' pixmap and a `focused' pixmap. You can get
 *  either each of these pixmaps by calling gnome_stock_pixmap or you
 *  can get a widget by calling gnome_stock_pixmap_widget. This widget
 *  is a container which gtk_widget_shows the pixmap, that is
 *  reflecting the current state of the widget. If for example you
 *  gtk_container_add this widget to a button, which is currently not
 *  sensitive, the widget will just show the `disabled' pixmap. If the
 *  state of the button changes to sensitive, the widget will change to
 *  the `regular' pixmap. The `focused' pixmap will be shown, when the
 *  mouse pointer enters the widget.
 *
 *  To support themability, we use (char *) to call those functions. A
 *  new theme might register new icons by calling
 *  gnome_stock_pixmap_register, or may change existing icons by
 *  calling gnome_stock_pixmap_change. An application should check (by
 *  calling gnome_stock_pixmap_checkfor), if the current theme supports
 *  an uncommon icon, before using it. The only icons an app can rely
 *  on, are those defined in this haeder file.
 *
 *  We now have stock buttons too. To use them, just replace any
 *  gtk_button_new{_with_label} with
 *  gnome_stock_button(GNOME_STOCK_BUTTON_...).  This function returns
 *  a GtkButton with a gettexted default text and an icon.
 *
 *  There's an additional feature, which might be interesting. If an
 *  application calls gnome_stock_pixmap_register and uses it by
 *  calling gnome_stock_pixmap_widget, it doesn't have to care about
 *  the state_changed signal to display the appropriate pixmap
 *  itself. Additionally gnome-stock generates a disabled version of a
 *  pixmap automatically, when no pixmap for a disabled state is
 *  provided.
 */

/* State:
 *
 *  currently implemented:
 *    - gnome_stock_pixmap
 *    - gnome_stock_pixmap_widget
 *    - gnome_stock_pixmap_checkfor
 *    - GnomeStockPixmapWidget
 *    - gnome_stock_button
 *    - gnome_stock_pixmap_register
 *
 *  not implemented:
 *    - gnome_stock_pixmap_change
 */

BEGIN_GNOME_DECLS

/* The names of `well known' icons. I define these strings mainly to
   prevent errors due to typos. */

#define GNOME_STOCK_PIXMAP_NEW         "New"
#define GNOME_STOCK_PIXMAP_OPEN        "Open"
#define GNOME_STOCK_PIXMAP_SAVE        "Save"
#define GNOME_STOCK_PIXMAP_CUT         "Cut"
#define GNOME_STOCK_PIXMAP_COPY        "Copy"
#define GNOME_STOCK_PIXMAP_PASTE       "Paste"
#define GNOME_STOCK_PIXMAP_PROPERTIES  "Properties"
#define GNOME_STOCK_PIXMAP_PREFERENCES "Preferences"
#define GNOME_STOCK_PIXMAP_HELP        "Help"
#define GNOME_STOCK_PIXMAP_SCORES      "Scores"
#define GNOME_STOCK_PIXMAP_PRINT       "Print"
#define GNOME_STOCK_PIXMAP_SEARCH      "Search"
#define GNOME_STOCK_PIXMAP_BACK        "Back"
#define GNOME_STOCK_PIXMAP_FORWARD     "Forward"
#define GNOME_STOCK_PIXMAP_EXIT        "Exit"


/* The basic pixmap version of an icon. */

#define GNOME_STOCK_PIXMAP_REGULAR     "regular"
#define GNOME_STOCK_PIXMAP_DISABLED    "disabled"
#define GNOME_STOCK_PIXMAP_FOCUSED     "focused"



/* some internal definitions */

typedef struct _GnomeStockPixmapEntryAny     GnomeStockPixmapEntryAny;
typedef struct _GnomeStockPixmapEntryData    GnomeStockPixmapEntryData;
typedef struct _GnomeStockPixmapEntryFile    GnomeStockPixmapEntryFile;
typedef struct _GnomeStockPixmapEntryPath    GnomeStockPixmapEntryPath;
typedef struct _GnomeStockPixmapEntryWidget  GnomeStockPixmapEntryWidget;
typedef union  _GnomeStockPixmapEntry        GnomeStockPixmapEntry;

typedef enum {
        GNOME_STOCK_PIXMAP_TYPE_NONE,
        GNOME_STOCK_PIXMAP_TYPE_DATA,
        GNOME_STOCK_PIXMAP_TYPE_FILE,
        GNOME_STOCK_PIXMAP_TYPE_PATH,
        GNOME_STOCK_PIXMAP_TYPE_WIDGET
#ifdef USE_GDK_IMLIB
	,
	GNOME_STOCK_PIXMAP_TYPE_IMLIB
#endif /* USE_GDK_IMLIB */
} GnomeStockPixmapType;


/* a data entry holds a hardcoded pixmap */
struct _GnomeStockPixmapEntryData {
        GnomeStockPixmapType type;
	int width, height;
        gchar **xpm_data;
};

#ifdef USE_GDK_IMLIB
/* a data entry holds a hardcoded pixmap */
typedef struct _GnomeStockPixmapEntryImlib   GnomeStockPixmapEntryImlib;
struct _GnomeStockPixmapEntryImlib {
        GnomeStockPixmapType type;
	int width, height;
        gchar *rgb_data;
	GdkImlibColor shape;
};
#endif

/* a file entry holds a filename (no path) to the pixamp. this pixmap
   will be seached for using gnome_pixmap_file */
struct _GnomeStockPixmapEntryFile {
        GnomeStockPixmapType type;
	int width, height;
        gchar *filename;
};

/* a path entry holds the complete (absolut) path to the pixmap file */
struct _GnomeStockPixmapEntryPath {
        GnomeStockPixmapType type;
	int width, height;
        gchar *pathname;
};

/* a widget entry holds a GnomeStockPixmapWidget. This kind of icon can be
 * used by a theme to completely change the handling of a stock icon. */
struct _GnomeStockPixmapEntryWidget {
        GnomeStockPixmapType type;
	int width, height;
        GtkWidget *widget;
};

struct _GnomeStockPixmapEntryAny {
        GnomeStockPixmapType type;
	int width, height;
};

union _GnomeStockPixmapEntry {
        GnomeStockPixmapType type;
        GnomeStockPixmapEntryAny any;
        GnomeStockPixmapEntryData data;
        GnomeStockPixmapEntryFile file;
        GnomeStockPixmapEntryPath path;
        GnomeStockPixmapEntryWidget widget;
#ifdef USE_GDK_IMLIB
	GnomeStockPixmapEntryImlib imlib;
#endif /* USE_GDK_IMLIB */ 
};



/* the GnomeStockPixmapWidget */

#define GNOME_STOCK_PIXMAP_WIDGET(obj)         GTK_CHECK_CAST(obj, gnome_stock_pixmap_widget_get_type(), GnomeStockPixmapWidget)
#define GNOME_STOCK_PIXMAP_WIDGET_CLASS(klass) GTK_CHECK_CAST_CLASS(obj, gnome_stock_pixmap_widget_get_type(), GnomeStockPixmapWidget)
#define GNOME_IS_STOCK_PIXMAP_WIDGET(obj)      GTK_CHECK_TYPE(obj, gnome_stock_pixmap_widget_get_type())

typedef struct _GnomeStockPixmapWidget         GnomeStockPixmapWidget;
typedef struct _GnomeStockPixmapWidgetClass    GnomeStockPixmapWidgetClass;

struct _GnomeStockPixmapWidget {
	GtkVBox parent_object;

        char *icon;
	int width, height;      /* needed to answer size_requests even before
			         * a pixmap is loaded/created */
        GtkWidget   *window;    /* needed for style and gdk_pixmap_create... */
        GnomePixmap *pixmap;    /* the pixmap currently shown */
        GnomePixmap *regular, *disabled, *focused;  /* pixmap cache */
};

struct _GnomeStockPixmapWidgetClass {
	GtkVBoxClass parent_class;
};

guint gnome_stock_pixmap_widget_get_type(void);
GtkWidget *gnome_stock_pixmap_widget_new(GtkWidget *window, char *icon);



/* the utility functions */

/* just fetch a pixmap */
/* window isn't needed for pixmap creation but for the style
 * when a disabled icon is automatically created */
GnomePixmap           *gnome_stock_pixmap          (GtkWidget *window,
                                                    char *icon,
                                                    char *subtype);

/* just fetch a GnomeStockPixmapWidget */
GtkWidget             *gnome_stock_pixmap_widget   (GtkWidget *window,
                                                    char *icon);

/* register a pixmap. returns non-zero, if successfull */
gint                   gnome_stock_pixmap_register (char *icon, char *subtype,
                                                    GnomeStockPixmapEntry *entry);

/* change an existing entry. returns non-zero on success */
gint                   gnome_stock_pixmap_change   (char *icon, char *subtype,
                                                    GnomeStockPixmapEntry *entry);

/* check for the existance of an entry. returns the entry if it
   exists, or NULL otherwise */
GnomeStockPixmapEntry *gnome_stock_pixmap_checkfor (char *icon, char *subtype);



/*  buttons  */

#define GNOME_STOCK_BUTTON_OK     "Button_Ok"
#define GNOME_STOCK_BUTTON_CANCEL "Button_Cancel"
#define GNOME_STOCK_BUTTON_YES    "Button_Yes"
#define GNOME_STOCK_BUTTON_NO     "Button_No"
#define GNOME_STOCK_BUTTON_CLOSE  "Button_Exit"
#define GNOME_STOCK_BUTTON_APPLY  "Button_Apply"
#define GNOME_STOCK_BUTTON_HELP   "Button_Help"

/* returns a default button widget for dialogs */
GtkWidget             *gnome_stock_button          (char *type);


/*  menus  */

#define GNOME_STOCK_MENU_NEW      "Menu_New"
#define GNOME_STOCK_MENU_SAVE     "Menu_Save"
#define GNOME_STOCK_MENU_OPEN     "Menu_Open"
#define GNOME_STOCK_MENU_EXIT     "Menu_Exit"
#define GNOME_STOCK_MENU_CUT      "Menu_Cut"
#define GNOME_STOCK_MENU_COPY     "Menu_Copy"
#define GNOME_STOCK_MENU_PASTE    "Menu_Paste"
#define GNOME_STOCK_MENU_PROP     "Menu_Properties"
#define GNOME_STOCK_MENU_ABOUT    "Menu_About"
#define GNOME_STOCK_MENU_SCORES   "Menu_Scores"
#define GNOME_STOCK_MENU_BLANK    "Menu_"

/* returns a GtkMenuItem with an stock icon and text */
GtkWidget             *gnome_stock_menu_item       (char *type, char *text);


END_GNOME_DECLS

#endif /* GNOME_STOCK_H */
