#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>
#include <libintl.h>

#include "gnome.h"
#include "gnome-desktop.h"
#include "gtkpreviewextra.h"

#define _(String) gettext(String)

#define PAD 10

static GtkWidget *frame;
static GtkWidget *monitor;

/* If true, the display is a gradient from color1..color2 */
static int grad = FALSE;

/* Direction of the gradient */
static int vertical = TRUE;

/* The pointers to the color selectors */
static GnomeColorSelector *cs1, *cs2;

void
gtk_widget_show_multi (GtkWidget *first,...)
{
	va_list ap;
	GtkWidget *next;
	
	if (!first)
		return;

	gtk_widget_show (first);
	va_start (ap, first);
	while ((next = va_arg (ap, GtkWidget *)) != 0)
		gtk_widget_show (next);
	va_end (ap);
}

static void
color_changed (gpointer data)
{
}

static void
radio_toggle_widget_active(GtkWidget *widget, gpointer data)
{
	GtkWidget *dest;

	dest = GTK_WIDGET(data);

	gtk_widget_set_sensitive(dest, GTK_TOGGLE_BUTTON(widget)->active);
} /* radio_toggle_widget_active */

GtkWidget *
create_gradient (int width, int height, int r0, int g0, int b0, int r1, int g1, int b1, int vertical)
{
	GtkWidget *preview;
	guchar    *gbuf, *buf;
	guchar    *s, *p;
	int        i, j;
	int        gsize;

	preview = gtk_preview_new(GTK_PREVIEW_COLOR);
	gtk_preview_size(GTK_PREVIEW(preview), width, height);

	if (vertical) {
		gbuf = g_malloc(height * 3 * sizeof(guchar));
		buf  = g_malloc(width * 3 * sizeof(guchar));

		gsize = height;
	} else {
		gbuf = g_malloc(width * 3 * sizeof(guchar));
		buf  = NULL;

		gsize = width;
	}

	/* Fill gradient stripe */

	p = gbuf;

	for (i = 0; i < gsize; i++) {
		*p++ = r0 + i * (r1 - r0) / (gsize - 1);
		*p++ = g0 + i * (g1 - g0) / (gsize - 1);
		*p++ = b0 + i * (b1 - b0) / (gsize - 1);
	}

	/* Fill preview */

	if (vertical) 
		for (i = 0; i < height; i++) {
			s = gbuf + 3 * i;
			p = buf;

			for (j = 0; j < width; j++) {
				*p++ = s[0];
				*p++ = s[1];
				*p++ = s[2];
			}

			gtk_preview_draw_row(GTK_PREVIEW(preview), buf, 0, i, width);
		}
	else
		for (i = 0; i < height; i++)
			gtk_preview_draw_row(GTK_PREVIEW(preview), gbuf, 0, i, width);

	g_free(gbuf);
	g_free(buf);

	return preview;
}

static void
set_gradient (void)
{
	GtkWidget *preview;
	int        r0, g0, b0;
	int        r1, g1, b1;

	gnome_color_selector_get_color_int(cs1, &r0, &g0, &b0, 255);
	gnome_color_selector_get_color_int(cs2, &r1, &g1, &b1, 255);

	preview = create_gradient (157, 111, r0, g0, b0, r1, g1, b1, vertical);
	
	gtk_preview_put_with_offsets (GTK_PREVIEW (preview),
				      GTK_PIXMAP(monitor)->pixmap,
				      monitor->style->black_gc,
				      0, 0,
				      20, 10,
				      157, 111);

	gtk_widget_destroy(preview);
	gtk_widget_draw(monitor, NULL);
}

static void
set_solid (void)
{
	/* FIXME: this is a super-ugly hack! */

	GtkWidget *preview;
	int        r0, g0, b0;
	int        r1, g1, b1;

	gnome_color_selector_get_color_int(cs1, &r0, &g0, &b0, 255);

	preview = create_gradient (157, 111, r0, g0, b0, r0, g0, b0, vertical);
	
	gtk_preview_put_with_offsets (GTK_PREVIEW (preview),
				      GTK_PIXMAP(monitor)->pixmap,
				      monitor->style->black_gc,
				      0, 0,
				      20, 10,
				      157, 111);

	gtk_widget_destroy(preview);
	gtk_widget_draw(monitor, NULL);
}

static void
fill_monitor (void)
{
	if (!grad)
		set_solid ();
	else
		set_gradient();
}

static void
set_background_mode (GtkWidget *widget, gpointer data)
{
	grad = (int) ((long) data);

	fill_monitor();
}

static void
set_orientation (GtkWidget *widget, gpointer data)
{
	vertical = (int) ((long) data);

	fill_monitor();
}

GtkWidget *
color_setup ()
{
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *radio1;
	GtkWidget *radio2;
	GdkColor  color1, color2;
	
	frame = gtk_frame_new(_("Color"));
	gtk_widget_show(frame);

	table = gtk_table_new(4, 2, FALSE);
	gtk_container_border_width(GTK_CONTAINER(table), 4);
	gtk_table_set_row_spacing(GTK_TABLE(table), 1, 6);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 4);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	cs1 = gnome_color_selector_new((SetColorFunc) fill_monitor, NULL);
	gdk_color_parse (gnome_config_get_string ("/Desktop/Background/color1=rgb:00/00/00"), &color1);
	gnome_color_selector_set_color_int (cs1, color1.red, color1.green, color1.blue, 65535);
	
	button1 = gnome_color_selector_get_button(cs1);
	gtk_table_attach(GTK_TABLE(table), button1, 0, 1, 0, 2, 0, 0, 0, 0);
	gtk_widget_show(button1);

	radio1 = gtk_radio_button_new_with_label(NULL, _("Flat"));
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) set_background_mode,
			    (gpointer) ((long) FALSE));
	gtk_table_attach_defaults(GTK_TABLE(table), radio1, 1, 2, 0, 1);
	gtk_widget_show(radio1);

	radio1 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)),
						 _("Gradient"));
	gtk_signal_connect (GTK_OBJECT(radio1), "toggled",
			    (GtkSignalFunc) set_background_mode,
			    (gpointer) ((long) TRUE));
	gtk_table_attach_defaults(GTK_TABLE(table), radio1, 1, 2, 1, 2);
	gtk_widget_show(radio1);

	cs2 = gnome_color_selector_new((SetColorFunc) fill_monitor, NULL);
	gdk_color_parse (gnome_config_get_string ("/Desktop/Background/color2=rgb:00/00/ff"), &color2);
	gnome_color_selector_set_color_int (cs2, color2.red, color2.green, color2.blue, 65535);

	/* fill_monitor(); */

	button2 = gnome_color_selector_get_button(cs2);
	gtk_table_attach(GTK_TABLE(table), button2, 0, 1, 2, 4, 0, 0, 0, 0);
	gtk_widget_set_sensitive(button2, FALSE);
	gtk_widget_show(button2);
	gtk_signal_connect(GTK_OBJECT(radio1), "toggled",
			   (GtkSignalFunc) radio_toggle_widget_active,
			   button2);

	radio2 = gtk_radio_button_new_with_label(NULL, _("Vertical"));
	gtk_signal_connect(GTK_OBJECT(radio2), "toggled",
			   (GtkSignalFunc) set_orientation,
			   (gpointer) ((long) TRUE));
	gtk_table_attach_defaults(GTK_TABLE(table), radio2, 1, 2, 2, 3);
	gtk_widget_set_sensitive(radio2, FALSE);
	gtk_widget_show(radio2);
	gtk_signal_connect(GTK_OBJECT(radio1), "toggled",
			   (GtkSignalFunc) radio_toggle_widget_active,
			   radio2);

	radio2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio2)),
						 _("Horizontal"));
	gtk_signal_connect(GTK_OBJECT(radio2), "toggled",
			   (GtkSignalFunc) set_orientation,
			   (gpointer) ((long) FALSE));
	gtk_table_attach_defaults(GTK_TABLE(table), radio2, 1, 2, 3, 4);
	gtk_widget_set_sensitive(radio2, FALSE);
	gtk_widget_show(radio2);
	gtk_signal_connect(GTK_OBJECT(radio1), "toggled",
			   (GtkSignalFunc) radio_toggle_widget_active,
			   radio2);
	
	return frame;
}

GtkWidget *
wallpaper_setup ()
{
	GtkWidget *wallp;

	wallp = gtk_frame_new (_("Wallpaper"));
	gtk_widget_show (wallp);
	return wallp;
}

int
background_action (GnomePropertyRequest req)
{
	char buffer [60];
	int r, g, b;
	
	if (req != GNOME_PROPERTY_APPLY)
		return 0;

	gnome_color_selector_get_color_int (cs1, &r, &g, &b, 255);
	sprintf (buffer, "rgb:%d/%d/%d", r, g, b);
	gnome_config_set_string ("/Desktop/Background/color1", buffer);
	gnome_color_selector_get_color_int (cs2, &r, &g, &b, 255);
	sprintf (buffer, "rgb:%d/%d/%d", r, g, b);
	gnome_config_set_string ("/Desktop/Background/color2", buffer);
	
	return 1;
}

/*
 * background_setup: creates the dialog box for configuring the
 * display background and registers it with the display property
 * configurator
 */
void
background_setup (GtkWidget *window)
{
	GtkWidget *vbox, *settings;
	GtkWidget *hbox;
	GtkWidget *fill, *wallp;
	
	vbox = gtk_vbox_new (TRUE, 0);

	hbox = gtk_hbox_new (TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER(hbox), 10);

	monitor = get_monitor_preview_widget (window);
	
	gtk_box_pack_start (GTK_BOX(hbox), monitor, FALSE, FALSE, 5);

	gtk_box_pack_start (GTK_BOX (vbox), hbox, 1, 1, 1);
	
	settings = gtk_hbox_new (TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER(settings), 10);
	gtk_box_pack_end (GTK_BOX (vbox), settings, 1, 1, 0);

	fill = color_setup ();
	gtk_box_pack_start (GTK_BOX (settings), fill, 1, 1, PAD);
	
	wallp  = wallpaper_setup ();
	gtk_box_pack_end (GTK_BOX (settings), wallp, 1, 1, PAD);
	
	gtk_widget_show (monitor);
	gtk_widget_show (settings);
	gtk_widget_show (hbox);

        register_extension (gtk_label_new (_("Background")), vbox, background_action);

	gtk_widget_show (vbox);
}
