/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_HOST_H__
#define __GTK_HOST_H__


#include <gdk/gdk.h>
#include <gtk/gtkcontainer.h>
#include <gtktty/gtkled.h>


#ifdef __cplusplus
extern "C" 
#endif /* __cplusplus */


#define GTK_HOST(obj)          (GTK_CHECK_CAST ((obj), gtk_host_get_type (), GtkHost))
#define GTK_HOST_CLASS(klass)  (GTK_CHECK_CLASS_CAST ((klass), gtk_host_get_type (), GtkHostClass))
#define GTK_IS_HOST(obj)       (GTK_CHECK_TYPE ((obj), gtk_host_get_type ()))


typedef struct _GtkHost       GtkHost;
typedef struct _GtkHostClass  GtkHostClass;

struct _GtkHost
{
  GtkContainer container;

  GtkWidget *child;
  GtkWidget *label;
  GtkWidget *pixmapwid;
  GtkWidget *act_led;
  GtkWidget *box;

  guint in_host : 1;
  guint host_down : 1;
};

struct _GtkHostClass
{
  GtkContainerClass parent_class;

  void (* pressed)  (GtkHost *host);
  void (* released) (GtkHost *host);
  void (* clicked)  (GtkHost *host);
  void (* enter)    (GtkHost *host);
  void (* leave)    (GtkHost *host);
};


guint      gtk_host_get_type       (void);
GtkWidget* gtk_host_new            (void);
GtkWidget* gtk_host_new_with_label (const gchar *label);
void       gtk_host_pressed        (GtkHost *button);
void       gtk_host_released       (GtkHost *button);
void       gtk_host_clicked        (GtkHost *button);
void       gtk_host_enter          (GtkHost *button);
void       gtk_host_leave          (GtkHost *button);
void       gtk_host_set_label      (GtkWidget *host, const gchar *label);
void       gtk_host_set_pixmap     (GtkWidget *host, GtkWidget *pixmap);
void       gtk_host_led_toggle     (GtkWidget *host);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_HOST_H__ */
