/*
 * $Id: g_transport.h,v 1.1 1998/07/27 18:42:54 jochen Exp $
 * GXSNMP -- An snmp management application
 * Copyright (C) 1998 Gregory McLean & Jochen Friedrich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Defines and variables for snmp support
 */
#ifndef __G_TRANSPORT_H__
#define __G_TRANSPORT_H__

#include "g_snmp.h"

struct g_transport
  {
     gboolean (*sendMessage) (
                         struct sockaddr *transportAddress,
                         gpointer outgoingMessage,
                         guint outgoingMessageLength);
     void (*receiveMessage) ();
     gboolean (*resolveAddress) (
                         guchar *hostName,
                         struct sockaddr **transportAddress);
     guint    (*getSocket) ();
  };

#endif
