#include <config.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>
#include <gdk_imlib.h>
#include <gdk_imlib_private.h>
#include <gnome.h>
#include <libgnome/gnome-help.h>
#include <gtk/gtk.h>


struct _image
{
   char *file;
   int  num_categories;
   char **categories;
   GtkWidget *thumb;
};

struct _current_image
{
   int           number;
   struct _image *info;
   GdkImlibImage *image;
   GdkPixmap     *pixmap;
   int           width;
   int           height;
   int           mini_width;
   int           mini_height;
   GtkWidget     *mini_area;
   GtkWidget     *mini_view;
   GtkWidget     *mini_redraw;
   GdkPixmap     *mini_pixmap;
};

typedef struct _EEGtkHider
{
   GtkWidget *frame;
   GtkWidget *label;
   GtkWidget *content;
   
   GtkWidget *box;
   GtkWidget *headerbox;
   GtkWidget *hidebutton;
   GtkWidget *hidepixmap;
   GtkWidget *showpixmap;
} EEGtkHider;

void quit_image_cb(GtkWidget *widget, void *data);
void draw_image();
void print_image(GtkWidget *widget, void *data);
void handle_image_resize_cb(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_double(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_halve(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_up(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_down(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_original(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_fit(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_resize_maximize(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_next(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_previous(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_set_desktop(GtkWidget *widget, GdkEventConfigure *event);
void image_open(GtkWidget *widget, GdkEventConfigure *event);
void image_save(GtkWidget *widget, GdkEventConfigure *event);
void image_save_as(GtkWidget *widget, GdkEventConfigure *event);
void start_slideshow(GtkWidget *widget, GdkEventConfigure *event);
void stop_slideshow(GtkWidget *widget, GdkEventConfigure *event);
void handle_image_button_cb(GtkWidget *widget, GdkEventButton *event);
void image_fliph(GtkWidget *widget, GdkEventConfigure *event);
void image_flipv(GtkWidget *widget, GdkEventConfigure *event);
void image_rotate(GtkWidget *widget, GdkEventConfigure *event);
void image_open(GtkWidget *widget, GdkEventConfigure *event);
void image_save(GtkWidget *widget, GdkEventConfigure *event);
void image_save_as(GtkWidget *widget, GdkEventConfigure *event);
void about_image_cb(GtkWidget *widget, void *data);
void init_image();
void show_image_n(int n);
void show_image();
void hide_image();
void draw_crop();
void configure_drop_on_widget(GtkWidget *widget, GdkWindow *window);
void about_image_help_cb(GtkWidget *widget, void *data);

void init_list();
int add_file_to_list(char *file);
int del_file_from_list(char *file);
struct _image *get_file_from_list(char *file);
int get_file_number_from_list(char *file);
struct _image *get_file_n_from_list(int n);
int get_list_length();
void del_file_from_clist(char *file);
void add_file_to_clist(char *file);
void sync_list_to_clist();

void make_icons();
void reset_all_mods();
void quit_edit_cb(GtkWidget *widget, void *data);
void start_edit_cb(GtkWidget *widget, void *data);
void draw_mini_image();
void init_edit();
void show_edit();
void hide_edit();
void update_crop_spins();

void showthumbs(GtkWidget *widget, gpointer *data);
void del_thumb(char *file);
void sel_thumb(char *file);
void add_thumb(char *file);

void show_config(GtkWidget *widget, void *data);

int main(int argc, char **argv);

/* Drag and drop routines */
void drag_begin (GtkWidget *widget, GdkEvent *event);
void init_dnd (void);
void artificial_drag_start (GdkWindow *window, int x, int y);

void          md(char *s);
int           exists(char *s);
int           isfile(char *s);
int           isdir(char *s);
char        **ls(char *dir, int *num);
void          freestrlist(char **l, int num);
void          rm(char *s);
void          mv(char *s, char *ss);
void          cp(char *s, char *ss);
unsigned long moddate(char *s);
int           filesize(char *s);
void          cd(char *s);
char         *cwd(void);
int           permissions(char *s);
int           owner(char *s);
int           group(char *s);
char         *username(int uid);
char         *homedir(int uid);
char         *usershell(int uid);
char         *atword(char *s, int num);
char         *atchar(char *s, char c);
void          word(char *s, int num, char *wd);
int           canread(char *s);
int           canwrite(char *s);
int           canexec(char *s);
char         *fileof(char *s);
char         *fullfileof(char *s);
char         *noext(char *s);
void          mkdirs(char *s);

extern char                   *current_dir;
extern GtkWidget              *window_image;
extern struct _current_image  current;
extern GList                  *image_list;
extern GtkWidget              *menu_main;
extern GtkWidget              *app;
extern GtkWidget              *window_edit;
extern GdkPixmap              *brightness_pmap;
extern GdkPixmap              *brightness_mask;
extern GdkPixmap              *contrast_pmap;
extern GdkPixmap              *contrast_mask;
extern GdkPixmap              *gamma_pmap;
extern GdkPixmap              *gamma_mask;
extern GdkImlibImage          *red_curve;
extern GdkImlibImage          *green_curve;
extern GdkImlibImage          *blue_curve;
extern GdkPixmap              *red_curve_pmap;
extern GdkPixmap              *green_curve_pmap;
extern GdkPixmap              *blue_curve_pmap;
extern GtkWidget              *red_view;
extern GtkWidget              *green_view;
extern GtkWidget              *blue_view;
extern GtkObject              *adjusters[12];
extern GtkWidget              *sliders[12];
extern char                   autoapply;
#ifdef GTK_HAVE_FEATURES_1_1_0
extern GtkAccelGroup          *image_accel;
extern GtkAccelGroup          *edit_accel;
#else
extern GtkAcceleratorTable    *image_accel;
extern GtkAcceleratorTable    *edit_accel;
#define gtk_accel_group_add(at,key,mods,dummy,widget,signal) \
         (gtk_accelerator_table_install(at,widget,signal,key,mods))
#endif
extern GtkWidget              *tips;
extern GtkWidget              *list;
extern char                   mods_changed;
extern char                   in_init;
extern guint                  slide_timer;
extern guint32                silde_speed;
extern int                    num_categories;
extern char                   **categories;
extern char                   fixed_aspect;
extern char                   correcting_aspect;
extern GtkObject              *width_adj,*height_adj;
extern GtkWidget              *width_wid,*height_wid;
extern GtkObject              *cropx_adj,*cropy_adj,*cropw_adj,*croph_adj;
extern GtkWidget              *cropx_wid,*cropy_wid,*cropw_wid,*croph_wid;
extern char                   mod_width,mod_height;
extern char                   mod_cx,mod_cy,mod_cw,mod_ch;
extern char                   incrop,cstart;
extern int                    crop_x,crop_y,crop_w,crop_h;
extern int                    thumb_w,thumb_h;
extern GtkWidget              *window_thumbs;
extern GtkWidget              *thumbs_box;
extern GtkWidget              *fsel;
extern char                   loadsave;
extern unsigned char          unknown[];
extern GtkWidget              *aboutwin;
extern GtkWidget              *window_config;
extern char                   keepsize;
