#include <gtk/gtk.h>
#include <string.h>
#include "libgnome/gnome-defs.h"
#include "gnome-properties.h"
#include "gnome-actionarea.h"

GnomePropertyConfigurator *
gnome_property_configurator_new (void)
{
	GnomePropertyConfigurator *this = g_malloc (sizeof (GnomePropertyConfigurator));
	GtkWidget *notebook;

	notebook = gtk_notebook_new ();

	this->props = NULL;
	
	this->notebook = notebook;

	return this;
}

void
gnome_property_configurator_destroy (GnomePropertyConfigurator *this)
{
	gtk_widget_destroy (this->notebook);
	g_list_free (this->props);
}



void
gnome_property_configurator_register (GnomePropertyConfigurator *this,
				      GtkWidget *title_widget, GtkWidget *content_widget,
				      int (*callback)(GnomePropertyRequest))
{
	// printf ("adding %x\n", callback);
	this->props = g_list_append (this->props, callback);

	gtk_notebook_append_page (GTK_NOTEBOOK (this->notebook), content_widget, title_widget);

	gtk_widget_show (content_widget);
	gtk_widget_show (title_widget);
}

gint
gnome_property_configurator_request (GnomePropertyConfigurator *th,
				     GnomePropertyRequest r)
{
	int (*cb)(GnomePropertyRequest);

	cb = (int (*)(GnomePropertyRequest))
		(g_list_nth
		 (th->props,
		  gtk_notebook_current_page (GTK_NOTEBOOK (th->notebook)))->data);


	// printf ("request %d %x\n", gtk_notebook_current_page (th->notebook), cb);

	if (cb)
		return (*cb) (r);
	else
		return 0;
}
