/*
 * GNOME panel mail check module.
 * (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza
 *
 * Exported interfaces to the GNOME Panel
 */

#include <stdio.h>
#include <libintl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include "gnome.h"
#include "../applet.h"

static char *mail_file;

/* If set, the user has launched the mail viewer */
int mailcleared;

/* Does the user have any mail at all? */
int anymail;

/* New mail has arrived? */
int newmail;

/* Does the user have unread mail? */
int unreadmail;

/* The widget that holds the label with the mail information */
GtkWidget *label;

/* handle for the timeout */
int mail_timeout;

GtkWidget *pixmap_container;

char *
query (void)
{
	return "Mail check";
}

/*
 * Get file modification time, based upon the code
 * of Byron C. Darrah for coolmail and reused on fvwm95
 */
void
check_mail_file_status ()
{
	static off_t oldsize = 0;
	struct stat s;
	off_t newsize;
	int status;

	status = stat (mail_file, &s);
	if (status < 0){
		oldsize = 0;
		anymail = newmail = unreadmail = 0;
		return;
	}
	
	newsize = s.st_size;
	anymail = newsize > 0;
	unreadmail = (s.st_mtime >= s.st_atime && newsize > 0);

	if (newsize >= oldsize && unreadmail){
		newmail = 1;
		mailcleared = 0;
	} else
		newmail = 0;
	oldsize = newsize;
}

int
mail_check_timeout (void *data)
{
	char *text;

#define UG "This is a test -> "
	check_mail_file_status ();
	if (anymail)
		text = g_copy_strings (UG "You have ", newmail ? "new" : "", " mail", NULL);
	else
		text = g_copy_strings (UG "No mail.", NULL);
	gtk_label_set (GTK_LABEL (label), text);
	free (text);
}

GtkWidget *
create_mail_widgets (GtkWidget *window)
{
	label = gtk_label_new ("");
	mail_check_timeout (0);
	gtk_widget_show (label);
	mail_timeout = gtk_timeout_add (10000, mail_check_timeout, 0);
	return label;
}

void
init (PanelCallback callback, Panel *panel, char *params, int xpos, int ypos)
{
	PanelCommand cmd;
	GtkWidget *mailcheck;

	/* Only allow one instance of this module */
	if (mail_file)
		return;
	
	mail_file = getenv ("MAIL");
	if (!mail_file)
		return;

	mailcheck = create_mail_widgets (panel->window);
	cmd.cmd = PANEL_CMD_REGISTER_TOY;
	cmd.params.register_toy.applet = mailcheck;
	cmd.params.register_toy.xpos   = xpos;
	cmd.params.register_toy.ypos   = ypos;
	cmd.params.register_toy.flags  = 0;

	(*callback) (panel, &cmd);
}
